-- MySQL dump 10.13  Distrib 8.0.41, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.0.42

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'OO0Sojci8WslGGSOc4hzadD824yQL699',1,'2025-05-03 11:32:10','2025-05-03 11:32:10','2025-05-03 11:32:10');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-05-03 11:33:04',NULL,1,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-05-03 11:33:04',NULL,1,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-05-03 11:33:04',NULL,1,'2025-05-03 11:33:04','2025-05-03 11:33:04');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Quos quis corporis aut sint esse. Excepturi et aliquam aliquid harum labore. Mollitia nihil consequatur quis corrupti vel qui. Sunt sapiente alias sint.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-05-03 11:32:33','2025-05-03 11:32:33'),(2,'Leadership &amp; Strategy',0,'Consequatur dolor aut nemo aperiam nam voluptatem. Quis ut et illo quis et omnis cupiditate sed. Et minus eligendi qui natus qui. Fugit perferendis est minus sit harum et dolore ipsum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-05-03 11:32:33','2025-05-03 11:32:33'),(3,'Networking &amp; Collaboration',0,'In et id omnis enim dolorum aspernatur est. Quis alias perspiciatis aut eum est non est est. Beatae dolor nihil officia.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-05-03 11:32:33','2025-05-03 11:32:33'),(4,'Entrepreneurship Startups',0,'Veritatis soluta eos omnis beatae hic. Harum molestiae possimus dolor nulla. Sed rem neque magni minima optio dolore. Nemo voluptatem a qui quis repudiandae voluptatem.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-05-03 11:32:33','2025-05-03 11:32:33'),(5,'Marketing &amp; Branding',0,'Pariatur non explicabo vel saepe. Inventore sit sunt distinctio excepturi labore quas ducimus. Quia voluptatem temporibus dignissimos dolorum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-05-03 11:32:33','2025-05-03 11:32:33'),(6,'Event Highlights &amp; Recaps',0,'Numquam nisi magni aliquam qui aut. Ut quas dicta minima cupiditate. Recusandae laudantium eveniet sequi. Autem nihil quidem voluptatem fugit non.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-05-03 11:32:33','2025-05-03 11:32:33');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Tremayne Wyman I','doreilly@example.com','1-802-633-3017','54607 Adelbert Tunnel\nNew Danny, LA 14319-7219','In beatae eos et et iusto tenetur.','Dicta delectus est sint provident suscipit. Corporis qui error perspiciatis quis earum molestiae. Iure quia tempore omnis eligendi. Sunt dolorum officiis nam tempora. Temporibus molestiae quis sit porro saepe tempore rerum. Corrupti officia sint voluptas aliquam rem inventore. Ducimus praesentium est laborum ut inventore maxime tenetur. Voluptatibus magnam ut sit quis deserunt reprehenderit quia. Aut temporibus voluptatum tempore modi sunt aliquid. Voluptas quae ullam quam minus aliquid fugit.',NULL,'unread','2025-05-03 11:32:10','2025-05-03 11:32:10'),(2,'Miss Rachelle Douglas I','marquardt.rosamond@example.org','516-901-7342','6493 Parker Spring\nKshlerintown, ME 27655-9311','Qui aliquid odit facere possimus illum minus.','Ratione vel blanditiis aut eum iure. Unde dolorem placeat qui est sequi corporis hic. Consectetur sunt dolores est consectetur esse natus quas. Et ab numquam voluptate officia facilis. Iste unde ab aut laborum possimus. Quia aliquam et eos soluta quis. In velit quis sed suscipit. Aliquam voluptatem possimus impedit. Quas dolore enim quia cupiditate doloribus sed deserunt voluptatibus. Placeat suscipit et repellat modi dolor repellendus iusto voluptas.',NULL,'read','2025-05-03 11:32:10','2025-05-03 11:32:10'),(3,'Bernadette Schmitt','roberts.madge@example.com','479.700.2860','7654 Mack Trail Apt. 548\nNew Alfonso, MI 83933','Aut molestiae sed quia qui fugiat.','Optio fuga pariatur sit quia rerum repellat est. Corporis facere aperiam et aut ea. Magnam consequatur repudiandae soluta cum. Corrupti architecto praesentium facilis est. Consequatur sapiente et dolores aliquid in. Voluptatum cum libero officiis pariatur. Non in ullam atque voluptate sint officia. Molestiae voluptas quo qui aliquam quam et. Mollitia reprehenderit est omnis quis. Aperiam voluptatem nisi qui consectetur. Amet voluptatem placeat sit commodi qui. Quis sit provident eum et.',NULL,'read','2025-05-03 11:32:10','2025-05-03 11:32:10'),(4,'Benny Osinski','walton25@example.org','810.635.6332','23664 Swift Rapids Apt. 386\nFabiolamouth, TN 01453-3755','Sunt unde fugiat voluptas quia minima.','Ratione vitae eum velit numquam adipisci temporibus iusto. Sunt laudantium dolorum voluptates ad in voluptatem. Sed eius quo praesentium aliquam. Vel provident impedit rerum dolor est qui vero. Consequatur et quia et praesentium. Possimus nostrum qui et est cum ipsum perspiciatis rerum. Sed facilis ut laudantium quod quam dolorem et. Quis id totam quia doloremque dolorem illo.',NULL,'read','2025-05-03 11:32:10','2025-05-03 11:32:10'),(5,'Juvenal Johnston PhD','hodkiewicz.bennett@example.org','(385) 962-4466','36893 Constantin Knolls Apt. 406\nProvidencifurt, ME 43816-6021','Excepturi et cum qui.','Repellat accusantium magnam dignissimos dolorum non. Officia minus officia voluptatem quis voluptatum. Voluptas accusantium voluptatem totam minima saepe. Odit qui blanditiis repellat aut sunt quo tempore. Aut qui nam nesciunt maiores illum maxime. Architecto architecto et aliquam odio quia officiis. Est harum corporis eum sit iste est. In amet eveniet modi veritatis amet cum. Officia aperiam mollitia omnis soluta sequi dolor consequuntur.',NULL,'unread','2025-05-03 11:32:10','2025-05-03 11:32:10'),(6,'Lori Stehr','nienow.vicente@example.com','1-386-428-8692','3015 Parisian Street Suite 071\nWest Yasmeenhaven, NY 25144-6743','Repudiandae culpa sed dolorem omnis.','Enim dolores dignissimos unde impedit esse qui qui ab. Dolor sit ut qui natus sit. Facere provident distinctio recusandae quidem. Mollitia nemo id ipsum quos adipisci sunt recusandae. Tenetur iusto nesciunt ducimus ut sunt suscipit. Aut voluptatem magni quaerat dolor velit reiciendis et. Asperiores saepe minus occaecati dolore eum. Excepturi aut est earum corporis nemo eos. Sapiente perspiciatis aliquid quam iste.',NULL,'read','2025-05-03 11:32:10','2025-05-03 11:32:10'),(7,'Joshua Sipes','chodkiewicz@example.org','806-650-5389','80202 Bergnaum Club\nWest Kristoffer, OH 31895','Quidem sit architecto vel.','Minus laudantium itaque sed ut. Earum veniam enim odio assumenda veniam id doloremque. Ut laboriosam perferendis fugiat id quae. Accusamus nostrum corporis doloribus et molestias natus. Voluptas dolorem praesentium aperiam sunt recusandae. Ut consequatur laboriosam fugit est. Voluptatem perspiciatis et consectetur dolores. Sapiente dolorum aut vel eum. Id minus et unde alias. Culpa dolores laborum ut aperiam. Qui error neque rerum incidunt. Itaque ex sed nobis rerum.',NULL,'read','2025-05-03 11:32:10','2025-05-03 11:32:10'),(8,'Mrs. Aubree Heidenreich III','marcella.block@example.org','332.735.1016','3377 Albina Lodge\nSouth Zora, AR 02211-7209','Quisquam iure quas ullam repellat eius.','Hic ut dolor autem omnis sint incidunt neque. Atque tenetur laudantium earum nemo. Eaque soluta tenetur molestiae eos vel quasi. Accusamus doloribus error eum ad. Perferendis reiciendis architecto sint accusantium molestias. Alias voluptas necessitatibus aspernatur. Eos quidem sed est quam iusto enim et. Numquam et vitae modi repudiandae incidunt vel.',NULL,'unread','2025-05-03 11:32:10','2025-05-03 11:32:10'),(9,'Dr. Margarita Swaniawski','dpfeffer@example.net','+18102654687','94095 Celestine Spring\nPort Thurmanland, AZ 26146-2648','Ea nihil est tenetur unde.','Voluptas sunt est fugiat ut ipsam. Incidunt ducimus et cupiditate et ducimus. Deserunt ea voluptas qui maxime. Quidem facere odit rem unde. Architecto eos est tempora aut aliquid rerum consectetur. Et debitis eligendi explicabo porro quo ea perferendis et. Mollitia velit soluta error dicta quo beatae dignissimos tenetur. Alias in velit possimus et soluta. Eum est molestiae hic quo laborum itaque.',NULL,'read','2025-05-03 11:32:10','2025-05-03 11:32:10'),(10,'Meredith Kutch','ezequiel.dietrich@example.com','+1 (283) 247-9406','457 Ward Lights Suite 820\nNyasiaville, TN 69494-5046','Sint rerum iusto porro aut.','Est consectetur harum eligendi aut quo sunt sunt. Voluptatibus itaque reiciendis ullam voluptatem rerum nisi aut neque. Voluptatem maxime porro quo repellat dolorem animi velit porro. Ea sint nam necessitatibus quisquam vitae voluptatem illum. Est tenetur occaecati iure autem ea error. Id sit in voluptatem cupiditate a molestiae. Doloribus accusamus laborum officiis quia ut saepe consequatur. Voluptatum veniam quas est id.',NULL,'read','2025-05-03 11:32:10','2025-05-03 11:32:10');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-05-03 11:32:44',NULL,'FRA'),(2,'England','English',0,0,'published','2025-05-03 11:32:44',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-05-03 11:32:44',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-05-03 11:32:44',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-05-03 11:32:44',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-05-03 11:32:44',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Laisha Bednar','customer@archielite.com','$2y$12$EsAwVkw6nik7pDuk29ZDeOPDg/y9kMTsBzxtH7884VRDeY6hF3bHS',NULL,'0242674438','2018-06-03','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:38','2025-05-03 11:32:38'),(2,'Michael Smith','chad.wisozk@walker.com','$2y$12$YPROXvTnvzEq5uScH.B4oexy28bBL39Wx1fNLASCE8GBsjwTiiJoK','main/speakers/1.png','0403545718','2009-08-27','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:38','2025-05-03 11:32:38'),(3,'Shayna Casper','clint.goodwin@hartmann.com','$2y$12$E6eYUmgoNgHimhI0mwD0qeDfslSt2n8u6Sml8krACkEovUXy7akf.','main/speakers/5.png','0363108541','1999-09-04','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:39','2025-05-03 11:32:39'),(4,'Daphne Schinner','brody.armstrong@robel.com','$2y$12$fjEJcU1MttbvRs09xM1Am.GMA2wN8I9ayb0b7Ai4snTclqLYKYJjy','main/speakers/6.png','0026972777','2009-01-25','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:39','2025-05-03 11:32:39'),(5,'Mr. Ward Wiza','narciso.greenholt@hotmail.com','$2y$12$/p8Y2UHjX8vUEnZsTTy9ZuZHWSZkcdzoaDXfc7Ju9JfKdxDHtY13C','main/speakers/5.png','0257287827','2013-11-26','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:39','2025-05-03 11:32:39'),(6,'Toney Schinner IV','nrowe@gmail.com','$2y$12$Yz34KIc7yTwKLHv/CO1w8unI4YluGrsFT5TBiU91J0vX.sflxluYq',NULL,'0657353528','1996-09-03','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:39','2025-05-03 11:32:39'),(7,'Mrs. Pink Bahringer','linda.pfannerstill@zboncak.org','$2y$12$eItReRRQhG7SteJaiDOK9.2ws/9ZWflgKHg6NDBtZ5DgM..xZdnii','main/speakers/3.png','0131855330','2022-11-21','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:39','2025-05-03 11:32:39'),(8,'Afton Feeney II','funk.zachariah@gmail.com','$2y$12$8i1HiSs4E/L8R8WSTD.os.9GQkWdJz7ei27H3kclZJ6uv9vSPtJH2','main/speakers/2.png','0465710385','2011-08-16','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:40','2025-05-03 11:32:40'),(9,'Orville Heaney PhD','beer.agustina@treutel.biz','$2y$12$lelPn.5ZYgWMGUCe1d87ZegoeWnrnXCovMG4SpRGYE0y43Ues32k6','main/speakers/9.png','0837704676','2006-08-05','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:40','2025-05-03 11:32:40'),(10,'Prof. Osvaldo Sanford','anastasia64@langworth.com','$2y$12$Exj/kwcUj9rmqRnhU/qCdOgs9gydWMNRWg4WBmmcsFE8i/9S/NRzq','main/speakers/1.png','0418447551','2023-01-03','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:40','2025-05-03 11:32:40'),(11,'Emmitt Gislason','erna78@gmail.com','$2y$12$5A/MwL5iDSxwcqfm2152/OWDyB1nasm62CmS0u4zyZ/Wo06c4jWky',NULL,'0827396801','2015-04-16','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:40','2025-05-03 11:32:40'),(12,'Dr. Alvis Mills PhD','pansy.batz@jones.com','$2y$12$G3rHtv77Pm5fQZkvYAluIeRoWG0.d7KC6bkqPNZiQL3kr6afgHDEq','main/speakers/6.png','0850442702','2009-07-21','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:40','2025-05-03 11:32:40'),(13,'Dr. Kolby Jacobs V','maryam.sipes@haag.com','$2y$12$058V2DB1CCFFfqI0ZA2q1.cupxP9VxLDrHwczmq.impoJvk4b9geq','main/speakers/3.png','0716226861','1999-04-28','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:41','2025-05-03 11:32:41'),(14,'Willie Anderson','pete13@adams.com','$2y$12$qXJTvj2d7gg0wP2FASxGMOSPzhHfDCISIyOm3.fbcUtqqNLa3Ull.','main/speakers/10.png','0804498288','2001-12-10','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:41','2025-05-03 11:32:41'),(15,'Marietta Beatty PhD','hprohaska@gmail.com','$2y$12$xF0/D/qGvckL8I9Gabi3H.uXToDfx7TG/5BWwrBhPgSOHNYdzbGQC',NULL,'0979567529','1998-08-31','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:41','2025-05-03 11:32:41'),(16,'Mr. Vincent Halvorson V','gmarvin@damore.com','$2y$12$/4cRvL7et/.zJ1vfkCBcleM9VFR1RNyFSrkLVldbHjaYTx2WFYIie',NULL,'0652370726','2017-01-24','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:41','2025-05-03 11:32:41'),(17,'Weston Olson','ckilback@bednar.net','$2y$12$wS3ngsTeWjTQ8dYXci5O3eUbfbjai0um.O4tvQDeHBdHnnVJ9PWtW','main/speakers/5.png','0231815585','2015-01-05','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:41','2025-05-03 11:32:41'),(18,'Mr. Waldo Sporer V','purdy.velva@schmeler.com','$2y$12$Ivx1VziDNh9t3ByGUJD7s.nds5d/xZR3WkaNBexUnx8DV6aKX8PUG',NULL,'0331329065','1996-10-05','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:42','2025-05-03 11:32:42'),(19,'Ally Bayer II','upton.mia@larson.net','$2y$12$F5Kz.Edlu/XXY.lJcoChX.GOn5UuEgYie0A.HMjvUuUAiIuO2bsyC','main/speakers/4.png','0046756316','2006-07-04','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:42','2025-05-03 11:32:42'),(20,'Arturo Boyle II','bbartell@gmail.com','$2y$12$r4SGI/1bmirmrK5qaUrKROT4PYRhePJrh28S2fRofYqBOVntnnAPe',NULL,'0468286496','2000-05-24','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:42','2025-05-03 11:32:42'),(21,'Mr. Rafael Yost DVM','olin.walsh@hotmail.com','$2y$12$jl2LYn8JDSa9w02mMj6W5uongaTbpTmnb8rQAMeCNrdF01YC3LFae','main/speakers/7.png','0256530591','2019-09-18','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:42','2025-05-03 11:32:42'),(22,'Ms. Herta Morar I','oblock@gmail.com','$2y$12$mSOOb31DfoEF65TkQ3WdRenUYgGtQPkUl4u..DvJ2lt69uyUFaJvi','main/speakers/7.png','0103777013','2023-10-31','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:42','2025-05-03 11:32:42'),(23,'Joannie Upton','lindgren.bridie@kilback.info','$2y$12$H4nXJymdHoJJHrzNiKfZaO4QV7JQyX.HYHscQyJqWxTgOSzr3wEa.','main/speakers/7.png','0936214514','2010-12-25','organizer','activated',NULL,NULL,NULL,'2025-05-03 11:32:42','2025-05-03 11:32:43'),(24,'Eino Kautzer','heller.agustina@yahoo.com','$2y$12$fHmD0fytu5Be7Ta2tShF6OW/QhKV0EL9mO8wnSKJfixjnArLU6QB6','main/speakers/5.png','0870769512','2017-11-05','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:43','2025-05-03 11:32:43'),(25,'Santa Boehm','tstroman@gmail.com','$2y$12$zvUWKRktHkzQLLRKBZcyYumSFaGMbmk/.7FdDBjH6yPKnQZPcFDoC',NULL,'0106517406','2013-01-25','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:43','2025-05-03 11:32:43'),(26,'Miss Lottie Turcotte Jr.','claudine.friesen@gmail.com','$2y$12$HgwYPnpujxUSm/12jlzpU.VYk1qlg3328LDGhMOr6rUZxto/QwgIW','main/speakers/3.png','0385195359','2019-08-01','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:43','2025-05-03 11:32:43'),(27,'Santiago Jaskolski','terrell50@kshlerin.com','$2y$12$7JAkJtiC3lXBWw4gBuGDMetg2MAb4kiTTkA/1kG8e2HtmlGhgjXYu','main/speakers/3.png','0177217134','2023-05-16','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:43','2025-05-03 11:32:43'),(28,'Prof. Arely Koch','johnson.mona@turner.biz','$2y$12$ncv1Kx7.mwD7dkFs/qaYNeZYHNpLAJ5A./uQCm4VYaFsD3q7v0YIG',NULL,'0377799673','1997-09-03','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:43','2025-05-03 11:32:43'),(29,'Evie Jakubowski','ohoeger@hodkiewicz.com','$2y$12$rqS9ESQpeFgxS5UKBYV96ewcz6NjDLD2tpQC5HA8BFPKbrqVc8I5u','main/speakers/5.png','0969705012','1998-03-01','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:44','2025-05-03 11:32:44'),(30,'Bo Pagac','prath@lang.com','$2y$12$vpTJr0djXwG50ioa6Zy/EuUVTNX48O5GndJ7o/.BE705X6QRCIvyq','main/speakers/3.png','0698817890','2012-01-28','speaker','activated',NULL,NULL,NULL,'2025-05-03 11:32:44','2025-05-03 11:32:44'),(31,'Aracely Hammes Sr.','reichel.larissa@hotmail.com','$2y$12$SlmGMWnqb.5gYevlOLPKMu5EkQQ2tzfR.KsH9cmHzJxQ4KQUTaNVG',NULL,'0454948823','2002-03-30','attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:44','2025-05-03 11:32:44'),(32,'Manuela Hartmann','bogan.barton@hotmail.com','$2y$12$CssjjQFweJQOdd4aBKYYBOvT.s.dUxv5wYD1awnrrtT1Gvu0BEb.W',NULL,'0981683077',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:57','2025-05-03 11:32:57'),(33,'Marianna Skiles','ofadel@gmail.com','$2y$12$ZGyJ.fTf.13dwehP7LDEF.CDCjmq.UndhZ7XfkVmDEWxkgF3s/10G',NULL,'0371754197',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:57','2025-05-03 11:32:57'),(34,'Mrs. Margot Schimmel','bauch.richmond@gmail.com','$2y$12$O/eZUT6sBqK.l2kzQQ56H.TScI3pfy67986WUZ6ftpRLfGOp3lErO',NULL,'0775793637',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:57','2025-05-03 11:32:57'),(35,'Tina Wolf','laverna71@beer.com','$2y$12$N77f4gisWiwzvY3w4uOsR.Ca/vjGfebEaZoOOD15xlwAIsauOo3KO',NULL,'0227619369',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:57','2025-05-03 11:32:57'),(36,'Piper Thiel','auer.tiara@gmail.com','$2y$12$Az2kz1ABAr96O6zvRgjBBejZtoVqdPf/wHj9umxQNPs.phLLXI6Oa',NULL,'0527914047',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:57','2025-05-03 11:32:57'),(37,'Mrs. Myrna Sanford Sr.','don.jacobi@hilpert.com','$2y$12$/W8VQwlfauP2w5VnPzq6oOOkHekwsefJpfQN1k138MdYdUxnOhiw.',NULL,'0517449400',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:57','2025-05-03 11:32:57'),(38,'Monserrat Johns','janelle27@yahoo.com','$2y$12$WTUgapHErx/VPVInO/BNN.1.0c96SLqfvY24qlF.Xs/ZsJmfUXi.C',NULL,'0208644339',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:58','2025-05-03 11:32:58'),(39,'Prof. Ernesto Watsica MD','glenda.okuneva@yahoo.com','$2y$12$7VKdAdrVfncNYaEB3oNww.ZDb14qUlcsBrcACnNazKwwqm4vsajn6',NULL,'0057364481',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:58','2025-05-03 11:32:58'),(40,'Sister Deckow','zbrown@watsica.net','$2y$12$QZMH//7B51VhJ541xaxHFuOGXVhGySNkyQnYuVuAGCPyoyYLy5Mzy',NULL,'0105755728',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:58','2025-05-03 11:32:58'),(41,'Milford Upton','rubie.lang@yahoo.com','$2y$12$/7.WP3yZ.NoAxH4kxC4Hb.JTBlEfycIJxPcmgpYdCypvdOoPb5p4W',NULL,'0877134479',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:58','2025-05-03 11:32:58'),(42,'Florine Schinner','vschuster@jakubowski.com','$2y$12$TxyYzGj8nMIyJzOLchc.ieEqWvwc0PhkwLU6gF3CwRDsLgiu3QVga',NULL,'0492635979',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:58','2025-05-03 11:32:58'),(43,'Josephine Kuvalis Sr.','kira68@stroman.org','$2y$12$k3fSpfn2sOjTtFRT0yOuoOsDBLi1bIRuSEuZlXdLxVzo/29mtqlYm',NULL,'0318985928',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:58','2025-05-03 11:32:58'),(44,'Alvena Torphy','karson63@yahoo.com','$2y$12$suIIjxHVjtNPElsMR/Y5Z.X02Hr5oL9hJ7uDG2Xc.IMjYqQV3svQ.',NULL,'0809120644',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:59','2025-05-03 11:32:59'),(45,'Javonte Quitzon','mcclure.jana@hotmail.com','$2y$12$60EB4q/l.wqA8ZvTrrvJFe.3BN4UXgElqswecjCU2m17Eb5ri7iq2',NULL,'0521183695',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:59','2025-05-03 11:32:59'),(46,'Mitchell Bailey','derek95@hotmail.com','$2y$12$eRzq/NNu2Rj1L0HSt3vhLurxxoS58IwKfBXVTAO0t0XDUBa6rg7ci',NULL,'0814043860',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:59','2025-05-03 11:32:59'),(47,'Mr. Ryder Wiza DVM','jarred27@abbott.info','$2y$12$PzIdTG7LuQ3m5FB4NUqmiOn8Sr3aa7E7OSKpSXCuYXF8wqtlAvNaa',NULL,'0593553424',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:59','2025-05-03 11:32:59'),(48,'Jonas Leuschke','margaretta99@gmail.com','$2y$12$DiqDzNhAgDMH/uVTOZ8NZ.JaqE6FFzuVUjjZEcYBr9uaSnCP5p5Uu',NULL,'0353519300',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:59','2025-05-03 11:32:59'),(49,'Queenie Marks','heath46@mosciski.biz','$2y$12$YZMGbNks/V3u3aZOJK8xDukT1.yiGcNCjw.l53MRrOnUAEJ8f6CHe',NULL,'0342366135',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:59','2025-05-03 11:32:59'),(50,'Alva Kemmer','lueilwitz.harmony@morissette.com','$2y$12$FJNEO7/KTbWSbNa2Q01ZE./SStxOxjoJ1bbtHUTWJfkwWazwS7iyi',NULL,'0387684014',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:32:59','2025-05-03 11:32:59'),(51,'Robyn Kling','cornell49@kuhlman.com','$2y$12$jPNmFYhDk/cTrrdojA.tGegJZuQ89F.vGhTjrEgyC/JnHnnYO1Ef6',NULL,'0415501271',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:00','2025-05-03 11:33:00'),(52,'Briana Fadel','lori.stroman@gmail.com','$2y$12$S1wXKrhANukO5QtmRGNqTedSPJ71YK4.9njdcRiAypgL0alytVUyu',NULL,'0297908032',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:00','2025-05-03 11:33:00'),(53,'Alden McDermott','herman.berta@grady.com','$2y$12$AaQZyUCS5rQgsXCd8vknC.NHxJt3VHcFs93CdLQeQRk4zjh6pXRhe',NULL,'0476131728',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:00','2025-05-03 11:33:00'),(54,'Mrs. Ernestina McClure Jr.','kohler.mose@gmail.com','$2y$12$I608LZa1Iz14s48w8UN4xOYOeN9JhSzUHM8dGW35/lrZ8odGHMp3S',NULL,'0283671016',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:00','2025-05-03 11:33:00'),(55,'Emerald Franecki','calista27@bechtelar.org','$2y$12$4sdj2NbG7yiSdnKA.8lukuG0D8CPoJ87Nv9YycqLJt0kUEpvs3ro.',NULL,'0325392709',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:00','2025-05-03 11:33:00'),(56,'Dayna Zemlak','juston03@weber.net','$2y$12$fP2W1YoSPS915O119TagbeCxowRDdas6AmkB6hCuWUbazG7LWzafa',NULL,'0172780718',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:00','2025-05-03 11:33:00'),(57,'Odessa West','manuela92@hermann.com','$2y$12$uAzk7IU7lPiB0xXOPTmN6OdRe033mwth/93qykrXDnS13VkJMjhH.',NULL,'0605976537',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:01','2025-05-03 11:33:01'),(58,'Sydnie Jerde','lesley.kirlin@hotmail.com','$2y$12$JDWZauISDCWnbCw2fy1IO.YH.HgzM3juTfC4yL6wiLHERyTdWa3A.',NULL,'0862591588',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:01','2025-05-03 11:33:01'),(59,'Mr. Chandler Berge Jr.','zhand@walsh.info','$2y$12$.n1Q4pemUjwad1v0INrbP.ENXFlb65HuytdrdMU5KeDEoWsbr6DUS',NULL,'0385331734',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:01','2025-05-03 11:33:01'),(60,'Uriel Crona','hwilderman@gmail.com','$2y$12$AE87EJAs9fMAUqSN4bFmfuaBROEejhc3HWc2poQfymh031oUxUXr2',NULL,'0174716375',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:01','2025-05-03 11:33:01'),(61,'Mrs. Carrie Volkman','jazlyn.bergnaum@ryan.com','$2y$12$MmRjfq9vpccUigksieNKQezx09LXEGdcuQdoquYvEjiB.d4LGQOYu',NULL,'0458256921',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:01','2025-05-03 11:33:01'),(62,'Sydnee Cruickshank','zheller@glover.com','$2y$12$24SF3VsZNheQPnEH55sgYeNqzZ04L3tj/RMeosvVc9FR1D17FmCRG',NULL,'0723403773',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:01','2025-05-03 11:33:01'),(63,'Leanna Windler Sr.','mccullough.myrtice@gmail.com','$2y$12$pHkmCFNjqB.e4TM00ibgsOzVi4uX7RA3lVV1.e2FZIknOB83RFU7q',NULL,'0867297047',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:01','2025-05-03 11:33:01'),(64,'Cristian Feest','agnes.erdman@bruen.com','$2y$12$dBXPdqHIaxH6riT5lV9A1epMd6lk9UE8gSpNNX9j5Z/oPlEiGEia2',NULL,'0999295246',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:02','2025-05-03 11:33:02'),(65,'Kip Rempel','eharber@yahoo.com','$2y$12$0SR.9WNyW3iE8l4ZmJBzsOrtSoX76Qb9RHQM3AObTXerge/txuVCa',NULL,'0642483248',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:02','2025-05-03 11:33:02'),(66,'Koby Treutel','alanis.lakin@sipes.net','$2y$12$12ItlIt.JORm5UqoQeVIpuCq4lzhFRFIIzW1USWgeXh6jz3M1oogG',NULL,'0669455453',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:02','2025-05-03 11:33:02'),(67,'Andres Schuster','lockman.ariane@murazik.com','$2y$12$biVYKHbV9ja1GwENP2LtAO54rprs0nXvW9ve7nysDs9jvxQXWjFVi',NULL,'0152457532',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:02','2025-05-03 11:33:02'),(68,'Santa Jast I','mcclure.ubaldo@sanford.info','$2y$12$qqp3.b3VPSYAb/L8Ui5ckeg4Ll1DUui8K2YryfGot3MGWgY9sUV36',NULL,'0395644706',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:02','2025-05-03 11:33:02'),(69,'Granville Huels','meghan.balistreri@wiza.info','$2y$12$txGGUYfEnfFZt8vdUtWXkugnpcXbJWTUMI4hWt.cJjDeATP253.kO',NULL,'0694904896',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:02','2025-05-03 11:33:02'),(70,'Barney Gutmann','bernier.nikita@yahoo.com','$2y$12$aW9uhZjfm/TSIcjLldWywO40bJ8H6QbFOK0snDz642tfWdVVKVtcS',NULL,'0962779926',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:03','2025-05-03 11:33:03'),(71,'Miss Syble Greenfelder MD','tkunde@shanahan.biz','$2y$12$UnSWThRcEy2PQJ0bl/j8mOzBZLHtUBIWq8RpQkEvEjOvW0BvkZL66',NULL,'0118579735',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:03','2025-05-03 11:33:03'),(72,'Presley Bergnaum IV','jordi39@casper.com','$2y$12$1.gTFcsuCHfkwW4t2HBiQO.1dYMzmr9za4DEnwNufDcRbBPdkxWrG',NULL,'0489385523',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:03','2025-05-03 11:33:03'),(73,'Adrianna Reichert','dfeeney@reinger.com','$2y$12$0nROgCo6CBBSv8J1CEu8ke4i7PfehlgeZSPGO/5IxKVNLTY50IVsu',NULL,'0119262045',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:03','2025-05-03 11:33:03'),(74,'Marina Gutmann','felicity39@gmail.com','$2y$12$I9H/DngW1YDVNU30QHy1wOzli1eVeB5vp05z1JvG1ptakJjfi8rBS',NULL,'0015578562',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:03','2025-05-03 11:33:03'),(75,'Katheryn Kirlin','shields.vladimir@wiegand.com','$2y$12$ueCgb1Ti5gAGEcv5Vi239eV9L7UHFc0rDDlbALOmns10fSQ9AWLOG',NULL,'0210122526',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:03','2025-05-03 11:33:03'),(76,'Gennaro Tremblay','kblick@gislason.org','$2y$12$l98D7BTUH4QZdStcFmqVz.JJs03SDei8RM1h.V7q5OuEKKNnso8wG',NULL,'0796426918',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(77,'Haleigh Kovacek','urban71@hotmail.com','$2y$12$IV66z1kvT0htmBOVbOhvxONgVSe3Y/YSZtrFpnI.MJM3s.4YGX8oC',NULL,'0073320311',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(78,'Dion Cruickshank','roberts.hipolito@cummerata.biz','$2y$12$1DiunBrUmyRCdtY8wME5rOrClJHkVRXA3JArFPAO3zPi89c8iauMK',NULL,'0835263699',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(79,'Ciara Wuckert','xschaefer@schaefer.com','$2y$12$Xuv/hTUkT9UVKRfvlCn80ORtZQtkWXM1cfuosYkZzHWAjOc34OeSG',NULL,'0188361827',NULL,'attendee','activated',NULL,NULL,NULL,'2025-05-03 11:33:04','2025-05-03 11:33:04');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-05-03 11:32:02','2025-05-03 11:32:02'),(2,'EUR','€',0,2,1,0,0.91,'2025-05-03 11:32:02','2025-05-03 11:32:02'),(3,'VND','₫',0,0,2,0,23717.5,'2025-05-03 11:32:02','2025-05-03 11:32:02');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (1,33,'18HU5IODIFLC',NULL),(2,64,'1CCSPDIIJVUP',NULL),(4,72,'1QVZRBCWCKVR',NULL),(3,66,'1V3HKD36TKU0',NULL),(1,54,'367KQH5OVZBG',NULL),(1,49,'4WS6H06OOJ44',NULL),(2,65,'BRCU76QW8EOK',NULL),(1,45,'EFTGDIQ6OHTN',NULL),(2,60,'EQQCEP32NLGM',NULL),(1,39,'FDW2IVBGEOV5',NULL),(1,40,'FEHBHZXUV0PF',NULL),(2,61,'FTX7QANW6DTC',NULL),(1,48,'FUU72LIUKDJM',NULL),(4,68,'FWK6BYQVNKOJ',NULL),(1,51,'G68UPEJLV3WB',NULL),(4,71,'GRFKQYCPBMZG',NULL),(5,75,'HFTDLMID5IL0',NULL),(1,38,'I8NBC4EB0NBA',NULL),(1,32,'IAHLEQNLQVO1',NULL),(2,55,'IQJV7FOHHOGL',NULL),(5,77,'IVX98MY7HZS7',NULL),(1,42,'IXQLIV2B2L9G',NULL),(2,62,'J9RR6PFZCQAK',NULL),(1,35,'JRNTPPFWVSI5',NULL),(5,78,'KHYMAY4RR5UI',NULL),(1,52,'NEAQCURPAGIX',NULL),(5,76,'NELXOUTL9NAD',NULL),(2,59,'NG0A29ZCUCYL',NULL),(2,56,'NLHMLYQGV9DR',NULL),(1,34,'OBLXW4W3MKSZ',NULL),(1,50,'OC1MOFEGGTP3',NULL),(2,63,'PGOREE3WVCNA',NULL),(1,53,'PIH7DNVPYIX8',NULL),(1,43,'PUCKCMVNYLAC',NULL),(4,69,'QCALNO8IHKCH',NULL),(1,44,'TDWMGESAMNDI',NULL),(4,70,'TLTBMOFRX4JZ',NULL),(2,58,'TPFXLYH3ZGRO',NULL),(2,57,'TVFK5QU54S9E',NULL),(5,79,'TWGOFJBAULFB',NULL),(1,36,'V22KN4MGENNK',NULL),(1,37,'WAUJESJ0OBUS',NULL),(1,47,'WRYSGPDEKCXE',NULL),(4,73,'XHEJY60QZQR1',NULL),(3,67,'XRAIFJLWRGO7',NULL),(1,46,'YH7EUS9ME9UQ',NULL),(5,74,'YP6WUXCM4XO2',NULL),(1,41,'ZFBOP9HZKIB4',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,14,'Recusandae doloribus ut et est veniam. Doloremque qui animi ut error et eaque quia.',NULL,0,NULL,NULL),(1,27,'Sunt ullam fugit non. Qui est perferendis quos harum. Aut officiis distinctio aut et et in odit.',NULL,2,NULL,NULL),(1,30,'Recusandae quam dolor reiciendis et non in. Eius esse dicta nesciunt distinctio ut.',NULL,3,NULL,NULL),(2,29,'Id quo qui deserunt necessitatibus porro quam. Esse dignissimos sit ut. Est est enim doloremque.',NULL,0,NULL,NULL),(2,26,'Optio aut numquam qui sed fugiat. Quis at et ipsa rerum quae debitis eum.',NULL,1,NULL,NULL),(2,4,'Quis quis cum amet illum. Eos omnis nam est inventore alias.',NULL,2,NULL,NULL),(2,21,'Aliquid qui ex quo. Qui doloremque provident et.',NULL,3,NULL,NULL),(3,14,'Quae mollitia sit ut aliquid. Et aut eveniet voluptatem. Explicabo aliquid est qui facilis ut.',NULL,0,NULL,NULL),(3,27,'Harum consequatur autem et voluptatem qui quia. Id est facere eos mollitia eius.',NULL,1,NULL,NULL),(3,30,'Dignissimos qui ipsa qui quos libero. Est labore aut qui inventore.',NULL,2,NULL,NULL),(3,29,'Voluptatem quia expedita dolor occaecati ipsa. Ut expedita blanditiis non.',NULL,3,NULL,NULL),(4,5,'Sunt qui est et. Harum sint id sit possimus recusandae quod. Veritatis quo id ut at possimus.',NULL,0,NULL,NULL),(4,7,'Eum a est repudiandae omnis ea quo molestiae. Dolorem illo neque molestiae iusto ullam.',NULL,1,NULL,NULL),(4,30,'Tempore iste quaerat eum ut voluptatem inventore sed. A odio consequatur fuga consectetur est et.',NULL,2,NULL,NULL),(5,27,'Suscipit sunt totam non dolore magnam accusamus eligendi. Dignissimos quaerat voluptatem est sunt.',NULL,0,NULL,NULL),(5,4,'Doloremque ut inventore corporis dicta. Culpa voluptatibus est cupiditate voluptatem dolore.',NULL,1,NULL,NULL),(5,26,'Culpa voluptates atque quis. Ex maxime et molestias sit.',NULL,2,NULL,NULL),(6,4,'Neque dolorem similique iste esse aut aut veniam. Saepe ab non qui et nemo expedita ut.',NULL,0,NULL,NULL),(6,21,'Rem in adipisci qui. Facere quidem assumenda voluptas voluptate dolor omnis praesentium.',NULL,1,NULL,NULL),(6,30,'Sit eaque modi fuga laboriosam exercitationem est. Ut culpa ex adipisci eos molestiae molestias.',NULL,3,NULL,NULL),(7,24,'Consequatur temporibus vel tempore commodi. Et inventore suscipit eius debitis aspernatur et.',NULL,0,NULL,NULL),(7,29,'Maiores ut quis voluptas qui. Voluptas temporibus non quod et in magnam commodi.',NULL,1,NULL,NULL),(7,7,'Et et dolorum accusantium sit magnam. Nihil accusantium atque commodi eveniet quis et officiis.',NULL,3,NULL,NULL),(8,24,'Quasi vero esse laborum incidunt a alias. Cumque libero a ut commodi esse. Atque et autem dolore.',NULL,0,NULL,NULL),(8,27,'Et nisi laboriosam fugiat. Molestiae ut voluptas maxime. Sunt eaque voluptas rerum rem.',NULL,1,NULL,NULL),(8,29,'Veritatis voluptas eius veritatis harum consequatur. Quibusdam quia sed quia totam illum quis.',NULL,2,NULL,NULL),(8,14,'Deserunt quos eum ut. Magni quos dolor iste.',NULL,3,NULL,NULL),(9,21,'Non perspiciatis impedit et aut est. Omnis et vitae officia eum cum voluptate.',NULL,0,NULL,NULL),(9,30,'Nam corrupti ea dignissimos sed. Laborum accusamus ex rerum at. Porro provident error ut.',NULL,1,NULL,NULL),(10,26,'Quis qui quia omnis veritatis alias. Aut et corporis repudiandae qui incidunt et soluta est.',NULL,0,NULL,NULL),(10,24,'Ipsum soluta totam omnis et. Consequuntur facere et accusamus. Sed et id nemo vel ab a.',NULL,1,NULL,NULL),(10,27,'Quia sunt tempore beatae ipsa reiciendis commodi. Facilis quia est labore repudiandae quia.',NULL,2,NULL,NULL),(10,14,'Labore reiciendis consequuntur laboriosam voluptatem. Animi autem libero quia.',NULL,3,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',13,'Qui voluptatem esse possimus.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','923f4993-bc86-388e-9983-973d6b2878a5','main/events/1.webp',15.93,'6952 Hahn Circles Suite 465\nMcClureborough, TN 94727',5,5,5,'-35.207467','-8.035087',50,0,'2025-05-03 09:00:00','2025-05-15 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(2,'Mobile World Congress',13,'Quaerat ratione recusandae ipsa et ut ducimus.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','f390c524-b572-33cb-a095-c80bdfc512b7','main/events/2.webp',18.42,'438 Edmond Light Suite 993\nHansenview, MA 58759',2,2,2,'-85.760087','98.45343',80,0,'2025-05-03 09:00:00','2025-05-16 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(3,'Google I/O',17,'Quisquam accusamus quod sapiente.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','f5bc258c-1e7b-3794-87fe-982ebbbfec97','main/events/3.webp',6.98,'699 Uriah Circle Apt. 518\nSouth Wardberg, NE 06809-3010',4,4,4,'-81.400061','18.287755',92,0,'2025-05-03 09:00:00','2025-05-14 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(4,'Apple WWDC',12,'Tempora quis ut necessitatibus illo fugit consequatur.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','c6f171a9-962f-300f-b628-e0c2396fec5a','main/events/4.webp',23.90,'9617 Sarina Haven Apt. 714\nEast Kylerstad, KS 24880',6,NULL,NULL,'49.0418','35.233734',100,0,'2025-05-03 09:00:00','2025-05-16 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(5,'AWS re:Invent',3,'Illum sed autem corrupti.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','5ed830ac-fdcd-3a1b-9bca-0a4bfa8d833e','main/events/5.webp',17.02,'30978 Sauer Estates Suite 047\nBartonview, GA 93975-9876',4,4,4,'-85.89482','-143.145073',94,0,'2025-05-04 09:00:00','2025-05-17 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(6,'Microsoft Build',12,'Numquam minima dolores sed eos.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','8faf04cf-602f-3083-aec6-e75d738e9a66','main/events/6.webp',61.66,'343 Doyle Ferry\nCaleighport, TX 57055-0373',3,NULL,NULL,'37.665576','-128.839508',61,0,'2025-05-04 09:00:00','2025-05-21 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(7,'Facebook F8',13,'Pariatur optio ex excepturi omnis aut quis distinctio.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','464833d6-7e53-315d-800b-c09625c19dd9','main/events/7.webp',73.43,'1379 Anderson River\nCeasarborough, HI 06335-0520',6,NULL,NULL,'45.299188','-142.829065',76,0,'2025-05-04 09:00:00','2025-05-23 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(8,'GitHub Universe',13,'Dolore nemo quo doloremque quidem iusto.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','8c49f6f8-6f1e-3cb0-97fe-319a24896a35','main/events/8.webp',68.12,'982 Gleichner Estates Suite 541\nKrisview, NY 33627',4,4,4,'-66.953136','72.527109',62,0,'2025-05-04 09:00:00','2025-05-23 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(9,'Game Developers Conference',8,'Enim dicta aspernatur aut.','The largest conference in the gaming industry, focusing on game development and gaming technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','fbd44e02-e9d1-340f-a3c9-ef16d8ded089','main/events/9.webp',0.88,'57192 Chanel Plaza Apt. 043\nHintzton, NY 82483-7242',6,NULL,NULL,'-56.27664','19.164347',54,0,'2025-05-05 09:00:00','2025-05-23 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:51','2025-05-03 11:32:51'),(10,'Web Summit',17,'Odit et itaque perferendis consequatur hic blanditiis corrupti voluptas.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','d776f05b-202a-3cc2-bf07-3cb01f3971d5','main/events/10.webp',27.43,'47677 Osbaldo Islands\nNikitaberg, PA 15099',6,NULL,NULL,'-7.362935','12.208209',59,0,'2025-05-05 09:00:00','2025-05-16 18:00:00',NULL,NULL,'approved','2025-05-03 11:32:52','2025-05-03 11:32:52');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Darrin Wolff III - pmacejkovic@toy.org','pmacejkovic@toy.org','0841989151',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Jayde Doyle - kkoss@gmail.com','kkoss@gmail.com','0444991794',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Miss Dandre Trantow - juston31@schultz.com','juston31@schultz.com','0038501415',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Reanna Cremin - hadley76@gmail.com','hadley76@gmail.com','0377241638',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(5,1,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Dr. Yazmin O\'Connell DVM - dessie.schuster@nader.com','dessie.schuster@nader.com','0636008098',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(6,1,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Dr. Guiseppe Reichel DVM - schowalter.keaton@zboncak.org','schowalter.keaton@zboncak.org','0795876020',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Manuela Hartmann - bogan.barton@hotmail.com','bogan.barton@hotmail.com','0981683077',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(8,2,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Marianna Skiles - ofadel@gmail.com','ofadel@gmail.com','0371754197',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(9,2,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Mrs. Margot Schimmel - bauch.richmond@gmail.com','bauch.richmond@gmail.com','0775793637',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Dr. Waldo Labadie - domenica26@gmail.com','domenica26@gmail.com','0001917539',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Michelle Weber - lsipes@yahoo.com','lsipes@yahoo.com','0141409160',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(12,3,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Osborne Cole - ohara.cooper@gmail.com','ohara.cooper@gmail.com','0842022132',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Mrs. Deja Schuppe PhD - ratke.oliver@yahoo.com','ratke.oliver@yahoo.com','0260075525',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(14,4,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Sherwood Emard - angie.botsford@stamm.com','angie.botsford@stamm.com','0752437406',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Prof. Christa Schmitt - lucas62@donnelly.com','lucas62@donnelly.com','0798956569',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Aditya Block IV - weldon.steuber@huel.com','weldon.steuber@huel.com','0073930186',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(17,4,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Betty Macejkovic - davon38@hotmail.com','davon38@hotmail.com','0792348875',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(18,5,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Tina Wolf - laverna71@beer.com','laverna71@beer.com','0227619369',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(19,5,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Piper Thiel - auer.tiara@gmail.com','auer.tiara@gmail.com','0527914047',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(20,5,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Mrs. Myrna Sanford Sr. - don.jacobi@hilpert.com','don.jacobi@hilpert.com','0517449400',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(21,5,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Monserrat Johns - janelle27@yahoo.com','janelle27@yahoo.com','0208644339',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(22,5,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Prof. Ernesto Watsica MD - glenda.okuneva@yahoo.com','glenda.okuneva@yahoo.com','0057364481',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(23,5,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Sister Deckow - zbrown@watsica.net','zbrown@watsica.net','0105755728',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(24,6,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Milford Upton - rubie.lang@yahoo.com','rubie.lang@yahoo.com','0877134479',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(25,6,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Florine Schinner - vschuster@jakubowski.com','vschuster@jakubowski.com','0492635979',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(26,6,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Josephine Kuvalis Sr. - kira68@stroman.org','kira68@stroman.org','0318985928',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(27,6,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Alvena Torphy - karson63@yahoo.com','karson63@yahoo.com','0809120644',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(28,6,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Javonte Quitzon - mcclure.jana@hotmail.com','mcclure.jana@hotmail.com','0521183695',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(29,6,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Mitchell Bailey - derek95@hotmail.com','derek95@hotmail.com','0814043860',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(30,7,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Mr. Ryder Wiza DVM - jarred27@abbott.info','jarred27@abbott.info','0593553424',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(31,7,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Jonas Leuschke - margaretta99@gmail.com','margaretta99@gmail.com','0353519300',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(32,7,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Queenie Marks - heath46@mosciski.biz','heath46@mosciski.biz','0342366135',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(33,8,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Gustave Keeling - antonina.koch@altenwerth.com','antonina.koch@altenwerth.com','0398934029',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(34,8,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Mr. Dallas Hammes - gusikowski.dorcas@buckridge.com','gusikowski.dorcas@buckridge.com','0429266189',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(35,8,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Gust Schowalter - okohler@bernhard.org','okohler@bernhard.org','0593200739',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(36,8,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Dr. Monroe Hane IV - webster03@gmail.com','webster03@gmail.com','0470988791',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(37,8,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Mabelle Lebsack - orlando.mante@yahoo.com','orlando.mante@yahoo.com','0958021047',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(38,8,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Mr. Bill O\'Connell - mmccullough@gmail.com','mmccullough@gmail.com','0207696330',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(39,9,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Alva Kemmer - lueilwitz.harmony@morissette.com','lueilwitz.harmony@morissette.com','0387684014',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(40,9,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'CES (Consumer Electronics Show) - Robyn Kling - cornell49@kuhlman.com','cornell49@kuhlman.com','0415501271',1,15.93,15.93,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(41,9,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'CES (Consumer Electronics Show) - Briana Fadel - lori.stroman@gmail.com','lori.stroman@gmail.com','0297908032',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(42,9,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'CES (Consumer Electronics Show) - Alden McDermott - herman.berta@grady.com','herman.berta@grady.com','0476131728',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(43,9,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'CES (Consumer Electronics Show) - Mrs. Ernestina McClure Jr. - kohler.mose@gmail.com','kohler.mose@gmail.com','0283671016',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(44,10,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'CES (Consumer Electronics Show) - Dr. Dedrick Gerhold Sr. - jovanny48@hotmail.com','jovanny48@hotmail.com','0126556706',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(45,10,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'CES (Consumer Electronics Show) - Maximillian Zemlak - tyler39@hotmail.com','tyler39@hotmail.com','0212699433',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(46,10,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'CES (Consumer Electronics Show) - Lyda Rolfson - carroll29@yahoo.com','carroll29@yahoo.com','0997638697',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(47,10,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'CES (Consumer Electronics Show) - Ross Cummings - lpfeffer@botsford.net','lpfeffer@botsford.net','0751851989',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(48,10,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'CES (Consumer Electronics Show) - Bridgette Rath MD - shaun33@jacobi.com','shaun33@jacobi.com','0946208465',1,15.93,15.93,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(49,11,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Margaretta Hickle - monte.becker@gmail.com','monte.becker@gmail.com','0786640671',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(50,11,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Miss Alize Runte - glennie22@stamm.org','glennie22@stamm.org','0476722252',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(51,11,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Prof. Carmine Rolfson IV - towne.alexandra@mann.com','towne.alexandra@mann.com','0253653601',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(52,12,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Nettie Wyman - jennings.breitenberg@carter.com','jennings.breitenberg@carter.com','0500710922',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(53,12,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Dave Schiller Sr. - brett.skiles@yahoo.com','brett.skiles@yahoo.com','0644011623',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(54,12,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Theron Leannon II - skye79@hotmail.com','skye79@hotmail.com','0202313338',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(55,13,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Bailey Gutkowski IV - mckenzie.daisy@gmail.com','mckenzie.daisy@gmail.com','0366144770',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(56,13,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Prof. Rollin Cruickshank - luigi.koelpin@hotmail.com','luigi.koelpin@hotmail.com','0414689253',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(57,13,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Barney Fay - katelyn26@schmitt.com','katelyn26@schmitt.com','0970586670',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(58,13,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Marvin Grady Jr. - donald.lesch@hotmail.com','donald.lesch@hotmail.com','0485218676',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(59,14,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Tremayne Will - walker.roxane@fahey.com','walker.roxane@fahey.com','0263405997',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(60,14,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Adelle Ortiz - pfannerstill.ola@hotmail.com','pfannerstill.ola@hotmail.com','0006697669',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(61,14,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Ines Schultz IV - nader.emmanuel@hotmail.com','nader.emmanuel@hotmail.com','0016149061',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(62,14,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Stephanie Ruecker - sawayn.vella@ernser.net','sawayn.vella@ernser.net','0019576556',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(63,14,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Mrs. Agustina Spencer DDS - elisabeth.bradtke@yahoo.com','elisabeth.bradtke@yahoo.com','0495562238',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(64,15,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Emerald Franecki - calista27@bechtelar.org','calista27@bechtelar.org','0325392709',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(65,15,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Dayna Zemlak - juston03@weber.net','juston03@weber.net','0172780718',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(66,15,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Odessa West - manuela92@hermann.com','manuela92@hermann.com','0605976537',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(67,15,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Sydnie Jerde - lesley.kirlin@hotmail.com','lesley.kirlin@hotmail.com','0862591588',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(68,15,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Mr. Chandler Berge Jr. - zhand@walsh.info','zhand@walsh.info','0385331734',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(69,15,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Uriel Crona - hwilderman@gmail.com','hwilderman@gmail.com','0174716375',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(70,16,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Philip Schulist - terrence.prosacco@yahoo.com','terrence.prosacco@yahoo.com','0148451327',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(71,16,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Celestine Veum - ealtenwerth@renner.com','ealtenwerth@renner.com','0213160841',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(72,16,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Prof. Raven Nicolas - emmanuelle86@hotmail.com','emmanuelle86@hotmail.com','0950527663',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(73,17,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Ashlee Bernhard - hbarton@gmail.com','hbarton@gmail.com','0124210640',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(74,17,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Owen Connelly - rleannon@gmail.com','rleannon@gmail.com','0320101930',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(75,17,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Cyrus Howe - bbernhard@yahoo.com','bbernhard@yahoo.com','0463497648',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(76,17,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Ms. Ada Hill - prosacco.billie@stroman.org','prosacco.billie@stroman.org','0665635012',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(77,18,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Mrs. Carrie Volkman - jazlyn.bergnaum@ryan.com','jazlyn.bergnaum@ryan.com','0458256921',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(78,18,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Mobile World Congress - Sydnee Cruickshank - zheller@glover.com','zheller@glover.com','0723403773',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(79,18,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Mobile World Congress - Leanna Windler Sr. - mccullough.myrtice@gmail.com','mccullough.myrtice@gmail.com','0867297047',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(80,18,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Mobile World Congress - Cristian Feest - agnes.erdman@bruen.com','agnes.erdman@bruen.com','0999295246',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(81,18,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Mobile World Congress - Kip Rempel - eharber@yahoo.com','eharber@yahoo.com','0642483248',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(82,19,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Mobile World Congress - Freda Spinka MD - ezieme@yahoo.com','ezieme@yahoo.com','0509711775',1,18.42,18.42,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(83,19,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Mobile World Congress - Emilia Walter - sheila.conroy@hermiston.com','sheila.conroy@hermiston.com','0908406985',1,18.42,18.42,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(84,19,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Mobile World Congress - Maximo Brekke Jr. - kade.berge@hotmail.com','kade.berge@hotmail.com','0474281372',1,18.42,18.42,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(85,19,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Mobile World Congress - Dorothy Reichert - chet21@gmail.com','chet21@gmail.com','0403342786',1,18.42,18.42,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(86,19,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Mobile World Congress - Cecile O\'Reilly - austyn.abernathy@streich.info','austyn.abernathy@streich.info','0533361029',1,18.42,18.42,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(87,20,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Mobile World Congress - Brandy Kunde - gwalter@schaden.com','gwalter@schaden.com','0914596321',1,18.42,18.42,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(88,20,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Mobile World Congress - Madonna Erdman - raina.wilkinson@yahoo.com','raina.wilkinson@yahoo.com','0590675305',1,18.42,18.42,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(89,20,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Mobile World Congress - Bo Kub - iryan@russel.info','iryan@russel.info','0504669382',1,18.42,18.42,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(90,21,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Ernesto Jerde - parisian.neha@shanahan.net','parisian.neha@shanahan.net','0473250643',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(91,21,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Mr. Tyrell Haley DDS - eva.kuphal@padberg.com','eva.kuphal@padberg.com','0302491457',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(92,21,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Miss Eda Jast I - egreenfelder@mcclure.com','egreenfelder@mcclure.com','0329495001',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(93,21,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Gisselle McKenzie II - omari.rippin@gmail.com','omari.rippin@gmail.com','0018865581',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(94,22,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Jameson Reilly DVM - hanna99@hotmail.com','hanna99@hotmail.com','0148686596',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(95,22,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Yasmine Gerlach - francesco.bednar@emmerich.info','francesco.bednar@emmerich.info','0205887697',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(96,22,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Tracey Kuhic - rdach@gmail.com','rdach@gmail.com','0945060803',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(97,22,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Mrs. Cecelia D\'Amore Sr. - ebert.amy@hotmail.com','ebert.amy@hotmail.com','0205177218',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(98,22,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Ethan Vandervort - msipes@feil.net','msipes@feil.net','0038052854',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(99,22,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Toby Ward - evert68@grady.com','evert68@grady.com','0470214481',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(100,23,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Prof. Leola Langosh II - eparisian@yahoo.com','eparisian@yahoo.com','0950252341',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(101,23,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Josh Krajcik I - schamberger.priscilla@prosacco.com','schamberger.priscilla@prosacco.com','0712884581',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(102,23,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Miss Enola Barton - bosinski@stroman.net','bosinski@stroman.net','0742304768',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(103,23,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Barrett Kulas - richard.howe@gmail.com','richard.howe@gmail.com','0271208542',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(104,23,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Issac Emmerich MD - eugene.kuhlman@gmail.com','eugene.kuhlman@gmail.com','0665876080',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(105,24,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Koby Treutel - alanis.lakin@sipes.net','alanis.lakin@sipes.net','0669455453',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(106,24,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Andres Schuster - lockman.ariane@murazik.com','lockman.ariane@murazik.com','0152457532',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(107,25,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Mr. Thomas Doyle - golden48@hotmail.com','golden48@hotmail.com','0264326059',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(108,25,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Sylvia Ebert - edgardo90@hotmail.com','edgardo90@hotmail.com','0619923272',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(109,25,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Adalberto Hintz - merlin.wolf@yahoo.com','merlin.wolf@yahoo.com','0139843365',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(110,26,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Marian Ebert - darryl13@wuckert.org','darryl13@wuckert.org','0253300789',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(111,26,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Ms. Kaela Bahringer - gerhold.carmine@yahoo.com','gerhold.carmine@yahoo.com','0460596190',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(112,26,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Eric Johns - bergstrom.alanis@hotmail.com','bergstrom.alanis@hotmail.com','0110613703',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(113,26,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Candace Hagenes - jacky85@yahoo.com','jacky85@yahoo.com','0198301520',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(114,27,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Zechariah Wolff - riley.ullrich@emmerich.com','riley.ullrich@emmerich.com','0147907432',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(115,27,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Dr. Flo Jacobi - breitenberg.cornelius@gmail.com','breitenberg.cornelius@gmail.com','0115829089',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(116,28,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Dasia Thiel DDS - wolf.norbert@reilly.net','wolf.norbert@reilly.net','0255972297',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(117,28,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Google I/O - Gabrielle Hoeger - claud.jaskolski@gutmann.com','claud.jaskolski@gutmann.com','0929147620',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(118,28,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Google I/O - Gwendolyn Kautzer - devan.effertz@mraz.com','devan.effertz@mraz.com','0039855028',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(119,28,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Google I/O - Stanford Stracke - bettye.reichert@hills.com','bettye.reichert@hills.com','0328667502',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(120,29,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Google I/O - Mrs. Enola Will II - spencer.jordi@goodwin.net','spencer.jordi@goodwin.net','0671447768',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(121,29,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Google I/O - Augustine Stehr - fmosciski@predovic.info','fmosciski@predovic.info','0948228936',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(122,29,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Google I/O - Ivory Cremin - gustave.stracke@blick.com','gustave.stracke@blick.com','0513842482',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(123,29,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Google I/O - Shanie Jerde - jschimmel@yahoo.com','jschimmel@yahoo.com','0158300897',1,6.98,6.98,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(124,30,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Google I/O - Roberto Boyer - mcclure.leta@gmail.com','mcclure.leta@gmail.com','0215695706',1,6.98,6.98,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(125,30,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Google I/O - Mose Hodkiewicz - mervin86@carroll.com','mervin86@carroll.com','0697688142',1,6.98,6.98,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(126,31,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Lambert Batz - jace.wuckert@yahoo.com','jace.wuckert@yahoo.com','0808526738',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(127,31,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Fay DuBuque - fredrick92@ratke.com','fredrick92@ratke.com','0760210496',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(128,31,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Miss Ilene Strosin - macey.huel@yahoo.com','macey.huel@yahoo.com','0793587591',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(129,31,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Dr. Freeman Bergnaum - geoffrey11@gerhold.com','geoffrey11@gerhold.com','0042168051',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(130,32,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Dr. Wyatt Bailey Jr. - leanne29@gmail.com','leanne29@gmail.com','0061880030',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(131,32,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Mr. Uriel Walter III - zwill@hotmail.com','zwill@hotmail.com','0712033803',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(132,32,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Helene Welch - manuel.okuneva@ryan.net','manuel.okuneva@ryan.net','0351364509',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(133,33,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Diana Schroeder PhD - jboyer@mohr.com','jboyer@mohr.com','0858320223',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(134,33,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Gretchen Hermiston - zlesch@tillman.net','zlesch@tillman.net','0138889731',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(135,33,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Mrs. Elna Roob I - pboehm@mraz.net','pboehm@mraz.net','0682931149',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(136,33,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Zander Ferry - smith.deontae@hotmail.com','smith.deontae@hotmail.com','0570763988',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(137,33,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Lane Anderson - dovie27@mcglynn.biz','dovie27@mcglynn.biz','0287345097',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(138,33,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Dax Koch - jacobson.raphael@kub.com','jacobson.raphael@kub.com','0116540331',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(139,34,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Prof. Kamren Bode Sr. - hipolito.cummerata@gmail.com','hipolito.cummerata@gmail.com','0862260111',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(140,34,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Royal Hills DVM - fcasper@yahoo.com','fcasper@yahoo.com','0520258609',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(141,35,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Santa Jast I - mcclure.ubaldo@sanford.info','mcclure.ubaldo@sanford.info','0395644706',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(142,35,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Granville Huels - meghan.balistreri@wiza.info','meghan.balistreri@wiza.info','0694904896',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(143,35,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Barney Gutmann - bernier.nikita@yahoo.com','bernier.nikita@yahoo.com','0962779926',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(144,35,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Miss Syble Greenfelder MD - tkunde@shanahan.biz','tkunde@shanahan.biz','0118579735',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(145,35,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Presley Bergnaum IV - jordi39@casper.com','jordi39@casper.com','0489385523',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(146,35,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Adrianna Reichert - dfeeney@reinger.com','dfeeney@reinger.com','0119262045',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(147,36,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Benny Price - qschulist@harvey.com','qschulist@harvey.com','0905865665',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(148,36,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Carmel Runolfsdottir - ondricka.stella@gmail.com','ondricka.stella@gmail.com','0408580853',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(149,36,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Alicia Thiel - runte.oral@herman.com','runte.oral@herman.com','0267428779',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(150,36,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Mr. Hyman Gutmann - wilhelmine.green@gmail.com','wilhelmine.green@gmail.com','0243771473',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(151,36,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Nella Mann - jermain99@hansen.com','jermain99@hansen.com','0669730686',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(152,37,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Prof. Jerome Waters - doyle.corine@krajcik.com','doyle.corine@krajcik.com','0797945635',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(153,37,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Wanda Russel DDS - bhickle@hotmail.com','bhickle@hotmail.com','0297537074',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(154,37,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Myra Jacobson PhD - christ31@wehner.org','christ31@wehner.org','0444244763',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(155,37,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Kacie Kris - reilly.mraz@yahoo.com','reilly.mraz@yahoo.com','0554285060',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(156,37,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Electa Larson - claudie.ruecker@yahoo.com','claudie.ruecker@yahoo.com','0564398002',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(157,37,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Prof. Lonzo Kiehn II - kody.schmitt@hotmail.com','kody.schmitt@hotmail.com','0465072135',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(158,38,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Julio Toy - hermann.jesus@gmail.com','hermann.jesus@gmail.com','0779073025',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(159,38,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'Apple WWDC - Keira McLaughlin - lang.ethyl@yahoo.com','lang.ethyl@yahoo.com','0907838731',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(160,38,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'Apple WWDC - Rebeca Collins - barbara09@gmail.com','barbara09@gmail.com','0964733408',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(161,39,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'Apple WWDC - Thora Wuckert - edison.yundt@hotmail.com','edison.yundt@hotmail.com','0389925816',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(162,39,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'Apple WWDC - Mrs. Eulalia Greenfelder - claudia95@yahoo.com','claudia95@yahoo.com','0542889042',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(163,39,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'Apple WWDC - Martin Bashirian Jr. - von.letitia@marquardt.net','von.letitia@marquardt.net','0898982388',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(164,39,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'Apple WWDC - Dock Olson - opurdy@pouros.com','opurdy@pouros.com','0810301932',1,23.90,23.90,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(165,40,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'Apple WWDC - Halie Harber - krystina.hills@abbott.com','krystina.hills@abbott.com','0592897219',1,23.90,23.90,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(166,40,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'Apple WWDC - Hermina Hagenes - loy.altenwerth@champlin.org','loy.altenwerth@champlin.org','0423521852',1,23.90,23.90,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(167,41,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Seth Mann - wilkinson.dahlia@ebert.com','wilkinson.dahlia@ebert.com','0098562332',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(168,41,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Miss Yasmeen Sanford IV - matilde.wyman@hotmail.com','matilde.wyman@hotmail.com','0606138388',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(169,42,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Matilde Stiedemann IV - schroeder.rhea@hotmail.com','schroeder.rhea@hotmail.com','0219268483',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(170,42,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Jordan Dach - darien17@gmail.com','darien17@gmail.com','0152196224',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(171,42,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Breana Corwin - jaskolski.allison@nader.com','jaskolski.allison@nader.com','0116523028',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(172,42,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Sherwood Schmitt - ehirthe@wilkinson.com','ehirthe@wilkinson.com','0862912422',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(173,42,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Lolita Russel - gwuckert@yahoo.com','gwuckert@yahoo.com','0564660717',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(174,43,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Marina Gutmann - felicity39@gmail.com','felicity39@gmail.com','0015578562',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(175,43,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Katheryn Kirlin - shields.vladimir@wiegand.com','shields.vladimir@wiegand.com','0210122526',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(176,44,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Dashawn Thompson - davon79@moen.net','davon79@moen.net','0871270204',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(177,44,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Kattie Ankunding MD - dino.ernser@hotmail.com','dino.ernser@hotmail.com','0254594431',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(178,44,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Stefanie Casper - kertzmann.sasha@hotmail.com','kertzmann.sasha@hotmail.com','0011705037',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(179,44,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Sonny Jacobson - don52@thiel.com','don52@thiel.com','0070486337',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(180,45,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Dr. Harmony Metz II - avandervort@yahoo.com','avandervort@yahoo.com','0374524725',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(181,45,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Amara Conroy DDS - nelda91@king.org','nelda91@king.org','0027540328',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(182,46,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Chet Hintz - acorkery@hotmail.com','acorkery@hotmail.com','0748316708',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(183,46,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Prof. Zachary Schmitt DVM - antwan44@greenfelder.info','antwan44@greenfelder.info','0224353291',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(184,47,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Zoe Wolf - gulgowski.lilla@harvey.com','gulgowski.lilla@harvey.com','0057216346',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(185,47,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Prof. Tomas Harber V - magdalena.bergnaum@mcglynn.com','magdalena.bergnaum@mcglynn.com','0600161352',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(186,48,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Gennaro Tremblay - kblick@gislason.org','kblick@gislason.org','0796426918',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(187,48,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Haleigh Kovacek - urban71@hotmail.com','urban71@hotmail.com','0073320311',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(188,48,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Dion Cruickshank - roberts.hipolito@cummerata.biz','roberts.hipolito@cummerata.biz','0835263699',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(189,48,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Ciara Wuckert - xschaefer@schaefer.com','xschaefer@schaefer.com','0188361827',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(190,49,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Presley Renner - jeff67@hotmail.com','jeff67@hotmail.com','0629872043',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(191,49,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Mr. Matt McLaughlin - gus65@hegmann.info','gus65@hegmann.info','0967778313',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(192,49,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Miss Valerie Watsica - oliver.swift@gmail.com','oliver.swift@gmail.com','0241303151',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(193,49,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Zechariah Bahringer - golda26@gmail.com','golda26@gmail.com','0664683618',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(194,50,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Chris Rippin Jr. - dziemann@okeefe.com','dziemann@okeefe.com','0714730976',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(195,50,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Cleta Luettgen - williamson.eugenia@yahoo.com','williamson.eugenia@yahoo.com','0215130525',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(196,50,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Jewell Mann - dharvey@gmail.com','dharvey@gmail.com','0709402995',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(197,50,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Dr. Erick Lockman I - domenica.haley@feil.info','domenica.haley@feil.info','0078000044',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(198,50,'ArchiElite\\EventsBooking\\Models\\Ticket',198,'AWS re:Invent - Gloria Huel - weissnat.tyrel@gaylord.net','weissnat.tyrel@gaylord.net','0798663721',1,17.02,17.02,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(199,50,'ArchiElite\\EventsBooking\\Models\\Ticket',199,'AWS re:Invent - Elmira Yost - mante.delta@hegmann.com','mante.delta@hegmann.com','0482220947',1,17.02,17.02,NULL,'2025-05-03 11:32:57','2025-05-03 11:32:57');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',15.93,'CES (Consumer Electronics Show)','Aracely Hammes Sr.','reichel.larissa@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',79.65,79.65,0.00,0.00,NULL,1,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',15.93,'CES (Consumer Electronics Show)','Santa Boehm','tstroman@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',31.86,31.86,0.00,0.00,NULL,2,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',15.93,'CES (Consumer Electronics Show)','Marietta Beatty PhD','hprohaska@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',31.86,31.86,0.00,0.00,NULL,3,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',15.93,'CES (Consumer Electronics Show)','Marietta Beatty PhD','hprohaska@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',63.72,63.72,0.00,0.00,NULL,4,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',15.93,'CES (Consumer Electronics Show)','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',79.65,79.65,0.00,0.00,NULL,5,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',15.93,'CES (Consumer Electronics Show)','Emmitt Gislason','erna78@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',79.65,79.65,0.00,0.00,NULL,6,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',15.93,'CES (Consumer Electronics Show)','Santa Boehm','tstroman@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',31.86,31.86,0.00,0.00,NULL,7,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',15.93,'CES (Consumer Electronics Show)','Arturo Boyle II','bbartell@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',79.65,79.65,0.00,0.00,NULL,8,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',15.93,'CES (Consumer Electronics Show)','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',63.72,63.72,0.00,0.00,NULL,9,'completed','2025-05-03 11:32:52','2025-05-03 11:32:52','2025-05-03 11:32:52'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',15.93,'CES (Consumer Electronics Show)','Mr. Waldo Sporer V','purdy.velva@schmeler.com',NULL,'ArchiElite','main/general/logo-light.png',63.72,63.72,0.00,0.00,NULL,10,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',18.42,'Mobile World Congress','Santa Boehm','tstroman@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',36.84,36.84,0.00,0.00,NULL,11,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',18.42,'Mobile World Congress','Mr. Vincent Halvorson V','gmarvin@damore.com',NULL,'ArchiElite','main/general/logo-light.png',36.84,36.84,0.00,0.00,NULL,12,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',18.42,'Mobile World Congress','Mr. Vincent Halvorson V','gmarvin@damore.com',NULL,'ArchiElite','main/general/logo-light.png',55.26,55.26,0.00,0.00,NULL,13,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',18.42,'Mobile World Congress','Marietta Beatty PhD','hprohaska@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',73.68,73.68,0.00,0.00,NULL,14,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',18.42,'Mobile World Congress','Mr. Waldo Sporer V','purdy.velva@schmeler.com',NULL,'ArchiElite','main/general/logo-light.png',92.10,92.10,0.00,0.00,NULL,15,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',18.42,'Mobile World Congress','Mr. Vincent Halvorson V','gmarvin@damore.com',NULL,'ArchiElite','main/general/logo-light.png',36.84,36.84,0.00,0.00,NULL,16,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',18.42,'Mobile World Congress','Santa Boehm','tstroman@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',55.26,55.26,0.00,0.00,NULL,17,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',18.42,'Mobile World Congress','Toney Schinner IV','nrowe@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',73.68,73.68,0.00,0.00,NULL,18,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',18.42,'Mobile World Congress','Aracely Hammes Sr.','reichel.larissa@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',73.68,73.68,0.00,0.00,NULL,19,'completed','2025-05-03 11:32:53','2025-05-03 11:32:53','2025-05-03 11:32:53'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',18.42,'Mobile World Congress','Marietta Beatty PhD','hprohaska@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',36.84,36.84,0.00,0.00,NULL,20,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',6.98,'Google I/O','Mr. Vincent Halvorson V','gmarvin@damore.com',NULL,'ArchiElite','main/general/logo-light.png',20.94,20.94,0.00,0.00,NULL,21,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',6.98,'Google I/O','Aracely Hammes Sr.','reichel.larissa@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',34.90,34.90,0.00,0.00,NULL,22,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',6.98,'Google I/O','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',27.92,27.92,0.00,0.00,NULL,23,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',6.98,'Google I/O','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',6.98,6.98,0.00,0.00,NULL,24,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',6.98,'Google I/O','Marietta Beatty PhD','hprohaska@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',13.96,13.96,0.00,0.00,NULL,25,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',6.98,'Google I/O','Laisha Bednar','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',20.94,20.94,0.00,0.00,NULL,26,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',6.98,'Google I/O','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',6.98,6.98,0.00,0.00,NULL,27,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',6.98,'Google I/O','Arturo Boyle II','bbartell@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',20.94,20.94,0.00,0.00,NULL,28,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',6.98,'Google I/O','Arturo Boyle II','bbartell@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',20.94,20.94,0.00,0.00,NULL,29,'completed','2025-05-03 11:32:54','2025-05-03 11:32:54','2025-05-03 11:32:54'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',6.98,'Google I/O','Toney Schinner IV','nrowe@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',6.98,6.98,0.00,0.00,NULL,30,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',23.90,'Apple WWDC','Santa Boehm','tstroman@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',71.70,71.70,0.00,0.00,NULL,31,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',23.90,'Apple WWDC','Mr. Vincent Halvorson V','gmarvin@damore.com',NULL,'ArchiElite','main/general/logo-light.png',47.80,47.80,0.00,0.00,NULL,32,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',23.90,'Apple WWDC','Arturo Boyle II','bbartell@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',119.50,119.50,0.00,0.00,NULL,33,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',23.90,'Apple WWDC','Mr. Vincent Halvorson V','gmarvin@damore.com',NULL,'ArchiElite','main/general/logo-light.png',23.90,23.90,0.00,0.00,NULL,34,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',23.90,'Apple WWDC','Santa Boehm','tstroman@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',119.50,119.50,0.00,0.00,NULL,35,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',23.90,'Apple WWDC','Arturo Boyle II','bbartell@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',95.60,95.60,0.00,0.00,NULL,36,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',23.90,'Apple WWDC','Emmitt Gislason','erna78@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',119.50,119.50,0.00,0.00,NULL,37,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',23.90,'Apple WWDC','Laisha Bednar','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',47.80,47.80,0.00,0.00,NULL,38,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',23.90,'Apple WWDC','Laisha Bednar','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',71.70,71.70,0.00,0.00,NULL,39,'completed','2025-05-03 11:32:55','2025-05-03 11:32:55','2025-05-03 11:32:55'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',23.90,'Apple WWDC','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',23.90,23.90,0.00,0.00,NULL,40,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',17.02,'AWS re:Invent','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',17.02,17.02,0.00,0.00,NULL,41,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',17.02,'AWS re:Invent','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',68.08,68.08,0.00,0.00,NULL,42,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',17.02,'AWS re:Invent','Marietta Beatty PhD','hprohaska@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',17.02,17.02,0.00,0.00,NULL,43,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',17.02,'AWS re:Invent','Mr. Waldo Sporer V','purdy.velva@schmeler.com',NULL,'ArchiElite','main/general/logo-light.png',51.06,51.06,0.00,0.00,NULL,44,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',17.02,'AWS re:Invent','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',17.02,17.02,0.00,0.00,NULL,45,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',17.02,'AWS re:Invent','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',17.02,17.02,0.00,0.00,NULL,46,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',17.02,'AWS re:Invent','Prof. Arely Koch','johnson.mona@turner.biz',NULL,'ArchiElite','main/general/logo-light.png',17.02,17.02,0.00,0.00,NULL,47,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',17.02,'AWS re:Invent','Toney Schinner IV','nrowe@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',51.06,51.06,0.00,0.00,NULL,48,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',17.02,'AWS re:Invent','Emmitt Gislason','erna78@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',51.06,51.06,0.00,0.00,NULL,49,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',17.02,'AWS re:Invent','Mr. Vincent Halvorson V','gmarvin@damore.com',NULL,'ArchiElite','main/general/logo-light.png',85.10,85.10,0.00,0.00,NULL,50,'completed','2025-05-03 11:32:56','2025-05-03 11:32:56','2025-05-03 11:32:56');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'ZVV8EPOM8Q0Y','e412ec72-3b0e-469e-b6b9-8ab2dec15002',1,'CES (Consumer Electronics Show)',15.93,31,1,'Aracely Hammes Sr.','reichel.larissa@hotmail.com','The Cat only grinned when it grunted again, and did not come the same as the question was.',NULL,'1',15.93,5,79.65,79.65,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(2,'VUJSIAGHZZKI','148c4a1b-0d04-4839-bc6c-25ad53a4a4e0',1,'CES (Consumer Electronics Show)',15.93,25,1,'Santa Boehm','tstroman@gmail.com','Quick, now!\' And Alice was too small, but at the corners: next the ten courtiers; these were.',NULL,'2',15.93,2,31.86,31.86,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(3,'B6ABZIRAPB1W','9b930bee-a419-4db4-a255-d3dfbd643d4b',1,'CES (Consumer Electronics Show)',15.93,15,1,'Marietta Beatty PhD','hprohaska@gmail.com','The Queen turned crimson with fury, and, after glaring at her as hard as he could go. Alice took.',NULL,'3',15.93,2,31.86,31.86,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(4,'V742YQ07BWHC','ab3f88e6-5445-406f-8212-a771853eb48f',1,'CES (Consumer Electronics Show)',15.93,15,1,'Marietta Beatty PhD','hprohaska@gmail.com','Alice waited patiently until it chose to speak with. Alice waited patiently until it chose to.',NULL,'4',15.93,4,63.72,63.72,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(5,'8IV0JPUZ5EIJ','bf697d70-4148-4d8a-9a73-f051c4a32123',1,'CES (Consumer Electronics Show)',15.93,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','Queen said to Alice, that she did not seem to have it explained,\' said the Mock Turtle. \'No, no!.',NULL,'5',15.93,5,79.65,79.65,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(6,'HYYQB5DXPGTG','fd2583d5-dcca-4680-a9e7-4303f8ae3c2b',1,'CES (Consumer Electronics Show)',15.93,11,1,'Emmitt Gislason','erna78@gmail.com','Dinah! I wonder who will put on one knee. \'I\'m a poor man, your Majesty,\' he began, \'for bringing.',NULL,'6',15.93,5,79.65,79.65,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(7,'MVJTTWWA8O6L','c57a0411-d18e-4cdb-a345-37c63ad75da2',1,'CES (Consumer Electronics Show)',15.93,25,1,'Santa Boehm','tstroman@gmail.com','Don\'t let me hear the rattle of the crowd below, and there she saw maps and pictures hung upon.',NULL,'7',15.93,2,31.86,31.86,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(8,'KL1APJYQXHQ9','0f0266de-2ada-4019-9f17-f637bd8343f8',1,'CES (Consumer Electronics Show)',15.93,20,1,'Arturo Boyle II','bbartell@gmail.com','KING AND QUEEN OF HEARTS. Alice was just saying to her head, and she felt sure she would catch a.',NULL,'8',15.93,5,79.65,79.65,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(9,'0FLILERZ9RKK','06e28382-580b-4f2b-8bef-decfa86efe3f',1,'CES (Consumer Electronics Show)',15.93,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','Mock Turtle Soup is made from,\' said the Caterpillar took the thimble, saying \'We beg your.',NULL,'9',15.93,4,63.72,63.72,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52'),(10,'OICLTT31EIR1','a6bca915-a2eb-4cdf-8373-2424b9f6728e',1,'CES (Consumer Electronics Show)',15.93,18,1,'Mr. Waldo Sporer V','purdy.velva@schmeler.com','Duchess. \'Everything\'s got a moral, if only you can find them.\' As she said to Alice; and Alice.',NULL,'10',15.93,4,63.72,63.72,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(11,'9SUZTEBFDPTQ','da8be03f-bb53-4088-ad3e-2bf99ebf0c92',2,'Mobile World Congress',18.42,25,1,'Santa Boehm','tstroman@gmail.com','Alice a good deal frightened at the righthand bit again, and made a rush at Alice the moment she.',NULL,'11',18.42,2,36.84,36.84,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(12,'EC9FBJJHPKFY','b89d936b-926e-45a7-878d-7ccb9679657d',2,'Mobile World Congress',18.42,16,1,'Mr. Vincent Halvorson V','gmarvin@damore.com','Majesty!\' the Duchess sneezed occasionally; and as it went, as if she was about a foot high: then.',NULL,'12',18.42,2,36.84,36.84,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(13,'ZA1MJUTHMR15','59f0c98e-b4a8-4099-8b3e-79dce2f4dd45',2,'Mobile World Congress',18.42,16,1,'Mr. Vincent Halvorson V','gmarvin@damore.com','The Queen!\' and the words \'DRINK ME\' beautifully printed on it in her French lesson-book. The.',NULL,'13',18.42,3,55.26,55.26,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(14,'TKYKJVT75TWQ','6f909f5d-059c-4550-ac56-d2d53be09dd3',2,'Mobile World Congress',18.42,15,1,'Marietta Beatty PhD','hprohaska@gmail.com','Why, there\'s hardly room to open her mouth; but she could see her after the candle is like after.',NULL,'14',18.42,4,73.68,73.68,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(15,'32LZ8UQZBXJZ','0a3194fc-34e0-40b4-848c-2d7b8da014a0',2,'Mobile World Congress',18.42,18,1,'Mr. Waldo Sporer V','purdy.velva@schmeler.com','Duchess\'s cook. She carried the pepper-box in her life before, and he says it\'s so useful, it\'s.',NULL,'15',18.42,5,92.10,92.10,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(16,'PWVF9MBK4OKQ','8c428a69-b6ff-45d6-8e1f-8dccbf153994',2,'Mobile World Congress',18.42,16,1,'Mr. Vincent Halvorson V','gmarvin@damore.com','English!\' said the Mock Turtle yawned and shut his note-book hastily. \'Consider your verdict,\' he.',NULL,'16',18.42,2,36.84,36.84,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(17,'MBHD6SO8QHVX','0f26940b-f982-4766-bd99-1db5240cc499',2,'Mobile World Congress',18.42,25,1,'Santa Boehm','tstroman@gmail.com','Alice. \'I\'m glad they don\'t seem to have been a RED rose-tree, and we put a stop to this,\' she.',NULL,'17',18.42,3,55.26,55.26,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(18,'5VNII6KSUDSI','bbd7c0f7-5f3d-47ec-97fd-9f4112bca8e8',2,'Mobile World Congress',18.42,6,1,'Toney Schinner IV','nrowe@gmail.com','WOULD put their heads down! I am very tired of being all alone here!\' As she said to the shore.',NULL,'18',18.42,4,73.68,73.68,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(19,'ZRMFFEQH9NLF','78ca1907-6382-4551-aab9-4d7378b8e357',2,'Mobile World Congress',18.42,31,1,'Aracely Hammes Sr.','reichel.larissa@hotmail.com','I don\'t care which happens!\' She ate a little nervous about this; \'for it might tell her something.',NULL,'19',18.42,4,73.68,73.68,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53'),(20,'MSHRHXWWCNDT','672cd992-80ea-413b-baa9-65e9de8991ce',2,'Mobile World Congress',18.42,15,1,'Marietta Beatty PhD','hprohaska@gmail.com','Mock Turtle: \'why, if a fish came to ME, and told me you had been jumping about like mad things.',NULL,'20',18.42,2,36.84,36.84,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(21,'XDLDTZTTEYYH','86716044-7149-47bd-97f8-615e29883ec1',3,'Google I/O',6.98,16,1,'Mr. Vincent Halvorson V','gmarvin@damore.com','Alice, looking down with one eye; \'I seem to encourage the witness at all: he kept shifting from.',NULL,'21',6.98,3,20.94,20.94,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(22,'WHMEX8ZKXMTC','d62af4d0-bad9-4812-9ba3-48454e2a8ccb',3,'Google I/O',6.98,31,1,'Aracely Hammes Sr.','reichel.larissa@hotmail.com','Hatter. \'It isn\'t mine,\' said the Mock Turtle sang this, very slowly and sadly:-- \'\"Will you walk.',NULL,'22',6.98,5,34.90,34.90,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(23,'AM0KE1BYZOWE','4db911ff-6365-4bac-84c9-b64ceae36153',3,'Google I/O',6.98,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','Let me think: was I the same thing as a cushion, resting their elbows on it, and very soon came to.',NULL,'23',6.98,4,27.92,27.92,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(24,'PSYV7NWEJGCP','5d580cb1-a697-4590-878d-6ffd0f280b01',3,'Google I/O',6.98,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','Alice, \'as all the party went back to them, and the constant heavy sobbing of the moment they saw.',NULL,'24',6.98,1,6.98,6.98,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(25,'I2OTACGY5CZN','f77ff139-317a-4ca6-8299-62537ac77b29',3,'Google I/O',6.98,15,1,'Marietta Beatty PhD','hprohaska@gmail.com','CHORUS. \'Wow! wow! wow!\' \'Here! you may stand down,\' continued the Gryphon. \'Of course,\' the.',NULL,'25',6.98,2,13.96,13.96,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(26,'373DLCB8IFLD','905e4ac4-f234-4d85-a77c-2c485b233930',3,'Google I/O',6.98,1,1,'Laisha Bednar','customer@archielite.com','Mock Turtle. \'She can\'t explain MYSELF, I\'m afraid, but you might do something better with the.',NULL,'26',6.98,3,20.94,20.94,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(27,'ZIVYUVT5ZVHE','4da35a36-898e-4ab7-ad97-a6db9b417861',3,'Google I/O',6.98,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','Pat, what\'s that in the distance, and she tried to beat them off, and that makes them.',NULL,'27',6.98,1,6.98,6.98,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(28,'UMSENJTNKE7Q','5a203057-d05e-4479-b21f-32d0bcf9acb3',3,'Google I/O',6.98,20,1,'Arturo Boyle II','bbartell@gmail.com','WOULD not remember ever having seen such a curious feeling!\' said Alice; \'you needn\'t be afraid of.',NULL,'28',6.98,3,20.94,20.94,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(29,'HOKHBE8HZATF','7ca27924-b609-45bf-a629-ab4941ea532b',3,'Google I/O',6.98,20,1,'Arturo Boyle II','bbartell@gmail.com','Rome, and Rome--no, THAT\'S all wrong, I\'m certain! I must be removed,\' said the Dodo could not.',NULL,'29',6.98,3,20.94,20.94,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54'),(30,'AWTUHQQXWHY5','2f8e6ec7-4ac5-4ced-b0a9-646d200e351b',3,'Google I/O',6.98,6,1,'Toney Schinner IV','nrowe@gmail.com','I think?\' \'I had NOT!\' cried the Mouse, getting up and went on: \'--that begins with a large.',NULL,'30',6.98,1,6.98,6.98,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(31,'H2SRH3QZP8QB','dd544dc9-4532-4c40-84fc-f288d9de4838',4,'Apple WWDC',23.90,25,1,'Santa Boehm','tstroman@gmail.com','I\'ve finished.\' So they had at the end.\' \'If you can\'t take more.\' \'You mean you can\'t swim, can.',NULL,'31',23.90,3,71.70,71.70,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(32,'T4UCRQDQQYUC','1bf0041d-fb9a-4905-abaf-39c650bec5b2',4,'Apple WWDC',23.90,16,1,'Mr. Vincent Halvorson V','gmarvin@damore.com','My notion was that she had someone to listen to her. The Cat seemed to be Number One,\' said Alice.',NULL,'32',23.90,2,47.80,47.80,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(33,'K6Q82HXAIFUG','450eb790-21ca-4420-9b13-e033f5cab759',4,'Apple WWDC',23.90,20,1,'Arturo Boyle II','bbartell@gmail.com','Hatter was out of the sea.\' \'I couldn\'t help it,\' said Alice, very earnestly. \'I\'ve had nothing.',NULL,'33',23.90,5,119.50,119.50,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(34,'EUYFMCMENSZW','4e31b35c-9b73-4d6a-a86d-78efc7c1f0e7',4,'Apple WWDC',23.90,16,1,'Mr. Vincent Halvorson V','gmarvin@damore.com','Next came the royal children, and everybody laughed, \'Let the jury wrote it down into a graceful.',NULL,'34',23.90,1,23.90,23.90,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(35,'DSUPPKKQCTV1','d3ba7759-948f-4449-8348-2be17c9f67f4',4,'Apple WWDC',23.90,25,1,'Santa Boehm','tstroman@gmail.com','ALL RETURNED FROM HIM TO YOU,\"\' said Alice. \'Call it what you had been running half an hour or so.',NULL,'35',23.90,5,119.50,119.50,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(36,'NC5NDEWOMMUZ','0a6d82c8-f90b-49a7-b090-a1bc6ec4dd1e',4,'Apple WWDC',23.90,20,1,'Arturo Boyle II','bbartell@gmail.com','She had already heard her voice close to her daughter \'Ah, my dear! Let this be a book written.',NULL,'36',23.90,4,95.60,95.60,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(37,'FLP7NTRPNYWP','0007f4e8-04ec-4449-bf9e-5dff3e16a550',4,'Apple WWDC',23.90,11,1,'Emmitt Gislason','erna78@gmail.com','Knave was standing before them, in chains, with a trumpet in one hand and a pair of white kid.',NULL,'37',23.90,5,119.50,119.50,0.00,0.00,NULL,'pending',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(38,'SGQJXCPJ425B','17eff1bc-409a-4cbc-8fd5-8b0e4ec0b5bc',4,'Apple WWDC',23.90,1,1,'Laisha Bednar','customer@archielite.com','Mock Turtle. \'Hold your tongue, Ma!\' said the Mock Turtle Soup is made from,\' said the Dormouse.',NULL,'38',23.90,2,47.80,47.80,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(39,'MG5WF8F7AYH3','0cc3bfac-2945-4f3c-86b9-fab4ba4ea97f',4,'Apple WWDC',23.90,1,1,'Laisha Bednar','customer@archielite.com','Mock Turtle: \'crumbs would all wash off in the house down!\' said the Caterpillar contemptuously.',NULL,'39',23.90,3,71.70,71.70,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55'),(40,'KYQUWU9XHLVM','4fd376d3-0ef0-4d1b-b54d-53e1a545f334',4,'Apple WWDC',23.90,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','And so it was a very little way off, panting, with its wings. \'Serpent!\' screamed the Pigeon. \'I.',NULL,'40',23.90,1,23.90,23.90,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(41,'RWAHXDNMIREB','ecc041f5-6f51-43b4-991e-9f00ad14c094',5,'AWS re:Invent',17.02,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','Alice replied thoughtfully. \'They have their tails in their proper places--ALL,\' he repeated with.',NULL,'41',17.02,1,17.02,17.02,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(42,'MSALKTB9QR3V','c210389b-1a54-4832-893f-0b8065710ffe',5,'AWS re:Invent',17.02,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','But her sister sat still just as she could. \'The Dormouse is asleep again,\' said the Pigeon. \'I.',NULL,'42',17.02,4,68.08,68.08,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(43,'B6FOVNXUB9VB','7d99f1bb-bc8e-4974-bd52-344400a4a95d',5,'AWS re:Invent',17.02,15,1,'Marietta Beatty PhD','hprohaska@gmail.com','NOT marked \'poison,\' so Alice ventured to say. \'What is his sorrow?\' she asked the Gryphon, half.',NULL,'43',17.02,1,17.02,17.02,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(44,'FFGCCN267AB5','f1d025ff-e1f5-4293-87fd-1d98c4043072',5,'AWS re:Invent',17.02,18,1,'Mr. Waldo Sporer V','purdy.velva@schmeler.com','White Rabbit cried out, \'Silence in the wood, \'is to grow larger again, and that\'s all you know.',NULL,'44',17.02,3,51.06,51.06,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(45,'YBI1EFO43S03','3ff4c607-22bd-4a3c-81a5-d3c5e71c16bf',5,'AWS re:Invent',17.02,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','Come on!\' \'Everybody says \"come on!\" here,\' thought Alice, as she could. The next thing is, to get.',NULL,'45',17.02,1,17.02,17.02,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(46,'P7HSXP26AREH','ff94b698-460e-434d-9cb1-8a234ca8c733',5,'AWS re:Invent',17.02,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','After a while, finding that nothing more happened, she decided on going into the teapot. \'At any.',NULL,'46',17.02,1,17.02,17.02,0.00,0.00,NULL,'refunded',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(47,'NYN5MDPVVSLO','34fbf4d9-7488-4574-9672-a2639cba7148',5,'AWS re:Invent',17.02,28,1,'Prof. Arely Koch','johnson.mona@turner.biz','And yet you incessantly stand on their faces, and the fall NEVER come to the Dormouse, and.',NULL,'47',17.02,1,17.02,17.02,0.00,0.00,NULL,'cancelled',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(48,'SQWXPMGPBPYH','e7ea5407-0b33-457f-8f56-64f3f4772c0f',5,'AWS re:Invent',17.02,6,1,'Toney Schinner IV','nrowe@gmail.com','Alice; \'I can\'t explain MYSELF, I\'m afraid, but you might knock, and I shall only look up and.',NULL,'48',17.02,3,51.06,51.06,0.00,0.00,NULL,'completed',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(49,'JAQ1636PBCP5','d2c55d4c-10ec-4b6c-be85-e2034f64aaeb',5,'AWS re:Invent',17.02,11,1,'Emmitt Gislason','erna78@gmail.com','I don\'t remember where.\' \'Well, it must make me giddy.\' And then, turning to Alice, flinging the.',NULL,'49',17.02,3,51.06,51.06,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56'),(50,'NFBXKVCOVG0N','86d706bd-d6c3-4659-a368-82f4f00f3e4b',5,'AWS re:Invent',17.02,16,1,'Mr. Vincent Halvorson V','gmarvin@damore.com','Alice, \'as all the way wherever she wanted to send the hedgehog had unrolled itself, and was a.',NULL,'50',17.02,5,85.10,85.10,0.00,0.00,NULL,'processing',NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'UP5SSLBTCVO7','Darrin Wolff III','pmacejkovic@toy.org','0841989151','She hastily put down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go.',NULL,'pending','2025-05-03 11:32:52','2025-05-03 11:32:52'),(2,1,'SCNZDA0PEFTN','Jayde Doyle','kkoss@gmail.com','0444991794','Alice, a little shriek, and went stamping about, and crept a little pattering of footsteps in the.',NULL,'checked_in','2025-05-03 11:32:52','2025-05-03 11:32:52'),(3,1,'V3AU67VTMXVR','Miss Dandre Trantow','juston31@schultz.com','0038501415','I should think you\'ll feel it a bit, if you only kept on puzzling about it just grazed his nose.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(4,1,'APG277YFKLWU','Reanna Cremin','hadley76@gmail.com','0377241638','XI. Who Stole the Tarts? The King laid his hand upon her face. \'Wake up, Alice dear!\' said her.',NULL,'transferred','2025-05-03 11:32:52','2025-05-03 11:32:52'),(5,1,'2FLSCYWOWXYQ','Dr. Yazmin O\'Connell DVM','dessie.schuster@nader.com','0636008098','Alice. \'And be quick about it,\' said Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon in.',NULL,'refunded','2025-05-03 11:32:52','2025-05-03 11:32:52'),(6,1,'TWERVQRKVTHV','Dr. Guiseppe Reichel DVM','schowalter.keaton@zboncak.org','0795876020','It\'s high time to avoid shrinking away altogether. \'That WAS a curious dream!\' said Alice, \'I\'ve.',NULL,'pending','2025-05-03 11:32:52','2025-05-03 11:32:52'),(7,2,'IAHLEQNLQVO1','Manuela Hartmann','bogan.barton@hotmail.com','0981683077','I don\'t remember where.\' \'Well, it must be getting somewhere near the King sharply. \'Do you know.',NULL,'checked_in','2025-05-03 11:32:52','2025-05-03 11:32:52'),(8,2,'18HU5IODIFLC','Marianna Skiles','ofadel@gmail.com','0371754197','Mock Turtle. \'Certainly not!\' said Alice more boldly: \'you know you\'re growing too.\' \'Yes, but I.',NULL,'transferred','2025-05-03 11:32:52','2025-05-03 11:32:52'),(9,2,'OBLXW4W3MKSZ','Mrs. Margot Schimmel','bauch.richmond@gmail.com','0775793637','Alice was only the pepper that had made her draw back in a louder tone. \'ARE you to learn?\' \'Well.',NULL,'cancelled','2025-05-03 11:32:52','2025-05-03 11:32:52'),(10,3,'XL7HFNVG2BSU','Dr. Waldo Labadie','domenica26@gmail.com','0001917539','And he got up in such confusion that she remained the same when I got up this morning? I almost.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(11,3,'TPSBBU2ZYSP4','Michelle Weber','lsipes@yahoo.com','0141409160','I\'ve got to the shore. CHAPTER III. A Caucus-Race and a piece of it had come to the cur, \"Such a.',NULL,'pending','2025-05-03 11:32:52','2025-05-03 11:32:52'),(12,3,'KE0GCN0N05XG','Osborne Cole','ohara.cooper@gmail.com','0842022132','Nile On every golden scale! \'How cheerfully he seems to like her, down here, and I\'m sure _I_.',NULL,'transferred','2025-05-03 11:32:52','2025-05-03 11:32:52'),(13,4,'EGZADWPXZ9ML','Mrs. Deja Schuppe PhD','ratke.oliver@yahoo.com','0260075525','They all sat down a jar from one minute to another! However, I\'ve got to the Knave. The Knave did.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(14,4,'CKGXVTOSXRPS','Sherwood Emard','angie.botsford@stamm.com','0752437406','Dinah, tell me who YOU are, first.\' \'Why?\' said the Hatter. \'He won\'t stand beating. Now, if you.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(15,4,'FAUMB6GX54T3','Prof. Christa Schmitt','lucas62@donnelly.com','0798956569','Duchess and the other two were using it as well as if a fish came to ME, and told me he was gone.',NULL,'cancelled','2025-05-03 11:32:52','2025-05-03 11:32:52'),(16,4,'DZFPHJV4S0OG','Aditya Block IV','weldon.steuber@huel.com','0073930186','Alice started to her usual height. It was all dark overhead; before her was another puzzling.',NULL,'refunded','2025-05-03 11:32:52','2025-05-03 11:32:52'),(17,4,'4Z7EEB0NIV3H','Betty Macejkovic','davon38@hotmail.com','0792348875','Alice, quite forgetting in the newspapers, at the mushroom for a baby: altogether Alice did not.',NULL,'pending','2025-05-03 11:32:52','2025-05-03 11:32:52'),(18,5,'JRNTPPFWVSI5','Tina Wolf','laverna71@beer.com','0227619369','AND WASHING--extra.\"\' \'You couldn\'t have wanted it much,\' said the Lory positively refused to tell.',NULL,'checked_in','2025-05-03 11:32:52','2025-05-03 11:32:52'),(19,5,'V22KN4MGENNK','Piper Thiel','auer.tiara@gmail.com','0527914047','Lory, with a great letter, nearly as she could remember them, all these strange Adventures of hers.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(20,5,'WAUJESJ0OBUS','Mrs. Myrna Sanford Sr.','don.jacobi@hilpert.com','0517449400','White Rabbit as he spoke. \'A cat may look at the moment, \'My dear! I wish you could manage it?).',NULL,'refunded','2025-05-03 11:32:52','2025-05-03 11:32:52'),(21,5,'I8NBC4EB0NBA','Monserrat Johns','janelle27@yahoo.com','0208644339','Alice; \'living at the top of her sister, who was gently brushing away some dead leaves that had.',NULL,'reserved','2025-05-03 11:32:52','2025-05-03 11:32:52'),(22,5,'FDW2IVBGEOV5','Prof. Ernesto Watsica MD','glenda.okuneva@yahoo.com','0057364481','Alice, every now and then dipped suddenly down, so suddenly that Alice had no idea what a Gryphon.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(23,5,'FEHBHZXUV0PF','Sister Deckow','zbrown@watsica.net','0105755728','King. \'When did you manage to do so. \'Shall we try another figure of the evening, beautiful Soup!.',NULL,'cancelled','2025-05-03 11:32:52','2025-05-03 11:32:52'),(24,6,'ZFBOP9HZKIB4','Milford Upton','rubie.lang@yahoo.com','0877134479','They all returned from him to you, Though they were filled with cupboards and book-shelves; here.',NULL,'cancelled','2025-05-03 11:32:52','2025-05-03 11:32:52'),(25,6,'IXQLIV2B2L9G','Florine Schinner','vschuster@jakubowski.com','0492635979','The first witness was the Hatter. \'Nor I,\' said the Pigeon; \'but if they do, why then they\'re a.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(26,6,'PUCKCMVNYLAC','Josephine Kuvalis Sr.','kira68@stroman.org','0318985928','MINE.\' The Queen turned crimson with fury, and, after waiting till she had made her so savage when.',NULL,'checked_in','2025-05-03 11:32:52','2025-05-03 11:32:52'),(27,6,'TDWMGESAMNDI','Alvena Torphy','karson63@yahoo.com','0809120644','I can\'t show it you myself,\' the Mock Turtle to the table, half hoping that the Queen to play.',NULL,'cancelled','2025-05-03 11:32:52','2025-05-03 11:32:52'),(28,6,'EFTGDIQ6OHTN','Javonte Quitzon','mcclure.jana@hotmail.com','0521183695','The Dormouse slowly opened his eyes were looking over his shoulder as she leant against a.',NULL,'transferred','2025-05-03 11:32:52','2025-05-03 11:32:52'),(29,6,'YH7EUS9ME9UQ','Mitchell Bailey','derek95@hotmail.com','0814043860','Alice as she did not quite like the look of it in time,\' said the Gryphon: \'I went to school in.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(30,7,'WRYSGPDEKCXE','Mr. Ryder Wiza DVM','jarred27@abbott.info','0593553424','And oh, my poor little thing was waving its right ear and left foot, so as to prevent its undoing.',NULL,'refunded','2025-05-03 11:32:52','2025-05-03 11:32:52'),(31,7,'FUU72LIUKDJM','Jonas Leuschke','margaretta99@gmail.com','0353519300','King triumphantly, pointing to the door, she walked off, leaving Alice alone with the.',NULL,'refunded','2025-05-03 11:32:52','2025-05-03 11:32:52'),(32,7,'4WS6H06OOJ44','Queenie Marks','heath46@mosciski.biz','0342366135','Let me see: that would happen: \'\"Miss Alice! Come here directly, and get ready to make it stop.',NULL,'purchased','2025-05-03 11:32:52','2025-05-03 11:32:52'),(33,8,'QINJYZKFQVAJ','Gustave Keeling','antonina.koch@altenwerth.com','0398934029','Latitude was, or Longitude I\'ve got to see its meaning. \'And just as usual. \'Come, there\'s half my.',NULL,'pending','2025-05-03 11:32:52','2025-05-03 11:32:52'),(34,8,'RSB0ZTGDG26H','Mr. Dallas Hammes','gusikowski.dorcas@buckridge.com','0429266189','For some minutes the whole pack rose up into the court, by the Hatter, \'I cut some more tea,\' the.',NULL,'cancelled','2025-05-03 11:32:52','2025-05-03 11:32:52'),(35,8,'RYRGGPJMSTRZ','Gust Schowalter','okohler@bernhard.org','0593200739','Gryphon, and the little door, so she went round the neck of the singers in the direction in which.',NULL,'reserved','2025-05-03 11:32:52','2025-05-03 11:32:52'),(36,8,'HU7ADGQSYATN','Dr. Monroe Hane IV','webster03@gmail.com','0470988791','Hatter trembled so, that he shook both his shoes off. \'Give your evidence,\' the King triumphantly.',NULL,'refunded','2025-05-03 11:32:52','2025-05-03 11:32:52'),(37,8,'QN9KBUCQVHC7','Mabelle Lebsack','orlando.mante@yahoo.com','0958021047','Alice thoughtfully: \'but then--I shouldn\'t be hungry for it, she found she could not tell whether.',NULL,'pending','2025-05-03 11:32:52','2025-05-03 11:32:52'),(38,8,'LZX5WIPDTSG1','Mr. Bill O\'Connell','mmccullough@gmail.com','0207696330','This seemed to be two people! Why, there\'s hardly enough of it at all; however, she waited.',NULL,'reserved','2025-05-03 11:32:52','2025-05-03 11:32:52'),(39,9,'OC1MOFEGGTP3','Alva Kemmer','lueilwitz.harmony@morissette.com','0387684014','YOU, and no more to do this, so that it had made. \'He took me for a minute, nurse! But I\'ve got.',NULL,'refunded','2025-05-03 11:32:52','2025-05-03 11:32:52'),(40,9,'G68UPEJLV3WB','Robyn Kling','cornell49@kuhlman.com','0415501271','Alice. \'Come on, then,\' said Alice, always ready to agree to everything that was linked into hers.',NULL,'reserved','2025-05-03 11:32:52','2025-05-03 11:32:52'),(41,9,'NEAQCURPAGIX','Briana Fadel','lori.stroman@gmail.com','0297908032','Dormouse shall!\' they both cried. \'Wake up, Dormouse!\' And they pinched it on both sides of it.',NULL,'reserved','2025-05-03 11:32:52','2025-05-03 11:32:52'),(42,9,'PIH7DNVPYIX8','Alden McDermott','herman.berta@grady.com','0476131728','I\'d only been the whiting,\' said the Hatter; \'so I can\'t see you?\' She was looking for it, he was.',NULL,'pending','2025-05-03 11:32:52','2025-05-03 11:32:52'),(43,9,'367KQH5OVZBG','Mrs. Ernestina McClure Jr.','kohler.mose@gmail.com','0283671016','Would not, could not taste theirs, and the jury asked. \'That I can\'t see you?\' She was close.',NULL,'cancelled','2025-05-03 11:32:52','2025-05-03 11:32:52'),(44,10,'OBISCCMAVB9M','Dr. Dedrick Gerhold Sr.','jovanny48@hotmail.com','0126556706','It sounded an excellent opportunity for making her escape; so she began fancying the sort of idea.',NULL,'checked_in','2025-05-03 11:32:53','2025-05-03 11:32:53'),(45,10,'0DTUH1UUYOCU','Maximillian Zemlak','tyler39@hotmail.com','0212699433','Caterpillar. \'Not QUITE right, I\'m afraid,\' said Alice, surprised at this, that she ought to be.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(46,10,'YWXQBMJEFW1L','Lyda Rolfson','carroll29@yahoo.com','0997638697','Alice to herself. At this moment Five, who had followed him into the air, I\'m afraid, sir\' said.',NULL,'reserved','2025-05-03 11:32:53','2025-05-03 11:32:53'),(47,10,'LH4MBFYVBGAC','Ross Cummings','lpfeffer@botsford.net','0751851989','The Cat seemed to be in a whisper, half afraid that it signifies much,\' she said to a mouse: she.',NULL,'checked_in','2025-05-03 11:32:53','2025-05-03 11:32:53'),(48,10,'9RBAJAMPODEB','Bridgette Rath MD','shaun33@jacobi.com','0946208465','King say in a whisper.) \'That would be quite absurd for her to carry it further. So she called.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(49,11,'B8O427Z4K817','Margaretta Hickle','monte.becker@gmail.com','0786640671','What happened to me! When I used to know. Let me think: was I the same as the whole court was a.',NULL,'pending','2025-05-03 11:32:53','2025-05-03 11:32:53'),(50,11,'FVFAMALZDALY','Miss Alize Runte','glennie22@stamm.org','0476722252','Pigeon the opportunity of saying to herself, for this curious child was very likely it can be,\'.',NULL,'pending','2025-05-03 11:32:53','2025-05-03 11:32:53'),(51,11,'BXDDNSVOJUHD','Prof. Carmine Rolfson IV','towne.alexandra@mann.com','0253653601','Latitude was, or Longitude either, but thought they were nice grand words to say.) Presently she.',NULL,'refunded','2025-05-03 11:32:53','2025-05-03 11:32:53'),(52,12,'BDALOCEMYU8S','Nettie Wyman','jennings.breitenberg@carter.com','0500710922','Queen, and in a deep, hollow tone: \'sit down, both of you, and don\'t speak a word till I\'ve.',NULL,'purchased','2025-05-03 11:32:53','2025-05-03 11:32:53'),(53,12,'TUBC414ZH6UM','Dave Schiller Sr.','brett.skiles@yahoo.com','0644011623','Alice. \'Come on, then,\' said the Duchess; \'and the moral of that is--\"Birds of a well--\' \'What did.',NULL,'refunded','2025-05-03 11:32:53','2025-05-03 11:32:53'),(54,12,'FIBVDHZEFAYO','Theron Leannon II','skye79@hotmail.com','0202313338','King, and he went on \'And how do you know why it\'s called a whiting?\' \'I never was so much.',NULL,'purchased','2025-05-03 11:32:53','2025-05-03 11:32:53'),(55,13,'MYDK5V98MLY4','Bailey Gutkowski IV','mckenzie.daisy@gmail.com','0366144770','Alice took up the conversation a little. \'\'Tis so,\' said Alice. \'Why, SHE,\' said the King. \'Then.',NULL,'reserved','2025-05-03 11:32:53','2025-05-03 11:32:53'),(56,13,'MGWBGV8JXCBL','Prof. Rollin Cruickshank','luigi.koelpin@hotmail.com','0414689253','This question the Dodo solemnly, rising to its feet, ran round the neck of the song. \'What trial.',NULL,'refunded','2025-05-03 11:32:53','2025-05-03 11:32:53'),(57,13,'OXKNAXXHDMHZ','Barney Fay','katelyn26@schmitt.com','0970586670','March Hare will be much the same tone, exactly as if she had plenty of time as she could. \'The.',NULL,'pending','2025-05-03 11:32:53','2025-05-03 11:32:53'),(58,13,'X0Q04L6IOIBV','Marvin Grady Jr.','donald.lesch@hotmail.com','0485218676','Duchess, as she went on so long since she had been to her, \'if we had the door of the treat. When.',NULL,'checked_in','2025-05-03 11:32:53','2025-05-03 11:32:53'),(59,14,'MBJMRMUACQWZ','Tremayne Will','walker.roxane@fahey.com','0263405997','When the pie was all dark overhead; before her was another puzzling question; and as it spoke. \'As.',NULL,'transferred','2025-05-03 11:32:53','2025-05-03 11:32:53'),(60,14,'G5DDBT4KAV3F','Adelle Ortiz','pfannerstill.ola@hotmail.com','0006697669','Gryphon. \'Do you take me for his housemaid,\' she said to herself how she would manage it. \'They.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(61,14,'GA4EBIXDER7D','Ines Schultz IV','nader.emmanuel@hotmail.com','0016149061','Alice said very politely, feeling quite pleased to have got in as well,\' the Hatter with a table.',NULL,'checked_in','2025-05-03 11:32:53','2025-05-03 11:32:53'),(62,14,'AOZX93CNHFAJ','Stephanie Ruecker','sawayn.vella@ernser.net','0019576556','I\'m a deal too far off to the executioner: \'fetch her here.\' And the Gryphon answered, very nearly.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(63,14,'OGIPKL8CY1QK','Mrs. Agustina Spencer DDS','elisabeth.bradtke@yahoo.com','0495562238','Gryphon is, look at all what had become of it; then Alice, thinking it was a different person.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(64,15,'IQJV7FOHHOGL','Emerald Franecki','calista27@bechtelar.org','0325392709','I believe.\' \'Boots and shoes under the circumstances. There was no time she\'d have everybody.',NULL,'transferred','2025-05-03 11:32:53','2025-05-03 11:32:53'),(65,15,'NLHMLYQGV9DR','Dayna Zemlak','juston03@weber.net','0172780718','Gryphon. \'I mean, what makes them bitter--and--and barley-sugar and such things that make children.',NULL,'purchased','2025-05-03 11:32:53','2025-05-03 11:32:53'),(66,15,'TVFK5QU54S9E','Odessa West','manuela92@hermann.com','0605976537','He looked at it, and kept doubling itself up and went on muttering over the fire, licking her paws.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(67,15,'TPFXLYH3ZGRO','Sydnie Jerde','lesley.kirlin@hotmail.com','0862591588','HIS time of life. The King\'s argument was, that you never even spoke to Time!\' \'Perhaps not,\'.',NULL,'transferred','2025-05-03 11:32:53','2025-05-03 11:32:53'),(68,15,'NG0A29ZCUCYL','Mr. Chandler Berge Jr.','zhand@walsh.info','0385331734','Dodo replied very gravely. \'What else had you to offer it,\' said the Cat, \'or you wouldn\'t squeeze.',NULL,'purchased','2025-05-03 11:32:53','2025-05-03 11:32:53'),(69,15,'EQQCEP32NLGM','Uriel Crona','hwilderman@gmail.com','0174716375','I suppose.\' So she was peering about anxiously among the leaves, which she had finished, her.',NULL,'reserved','2025-05-03 11:32:53','2025-05-03 11:32:53'),(70,16,'XX9UP5XGCLZQ','Philip Schulist','terrence.prosacco@yahoo.com','0148451327','The Mouse looked at her feet as the hall was very fond of beheading people here; the great hall.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(71,16,'ION4R51OFAHW','Celestine Veum','ealtenwerth@renner.com','0213160841','I didn\'t know that Cheshire cats always grinned; in fact, a sort of lullaby to it as to the little.',NULL,'refunded','2025-05-03 11:32:53','2025-05-03 11:32:53'),(72,16,'NMD4D7J6VRNW','Prof. Raven Nicolas','emmanuelle86@hotmail.com','0950527663','Alice again, in a hoarse, feeble voice: \'I heard the Rabbit coming to look at the end of trials.',NULL,'purchased','2025-05-03 11:32:53','2025-05-03 11:32:53'),(73,17,'VEVWONMG5WFE','Ashlee Bernhard','hbarton@gmail.com','0124210640','Dodo, a Lory and an Eaglet, and several other curious creatures. Alice led the way, and the three.',NULL,'reserved','2025-05-03 11:32:53','2025-05-03 11:32:53'),(74,17,'UKSNEYECYKN6','Owen Connelly','rleannon@gmail.com','0320101930','The Dormouse again took a great deal to come out among the party. Some of the what?\' said the.',NULL,'purchased','2025-05-03 11:32:53','2025-05-03 11:32:53'),(75,17,'J1BXM8XYSSOR','Cyrus Howe','bbernhard@yahoo.com','0463497648','The players all played at once to eat the comfits: this caused some noise and confusion, as the.',NULL,'checked_in','2025-05-03 11:32:53','2025-05-03 11:32:53'),(76,17,'QCV8HHCRUS55','Ms. Ada Hill','prosacco.billie@stroman.org','0665635012','Gryphon, and the poor little juror (it was exactly one a-piece all round. (It was this last word.',NULL,'reserved','2025-05-03 11:32:53','2025-05-03 11:32:53'),(77,18,'FTX7QANW6DTC','Mrs. Carrie Volkman','jazlyn.bergnaum@ryan.com','0458256921','Duchess to play croquet with the other side of the court and got behind him, and said to itself.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(78,18,'J9RR6PFZCQAK','Sydnee Cruickshank','zheller@glover.com','0723403773','I like\"!\' \'You might just as she went out, but it said in a pleased tone. \'Pray don\'t trouble.',NULL,'purchased','2025-05-03 11:32:53','2025-05-03 11:32:53'),(79,18,'PGOREE3WVCNA','Leanna Windler Sr.','mccullough.myrtice@gmail.com','0867297047','Alice, rather doubtfully, as she could, \'If you didn\'t like cats.\' \'Not like cats!\' cried the.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(80,18,'1CCSPDIIJVUP','Cristian Feest','agnes.erdman@bruen.com','0999295246','Mercia and Northumbria, declared for him: and even Stigand, the patriotic archbishop of.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(81,18,'BRCU76QW8EOK','Kip Rempel','eharber@yahoo.com','0642483248','They are waiting on the breeze that followed them, the melancholy words:-- \'Soo--oop of the.',NULL,'transferred','2025-05-03 11:32:53','2025-05-03 11:32:53'),(82,19,'3HJG7QRTENKN','Freda Spinka MD','ezieme@yahoo.com','0509711775','Lobster; I heard him declare, \"You have baked me too brown, I must go and live in that soup!\'.',NULL,'refunded','2025-05-03 11:32:53','2025-05-03 11:32:53'),(83,19,'AETN1FC0PRGJ','Emilia Walter','sheila.conroy@hermiston.com','0908406985','Two. Two began in a minute, while Alice thought the whole pack rose up into a butterfly, I should.',NULL,'cancelled','2025-05-03 11:32:53','2025-05-03 11:32:53'),(84,19,'QB5FKUOVOIMG','Maximo Brekke Jr.','kade.berge@hotmail.com','0474281372','Oh, I shouldn\'t like THAT!\' \'Oh, you can\'t help it,\' said the King, and he went on again:-- \'I.',NULL,'reserved','2025-05-03 11:32:53','2025-05-03 11:32:53'),(85,19,'TEOLLDU3JCG5','Dorothy Reichert','chet21@gmail.com','0403342786','I do!\' said Alice doubtfully: \'it means--to--make--anything--prettier.\' \'Well, then,\' the Gryphon.',NULL,'pending','2025-05-03 11:32:53','2025-05-03 11:32:53'),(86,19,'K6OGJ9LSDFTR','Cecile O\'Reilly','austyn.abernathy@streich.info','0533361029','Queen. \'You make me larger, it must be getting somewhere near the looking-glass. There was exactly.',NULL,'pending','2025-05-03 11:32:53','2025-05-03 11:32:53'),(87,20,'NZ5Y61GAZZAC','Brandy Kunde','gwalter@schaden.com','0914596321','White Rabbit interrupted: \'UNimportant, your Majesty means, of course,\' said the youth, \'as I.',NULL,'checked_in','2025-05-03 11:32:54','2025-05-03 11:32:54'),(88,20,'EFFIUQNL3QMS','Madonna Erdman','raina.wilkinson@yahoo.com','0590675305','Mock Turtle in a great hurry; \'this paper has just been reading about; and when she had never been.',NULL,'refunded','2025-05-03 11:32:54','2025-05-03 11:32:54'),(89,20,'3JCA1HJX9FXR','Bo Kub','iryan@russel.info','0504669382','That he met in the same thing with you,\' said the Queen, who was beginning to grow up again! Let.',NULL,'refunded','2025-05-03 11:32:54','2025-05-03 11:32:54'),(90,21,'HVCO78MQBDCP','Ernesto Jerde','parisian.neha@shanahan.net','0473250643','Besides, SHE\'S she, and I\'m sure I don\'t keep the same age as herself, to see it quite plainly.',NULL,'purchased','2025-05-03 11:32:54','2025-05-03 11:32:54'),(91,21,'JLKQL7UAL2YY','Mr. Tyrell Haley DDS','eva.kuphal@padberg.com','0302491457','I THINK I can kick a little!\' She drew her foot as far down the chimney close above her: then.',NULL,'checked_in','2025-05-03 11:32:54','2025-05-03 11:32:54'),(92,21,'YH2USJH8UX0I','Miss Eda Jast I','egreenfelder@mcclure.com','0329495001','YOU must cross-examine the next witness.\' And he added looking angrily at the cook, to see its.',NULL,'refunded','2025-05-03 11:32:54','2025-05-03 11:32:54'),(93,21,'3IM1PNQ9ASUX','Gisselle McKenzie II','omari.rippin@gmail.com','0018865581','I do hope it\'ll make me giddy.\' And then, turning to Alice: he had taken advantage of the evening.',NULL,'reserved','2025-05-03 11:32:54','2025-05-03 11:32:54'),(94,22,'AXBACIU31GNM','Jameson Reilly DVM','hanna99@hotmail.com','0148686596','I THINK; or is it I can\'t remember,\' said the Dodo, \'the best way you can;--but I must be.',NULL,'cancelled','2025-05-03 11:32:54','2025-05-03 11:32:54'),(95,22,'ZTZOQW0SKXA9','Yasmine Gerlach','francesco.bednar@emmerich.info','0205887697','Mock Turtle recovered his voice, and, with tears running down his brush, and had to do this, so.',NULL,'cancelled','2025-05-03 11:32:54','2025-05-03 11:32:54'),(96,22,'SU9BMZ0W2A2E','Tracey Kuhic','rdach@gmail.com','0945060803','Alice said very politely, \'for I never knew so much about a foot high: then she walked sadly down.',NULL,'purchased','2025-05-03 11:32:54','2025-05-03 11:32:54'),(97,22,'JVPREHDCN9N3','Mrs. Cecelia D\'Amore Sr.','ebert.amy@hotmail.com','0205177218','March Hare was said to Alice; and Alice thought she had never had to stoop to save her neck kept.',NULL,'pending','2025-05-03 11:32:54','2025-05-03 11:32:54'),(98,22,'DT4OCEU09L6F','Ethan Vandervort','msipes@feil.net','0038052854','Alice, seriously, \'I\'ll have nothing more happened, she decided on going into the sky. Alice went.',NULL,'cancelled','2025-05-03 11:32:54','2025-05-03 11:32:54'),(99,22,'TIWRFBIRTXNM','Toby Ward','evert68@grady.com','0470214481','The Mouse did not like the three gardeners, oblong and flat, with their heads!\' and the baby.',NULL,'purchased','2025-05-03 11:32:54','2025-05-03 11:32:54'),(100,23,'PCJKQH75QG8K','Prof. Leola Langosh II','eparisian@yahoo.com','0950252341','Alice. \'Now we shall have to fly; and the King repeated angrily, \'or I\'ll have you executed.\' The.',NULL,'cancelled','2025-05-03 11:32:54','2025-05-03 11:32:54'),(101,23,'DY79VGGB1SHY','Josh Krajcik I','schamberger.priscilla@prosacco.com','0712884581','There was a most extraordinary noise going on between the executioner, the King, \'or I\'ll have you.',NULL,'pending','2025-05-03 11:32:54','2025-05-03 11:32:54'),(102,23,'DOZ3THF9KUML','Miss Enola Barton','bosinski@stroman.net','0742304768','Alice felt a little of her or of anything to put down her anger as well as I do,\' said Alice.',NULL,'purchased','2025-05-03 11:32:54','2025-05-03 11:32:54'),(103,23,'7G65KVOBNGXE','Barrett Kulas','richard.howe@gmail.com','0271208542','And the Eaglet bent down its head down, and the March Hare. \'Sixteenth,\' added the Dormouse.',NULL,'checked_in','2025-05-03 11:32:54','2025-05-03 11:32:54'),(104,23,'O9G0V1TE9OB5','Issac Emmerich MD','eugene.kuhlman@gmail.com','0665876080','I gave her one, they gave him two, You gave us three or more; They all sat down at them, and just.',NULL,'pending','2025-05-03 11:32:54','2025-05-03 11:32:54'),(105,24,'1V3HKD36TKU0','Koby Treutel','alanis.lakin@sipes.net','0669455453','King say in a very curious to see if he doesn\'t begin.\' But she waited patiently. \'Once,\' said the.',NULL,'refunded','2025-05-03 11:32:54','2025-05-03 11:32:54'),(106,24,'XRAIFJLWRGO7','Andres Schuster','lockman.ariane@murazik.com','0152457532','Alice remarked. \'Oh, you can\'t think! And oh, my poor hands, how is it directed to?\' said the.',NULL,'cancelled','2025-05-03 11:32:54','2025-05-03 11:32:54'),(107,25,'OISYSYBMTB9X','Mr. Thomas Doyle','golden48@hotmail.com','0264326059','SHE, of course,\' he said do. Alice looked up, and there stood the Queen had only one who got any.',NULL,'pending','2025-05-03 11:32:54','2025-05-03 11:32:54'),(108,25,'DOEBJBJVP1RV','Sylvia Ebert','edgardo90@hotmail.com','0619923272','Lizard, who seemed to quiver all over their heads. She felt very glad to get out again. Suddenly.',NULL,'checked_in','2025-05-03 11:32:54','2025-05-03 11:32:54'),(109,25,'FXIETTKJY0V6','Adalberto Hintz','merlin.wolf@yahoo.com','0139843365','COULD grin.\' \'They all can,\' said the Gryphon. Alice did not dare to laugh; and, as the large.',NULL,'checked_in','2025-05-03 11:32:54','2025-05-03 11:32:54'),(110,26,'CKQ5WRMYXAMW','Marian Ebert','darryl13@wuckert.org','0253300789','King repeated angrily, \'or I\'ll have you executed on the ground near the right thing to get us dry.',NULL,'refunded','2025-05-03 11:32:54','2025-05-03 11:32:54'),(111,26,'MORWQHXHTYU3','Ms. Kaela Bahringer','gerhold.carmine@yahoo.com','0460596190','King, \'and don\'t look at me like that!\' said Alice aloud, addressing nobody in particular. \'She\'d.',NULL,'reserved','2025-05-03 11:32:54','2025-05-03 11:32:54'),(112,26,'OQVXTKMAO85W','Eric Johns','bergstrom.alanis@hotmail.com','0110613703','Alice did not see anything that looked like the look of things at all, at all!\' \'Do as I tell.',NULL,'cancelled','2025-05-03 11:32:54','2025-05-03 11:32:54'),(113,26,'K8YPFUY1CKR1','Candace Hagenes','jacky85@yahoo.com','0198301520','Then it got down off the top of her age knew the meaning of half those long words, and, what\'s.',NULL,'refunded','2025-05-03 11:32:54','2025-05-03 11:32:54'),(114,27,'QNGHVCNCTSX8','Zechariah Wolff','riley.ullrich@emmerich.com','0147907432','But she did not wish to offend the Dormouse shall!\' they both bowed low, and their slates and.',NULL,'cancelled','2025-05-03 11:32:54','2025-05-03 11:32:54'),(115,27,'RSWUH4VCI0CI','Dr. Flo Jacobi','breitenberg.cornelius@gmail.com','0115829089','It sounded an excellent opportunity for making her escape; so she went on, \'that they\'d let Dinah.',NULL,'transferred','2025-05-03 11:32:54','2025-05-03 11:32:54'),(116,28,'NXGEZUAZOKFH','Dasia Thiel DDS','wolf.norbert@reilly.net','0255972297','King. The White Rabbit hurried by--the frightened Mouse splashed his way through the neighbouring.',NULL,'transferred','2025-05-03 11:32:54','2025-05-03 11:32:54'),(117,28,'PYYKY2G014SR','Gabrielle Hoeger','claud.jaskolski@gutmann.com','0929147620','King. \'When did you do lessons?\' said Alice, \'it\'s very interesting. I never knew whether it would.',NULL,'reserved','2025-05-03 11:32:54','2025-05-03 11:32:54'),(118,28,'BUBYQIANVAIF','Gwendolyn Kautzer','devan.effertz@mraz.com','0039855028','Alice. \'You did,\' said the Caterpillar. This was not an encouraging tone. Alice looked at Alice.',NULL,'purchased','2025-05-03 11:32:54','2025-05-03 11:32:54'),(119,28,'ZDFNLSQKOF9U','Stanford Stracke','bettye.reichert@hills.com','0328667502','The Hatter opened his eyes. He looked anxiously over his shoulder with some surprise that the best.',NULL,'transferred','2025-05-03 11:32:54','2025-05-03 11:32:54'),(120,29,'OOVDUGAWDJNB','Mrs. Enola Will II','spencer.jordi@goodwin.net','0671447768','PLEASE mind what you\'re doing!\' cried Alice, jumping up in such confusion that she had.',NULL,'purchased','2025-05-03 11:32:54','2025-05-03 11:32:54'),(121,29,'RVC6U2WXMD6G','Augustine Stehr','fmosciski@predovic.info','0948228936','And in she went. Once more she found to be rude, so she waited. The Gryphon sat up and said, very.',NULL,'pending','2025-05-03 11:32:54','2025-05-03 11:32:54'),(122,29,'AVKSBBC7W2HF','Ivory Cremin','gustave.stracke@blick.com','0513842482','It was, no doubt: only Alice did not like the name: however, it only grinned a little now and.',NULL,'pending','2025-05-03 11:32:54','2025-05-03 11:32:54'),(123,29,'1SF5WPPIVXNQ','Shanie Jerde','jschimmel@yahoo.com','0158300897','Hatter. \'You MUST remember,\' remarked the King, and the pair of boots every Christmas.\' And she.',NULL,'refunded','2025-05-03 11:32:54','2025-05-03 11:32:54'),(124,30,'1WDYRPFPNPBW','Roberto Boyer','mcclure.leta@gmail.com','0215695706','GAVE HER ONE, THEY GAVE HIM TWO--\" why, that must be really offended. \'We won\'t talk about her.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(125,30,'YSPSLLVSTZDS','Mose Hodkiewicz','mervin86@carroll.com','0697688142','She felt that this could not join the dance? Will you, won\'t you join the dance. So they sat down.',NULL,'purchased','2025-05-03 11:32:55','2025-05-03 11:32:55'),(126,31,'0OWXCJZU00UE','Lambert Batz','jace.wuckert@yahoo.com','0808526738','Alice: \'I don\'t even know what you like,\' said the Queen. \'Can you play croquet with the day of.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(127,31,'97Q19IKKOSBY','Fay DuBuque','fredrick92@ratke.com','0760210496','Caterpillar The Caterpillar and Alice looked up, but it was very fond of beheading people here.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(128,31,'OO8LZWGRK6FD','Miss Ilene Strosin','macey.huel@yahoo.com','0793587591','I\'ll never go THERE again!\' said Alice to herself, \'I don\'t quite understand you,\' she said, as.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(129,31,'5RS3SBPNDOEI','Dr. Freeman Bergnaum','geoffrey11@gerhold.com','0042168051','Hatter. He had been for some minutes. The Caterpillar was the first witness,\' said the young lady.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(130,32,'3ZXA7ZB2LBGG','Dr. Wyatt Bailey Jr.','leanne29@gmail.com','0061880030','Tears \'Curiouser and curiouser!\' cried Alice (she was so large in the middle, wondering how she.',NULL,'checked_in','2025-05-03 11:32:55','2025-05-03 11:32:55'),(131,32,'IDE8BYYIYDOF','Mr. Uriel Walter III','zwill@hotmail.com','0712033803','Turn that Dormouse out of their wits!\' So she sat on, with closed eyes, and half of them--and it.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(132,32,'PYZANQBVPDT0','Helene Welch','manuel.okuneva@ryan.net','0351364509','Bill, the Lizard) could not remember ever having heard of such a curious dream, dear, certainly.',NULL,'transferred','2025-05-03 11:32:55','2025-05-03 11:32:55'),(133,33,'99UIYDCHND1S','Diana Schroeder PhD','jboyer@mohr.com','0858320223','Queen. \'I haven\'t opened it yet,\' said Alice; \'it\'s laid for a minute or two. \'They couldn\'t have.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(134,33,'8E4ACKF0WQDC','Gretchen Hermiston','zlesch@tillman.net','0138889731','Alice\'s shoulder, and it said in a low, timid voice, \'If you didn\'t sign it,\' said Alice, \'I\'ve.',NULL,'cancelled','2025-05-03 11:32:55','2025-05-03 11:32:55'),(135,33,'YVWJ7SBWUVD8','Mrs. Elna Roob I','pboehm@mraz.net','0682931149','Hardly knowing what she was appealed to by the way, and nothing seems to like her, down here, and.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(136,33,'HZULCPTQCKCV','Zander Ferry','smith.deontae@hotmail.com','0570763988','Yet you finished the first really clever thing the King said to the Gryphon. \'I mean, what makes.',NULL,'checked_in','2025-05-03 11:32:55','2025-05-03 11:32:55'),(137,33,'I5R3DDUMIBIN','Lane Anderson','dovie27@mcglynn.biz','0287345097','WHAT?\' thought Alice to herself, \'after such a capital one for catching mice--oh, I beg your.',NULL,'cancelled','2025-05-03 11:32:55','2025-05-03 11:32:55'),(138,33,'SOW34IZU08UF','Dax Koch','jacobson.raphael@kub.com','0116540331','Alice, swallowing down her anger as well wait, as she went on saying to herself, \'I wish I hadn\'t.',NULL,'checked_in','2025-05-03 11:32:55','2025-05-03 11:32:55'),(139,34,'HNSN9VTMKXRN','Prof. Kamren Bode Sr.','hipolito.cummerata@gmail.com','0862260111','And yet you incessantly stand on your shoes and stockings for you now, dears? I\'m sure _I_ shan\'t.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(140,34,'XZAUEGMY84SO','Royal Hills DVM','fcasper@yahoo.com','0520258609','I did: there\'s no meaning in them, after all. I needn\'t be afraid of interrupting him,) \'I\'ll give.',NULL,'purchased','2025-05-03 11:32:55','2025-05-03 11:32:55'),(141,35,'FWK6BYQVNKOJ','Santa Jast I','mcclure.ubaldo@sanford.info','0395644706','WOULD always get into the garden at once; but, alas for poor Alice! when she noticed that they.',NULL,'pending','2025-05-03 11:32:55','2025-05-03 11:32:55'),(142,35,'QCALNO8IHKCH','Granville Huels','meghan.balistreri@wiza.info','0694904896','Off with his head!\"\' \'How dreadfully savage!\' exclaimed Alice. \'And ever since that,\' the Hatter.',NULL,'checked_in','2025-05-03 11:32:55','2025-05-03 11:32:55'),(143,35,'TLTBMOFRX4JZ','Barney Gutmann','bernier.nikita@yahoo.com','0962779926','They are waiting on the English coast you find a pleasure in all my life!\' She had just upset the.',NULL,'purchased','2025-05-03 11:32:55','2025-05-03 11:32:55'),(144,35,'GRFKQYCPBMZG','Miss Syble Greenfelder MD','tkunde@shanahan.biz','0118579735','Down, down, down. Would the fall was over. However, when they met in the other. In the very middle.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(145,35,'1QVZRBCWCKVR','Presley Bergnaum IV','jordi39@casper.com','0489385523','HER ONE, THEY GAVE HIM TWO--\" why, that must be growing small again.\' She got up in her life.',NULL,'purchased','2025-05-03 11:32:55','2025-05-03 11:32:55'),(146,35,'XHEJY60QZQR1','Adrianna Reichert','dfeeney@reinger.com','0119262045','Duchess was VERY ugly; and secondly, because she was ready to play croquet with the strange.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(147,36,'H3VQR4HPNNYB','Benny Price','qschulist@harvey.com','0905865665','I don\'t understand. Where did they draw the treacle from?\' \'You can draw water out of the sort!\'.',NULL,'cancelled','2025-05-03 11:32:55','2025-05-03 11:32:55'),(148,36,'YAUQLMNXFGJG','Carmel Runolfsdottir','ondricka.stella@gmail.com','0408580853','The question is, what did the Dormouse sulkily remarked, \'If you do. I\'ll set Dinah at you!\' There.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(149,36,'GROVXDX1JEWD','Alicia Thiel','runte.oral@herman.com','0267428779','Alice, and looking anxiously about her. \'Oh, do let me hear the name \'Alice!\' CHAPTER XII. Alice\'s.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(150,36,'OD3PZYGM37CD','Mr. Hyman Gutmann','wilhelmine.green@gmail.com','0243771473','I\'m quite tired of being upset, and their curls got entangled together. Alice was beginning to get.',NULL,'transferred','2025-05-03 11:32:55','2025-05-03 11:32:55'),(151,36,'6QVEZQGLHSQI','Nella Mann','jermain99@hansen.com','0669730686','Rabbit asked. \'No, I didn\'t,\' said Alice: \'she\'s so extremely--\' Just then her head made her draw.',NULL,'pending','2025-05-03 11:32:55','2025-05-03 11:32:55'),(152,37,'WKDIDDJIJZSX','Prof. Jerome Waters','doyle.corine@krajcik.com','0797945635','Hatter. \'He won\'t stand beating. Now, if you were INSIDE, you might catch a bad cold if she had.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(153,37,'UXJVKACGM36L','Wanda Russel DDS','bhickle@hotmail.com','0297537074','Christmas.\' And she went on, taking first one side and up I goes like a snout than a pig, my.',NULL,'purchased','2025-05-03 11:32:55','2025-05-03 11:32:55'),(154,37,'F0GCIH2CVGUY','Myra Jacobson PhD','christ31@wehner.org','0444244763','Alice, a little bird as soon as the Lory positively refused to tell you--all I know is, it would.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(155,37,'OVL1W4D8DFW9','Kacie Kris','reilly.mraz@yahoo.com','0554285060','After a minute or two the Caterpillar seemed to listen, the whole pack rose up into the garden.',NULL,'cancelled','2025-05-03 11:32:55','2025-05-03 11:32:55'),(156,37,'WLRKQFDD2L0W','Electa Larson','claudie.ruecker@yahoo.com','0564398002','First, however, she went on. \'I do,\' Alice said to the other, and making quite a large arm-chair.',NULL,'transferred','2025-05-03 11:32:55','2025-05-03 11:32:55'),(157,37,'N9FPD9TNADKC','Prof. Lonzo Kiehn II','kody.schmitt@hotmail.com','0465072135','I think I should think you could only see her. She is such a thing. After a time there were three.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(158,38,'0AZIEEQOLQYP','Julio Toy','hermann.jesus@gmail.com','0779073025','Do you think I should frighten them out again. That\'s all.\' \'Thank you,\' said the Dormouse: \'not.',NULL,'checked_in','2025-05-03 11:32:55','2025-05-03 11:32:55'),(159,38,'VJS6ZGQR7GB5','Keira McLaughlin','lang.ethyl@yahoo.com','0907838731','Pepper For a minute or two, looking for them, and he hurried off. Alice thought to herself.',NULL,'checked_in','2025-05-03 11:32:55','2025-05-03 11:32:55'),(160,38,'XPCCWAZZDZXR','Rebeca Collins','barbara09@gmail.com','0964733408','TRUE--\" that\'s the jury, in a low, trembling voice. \'There\'s more evidence to come yet, please.',NULL,'cancelled','2025-05-03 11:32:55','2025-05-03 11:32:55'),(161,39,'NEHTEZB1JRNL','Thora Wuckert','edison.yundt@hotmail.com','0389925816','VERY long claws and a bright brass plate with the next witness was the Cat remarked. \'Don\'t be.',NULL,'checked_in','2025-05-03 11:32:55','2025-05-03 11:32:55'),(162,39,'DD82XOLDISTP','Mrs. Eulalia Greenfelder','claudia95@yahoo.com','0542889042','Alice, in a very hopeful tone though), \'I won\'t interrupt again. I dare say you\'re wondering why I.',NULL,'reserved','2025-05-03 11:32:55','2025-05-03 11:32:55'),(163,39,'VKA3X7NSYM5J','Martin Bashirian Jr.','von.letitia@marquardt.net','0898982388','And so she tried the effect of lying down on one side, to look at all this time. \'I want a clean.',NULL,'refunded','2025-05-03 11:32:55','2025-05-03 11:32:55'),(164,39,'VADXSSVASVSO','Dock Olson','opurdy@pouros.com','0810301932','Gryphon. \'Do you know what to say \"HOW DOTH THE LITTLE BUSY BEE,\" but it was very provoking to.',NULL,'pending','2025-05-03 11:32:55','2025-05-03 11:32:55'),(165,40,'PTCZ20DAHAOW','Halie Harber','krystina.hills@abbott.com','0592897219','Caterpillar. Alice folded her hands, wondering if anything would EVER happen in a sulky tone, as.',NULL,'pending','2025-05-03 11:32:56','2025-05-03 11:32:56'),(166,40,'UCONCX25EXGA','Hermina Hagenes','loy.altenwerth@champlin.org','0423521852','VERY short remarks, and she set to work nibbling at the beginning,\' the King repeated angrily, \'or.',NULL,'cancelled','2025-05-03 11:32:56','2025-05-03 11:32:56'),(167,41,'I8LYNGCENA1Q','Seth Mann','wilkinson.dahlia@ebert.com','0098562332','Arithmetic--Ambition, Distraction, Uglification, and Derision.\' \'I never went to school in the.',NULL,'cancelled','2025-05-03 11:32:56','2025-05-03 11:32:56'),(168,41,'N3JCMQ1RG8MU','Miss Yasmeen Sanford IV','matilde.wyman@hotmail.com','0606138388','King was the first witness,\' said the King; and as it is.\' \'Then you should say \"With what.',NULL,'checked_in','2025-05-03 11:32:56','2025-05-03 11:32:56'),(169,42,'YEJRSBIRUPTW','Matilde Stiedemann IV','schroeder.rhea@hotmail.com','0219268483','Cheshire cat,\' said the Hatter, \'when the Queen jumped up on tiptoe, and peeped over the fire.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56'),(170,42,'KCM0W7DJ0ZGO','Jordan Dach','darien17@gmail.com','0152196224','I eat or drink something or other; but the Dormouse go on till you come to the company generally.',NULL,'transferred','2025-05-03 11:32:56','2025-05-03 11:32:56'),(171,42,'LH9AIPPEYNPO','Breana Corwin','jaskolski.allison@nader.com','0116523028','King. \'Nearly two miles high,\' added the Hatter, with an air of great curiosity. \'Soles and eels.',NULL,'checked_in','2025-05-03 11:32:56','2025-05-03 11:32:56'),(172,42,'BGGM02OCH1IF','Sherwood Schmitt','ehirthe@wilkinson.com','0862912422','King: \'however, it may kiss my hand if it had lost something; and she looked at Alice. \'It goes.',NULL,'reserved','2025-05-03 11:32:56','2025-05-03 11:32:56'),(173,42,'IWJ4AUFCQB3S','Lolita Russel','gwuckert@yahoo.com','0564660717','SOMETHING interesting is sure to make out that the pebbles were all shaped like ears and whiskers.',NULL,'transferred','2025-05-03 11:32:56','2025-05-03 11:32:56'),(174,43,'YP6WUXCM4XO2','Marina Gutmann','felicity39@gmail.com','0015578562','Gryphon. \'Turn a somersault in the act of crawling away: besides all this, there was a little.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(175,43,'HFTDLMID5IL0','Katheryn Kirlin','shields.vladimir@wiegand.com','0210122526','Half-past one, time for dinner!\' (\'I only wish people knew that: then they both sat silent and.',NULL,'transferred','2025-05-03 11:32:56','2025-05-03 11:32:56'),(176,44,'GETHUCIBFYYP','Dashawn Thompson','davon79@moen.net','0871270204','Then it got down off the top of it. She stretched herself up and down looking for it, she found.',NULL,'reserved','2025-05-03 11:32:56','2025-05-03 11:32:56'),(177,44,'OEIU29QKJFHP','Kattie Ankunding MD','dino.ernser@hotmail.com','0254594431','I suppose.\' So she set the little magic bottle had now had its full effect, and she swam about.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(178,44,'K0ZDNOA6IHKD','Stefanie Casper','kertzmann.sasha@hotmail.com','0011705037','Alice hastily; \'but I\'m not used to say a word, but slowly followed her back to my right size: the.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(179,44,'EVC5QMULOZFA','Sonny Jacobson','don52@thiel.com','0070486337','Alice thought to herself, as she spoke--fancy CURTSEYING as you\'re falling through the glass, and.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56'),(180,45,'FWB04YXV0XAY','Dr. Harmony Metz II','avandervort@yahoo.com','0374524725','Either the well was very fond of beheading people here; the great puzzle!\' And she began again. \'I.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56'),(181,45,'DSXNEMVYNRLB','Amara Conroy DDS','nelda91@king.org','0027540328','IS that to be a letter, written by the end of trials, \"There was some attempts at applause, which.',NULL,'reserved','2025-05-03 11:32:56','2025-05-03 11:32:56'),(182,46,'BK7A36IKQE44','Chet Hintz','acorkery@hotmail.com','0748316708','PLEASE mind what you\'re doing!\' cried Alice, with a T!\' said the Hatter. \'Does YOUR watch tell you.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(183,46,'BYGBK7LKMX13','Prof. Zachary Schmitt DVM','antwan44@greenfelder.info','0224353291','William the Conqueror.\' (For, with all speed back to the jury, and the bright flower-beds and the.',NULL,'cancelled','2025-05-03 11:32:56','2025-05-03 11:32:56'),(184,47,'IQQHKZCFPG8X','Zoe Wolf','gulgowski.lilla@harvey.com','0057216346','Alice, \'shall I NEVER get any older than I am now? That\'ll be a LITTLE larger, sir, if you could.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(185,47,'SKPTXY3M7MXY','Prof. Tomas Harber V','magdalena.bergnaum@mcglynn.com','0600161352','I know I do!\' said Alice doubtfully: \'it means--to--make--anything--prettier.\' \'Well, then,\' the.',NULL,'cancelled','2025-05-03 11:32:56','2025-05-03 11:32:56'),(186,48,'NELXOUTL9NAD','Gennaro Tremblay','kblick@gislason.org','0796426918','Alice in a whisper.) \'That would be as well say,\' added the Dormouse, after thinking a minute or.',NULL,'pending','2025-05-03 11:32:56','2025-05-03 11:32:56'),(187,48,'IVX98MY7HZS7','Haleigh Kovacek','urban71@hotmail.com','0073320311','YOUR temper!\' \'Hold your tongue!\' said the King: \'however, it may kiss my hand if it makes me grow.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(188,48,'KHYMAY4RR5UI','Dion Cruickshank','roberts.hipolito@cummerata.biz','0835263699','However, \'jury-men\' would have appeared to them to be almost out of this elegant thimble\'; and.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(189,48,'TWGOFJBAULFB','Ciara Wuckert','xschaefer@schaefer.com','0188361827','Footman went on so long that they were IN the well,\' Alice said very humbly; \'I won\'t have any.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(190,49,'Y0BGD3CC5K5P','Presley Renner','jeff67@hotmail.com','0629872043','Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another.',NULL,'pending','2025-05-03 11:32:56','2025-05-03 11:32:56'),(191,49,'CBXWUIWZABHK','Mr. Matt McLaughlin','gus65@hegmann.info','0967778313','I\'ll manage better this time,\' she said to herself, and nibbled a little three-legged table, all.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56'),(192,49,'PA3WVPYXK37Y','Miss Valerie Watsica','oliver.swift@gmail.com','0241303151','Mock Turtle replied, counting off the cake. * * * * * * * * * * * * * * * * * * * * * * * * * * *.',NULL,'cancelled','2025-05-03 11:32:56','2025-05-03 11:32:56'),(193,49,'YNMVLVBJZS50','Zechariah Bahringer','golda26@gmail.com','0664683618','Mabel after all, and I shall be late!\' (when she thought it over here,\' said the King: \'leave out.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56'),(194,50,'48KFKLFMFAZN','Chris Rippin Jr.','dziemann@okeefe.com','0714730976','I can reach the key; and if the Queen had only one way of expecting nothing but out-of-the-way.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56'),(195,50,'FN3WO05DSASK','Cleta Luettgen','williamson.eugenia@yahoo.com','0215130525','CHAPTER X. The Lobster Quadrille The Mock Turtle said: \'no wise fish would go anywhere without a.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(196,50,'9IUDRL83UAUF','Jewell Mann','dharvey@gmail.com','0709402995','Alice; \'living at the top with its eyelids, so he with his head!\' or \'Off with her friend. When.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56'),(197,50,'PPVPRCSFGRVT','Dr. Erick Lockman I','domenica.haley@feil.info','0078000044','Hatter. \'He won\'t stand beating. Now, if you drink much from a Caterpillar The Caterpillar was the.',NULL,'purchased','2025-05-03 11:32:56','2025-05-03 11:32:56'),(198,50,'IVM8ZGVYZMP5','Gloria Huel','weissnat.tyrel@gaylord.net','0798663721','She went on in the after-time, be herself a grown woman; and how she would gather about her.',NULL,'checked_in','2025-05-03 11:32:56','2025-05-03 11:32:56'),(199,50,'FGVTJHVY9BKF','Elmira Yost','mante.delta@hegmann.com','0482220947','Dormouse\'s place, and Alice guessed who it was, and, as she could. \'No,\' said the last words out.',NULL,'refunded','2025-05-03 11:32:56','2025-05-03 11:32:56');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-05-03 11:32:34','2025-05-03 11:32:34','Inventore neque velit cupiditate qui. Aut enim fugiat nihil temporibus consectetur sequi.'),(2,'Registration &amp; Tickets',0,'published','2025-05-03 11:32:34','2025-05-03 11:32:34','Sed molestiae odio facere assumenda et quia mollitia. Porro optio alias vel quidem quia sunt.'),(3,'Event Experience',0,'published','2025-05-03 11:32:34','2025-05-03 11:32:34','Modi eum numquam sed libero. Aut velit et itaque. Reprehenderit culpa cupiditate odio.'),(4,'Speaker &amp; Sessions',0,'published','2025-05-03 11:32:34','2025-05-03 11:32:34','Numquam quod sed quia qui fuga quae. Dolor et et commodi nemo consectetur.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Excepturi ea quod iure iste.','Non provident omnis vel et ab minima suscipit quisquam vel incidunt atque necessitatibus eum aut quia voluptatem qui hic amet dolorum eaque qui voluptas in quo nam voluptas repellendus voluptatibus ipsum dolorum repellat animi quam et.',4,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(2,'Culpa eos eos itaque consequatur voluptatem.','Qui veritatis quia neque omnis aut iusto ducimus consequatur hic sapiente id et totam mollitia quia neque nisi sit ut sit voluptas quasi ipsam voluptates et voluptate minus aut odio a et ut sunt et nisi quia.',3,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(3,'Illo et eum delectus suscipit.','Voluptatem amet architecto culpa vel tempora non sit non eum voluptatem molestias molestiae dicta qui et provident nostrum officia non est quia minus et aut sequi omnis nesciunt incidunt ea rem tempora aut nam qui veritatis eos nihil dolorem ea non qui alias.',2,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(4,'Quae quia voluptas ea qui cupiditate.','Corporis qui asperiores qui labore omnis illum est laboriosam et aut ex magnam veniam sed nihil accusantium rerum et a voluptas deserunt.',2,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(5,'Aliquam qui recusandae earum amet iure explicabo.','Consequuntur commodi excepturi asperiores ea rerum ea quia ullam aut voluptatibus ut sunt odio harum modi in aut labore numquam quia odio accusamus magnam odio ducimus blanditiis excepturi omnis nihil tenetur animi sequi vel rerum debitis quia totam quasi impedit.',1,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(6,'Ullam facilis sint possimus enim adipisci quam.','Excepturi sed laborum doloribus officia assumenda ea debitis modi doloremque et occaecati natus rerum quo eveniet eaque ut eveniet qui quia aut est totam saepe est omnis praesentium veritatis amet autem sit tempora qui.',1,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(7,'Minus fuga facilis velit.','Cupiditate cumque iste quia ab explicabo quod voluptas sit quasi aut voluptatem iure rerum asperiores perferendis expedita aut nobis eum consequuntur rerum ut molestiae est et dolorem hic.',2,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(8,'Est ab nam sit.','Nesciunt voluptatibus dolorem omnis minima fuga non dolor velit rerum facilis dolores qui blanditiis aut accusantium voluptatem praesentium ad odio aut unde voluptatum hic ipsa soluta iure dolor officiis quam rerum repellendus debitis esse architecto.',2,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(9,'Quidem impedit voluptate aut quos.','Aliquid nulla voluptatem aut enim totam animi praesentium nihil laudantium quos ut aut nihil corporis at consequatur vel beatae quis qui assumenda velit reprehenderit dolorum soluta ut ut quis dicta quae enim fugiat aut veritatis non adipisci.',3,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(10,'Qui atque repudiandae magni.','Assumenda pariatur consequatur libero sint dolores quia quia expedita molestiae quam quos officiis tenetur voluptas nihil dolores ipsa totam officiis suscipit id corporis ea voluptatibus in et iusto molestiae dolore minus repudiandae dolor incidunt accusantium illum aut maxime distinctio omnis totam.',1,'published','2025-05-03 11:32:34','2025-05-03 11:32:34'),(11,'Qui et voluptatem distinctio consequatur iure unde.','Autem numquam aspernatur laborum non consequatur consectetur architecto et dolores autem doloribus non consectetur aut excepturi est explicabo minima necessitatibus.',1,'published','2025-05-03 11:32:34','2025-05-03 11:32:34');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Consequatur nobis eaque ut sit quas voluptas aliquid. Cumque dolor impedit laboriosam qui non. Ipsum dolores veritatis numquam minus.',1,0,'main/news/6.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(2,'Ocean Views','Enim vel beatae suscipit sint inventore. Occaecati quos nisi aliquid. Qui quos est ipsa illum repellendus et repellat. Tempore et quasi commodi.',1,0,'main/news/7.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(3,'Adventure Time','Velit est dolores qui. Maiores enim error ut qui et qui ad sed. Earum at expedita deserunt aperiam pariatur. Tempora dolor enim ut eos.',1,0,'main/news/8.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(4,'City Lights','Repellat quis voluptatem nulla repudiandae et. Fuga tempora nostrum vitae aut. Et eligendi voluptatem ea eos fugit aperiam.',1,0,'main/news/9.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(5,'Dreamscape','Ad impedit qui perferendis et quasi sit. Hic recusandae modi voluptas. Numquam neque earum officiis eos ducimus a sit.',1,0,'main/news/10.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(6,'Enchanted Forest','Quaerat dolor facilis quis repudiandae reprehenderit. Cumque quaerat soluta est quam quis dolore. Dolores cum minima id quia consectetur unde.',1,0,'main/news/11.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(7,'Golden Hour','Et voluptatem sed id saepe quis ut quasi in. Sunt et quo qui.',0,0,'main/news/12.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(8,'Serenity','Rem similique ea totam veniam debitis. Omnis accusamus debitis est dolor minima facere id. Eum enim error laboriosam nobis.',0,0,'main/news/13.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(9,'Eternal Beauty','Voluptatibus possimus ut maxime laboriosam rerum iste. Qui consectetur vel veniam velit asperiores dolores.',0,0,'main/news/14.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(10,'Moonlight Magic','Dignissimos nihil aperiam vel tenetur ut aut. Eum odit est omnis. Error repudiandae aut sapiente et.',0,0,'main/news/15.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(11,'Starry Night','Et accusamus provident fugit sit. Error voluptas voluptate consequuntur. Sequi omnis sed et deleniti.',0,0,'main/news/16.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(12,'Hidden Gems','Ut eum error vel voluptatem. Distinctio necessitatibus ducimus quos debitis nisi et enim. Eum harum excepturi quidem ex amet.',0,0,'main/news/17.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(13,'Tranquil Waters','Voluptatibus inventore eos et et ut porro eos. Perferendis assumenda alias occaecati et deleniti.',0,0,'main/news/18.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(14,'Urban Escape','Veniam ea exercitationem quis impedit. Voluptatem architecto excepturi id temporibus ut. Illum suscipit aperiam sint.',0,0,'main/news/19.jpg',NULL,'published','2025-05-03 11:32:09','2025-05-03 11:32:09'),(15,'Twilight Zone','Voluptatem a non laboriosam facere. Harum sapiente tempora rerum exercitationem et nemo placeat alias. Pariatur harum quisquam eius sit animi quae.',0,0,'main/news/20.jpg',NULL,'published','2025-05-03 11:32:10','2025-05-03 11:32:10');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:09','2025-05-03 11:32:09'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Eligendi aperiam aut commodi similique. Ad dicta amet doloremque itaque earum fugiat.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sunt minus animi corrupti est aliquam. Error necessitatibus expedita eos nostrum. Laborum dolor qui quo rerum.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Itaque voluptatem voluptatum quia dolor. Omnis velit voluptatum consequatur impedit qui iusto. Nihil debitis animi quo id odit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quia exercitationem sunt qui et aliquid ut et. Eligendi libero sunt magnam iste ratione. Animi velit saepe beatae iusto.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Sapiente veritatis similique et et. Qui quo dolore harum et ut sed nam. Neque voluptates est quae soluta modi.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Rerum amet esse harum magni voluptas. Ipsum impedit consequatur quidem voluptatem iste. Quas dolores voluptatibus impedit aut eos.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ut placeat nobis laudantium eum voluptatem qui. Cum quo est animi modi quam quis. Et qui maiores quam. Atque sint ex aut soluta voluptas qui.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Autem aperiam libero mollitia sint voluptatum ut. Enim quod ipsa temporibus rerum voluptatum nobis at.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aliquid quis ipsa cupiditate est deleniti ab. Ut ut sed odit eveniet.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Illo soluta consectetur assumenda. Consequatur asperiores praesentium debitis et voluptas odit. Id et est consequatur vero.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Sunt consequatur dicta ex dolor voluptatem. Temporibus quaerat est recusandae quia. Eveniet eos dolorem natus nemo.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Sapiente blanditiis enim eum quam. Ut ut vel asperiores id quo ut assumenda. Id incidunt officiis molestiae similique numquam reiciendis.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Enim sit sit praesentium eum voluptate. Maiores doloribus qui rerum. Voluptate autem saepe dolore et rerum vero est.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Error incidunt ut ea sit eligendi cum voluptates reprehenderit. Assumenda aliquid consequatur alias rerum nostrum odio sed.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Quia necessitatibus optio vero optio aut non reiciendis. Qui iste eos qui ut sequi sed optio doloribus. Ipsum tenetur et quaerat consequatur.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur dolore quos ea porro dolorem. Qui sapiente quisquam eos.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Est earum alias dolorem deleniti nihil. Omnis eum rem pariatur ipsa. Accusantium cumque id temporibus. Quis qui voluptates aut hic.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit veniam vel autem et. Aut vitae commodi iste illum voluptas ab.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ipsa quasi est delectus et perspiciatis omnis nulla. Consequatur aut aut amet. Qui voluptas iure rerum aut sit laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Libero reprehenderit maxime animi. Itaque dolorum placeat fugit qui modi rem non quo. Fuga in et consequatur debitis id. Sunt at nihil ipsam et.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-05-03 11:32:10','2025-05-03 11:32:10');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','bb12eb854556a036871fd79cd2987695',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','c2faa75b216c3ddfa86d569b22968fac',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','b25de71c6dd94b798d0bcacf723c3143',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-05-03 11:32:10','2025-05-03 11:32:10',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-05-03 11:32:10','2025-05-03 11:32:10',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-05-03 11:32:10','2025-05-03 11:32:10',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-05-03 11:32:11','2025-05-03 11:32:11',NULL,'public'),(36,0,'brand-img1','brand-img1',5,'image/png',922,'main/brands/brand-img1.png','[]','2025-05-03 11:32:11','2025-05-03 11:32:11',NULL,'public'),(37,0,'brand-img2','brand-img2',5,'image/png',922,'main/brands/brand-img2.png','[]','2025-05-03 11:32:11','2025-05-03 11:32:11',NULL,'public'),(38,0,'brand-img3','brand-img3',5,'image/png',922,'main/brands/brand-img3.png','[]','2025-05-03 11:32:11','2025-05-03 11:32:11',NULL,'public'),(39,0,'brand-img4','brand-img4',5,'image/png',922,'main/brands/brand-img4.png','[]','2025-05-03 11:32:11','2025-05-03 11:32:11',NULL,'public'),(40,0,'brand-img5','brand-img5',5,'image/png',922,'main/brands/brand-img5.png','[]','2025-05-03 11:32:11','2025-05-03 11:32:11',NULL,'public'),(41,0,'brand-img6','brand-img6',5,'image/png',922,'main/brands/brand-img6.png','[]','2025-05-03 11:32:12','2025-05-03 11:32:12',NULL,'public'),(42,0,'brand-img7','brand-img7',5,'image/png',922,'main/brands/brand-img7.png','[]','2025-05-03 11:32:12','2025-05-03 11:32:12',NULL,'public'),(43,0,'brand-img8','brand-img8',5,'image/png',922,'main/brands/brand-img8.png','[]','2025-05-03 11:32:12','2025-05-03 11:32:12',NULL,'public'),(44,0,'1','1',6,'image/png',2977,'main/backgrounds/1.png','[]','2025-05-03 11:32:12','2025-05-03 11:32:12',NULL,'public'),(45,0,'2','2',6,'image/png',116016,'main/backgrounds/2.png','[]','2025-05-03 11:32:12','2025-05-03 11:32:12',NULL,'public'),(46,0,'header-bg4','header-bg4',6,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-05-03 11:32:13','2025-05-03 11:32:13',NULL,'public'),(47,0,'hero-banner-bg','hero-banner-bg',6,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-05-03 11:32:13','2025-05-03 11:32:13',NULL,'public'),(48,0,'image-1','image-1',6,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-05-03 11:32:14','2025-05-03 11:32:14',NULL,'public'),(49,0,'newsletter-bg','newsletter-bg',6,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-05-03 11:32:15','2025-05-03 11:32:15',NULL,'public'),(50,0,'pricing-name','pricing-name',6,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-05-03 11:32:16','2025-05-03 11:32:16',NULL,'public'),(51,0,'speakers-bg','speakers-bg',6,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-05-03 11:32:16','2025-05-03 11:32:16',NULL,'public'),(52,0,'balloons','balloons',7,'image/png',25074,'main/icons/balloons.png','[]','2025-05-03 11:32:16','2025-05-03 11:32:16',NULL,'public'),(53,0,'calendar','calendar',7,'image/png',15903,'main/icons/calendar.png','[]','2025-05-03 11:32:16','2025-05-03 11:32:16',NULL,'public'),(54,0,'clock','clock',7,'image/png',31087,'main/icons/clock.png','[]','2025-05-03 11:32:16','2025-05-03 11:32:16',NULL,'public'),(55,0,'coding','coding',7,'image/png',19675,'main/icons/coding.png','[]','2025-05-03 11:32:17','2025-05-03 11:32:17',NULL,'public'),(56,0,'idea','idea',7,'image/png',18793,'main/icons/idea.png','[]','2025-05-03 11:32:17','2025-05-03 11:32:17',NULL,'public'),(57,0,'instagram-icon','instagram-icon',7,'image/png',606,'main/icons/instagram-icon.png','[]','2025-05-03 11:32:17','2025-05-03 11:32:17',NULL,'public'),(58,0,'location-icon','location-icon',7,'image/png',835,'main/icons/location-icon.png','[]','2025-05-03 11:32:17','2025-05-03 11:32:17',NULL,'public'),(59,0,'location','location',7,'image/png',22189,'main/icons/location.png','[]','2025-05-03 11:32:17','2025-05-03 11:32:17',NULL,'public'),(60,0,'mail-icon','mail-icon',7,'image/png',647,'main/icons/mail-icon.png','[]','2025-05-03 11:32:17','2025-05-03 11:32:17',NULL,'public'),(61,0,'menu','menu',7,'image/png',11155,'main/icons/menu.png','[]','2025-05-03 11:32:18','2025-05-03 11:32:18',NULL,'public'),(62,0,'microphone','microphone',7,'image/png',22211,'main/icons/microphone.png','[]','2025-05-03 11:32:18','2025-05-03 11:32:18',NULL,'public'),(63,0,'phone-icon','phone-icon',7,'image/png',982,'main/icons/phone-icon.png','[]','2025-05-03 11:32:18','2025-05-03 11:32:18',NULL,'public'),(64,0,'search','search',7,'image/png',23517,'main/icons/search.png','[]','2025-05-03 11:32:18','2025-05-03 11:32:18',NULL,'public'),(65,0,'speaker','speaker',7,'image/png',16059,'main/icons/speaker.png','[]','2025-05-03 11:32:18','2025-05-03 11:32:18',NULL,'public'),(66,0,'ticket','ticket',7,'image/png',18246,'main/icons/ticket.png','[]','2025-05-03 11:32:18','2025-05-03 11:32:18',NULL,'public'),(67,0,'user','user',7,'image/png',16365,'main/icons/user.png','[]','2025-05-03 11:32:19','2025-05-03 11:32:19',NULL,'public'),(68,0,'view','view',7,'image/png',18213,'main/icons/view.png','[]','2025-05-03 11:32:19','2025-05-03 11:32:19',NULL,'public'),(69,0,'workshop','workshop',7,'image/png',25532,'main/icons/workshop.png','[]','2025-05-03 11:32:19','2025-05-03 11:32:19',NULL,'public'),(70,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-05-03 11:32:19','2025-05-03 11:32:19',NULL,'public'),(71,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-05-03 11:32:20','2025-05-03 11:32:20',NULL,'public'),(72,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-05-03 11:32:20','2025-05-03 11:32:20',NULL,'public'),(73,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-05-03 11:32:20','2025-05-03 11:32:20',NULL,'public'),(74,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-05-03 11:32:21','2025-05-03 11:32:21',NULL,'public'),(75,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-05-03 11:32:21','2025-05-03 11:32:21',NULL,'public'),(76,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-05-03 11:32:21','2025-05-03 11:32:21',NULL,'public'),(77,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-05-03 11:32:22','2025-05-03 11:32:22',NULL,'public'),(78,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-05-03 11:32:22','2025-05-03 11:32:22',NULL,'public'),(79,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-05-03 11:32:22','2025-05-03 11:32:22',NULL,'public'),(80,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-05-03 11:32:23','2025-05-03 11:32:23',NULL,'public'),(81,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-05-03 11:32:23','2025-05-03 11:32:23',NULL,'public'),(82,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-05-03 11:32:23','2025-05-03 11:32:23',NULL,'public'),(83,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-05-03 11:32:24','2025-05-03 11:32:24',NULL,'public'),(84,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-05-03 11:32:24','2025-05-03 11:32:24',NULL,'public'),(85,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-05-03 11:32:24','2025-05-03 11:32:24',NULL,'public'),(86,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-05-03 11:32:25','2025-05-03 11:32:25',NULL,'public'),(87,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-05-03 11:32:25','2025-05-03 11:32:25',NULL,'public'),(88,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-05-03 11:32:25','2025-05-03 11:32:25',NULL,'public'),(89,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-05-03 11:32:26','2025-05-03 11:32:26',NULL,'public'),(90,0,'1','1',8,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-05-03 11:32:26','2025-05-03 11:32:26',NULL,'public'),(91,0,'10','10',8,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-05-03 11:32:27','2025-05-03 11:32:27',NULL,'public'),(92,0,'11','11',8,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-05-03 11:32:27','2025-05-03 11:32:27',NULL,'public'),(93,0,'12','12',8,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-05-03 11:32:27','2025-05-03 11:32:27',NULL,'public'),(94,0,'13','13',8,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-05-03 11:32:28','2025-05-03 11:32:28',NULL,'public'),(95,0,'14','14',8,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-05-03 11:32:28','2025-05-03 11:32:28',NULL,'public'),(96,0,'15','15',8,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-05-03 11:32:29','2025-05-03 11:32:29',NULL,'public'),(97,0,'16','16',8,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-05-03 11:32:29','2025-05-03 11:32:29',NULL,'public'),(98,0,'17','17',8,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-05-03 11:32:29','2025-05-03 11:32:29',NULL,'public'),(99,0,'18','18',8,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-05-03 11:32:30','2025-05-03 11:32:30',NULL,'public'),(100,0,'19','19',8,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-05-03 11:32:30','2025-05-03 11:32:30',NULL,'public'),(101,0,'2','2',8,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-05-03 11:32:30','2025-05-03 11:32:30',NULL,'public'),(102,0,'20','20',8,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-05-03 11:32:31','2025-05-03 11:32:31',NULL,'public'),(103,0,'3','3',8,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-05-03 11:32:31','2025-05-03 11:32:31',NULL,'public'),(104,0,'4','4',8,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-05-03 11:32:31','2025-05-03 11:32:31',NULL,'public'),(105,0,'5','5',8,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-05-03 11:32:32','2025-05-03 11:32:32',NULL,'public'),(106,0,'6','6',8,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-05-03 11:32:32','2025-05-03 11:32:32',NULL,'public'),(107,0,'7','7',8,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-05-03 11:32:32','2025-05-03 11:32:32',NULL,'public'),(108,0,'8','8',8,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-05-03 11:32:33','2025-05-03 11:32:33',NULL,'public'),(109,0,'9','9',8,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-05-03 11:32:33','2025-05-03 11:32:33',NULL,'public'),(110,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-05-03 11:32:34','2025-05-03 11:32:34',NULL,'public'),(111,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-05-03 11:32:34','2025-05-03 11:32:34',NULL,'public'),(112,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-05-03 11:32:35','2025-05-03 11:32:35',NULL,'public'),(113,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-05-03 11:32:35','2025-05-03 11:32:35',NULL,'public'),(114,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-05-03 11:32:35','2025-05-03 11:32:35',NULL,'public'),(115,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-05-03 11:32:35','2025-05-03 11:32:35',NULL,'public'),(116,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-05-03 11:32:35','2025-05-03 11:32:35',NULL,'public'),(117,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-05-03 11:32:36','2025-05-03 11:32:36',NULL,'public'),(118,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-05-03 11:32:36','2025-05-03 11:32:36',NULL,'public'),(119,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-05-03 11:32:36','2025-05-03 11:32:36',NULL,'public'),(120,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-05-03 11:32:36','2025-05-03 11:32:36',NULL,'public'),(121,0,'1','1',9,'image/png',31065,'main/speakers/1.png','[]','2025-05-03 11:32:36','2025-05-03 11:32:36',NULL,'public'),(122,0,'10','10',9,'image/png',46860,'main/speakers/10.png','[]','2025-05-03 11:32:36','2025-05-03 11:32:36',NULL,'public'),(123,0,'11','11',9,'image/png',52206,'main/speakers/11.png','[]','2025-05-03 11:32:37','2025-05-03 11:32:37',NULL,'public'),(124,0,'2','2',9,'image/png',36766,'main/speakers/2.png','[]','2025-05-03 11:32:37','2025-05-03 11:32:37',NULL,'public'),(125,0,'3','3',9,'image/png',30159,'main/speakers/3.png','[]','2025-05-03 11:32:37','2025-05-03 11:32:37',NULL,'public'),(126,0,'4','4',9,'image/png',10879,'main/speakers/4.png','[]','2025-05-03 11:32:37','2025-05-03 11:32:37',NULL,'public'),(127,0,'5','5',9,'image/png',38725,'main/speakers/5.png','[]','2025-05-03 11:32:37','2025-05-03 11:32:37',NULL,'public'),(128,0,'6','6',9,'image/png',41822,'main/speakers/6.png','[]','2025-05-03 11:32:37','2025-05-03 11:32:37',NULL,'public'),(129,0,'7','7',9,'image/png',36871,'main/speakers/7.png','[]','2025-05-03 11:32:38','2025-05-03 11:32:38',NULL,'public'),(130,0,'8','8',9,'image/png',44128,'main/speakers/8.png','[]','2025-05-03 11:32:38','2025-05-03 11:32:38',NULL,'public'),(131,0,'9','9',9,'image/png',42973,'main/speakers/9.png','[]','2025-05-03 11:32:38','2025-05-03 11:32:38',NULL,'public'),(132,0,'0','0',10,'image/webp',33268,'main/events/0-1746271964.webp','[]','2025-05-03 11:32:44','2025-05-03 11:32:44',NULL,'public'),(133,0,'1','1',10,'image/webp',33268,'main/events/1.webp','[]','2025-05-03 11:32:45','2025-05-03 11:32:45',NULL,'public'),(134,0,'10','10',10,'image/webp',33268,'main/events/10.webp','[]','2025-05-03 11:32:45','2025-05-03 11:32:45',NULL,'public'),(135,0,'11','11',10,'image/webp',33268,'main/events/11.webp','[]','2025-05-03 11:32:45','2025-05-03 11:32:45',NULL,'public'),(136,0,'12','12',10,'image/webp',33268,'main/events/12.webp','[]','2025-05-03 11:32:46','2025-05-03 11:32:46',NULL,'public'),(137,0,'13','13',10,'image/webp',33268,'main/events/13.webp','[]','2025-05-03 11:32:46','2025-05-03 11:32:46',NULL,'public'),(138,0,'14','14',10,'image/webp',33268,'main/events/14.webp','[]','2025-05-03 11:32:46','2025-05-03 11:32:46',NULL,'public'),(139,0,'15','15',10,'image/webp',33268,'main/events/15.webp','[]','2025-05-03 11:32:47','2025-05-03 11:32:47',NULL,'public'),(140,0,'16','16',10,'image/webp',33268,'main/events/16.webp','[]','2025-05-03 11:32:47','2025-05-03 11:32:47',NULL,'public'),(141,0,'17','17',10,'image/webp',33268,'main/events/17.webp','[]','2025-05-03 11:32:47','2025-05-03 11:32:47',NULL,'public'),(142,0,'18','18',10,'image/webp',33268,'main/events/18.webp','[]','2025-05-03 11:32:48','2025-05-03 11:32:48',NULL,'public'),(143,0,'19','19',10,'image/webp',33268,'main/events/19.webp','[]','2025-05-03 11:32:48','2025-05-03 11:32:48',NULL,'public'),(144,0,'2','2',10,'image/webp',33268,'main/events/2.webp','[]','2025-05-03 11:32:48','2025-05-03 11:32:48',NULL,'public'),(145,0,'20','20',10,'image/webp',33268,'main/events/20.webp','[]','2025-05-03 11:32:49','2025-05-03 11:32:49',NULL,'public'),(146,0,'3','3',10,'image/webp',33268,'main/events/3.webp','[]','2025-05-03 11:32:49','2025-05-03 11:32:49',NULL,'public'),(147,0,'4','4',10,'image/webp',33268,'main/events/4.webp','[]','2025-05-03 11:32:49','2025-05-03 11:32:49',NULL,'public'),(148,0,'5','5',10,'image/webp',33268,'main/events/5.webp','[]','2025-05-03 11:32:50','2025-05-03 11:32:50',NULL,'public'),(149,0,'6','6',10,'image/webp',33268,'main/events/6.webp','[]','2025-05-03 11:32:50','2025-05-03 11:32:50',NULL,'public'),(150,0,'7','7',10,'image/webp',33268,'main/events/7.webp','[]','2025-05-03 11:32:50','2025-05-03 11:32:50',NULL,'public'),(151,0,'8','8',10,'image/webp',33268,'main/events/8.webp','[]','2025-05-03 11:32:51','2025-05-03 11:32:51',NULL,'public'),(152,0,'9','9',10,'image/webp',33268,'main/events/9.webp','[]','2025-05-03 11:32:51','2025-05-03 11:32:51',NULL,'public'),(153,0,'1','1',11,'image/png',21331,'main/sliders/1.png','[]','2025-05-03 11:33:05','2025-05-03 11:33:05',NULL,'public'),(154,0,'2','2',11,'image/png',21331,'main/sliders/2.png','[]','2025-05-03 11:33:05','2025-05-03 11:33:05',NULL,'public'),(155,0,'3','3',11,'image/png',21331,'main/sliders/3.png','[]','2025-05-03 11:33:05','2025-05-03 11:33:05',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-05-03 11:32:00','2025-05-03 11:32:00',NULL),(2,0,'general',NULL,'general',1,'2025-05-03 11:32:00','2025-05-03 11:32:00',NULL),(3,0,'news',NULL,'news',1,'2025-05-03 11:32:02','2025-05-03 11:32:02',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-05-03 11:32:10','2025-05-03 11:32:10',NULL),(5,0,'brands',NULL,'brands',1,'2025-05-03 11:32:11','2025-05-03 11:32:11',NULL),(6,0,'backgrounds',NULL,'backgrounds',1,'2025-05-03 11:32:12','2025-05-03 11:32:12',NULL),(7,0,'icons',NULL,'icons',1,'2025-05-03 11:32:16','2025-05-03 11:32:16',NULL),(8,0,'blogs',NULL,'blogs',1,'2025-05-03 11:32:26','2025-05-03 11:32:26',NULL),(9,0,'speakers',NULL,'speakers',1,'2025-05-03 11:32:36','2025-05-03 11:32:36',NULL),(10,0,'events',NULL,'events',1,'2025-05-03 11:32:44','2025-05-03 11:32:44',NULL),(11,0,'sliders',NULL,'sliders',1,'2025-05-03 11:33:05','2025-05-03 11:33:05',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-05-03 11:33:04','2025-05-03 11:33:04');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(15,1,13,NULL,NULL,'',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(19,1,16,NULL,NULL,'',NULL,2,'Event Detail',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-05-03 11:33:04','2025-05-03 11:33:04');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-05-03 11:33:04','2025-05-03 11:33:04');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-05-03 11:32:11','2025-05-03 11:32:11'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-05-03 11:32:11','2025-05-03 11:32:11'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-05-03 11:32:11','2025-05-03 11:32:11'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-05-03 11:32:11','2025-05-03 11:32:11'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-05-03 11:32:26','2025-05-03 11:32:26'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-05-03 11:32:26','2025-05-03 11:32:26'),(7,'title','[\"Project Manager\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(8,'description','[\"And she squeezed herself up closer to Alice\'s side as she stood watching them, and was delighted to find my way into a large piece out of its mouth again, and said, very gravely, \'I think, you ought.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(9,'address','[\"5185 Rippin Lakes Suite 780\\nMillschester, DE 27625\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(11,'title','[\"Frontend Developer\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(12,'description','[\"Mock Turtle. \'Hold your tongue!\' said the Mock Turtle: \'why, if a dish or kettle had been broken to pieces. \'Please, then,\' said the King. The White Rabbit blew three blasts on the trumpet, and then.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(13,'address','[\"761 Schimmel Ports Apt. 384\\nLake Eladioland, CA 79711\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:38','2025-05-03 11:32:38'),(15,'title','[\"Project Manager\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(16,'description','[\"I!\' said the Gryphon, half to herself, \'I don\'t quite understand you,\' she said, without even looking round. \'I\'ll fetch the executioner ran wildly up and went on growing, and, as the jury eagerly.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(17,'address','[\"569 Howell Overpass Apt. 116\\nNew Darwin, NE 11406-4681\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(19,'title','[\"UX\\/UI Designer\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(20,'description','[\"Cat. \'I said pig,\' replied Alice; \'and I do so like that curious song about the same thing as \\\"I eat what I was thinking I should think!\' (Dinah was the first question, you know.\' \'I don\'t quite.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(21,'address','[\"782 Orrin Oval\\nKadenside, KS 19545\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(23,'title','[\"UX\\/UI Designer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(24,'description','[\"ALL RETURNED FROM HIM TO YOU,\\\"\' said Alice. \'Then you may nurse it a minute or two, looking for the garden!\' and she went out, but it makes rather a handsome pig, I think.\' And she tried to get in?\'.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(25,'address','[\"49234 Milford Camp Suite 019\\nPort Randalhaven, SC 10958\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(27,'title','[\"Frontend Developer\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(28,'description','[\"As soon as it was YOUR table,\' said Alice; not that she could even make out which were the verses to himself: \'\\\"WE KNOW IT TO BE TRUE--\\\" that\'s the jury-box,\' thought Alice, \'it\'ll never do to come.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(29,'address','[\"687 Casper Road Suite 165\\nPort Macyfurt, DC 10644\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(31,'title','[\"Quality Assurance\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(32,'description','[\"Down, down, down. There was exactly the right way of speaking to a shriek, \'and just as well as she picked her way through the little golden key was too small, but at any rate, there\'s no harm in.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(33,'address','[\"472 Adams Points Suite 057\\nCrooksmouth, AZ 61765\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:39','2025-05-03 11:32:39'),(35,'title','[\"Frontend Developer\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(36,'description','[\"All the time he had taken his watch out of the jurymen. \'No, they\'re not,\' said the Queen, tossing her head to feel very uneasy: to be two people! Why, there\'s hardly enough of it had grown in the.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(37,'address','[\"4768 Johnson Springs\\nEast Sharonside, MN 69533-7971\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(39,'title','[\"Product Manager\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(40,'description','[\"Turtle--we used to know. Let me see--how IS it to annoy, Because he knows it teases.\' CHORUS. (In which the cook was leaning over the list, feeling very glad to do it.\' (And, as you liked.\' \'Is that.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(41,'address','[\"8089 Bashirian Junction\\nLake Orland, NE 57731\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(43,'title','[\"UX\\/UI Designer\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(44,'description','[\"I can find it.\' And she squeezed herself up and ran till she got to the Dormouse, not choosing to notice this question, but hurriedly went on, \'I must be shutting up like a serpent. She had already.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(45,'address','[\"6014 Emily Hills Suite 907\\nPort Hope, CT 98229-7161\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(47,'title','[\"Backend Developer\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(48,'description','[\"Alice as she went on: \'--that begins with a trumpet in one hand and a fan! Quick, now!\' And Alice was beginning to see what was coming. It was the White Rabbit with pink eyes ran close by her. There.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(49,'address','[\"92591 Gayle Springs Suite 330\\nNew Antoneburgh, NV 45573-6519\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(51,'title','[\"Backend Developer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(52,'description','[\"I know is, something comes at me like that!\' But she went hunting about, and crept a little while, however, she waited patiently. \'Once,\' said the Duchess; \'and most things twinkled after that--only.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(53,'address','[\"625 Bode Isle\\nAbernathyton, MD 31590\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:40','2025-05-03 11:32:40'),(55,'title','[\"Frontend Developer\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(56,'description','[\"Alice noticed, had powdered hair that curled all over crumbs.\' \'You\'re wrong about the reason is--\' here the conversation a little. \'\'Tis so,\' said the King. The next thing is, to get through was.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(57,'address','[\"2720 Dexter Mount\\nKonopelskiview, WY 74927-4143\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(59,'title','[\"Project Manager\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(60,'description','[\"Alice, that she might find another key on it, and kept doubling itself up very sulkily and crossed over to herself, rather sharply; \'I advise you to learn?\' \'Well, there was a general chorus of.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(61,'address','[\"9618 Anissa Walk\\nEast Leda, MT 04137-9375\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(63,'title','[\"UX\\/UI Designer\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(64,'description','[\"Then followed the Knave of Hearts, carrying the King\'s crown on a three-legged stool in the sea, \'and in that soup!\' Alice said nothing; she had forgotten the words.\' So they went up to the dance.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(65,'address','[\"636 Roosevelt Squares Suite 724\\nWest Michelmouth, PA 19121\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(67,'title','[\"System Administrator\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(68,'description','[\"Canary called out \'The Queen! The Queen!\' and the small ones choked and had come back in a natural way again. \'I wonder how many miles I\'ve fallen by this time?\' she said to herself. \'Of the.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(69,'address','[\"9482 Steuber Station Suite 065\\nEast Emery, CA 40986\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(71,'title','[\"Backend Developer\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(72,'description','[\"Alice ventured to remark. \'Tut, tut, child!\' said the Caterpillar contemptuously. \'Who are YOU?\' Which brought them back again to the Queen, \'and take this young lady to see if he doesn\'t begin.\'.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(73,'address','[\"7587 David Course\\nEast Ward, NE 62575\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:41','2025-05-03 11:32:41'),(75,'title','[\"System Administrator\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(76,'description','[\"I hadn\'t quite finished my tea when I was a good many little girls of her head struck against the door, she found herself falling down a large mustard-mine near here. And the executioner ran wildly.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(77,'address','[\"828 Archibald Port\\nSouth Rico, DC 95215\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(79,'title','[\"Product Manager\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(80,'description','[\"Pigeon in a more subdued tone, and everybody else. \'Leave off that!\' screamed the Queen. An invitation for the rest of the pack, she could not remember the simple and loving heart of her skirt.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(81,'address','[\"757 Celia Road\\nWeimannton, WA 46564-2561\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(83,'title','[\"Fullstack Developer\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(84,'description','[\"Alice. \'It must be a book of rules for shutting people up like a star-fish,\' thought Alice. \'Now we shall have somebody to talk about cats or dogs either, if you cut your finger VERY deeply with a.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(85,'address','[\"838 Berge Squares\\nShaunville, MD 49271-2334\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(87,'title','[\"Product Manager\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(88,'description','[\"March Hare. \'It was the BEST butter,\' the March Hare. \'It was the first to speak. \'What size do you want to be?\' it asked. \'Oh, I\'m not looking for it, he was obliged to write this down on the end.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(89,'address','[\"54796 Christiana Haven Apt. 998\\nLake Marysemouth, CO 60474\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(91,'title','[\"System Administrator\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(92,'description','[\"Next came the royal children; there were ten of them, and just as usual. I wonder if I\'ve been changed for any of them. \'I\'m sure those are not attending!\' said the Dodo, \'the best way you have of.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(93,'address','[\"93012 Luettgen Extensions\\nBayerton, AR 32545\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:42','2025-05-03 11:32:42'),(95,'title','[\"Fullstack Developer\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(96,'description','[\"It was so much frightened to say anything. \'Why,\' said the youth, \'and your jaws are too weak For anything tougher than suet; Yet you balanced an eel on the floor, and a large plate came skimming.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(97,'address','[\"2339 Herman Streets\\nNyachester, CT 85682-4736\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(99,'title','[\"Backend Developer\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(100,'description','[\"Gryphon remarked: \'because they lessen from day to day.\' This was not an encouraging tone. Alice looked at it gloomily: then he dipped it into one of them hit her in an offended tone, \'Hm! No.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(101,'address','[\"7518 Kulas Harbors\\nLake Priscilla, PA 90622-3645\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(103,'title','[\"Backend Developer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(104,'description','[\"Seaography: then Drawling--the Drawling-master was an old Crab took the least idea what a wonderful dream it had VERY long claws and a bright idea came into her face. \'Wake up, Alice dear!\' said her.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(105,'address','[\"9472 Luisa Burgs Apt. 364\\nLemkeport, OH 10257-3049\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(107,'title','[\"Fullstack Developer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(108,'description','[\"M, such as mouse-traps, and the baby--the fire-irons came first; then followed a shower of saucepans, plates, and dishes. The Duchess took her choice, and was just in time to go, for the White.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(109,'address','[\"9621 Alicia Alley Apt. 635\\nNew Lisandrofurt, MA 49893-5156\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(111,'title','[\"Backend Developer\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(112,'description','[\"And certainly there was mouth enough for it now, I suppose, by being drowned in my time, but never ONE with such sudden violence that Alice had got burnt, and eaten up by two guinea-pigs, who were.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(113,'address','[\"6510 King Trail Apt. 915\\nSouth Jedidiahburgh, RI 95517-2814\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(115,'title','[\"Fullstack Developer\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(116,'description','[\"Hatter. \'Stolen!\' the King say in a great deal to ME,\' said the Lory, with a cart-horse, and expecting every moment to be a LITTLE larger, sir, if you want to see a little queer, won\'t you?\' \'Not a.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:43','2025-05-03 11:32:43'),(117,'address','[\"510 Flo Corners Suite 596\\nBreitenbergfurt, ND 61986-2475\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(119,'title','[\"Quality Assurance\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(120,'description','[\"Duchess, \'as pigs have to ask his neighbour to tell me the truth: did you begin?\' The Hatter shook his head contemptuously. \'I dare say there may be ONE.\' \'One, indeed!\' said the March Hare. Alice.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(121,'address','[\"42820 Rowena Fall Apt. 799\\nTiarahaven, TX 80115\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(123,'title','[\"Fullstack Developer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(124,'description','[\"Alice angrily. \'It wasn\'t very civil of you to set them free, Exactly as we were. My notion was that it led into a tree. By the use of a tree a few minutes to see what was on the floor: in another.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(125,'address','[\"6938 Harmony Union\\nBoyermouth, MD 90067-8684\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(127,'title','[\"System Administrator\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(128,'description','[\"And so it was the White Rabbit hurried by--the frightened Mouse splashed his way through the air! Do you think you could keep it to be ashamed of yourself for asking such a curious feeling!\' said.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(129,'address','[\"4166 Cartwright Springs\\nSouth Ahmedtown, IN 44086-8892\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-05-03 11:32:44','2025-05-03 11:32:44'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(134,'event_id','[9]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(138,'event_id','[10]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05'),(142,'event_id','[5]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-05-03 11:33:05','2025-05-03 11:33:05');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2016_06_10_230148_create_acl_tables',1),(7,'2016_06_14_230857_create_menus_table',1),(8,'2016_06_28_221418_create_pages_table',1),(9,'2016_10_05_074239_create_setting_table',1),(10,'2016_11_28_032840_create_dashboard_widget_tables',1),(11,'2016_12_16_084601_create_widgets_table',1),(12,'2017_05_09_070343_create_media_tables',1),(13,'2017_11_03_070450_create_slug_table',1),(14,'2019_01_05_053554_create_jobs_table',1),(15,'2019_08_19_000000_create_failed_jobs_table',1),(16,'2019_12_14_000001_create_personal_access_tokens_table',1),(17,'2022_04_20_100851_add_index_to_media_table',1),(18,'2022_04_20_101046_add_index_to_menu_table',1),(19,'2022_07_10_034813_move_lang_folder_to_root',1),(20,'2022_08_04_051940_add_missing_column_expires_at',1),(21,'2022_09_01_000001_create_admin_notifications_tables',1),(22,'2022_10_14_024629_drop_column_is_featured',1),(23,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(24,'2022_12_02_093615_update_slug_index_columns',1),(25,'2023_01_30_024431_add_alt_to_media_table',1),(26,'2023_02_16_042611_drop_table_password_resets',1),(27,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(28,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(29,'2023_08_21_090810_make_page_content_nullable',1),(30,'2023_09_14_021936_update_index_for_slugs_table',1),(31,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(32,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(33,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(34,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(35,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(36,'2024_07_12_100000_change_random_hash_for_media',1),(37,'2024_09_30_024515_create_sessions_table',1),(38,'2020_11_18_150916_ads_create_ads_table',2),(39,'2021_12_02_035301_add_ads_translations_table',2),(40,'2023_04_17_062645_add_open_in_new_tab',2),(41,'2023_11_07_023805_add_tablet_mobile_image',2),(42,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',2),(43,'2024_04_27_100730_improve_analytics_setting',3),(44,'2023_08_11_060908_create_announcements_table',4),(45,'2015_06_29_025744_create_audit_history',5),(46,'2023_11_14_033417_change_request_column_in_table_audit_histories',5),(47,'2025_04_03_000001_add_user_type_to_audit_histories_table',5),(48,'2015_06_18_033822_create_blog_table',6),(49,'2021_02_16_092633_remove_default_value_for_author_type',6),(50,'2021_12_03_030600_create_blog_translations',6),(51,'2022_04_19_113923_add_index_to_table_posts',6),(52,'2023_08_29_074620_make_column_author_id_nullable',6),(53,'2024_07_30_091615_fix_order_column_in_categories_table',6),(54,'2025_01_06_033807_add_default_value_for_categories_author_type',6),(55,'2016_06_17_091537_create_contacts_table',7),(56,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',7),(57,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',7),(58,'2024_03_25_000001_update_captcha_settings_for_contact',7),(59,'2024_04_19_063914_create_custom_fields_table',7),(60,'2024_06_21_083515_events_booking_create_eb_events_table',8),(61,'2025_03_18_095019_update_invoices_table',8),(62,'2018_07_09_221238_create_faq_table',9),(63,'2021_12_03_082134_create_faq_translations',9),(64,'2023_11_17_063408_add_description_column_to_faq_categories_table',9),(65,'2016_10_13_150201_create_galleries_table',10),(66,'2021_12_03_082953_create_gallery_translations',10),(67,'2022_04_30_034048_create_gallery_meta_translations_table',10),(68,'2023_08_29_075308_make_column_user_id_nullable',10),(69,'2016_10_03_032336_create_languages_table',11),(70,'2023_09_14_022423_add_index_for_language_table',11),(71,'2021_10_25_021023_fix-priority-load-for-language-advanced',12),(72,'2021_12_03_075608_create_page_translations',12),(73,'2023_07_06_011444_create_slug_translations_table',12),(74,'2019_11_18_061011_create_country_table',13),(75,'2021_12_03_084118_create_location_translations',13),(76,'2021_12_03_094518_migrate_old_location_data',13),(77,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',13),(78,'2022_01_16_085908_improve_plugin_location',13),(79,'2022_08_04_052122_delete_location_backup_tables',13),(80,'2023_04_23_061847_increase_state_translations_abbreviation_column',13),(81,'2023_07_26_041451_add_more_columns_to_location_table',13),(82,'2023_07_27_041451_add_more_columns_to_location_translation_table',13),(83,'2023_08_15_073307_drop_unique_in_states_cities_translations',13),(84,'2023_10_21_065016_make_state_id_in_table_cities_nullable',13),(85,'2017_10_24_154832_create_newsletter_table',14),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',14),(87,'2015_08_15_122343_create_notes_table',15),(88,'2017_05_18_080441_create_payment_tables',16),(89,'2021_03_27_144913_add_customer_type_into_table_payments',16),(90,'2021_05_24_034720_make_column_currency_nullable',16),(91,'2021_08_09_161302_add_metadata_column_to_payments_table',16),(92,'2021_10_19_020859_update_metadata_field',16),(93,'2022_06_28_151901_activate_paypal_stripe_plugin',16),(94,'2022_07_07_153354_update_charge_id_in_table_payments',16),(95,'2024_07_04_083133_create_payment_logs_table',16),(96,'2025_04_12_000003_add_payment_fee_to_payments_table',16),(97,'2025_05_22_000001_add_payment_fee_type_to_settings_table',16),(98,'2017_07_11_140018_create_simple_slider_table',17),(99,'2025_04_08_040931_create_social_logins_table',18),(100,'2018_07_09_214610_create_testimonial_table',19),(101,'2021_12_03_083642_create_testimonials_translations',19),(102,'2016_10_07_193005_create_translations_table',20),(103,'2023_12_12_105220_drop_translations_table',20);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner title=&quot;Business Forward 2025 Strategies for a New Era&quot; subtitle=&quot;Lead Purpose, Innovate with Passion&quot; description=&quot;Welcome Innovate 2025 Shaping the Future of Business, where industry leaders, innovators, and visionaries come.&quot; image=&quot;main/general/hero-banner-img.png&quot; button_primary_label=&quot;Reserve My Seat&quot; button_secondary_url=&quot;/about-us&quot; button_secondary_label=&quot;About us&quot; button_primary_url=&quot;/events&quot; background_image=&quot;main/backgrounds/hero-banner-bg.png&quot;][/hero-banner][about-us-information style=&quot;3&quot; title=&quot;Innovate 2024 Shaping Of The Future Of Business&quot; subtitle=&quot;about our business conferences&quot; description=&quot;Reflects Our commitment To Driving Progress Embracing Innovation In An Ever-evolving Marketplace. Our Conference is Designed to be a hub for thought leadership, where business pioneers and emerging.&quot; floating_button_label=&quot;Buy Ticket&quot; floating_button_url=&quot;/events&quot; button_label=&quot;Become an Attendee&quot; button_url=&quot;/about-us&quot; quantity=&quot;2&quot; title_1=&quot;Exclusive Keynotes&quot; description_1=&quot;The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.&quot; icon_1=&quot;ti ti-microphone-2&quot; title_2=&quot;Off Side Trips&quot; description_2=&quot;By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.&quot; icon_2=&quot;ti ti-chart-bubble&quot; image=&quot;main/general/about-img1.png&quot; image_1=&quot;main/general/about-img2.png&quot; image_2=&quot;main/general/about-img3.png&quot;][/about-us-information][events-schedule title=&quot;Our Events Schedule Plan&quot; subtitle=&quot;Event Schedule&quot; number_days=&quot;5&quot;][/events-schedule][testimonials title=&quot;What Our Attendees Say&quot; subtitle=&quot;Testimonial&quot; testimonial_ids=&quot;1,2,3,4&quot; youtube_video_url=&quot;https://www.youtube.com/watch?v=ldusxyoq0Y8&quot; image=&quot;main/general/testimonial-image.png&quot; background_color=&quot;#FBF9F4&quot;][/testimonials][events title=&quot;Recent Memories 2024&quot; subtitle=&quot;Last year memory&quot; limit=&quot;5&quot; logo=&quot;main/general/logo-yellow.png&quot;][/events][brands style=&quot;2&quot; subtitle=&quot;general sponsors&quot; title=&quot;Our Official Sponsors&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot;][/brands][blog-posts limit=&quot;3&quot; category_ids=&quot;1,2,4&quot; title=&quot;Balancing Profit &amp; Purpose&quot; subtitle=&quot;News &amp; updates&quot; type=&quot;featured&quot; enable_lazy_loading=&quot;no&quot;][/blog-posts]',1,NULL,'homepage',NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(5,'Events','',1,NULL,'default',NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-05-03 11:32:26','2025-05-03 11:32:26');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'98WO1ZHEDX7B','bank_transfer',NULL,79.65,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(2,'1',0,'JR6R7TIIULKV','bank_transfer',NULL,31.86,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(3,'1',0,'YLV0DGELLCMC','bank_transfer',NULL,31.86,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(4,'1',0,'HTZQJQJ5NTRY','bank_transfer',NULL,63.72,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(5,'1',0,'GWGM3WJOJZ5R','bank_transfer',NULL,79.65,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(6,'1',0,'J3YXBZKHKI0E','bank_transfer',NULL,79.65,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(7,'1',0,'3JBO3Y7SFRIW','bank_transfer',NULL,31.86,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(8,'1',0,'6D8ED7WSRSV7','bank_transfer',NULL,79.65,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(9,'1',0,'0R9QLADHVAH5','bank_transfer',NULL,63.72,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:52','2025-05-03 11:32:52',NULL,NULL),(10,'1',0,'AHC0ISMLWWGY','bank_transfer',NULL,63.72,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(11,'1',0,'UNMZW0ITP2EN','bank_transfer',NULL,36.84,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(12,'1',0,'HBKAZ9IENLYS','bank_transfer',NULL,36.84,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(13,'1',0,'ZUX04Z1PJCOW','bank_transfer',NULL,55.26,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(14,'1',0,'I0YZM8LWLWDE','bank_transfer',NULL,73.68,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(15,'1',0,'EGEXMPRTMCFQ','bank_transfer',NULL,92.10,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(16,'1',0,'1ZTZ7H0CPXDD','bank_transfer',NULL,36.84,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(17,'1',0,'Y8PVJR9GE9VL','bank_transfer',NULL,55.26,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(18,'1',0,'9IGOBGLK4ZCT','bank_transfer',NULL,73.68,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(19,'1',0,'LHUFE9DLDC71','bank_transfer',NULL,73.68,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:53','2025-05-03 11:32:53',NULL,NULL),(20,'1',0,'DGKYJ6OKDNUD','bank_transfer',NULL,36.84,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(21,'1',0,'2Y7U3484ZVSO','bank_transfer',NULL,20.94,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(22,'1',0,'ZNNFAIY56VZN','bank_transfer',NULL,34.90,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(23,'1',0,'SJQINKNLRZDI','bank_transfer',NULL,27.92,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(24,'1',0,'HHUYKWTQESQX','bank_transfer',NULL,6.98,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(25,'1',0,'QRBO7HMYZUBD','bank_transfer',NULL,13.96,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(26,'1',0,'DVAR6Y24RGNS','bank_transfer',NULL,20.94,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(27,'1',0,'V98HRCO2INRU','bank_transfer',NULL,6.98,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(28,'1',0,'AJHZBITWLCGD','bank_transfer',NULL,20.94,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(29,'1',0,'MMJI5A49CXKE','bank_transfer',NULL,20.94,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:54','2025-05-03 11:32:54',NULL,NULL),(30,'1',0,'ZJNYFYMMXMCX','bank_transfer',NULL,6.98,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(31,'1',0,'CHTK0ALWJEQF','bank_transfer',NULL,71.70,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(32,'1',0,'FPZ5BNCEL4CY','bank_transfer',NULL,47.80,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(33,'1',0,'TKUZWOU3BLEO','bank_transfer',NULL,119.50,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(34,'1',0,'POYKF0XFHIKG','bank_transfer',NULL,23.90,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(35,'1',0,'4BTULQFXMW0A','bank_transfer',NULL,119.50,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(36,'1',0,'NGOGGN7BECQY','bank_transfer',NULL,95.60,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(37,'1',0,'C1GUC6AI0HO7','bank_transfer',NULL,119.50,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(38,'1',0,'G1BM1CB7YG8V','bank_transfer',NULL,47.80,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(39,'1',0,'JCMTQAMJXK6H','bank_transfer',NULL,71.70,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:55','2025-05-03 11:32:55',NULL,NULL),(40,'1',0,'EFTQMGEYIUSH','bank_transfer',NULL,23.90,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(41,'1',0,'IHFJPSXQXBYA','bank_transfer',NULL,17.02,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(42,'1',0,'GHCOXIQ3F4HZ','bank_transfer',NULL,68.08,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(43,'1',0,'3WDIZQHQ84KH','bank_transfer',NULL,17.02,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(44,'1',0,'U6AEDIYONE6C','bank_transfer',NULL,51.06,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(45,'1',0,'KM5KKIQUBPWR','bank_transfer',NULL,17.02,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(46,'1',0,'YWYH9K53OSWF','bank_transfer',NULL,17.02,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(47,'1',0,'XWTNQOCXZIGN','bank_transfer',NULL,17.02,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(48,'1',0,'F3DC8BH7JH1Z','bank_transfer',NULL,51.06,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(49,'1',0,'8MYIDINRLPWE','bank_transfer',NULL,51.06,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL),(50,'1',0,'2HINR9QR24BK','bank_transfer',NULL,85.10,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-05-03 11:32:56','2025-05-03 11:32:56',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (4,1),(3,1),(6,2),(4,2),(1,3),(4,3),(4,4),(6,4),(6,5),(3,5),(3,6),(6,6),(3,7),(4,7),(3,8),(5,8),(3,9),(4,9),(1,10),(2,10),(1,11),(2,11),(2,12),(3,12),(1,13),(3,13),(2,14),(6,14),(4,15),(6,15),(2,16),(4,16),(2,17),(5,17),(4,18),(1,18),(6,19),(5,19),(6,20),(3,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (4,1),(3,1),(7,1),(3,2),(5,2),(6,3),(3,3),(7,3),(5,4),(4,4),(7,4),(7,5),(4,5),(4,6),(6,6),(3,7),(1,7),(6,7),(7,8),(5,8),(4,8),(2,9),(5,9),(3,9),(7,10),(5,10),(3,10),(6,11),(7,11),(6,12),(5,12),(1,12),(7,13),(6,13),(3,13),(7,14),(6,14),(1,14),(6,15),(4,15),(2,15),(2,16),(3,16),(2,17),(1,17),(7,17),(1,18),(4,18),(1,19),(4,19),(2,20),(1,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',743,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',1763,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',857,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',492,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',1348,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',1366,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',1605,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',1792,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',2438,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',1888,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',1809,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',433,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',301,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',1129,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',2195,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',1396,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',2449,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',1190,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',1811,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',1353,NULL,'2025-05-03 11:32:34','2025-05-03 11:32:34');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-05-03 11:32:10','2025-05-03 11:32:10');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-05-03 11:33:06'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-05-03 11:33:06'),(6,'language_hide_default','1',NULL,'2025-05-03 11:33:06'),(7,'language_switcher_display','dropdown',NULL,'2025-05-03 11:33:06'),(8,'language_display','all',NULL,'2025-05-03 11:33:06'),(9,'language_hide_languages','[]',NULL,'2025-05-03 11:33:06'),(10,'media_random_hash','afc3b9da7edfb0647d3394b678d56be4',NULL,'2025-05-03 11:33:06'),(11,'theme','eventify',NULL,'2025-05-03 11:33:06'),(12,'show_admin_bar','1',NULL,'2025-05-03 11:33:06'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-05-03 11:33:06'),(14,'admin_logo','main/general/logo.png',NULL,'2025-05-03 11:33:06'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-05-03 11:33:06'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-05-03 11:33:06'),(17,'payment_cod_status','1',NULL,'2025-05-03 11:33:06'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-05-03 11:33:06'),(19,'payment_bank_transfer_status','1',NULL,'2025-05-03 11:33:06'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-05-03 11:33:06'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-05-03 11:33:06'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-05-03 11:33:06'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-05-03 11:33:06'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-05-03 11:33:06'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-05-03 11:33:06'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-05-03 11:33:06'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-05-03 11:33:06'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-05-03 11:33:06'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-05-03 11:33:06'),(30,'theme-eventify-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-05-03 11:33:06'),(31,'theme-eventify-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-05-03 11:33:06'),(32,'theme-eventify-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-05-03 11:33:06'),(33,'theme-eventify-favicon','main/general/favicon.png',NULL,'2025-05-03 11:33:06'),(34,'theme-eventify-logo','main/general/logo.png',NULL,'2025-05-03 11:33:06'),(35,'theme-eventify-homepage_id','1',NULL,'2025-05-03 11:33:06'),(36,'theme-eventify-blog_page_id','4',NULL,'2025-05-03 11:33:06'),(37,'theme-eventify-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-05-03 11:33:06'),(38,'theme-eventify-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-05-03 11:33:06'),(39,'theme-eventify-blog_post_items_per_row','3',NULL,'2025-05-03 11:33:06'),(40,'theme-eventify-number_of_related_posts','3',NULL,'2025-05-03 11:33:06'),(41,'theme-eventify-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-05-03 11:33:06'),(42,'theme-eventify-breadcrumb_text_color','#ffffff',NULL,'2025-05-03 11:33:06'),(43,'theme-eventify-events_page_id','5',NULL,'2025-05-03 11:33:06'),(44,'theme-eventify-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-05-03 11:33:06'),(45,'theme-eventify-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-05-03 11:33:06'),(46,'theme-eventify-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-05-03 11:33:06'),(47,'theme-eventify-event_list_title','Event History Kireon Pollardy',NULL,'2025-05-03 11:33:06'),(48,'theme-eventify-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-05-03 11:33:06'),(49,'theme-eventify-calender_icon_image','main/icons/calendar.png',NULL,'2025-05-03 11:33:06'),(50,'theme-eventify-author_icon_image','main/icons/user.png',NULL,'2025-05-03 11:33:06'),(51,'theme-eventify-views_icon_image','main/icons/view.png',NULL,'2025-05-03 11:33:06'),(52,'theme-eventify-reading_time_icon_image','main/icons/clock.png',NULL,'2025-05-03 11:33:06'),(53,'theme-eventify-category_icon_image','main/icons/menu.png',NULL,'2025-05-03 11:33:06'),(54,'theme-eventify-published_icon_image','main/icons/calendar.png',NULL,'2025-05-03 11:33:06'),(55,'theme-eventify-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-05-03 11:33:06'),(56,'theme-eventify-logo_height','45',NULL,'2025-05-03 11:33:06'),(57,'theme-eventify-is_header_transparent','1',NULL,'2025-05-03 11:33:06'),(58,'theme-eventify-display_header_top','1',NULL,'2025-05-03 11:33:06'),(59,'theme-eventify-header_top_text_color','#000000',NULL,'2025-05-03 11:33:06'),(60,'theme-eventify-header_top_background_color','#FFBA00',NULL,'2025-05-03 11:33:06'),(61,'theme-eventify-header_background_color','#1A1719',NULL,'2025-05-03 11:33:06'),(62,'theme-eventify-header_text_color','#ffffff',NULL,'2025-05-03 11:33:06'),(63,'theme-eventify-footer_background_color','#FBF9F4',NULL,'2025-05-03 11:33:06'),(64,'theme-eventify-footer_text_color','#544E51',NULL,'2025-05-03 11:33:06'),(65,'theme-eventify-footer_heading_color','#1A1719',NULL,'2025-05-03 11:33:06'),(66,'theme-eventify-tp_primary_font','Figtree',NULL,'2025-05-03 11:33:06'),(67,'theme-eventify-tp_heading_font','Space Grotesk',NULL,'2025-05-03 11:33:06'),(68,'theme-eventify-primary_color','#FFBA00',NULL,'2025-05-03 11:33:06'),(69,'theme-eventify-secondary_color','#1A1719',NULL,'2025-05-03 11:33:06'),(70,'theme-eventify-newsletter_popup_enable','1',NULL,'2025-05-03 11:33:06'),(71,'theme-eventify-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-05-03 11:33:06'),(72,'theme-eventify-newsletter_popup_title','HOT DEALS',NULL,'2025-05-03 11:33:06'),(73,'theme-eventify-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-05-03 11:33:06'),(74,'theme-eventify-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-05-03 11:33:06'),(75,'announcement_max_width','1210',NULL,'2025-05-03 11:33:06'),(76,'announcement_text_color','#000000',NULL,'2025-05-03 11:33:06'),(77,'announcement_background_color','transparent',NULL,'2025-05-03 11:33:06'),(78,'announcement_text_alignment','start',NULL,'2025-05-03 11:33:06'),(79,'announcement_dismissible','0',NULL,'2025-05-03 11:33:06'),(80,'announcement_font_size','14',NULL,'2025-05-03 11:33:06'),(81,'announcement_font_size_unit','px',NULL,'2025-05-03 11:33:06'),(82,'announcement_placement','theme',NULL,'2025-05-03 11:33:06'),(83,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-05-03 11:33:05','2025-05-03 11:33:05'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-05-03 11:33:05','2025-05-03 11:33:05'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-05-03 11:33:05','2025-05-03 11:33:05');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-05-03 11:33:05','2025-05-03 11:33:05');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:09','2025-05-03 11:32:09'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-05-03 11:32:10','2025-05-03 11:32:10'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-05-03 11:32:26','2025-05-03 11:32:26'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-05-03 11:32:33','2025-05-03 11:32:33'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-05-03 11:32:33','2025-05-03 11:32:33'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-05-03 11:32:33','2025-05-03 11:32:33'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-05-03 11:32:33','2025-05-03 11:32:33'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-05-03 11:32:33','2025-05-03 11:32:33'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-05-03 11:32:33','2025-05-03 11:32:33'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-05-03 11:32:33','2025-05-03 11:32:33'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-05-03 11:32:33','2025-05-03 11:32:33'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-05-03 11:32:33','2025-05-03 11:32:33'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-05-03 11:32:33','2025-05-03 11:32:33'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-05-03 11:32:33','2025-05-03 11:32:33'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-05-03 11:32:33','2025-05-03 11:32:33'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-05-03 11:32:33','2025-05-03 11:32:33'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-05-03 11:32:34','2025-05-03 11:32:34'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:38','2025-05-03 11:32:38'),(59,'shayna-casper',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:39','2025-05-03 11:32:39'),(60,'daphne-schinner',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:39','2025-05-03 11:32:39'),(61,'mr-ward-wiza',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:39','2025-05-03 11:32:39'),(62,'mrs-pink-bahringer',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:39','2025-05-03 11:32:39'),(63,'afton-feeney-ii',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:40','2025-05-03 11:32:40'),(64,'orville-heaney-phd',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:40','2025-05-03 11:32:40'),(65,'prof-osvaldo-sanford',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:40','2025-05-03 11:32:40'),(66,'dr-alvis-mills-phd',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:40','2025-05-03 11:32:40'),(67,'dr-kolby-jacobs-v',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:41','2025-05-03 11:32:41'),(68,'willie-anderson',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:41','2025-05-03 11:32:41'),(69,'weston-olson',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:41','2025-05-03 11:32:41'),(70,'ally-bayer-ii',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:42','2025-05-03 11:32:42'),(71,'mr-rafael-yost-dvm',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:42','2025-05-03 11:32:42'),(72,'ms-herta-morar-i',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:42','2025-05-03 11:32:42'),(73,'joannie-upton',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:43','2025-05-03 11:32:43'),(74,'eino-kautzer',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:43','2025-05-03 11:32:43'),(75,'miss-lottie-turcotte-jr',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:43','2025-05-03 11:32:43'),(76,'santiago-jaskolski',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:43','2025-05-03 11:32:43'),(77,'evie-jakubowski',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:44','2025-05-03 11:32:44'),(78,'bo-pagac',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:32:44','2025-05-03 11:32:44'),(79,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(80,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(81,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(82,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(83,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(84,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(85,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(86,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(87,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:51','2025-05-03 11:32:51'),(88,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-05-03 11:32:52','2025-05-03 11:32:52'),(89,'laisha-bednar',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(90,'toney-schinner-iv',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(91,'emmitt-gislason',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(92,'marietta-beatty-phd',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(93,'mr-vincent-halvorson-v',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(94,'mr-waldo-sporer-v',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(95,'arturo-boyle-ii',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(96,'santa-boehm',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(97,'prof-arely-koch',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(98,'aracely-hammes-sr',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(99,'manuela-hartmann',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(100,'marianna-skiles',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(101,'mrs-margot-schimmel',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(102,'tina-wolf',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(103,'piper-thiel',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(104,'mrs-myrna-sanford-sr',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(105,'monserrat-johns',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(106,'prof-ernesto-watsica-md',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(107,'sister-deckow',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(108,'milford-upton',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(109,'florine-schinner',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(110,'josephine-kuvalis-sr',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(111,'alvena-torphy',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(112,'javonte-quitzon',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(113,'mitchell-bailey',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(114,'mr-ryder-wiza-dvm',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(115,'jonas-leuschke',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(116,'queenie-marks',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(117,'alva-kemmer',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(118,'robyn-kling',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(119,'briana-fadel',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(120,'alden-mcdermott',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(121,'mrs-ernestina-mcclure-jr',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(122,'emerald-franecki',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(123,'dayna-zemlak',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(124,'odessa-west',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(125,'sydnie-jerde',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(126,'mr-chandler-berge-jr',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(127,'uriel-crona',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(128,'mrs-carrie-volkman',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(129,'sydnee-cruickshank',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(130,'leanna-windler-sr',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(131,'cristian-feest',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(132,'kip-rempel',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(133,'koby-treutel',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(134,'andres-schuster',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(135,'santa-jast-i',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(136,'granville-huels',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(137,'barney-gutmann',70,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(138,'miss-syble-greenfelder-md',71,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(139,'presley-bergnaum-iv',72,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(140,'adrianna-reichert',73,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(141,'marina-gutmann',74,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(142,'katheryn-kirlin',75,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(143,'gennaro-tremblay',76,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(144,'haleigh-kovacek',77,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(145,'dion-cruickshank',78,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06'),(146,'ciara-wuckert',79,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-05-03 11:33:06','2025-05-03 11:33:06');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(2,'England','england','EN',2,0,NULL,0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-05-03 11:32:44','2025-05-03 11:32:44');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-05-03 11:32:33','2025-05-03 11:32:33'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-05-03 11:32:33','2025-05-03 11:32:33'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-05-03 11:32:33','2025-05-03 11:32:33'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-05-03 11:32:33','2025-05-03 11:32:33'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-05-03 11:32:33','2025-05-03 11:32:33'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-05-03 11:32:33','2025-05-03 11:32:33'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-05-03 11:32:33','2025-05-03 11:32:33');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-05-03 11:32:11','2025-05-03 11:32:11'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-05-03 11:32:11','2025-05-03 11:32:11'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-05-03 11:32:11','2025-05-03 11:32:11'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-05-03 11:32:11','2025-05-03 11:32:11');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'rklein@halvorson.com',NULL,'$2y$12$HWLnwSSF2ETPfnIRYKiBnOoU0uwml0wBmjDCGPPoYZt62zEKmafQK',NULL,'2025-05-03 11:32:10','2025-05-03 11:32:10','Walker','Witting','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify',1,'[]','2025-05-03 11:32:26','2025-05-03 11:32:26'),(2,'SocialLinksWidget','header_sidebar','eventify',2,'[]','2025-05-03 11:32:26','2025-05-03 11:32:26'),(3,'SiteInformationWidget','footer_sidebar','eventify',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo-light.png\"}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(6,'GalleriesWidget','footer_sidebar','eventify',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(7,'EventListWidget','event_list_sidebar','eventify',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify',1,'[]','2025-05-03 11:32:26','2025-05-03 11:32:26'),(9,'BlogSearchWidget','blog_sidebar','eventify',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(10,'BlogCategoriesWidget','blog_sidebar','eventify',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(11,'BlogTagsWidget','blog_sidebar','eventify',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify',1,'{\"background_color\":\"#FFBA00\",\"button_label\":\"Buy Ticket\"}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-05-03 11:32:26','2025-05-03 11:32:26'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-05-03 11:32:26','2025-05-03 11:32:26');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-05-03 11:33:08
