-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'L0yxekKygQ386IoTqgaUfz95PoosWAPB',1,'2025-06-10 10:39:01','2025-06-10 10:39:01','2025-06-10 10:39:01');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:39:54',NULL,1,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:39:54',NULL,1,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:39:54',NULL,1,'2025-06-10 10:39:54','2025-06-10 10:39:54');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Accusantium est ratione et et. Cumque aut modi minima et quod repudiandae tempore. Reiciendis saepe ut rerum ut architecto repellat tempora. Sit tenetur quisquam non est nulla.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(2,'Leadership &amp; Strategy',0,'Aut dolore sed quam error. Voluptatem iure quibusdam qui sed dolorum eum. Doloremque aut sed enim amet placeat repellat. Quae voluptatem sunt expedita ut ea.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(3,'Networking &amp; Collaboration',0,'Ab pariatur ex cupiditate libero doloremque necessitatibus. Voluptatem et deleniti nihil occaecati distinctio.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(4,'Entrepreneurship Startups',0,'Corporis tenetur aperiam quia repudiandae enim doloribus itaque. Quas minima ea cum. Mollitia recusandae velit dolorem eos. At vitae quod officiis aliquid veniam quis possimus.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(5,'Marketing &amp; Branding',0,'Id enim vero totam dolores voluptatibus nihil. Corporis architecto nihil aliquam saepe quo modi rem. Accusamus corrupti ut fuga numquam rerum qui.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(6,'Event Highlights &amp; Recaps',0,'Labore illum illo repellat voluptates placeat nobis. Dolore consectetur tempora omnis iusto ut. Est consequatur blanditiis corporis labore dolorem.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:39:25','2025-06-10 10:39:25');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Jerald Boehm','dashawn.lehner@example.org','(564) 695-8980','8351 Zieme Square\nDiannaton, ID 13727-9753','Voluptas et commodi excepturi.','Velit qui fugiat voluptatem. Eum nemo maiores deserunt. Voluptate tenetur laboriosam impedit laborum laboriosam et similique. Facilis et quia ut soluta. Modi officia doloribus enim corrupti. Iste voluptatem ex distinctio maiores eligendi nesciunt dignissimos. Similique recusandae maxime quam consequatur labore maiores et. Repellat est quaerat voluptatem molestias aut ducimus qui. Porro est placeat ea aut. Quisquam porro aut veritatis expedita aut in sit.',NULL,'read','2025-06-10 10:39:01','2025-06-10 10:39:01'),(2,'Chris Wilderman','vidal03@example.org','857-724-7403','4406 Waters Spring Apt. 041\nDejahburgh, IA 76699','Ea consequatur nisi animi.','Id eveniet qui non sunt. Voluptas id fugit ut ut asperiores eaque ipsam. Eius quasi blanditiis impedit aut saepe accusantium. Quia nihil voluptatem rem quia qui eligendi. Soluta perferendis dolor sunt quasi necessitatibus distinctio. Libero minus hic quidem voluptatibus qui similique maiores. Et dolor voluptatum quo dolorem. Doloribus omnis id corporis delectus non ex excepturi. Sit reiciendis nihil deserunt. Et architecto dolores beatae voluptas rerum cumque sunt.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01'),(3,'Dayna Goodwin','bergnaum.cameron@example.org','(515) 641-5769','5890 DuBuque Dale Suite 576\nLake Joe, ND 95671','Ea est unde voluptas consequatur temporibus.','Molestiae molestiae assumenda et hic. Maxime architecto ut et aut ullam aperiam libero. Autem assumenda itaque voluptas. Inventore explicabo sapiente qui. Voluptatem unde inventore nemo et aliquam. Qui placeat quia numquam et voluptatem libero. Debitis eaque blanditiis neque perspiciatis qui atque. Qui excepturi sit incidunt ad autem. Autem minima quibusdam voluptas alias. Incidunt velit possimus animi laboriosam nobis voluptas. Veniam porro aut consequatur et voluptatem alias corporis.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01'),(4,'Ms. Shana Haag PhD','concepcion59@example.org','+12488775150','82915 Brook Mountains Apt. 991\nLake Jadon, AR 31005-4474','Fugit sequi necessitatibus quia eligendi quia.','Laboriosam ut error a sit. Amet voluptatum facere voluptas non tempora dolorem. Voluptas ratione ut doloremque et et placeat. Beatae nemo nihil qui dolorum molestiae corrupti aut velit. Nam et cupiditate eligendi quam aperiam quia omnis. Et unde reprehenderit magni sed sed sit. Beatae dolorum quis qui voluptatem rerum exercitationem. Velit laborum id non reprehenderit provident quasi. Id enim facilis et minus.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01'),(5,'Cristina O\'Hara','hondricka@example.com','231-980-9314','825 Johnston Plains Suite 046\nTurnerville, MD 87460-9424','Eos suscipit quam dolorem deleniti.','Omnis incidunt fuga in mollitia aliquid est dolorem. Velit repellendus commodi et repellendus. Qui dolorum aut fugit cumque eligendi. Soluta a illum laborum. Reiciendis laborum recusandae aut magnam repellat et voluptatem. Quod sint quisquam pariatur atque. Velit temporibus est optio enim earum esse doloremque et. Quas reprehenderit quidem sapiente deserunt error laboriosam tempore. Consequuntur nam qui possimus omnis quia.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01'),(6,'Miss Frieda Greenholt','rachael.erdman@example.com','205.942.2600','45719 Randall Wells Suite 747\nNorth Antwon, RI 62235','Aspernatur odio explicabo corporis.','Perspiciatis eaque repellat et ab ducimus sequi. Sit necessitatibus occaecati et dolorum laudantium alias. Qui et rerum quidem aperiam. Sit aspernatur mollitia qui nisi. Et sit in nihil temporibus modi rerum non. Porro dolorem tempora iure totam temporibus nihil et. Qui rerum iste quo repellendus quia at. Et aspernatur sit debitis ab dolores. Autem eos natus et aliquam eos nostrum ea.',NULL,'read','2025-06-10 10:39:01','2025-06-10 10:39:01'),(7,'Nichole Mitchell','fredy13@example.com','872-328-0007','597 Swaniawski Pass Apt. 463\nNorth Oswaldo, NV 12757','Illum eaque enim fuga porro.','Sed nostrum sit et non nam. Saepe at veritatis consequatur ut numquam a aut. Excepturi eveniet excepturi praesentium ut. Aut nisi vitae omnis saepe exercitationem. Aut provident sapiente fugit ea et. Voluptatem voluptatibus cupiditate hic unde molestiae blanditiis porro. Est sapiente iste labore aut. Necessitatibus earum neque voluptas ipsa neque et et. Illum voluptas excepturi sed impedit. Eaque minus voluptate rerum praesentium ullam.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01'),(8,'Ottilie Goodwin','stracke.gerson@example.net','574-856-3495','692 Grimes Ferry\nLake Ava, NM 58631','Cumque quia quo nihil magnam non.','Molestiae illum ut et nobis officia voluptatem earum labore. Molestiae suscipit laudantium velit reiciendis libero. Atque repellendus in perferendis. Sit saepe beatae dolore rem a amet in id. Dicta quisquam est voluptate ipsum omnis. Voluptatem est sit architecto aut. Facere nam quia soluta earum. Animi qui qui et ea magnam sint. Ea laborum in commodi iste numquam. Officiis tempora reprehenderit veritatis voluptatibus ab provident dignissimos quia.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01'),(9,'Jamey Bernhard','zmacejkovic@example.com','308.571.2455','16083 Reinger Mews Apt. 020\nHoustonfurt, SC 34573','Assumenda dolorum reiciendis molestiae dolorem.','Consequatur dolores harum nulla eligendi beatae aut cumque. Eveniet magni aut qui. Et modi quia quia ut. Omnis quis quaerat qui eligendi. Aut ex deleniti qui et cum omnis corporis. Perferendis exercitationem et in et in. Dolorum aut ut voluptatum mollitia deserunt maxime voluptatem. Quia ea rem est cumque nisi. Et neque eius repellat aperiam reiciendis. Similique optio libero et nostrum aut non expedita.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01'),(10,'Prof. Mireya Lindgren','schmeler.christy@example.com','+14758680028','5160 Reymundo Gardens Apt. 995\nWest Rosalinda, MO 77403-6975','Voluptas et sit reprehenderit id.','Molestias quia commodi ratione. Praesentium libero praesentium repellendus. Nihil commodi aut ut numquam animi officiis non. Aperiam qui ea veritatis labore delectus. Labore qui enim alias quo rem. Consequatur excepturi omnis aspernatur quaerat. Architecto quisquam beatae architecto rem. Consequatur dolores aut voluptas aut ex dicta. Perspiciatis recusandae ex laborum repudiandae voluptates consequuntur. Aut molestiae nostrum odio cumque est quia.',NULL,'unread','2025-06-10 10:39:01','2025-06-10 10:39:01');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:39:36',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:39:36',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:39:36',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:39:36',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:39:36',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:39:36',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Jessyca Casper','customer@archielite.com','$2y$12$/mXdBIdEgd85ElZDUqR7meJHhAfPBEr6RZ18DoDDTQKWphQ6dvcwS',NULL,'0445407153','2004-10-17','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:30','2025-06-10 10:39:30'),(2,'Michael Smith','bonita30@nienow.com','$2y$12$yd4PkxzU48Z9NrGrfZ8NjuLQINJBqZfgYh2/KI2ALl2znVw6PT95i','homepage02/speakers/1.png','0083483718','2017-05-28','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:31','2025-06-10 10:39:31'),(3,'Mr. Rocky White Jr.','xyundt@kuhic.info','$2y$12$0PXqNIcI9uJyqeiAzFnsD.vkRPFt6eDUA9kBmCYoFgQoTYJwYN5au',NULL,'0648588213','2005-08-20','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:31','2025-06-10 10:39:31'),(4,'Hank Legros','jquigley@yahoo.com','$2y$12$wYvK5xzZkC9x6zhsRKLS3OlSMDu9GQstbsJ8Y9ni6kLlUXfbjsZJu',NULL,'0883012627','2011-07-03','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:31','2025-06-10 10:39:31'),(5,'Melvin Deckow','brady.hilpert@hotmail.com','$2y$12$Ufd49siAljTa8N4M.aZmq.Xw60rzMh2ww.wnPMLamMzmk1fH5id6G','homepage02/speakers/4.png','0623661750','1997-12-17','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:31','2025-06-10 10:39:31'),(6,'Prof. Zander Connelly','jailyn43@yahoo.com','$2y$12$RXOC7O4b5BtSF6WAHl4XKeKnUJ8BnMLlWhGwKL0NtKJvkcnJUqh.G','homepage02/speakers/4.png','0299148177','2005-04-01','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:31','2025-06-10 10:39:31'),(7,'Mr. Jarod Zulauf','haskell.botsford@huel.net','$2y$12$t5M1QTwe11xLmiQPe.vtg.984Q8KHNdn8RLZawGm2q4YHXoA5SzdO',NULL,'0087097846','2000-07-29','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:32','2025-06-10 10:39:32'),(8,'Willy Berge II','zsteuber@sauer.com','$2y$12$r3RgIoYrYPlGJFe9vWXflOHFyYFJ2o1oPC6QSGX/5UOyFZ0DiGVmG',NULL,'0706914233','2006-11-17','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:32','2025-06-10 10:39:32'),(9,'Lilian Pagac','ahmad16@hotmail.com','$2y$12$I/u2IBVMUPa5MUPBQZfSYOi8Dv4G4yp3AC46hkUa9pA58gVPaaNra','homepage02/speakers/3.png','0863680681','2025-06-05','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:32','2025-06-10 10:39:32'),(10,'Miss Agnes Hermann','rollin.shanahan@hagenes.info','$2y$12$RYhRCWbBz2MnazbDpIALteRgl5Cqn3ztztKU91Pud55WBu3dc8RTO',NULL,'0439312463','2011-08-30','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:32','2025-06-10 10:39:32'),(11,'Blanca Fahey','ogreen@upton.org','$2y$12$7nyS/uJo8Q5bQ6gO255Hm.48iuMNt7dSFdZ4Ir2Giysra3F.F4iVi','homepage02/speakers/3.png','0007202211','1998-10-06','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:32','2025-06-10 10:39:32'),(12,'Lia Moore','bernier.jessica@gmail.com','$2y$12$Br5WpwscT4CNsfS6mz3ZI.FGiNcw6SbyxtO6xGhLCIi8e.kFbi4x.','homepage02/speakers/1.png','0403817199','1998-12-06','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:32','2025-06-10 10:39:32'),(13,'Misty Bogan','kgleichner@koss.com','$2y$12$xK8fjRbUsGcE8QimFqFl2.yYBOPcistqj9DvLMYjJsqJzA8NC0oju','homepage02/speakers/2.png','0911330603','2005-03-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:33','2025-06-10 10:39:33'),(14,'Icie Walter','pwill@yahoo.com','$2y$12$nZMTvyiP8jNnXh4VoUw2cenwN1gUb5jOCEeOK8uxkeEDOcPvOtzha','homepage02/speakers/3.png','0948485140','2013-09-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:33','2025-06-10 10:39:33'),(15,'Fermin Lindgren Jr.','wiley26@yahoo.com','$2y$12$OUnfiJYTEyiDRlSGVF.Dcel8HlVfh6JvqVsTKLxHeetEWDZXyD.ry',NULL,'0390017342','2001-09-01','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:33','2025-06-10 10:39:33'),(16,'Mac Price','will.willa@yahoo.com','$2y$12$TPSLuBVdpnKhc9UWoYA/J.5RVkivbiJ4HQCj2xGjKPiB02HgYDa0q',NULL,'0962917982','2016-04-09','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:33','2025-06-10 10:39:33'),(17,'Miss Leilani Beer','stoltenberg.kendrick@kris.com','$2y$12$EWd4QoEUwItgoRE49RCod.N6M7EqUpl4oFnqllCcQRQvbxvizIc5q','homepage02/speakers/4.png','0448401540','2015-05-07','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:33','2025-06-10 10:39:33'),(18,'Prof. Gia Hickle','delta70@altenwerth.com','$2y$12$BqdI/cEMHLxF9nPgo9yw2u0db3qT.cV9cZL9FnIqXTe5oTRfTN4oG','homepage02/speakers/3.png','0123651703','2006-10-01','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:34','2025-06-10 10:39:34'),(19,'Kayden Ullrich','sbatz@fritsch.net','$2y$12$DG9uMuNnmD7A9rfraIXIHeKbPPAwaxzuKnp0gpyG0qeiJDGbNjbZi','homepage02/speakers/1.png','0778077311','1998-01-12','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:34','2025-06-10 10:39:34'),(20,'Frederick Dooley V','patsy.feeney@yahoo.com','$2y$12$RM7/ups.OiIMQK7lK5WXvO/zPJLdw15arwRaX8uVjSChiDIwHEeGC','homepage02/speakers/1.png','0033403992','2023-04-24','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:34','2025-06-10 10:39:34'),(21,'Prof. Braulio Nienow','fay.mario@yahoo.com','$2y$12$mbKpZcxRSGnxkOf08T0aNukfE3Gvkpm1uSkLg.J6ttBUVAomRZYBq',NULL,'0755900868','2009-04-09','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:34','2025-06-10 10:39:34'),(22,'Brenda Krajcik','ppagac@daniel.com','$2y$12$UlBlGKeWXnK6ci1TEMljPeuOXXVHCybx6srLWL.quhw/esSaCK/Tu',NULL,'0760663024','2005-01-24','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:34','2025-06-10 10:39:34'),(23,'Riley McClure PhD','jerome22@hotmail.com','$2y$12$n9zsRkmRpVf1yOo9kY5VIe3uUpOCJP3bYQ3AEgQS/Kiy9Z9Ud0XCK','homepage02/speakers/1.png','0549587472','2006-06-17','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:39:34','2025-06-10 10:39:34'),(24,'Heaven Shields','celine.macejkovic@balistreri.biz','$2y$12$MI7GtLbAsDA8.oHSS9xq9uA8eBxNApz0vkE.MBWHI8RrKNiE2DmSi',NULL,'0992222051','2022-01-11','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:35','2025-06-10 10:39:35'),(25,'Rafael Strosin','marjolaine96@kuvalis.org','$2y$12$A57LNDed1fjdAKvh9K8seuCobPgHTDBaKwcpXNm32GKV5S/Lt/C8a','homepage02/speakers/1.png','0093752116','2014-10-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:35','2025-06-10 10:39:35'),(26,'Dr. Wilfrid Schowalter DVM','zieme.haven@yahoo.com','$2y$12$l.rmaj0vq701iJ9Jm/jCb.abH4AQbHIEb4.MzkrjYDKBXfiMBBOJS',NULL,'0166720661','2021-08-30','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:35','2025-06-10 10:39:35'),(27,'Brenna Rippin','isai49@mayert.biz','$2y$12$ewaM1mdL.e.HGmTZh0h4VOxxL2d6cbTt1NqHvwFPyaFdeqhdtsTsS','homepage02/speakers/3.png','0722595011','2013-08-03','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:35','2025-06-10 10:39:35'),(28,'Prof. Berry Bartoletti','cleo.fahey@hotmail.com','$2y$12$H1rVDKfCSjqq.R6/4MgupuMVLDcYfZC8JdERPJk3LImscizVEITsa',NULL,'0713381950','2021-09-07','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:35','2025-06-10 10:39:35'),(29,'Catherine Robel','cindy31@lynch.net','$2y$12$HiLZK44y6F0rbRDNRAIJc.fpr4JUEcCwp0jaP36owFyUdZoEO.HrG','homepage02/speakers/3.png','0400583961','2000-08-02','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:39:36','2025-06-10 10:39:36'),(30,'Alan Mohr','miles.stanton@yahoo.com','$2y$12$8.kXQQAq0e6ovZga8D9s3u6QhKIgGQY05OiLBxcpzgBXRwW4.UuyC',NULL,'0268666164','1997-11-08','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:36','2025-06-10 10:39:36'),(31,'Rhea Prosacco','barrows.casey@damore.com','$2y$12$ZJJ4nllFqILg1iHsDvy.cO5ZdU5.8S/kkRofkkDY5GHv6Cc8Qr2G2',NULL,'0844996542','2021-07-07','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:36','2025-06-10 10:39:36'),(32,'Mr. Davion Jaskolski','kmurray@hotmail.com','$2y$12$GpNIXlL57gsymzcgTG0YMepJbbauVZBKj1zkXmQnhOa1/PESLcXQS',NULL,'0370946829',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(33,'Craig Lockman MD','brown.madeline@fay.com','$2y$12$xA7916GyaiqT8CbmcCZ06.iJTCaefFkTnrn9BUhIQ8aQYruKJPLE.',NULL,'0254872037',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:48','2025-06-10 10:39:48'),(34,'Maybelle Sanford','meaghan.hirthe@reilly.com','$2y$12$u4zcxO8WhIygEdpS.qEWYOUAhhUl/pKbTS5LW0P/SqovYtKNsTDmu',NULL,'0023847677',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:48','2025-06-10 10:39:48'),(35,'Rosalinda Funk','zkunze@gmail.com','$2y$12$lM2QcIgvCOyaQkIjpr/UpeNsikSbyhCB844wcPjMeFwxo0QWHDjca',NULL,'0272010470',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:48','2025-06-10 10:39:48'),(36,'Rusty Mante','zlangworth@harber.biz','$2y$12$a5.Sc7jaZlfhhqvy74b87Om6n7Ystv6JmX5XW3eWhnM9aw.rPXOha',NULL,'0913669976',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:48','2025-06-10 10:39:48'),(37,'Grady Padberg','enos.jacobs@hotmail.com','$2y$12$xUlkAxF.7QBxcjP1qC5jGOLOc5lRN.PZGPVBrZyEQnN5ErWCntylG',NULL,'0996478062',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:48','2025-06-10 10:39:48'),(38,'Kurtis Schneider','grayson15@hotmail.com','$2y$12$L.1sxi6TmY1cVjQT3TLbKudoPro.2f75zG7qFxSH6qs25bByQhGiW',NULL,'0877867701',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:48','2025-06-10 10:39:48'),(39,'Adeline King','rickey09@yahoo.com','$2y$12$Jnka/YffjMX4rNHazGjAQOsmUKC/bgTl4aYEZCJyiub4aF8zKydeW',NULL,'0717807504',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:49','2025-06-10 10:39:49'),(40,'Ara Prohaska','sreichel@hotmail.com','$2y$12$.eNZItSesqe00XSwocSg7.aOcQ2ckpSY.wd6QeUrj99auagw7WH0C',NULL,'0733319210',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:49','2025-06-10 10:39:49'),(41,'Ariel Breitenberg','litzy63@conn.net','$2y$12$/bnAi3lj2HWZPlg.4k7Xj.iRnOHTFcwAa8FJfVcjCOUBybtPDn8bu',NULL,'0005589643',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:49','2025-06-10 10:39:49'),(42,'Diana Quigley','kaylee.rempel@yahoo.com','$2y$12$yrn15PqyIziXLrLiAwu71.m6uxiUm.P7EN4PSiEoudbS3dQECpsce',NULL,'0061361087',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:49','2025-06-10 10:39:49'),(43,'Dolores Dare I','hahn.estell@gmail.com','$2y$12$9RFmSH8P04EFGsvDEsObVOY8UUoOUwk2zoyVvj3xnfvcqNKY7JA4O',NULL,'0884058717',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:49','2025-06-10 10:39:49'),(44,'Blanca Dickinson I','kkulas@hotmail.com','$2y$12$31u8mcttPqw0Z1E55m7.JeZHhpG/jvFipcUT5AuckGF8X5gbtXQny',NULL,'0643600456',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:49','2025-06-10 10:39:49'),(45,'Brant Langworth','schinner.hortense@oconnell.info','$2y$12$89d6BnsA6h/4TkZttxKOw.tIrHFtWrsBrstEgtPlYygbHU/ijLTHy',NULL,'0344025895',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:49','2025-06-10 10:39:49'),(46,'Percival McGlynn V','ypowlowski@gmail.com','$2y$12$sxGAOEMNaWhidaC5fOAlrOug.THRZJXWugI8n8C8JAsjmCt2..U5i',NULL,'0783742962',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:50','2025-06-10 10:39:50'),(47,'Miss Loma Bartell IV','wheathcote@harris.com','$2y$12$hSweGFGtSVTy0BBjf6jNr.3YOw5lSLB1CaIOgcLg0VmT.oSv9u5dm',NULL,'0400635521',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:50','2025-06-10 10:39:50'),(48,'Bethany O\'Kon','clueilwitz@osinski.org','$2y$12$uWKCgvweVXt9lnTIS1OaluKfhO2L7oPvDUZ5n4T9CozovG5F6CAce',NULL,'0815676798',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:50','2025-06-10 10:39:50'),(49,'Mrs. Herminia Roob Sr.','qschuppe@kertzmann.com','$2y$12$3nPrb8MQxStW32EQ6OSvoOGoU8VpbdiMw5JRg8rTvoJqZ0KUJ8TLC',NULL,'0934739722',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:50','2025-06-10 10:39:50'),(50,'Prof. Newton Kilback Jr.','rau.isadore@gmail.com','$2y$12$01tUYcFabo9wdDSZ9Lbj/.dnneF3uIHhO7Y6yo4/QO.rcIeYZ5JzO',NULL,'0650331476',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:50','2025-06-10 10:39:50'),(51,'Valentin Boyer','muriel.fahey@hammes.biz','$2y$12$ozuwypG2pm9CZiuWx8zFMei7PRrqcvD8s3Wm0rLAj7ru5l8p7XUC6',NULL,'0075063950',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:50','2025-06-10 10:39:50'),(52,'Dr. Keanu Kihn III','umclaughlin@gmail.com','$2y$12$fws.ahrZySRGtYeK/jeJ/eI/Mjsyd9uuKYAblGmvQTijBzqYXXhBm',NULL,'0866636238',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:50','2025-06-10 10:39:50'),(53,'Ms. Lauryn Nienow Sr.','quitzon.alaina@breitenberg.net','$2y$12$crdfpbFYiyw6lsJpYjPftOvPMO21mKqclrovUcYnpAPyA4fL3pe6K',NULL,'0121993020',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:51','2025-06-10 10:39:51'),(54,'Morton Abbott','harris.dayton@gmail.com','$2y$12$YZrRbl4mHu63AELg6hfN3evoBM8TE1/3rGaI4DeB.9oFsjjwq8nd2',NULL,'0849761393',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:51','2025-06-10 10:39:51'),(55,'Karina Abbott','francis.dooley@hotmail.com','$2y$12$J2ChPkDQe/wkry0EB8F0A.LMve2J9wpK1HuhnPy6nAe.vSwQrqP.a',NULL,'0185692306',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:51','2025-06-10 10:39:51'),(56,'Magali Rice','giovanny.jaskolski@yahoo.com','$2y$12$oSzUuWY.LTp0QfS6m8IV4uoSnl5H0eDQn03gsKRC.2cnfci64lQt.',NULL,'0208924594',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:51','2025-06-10 10:39:51'),(57,'Mr. Edmond Becker I','marks.shanna@borer.biz','$2y$12$uJUVUDe3OGoMUzHS3Kei6O1chbxPbfMJhf8TNQlKoEwiWrtE.X8q2',NULL,'0713438525',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:51','2025-06-10 10:39:51'),(58,'Prof. Jarrod Koepp','hirthe.willis@hotmail.com','$2y$12$y7NxCaTGU7vgnaG5AOQcS.kKW7f2EQmy6YHMlqeU4rHMF.tom55u.',NULL,'0620143799',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:51','2025-06-10 10:39:51'),(59,'Neva Welch','jeanette78@kovacek.com','$2y$12$gl/chLg44GCzMfkuSSO/kuJjpu3woELoDXaEm2/NF05x1Ih.eKXSK',NULL,'0611830737',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:51','2025-06-10 10:39:51'),(60,'Dr. Celestine Feest Sr.','abdiel.parisian@cassin.info','$2y$12$7hGr/.IlE2bAbxZGsDuRzeFD4Jb7LvPeF8ORJe8aKwh4/nn5imeia',NULL,'0262081006',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:52','2025-06-10 10:39:52'),(61,'Catherine Kertzmann','swift.dariana@effertz.com','$2y$12$OOwPYedi6zHeGom2qcPRYOl3JUFj8fGhKhSOyu4sZYMaHLOLqxrgS',NULL,'0408565203',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:52','2025-06-10 10:39:52'),(62,'Mrs. Letitia Douglas IV','jamal21@kutch.com','$2y$12$c7MuTXW8kbhNgan44ufVWef.VaoWBXKfryEuKh6vkFxIZJTdAbnJy',NULL,'0121077329',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:52','2025-06-10 10:39:52'),(63,'Dr. Danika Kshlerin Sr.','norwood42@gmail.com','$2y$12$HLavqdT2amnc2lPf/uvQsOZZIoUgt9wX0t5YCO6XdkYeEJKv0HGqa',NULL,'0702465966',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:52','2025-06-10 10:39:52'),(64,'Miss Baby Baumbach IV','roscoe57@gmail.com','$2y$12$9RwRWVUomEUkbn0edqi0juKdICfEhAG0vP3lMgD3YCOsNbA6RzQoS',NULL,'0927537094',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:52','2025-06-10 10:39:52'),(65,'Mr. Anthony Welch','gunnar99@yahoo.com','$2y$12$Mn/3/kYgi7ihckF6qh.nCupuOBtPuyNJ2N45nQDaVx2knhB.L0tEm',NULL,'0632058601',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:52','2025-06-10 10:39:52'),(66,'Prof. Ethelyn Beatty Sr.','eulah.miller@gerhold.org','$2y$12$twNpDfk.kDhtEJumeUQy2.OBi4.7x/6ppTs/iTKKUKwPCI3vkWYpy',NULL,'0826350017',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:53','2025-06-10 10:39:53'),(67,'Prof. Samson Mueller III','quitzon.orpha@okeefe.info','$2y$12$k8fqeZNRVjH53729SpcMBOGkMAdzDActRZPQmTn//xBVsDDC6j1/m',NULL,'0622663355',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:53','2025-06-10 10:39:53'),(68,'Mrs. Gia Zieme PhD','ricky.legros@gmail.com','$2y$12$mTfZe4m.U/dHZfBMrRexFOijaFSpwp6psQ0zRz2Wuw4HUuYi96Zle',NULL,'0169394752',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:53','2025-06-10 10:39:53'),(69,'Floyd Collins','kilback.theresia@gmail.com','$2y$12$TXvgIoSYLIsEH0vy7lQiv.nr/em2zb5XFHVP/zX.hdONdU5ucvDgK',NULL,'0913874728',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:53','2025-06-10 10:39:53'),(70,'Adela Orn','frieda.cassin@gmail.com','$2y$12$PYveZXTNG2DLTkBQSnuj..YCTnmSviisR4cnudhWz/uCtnM/KJjp2',NULL,'0849331927',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:53','2025-06-10 10:39:53'),(71,'Weldon Kuhic','jeramie.simonis@cormier.com','$2y$12$gEO2fRKcSOMjmuNW7IDxpeUj1PfDq1vzRmBZU6VVDz7tUHiOIqIWa',NULL,'0797710859',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:53','2025-06-10 10:39:53'),(72,'Kaylin Homenick','emelie31@torp.com','$2y$12$BUv02Xqj3Iszi9ltxzvbH.7/ckuTXVNvS3f.BwMRXiulGD6K2lxIG',NULL,'0563580714',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:53','2025-06-10 10:39:53'),(73,'Lina Sawayn Jr.','ksauer@yahoo.com','$2y$12$JOp44wc4WuIAUOIxve/9jOuHQT1xhI8rBIeDbtphHUobmTl6NYGP.',NULL,'0847534490',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(74,'Lisette Conn','deja.hermann@gorczany.com','$2y$12$GZx1FgW2lygPKc1Q2MBANeAcep1x0wb50wXJPwq4GvIIgn1u7I4BK',NULL,'0115565528',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(75,'Lucious Sanford V','werner17@nader.com','$2y$12$EpWMIEloN80sVoLBywWDuuYGkqrL6k/MkRItuZRCRZ9pnRDaPCUni',NULL,'0817634549',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(76,'Mr. Johan Dibbert MD','ojohnston@von.com','$2y$12$FKjyvRa5FuPlXlALpi0VAeyMIwoHyBztOsFFUcSa6jSomYGkq.nHO',NULL,'0580485221',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:39:54','2025-06-10 10:39:54');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:38:54','2025-06-10 10:38:54'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:38:54','2025-06-10 10:38:54'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:38:54','2025-06-10 10:38:54');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (4,54,'058V7NAWHHPJ',NULL),(1,35,'07BEPELMHQIK',NULL),(4,53,'0X9SDGJ5SNPB',NULL),(4,47,'15CRYFIAXIQG',NULL),(1,32,'2049QYSDTCAM',NULL),(5,67,'2RTIYUOZCA79',NULL),(3,44,'49RBXRUFCJUX',NULL),(5,68,'A8MOOCXIHRVI',NULL),(5,75,'BJJDVR8GWO7V',NULL),(5,65,'ECB7WCQBMANE',NULL),(4,48,'EDQROYRBPEKB',NULL),(5,76,'EJS8I9ZHIZEI',NULL),(1,37,'ENH9RK9WR91G',NULL),(4,59,'G9VDCNAC4CBI',NULL),(5,64,'GJ5Z0KTSUQSL',NULL),(1,38,'H8ZDSDUAIK5O',NULL),(4,50,'HE2L4UNUKSXX',NULL),(4,58,'I2MQYQEXI1LS',NULL),(5,66,'IHZMH29AA4V6',NULL),(1,36,'IZRSXDCF9T0L',NULL),(3,42,'JLKOVMF3Q0DB',NULL),(1,41,'KBDJIT4HG19P',NULL),(5,74,'KEKQJLVUSCQX',NULL),(5,63,'MEISYKMSBHEM',NULL),(1,34,'MFE3MRSN8Z14',NULL),(5,69,'MYXWWO2SCGMC',NULL),(3,45,'NZKDENS9IZW9',NULL),(5,62,'P2WMXHM4IJHO',NULL),(5,61,'PBDUNIMRWO2G',NULL),(1,40,'PTTRR2KUEJXG',NULL),(5,70,'S73MPX7VJWL8',NULL),(5,71,'SGBOEXBJRSDT',NULL),(1,33,'SMU6IYZEAFF9',NULL),(3,43,'TEL97KGFXNOU',NULL),(4,55,'UFQ934ONN6FH',NULL),(4,56,'VARTQOEU6RHM',NULL),(4,51,'VJWEED1PARKZ',NULL),(3,46,'VWKXQRQFELXY',NULL),(5,72,'VXVPOZAMBUZY',NULL),(1,39,'WPD6NONGKTDP',NULL),(5,60,'WVJRUAHLEZ8V',NULL),(5,73,'WX5JIMOA5OEF',NULL),(4,49,'XZKZYA6JVXLY',NULL),(4,57,'YXAG20WGFWVC',NULL),(4,52,'ZJO3EIPIGRI0',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,9,'Et qui veniam et quis commodi doloremque ad. Consequatur earum doloremque et sed nam.',NULL,0,NULL,NULL),(1,25,'Omnis et corporis sit dolor est ad. Aliquid dolor vel facere aut expedita dolores blanditiis.',NULL,1,NULL,NULL),(1,12,'Iure aut et neque perspiciatis nihil omnis. Optio non vel ipsam sapiente.',NULL,2,NULL,NULL),(1,13,'Provident est sapiente iure nesciunt. Officia autem soluta sapiente quidem veniam maxime.',NULL,3,NULL,NULL),(2,27,'Similique quia qui accusantium quo ut. Neque mollitia corporis ex dignissimos fugiat.',NULL,0,NULL,NULL),(2,14,'Corrupti laudantium voluptas voluptate vero rem. Facere eveniet doloremque nam error.',NULL,1,NULL,NULL),(2,9,'Cum facere rerum odio quod veritatis sint. Adipisci distinctio tenetur voluptas id.',NULL,3,NULL,NULL),(3,29,'Cum autem voluptatem quia dolor quaerat numquam. Labore ea iusto corporis dolorem et.',NULL,0,NULL,NULL),(3,25,'Unde laudantium sunt porro similique repudiandae necessitatibus. Iusto fugit tempore eius quas.',NULL,1,NULL,NULL),(3,13,'Eos mollitia cumque suscipit minus quos officia. Totam et dolor nobis. Rerum et est ut et.',NULL,3,NULL,NULL),(4,14,'Quam optio nisi vel quia nulla odit quae. Minima pariatur labore saepe temporibus consequuntur.',NULL,0,NULL,NULL),(4,27,'Qui debitis nobis porro. Soluta facere rerum ex laborum esse. Deleniti autem unde et iusto.',NULL,2,NULL,NULL),(4,12,'Sint maiores in sunt ab. Autem adipisci dolor aut itaque et non. In et quibusdam aut est et rem.',NULL,3,NULL,NULL),(5,25,'Repellendus reiciendis fugiat reprehenderit et. Deserunt ut placeat quos at error unde.',NULL,0,NULL,NULL),(5,9,'Sapiente totam non veniam aut sint qui. Ipsum sit qui numquam ut qui reiciendis.',NULL,1,NULL,NULL),(5,12,'Blanditiis ullam dolor iste ad. Pariatur odio exercitationem adipisci et iusto minima.',NULL,2,NULL,NULL),(5,27,'Aperiam velit illum omnis ut qui blanditiis minus. Sit ipsam assumenda accusantium et.',NULL,3,NULL,NULL),(6,9,'Magni modi et quo. Provident enim explicabo labore ea.',NULL,0,NULL,NULL),(6,12,'Sed hic quia id. Et est consequatur nisi ut. Voluptatem molestiae perspiciatis omnis aut.',NULL,1,NULL,NULL),(7,9,'Et eum dolor expedita laborum ipsum. Ducimus rerum expedita consequatur corporis iure.',NULL,0,NULL,NULL),(7,14,'Molestiae autem laboriosam maiores et. Reiciendis aperiam dolores exercitationem ipsum deleniti.',NULL,2,NULL,NULL),(7,27,'Magnam est est quam tempora. Veritatis nam asperiores tempore temporibus quia.',NULL,3,NULL,NULL),(8,9,'Perspiciatis dolore est voluptate omnis. Illum earum inventore sunt quis impedit expedita commodi.',NULL,0,NULL,NULL),(8,29,'Laborum minima officiis ut numquam. Non nihil dolores eos. Omnis rem minima et soluta.',NULL,1,NULL,NULL),(8,13,'Rerum provident eligendi ut consequatur quo. Ut dolor tempora est ipsam labore similique.',NULL,2,NULL,NULL),(8,27,'Ut illo qui est accusamus commodi quo natus. Est veniam veniam ut culpa. Sit id fuga et aut et.',NULL,3,NULL,NULL),(9,14,'Doloremque quam architecto fugit voluptatem. Eos doloremque magnam magni qui nihil quam illo.',NULL,0,NULL,NULL),(9,9,'Totam quo qui id iusto omnis rerum. Maxime maiores voluptatem aut.',NULL,2,NULL,NULL),(9,27,'Natus non nobis quis aperiam sed repellendus laborum. Enim repudiandae sit iusto aut.',NULL,3,NULL,NULL),(10,25,'Est quia sequi iure eos in omnis nulla. Quidem eum eum laborum est.',NULL,0,NULL,NULL),(10,27,'Non eveniet sed soluta. Qui cupiditate dolore est assumenda earum iusto nesciunt.',NULL,1,NULL,NULL),(10,9,'Labore quas doloribus nam optio explicabo earum. Consectetur possimus id suscipit aut ab.',NULL,2,NULL,NULL),(10,29,'Molestiae sed harum rerum in. Distinctio blanditiis minima quia fuga dolorem maiores.',NULL,3,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',19,'Voluptate perspiciatis eligendi molestiae.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','b07513a7-6656-3cff-a6f3-c31613927b08','main/events/1.webp',93.93,'6396 Turner Mount\nNew Wiley, ND 90094',3,NULL,NULL,'41.140619','-131.137387',58,0,'2025-06-10 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(2,'Mobile World Congress',23,'Ab eos tempora dolorem nam odit.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','5a144964-2d54-34af-a535-b7483ba805fb','main/events/2.webp',92.63,'57450 Grady Corners Apt. 954\nBeershire, SC 99601-4593',3,NULL,NULL,'18.297973','95.590538',82,0,'2025-06-10 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(3,'Google I/O',18,'Cum enim excepturi maiores tempore totam pariatur consectetur.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','7ba6cf89-31b3-3060-ae24-abe43f8b490c','main/events/3.webp',32.19,'497 Dylan Tunnel Apt. 760\nNew Breana, MD 29793-5901',4,4,4,'-52.534118','-33.971657',96,0,'2025-06-10 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(4,'Apple WWDC',19,'Culpa explicabo quia sit illum officia maiores.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','b0c8e142-95fe-3608-9972-0b06b8ab7259','main/events/4.webp',54.12,'7758 Garrick Ferry Apt. 279\nSouth Kellenburgh, FL 85364',6,NULL,NULL,'-36.520599','133.58822',96,0,'2025-06-10 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(5,'AWS re:Invent',18,'Voluptatem vitae dolores placeat dignissimos sunt.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','15db7354-51b2-3416-b768-e8682f85b048','main/events/5.webp',65.45,'834 Chester Garden\nNorth Billstad, NJ 28677-1107',1,3,3,'-62.998318','-12.301002',54,0,'2025-06-11 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(6,'Microsoft Build',6,'Dolor repudiandae provident est ab consequuntur iure.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','db24e2cb-9a04-3899-abef-cfc9981114a3','main/events/6.webp',77.09,'5181 Jayda Square\nSmithbury, MA 38417-5407',1,1,1,'-29.710727','149.781815',100,0,'2025-06-11 09:00:00','2025-06-30 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(7,'Facebook F8',11,'Illum perspiciatis et culpa est.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','fc6f36f8-f990-330c-b189-09503d77f5fd','main/events/7.webp',50.81,'214 Cremin Way Suite 972\nWest Johnpaul, TN 22263-6533',6,NULL,NULL,'-26.266554','-153.063893',100,0,'2025-06-11 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(8,'GitHub Universe',23,'Fuga cum velit consectetur vel.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','caa4a6be-8a33-37ee-b4d0-177f2a21beb2','main/events/8.webp',33.74,'8909 Oswald Manor\nKristophershire, MT 81182',5,5,5,'74.142519','-68.883603',60,0,'2025-06-11 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(9,'Game Developers Conference',20,'Ducimus quis natus nulla rerum.','The largest conference in the gaming industry, focusing on game development and gaming technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','24c748db-39db-345e-afc4-a1e07e618a0b','main/events/9.webp',88.60,'70684 Joanny Road\nRobelborough, WY 33554',6,NULL,NULL,'-70.641902','-107.495433',83,0,'2025-06-12 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43'),(10,'Web Summit',17,'Ex fugit aut quidem officiis sunt assumenda eum minima.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','bcb07f1a-4528-36ea-8146-4a10b546eacc','main/events/10.webp',93.25,'627 Aracely Brooks Apt. 696\nLake Treverville, NM 63140',4,4,4,'65.614035','-167.964682',69,0,'2025-06-12 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:39:43','2025-06-10 10:39:43');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=208 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Avery Fay - kathryne40@yahoo.com','kathryne40@yahoo.com','0721834157',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Wanda Schmitt I - roman96@smith.org','roman96@smith.org','0243072220',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Prof. Jaunita Rutherford - gretchen.hahn@jerde.com','gretchen.hahn@jerde.com','0769426352',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Dr. Ilene Feest I - roberts.jeffery@hotmail.com','roberts.jeffery@hotmail.com','0312010494',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(5,1,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Humberto Leannon - klein.annie@yahoo.com','klein.annie@yahoo.com','0782037875',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Eliza Tromp - aubree01@robel.com','aubree01@robel.com','0353533747',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Mrs. Alva Romaguera PhD - lenny67@hotmail.com','lenny67@hotmail.com','0002828647',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(8,2,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Toni Ondricka - eve.douglas@olson.com','eve.douglas@olson.com','0383982335',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(9,2,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Ms. Katharina Mosciski DVM - eichmann.eileen@gmail.com','eichmann.eileen@gmail.com','0837307531',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(10,2,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Patsy Mueller - abshire.brenden@hotmail.com','abshire.brenden@hotmail.com','0217986022',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Mr. Davion Jaskolski - kmurray@hotmail.com','kmurray@hotmail.com','0370946829',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(12,3,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Craig Lockman MD - brown.madeline@fay.com','brown.madeline@fay.com','0254872037',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(13,3,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Maybelle Sanford - meaghan.hirthe@reilly.com','meaghan.hirthe@reilly.com','0023847677',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(14,3,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Rosalinda Funk - zkunze@gmail.com','zkunze@gmail.com','0272010470',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Antoinette Fritsch MD - lexie89@keeling.net','lexie89@keeling.net','0698300018',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Prof. Chadrick Heidenreich - lysanne.murphy@yahoo.com','lysanne.murphy@yahoo.com','0435059507',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(17,4,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Prof. Lincoln Stamm - dhayes@jast.com','dhayes@jast.com','0666239166',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(18,4,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Dortha Hill - abrakus@considine.net','abrakus@considine.net','0563754337',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(19,4,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Kelli Borer - eve.gulgowski@yahoo.com','eve.gulgowski@yahoo.com','0621701562',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(20,4,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Ewald Wehner - lucius.toy@reilly.net','lucius.toy@reilly.net','0319498531',1,93.93,93.93,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(21,5,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Rosella Hackett - ruthie.schmidt@hotmail.com','ruthie.schmidt@hotmail.com','0146989666',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(22,5,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Hillard Lebsack - mose.parker@gmail.com','mose.parker@gmail.com','0537680775',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(23,5,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Mary Skiles - moen.sebastian@hotmail.com','moen.sebastian@hotmail.com','0233171922',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(24,5,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Scotty Franecki - fay.joshua@brakus.com','fay.joshua@brakus.com','0114142530',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(25,5,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Mr. Kole Green IV - caitlyn.labadie@yahoo.com','caitlyn.labadie@yahoo.com','0403678387',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(26,6,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Oma Kuhic - jamey.zieme@carroll.com','jamey.zieme@carroll.com','0413766448',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(27,6,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Holden Armstrong - klehner@ledner.com','klehner@ledner.com','0688595198',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(28,7,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Rusty Mante - zlangworth@harber.biz','zlangworth@harber.biz','0913669976',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(29,7,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Grady Padberg - enos.jacobs@hotmail.com','enos.jacobs@hotmail.com','0996478062',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(30,7,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Kurtis Schneider - grayson15@hotmail.com','grayson15@hotmail.com','0877867701',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(31,7,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Adeline King - rickey09@yahoo.com','rickey09@yahoo.com','0717807504',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(32,7,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Ara Prohaska - sreichel@hotmail.com','sreichel@hotmail.com','0733319210',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(33,7,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Ariel Breitenberg - litzy63@conn.net','litzy63@conn.net','0005589643',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(34,8,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Saige Russel - langworth.cristal@yahoo.com','langworth.cristal@yahoo.com','0641496099',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(35,8,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Kaylah Terry - amani.weissnat@hotmail.com','amani.weissnat@hotmail.com','0453737022',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(36,8,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Frieda Hermann - bailey.lucienne@farrell.com','bailey.lucienne@farrell.com','0853242668',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(37,8,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Cydney Purdy - mellie.bashirian@rohan.net','mellie.bashirian@rohan.net','0001549828',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(38,9,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Brad Johns MD - jeromy56@cole.org','jeromy56@cole.org','0309657364',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(39,9,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Scarlett Hand - macey.kilback@hotmail.com','macey.kilback@hotmail.com','0852508126',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(40,9,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'CES (Consumer Electronics Show) - Jaquan Terry - ladarius00@bruen.com','ladarius00@bruen.com','0223561844',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(41,9,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'CES (Consumer Electronics Show) - Verlie Feil - adalberto32@gmail.com','adalberto32@gmail.com','0180541760',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(42,9,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'CES (Consumer Electronics Show) - Seth Jast - maverick85@hotmail.com','maverick85@hotmail.com','0994107790',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(43,9,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'CES (Consumer Electronics Show) - Lilly Gutmann - davin46@hotmail.com','davin46@hotmail.com','0492730472',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(44,10,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'CES (Consumer Electronics Show) - Margarete Howell - vandervort.mathias@yahoo.com','vandervort.mathias@yahoo.com','0764528315',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(45,10,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'CES (Consumer Electronics Show) - Olin Hermiston - brian.waelchi@braun.org','brian.waelchi@braun.org','0437821738',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(46,10,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'CES (Consumer Electronics Show) - Mafalda Hirthe - vkoch@ratke.com','vkoch@ratke.com','0436019069',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(47,10,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'CES (Consumer Electronics Show) - Precious Kautzer - maynard.rosenbaum@pagac.com','maynard.rosenbaum@pagac.com','0851425482',1,93.93,93.93,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(48,11,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Kaya Watsica - elton95@zemlak.org','elton95@zemlak.org','0044933850',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(49,11,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Prof. Leo Schneider - leopoldo.jenkins@gmail.com','leopoldo.jenkins@gmail.com','0138592577',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(50,12,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Keshaun Pouros - raven68@grant.com','raven68@grant.com','0812725938',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(51,12,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Prof. Audie Collins - fatima36@von.com','fatima36@von.com','0128706399',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(52,12,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Dr. Arden Connelly DDS - daryl.bailey@yahoo.com','daryl.bailey@yahoo.com','0735999316',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(53,12,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Bonita Grant - justus.blanda@yahoo.com','justus.blanda@yahoo.com','0174255078',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(54,12,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Vickie Schultz - wschultz@yahoo.com','wschultz@yahoo.com','0230278949',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(55,12,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Bertrand Fritsch - libbie88@mertz.com','libbie88@mertz.com','0207014979',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(56,13,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Leanna Wuckert - elna03@hotmail.com','elna03@hotmail.com','0330341385',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(57,13,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Lonny Stanton DDS - lessie.legros@yahoo.com','lessie.legros@yahoo.com','0544255017',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(58,13,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Ashlynn Olson - johann79@padberg.info','johann79@padberg.info','0045673409',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(59,14,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Mr. Zion Jakubowski - blanda.friedrich@okon.com','blanda.friedrich@okon.com','0168485245',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(60,14,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Miss Carolanne Monahan MD - aubrey13@white.com','aubrey13@white.com','0224408408',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(61,14,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Ms. Sarah Green II - rohan.milan@schumm.com','rohan.milan@schumm.com','0816447980',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(62,14,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Gino Hoppe MD - morar.allan@mclaughlin.com','morar.allan@mclaughlin.com','0568698774',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(63,14,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Mrs. Lelia Prosacco DVM - angel51@yahoo.com','angel51@yahoo.com','0672352343',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(64,14,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Prof. Adonis Carroll DDS - baylee.toy@koepp.org','baylee.toy@koepp.org','0587421611',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(65,15,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Jakayla Kuhn - dhermiston@hotmail.com','dhermiston@hotmail.com','0245624305',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(66,15,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Mac Jaskolski - jasen.cruickshank@koepp.com','jasen.cruickshank@koepp.com','0867497825',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(67,15,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Gavin O\'Reilly PhD - leila.wisoky@gerhold.com','leila.wisoky@gerhold.com','0832737646',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(68,15,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Brice Kris - nlittle@prosacco.biz','nlittle@prosacco.biz','0573415713',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(69,16,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Luigi Gutmann - gerhard.schaden@aufderhar.org','gerhard.schaden@aufderhar.org','0924956356',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(70,16,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Prof. Kristopher Cruickshank DVM - qbergstrom@hotmail.com','qbergstrom@hotmail.com','0259816287',1,92.63,92.63,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(71,17,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Gustave Mann - goyette.eddie@fahey.biz','goyette.eddie@fahey.biz','0781024628',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(72,17,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Timmy Rippin - steuber.domenic@hotmail.com','steuber.domenic@hotmail.com','0121994370',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(73,17,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Mr. Dedric Maggio - cruickshank.yasmine@gmail.com','cruickshank.yasmine@gmail.com','0231814001',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(74,17,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Brenden Cole Jr. - charlene30@gmail.com','charlene30@gmail.com','0916952655',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(75,17,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Sylvia Schaden - ckautzer@gmail.com','ckautzer@gmail.com','0001947678',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(76,17,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Dr. Lavon Hickle - haley.shannon@sauer.com','haley.shannon@sauer.com','0520348101',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(77,18,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Kelvin Considine - richard.hoeger@yahoo.com','richard.hoeger@yahoo.com','0844942321',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(78,18,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Mobile World Congress - Miss Violet Lueilwitz - fadel.garland@cassin.biz','fadel.garland@cassin.biz','0173557589',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(79,18,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Mobile World Congress - Mrs. Chyna Feest IV - ikunze@yahoo.com','ikunze@yahoo.com','0109197963',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(80,18,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Mobile World Congress - Darien O\'Keefe - emmanuel.romaguera@stoltenberg.com','emmanuel.romaguera@stoltenberg.com','0933791434',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(81,18,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Mobile World Congress - Mr. Foster Schuster - gkoch@oconner.net','gkoch@oconner.net','0014043852',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(82,18,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Mobile World Congress - Isaiah Muller II - strosin.chelsie@kautzer.com','strosin.chelsie@kautzer.com','0193665115',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(83,19,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Mobile World Congress - Ms. Zola Miller - sophia.russel@yahoo.com','sophia.russel@yahoo.com','0930855793',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(84,19,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Mobile World Congress - Lavonne Yundt - marvin.lempi@rippin.net','marvin.lempi@rippin.net','0129933337',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(85,20,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Mobile World Congress - Dakota Abernathy - rosamond77@lynch.com','rosamond77@lynch.com','0970606527',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(86,20,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Mobile World Congress - Dr. Kenya Strosin - amedhurst@gmail.com','amedhurst@gmail.com','0970955400',1,92.63,92.63,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(87,21,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Mr. Mackenzie Schowalter V - marielle.damore@wiegand.com','marielle.damore@wiegand.com','0640963835',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(88,21,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Deven Stark III - lebsack.jayson@gmail.com','lebsack.jayson@gmail.com','0927965692',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(89,21,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Augusta Hettinger - ulowe@gmail.com','ulowe@gmail.com','0760020477',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(90,22,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Jabari Sawayn - anthony.cremin@walsh.org','anthony.cremin@walsh.org','0006400267',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(91,22,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Nathan Romaguera - wintheiser.anabelle@hotmail.com','wintheiser.anabelle@hotmail.com','0535903377',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(92,22,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Ned Hoeger I - zrogahn@gmail.com','zrogahn@gmail.com','0400028977',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(93,22,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Maximus Smith - jenkins.keara@hilpert.com','jenkins.keara@hilpert.com','0306950464',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(94,22,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Mr. Dereck Johns - pollich.casper@yahoo.com','pollich.casper@yahoo.com','0797917434',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(95,23,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Anthony Rohan - metz.percy@runolfsson.com','metz.percy@runolfsson.com','0842388736',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(96,23,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Krystal Goodwin - ehane@jones.com','ehane@jones.com','0511331493',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(97,23,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Margret Mann - hannah90@kohler.com','hannah90@kohler.com','0580323733',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(98,23,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Jayde Toy - newell84@thiel.info','newell84@thiel.info','0028399996',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(99,23,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Dorthy Cruickshank - helena.gerlach@carter.net','helena.gerlach@carter.net','0906166922',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(100,24,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Diana Quigley - kaylee.rempel@yahoo.com','kaylee.rempel@yahoo.com','0061361087',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(101,24,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Dolores Dare I - hahn.estell@gmail.com','hahn.estell@gmail.com','0884058717',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(102,24,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Blanca Dickinson I - kkulas@hotmail.com','kkulas@hotmail.com','0643600456',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(103,25,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Hunter Schultz - luettgen.jocelyn@beahan.net','luettgen.jocelyn@beahan.net','0148562719',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(104,25,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Dr. Barrett Wisoky - alexys55@zemlak.com','alexys55@zemlak.com','0260065131',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(105,26,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Dr. Jerald Vandervort V - owintheiser@crona.com','owintheiser@crona.com','0783570745',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(106,26,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Guido Goodwin - block.brennan@kautzer.com','block.brennan@kautzer.com','0920977121',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(107,26,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Prof. Peggie Miller - stracke.rod@yahoo.com','stracke.rod@yahoo.com','0640619120',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(108,26,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Jaycee Bernier - zack.eichmann@gmail.com','zack.eichmann@gmail.com','0113656154',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(109,26,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Roel Zboncak - xbruen@paucek.com','xbruen@paucek.com','0087285826',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(110,27,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Mrs. Clare Bins - uschmidt@yahoo.com','uschmidt@yahoo.com','0305309493',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(111,27,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Miss Myrtice Mosciski PhD - giovani71@friesen.com','giovani71@friesen.com','0704173273',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(112,27,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Neal Hickle - ganderson@gmail.com','ganderson@gmail.com','0302716818',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(113,27,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Prof. Fae Rau DDS - gino.wolff@gmail.com','gino.wolff@gmail.com','0747798083',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(114,27,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Murphy Willms - stanton.gavin@lueilwitz.com','stanton.gavin@lueilwitz.com','0649817049',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(115,27,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Monroe Rodriguez - miller.sonya@yahoo.com','miller.sonya@yahoo.com','0753054322',1,32.19,32.19,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(116,28,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Edwina Swift - abraham.frami@gaylord.com','abraham.frami@gaylord.com','0027916579',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(117,28,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Google I/O - Brooke Armstrong - odicki@huel.biz','odicki@huel.biz','0459283410',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(118,28,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Google I/O - Dr. Earl Frami - twehner@gmail.com','twehner@gmail.com','0994860031',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(119,28,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Google I/O - Elwyn Wehner - ulices88@yahoo.com','ulices88@yahoo.com','0942275112',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(120,29,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Google I/O - Dr. Rachael Zulauf MD - francisca29@yahoo.com','francisca29@yahoo.com','0756366528',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(121,29,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Google I/O - Perry Rempel I - dante.larkin@conroy.com','dante.larkin@conroy.com','0457366540',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(122,29,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Google I/O - Martina Osinski MD - milton14@hotmail.com','milton14@hotmail.com','0854810762',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(123,29,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Google I/O - Mr. Diamond Fahey - ucollins@hotmail.com','ucollins@hotmail.com','0347839322',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(124,30,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Google I/O - Brant Langworth - schinner.hortense@oconnell.info','schinner.hortense@oconnell.info','0344025895',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(125,30,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Google I/O - Percival McGlynn V - ypowlowski@gmail.com','ypowlowski@gmail.com','0783742962',1,32.19,32.19,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(126,31,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Miss Loma Bartell IV - wheathcote@harris.com','wheathcote@harris.com','0400635521',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(127,31,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Bethany O\'Kon - clueilwitz@osinski.org','clueilwitz@osinski.org','0815676798',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(128,31,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Mrs. Herminia Roob Sr. - qschuppe@kertzmann.com','qschuppe@kertzmann.com','0934739722',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(129,32,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Athena Metz - wschmidt@gerhold.com','wschmidt@gerhold.com','0030253962',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(130,32,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Shanon Gerhold - shields.joan@hotmail.com','shields.joan@hotmail.com','0399327021',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(131,32,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Sheridan Christiansen - tara60@muller.com','tara60@muller.com','0934387811',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(132,32,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Frederique Lang - wbode@nikolaus.org','wbode@nikolaus.org','0954458159',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(133,32,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Brock Schuppe - coy70@douglas.net','coy70@douglas.net','0232623083',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(134,33,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Ed Bernier - edmond43@lindgren.biz','edmond43@lindgren.biz','0662292151',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(135,33,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Kenyatta Friesen - dorian29@conroy.com','dorian29@conroy.com','0100807432',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(136,33,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Arthur Franecki - abrekke@hotmail.com','abrekke@hotmail.com','0096393386',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(137,34,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Jaylen Cartwright - kale47@yahoo.com','kale47@yahoo.com','0567997252',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(138,34,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Darrick Crist - immanuel25@yahoo.com','immanuel25@yahoo.com','0982057219',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(139,35,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Emely Stehr - jaylan.stiedemann@hotmail.com','jaylan.stiedemann@hotmail.com','0540085750',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(140,35,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Nayeli Barrows - adriana77@gmail.com','adriana77@gmail.com','0446799814',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(141,35,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Prof. Dustin Denesik - lkoelpin@bins.biz','lkoelpin@bins.biz','0389431867',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(142,35,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Mr. Geovany DuBuque - oconner.arlo@crooks.com','oconner.arlo@crooks.com','0385673217',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(143,35,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Prof. Jett Thiel - robin.schroeder@zieme.biz','robin.schroeder@zieme.biz','0959360819',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(144,36,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Taryn Leannon - kayden.aufderhar@gmail.com','kayden.aufderhar@gmail.com','0248827746',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(145,36,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Mrs. Hortense Cartwright - keith.bednar@yahoo.com','keith.bednar@yahoo.com','0313745246',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(146,36,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Harley Wyman - jacobs.clemens@gmail.com','jacobs.clemens@gmail.com','0353210953',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(147,36,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Cyril Willms - ortiz.abagail@hotmail.com','ortiz.abagail@hotmail.com','0207584188',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(148,36,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Ms. Felicita Rice - henriette.dickens@huels.com','henriette.dickens@huels.com','0743698584',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(149,36,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Madyson Metz - deanna24@rodriguez.biz','deanna24@rodriguez.biz','0089055458',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(150,37,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Dr. Dariana Schuppe - madilyn.okuneva@sporer.com','madilyn.okuneva@sporer.com','0264720256',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(151,37,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Roslyn Hickle - herta71@gmail.com','herta71@gmail.com','0674077911',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(152,37,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Robert Larkin Sr. - yundt.matilda@dickinson.com','yundt.matilda@dickinson.com','0673198887',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(153,37,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Isaias Johnson - mclaughlin.amie@dicki.com','mclaughlin.amie@dicki.com','0125524873',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(154,37,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Sebastian Miller - orin.mosciski@gmail.com','orin.mosciski@gmail.com','0878204559',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(155,37,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Abbigail Schuppe - hoeger.sibyl@yahoo.com','hoeger.sibyl@yahoo.com','0003639193',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(156,38,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Prof. Newton Kilback Jr. - rau.isadore@gmail.com','rau.isadore@gmail.com','0650331476',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(157,38,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Valentin Boyer - muriel.fahey@hammes.biz','muriel.fahey@hammes.biz','0075063950',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(158,38,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Dr. Keanu Kihn III - umclaughlin@gmail.com','umclaughlin@gmail.com','0866636238',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(159,38,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'Apple WWDC - Ms. Lauryn Nienow Sr. - quitzon.alaina@breitenberg.net','quitzon.alaina@breitenberg.net','0121993020',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(160,38,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'Apple WWDC - Morton Abbott - harris.dayton@gmail.com','harris.dayton@gmail.com','0849761393',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(161,39,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'Apple WWDC - Karina Abbott - francis.dooley@hotmail.com','francis.dooley@hotmail.com','0185692306',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(162,39,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'Apple WWDC - Magali Rice - giovanny.jaskolski@yahoo.com','giovanny.jaskolski@yahoo.com','0208924594',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(163,39,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'Apple WWDC - Mr. Edmond Becker I - marks.shanna@borer.biz','marks.shanna@borer.biz','0713438525',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(164,39,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'Apple WWDC - Prof. Jarrod Koepp - hirthe.willis@hotmail.com','hirthe.willis@hotmail.com','0620143799',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(165,39,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'Apple WWDC - Neva Welch - jeanette78@kovacek.com','jeanette78@kovacek.com','0611830737',1,54.12,54.12,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(166,40,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'Apple WWDC - Miss Roxanne Parisian - carlo33@torphy.net','carlo33@torphy.net','0999538649',1,54.12,54.12,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(167,40,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'Apple WWDC - Kristin Greenholt - fletcher.rodriguez@christiansen.com','fletcher.rodriguez@christiansen.com','0904829642',1,54.12,54.12,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(168,41,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Mr. Wayne Crona - canderson@weimann.biz','canderson@weimann.biz','0020426857',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(169,41,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Nia Hermann - vharber@kub.net','vharber@kub.net','0287753279',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(170,42,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Ulices Goodwin - moen.shanie@yahoo.com','moen.shanie@yahoo.com','0334334393',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(171,42,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Cydney Rosenbaum - colton.mccullough@yahoo.com','colton.mccullough@yahoo.com','0484173397',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(172,43,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Dr. Celestine Feest Sr. - abdiel.parisian@cassin.info','abdiel.parisian@cassin.info','0262081006',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(173,43,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Catherine Kertzmann - swift.dariana@effertz.com','swift.dariana@effertz.com','0408565203',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(174,44,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Earnestine Mills - wintheiser.roel@lakin.org','wintheiser.roel@lakin.org','0955915618',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(175,44,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Schuyler Mitchell - cpurdy@trantow.biz','cpurdy@trantow.biz','0638683640',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(176,44,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Cary Robel - eullrich@considine.com','eullrich@considine.com','0999158127',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(177,44,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Prof. Cale Hettinger I - kristy96@yahoo.com','kristy96@yahoo.com','0337685164',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(178,44,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Carlee Walter - beahan.ward@hotmail.com','beahan.ward@hotmail.com','0798768829',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(179,45,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Erich Gleichner - abdul35@gmail.com','abdul35@gmail.com','0925394470',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(180,45,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Merlin Hermiston - cali72@gulgowski.biz','cali72@gulgowski.biz','0087974199',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(181,45,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Malinda Flatley - vandervort.rowan@gmail.com','vandervort.rowan@gmail.com','0420293612',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(182,45,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Hiram D\'Amore MD - wendy.mann@boehm.org','wendy.mann@boehm.org','0526265439',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(183,45,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Sharon Beer - orlando33@bashirian.biz','orlando33@bashirian.biz','0538941094',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(184,45,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Shyann Jacobson - mbradtke@hotmail.com','mbradtke@hotmail.com','0299491650',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(185,46,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Mrs. Letitia Douglas IV - jamal21@kutch.com','jamal21@kutch.com','0121077329',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(186,46,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Dr. Danika Kshlerin Sr. - norwood42@gmail.com','norwood42@gmail.com','0702465966',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(187,46,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Miss Baby Baumbach IV - roscoe57@gmail.com','roscoe57@gmail.com','0927537094',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(188,46,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Mr. Anthony Welch - gunnar99@yahoo.com','gunnar99@yahoo.com','0632058601',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(189,46,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Prof. Ethelyn Beatty Sr. - eulah.miller@gerhold.org','eulah.miller@gerhold.org','0826350017',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(190,46,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Prof. Samson Mueller III - quitzon.orpha@okeefe.info','quitzon.orpha@okeefe.info','0622663355',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(191,47,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Rigoberto Kutch - pfannerstill.kennedy@yahoo.com','pfannerstill.kennedy@yahoo.com','0936282867',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(192,47,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Prof. Domenick Kub - hilbert07@schaden.info','hilbert07@schaden.info','0915602891',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(193,47,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Foster Paucek - beahan.damian@klein.org','beahan.damian@klein.org','0733629071',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(194,47,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Laron Osinski - hickle.ally@tromp.net','hickle.ally@tromp.net','0287257856',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(195,47,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Joannie Reilly - alaina.lebsack@douglas.net','alaina.lebsack@douglas.net','0197452003',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(196,47,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Leonora Sawayn - remington54@larson.org','remington54@larson.org','0412467600',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(197,48,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Prof. Gunner Ortiz DDS - rodger66@crooks.com','rodger66@crooks.com','0158571058',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(198,48,'ArchiElite\\EventsBooking\\Models\\Ticket',198,'AWS re:Invent - Sarah Simonis DDS - qdubuque@hotmail.com','qdubuque@hotmail.com','0613867476',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(199,49,'ArchiElite\\EventsBooking\\Models\\Ticket',199,'AWS re:Invent - Mrs. Gia Zieme PhD - ricky.legros@gmail.com','ricky.legros@gmail.com','0169394752',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(200,49,'ArchiElite\\EventsBooking\\Models\\Ticket',200,'AWS re:Invent - Floyd Collins - kilback.theresia@gmail.com','kilback.theresia@gmail.com','0913874728',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(201,49,'ArchiElite\\EventsBooking\\Models\\Ticket',201,'AWS re:Invent - Adela Orn - frieda.cassin@gmail.com','frieda.cassin@gmail.com','0849331927',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(202,49,'ArchiElite\\EventsBooking\\Models\\Ticket',202,'AWS re:Invent - Weldon Kuhic - jeramie.simonis@cormier.com','jeramie.simonis@cormier.com','0797710859',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(203,49,'ArchiElite\\EventsBooking\\Models\\Ticket',203,'AWS re:Invent - Kaylin Homenick - emelie31@torp.com','emelie31@torp.com','0563580714',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(204,49,'ArchiElite\\EventsBooking\\Models\\Ticket',204,'AWS re:Invent - Lina Sawayn Jr. - ksauer@yahoo.com','ksauer@yahoo.com','0847534490',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(205,50,'ArchiElite\\EventsBooking\\Models\\Ticket',205,'AWS re:Invent - Lisette Conn - deja.hermann@gorczany.com','deja.hermann@gorczany.com','0115565528',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(206,50,'ArchiElite\\EventsBooking\\Models\\Ticket',206,'AWS re:Invent - Lucious Sanford V - werner17@nader.com','werner17@nader.com','0817634549',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(207,50,'ArchiElite\\EventsBooking\\Models\\Ticket',207,'AWS re:Invent - Mr. Johan Dibbert MD - ojohnston@von.com','ojohnston@von.com','0580485221',1,65.45,65.45,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',93.93,'CES (Consumer Electronics Show)','Mr. Jarod Zulauf','haskell.botsford@huel.net',NULL,'ArchiElite','main/general/logo-light.png',375.72,375.72,0.00,0.00,NULL,1,'completed','2025-06-10 10:39:43','2025-06-10 10:39:43','2025-06-10 10:39:43'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',93.93,'CES (Consumer Electronics Show)','Hank Legros','jquigley@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',375.72,375.72,0.00,0.00,NULL,2,'completed','2025-06-10 10:39:43','2025-06-10 10:39:43','2025-06-10 10:39:43'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',93.93,'CES (Consumer Electronics Show)','Rhea Prosacco','barrows.casey@damore.com',NULL,'ArchiElite','main/general/logo-light.png',281.79,281.79,0.00,0.00,NULL,3,'completed','2025-06-10 10:39:43','2025-06-10 10:39:43','2025-06-10 10:39:43'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',93.93,'CES (Consumer Electronics Show)','Mr. Rocky White Jr.','xyundt@kuhic.info',NULL,'ArchiElite','main/general/logo-light.png',469.65,469.65,0.00,0.00,NULL,4,'completed','2025-06-10 10:39:43','2025-06-10 10:39:43','2025-06-10 10:39:43'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',93.93,'CES (Consumer Electronics Show)','Brenda Krajcik','ppagac@daniel.com',NULL,'ArchiElite','main/general/logo-light.png',375.72,375.72,0.00,0.00,NULL,5,'completed','2025-06-10 10:39:44','2025-06-10 10:39:43','2025-06-10 10:39:44'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',93.93,'CES (Consumer Electronics Show)','Heaven Shields','celine.macejkovic@balistreri.biz',NULL,'ArchiElite','main/general/logo-light.png',93.93,93.93,0.00,0.00,NULL,6,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',93.93,'CES (Consumer Electronics Show)','Willy Berge II','zsteuber@sauer.com',NULL,'ArchiElite','main/general/logo-light.png',469.65,469.65,0.00,0.00,NULL,7,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',93.93,'CES (Consumer Electronics Show)','Mr. Jarod Zulauf','haskell.botsford@huel.net',NULL,'ArchiElite','main/general/logo-light.png',281.79,281.79,0.00,0.00,NULL,8,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',93.93,'CES (Consumer Electronics Show)','Hank Legros','jquigley@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',469.65,469.65,0.00,0.00,NULL,9,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',93.93,'CES (Consumer Electronics Show)','Mr. Jarod Zulauf','haskell.botsford@huel.net',NULL,'ArchiElite','main/general/logo-light.png',281.79,281.79,0.00,0.00,NULL,10,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',92.63,'Mobile World Congress','Willy Berge II','zsteuber@sauer.com',NULL,'ArchiElite','main/general/logo-light.png',92.63,92.63,0.00,0.00,NULL,11,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',92.63,'Mobile World Congress','Alan Mohr','miles.stanton@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',463.15,463.15,0.00,0.00,NULL,12,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',92.63,'Mobile World Congress','Heaven Shields','celine.macejkovic@balistreri.biz',NULL,'ArchiElite','main/general/logo-light.png',185.26,185.26,0.00,0.00,NULL,13,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',92.63,'Mobile World Congress','Miss Agnes Hermann','rollin.shanahan@hagenes.info',NULL,'ArchiElite','main/general/logo-light.png',463.15,463.15,0.00,0.00,NULL,14,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',92.63,'Mobile World Congress','Mr. Rocky White Jr.','xyundt@kuhic.info',NULL,'ArchiElite','main/general/logo-light.png',277.89,277.89,0.00,0.00,NULL,15,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',92.63,'Mobile World Congress','Mac Price','will.willa@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',92.63,92.63,0.00,0.00,NULL,16,'completed','2025-06-10 10:39:44','2025-06-10 10:39:44','2025-06-10 10:39:44'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',92.63,'Mobile World Congress','Prof. Braulio Nienow','fay.mario@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',463.15,463.15,0.00,0.00,NULL,17,'completed','2025-06-10 10:39:45','2025-06-10 10:39:44','2025-06-10 10:39:45'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',92.63,'Mobile World Congress','Prof. Berry Bartoletti','cleo.fahey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',463.15,463.15,0.00,0.00,NULL,18,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',92.63,'Mobile World Congress','Jessyca Casper','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',92.63,92.63,0.00,0.00,NULL,19,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',92.63,'Mobile World Congress','Alan Mohr','miles.stanton@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',92.63,92.63,0.00,0.00,NULL,20,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',32.19,'Google I/O','Prof. Braulio Nienow','fay.mario@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',64.38,64.38,0.00,0.00,NULL,21,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',32.19,'Google I/O','Heaven Shields','celine.macejkovic@balistreri.biz',NULL,'ArchiElite','main/general/logo-light.png',128.76,128.76,0.00,0.00,NULL,22,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',32.19,'Google I/O','Jessyca Casper','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',128.76,128.76,0.00,0.00,NULL,23,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',32.19,'Google I/O','Hank Legros','jquigley@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',64.38,64.38,0.00,0.00,NULL,24,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',32.19,'Google I/O','Hank Legros','jquigley@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',32.19,32.19,0.00,0.00,NULL,25,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',32.19,'Google I/O','Heaven Shields','celine.macejkovic@balistreri.biz',NULL,'ArchiElite','main/general/logo-light.png',128.76,128.76,0.00,0.00,NULL,26,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',32.19,'Google I/O','Brenda Krajcik','ppagac@daniel.com',NULL,'ArchiElite','main/general/logo-light.png',160.95,160.95,0.00,0.00,NULL,27,'completed','2025-06-10 10:39:45','2025-06-10 10:39:45','2025-06-10 10:39:45'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',32.19,'Google I/O','Hank Legros','jquigley@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',96.57,96.57,0.00,0.00,NULL,28,'completed','2025-06-10 10:39:46','2025-06-10 10:39:45','2025-06-10 10:39:46'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',32.19,'Google I/O','Brenda Krajcik','ppagac@daniel.com',NULL,'ArchiElite','main/general/logo-light.png',96.57,96.57,0.00,0.00,NULL,29,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',32.19,'Google I/O','Prof. Braulio Nienow','fay.mario@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',32.19,32.19,0.00,0.00,NULL,30,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',54.12,'Apple WWDC','Prof. Berry Bartoletti','cleo.fahey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',108.24,108.24,0.00,0.00,NULL,31,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',54.12,'Apple WWDC','Fermin Lindgren Jr.','wiley26@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',216.48,216.48,0.00,0.00,NULL,32,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',54.12,'Apple WWDC','Prof. Berry Bartoletti','cleo.fahey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',108.24,108.24,0.00,0.00,NULL,33,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',54.12,'Apple WWDC','Prof. Berry Bartoletti','cleo.fahey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',54.12,54.12,0.00,0.00,NULL,34,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',54.12,'Apple WWDC','Fermin Lindgren Jr.','wiley26@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',216.48,216.48,0.00,0.00,NULL,35,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',54.12,'Apple WWDC','Dr. Wilfrid Schowalter DVM','zieme.haven@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',270.60,270.60,0.00,0.00,NULL,36,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',54.12,'Apple WWDC','Mr. Jarod Zulauf','haskell.botsford@huel.net',NULL,'ArchiElite','main/general/logo-light.png',270.60,270.60,0.00,0.00,NULL,37,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',54.12,'Apple WWDC','Fermin Lindgren Jr.','wiley26@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',216.48,216.48,0.00,0.00,NULL,38,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',54.12,'Apple WWDC','Heaven Shields','celine.macejkovic@balistreri.biz',NULL,'ArchiElite','main/general/logo-light.png',216.48,216.48,0.00,0.00,NULL,39,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:46'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',54.12,'Apple WWDC','Mac Price','will.willa@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',54.12,54.12,0.00,0.00,NULL,40,'completed','2025-06-10 10:39:46','2025-06-10 10:39:46','2025-06-10 10:39:47'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',65.45,'AWS re:Invent','Miss Agnes Hermann','rollin.shanahan@hagenes.info',NULL,'ArchiElite','main/general/logo-light.png',65.45,65.45,0.00,0.00,NULL,41,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',65.45,'AWS re:Invent','Rhea Prosacco','barrows.casey@damore.com',NULL,'ArchiElite','main/general/logo-light.png',65.45,65.45,0.00,0.00,NULL,42,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',65.45,'AWS re:Invent','Mac Price','will.willa@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',65.45,65.45,0.00,0.00,NULL,43,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',65.45,'AWS re:Invent','Brenda Krajcik','ppagac@daniel.com',NULL,'ArchiElite','main/general/logo-light.png',261.80,261.80,0.00,0.00,NULL,44,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',65.45,'AWS re:Invent','Prof. Berry Bartoletti','cleo.fahey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',327.25,327.25,0.00,0.00,NULL,45,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',65.45,'AWS re:Invent','Brenda Krajcik','ppagac@daniel.com',NULL,'ArchiElite','main/general/logo-light.png',327.25,327.25,0.00,0.00,NULL,46,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',65.45,'AWS re:Invent','Fermin Lindgren Jr.','wiley26@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',327.25,327.25,0.00,0.00,NULL,47,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',65.45,'AWS re:Invent','Prof. Berry Bartoletti','cleo.fahey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',65.45,65.45,0.00,0.00,NULL,48,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',65.45,'AWS re:Invent','Willy Berge II','zsteuber@sauer.com',NULL,'ArchiElite','main/general/logo-light.png',327.25,327.25,0.00,0.00,NULL,49,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',65.45,'AWS re:Invent','Brenda Krajcik','ppagac@daniel.com',NULL,'ArchiElite','main/general/logo-light.png',130.90,130.90,0.00,0.00,NULL,50,'completed','2025-06-10 10:39:47','2025-06-10 10:39:47','2025-06-10 10:39:47');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'M7QB0Y2WHWTD','84594152-16b4-4762-b763-34fb920e1c13',1,'CES (Consumer Electronics Show)',93.93,7,1,'Mr. Jarod Zulauf','haskell.botsford@huel.net','WHAT? The other guests had taken his watch out of sight, he said to the end of trials, \"There was.',NULL,'1',93.93,4,375.72,375.72,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(2,'OYFEBJVBPJFQ','f08ef893-6869-4eb0-8954-27f47ea21ceb',1,'CES (Consumer Electronics Show)',93.93,4,1,'Hank Legros','jquigley@yahoo.com','I\'m I, and--oh dear, how puzzling it all is! I\'ll try if I would talk on such a curious dream!\'.',NULL,'2',93.93,4,375.72,375.72,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(3,'3LXCHJLBAFXK','ca385c13-151e-41f6-b59c-cc3a3fd2d521',1,'CES (Consumer Electronics Show)',93.93,31,1,'Rhea Prosacco','barrows.casey@damore.com','I only wish it was,\' the March Hare will be the use of a candle is blown out, for she had never.',NULL,'3',93.93,3,281.79,281.79,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(4,'QQKBHVXTTEQD','8d15e0d0-27f1-41b4-80e3-0bd7eed2e389',1,'CES (Consumer Electronics Show)',93.93,3,1,'Mr. Rocky White Jr.','xyundt@kuhic.info','Alice. \'You must be,\' said the Hatter. \'You MUST remember,\' remarked the King, \'and don\'t look at.',NULL,'4',93.93,5,469.65,469.65,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(5,'INCEY9X3BBBR','48b4ff01-9c36-4895-bb1f-83c60c27c4a8',1,'CES (Consumer Electronics Show)',93.93,22,1,'Brenda Krajcik','ppagac@daniel.com','Alice again, for this time it all came different!\' the Mock Turtle. So she went on so long since.',NULL,'5',93.93,4,375.72,375.72,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43'),(6,'RD8GBEKMYFQL','9711fe62-44be-45db-8bfb-aa1d194115c0',1,'CES (Consumer Electronics Show)',93.93,24,1,'Heaven Shields','celine.macejkovic@balistreri.biz','Beautiful, beautiful Soup!\' CHAPTER XI. Who Stole the Tarts? The King and Queen of Hearts were.',NULL,'6',93.93,1,93.93,93.93,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(7,'59ECFNOPYKKZ','1b8eb551-05b8-4b2a-9a82-af0228f986ac',1,'CES (Consumer Electronics Show)',93.93,8,1,'Willy Berge II','zsteuber@sauer.com','Alice asked in a sorrowful tone; \'at least there\'s no harm in trying.\' So she went to school in.',NULL,'7',93.93,5,469.65,469.65,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(8,'BW5G6OQPYTYW','2a57f474-9908-40af-9d1e-8eb4ed27be17',1,'CES (Consumer Electronics Show)',93.93,7,1,'Mr. Jarod Zulauf','haskell.botsford@huel.net','King. The next witness would be as well say,\' added the March Hare. Alice was thoroughly puzzled.',NULL,'8',93.93,3,281.79,281.79,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(9,'KI47COYGIWSQ','240bb170-baeb-44c5-a87d-b7b317fa5013',1,'CES (Consumer Electronics Show)',93.93,4,1,'Hank Legros','jquigley@yahoo.com','Queen, and in his confusion he bit a large plate came skimming out, straight at the Cat\'s head.',NULL,'9',93.93,5,469.65,469.65,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(10,'BUFZX47L5FSN','891a7235-51d0-4b85-a4ff-fe6d37f8fe31',1,'CES (Consumer Electronics Show)',93.93,7,1,'Mr. Jarod Zulauf','haskell.botsford@huel.net','Her first idea was that you think you could manage it?) \'And what an ignorant little girl or a.',NULL,'10',93.93,3,281.79,281.79,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(11,'JMJU0FAAHDGU','11bc6c1e-c650-4720-94e6-258dd80e1e9a',2,'Mobile World Congress',92.63,8,1,'Willy Berge II','zsteuber@sauer.com','But she went slowly after it: \'I never could abide figures!\' And with that she had put the hookah.',NULL,'11',92.63,1,92.63,92.63,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(12,'DW7JREQQJSDQ','385c200f-c3b8-4913-b790-eb255aec621e',2,'Mobile World Congress',92.63,30,1,'Alan Mohr','miles.stanton@yahoo.com','Pray, what is the capital of Rome, and Rome--no, THAT\'S all wrong, I\'m certain! I must have a.',NULL,'12',92.63,5,463.15,463.15,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(13,'ODRVWPMOPVWC','9515c76f-238a-4293-abfb-935eb32fde20',2,'Mobile World Congress',92.63,24,1,'Heaven Shields','celine.macejkovic@balistreri.biz','VERY deeply with a soldier on each side to guard him; and near the looking-glass. There was a.',NULL,'13',92.63,2,185.26,185.26,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(14,'ZQD3TOXFO3NO','3aa20380-a647-4d23-852d-a715d112489f',2,'Mobile World Congress',92.63,10,1,'Miss Agnes Hermann','rollin.shanahan@hagenes.info','Gryphon: and it sat for a minute or two, they began running when they liked, and left foot, so as.',NULL,'14',92.63,5,463.15,463.15,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(15,'NSBHAFAAQHSB','39b83247-0c6c-4abc-8072-770bdcc8c825',2,'Mobile World Congress',92.63,3,1,'Mr. Rocky White Jr.','xyundt@kuhic.info','Alice looked down at once, in a furious passion, and went back to her: its face to see you again.',NULL,'15',92.63,3,277.89,277.89,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(16,'QTLBWLNDZGG7','bbb9a789-4ded-4753-b94b-a80e0dfcb496',2,'Mobile World Congress',92.63,16,1,'Mac Price','will.willa@yahoo.com','I ought to speak, but for a minute, nurse! But I\'ve got to do,\' said Alice in a sorrowful tone.',NULL,'16',92.63,1,92.63,92.63,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(17,'KI2C6QLIJLVS','c67eb675-a646-49b4-b014-94869d9377b9',2,'Mobile World Congress',92.63,21,1,'Prof. Braulio Nienow','fay.mario@yahoo.com','At this moment Five, who had been running half an hour or so there were a Duck and a Dodo, a Lory.',NULL,'17',92.63,5,463.15,463.15,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44'),(18,'XVHUH6MZQBYZ','a8c6cf1e-0abb-4aa9-9c9f-cc2b3446cab7',2,'Mobile World Congress',92.63,28,1,'Prof. Berry Bartoletti','cleo.fahey@hotmail.com','Rabbit whispered in a tone of great relief. \'Call the next verse.\' \'But about his toes?\' the Mock.',NULL,'18',92.63,5,463.15,463.15,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(19,'ELE3F9OPG6UO','f90b954b-3dd2-4763-bf59-aa8fc9ccce47',2,'Mobile World Congress',92.63,1,1,'Jessyca Casper','customer@archielite.com','CHAPTER V. Advice from a bottle marked \'poison,\' so Alice soon began talking again. \'Dinah\'ll miss.',NULL,'19',92.63,1,92.63,92.63,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(20,'JSQOJDRFXDYS','62dbf5ef-9c4a-4215-8fcc-a4dd82bf5f37',2,'Mobile World Congress',92.63,30,1,'Alan Mohr','miles.stanton@yahoo.com','I hate cats and dogs.\' It was so small as this before, never! And I declare it\'s too bad, that it.',NULL,'20',92.63,1,92.63,92.63,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(21,'QUJMNKAHSKHA','a3622456-779f-418d-bf93-e5765af6a2a9',3,'Google I/O',32.19,21,1,'Prof. Braulio Nienow','fay.mario@yahoo.com','Panther were sharing a pie--\' [later editions continued as follows The Panther took pie-crust, and.',NULL,'21',32.19,2,64.38,64.38,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(22,'R6AQIVEGPNTU','b173bd1e-28bb-4c9d-a3e5-330512e2e301',3,'Google I/O',32.19,24,1,'Heaven Shields','celine.macejkovic@balistreri.biz','Duchess! The Duchess! Oh my dear Dinah! I wonder who will put on his spectacles. \'Where shall I.',NULL,'22',32.19,4,128.76,128.76,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(23,'CVLFRZLOJELQ','24b0f54a-ab26-448e-9127-5ebb8a732c5d',3,'Google I/O',32.19,1,1,'Jessyca Casper','customer@archielite.com','Alice herself, and fanned herself with one finger; and the Panther were sharing a pie--\' [later.',NULL,'23',32.19,4,128.76,128.76,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(24,'NQGU8VSV4XCR','6f87dcee-a3f0-4922-8daa-9d8c6b517457',3,'Google I/O',32.19,4,1,'Hank Legros','jquigley@yahoo.com','Cheshire Cat,\' said Alice: \'three inches is such a thing. After a minute or two the Caterpillar.',NULL,'24',32.19,2,64.38,64.38,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(25,'C37NPG1IZMVQ','65a76575-b094-4240-bbe6-439608206b12',3,'Google I/O',32.19,4,1,'Hank Legros','jquigley@yahoo.com','Alice\'s head. \'Is that the hedgehog to, and, as they all spoke at once, in a deep voice, \'What are.',NULL,'25',32.19,1,32.19,32.19,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(26,'Y5ISWC2KGB6E','c13a4c10-4bd4-4458-9279-02f367d40194',3,'Google I/O',32.19,24,1,'Heaven Shields','celine.macejkovic@balistreri.biz','I can\'t quite follow it as a last resource, she put her hand on the top of it. She stretched.',NULL,'26',32.19,4,128.76,128.76,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(27,'M75EPRZMOHUP','b7a5baf0-b02e-4de9-b973-99dc91f3ddc2',3,'Google I/O',32.19,22,1,'Brenda Krajcik','ppagac@daniel.com','Duchess; \'and most things twinkled after that--only the March Hare interrupted, yawning. \'I\'m.',NULL,'27',32.19,5,160.95,160.95,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45'),(28,'O54GQOKB7HTU','e20a640d-bd40-4517-8461-8f69ee1c526a',3,'Google I/O',32.19,4,1,'Hank Legros','jquigley@yahoo.com','I can\'t be civil, you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen never left off when.',NULL,'28',32.19,3,96.57,96.57,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:45','2025-06-10 10:39:46'),(29,'RQ3D03VQQF7H','2a895dbc-2a58-49d2-b28a-eefffb6fc6a6',3,'Google I/O',32.19,22,1,'Brenda Krajcik','ppagac@daniel.com','King said to herself \'This is Bill,\' she gave her one, they gave him two, You gave us three or.',NULL,'29',32.19,3,96.57,96.57,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(30,'PF6IUTBCPYRZ','9d849f7a-aefa-48e5-8896-a3d71688bd53',3,'Google I/O',32.19,21,1,'Prof. Braulio Nienow','fay.mario@yahoo.com','SHE, of course,\' the Gryphon went on. \'Or would you like to be lost: away went Alice like the.',NULL,'30',32.19,1,32.19,32.19,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(31,'RLJLUFV7OYZ9','e87a0b8c-87f5-4801-b5a2-cbfe54f1939f',4,'Apple WWDC',54.12,28,1,'Prof. Berry Bartoletti','cleo.fahey@hotmail.com','I\'ve finished.\' So they went on for some time busily writing in his confusion he bit a large cat.',NULL,'31',54.12,2,108.24,108.24,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(32,'VAKDORWKBEPG','023002bb-0b1f-4e6f-a336-fea6bb84c473',4,'Apple WWDC',54.12,15,1,'Fermin Lindgren Jr.','wiley26@yahoo.com','I am to see if she meant to take MORE than nothing.\' \'Nobody asked YOUR opinion,\' said Alice. \'You.',NULL,'32',54.12,4,216.48,216.48,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(33,'8JJFJETOBXDD','62b7c29b-2b68-432f-8dff-791047f1b017',4,'Apple WWDC',54.12,28,1,'Prof. Berry Bartoletti','cleo.fahey@hotmail.com','Mock Turtle, and to her that she could see it written down: but I think I should like to try the.',NULL,'33',54.12,2,108.24,108.24,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(34,'2TAIRPOFWLSF','c3f29dde-1c35-4220-b0da-6eacb0891b83',4,'Apple WWDC',54.12,28,1,'Prof. Berry Bartoletti','cleo.fahey@hotmail.com','Alice: he had never seen such a pleasant temper, and thought it would,\' said the others. \'Are.',NULL,'34',54.12,1,54.12,54.12,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(35,'Q9V9DJ2TS4IK','70753602-b96d-4aec-b6d0-48c340f4cbd6',4,'Apple WWDC',54.12,15,1,'Fermin Lindgren Jr.','wiley26@yahoo.com','Knave \'Turn them over!\' The Knave of Hearts, carrying the King\'s crown on a crimson velvet.',NULL,'35',54.12,4,216.48,216.48,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(36,'CRUZTLFFFHX9','6058314d-e79b-4d6f-bb1b-d278ce5a474a',4,'Apple WWDC',54.12,26,1,'Dr. Wilfrid Schowalter DVM','zieme.haven@yahoo.com','King, and the arm that was sitting on a crimson velvet cushion; and, last of all this time. \'I.',NULL,'36',54.12,5,270.60,270.60,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(37,'VWWQKCIPES6L','12f06542-16b5-48c7-abcb-2b0f9ca1a97b',4,'Apple WWDC',54.12,7,1,'Mr. Jarod Zulauf','haskell.botsford@huel.net','Alice remarked. \'Oh, you can\'t help it,\' said the Cat, \'a dog\'s not mad. You grant that?\' \'I.',NULL,'37',54.12,5,270.60,270.60,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(38,'BDNBWOAN5VFF','7449515e-66e1-406a-8c1d-b8a4409d33b5',4,'Apple WWDC',54.12,15,1,'Fermin Lindgren Jr.','wiley26@yahoo.com','The further off from England the nearer is to do THAT in a Little Bill It was the King; and the.',NULL,'38',54.12,4,216.48,216.48,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(39,'F0OBSVFNY0Y5','8eacbedd-76bb-4e44-b5f0-bc5246237165',4,'Apple WWDC',54.12,24,1,'Heaven Shields','celine.macejkovic@balistreri.biz','It\'s high time you were never even introduced to a farmer, you know, with oh, such long curly.',NULL,'39',54.12,4,216.48,216.48,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(40,'8F7GEVFA6MJN','bafcdd94-5d1a-455b-b23e-7f443227ac17',4,'Apple WWDC',54.12,16,1,'Mac Price','will.willa@yahoo.com','Alice. \'Well, then,\' the Gryphon remarked: \'because they lessen from day to such stuff? Be off, or.',NULL,'40',54.12,1,54.12,54.12,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46'),(41,'QLUHEU0P5MWQ','41c00192-abf9-45fa-8945-27fac515b4bd',5,'AWS re:Invent',65.45,10,1,'Miss Agnes Hermann','rollin.shanahan@hagenes.info','Knave was standing before them, in chains, with a whiting. Now you know.\' \'I don\'t even know what.',NULL,'41',65.45,1,65.45,65.45,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(42,'KNBCBZEYB8PN','a92870b5-c0b7-416f-b24d-8ea00dba6616',5,'AWS re:Invent',65.45,31,1,'Rhea Prosacco','barrows.casey@damore.com','Alice could hear him sighing as if she was terribly frightened all the party went back to my boy.',NULL,'42',65.45,1,65.45,65.45,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(43,'SINBDRUXHLAY','d96eb1fc-1779-47e4-ba55-843e01fee5cc',5,'AWS re:Invent',65.45,16,1,'Mac Price','will.willa@yahoo.com','I am, sir,\' said Alice; \'but a grin without a moment\'s pause. The only things in the sky. Twinkle.',NULL,'43',65.45,1,65.45,65.45,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(44,'5PBYVJYYB0SZ','27d4a5a6-6937-4339-a6ad-13e98e151cc7',5,'AWS re:Invent',65.45,22,1,'Brenda Krajcik','ppagac@daniel.com','Alice kept her eyes filled with tears running down his face, as long as it settled down again, the.',NULL,'44',65.45,4,261.80,261.80,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(45,'YQWBG9QMNVYL','8afc2016-1ff2-4711-9b66-5031520d101d',5,'AWS re:Invent',65.45,28,1,'Prof. Berry Bartoletti','cleo.fahey@hotmail.com','White Rabbit with pink eyes ran close by it, and burning with curiosity, she ran across the field.',NULL,'45',65.45,5,327.25,327.25,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(46,'R8EZ1KN9EDJJ','f3ed9e3d-00c6-4a1c-a757-c179d62b0cc9',5,'AWS re:Invent',65.45,22,1,'Brenda Krajcik','ppagac@daniel.com','Do you think, at your age, it is almost certain to disagree with you, sooner or later. However.',NULL,'46',65.45,5,327.25,327.25,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(47,'ZKICB4E8GESV','d21fdc03-717d-4707-915d-0b3189e6e4a2',5,'AWS re:Invent',65.45,15,1,'Fermin Lindgren Jr.','wiley26@yahoo.com','Rabbit, and had just succeeded in curving it down into its mouth and yawned once or twice she had.',NULL,'47',65.45,5,327.25,327.25,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(48,'T2YPY1PUE6KO','547c7225-2aa9-44ca-8442-c18951dbea3c',5,'AWS re:Invent',65.45,28,1,'Prof. Berry Bartoletti','cleo.fahey@hotmail.com','Footman went on planning to herself how this same little sister of hers would, in the window?\'.',NULL,'48',65.45,1,65.45,65.45,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(49,'6J8FEFVMIZON','0486e0ef-4e5e-4ca7-a04f-ce8b64ae583c',5,'AWS re:Invent',65.45,8,1,'Willy Berge II','zsteuber@sauer.com','I wish you wouldn\'t mind,\' said Alice: \'three inches is such a capital one for catching mice--oh.',NULL,'49',65.45,5,327.25,327.25,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47'),(50,'9XQS89HRXKCE','6ef883e7-1721-44db-bb36-49033f87f71d',5,'AWS re:Invent',65.45,22,1,'Brenda Krajcik','ppagac@daniel.com','At last the Dodo replied very politely, \'for I never knew whether it was certainly too much pepper.',NULL,'50',65.45,2,130.90,130.90,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=208 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'4H5KBBPMQN7H','Avery Fay','kathryne40@yahoo.com','0721834157','Mock Turtle, capering wildly about. \'Change lobsters again!\' yelled the Gryphon whispered in a.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(2,1,'HBCKGMGMQKAA','Wanda Schmitt I','roman96@smith.org','0243072220','Lobster; I heard him declare, \"You have baked me too brown, I must be collected at once in a.',NULL,'pending','2025-06-10 10:39:43','2025-06-10 10:39:43'),(3,1,'KZFTQXR9HBTI','Prof. Jaunita Rutherford','gretchen.hahn@jerde.com','0769426352','When the pie was all very well to say which), and they repeated their arguments to her, one on.',NULL,'cancelled','2025-06-10 10:39:43','2025-06-10 10:39:43'),(4,1,'BFACIQGHL14D','Dr. Ilene Feest I','roberts.jeffery@hotmail.com','0312010494','Alice, with a kind of sob, \'I\'ve tried the roots of trees, and I\'ve tried banks, and I\'ve tried.',NULL,'refunded','2025-06-10 10:39:43','2025-06-10 10:39:43'),(5,1,'IXWOARC1C14C','Humberto Leannon','klein.annie@yahoo.com','0782037875','King. \'Nothing whatever,\' said Alice. \'Oh, don\'t talk about wasting IT. It\'s HIM.\' \'I don\'t.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(6,2,'MRIRU41BNU2W','Eliza Tromp','aubree01@robel.com','0353533747','Majesty,\' said Two, in a great hurry; \'and their names were Elsie, Lacie, and Tillie; and they sat.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(7,2,'BXSYC3UU55Y1','Mrs. Alva Romaguera PhD','lenny67@hotmail.com','0002828647','Queen of Hearts, who only bowed and smiled in reply. \'Idiot!\' said the Hatter, with an M, such as.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(8,2,'5M8FVDTP1TZJ','Toni Ondricka','eve.douglas@olson.com','0383982335','I never understood what it was written to nobody, which isn\'t usual, you know.\' \'Not at all,\' said.',NULL,'checked_in','2025-06-10 10:39:43','2025-06-10 10:39:43'),(9,2,'C9GQV2WLEOBO','Ms. Katharina Mosciski DVM','eichmann.eileen@gmail.com','0837307531','YOUR shoes done with?\' said the Mock Turtle in the distance, and she looked back once or twice.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(10,2,'RLMH1VFKJ9AC','Patsy Mueller','abshire.brenden@hotmail.com','0217986022','I shall fall right THROUGH the earth! How funny it\'ll seem to encourage the witness at all: he.',NULL,'pending','2025-06-10 10:39:43','2025-06-10 10:39:43'),(11,3,'2049QYSDTCAM','Mr. Davion Jaskolski','kmurray@hotmail.com','0370946829','She had quite a conversation of it at all; however, she went on, \'and most of \'em do.\' \'I don\'t.',NULL,'checked_in','2025-06-10 10:39:43','2025-06-10 10:39:43'),(12,3,'SMU6IYZEAFF9','Craig Lockman MD','brown.madeline@fay.com','0254872037','Alice called after her. \'I\'ve something important to say!\' This sounded promising, certainly.',NULL,'checked_in','2025-06-10 10:39:43','2025-06-10 10:39:43'),(13,3,'MFE3MRSN8Z14','Maybelle Sanford','meaghan.hirthe@reilly.com','0023847677','Cat, \'or you wouldn\'t mind,\' said Alice: \'she\'s so extremely--\' Just then she remembered how small.',NULL,'purchased','2025-06-10 10:39:43','2025-06-10 10:39:43'),(14,3,'07BEPELMHQIK','Rosalinda Funk','zkunze@gmail.com','0272010470','King said to Alice. \'Nothing,\' said Alice. \'Off with his nose Trims his belt and his friends.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(15,4,'UHZX3IWOMCI5','Antoinette Fritsch MD','lexie89@keeling.net','0698300018','I\'ll have you executed on the OUTSIDE.\' He unfolded the paper as he could think of anything to.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(16,4,'WAZNM6GACA1L','Prof. Chadrick Heidenreich','lysanne.murphy@yahoo.com','0435059507','Mock Turtle in a low voice, \'Why the fact is, you see, as well say that \"I see what this bottle.',NULL,'refunded','2025-06-10 10:39:43','2025-06-10 10:39:43'),(17,4,'DX6YEPRQT0GL','Prof. Lincoln Stamm','dhayes@jast.com','0666239166','I\'m angry. Therefore I\'m mad.\' \'I call it purring, not growling,\' said Alice. \'I\'ve so often read.',NULL,'pending','2025-06-10 10:39:43','2025-06-10 10:39:43'),(18,4,'CVBON6TESMKR','Dortha Hill','abrakus@considine.net','0563754337','She stretched herself up closer to Alice\'s side as she went on, \'you throw the--\' \'The lobsters!\'.',NULL,'purchased','2025-06-10 10:39:43','2025-06-10 10:39:43'),(19,4,'NA70IJUNUQEM','Kelli Borer','eve.gulgowski@yahoo.com','0621701562','Why, there\'s hardly enough of me left to make out that one of them say, \'Look out now, Five! Don\'t.',NULL,'pending','2025-06-10 10:39:43','2025-06-10 10:39:43'),(20,4,'Q08AXNO0DB7I','Ewald Wehner','lucius.toy@reilly.net','0319498531','There was nothing so VERY remarkable in that; nor did Alice think it was,\' said the Duchess. An.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(21,5,'YEREBEYKINKZ','Rosella Hackett','ruthie.schmidt@hotmail.com','0146989666','Alice, \'shall I NEVER get any older than you, and listen to me! When I used to it!\' pleaded poor.',NULL,'transferred','2025-06-10 10:39:43','2025-06-10 10:39:43'),(22,5,'AZMHOJ9TCHRJ','Hillard Lebsack','mose.parker@gmail.com','0537680775','I shall have somebody to talk to.\' \'How are you getting on?\' said the Mock Turtle said: \'I\'m too.',NULL,'pending','2025-06-10 10:39:43','2025-06-10 10:39:43'),(23,5,'NWYARITVBQC4','Mary Skiles','moen.sebastian@hotmail.com','0233171922','And when I was sent for.\' \'You ought to be a footman because he taught us,\' said the Footman.',NULL,'purchased','2025-06-10 10:39:43','2025-06-10 10:39:43'),(24,5,'DHJARXFWOFDY','Scotty Franecki','fay.joshua@brakus.com','0114142530','The King\'s argument was, that she was coming to, but it was sneezing on the bank, and of having.',NULL,'purchased','2025-06-10 10:39:43','2025-06-10 10:39:43'),(25,5,'NP7E8WLB8X0K','Mr. Kole Green IV','caitlyn.labadie@yahoo.com','0403678387','Then the Queen till she was now more than that, if you want to see if there were no tears. \'If.',NULL,'purchased','2025-06-10 10:39:43','2025-06-10 10:39:43'),(26,6,'FALANZGCVO6C','Oma Kuhic','jamey.zieme@carroll.com','0413766448','March--just before HE went mad, you know--\' (pointing with his knuckles. It was all dark overhead.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(27,6,'HD54KRT40UC3','Holden Armstrong','klehner@ledner.com','0688595198','Knave did so, very carefully, nibbling first at one and then nodded. \'It\'s no business of MINE.\'.',NULL,'checked_in','2025-06-10 10:39:44','2025-06-10 10:39:44'),(28,7,'IZRSXDCF9T0L','Rusty Mante','zlangworth@harber.biz','0913669976','Majesty,\' said the cook. \'Treacle,\' said a sleepy voice behind her. \'Collar that Dormouse,\' the.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(29,7,'ENH9RK9WR91G','Grady Padberg','enos.jacobs@hotmail.com','0996478062','And argued each case with MINE,\' said the Mouse was swimming away from him, and very soon finished.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(30,7,'H8ZDSDUAIK5O','Kurtis Schneider','grayson15@hotmail.com','0877867701','Duchess, the Duchess! Oh! won\'t she be savage if I\'ve been changed for any of them. However, on.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(31,7,'WPD6NONGKTDP','Adeline King','rickey09@yahoo.com','0717807504','I get SOMEWHERE,\' Alice added as an explanation. \'Oh, you\'re sure to happen,\' she said to the.',NULL,'cancelled','2025-06-10 10:39:44','2025-06-10 10:39:44'),(32,7,'PTTRR2KUEJXG','Ara Prohaska','sreichel@hotmail.com','0733319210','Alice began in a low, trembling voice. \'There\'s more evidence to come before that!\' \'Call the next.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(33,7,'KBDJIT4HG19P','Ariel Breitenberg','litzy63@conn.net','0005589643','I\'ll tell you more than three.\' \'Your hair wants cutting,\' said the Queen, pointing to the other.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(34,8,'XDVZEOXS7DD7','Saige Russel','langworth.cristal@yahoo.com','0641496099','As she said this, she looked down at once, with a soldier on each side to guard him; and near the.',NULL,'cancelled','2025-06-10 10:39:44','2025-06-10 10:39:44'),(35,8,'OARAVLGPZU5I','Kaylah Terry','amani.weissnat@hotmail.com','0453737022','Duchess, who seemed ready to sink into the teapot. \'At any rate I\'ll never go THERE again!\' said.',NULL,'cancelled','2025-06-10 10:39:44','2025-06-10 10:39:44'),(36,8,'M66OALWU2PKV','Frieda Hermann','bailey.lucienne@farrell.com','0853242668','Alice remarked. \'Right, as usual,\' said the Hatter. \'I told you that.\' \'If I\'d been the whiting,\'.',NULL,'checked_in','2025-06-10 10:39:44','2025-06-10 10:39:44'),(37,8,'56BCFGGK8YVZ','Cydney Purdy','mellie.bashirian@rohan.net','0001549828','However, I\'ve got to come out among the trees, a little while, however, she waited for some time.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(38,9,'KCZVRQNBPFI1','Brad Johns MD','jeromy56@cole.org','0309657364','Alice: \'allow me to sell you a couple?\' \'You are all dry, he is gay as a last resource, she put.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(39,9,'UKPBFENTGBFI','Scarlett Hand','macey.kilback@hotmail.com','0852508126','Mock Turtle, who looked at her, and she swam lazily about in the middle, nursing a baby; the cook.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(40,9,'26GAETJ8UHCD','Jaquan Terry','ladarius00@bruen.com','0223561844','Alice waited till the puppy\'s bark sounded quite faint in the direction it pointed to, without.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(41,9,'8SVI4IDCABMT','Verlie Feil','adalberto32@gmail.com','0180541760','Ma!\' said the young man said, \'And your hair has become very white; And yet you incessantly stand.',NULL,'cancelled','2025-06-10 10:39:44','2025-06-10 10:39:44'),(42,9,'QFVZEWEYDYZ7','Seth Jast','maverick85@hotmail.com','0994107790','I\'m a deal faster than it does.\' \'Which would NOT be an advantage,\' said Alice, (she had kept a.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(43,9,'4VVELGXQ4QGN','Lilly Gutmann','davin46@hotmail.com','0492730472','Drawling-master was an old Crab took the watch and looked into its eyes again, to see what would.',NULL,'pending','2025-06-10 10:39:44','2025-06-10 10:39:44'),(44,10,'S7Z6EL4RWJ8I','Margarete Howell','vandervort.mathias@yahoo.com','0764528315','Alice in a mournful tone, \'he won\'t do a thing before, and he hurried off. Alice thought to.',NULL,'checked_in','2025-06-10 10:39:44','2025-06-10 10:39:44'),(45,10,'UIW4UHDWAEY8','Olin Hermiston','brian.waelchi@braun.org','0437821738','I shan\'t grow any more--As it is, I can\'t remember,\' said the Caterpillar decidedly, and he poured.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(46,10,'SL1NNDFFZNYP','Mafalda Hirthe','vkoch@ratke.com','0436019069','Alice looked down into its eyes by this time). \'Don\'t grunt,\' said Alice; \'that\'s not at all a.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(47,10,'C7XHVT8ABPPG','Precious Kautzer','maynard.rosenbaum@pagac.com','0851425482','At last the Dodo could not think of nothing better to say it out again, so violently, that she.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(48,11,'INDBJ66KNTFH','Kaya Watsica','elton95@zemlak.org','0044933850','Alice to herself. \'Of the mushroom,\' said the Hatter: \'let\'s all move one place on.\' He moved on.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(49,11,'IAWVOLBPIM5J','Prof. Leo Schneider','leopoldo.jenkins@gmail.com','0138592577','Alice, who felt ready to sink into the court, arm-in-arm with the name again!\' \'I won\'t indeed!\'.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(50,12,'FRGU4PP8ESBI','Keshaun Pouros','raven68@grant.com','0812725938','I learn music.\' \'Ah! that accounts for it,\' said Alice as he said to live. \'I\'ve seen a rabbit.',NULL,'pending','2025-06-10 10:39:44','2025-06-10 10:39:44'),(51,12,'VYKOEP5YZ1TM','Prof. Audie Collins','fatima36@von.com','0128706399','This of course, Alice could hardly hear the very tones of her sharp little chin. \'I\'ve a right to.',NULL,'pending','2025-06-10 10:39:44','2025-06-10 10:39:44'),(52,12,'VQTX4SOLAP8W','Dr. Arden Connelly DDS','daryl.bailey@yahoo.com','0735999316','I\'ve got to grow up any more if you\'d rather not.\' \'We indeed!\' cried the Mouse, sharply and very.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(53,12,'UD3JPTVX0FMH','Bonita Grant','justus.blanda@yahoo.com','0174255078','Caterpillar seemed to be seen: she found to be said. At last the Mouse, in a hoarse growl, \'the.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(54,12,'JDGEHMPFOXXQ','Vickie Schultz','wschultz@yahoo.com','0230278949','Majesty,\' he began, \'for bringing these in: but I don\'t like the tone of great curiosity. \'Soles.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(55,12,'FZPBRNLCCSLD','Bertrand Fritsch','libbie88@mertz.com','0207014979','Caterpillar contemptuously. \'Who are YOU?\' Which brought them back again to the baby, it was too.',NULL,'pending','2025-06-10 10:39:44','2025-06-10 10:39:44'),(56,13,'Y0YM0MBNRM69','Leanna Wuckert','elna03@hotmail.com','0330341385','First, however, she went back for a long tail, certainly,\' said Alice, in a deep, hollow tone.',NULL,'cancelled','2025-06-10 10:39:44','2025-06-10 10:39:44'),(57,13,'RNYGUS1T2OTJ','Lonny Stanton DDS','lessie.legros@yahoo.com','0544255017','I know all sorts of things--I can\'t remember things as I do,\' said the Footman, and began by.',NULL,'checked_in','2025-06-10 10:39:44','2025-06-10 10:39:44'),(58,13,'JRSTNQX1WXQ2','Ashlynn Olson','johann79@padberg.info','0045673409','SIT down,\' the King replied. Here the Dormouse denied nothing, being fast asleep. \'After that,\'.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(59,14,'BNQW9RKPETTX','Mr. Zion Jakubowski','blanda.friedrich@okon.com','0168485245','Dormouse fell asleep instantly, and Alice rather unwillingly took the regular course.\' \'What was.',NULL,'cancelled','2025-06-10 10:39:44','2025-06-10 10:39:44'),(60,14,'HOXB4EXD5SIO','Miss Carolanne Monahan MD','aubrey13@white.com','0224408408','Panther received knife and fork with a T!\' said the March Hare,) \'--it was at the bottom of the.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(61,14,'ROT5V7BNPT3S','Ms. Sarah Green II','rohan.milan@schumm.com','0816447980','FENDER, (WITH ALICE\'S LOVE). Oh dear, what nonsense I\'m talking!\' Just then her head was so long.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(62,14,'AUXIMYO9ZJGD','Gino Hoppe MD','morar.allan@mclaughlin.com','0568698774','Alice. \'Why, SHE,\' said the Caterpillar. Here was another long passage, and the pool rippling to.',NULL,'pending','2025-06-10 10:39:44','2025-06-10 10:39:44'),(63,14,'RZM0UXJUDHNU','Mrs. Lelia Prosacco DVM','angel51@yahoo.com','0672352343','My notion was that it seemed quite dull and stupid for life to go down the chimney, has he?\' said.',NULL,'pending','2025-06-10 10:39:44','2025-06-10 10:39:44'),(64,14,'FJJRFHG1II0L','Prof. Adonis Carroll DDS','baylee.toy@koepp.org','0587421611','I must,\' the King sharply. \'Do you know about this business?\' the King said to herself, and once.',NULL,'transferred','2025-06-10 10:39:44','2025-06-10 10:39:44'),(65,15,'5OLRQ6DWCQWA','Jakayla Kuhn','dhermiston@hotmail.com','0245624305','Time as well as she could. \'No,\' said the Duck: \'it\'s generally a ridge or furrow in the.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(66,15,'VA5ODPABPYLK','Mac Jaskolski','jasen.cruickshank@koepp.com','0867497825','ONE with such a curious croquet-ground in her face, with such a long time with one finger for the.',NULL,'checked_in','2025-06-10 10:39:44','2025-06-10 10:39:44'),(67,15,'VDPUOVBHTEOQ','Gavin O\'Reilly PhD','leila.wisoky@gerhold.com','0832737646','So Alice got up in great disgust, and walked two and two, as the Caterpillar took the cauldron of.',NULL,'checked_in','2025-06-10 10:39:44','2025-06-10 10:39:44'),(68,15,'I9FYO0KYV9HR','Brice Kris','nlittle@prosacco.biz','0573415713','Still she went on, \'I must be getting home; the night-air doesn\'t suit my throat!\' and a fall, and.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(69,16,'KHP2PIUDQPTX','Luigi Gutmann','gerhard.schaden@aufderhar.org','0924956356','And will talk in contemptuous tones of the Rabbit\'s voice; and Alice looked at each other for some.',NULL,'reserved','2025-06-10 10:39:44','2025-06-10 10:39:44'),(70,16,'AJISOHUWHU0H','Prof. Kristopher Cruickshank DVM','qbergstrom@hotmail.com','0259816287','ALL RETURNED FROM HIM TO YOU,\"\' said Alice. \'Off with her head! Off--\' \'Nonsense!\' said Alice, who.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(71,17,'XQBE3VFOVLX4','Gustave Mann','goyette.eddie@fahey.biz','0781024628','Gryphon said to Alice; and Alice was not here before,\' said Alice,) and round the court was in.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(72,17,'1DED3NR3RSEM','Timmy Rippin','steuber.domenic@hotmail.com','0121994370','Normans--\" How are you thinking of?\' \'I beg pardon, your Majesty,\' said Two, in a low voice. \'Not.',NULL,'purchased','2025-06-10 10:39:44','2025-06-10 10:39:44'),(73,17,'WWEISNODPSZY','Mr. Dedric Maggio','cruickshank.yasmine@gmail.com','0231814001','Alice. \'Off with their fur clinging close to her: first, because the chimneys were shaped like the.',NULL,'refunded','2025-06-10 10:39:44','2025-06-10 10:39:44'),(74,17,'XLF176XECPAD','Brenden Cole Jr.','charlene30@gmail.com','0916952655','Cat. \'Do you know why it\'s called a whiting?\' \'I never saw one, or heard of \"Uglification,\"\' Alice.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(75,17,'MPAEVAA4BKH1','Sylvia Schaden','ckautzer@gmail.com','0001947678','I\'m afraid, but you might knock, and I had our Dinah here, I know I have ordered\'; and she went on.',NULL,'purchased','2025-06-10 10:39:45','2025-06-10 10:39:45'),(76,17,'J6EHIA4J0T8S','Dr. Lavon Hickle','haley.shannon@sauer.com','0520348101','Mock Turtle replied; \'and then the other, saying, in a natural way. \'I thought it would,\' said the.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(77,18,'ZEEUDJITDFJY','Kelvin Considine','richard.hoeger@yahoo.com','0844942321','So Alice began in a very humble tone, going down on one knee. \'I\'m a poor man, your Majesty,\' the.',NULL,'checked_in','2025-06-10 10:39:45','2025-06-10 10:39:45'),(78,18,'OFPSQJEMDGPP','Miss Violet Lueilwitz','fadel.garland@cassin.biz','0173557589','Conqueror, whose cause was favoured by the hand, it hurried off, without waiting for the next.',NULL,'checked_in','2025-06-10 10:39:45','2025-06-10 10:39:45'),(79,18,'FZDOA42RZNBC','Mrs. Chyna Feest IV','ikunze@yahoo.com','0109197963','Alice to herself, \'because of his tail. \'As if I can listen all day to day.\' This was such a tiny.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(80,18,'V6XR5CL0HM7Z','Darien O\'Keefe','emmanuel.romaguera@stoltenberg.com','0933791434','Take your choice!\' The Duchess took her choice, and was going to leave it behind?\' She said the.',NULL,'checked_in','2025-06-10 10:39:45','2025-06-10 10:39:45'),(81,18,'SBSX9O3VP3A9','Mr. Foster Schuster','gkoch@oconner.net','0014043852','Queen will hear you! You see, she came upon a time she went on: \'--that begins with an M, such as.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(82,18,'WSKRTNGPHFY6','Isaiah Muller II','strosin.chelsie@kautzer.com','0193665115','Alice thought she might find another key on it, and then added them up, and began picking them up.',NULL,'reserved','2025-06-10 10:39:45','2025-06-10 10:39:45'),(83,19,'9SBHSNSURZVW','Ms. Zola Miller','sophia.russel@yahoo.com','0930855793','Cat, and vanished again. Alice waited a little, \'From the Queen. \'Their heads are gone, if it had.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(84,19,'VKGXCSWHIMQD','Lavonne Yundt','marvin.lempi@rippin.net','0129933337','I\'ve said as yet.\' \'A cheap sort of life! I do it again and again.\' \'You are old,\' said the last.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(85,20,'O57EJGJNTSDM','Dakota Abernathy','rosamond77@lynch.com','0970606527','There could be no chance of her head made her so savage when they liked, and left off writing on.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(86,20,'EMGBOPBLI1QN','Dr. Kenya Strosin','amedhurst@gmail.com','0970955400','Queen, who had been to a farmer, you know, as we needn\'t try to find that she was walking by the.',NULL,'purchased','2025-06-10 10:39:45','2025-06-10 10:39:45'),(87,21,'4P20CMJNXJZQ','Mr. Mackenzie Schowalter V','marielle.damore@wiegand.com','0640963835','After a while she was about a whiting before.\' \'I can tell you just now what the flame of a tree a.',NULL,'pending','2025-06-10 10:39:45','2025-06-10 10:39:45'),(88,21,'XDFBNMQAH2XZ','Deven Stark III','lebsack.jayson@gmail.com','0927965692','Bill had left off sneezing by this time). \'Don\'t grunt,\' said Alice; \'that\'s not at all what had.',NULL,'purchased','2025-06-10 10:39:45','2025-06-10 10:39:45'),(89,21,'IKJNSFKOVLCJ','Augusta Hettinger','ulowe@gmail.com','0760020477','Alice was not even room for her. \'Yes!\' shouted Alice. \'Come on, then,\' said Alice, who was.',NULL,'checked_in','2025-06-10 10:39:45','2025-06-10 10:39:45'),(90,22,'VQWEBSOO0LAK','Jabari Sawayn','anthony.cremin@walsh.org','0006400267','I THINK; or is it directed to?\' said the King said gravely, \'and go on for some time in silence.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(91,22,'RILI9K2OL0X3','Nathan Romaguera','wintheiser.anabelle@hotmail.com','0535903377','King; and the shrill voice of the right-hand bit to try the patience of an oyster!\' \'I wish I.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(92,22,'X8T2MRD1AWEI','Ned Hoeger I','zrogahn@gmail.com','0400028977','Alice. \'You must be,\' said the Mock Turtle; \'but it doesn\'t matter a bit,\' she thought it over.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(93,22,'VXUFLPRFKGG2','Maximus Smith','jenkins.keara@hilpert.com','0306950464','She had quite a crowd of little Alice herself, and fanned herself with one elbow against the roof.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(94,22,'K6XE6KBLOGYD','Mr. Dereck Johns','pollich.casper@yahoo.com','0797917434','Dinah, if I can kick a little!\' She drew her foot as far as they would die. \'The trial cannot.',NULL,'cancelled','2025-06-10 10:39:45','2025-06-10 10:39:45'),(95,23,'WLAJ35QFR5ZK','Anthony Rohan','metz.percy@runolfsson.com','0842388736','WOULD not remember the simple rules their friends had taught them: such as, \'Sure, I don\'t want to.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(96,23,'QKULALNY2JHF','Krystal Goodwin','ehane@jones.com','0511331493','I may as well go back, and see how the Dodo solemnly presented the thimble, saying \'We beg your.',NULL,'cancelled','2025-06-10 10:39:45','2025-06-10 10:39:45'),(97,23,'BDC6XZRAOSEK','Margret Mann','hannah90@kohler.com','0580323733','As soon as there was hardly room to grow here,\' said the Mock Turtle. \'Seals, turtles, salmon, and.',NULL,'purchased','2025-06-10 10:39:45','2025-06-10 10:39:45'),(98,23,'IIMI5D64VIEM','Jayde Toy','newell84@thiel.info','0028399996','Alice; not that she had asked it aloud; and in a twinkling! Half-past one, time for dinner!\' (\'I.',NULL,'checked_in','2025-06-10 10:39:45','2025-06-10 10:39:45'),(99,23,'CIIKSBHPOA7Z','Dorthy Cruickshank','helena.gerlach@carter.net','0906166922','Alice, timidly; \'some of the house, quite forgetting in the wind, and the moon, and memory, and.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(100,24,'JLKOVMF3Q0DB','Diana Quigley','kaylee.rempel@yahoo.com','0061361087','King repeated angrily, \'or I\'ll have you executed.\' The miserable Hatter dropped his teacup.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(101,24,'TEL97KGFXNOU','Dolores Dare I','hahn.estell@gmail.com','0884058717','I\'ll look first,\' she said, \'than waste it in less than a pig, my dear,\' said Alice, swallowing.',NULL,'checked_in','2025-06-10 10:39:45','2025-06-10 10:39:45'),(102,24,'49RBXRUFCJUX','Blanca Dickinson I','kkulas@hotmail.com','0643600456','YOU, and no room at all what had become of me?\' Luckily for Alice, the little creature down, and.',NULL,'cancelled','2025-06-10 10:39:45','2025-06-10 10:39:45'),(103,25,'VXXBDS7ZMABF','Hunter Schultz','luettgen.jocelyn@beahan.net','0148562719','I give it up,\' Alice replied: \'what\'s the answer?\' \'I haven\'t the least notice of them hit her in.',NULL,'purchased','2025-06-10 10:39:45','2025-06-10 10:39:45'),(104,25,'QCSQBY04BCNH','Dr. Barrett Wisoky','alexys55@zemlak.com','0260065131','I dare say you\'re wondering why I don\'t think,\' Alice went on, \'I must go by the end of his tail.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(105,26,'ZOBSVNNUAWVF','Dr. Jerald Vandervort V','owintheiser@crona.com','0783570745','They had not gone far before they saw her, they hurried back to the law, And argued each case with.',NULL,'reserved','2025-06-10 10:39:45','2025-06-10 10:39:45'),(106,26,'LA1ALBDZHAHM','Guido Goodwin','block.brennan@kautzer.com','0920977121','She was a child,\' said the Footman. \'That\'s the reason is--\' here the conversation a little. \'\'Tis.',NULL,'cancelled','2025-06-10 10:39:45','2025-06-10 10:39:45'),(107,26,'V3FCH3HPXOE7','Prof. Peggie Miller','stracke.rod@yahoo.com','0640619120','Alice. \'Now we shall get on better.\' \'I\'d rather finish my tea,\' said the King, who had been.',NULL,'pending','2025-06-10 10:39:45','2025-06-10 10:39:45'),(108,26,'BOK8YPK1JEGU','Jaycee Bernier','zack.eichmann@gmail.com','0113656154','Alice could think of any use, now,\' thought Alice, \'to speak to this last word with such sudden.',NULL,'cancelled','2025-06-10 10:39:45','2025-06-10 10:39:45'),(109,26,'OGZE4IRLFEO7','Roel Zboncak','xbruen@paucek.com','0087285826','Stole the Tarts? The King turned pale, and shut his eyes.--\'Tell her about the right words,\' said.',NULL,'reserved','2025-06-10 10:39:45','2025-06-10 10:39:45'),(110,27,'Z68VL98K8PLS','Mrs. Clare Bins','uschmidt@yahoo.com','0305309493','Alice. \'Off with his head!\' or \'Off with his nose, you know?\' \'It\'s the Cheshire Cat: now I shall.',NULL,'refunded','2025-06-10 10:39:45','2025-06-10 10:39:45'),(111,27,'OFJNCREVBT3H','Miss Myrtice Mosciski PhD','giovani71@friesen.com','0704173273','I wish you were INSIDE, you might catch a bat, and that\'s all I can guess that,\' she added in an.',NULL,'transferred','2025-06-10 10:39:45','2025-06-10 10:39:45'),(112,27,'MNV6RNQVR557','Neal Hickle','ganderson@gmail.com','0302716818','Dinah my dear! I wish I hadn\'t drunk quite so much!\' said Alice, whose thoughts were still running.',NULL,'reserved','2025-06-10 10:39:45','2025-06-10 10:39:45'),(113,27,'Y5ALULT7FF09','Prof. Fae Rau DDS','gino.wolff@gmail.com','0747798083','Alice. \'Come on, then!\' roared the Queen, turning purple. \'I won\'t!\' said Alice. \'I\'ve so often.',NULL,'pending','2025-06-10 10:39:45','2025-06-10 10:39:45'),(114,27,'B9YUZKFIBVZ9','Murphy Willms','stanton.gavin@lueilwitz.com','0649817049','Queen, who was reading the list of singers. \'You may go,\' said the Pigeon in a hurry: a large.',NULL,'pending','2025-06-10 10:39:45','2025-06-10 10:39:45'),(115,27,'EZ2DDN6BHNB1','Monroe Rodriguez','miller.sonya@yahoo.com','0753054322','Last came a little worried. \'Just about as curious as it spoke. \'As wet as ever,\' said Alice in a.',NULL,'pending','2025-06-10 10:39:45','2025-06-10 10:39:45'),(116,28,'BUNDY67ABYSK','Edwina Swift','abraham.frami@gaylord.com','0027916579','HIM.\' \'I don\'t even know what to say \'I once tasted--\' but checked herself hastily. \'I don\'t see.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(117,28,'0YTYK3IJBOXC','Brooke Armstrong','odicki@huel.biz','0459283410','But do cats eat bats?\' and sometimes, \'Do bats eat cats?\' for, you see, as they lay on the.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(118,28,'OCXTQ7PMHR5U','Dr. Earl Frami','twehner@gmail.com','0994860031','Dodo replied very politely, \'for I never understood what it meant till now.\' \'If that\'s all I can.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(119,28,'EWJMRD56F9ZN','Elwyn Wehner','ulices88@yahoo.com','0942275112','Cheshire Cat,\' said Alice: \'--where\'s the Duchess?\' \'Hush! Hush!\' said the March Hare,) \'--it was.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(120,29,'YCGVNZDHHXE8','Dr. Rachael Zulauf MD','francisca29@yahoo.com','0756366528','I can\'t show it you myself,\' the Mock Turtle, and said to Alice, they all looked puzzled.) \'He.',NULL,'transferred','2025-06-10 10:39:46','2025-06-10 10:39:46'),(121,29,'DCQSWHAIQZP4','Perry Rempel I','dante.larkin@conroy.com','0457366540','I have ordered\'; and she very seldom followed it), and sometimes shorter, until she had forgotten.',NULL,'transferred','2025-06-10 10:39:46','2025-06-10 10:39:46'),(122,29,'DY0YDNEHAHIL','Martina Osinski MD','milton14@hotmail.com','0854810762','King. \'When did you ever saw. How she longed to get rather sleepy, and went on eagerly: \'There is.',NULL,'pending','2025-06-10 10:39:46','2025-06-10 10:39:46'),(123,29,'JYLZMMSJUCZO','Mr. Diamond Fahey','ucollins@hotmail.com','0347839322','She got up and repeat something now. Tell her to speak again. The Mock Turtle said: \'no wise fish.',NULL,'transferred','2025-06-10 10:39:46','2025-06-10 10:39:46'),(124,30,'NZKDENS9IZW9','Brant Langworth','schinner.hortense@oconnell.info','0344025895','I can do without lobsters, you know. So you see, Miss, this here ought to be listening, so she set.',NULL,'refunded','2025-06-10 10:39:46','2025-06-10 10:39:46'),(125,30,'VWKXQRQFELXY','Percival McGlynn V','ypowlowski@gmail.com','0783742962','You\'re mad.\' \'How do you want to get rather sleepy, and went on: \'But why did they draw?\' said.',NULL,'cancelled','2025-06-10 10:39:46','2025-06-10 10:39:46'),(126,31,'15CRYFIAXIQG','Miss Loma Bartell IV','wheathcote@harris.com','0400635521','Alice remarked. \'Right, as usual,\' said the Mock Turtle. \'Seals, turtles, salmon, and so on.\'.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(127,31,'EDQROYRBPEKB','Bethany O\'Kon','clueilwitz@osinski.org','0815676798','Where CAN I have done that, you know,\' said Alice, a little while, however, she again heard a.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(128,31,'XZKZYA6JVXLY','Mrs. Herminia Roob Sr.','qschuppe@kertzmann.com','0934739722','King said to herself, (not in a very little! Besides, SHE\'S she, and I\'m I, and--oh dear, how.',NULL,'cancelled','2025-06-10 10:39:46','2025-06-10 10:39:46'),(129,32,'LJF3CLNF9A2E','Athena Metz','wschmidt@gerhold.com','0030253962','I\'m mad. You\'re mad.\' \'How do you call him Tortoise, if he would not allow without knowing how old.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(130,32,'GNFO4M7X5XSK','Shanon Gerhold','shields.joan@hotmail.com','0399327021','The other side will make you grow taller, and the baby violently up and beg for its dinner, and.',NULL,'transferred','2025-06-10 10:39:46','2025-06-10 10:39:46'),(131,32,'SSOUCU2LAPJI','Sheridan Christiansen','tara60@muller.com','0934387811','I\'ve got to the other queer noises, would change to tinkling sheep-bells, and the reason they\'re.',NULL,'cancelled','2025-06-10 10:39:46','2025-06-10 10:39:46'),(132,32,'WB1ND8UDIJTD','Frederique Lang','wbode@nikolaus.org','0954458159','King said gravely, \'and go on crying in this way! Stop this moment, I tell you!\' But she waited.',NULL,'refunded','2025-06-10 10:39:46','2025-06-10 10:39:46'),(133,32,'MJXWDPF6EEW4','Brock Schuppe','coy70@douglas.net','0232623083','Alice, and, after folding his arms and legs in all my limbs very supple By the use of this pool? I.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(134,33,'IV4PFRPHZ3NH','Ed Bernier','edmond43@lindgren.biz','0662292151','The Mouse looked at Alice, and she drew herself up closer to Alice\'s side as she spoke. \'I must be.',NULL,'pending','2025-06-10 10:39:46','2025-06-10 10:39:46'),(135,33,'GOLD8ILZU84V','Kenyatta Friesen','dorian29@conroy.com','0100807432','Mouse, getting up and walking off to other parts of the cattle in the direction in which case it.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(136,33,'H8WFOGF1TZK3','Arthur Franecki','abrekke@hotmail.com','0096393386','OUTSIDE.\' He unfolded the paper as he spoke, and the Queen\'s hedgehog just now, only it ran away.',NULL,'transferred','2025-06-10 10:39:46','2025-06-10 10:39:46'),(137,34,'UKVJ8AISRUD2','Jaylen Cartwright','kale47@yahoo.com','0567997252','Gryphon: and it sat for a few minutes that she had never been so much frightened that she had not.',NULL,'purchased','2025-06-10 10:39:46','2025-06-10 10:39:46'),(138,34,'BHSDLSMHFWXC','Darrick Crist','immanuel25@yahoo.com','0982057219','When I used to say.\' \'So he did, so he did,\' said the Caterpillar. \'Is that the best of.',NULL,'refunded','2025-06-10 10:39:46','2025-06-10 10:39:46'),(139,35,'SLIMKMEPCIOU','Emely Stehr','jaylan.stiedemann@hotmail.com','0540085750','Alice. \'Of course it was,\' he said. \'Fifteenth,\' said the King. The next witness was the BEST.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(140,35,'STKK3HWHSZRA','Nayeli Barrows','adriana77@gmail.com','0446799814','Hardly knowing what she did, she picked up a little snappishly. \'You\'re enough to look over their.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(141,35,'BAVRCSAZJJVX','Prof. Dustin Denesik','lkoelpin@bins.biz','0389431867','I\'m mad. You\'re mad.\' \'How do you know that you\'re mad?\' \'To begin with,\' the Mock Turtle angrily.',NULL,'purchased','2025-06-10 10:39:46','2025-06-10 10:39:46'),(142,35,'LLKODMTYH7OP','Mr. Geovany DuBuque','oconner.arlo@crooks.com','0385673217','ME\' were beautifully marked in currants. \'Well, I\'ll eat it,\' said the Gryphon, sighing in his.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(143,35,'7WO7LE5GNNM8','Prof. Jett Thiel','robin.schroeder@zieme.biz','0959360819','And oh, my poor little thing sat down and cried. \'Come, there\'s half my plan done now! How.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(144,36,'ZIURKKV5I4VT','Taryn Leannon','kayden.aufderhar@gmail.com','0248827746','ME,\' but nevertheless she uncorked it and put it into one of the March Hare. \'Then it ought to be.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(145,36,'XAFNFGT2LZIL','Mrs. Hortense Cartwright','keith.bednar@yahoo.com','0313745246','Alice, timidly; \'some of the wood for fear of killing somebody, so managed to put down the hall.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(146,36,'QOR9AXD7WZF9','Harley Wyman','jacobs.clemens@gmail.com','0353210953','King was the White Rabbit read:-- \'They told me you had been looking at them with one finger for.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(147,36,'T1O8ZC8QP2H3','Cyril Willms','ortiz.abagail@hotmail.com','0207584188','Alice: \'allow me to sell you a present of everything I\'ve said as yet.\' \'A cheap sort of people.',NULL,'cancelled','2025-06-10 10:39:46','2025-06-10 10:39:46'),(148,36,'3LKU9KU3IXP3','Ms. Felicita Rice','henriette.dickens@huels.com','0743698584','In another minute the whole thing, and she thought it must be the right way to explain the mistake.',NULL,'refunded','2025-06-10 10:39:46','2025-06-10 10:39:46'),(149,36,'R89SBK7KVAN6','Madyson Metz','deanna24@rodriguez.biz','0089055458','Seaography: then Drawling--the Drawling-master was an old woman--but then--always to have lessons.',NULL,'purchased','2025-06-10 10:39:46','2025-06-10 10:39:46'),(150,37,'SFRGIBZJSTZB','Dr. Dariana Schuppe','madilyn.okuneva@sporer.com','0264720256','So they got settled down in an angry tone, \'Why, Mary Ann, and be turned out of sight. Alice.',NULL,'pending','2025-06-10 10:39:46','2025-06-10 10:39:46'),(151,37,'BGJSLHEXBEXX','Roslyn Hickle','herta71@gmail.com','0674077911','Queen, in a low voice, \'Why the fact is, you know. But do cats eat bats, I wonder?\' As she said to.',NULL,'refunded','2025-06-10 10:39:46','2025-06-10 10:39:46'),(152,37,'GAUDIRDFSZPO','Robert Larkin Sr.','yundt.matilda@dickinson.com','0673198887','Caterpillar. \'Well, I hardly know--No more, thank ye; I\'m better now--but I\'m a deal faster than.',NULL,'refunded','2025-06-10 10:39:46','2025-06-10 10:39:46'),(153,37,'9Y21NN7UABDJ','Isaias Johnson','mclaughlin.amie@dicki.com','0125524873','THAT. Then again--\"BEFORE SHE HAD THIS FIT--\" you never tasted an egg!\' \'I HAVE tasted eggs.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(154,37,'U3JD7MHZBXP7','Sebastian Miller','orin.mosciski@gmail.com','0878204559','How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure.',NULL,'purchased','2025-06-10 10:39:46','2025-06-10 10:39:46'),(155,37,'SOZB4IVNOCPH','Abbigail Schuppe','hoeger.sibyl@yahoo.com','0003639193','King. \'Nearly two miles high,\' added the March Hare went \'Sh! sh!\' and the poor little Lizard.',NULL,'refunded','2025-06-10 10:39:46','2025-06-10 10:39:46'),(156,38,'HE2L4UNUKSXX','Prof. Newton Kilback Jr.','rau.isadore@gmail.com','0650331476','The Cat\'s head with great emphasis, looking hard at Alice as he wore his crown over the fire.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(157,38,'VJWEED1PARKZ','Valentin Boyer','muriel.fahey@hammes.biz','0075063950','Some of the shepherd boy--and the sneeze of the thing Mock Turtle yet?\' \'No,\' said Alice. \'Exactly.',NULL,'pending','2025-06-10 10:39:46','2025-06-10 10:39:46'),(158,38,'ZJO3EIPIGRI0','Dr. Keanu Kihn III','umclaughlin@gmail.com','0866636238','I\'m angry. Therefore I\'m mad.\' \'I call it purring, not growling,\' said Alice. \'Of course it is,\'.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(159,38,'0X9SDGJ5SNPB','Ms. Lauryn Nienow Sr.','quitzon.alaina@breitenberg.net','0121993020','I could let you out, you know.\' It was, no doubt: only Alice did not much surprised at this, she.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(160,38,'058V7NAWHHPJ','Morton Abbott','harris.dayton@gmail.com','0849761393','I\'ll eat it,\' said Alice. \'Then you should say what you were never even spoke to Time!\' \'Perhaps.',NULL,'pending','2025-06-10 10:39:46','2025-06-10 10:39:46'),(161,39,'UFQ934ONN6FH','Karina Abbott','francis.dooley@hotmail.com','0185692306','Seaography: then Drawling--the Drawling-master was an old Crab took the least idea what to say.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(162,39,'VARTQOEU6RHM','Magali Rice','giovanny.jaskolski@yahoo.com','0208924594','Drawling-master was an old conger-eel, that used to know. Let me see: I\'ll give them a new idea to.',NULL,'cancelled','2025-06-10 10:39:46','2025-06-10 10:39:46'),(163,39,'YXAG20WGFWVC','Mr. Edmond Becker I','marks.shanna@borer.biz','0713438525','Queen. \'I haven\'t the least notice of them attempted to explain the paper. \'If there\'s no room to.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(164,39,'I2MQYQEXI1LS','Prof. Jarrod Koepp','hirthe.willis@hotmail.com','0620143799','March.\' As she said this, she noticed that they could not answer without a grin,\' thought Alice.',NULL,'purchased','2025-06-10 10:39:46','2025-06-10 10:39:46'),(165,39,'G9VDCNAC4CBI','Neva Welch','jeanette78@kovacek.com','0611830737','THIS size: why, I should frighten them out again. The rabbit-hole went straight on like a serpent.',NULL,'reserved','2025-06-10 10:39:46','2025-06-10 10:39:46'),(166,40,'4TRQFSGPETXI','Miss Roxanne Parisian','carlo33@torphy.net','0999538649','The players all played at once and put it into one of them were animals, and some were birds,) \'I.',NULL,'checked_in','2025-06-10 10:39:46','2025-06-10 10:39:46'),(167,40,'TPDQN2FXBNGK','Kristin Greenholt','fletcher.rodriguez@christiansen.com','0904829642','So she sat down a very long silence, broken only by an occasional exclamation of \'Hjckrrh!\' from.',NULL,'transferred','2025-06-10 10:39:46','2025-06-10 10:39:46'),(168,41,'MRV0IVA2L5WF','Mr. Wayne Crona','canderson@weimann.biz','0020426857','As for pulling me out of that is--\"Be what you were all locked; and when she had never been so.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(169,41,'X98WGR69XOU4','Nia Hermann','vharber@kub.net','0287753279','It was as much use in knocking,\' said the King; and the baby--the fire-irons came first; then.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(170,42,'TA6NKZZTXSYF','Ulices Goodwin','moen.shanie@yahoo.com','0334334393','There was no more to come, so she went round the rosetree; for, you see, because some of the.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(171,42,'O52UY7GNYWB3','Cydney Rosenbaum','colton.mccullough@yahoo.com','0484173397','I\'ve seen that done,\' thought Alice. One of the e--e--evening, Beautiful, beautiful Soup!.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(172,43,'WVJRUAHLEZ8V','Dr. Celestine Feest Sr.','abdiel.parisian@cassin.info','0262081006','An invitation from the Queen to play with, and oh! ever so many tea-things are put out here?\' she.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(173,43,'PBDUNIMRWO2G','Catherine Kertzmann','swift.dariana@effertz.com','0408565203','Mary Ann, and be turned out of the crowd below, and there she saw in my own tears! That WILL be a.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(174,44,'SNSP3WUHQRXI','Earnestine Mills','wintheiser.roel@lakin.org','0955915618','An obstacle that came between Him, and ourselves, and it. Don\'t let him know she liked them best.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(175,44,'EIN9ZIV6NDAG','Schuyler Mitchell','cpurdy@trantow.biz','0638683640','Presently she began thinking over other children she knew the name of the jurymen. \'No, they\'re.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(176,44,'PAK0MPCP0BXG','Cary Robel','eullrich@considine.com','0999158127','And he got up and rubbed its eyes: then it watched the White Rabbit blew three blasts on the song.',NULL,'transferred','2025-06-10 10:39:47','2025-06-10 10:39:47'),(177,44,'LLXX18EC42ZG','Prof. Cale Hettinger I','kristy96@yahoo.com','0337685164','I like being that person, I\'ll come up: if not, I\'ll stay down here till I\'m somebody else\"--but.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(178,44,'VJ4OSMI8VGAN','Carlee Walter','beahan.ward@hotmail.com','0798768829','And beat him when he finds out who I am! But I\'d better take him his fan and gloves, and, as they.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(179,45,'0JAFMCQIMNJI','Erich Gleichner','abdul35@gmail.com','0925394470','Why, I wouldn\'t be so easily offended!\' \'You\'ll get used up.\' \'But what happens when you come to.',NULL,'reserved','2025-06-10 10:39:47','2025-06-10 10:39:47'),(180,45,'ABMRKW6SHCG3','Merlin Hermiston','cali72@gulgowski.biz','0087974199','Hatter. \'Nor I,\' said the King. Here one of the court. All this time it vanished quite slowly.',NULL,'transferred','2025-06-10 10:39:47','2025-06-10 10:39:47'),(181,45,'TX0OF0MAHPCL','Malinda Flatley','vandervort.rowan@gmail.com','0420293612','Geography. London is the same thing, you know.\' It was, no doubt: only Alice did not like the.',NULL,'pending','2025-06-10 10:39:47','2025-06-10 10:39:47'),(182,45,'NHRVBRIFTXLF','Hiram D\'Amore MD','wendy.mann@boehm.org','0526265439','I dare say there may be different,\' said Alice; \'I must be getting somewhere near the house.',NULL,'reserved','2025-06-10 10:39:47','2025-06-10 10:39:47'),(183,45,'W5W6MPYBZKQJ','Sharon Beer','orlando33@bashirian.biz','0538941094','Queen of Hearts, he stole those tarts, And took them quite away!\' \'Consider your verdict,\' the.',NULL,'reserved','2025-06-10 10:39:47','2025-06-10 10:39:47'),(184,45,'75GSIRWB6MO2','Shyann Jacobson','mbradtke@hotmail.com','0299491650','She was looking about for some time after the birds! Why, she\'ll eat a bat?\' when suddenly, thump!.',NULL,'pending','2025-06-10 10:39:47','2025-06-10 10:39:47'),(185,46,'P2WMXHM4IJHO','Mrs. Letitia Douglas IV','jamal21@kutch.com','0121077329','The Gryphon sat up and rubbed its eyes: then it chuckled. \'What fun!\' said the Gryphon, \'you first.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(186,46,'MEISYKMSBHEM','Dr. Danika Kshlerin Sr.','norwood42@gmail.com','0702465966','I know I have ordered\'; and she went on in a moment like a telescope.\' And so it was out of its.',NULL,'cancelled','2025-06-10 10:39:47','2025-06-10 10:39:47'),(187,46,'GJ5Z0KTSUQSL','Miss Baby Baumbach IV','roscoe57@gmail.com','0927537094','I hadn\'t gone down that rabbit-hole--and yet--and yet--it\'s rather curious, you know, upon the.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(188,46,'ECB7WCQBMANE','Mr. Anthony Welch','gunnar99@yahoo.com','0632058601','Queen, but she added, to herself, \'in my going out altogether, like a writing-desk?\' \'Come, we.',NULL,'purchased','2025-06-10 10:39:47','2025-06-10 10:39:47'),(189,46,'IHZMH29AA4V6','Prof. Ethelyn Beatty Sr.','eulah.miller@gerhold.org','0826350017','Five, \'and I\'ll tell you more than Alice could see, as she could, for the Dormouse,\' thought.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(190,46,'2RTIYUOZCA79','Prof. Samson Mueller III','quitzon.orpha@okeefe.info','0622663355','Her chin was pressed hard against it, that attempt proved a failure. Alice heard the Rabbit.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(191,47,'6ATNOIYHQJED','Rigoberto Kutch','pfannerstill.kennedy@yahoo.com','0936282867','Christmas.\' And she tried hard to whistle to it; but she could not remember the simple and loving.',NULL,'pending','2025-06-10 10:39:47','2025-06-10 10:39:47'),(192,47,'CJAFKDLHYKUG','Prof. Domenick Kub','hilbert07@schaden.info','0915602891','IN the well,\' Alice said with some difficulty, as it was very fond of beheading people here; the.',NULL,'cancelled','2025-06-10 10:39:47','2025-06-10 10:39:47'),(193,47,'UPPX6EU6ODTA','Foster Paucek','beahan.damian@klein.org','0733629071','Queen! The Queen!\' and the baby--the fire-irons came first; then followed a shower of little birds.',NULL,'purchased','2025-06-10 10:39:47','2025-06-10 10:39:47'),(194,47,'EFK31HMY7DMX','Laron Osinski','hickle.ally@tromp.net','0287257856','I\'M a Duchess,\' she said these words her foot slipped, and in another moment, splash! she was.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(195,47,'HSHRRFFZMCEB','Joannie Reilly','alaina.lebsack@douglas.net','0197452003','March Hare. Alice was beginning to think about stopping herself before she made it out into the.',NULL,'reserved','2025-06-10 10:39:47','2025-06-10 10:39:47'),(196,47,'VD4B7OLWFBDU','Leonora Sawayn','remington54@larson.org','0412467600','She had already heard her sentence three of the pack, she could guess, she was losing her temper.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(197,48,'EM4Q5UKWCAYO','Prof. Gunner Ortiz DDS','rodger66@crooks.com','0158571058','Alice timidly. \'Would you like the Queen?\' said the King, who had been looking over his shoulder.',NULL,'transferred','2025-06-10 10:39:47','2025-06-10 10:39:47'),(198,48,'V9ZXJCHOAXDA','Sarah Simonis DDS','qdubuque@hotmail.com','0613867476','Alice. \'Come on, then!\' roared the Queen, \'and take this young lady tells us a story.\' \'I\'m afraid.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(199,49,'A8MOOCXIHRVI','Mrs. Gia Zieme PhD','ricky.legros@gmail.com','0169394752','Wonderland, though she knew that it signifies much,\' she said to the Dormouse, and repeated her.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(200,49,'MYXWWO2SCGMC','Floyd Collins','kilback.theresia@gmail.com','0913874728','Mock Turtle, and to wonder what was on the trumpet, and called out as loud as she could for.',NULL,'refunded','2025-06-10 10:39:47','2025-06-10 10:39:47'),(201,49,'S73MPX7VJWL8','Adela Orn','frieda.cassin@gmail.com','0849331927','The Gryphon lifted up both its paws in surprise. \'What! Never heard of \"Uglification,\"\' Alice.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47'),(202,49,'SGBOEXBJRSDT','Weldon Kuhic','jeramie.simonis@cormier.com','0797710859','White Rabbit, who was sitting on the bank--the birds with draggled feathers, the animals with.',NULL,'reserved','2025-06-10 10:39:47','2025-06-10 10:39:47'),(203,49,'VXVPOZAMBUZY','Kaylin Homenick','emelie31@torp.com','0563580714','Heads below!\' (a loud crash)--\'Now, who did that?--It was Bill, I fancy--Who\'s to go down the.',NULL,'pending','2025-06-10 10:39:47','2025-06-10 10:39:47'),(204,49,'WX5JIMOA5OEF','Lina Sawayn Jr.','ksauer@yahoo.com','0847534490','This was quite pleased to have lessons to learn! No, I\'ve made up my mind about it; if I\'m Mabel.',NULL,'transferred','2025-06-10 10:39:47','2025-06-10 10:39:47'),(205,50,'KEKQJLVUSCQX','Lisette Conn','deja.hermann@gorczany.com','0115565528','The Queen turned angrily away from him, and said \'No, never\') \'--so you can find them.\' As she.',NULL,'reserved','2025-06-10 10:39:47','2025-06-10 10:39:47'),(206,50,'BJJDVR8GWO7V','Lucious Sanford V','werner17@nader.com','0817634549','Dormouse. \'Fourteenth of March, I think that there ought! And when I sleep\" is the same age as.',NULL,'pending','2025-06-10 10:39:47','2025-06-10 10:39:47'),(207,50,'EJS8I9ZHIZEI','Mr. Johan Dibbert MD','ojohnston@von.com','0580485221','Alice, who always took a minute or two, it was a different person then.\' \'Explain all that,\' said.',NULL,'checked_in','2025-06-10 10:39:47','2025-06-10 10:39:47');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:39:26','2025-06-10 10:39:26','Voluptas qui autem eos soluta rerum aspernatur. Voluptas consequuntur consectetur consectetur.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:39:26','2025-06-10 10:39:26','Natus est minus qui aut. Velit ut dolores est voluptatem necessitatibus. Et vel voluptas aliquid.'),(3,'Event Experience',0,'published','2025-06-10 10:39:26','2025-06-10 10:39:26','Natus suscipit dolores ipsam voluptate. Aut sit doloribus similique.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:39:26','2025-06-10 10:39:26','Sit quisquam sed sit hic et ratione maiores. Possimus beatae et inventore quia.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Occaecati eaque animi enim dicta quis ut.','Incidunt voluptate at quaerat impedit eius laborum sit explicabo suscipit omnis aspernatur porro enim omnis adipisci tempore nam error voluptas vel necessitatibus iste sapiente quisquam et id aliquam est excepturi non ipsum.',4,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(2,'Qui aut quod unde.','Quidem a vel inventore minus at voluptatem culpa pariatur repellat magnam temporibus id natus sint voluptatibus modi debitis quibusdam quis atque dolores.',3,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(3,'Quia id non quam enim veritatis accusamus.','Quos dolore dolores quia nisi et dolorum et non ratione consequatur sed explicabo doloremque magnam officia placeat quo adipisci odit ullam fugiat numquam dolor consequuntur aut consectetur non aliquam eos sapiente quidem.',2,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(4,'Esse est assumenda nihil unde eum.','A aut error in ut explicabo qui aspernatur rerum et error qui velit ipsum eveniet provident ut vitae porro fugiat est rem quos saepe tempore laboriosam.',2,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(5,'Id qui omnis est ut molestiae.','Consectetur repudiandae quae labore sint voluptatibus voluptatibus vel nihil quibusdam voluptas autem non esse non dicta consequatur vel sit porro eos corrupti necessitatibus quos perferendis enim iste est laboriosam temporibus maxime eveniet consequuntur nam reiciendis natus aut et occaecati laborum.',4,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(6,'Dolor sunt non unde voluptatem maiores.','Et aut mollitia voluptas eum autem ipsam tenetur vero et accusantium vel consectetur nobis veritatis voluptatum asperiores eius totam dignissimos repudiandae velit tenetur reiciendis odit illo accusantium eius atque omnis magnam sed ab doloribus deleniti libero impedit.',4,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(7,'Doloribus minus qui hic.','Est est quia molestiae sed voluptatem et aut ad rem qui occaecati officia est quo natus deserunt nesciunt maxime provident voluptatum quos eum laborum quisquam dolorem assumenda officia et sint repellat iusto repellat voluptatem et illum in.',4,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(8,'Id blanditiis impedit est officia quia eum.','Id rerum eos vel temporibus esse omnis et perferendis quidem quis et sunt eaque non aspernatur non asperiores consequatur corrupti perspiciatis qui aliquam beatae id iste maiores inventore ipsum magni dicta illum nemo fugit hic aspernatur et cumque.',1,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(9,'Rerum qui autem molestias.','Commodi non aspernatur veritatis provident odit repellat molestias voluptates amet et enim necessitatibus quia est qui provident alias natus.',3,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(10,'Dicta ut in eum.','Libero assumenda et suscipit odit fuga qui mollitia autem minima qui et veniam ut explicabo est nobis ea dolorem commodi voluptatum perspiciatis.',2,'published','2025-06-10 10:39:26','2025-06-10 10:39:26'),(11,'Atque repudiandae voluptatibus et magni accusantium culpa.','Nulla quibusdam esse non quia provident voluptas velit fuga perspiciatis aut quia ut aut aut et et odit voluptatum natus expedita aliquid.',4,'published','2025-06-10 10:39:26','2025-06-10 10:39:26');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Explicabo quidem et et ea. Eum sit dolorem placeat qui rerum fugiat tempore. Necessitatibus fuga dolores aut sed velit officia veritatis.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(2,'Ocean Views','Dolorum ut deserunt eius eaque doloribus sint. At voluptate neque est quis quis error eos. Quasi tempora et nam sint.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(3,'Adventure Time','Provident quia tenetur provident facere sint dolorem accusantium. Provident optio et quia voluptatem. Cum fuga numquam est mollitia ea.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(4,'City Lights','Voluptatum cumque sed est accusamus architecto. Quo molestiae est quis suscipit atque qui. Reiciendis deserunt qui inventore ut natus et ullam.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(5,'Dreamscape','Reiciendis minus odit qui molestiae optio. Praesentium perferendis minus aspernatur aliquid. Rerum reprehenderit sed repudiandae similique.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(6,'Enchanted Forest','Et pariatur quod maxime aut. Fugiat a quas est unde.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(7,'Golden Hour','Iusto ipsum et ea perspiciatis et dolor. Ea consequatur ut rerum adipisci iusto sit. Veritatis esse occaecati accusantium a libero.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(8,'Serenity','Voluptatem iusto omnis unde vel deserunt nobis iste numquam. Numquam quo quos ea omnis dolor consequatur.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(9,'Eternal Beauty','Laudantium quo a tenetur similique voluptatibus. Similique possimus minus qui et eius. Qui nobis enim doloremque qui. Qui eum est ut ex molestias ex.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(10,'Moonlight Magic','Et quia quod ut nemo officiis aut sit eum. Earum id consequatur quod in enim maxime. Nulla aut tenetur consequuntur. Illum minus ea quo.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(11,'Starry Night','Sint quia alias exercitationem doloribus temporibus. Laboriosam cum recusandae illum deleniti quasi ea.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(12,'Hidden Gems','Id magnam nemo perferendis ea. Reprehenderit vero reprehenderit eum numquam perspiciatis.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(13,'Tranquil Waters','Placeat repellat dolor minus. Quia sunt magnam ut neque. Explicabo qui non hic. Optio voluptatibus unde quo aut quis vitae.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(14,'Urban Escape','Officiis sint ut est enim voluptatem expedita impedit. Debitis perspiciatis non quia unde quod. Occaecati debitis voluptates quis ad expedita.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:39:00','2025-06-10 10:39:00'),(15,'Twilight Zone','Eos reiciendis laborum repudiandae ea. Est qui voluptates ratione et. Qui perspiciatis voluptas perspiciatis minima perferendis.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:39:01','2025-06-10 10:39:01');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:00','2025-06-10 10:39:00'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:01','2025-06-10 10:39:01'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Possimus voluptatem illo et nostrum ut reprehenderit assumenda. Minus tempora accusamus ut in harum. Impedit nemo earum eius.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quis officiis incidunt autem adipisci consectetur unde architecto. Voluptatum rem sit ea porro eos. Sed adipisci placeat nihil officia est.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Fugit ipsa eius et sed. Quam harum vero rerum quo eius. Eveniet rerum dolorem veniam dicta quia beatae sit.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Enim et et ullam sunt perferendis assumenda quo. Fuga voluptates qui sit quidem. Qui mollitia porro magnam et voluptas atque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui corporis magni magni voluptates. Tempore quibusdam est sit numquam. Sed magnam aut cupiditate et doloribus veniam.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Fugiat dicta autem error atque nobis labore et. Eum omnis similique et. Rem saepe hic magni sint maxime ut molestias. Est qui totam quas aliquid.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Qui voluptas ut eius aut ducimus illo magni nostrum. Rerum corrupti quae aliquam nostrum. Quisquam aut optio facere eaque ut.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Dolorem dolore error quia sint id qui. Et nemo harum repudiandae hic et.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Distinctio non deleniti ducimus est modi aliquid. Ad qui rem vel ut labore voluptates. Itaque ut odio molestiae omnis et.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Aut eius quia sunt placeat aut consectetur sunt. Ipsum esse et quia ut. Asperiores qui commodi voluptatibus.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Aut minima eum laborum est. Laboriosam dolor nesciunt sunt qui esse et nostrum. Nihil magni perspiciatis sed ut iure deserunt voluptatem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Earum amet nemo earum aut quidem dolore. Reprehenderit aut consequuntur nulla ullam. Quis animi consectetur voluptatem sunt tempora.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Sed ipsam dolor ut laboriosam et. Commodi sunt voluptas et.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Recusandae rem soluta aut. Illum et aliquam soluta corporis et delectus. Aut voluptatem enim animi dicta voluptatem.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Eos corrupti eos minus libero nisi quod optio. Fugit sint sed consequatur omnis non fugit non non. Et asperiores blanditiis placeat in.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Et ex hic numquam ea voluptates doloremque cumque rerum. Delectus molestias veritatis omnis magnam nihil iure.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Aut maxime ad aut quis. Labore hic voluptatem non inventore. Voluptatem tempora sunt nihil nobis officiis voluptas.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Molestias et quisquam a eaque rem necessitatibus. Vel sit eius in. Blanditiis ipsum et earum sint aut qui.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Possimus ut quo rem et. Voluptas debitis sunt ea enim error porro. Architecto veniam ad id dolore enim dicta. Id excepturi rerum sequi.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Et quisquam doloremque delectus atque esse aliquam velit. Nam a ad mollitia optio nobis. Sed quisquam et iusto.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:39:01','2025-06-10 10:39:01');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','c54bc88b61735670fa7a50535cc65028',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','3a8ced21636aa49cb7837851ffd7f762',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','86e8b0ad5db3d3bb1ca207e10b8d851b',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:39:01','2025-06-10 10:39:01',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:39:02','2025-06-10 10:39:02',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:39:02','2025-06-10 10:39:02',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:39:02','2025-06-10 10:39:02',NULL,'public'),(36,0,'brand-img1','brand-img1',5,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:39:03','2025-06-10 10:39:03',NULL,'public'),(37,0,'brand-img2','brand-img2',5,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:39:03','2025-06-10 10:39:03',NULL,'public'),(38,0,'brand-img3','brand-img3',5,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:39:03','2025-06-10 10:39:03',NULL,'public'),(39,0,'brand-img4','brand-img4',5,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:39:03','2025-06-10 10:39:03',NULL,'public'),(40,0,'brand-img5','brand-img5',5,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:39:03','2025-06-10 10:39:03',NULL,'public'),(41,0,'brand-img6','brand-img6',5,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:39:03','2025-06-10 10:39:03',NULL,'public'),(42,0,'brand-img7','brand-img7',5,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:39:03','2025-06-10 10:39:03',NULL,'public'),(43,0,'brand-img8','brand-img8',5,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:39:04','2025-06-10 10:39:04',NULL,'public'),(44,0,'1','1',6,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:39:04','2025-06-10 10:39:04',NULL,'public'),(45,0,'2','2',6,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:39:04','2025-06-10 10:39:04',NULL,'public'),(46,0,'header-bg4','header-bg4',6,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:39:04','2025-06-10 10:39:04',NULL,'public'),(47,0,'hero-banner-bg','hero-banner-bg',6,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:39:05','2025-06-10 10:39:05',NULL,'public'),(48,0,'image-1','image-1',6,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:39:06','2025-06-10 10:39:06',NULL,'public'),(49,0,'newsletter-bg','newsletter-bg',6,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:39:07','2025-06-10 10:39:07',NULL,'public'),(50,0,'pricing-name','pricing-name',6,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:39:07','2025-06-10 10:39:07',NULL,'public'),(51,0,'speakers-bg','speakers-bg',6,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:39:07','2025-06-10 10:39:07',NULL,'public'),(52,0,'balloons','balloons',7,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:39:08','2025-06-10 10:39:08',NULL,'public'),(53,0,'calendar','calendar',7,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:39:08','2025-06-10 10:39:08',NULL,'public'),(54,0,'clock','clock',7,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:39:08','2025-06-10 10:39:08',NULL,'public'),(55,0,'coding','coding',7,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:39:08','2025-06-10 10:39:08',NULL,'public'),(56,0,'idea','idea',7,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:39:08','2025-06-10 10:39:08',NULL,'public'),(57,0,'instagram-icon','instagram-icon',7,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:39:09','2025-06-10 10:39:09',NULL,'public'),(58,0,'location-icon','location-icon',7,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:39:09','2025-06-10 10:39:09',NULL,'public'),(59,0,'location','location',7,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:39:09','2025-06-10 10:39:09',NULL,'public'),(60,0,'mail-icon','mail-icon',7,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:39:09','2025-06-10 10:39:09',NULL,'public'),(61,0,'menu','menu',7,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:39:09','2025-06-10 10:39:09',NULL,'public'),(62,0,'microphone','microphone',7,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:39:09','2025-06-10 10:39:09',NULL,'public'),(63,0,'phone-icon','phone-icon',7,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:39:09','2025-06-10 10:39:09',NULL,'public'),(64,0,'search','search',7,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:39:10','2025-06-10 10:39:10',NULL,'public'),(65,0,'speaker','speaker',7,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:39:10','2025-06-10 10:39:10',NULL,'public'),(66,0,'ticket','ticket',7,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:39:10','2025-06-10 10:39:10',NULL,'public'),(67,0,'user','user',7,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:39:10','2025-06-10 10:39:10',NULL,'public'),(68,0,'view','view',7,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:39:10','2025-06-10 10:39:10',NULL,'public'),(69,0,'workshop','workshop',7,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:39:10','2025-06-10 10:39:10',NULL,'public'),(70,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:39:11','2025-06-10 10:39:11',NULL,'public'),(71,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:39:11','2025-06-10 10:39:11',NULL,'public'),(72,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:39:11','2025-06-10 10:39:11',NULL,'public'),(73,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:39:12','2025-06-10 10:39:12',NULL,'public'),(74,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:39:12','2025-06-10 10:39:12',NULL,'public'),(75,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:39:12','2025-06-10 10:39:12',NULL,'public'),(76,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:39:13','2025-06-10 10:39:13',NULL,'public'),(77,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:39:13','2025-06-10 10:39:13',NULL,'public'),(78,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:39:13','2025-06-10 10:39:13',NULL,'public'),(79,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:39:14','2025-06-10 10:39:14',NULL,'public'),(80,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:39:14','2025-06-10 10:39:14',NULL,'public'),(81,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:39:14','2025-06-10 10:39:14',NULL,'public'),(82,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:39:15','2025-06-10 10:39:15',NULL,'public'),(83,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:39:15','2025-06-10 10:39:15',NULL,'public'),(84,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:39:15','2025-06-10 10:39:15',NULL,'public'),(85,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:39:16','2025-06-10 10:39:16',NULL,'public'),(86,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:39:16','2025-06-10 10:39:16',NULL,'public'),(87,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:39:16','2025-06-10 10:39:16',NULL,'public'),(88,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:39:17','2025-06-10 10:39:17',NULL,'public'),(89,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:39:17','2025-06-10 10:39:17',NULL,'public'),(90,0,'about-us-information-1','about-us-information-1',9,'image/png',5914,'homepage02/general/about-us-information-1.png','[]','2025-06-10 10:39:17','2025-06-10 10:39:17',NULL,'public'),(91,0,'about-us-information-2','about-us-information-2',9,'image/png',4914,'homepage02/general/about-us-information-2.png','[]','2025-06-10 10:39:17','2025-06-10 10:39:17',NULL,'public'),(92,0,'about-us-information-3','about-us-information-3',9,'image/png',4914,'homepage02/general/about-us-information-3.png','[]','2025-06-10 10:39:18','2025-06-10 10:39:18',NULL,'public'),(93,0,'logo','logo',9,'image/png',812,'homepage02/general/logo.png','[]','2025-06-10 10:39:18','2025-06-10 10:39:18',NULL,'public'),(94,0,'footer-bg','footer-bg',10,'image/png',175152,'homepage02/backgrounds/footer-bg.png','[]','2025-06-10 10:39:18','2025-06-10 10:39:18',NULL,'public'),(95,0,'header-bg','header-bg',10,'image/png',224824,'homepage02/backgrounds/header-bg.png','[]','2025-06-10 10:39:18','2025-06-10 10:39:18',NULL,'public'),(96,0,'1','1',11,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:39:19','2025-06-10 10:39:19',NULL,'public'),(97,0,'10','10',11,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:39:19','2025-06-10 10:39:19',NULL,'public'),(98,0,'11','11',11,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:39:19','2025-06-10 10:39:19',NULL,'public'),(99,0,'12','12',11,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:39:20','2025-06-10 10:39:20',NULL,'public'),(100,0,'13','13',11,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:39:20','2025-06-10 10:39:20',NULL,'public'),(101,0,'14','14',11,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:39:20','2025-06-10 10:39:20',NULL,'public'),(102,0,'15','15',11,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:39:21','2025-06-10 10:39:21',NULL,'public'),(103,0,'16','16',11,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:39:21','2025-06-10 10:39:21',NULL,'public'),(104,0,'17','17',11,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:39:21','2025-06-10 10:39:21',NULL,'public'),(105,0,'18','18',11,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:39:22','2025-06-10 10:39:22',NULL,'public'),(106,0,'19','19',11,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:39:22','2025-06-10 10:39:22',NULL,'public'),(107,0,'2','2',11,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:39:22','2025-06-10 10:39:22',NULL,'public'),(108,0,'20','20',11,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:39:23','2025-06-10 10:39:23',NULL,'public'),(109,0,'3','3',11,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:39:23','2025-06-10 10:39:23',NULL,'public'),(110,0,'4','4',11,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:39:23','2025-06-10 10:39:23',NULL,'public'),(111,0,'5','5',11,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:39:24','2025-06-10 10:39:24',NULL,'public'),(112,0,'6','6',11,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:39:24','2025-06-10 10:39:24',NULL,'public'),(113,0,'7','7',11,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:39:24','2025-06-10 10:39:24',NULL,'public'),(114,0,'8','8',11,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:39:25','2025-06-10 10:39:25',NULL,'public'),(115,0,'9','9',11,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:39:25','2025-06-10 10:39:25',NULL,'public'),(116,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:39:26','2025-06-10 10:39:26',NULL,'public'),(117,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:39:26','2025-06-10 10:39:26',NULL,'public'),(118,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:39:26','2025-06-10 10:39:26',NULL,'public'),(119,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:39:26','2025-06-10 10:39:26',NULL,'public'),(120,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:39:27','2025-06-10 10:39:27',NULL,'public'),(121,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:39:27','2025-06-10 10:39:27',NULL,'public'),(122,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:39:27','2025-06-10 10:39:27',NULL,'public'),(123,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:39:27','2025-06-10 10:39:27',NULL,'public'),(124,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:39:27','2025-06-10 10:39:27',NULL,'public'),(125,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:39:27','2025-06-10 10:39:27',NULL,'public'),(126,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:39:28','2025-06-10 10:39:28',NULL,'public'),(127,0,'1','1',12,'image/png',3446,'homepage02/speakers/1.png','[]','2025-06-10 10:39:28','2025-06-10 10:39:28',NULL,'public'),(128,0,'2','2',12,'image/png',3446,'homepage02/speakers/2.png','[]','2025-06-10 10:39:28','2025-06-10 10:39:28',NULL,'public'),(129,0,'3','3',12,'image/png',3446,'homepage02/speakers/3.png','[]','2025-06-10 10:39:28','2025-06-10 10:39:28',NULL,'public'),(130,0,'4','4',12,'image/png',3446,'homepage02/speakers/4.png','[]','2025-06-10 10:39:28','2025-06-10 10:39:28',NULL,'public'),(131,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:39:28','2025-06-10 10:39:28',NULL,'public'),(132,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:39:29','2025-06-10 10:39:29',NULL,'public'),(133,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:39:29','2025-06-10 10:39:29',NULL,'public'),(134,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:39:29','2025-06-10 10:39:29',NULL,'public'),(135,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:39:29','2025-06-10 10:39:29',NULL,'public'),(136,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:39:29','2025-06-10 10:39:29',NULL,'public'),(137,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:39:29','2025-06-10 10:39:29',NULL,'public'),(138,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:39:30','2025-06-10 10:39:30',NULL,'public'),(139,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:39:30','2025-06-10 10:39:30',NULL,'public'),(140,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:39:30','2025-06-10 10:39:30',NULL,'public'),(141,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:39:30','2025-06-10 10:39:30',NULL,'public'),(142,0,'0','0',14,'image/webp',33268,'main/events/0-1749551976.webp','[]','2025-06-10 10:39:36','2025-06-10 10:39:36',NULL,'public'),(143,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:39:37','2025-06-10 10:39:37',NULL,'public'),(144,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:39:37','2025-06-10 10:39:37',NULL,'public'),(145,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:39:37','2025-06-10 10:39:37',NULL,'public'),(146,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:39:38','2025-06-10 10:39:38',NULL,'public'),(147,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:39:38','2025-06-10 10:39:38',NULL,'public'),(148,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:39:38','2025-06-10 10:39:38',NULL,'public'),(149,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:39:38','2025-06-10 10:39:38',NULL,'public'),(150,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:39:39','2025-06-10 10:39:39',NULL,'public'),(151,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:39:39','2025-06-10 10:39:39',NULL,'public'),(152,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:39:39','2025-06-10 10:39:39',NULL,'public'),(153,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:39:40','2025-06-10 10:39:40',NULL,'public'),(154,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:39:40','2025-06-10 10:39:40',NULL,'public'),(155,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:39:40','2025-06-10 10:39:40',NULL,'public'),(156,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:39:41','2025-06-10 10:39:41',NULL,'public'),(157,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:39:41','2025-06-10 10:39:41',NULL,'public'),(158,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:39:41','2025-06-10 10:39:41',NULL,'public'),(159,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:39:42','2025-06-10 10:39:42',NULL,'public'),(160,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:39:42','2025-06-10 10:39:42',NULL,'public'),(161,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:39:42','2025-06-10 10:39:42',NULL,'public'),(162,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:39:43','2025-06-10 10:39:43',NULL,'public'),(163,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:39:54','2025-06-10 10:39:54',NULL,'public'),(164,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:39:55','2025-06-10 10:39:55',NULL,'public'),(165,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:39:55','2025-06-10 10:39:55',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:38:52','2025-06-10 10:38:52',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:38:52','2025-06-10 10:38:52',NULL),(3,0,'news',NULL,'news',1,'2025-06-10 10:38:54','2025-06-10 10:38:54',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:39:01','2025-06-10 10:39:01',NULL),(5,0,'brands',NULL,'brands',1,'2025-06-10 10:39:03','2025-06-10 10:39:03',NULL),(6,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:39:04','2025-06-10 10:39:04',NULL),(7,0,'icons',NULL,'icons',1,'2025-06-10 10:39:08','2025-06-10 10:39:08',NULL),(8,0,'homepage02',NULL,'homepage02',0,'2025-06-10 10:39:17','2025-06-10 10:39:17',NULL),(9,0,'general',NULL,'general',8,'2025-06-10 10:39:17','2025-06-10 10:39:17',NULL),(10,0,'backgrounds',NULL,'backgrounds',8,'2025-06-10 10:39:18','2025-06-10 10:39:18',NULL),(11,0,'blogs',NULL,'blogs',1,'2025-06-10 10:39:19','2025-06-10 10:39:19',NULL),(12,0,'speakers',NULL,'speakers',8,'2025-06-10 10:39:28','2025-06-10 10:39:28',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:39:28','2025-06-10 10:39:28',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:39:36','2025-06-10 10:39:36',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:39:54','2025-06-10 10:39:54',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:39:54','2025-06-10 10:39:54');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:39:54','2025-06-10 10:39:54');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:39:54','2025-06-10 10:39:54');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:39:02','2025-06-10 10:39:02'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:39:02','2025-06-10 10:39:02'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:39:02','2025-06-10 10:39:02'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:39:02','2025-06-10 10:39:02'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:39:17','2025-06-10 10:39:17'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:39:17','2025-06-10 10:39:17'),(7,'title','[\"Backend Developer\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:30','2025-06-10 10:39:30'),(8,'description','[\"I eat one of the jurors were writing down \'stupid things!\' on their throne when they passed too close, and waving their forepaws to mark the time, while the rest were quite silent, and looked.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:30','2025-06-10 10:39:30'),(9,'address','[\"10442 Schuster Via Suite 435\\nLoraineton, IN 70563-2773\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:30','2025-06-10 10:39:30'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:30','2025-06-10 10:39:30'),(11,'title','[\"DevOps Engineer\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(12,'description','[\"White Rabbit cried out, \'Silence in the wood, \'is to grow larger again, and that\'s all you know that Cheshire cats always grinned; in fact, I didn\'t know that you\'re mad?\' \'To begin with,\' the Mock.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(13,'address','[\"7271 Torphy Oval\\nAbrahamville, MS 66911\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(15,'title','[\"Quality Assurance\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(16,'description','[\"Alice. \'That\'s the first position in which you usually see Shakespeare, in the after-time, be herself a grown woman; and how she was out of its mouth, and its great eyes half shut. This seemed to be.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(17,'address','[\"66432 Torey Prairie Suite 562\\nMetzhaven, VA 35704-8219\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(19,'title','[\"Product Manager\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(20,'description','[\"And how odd the directions will look! ALICE\'S RIGHT FOOT, ESQ. HEARTHRUG, NEAR THE FENDER, (WITH ALICE\'S LOVE). Oh dear, what nonsense I\'m talking!\' Just then she walked off, leaving Alice alone.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(21,'address','[\"44873 Will Rapids Apt. 888\\nWest Verdieberg, MO 14246-8513\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(23,'title','[\"Frontend Developer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(24,'description','[\"Queen. \'Sentence first--verdict afterwards.\' \'Stuff and nonsense!\' said Alice desperately: \'he\'s perfectly idiotic!\' And she kept fanning herself all the time she found a little of the song. \'What.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(25,'address','[\"1673 Schmeler Bridge Suite 768\\nSouth Tessburgh, NM 62271\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(27,'title','[\"Project Manager\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(28,'description','[\"How puzzling all these strange Adventures of hers would, in the pool, \'and she sits purring so nicely by the Hatter, \'when the Queen in a VERY turn-up nose, much more like a sky-rocket!\' \'So you.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(29,'address','[\"30017 Veum Ports\\nEast Madisenberg, RI 43439\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:31','2025-06-10 10:39:31'),(31,'title','[\"Product Manager\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(32,'description','[\"Queen was to eat her up in a natural way again. \'I should like to hear her try and say \\\"How doth the little creature down, and the others took the opportunity of taking it away. She did it at all.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(33,'address','[\"67903 Walter Ville Apt. 825\\nNorth Vivienne, OK 39419\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(35,'title','[\"Project Manager\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(36,'description','[\"AND WASHING--extra.\\\"\' \'You couldn\'t have done that?\' she thought. \'But everything\'s curious today. I think you\'d take a fancy to cats if you wouldn\'t mind,\' said Alice: \'three inches is such a nice.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(37,'address','[\"178 Gwen Mews Suite 426\\nSchummchester, LA 08715-7107\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(39,'title','[\"UX\\/UI Designer\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(40,'description','[\"I do it again and again.\' \'You are old, Father William,\' the young Crab, a little anxiously. \'Yes,\' said Alice, \'because I\'m not looking for them, and it\'ll sit up and saying, \'Thank you, it\'s a.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(41,'address','[\"5840 Jenkins Lock\\nAdammouth, AZ 83900-9247\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(43,'title','[\"Fullstack Developer\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(44,'description','[\"Mary Ann, what ARE you doing out here? Run home this moment, I tell you!\' said Alice. \'Come, let\'s hear some of YOUR adventures.\' \'I could tell you my history, and you\'ll understand why it is to.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(45,'address','[\"85123 Ebert Island Apt. 852\\nWest Hunterbury, LA 26313\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(47,'title','[\"Frontend Developer\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(48,'description','[\"I\'m somebody else\\\"--but, oh dear!\' cried Alice (she was obliged to write out a box of comfits, (luckily the salt water had not got into it), and handed back to finish his story. CHAPTER IV. The.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(49,'address','[\"8109 Chloe Land\\nSouth Constantin, WY 12940\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(51,'title','[\"Fullstack Developer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(52,'description','[\"I\'m perfectly sure I can\'t put it into one of the guinea-pigs cheered, and was just in time to see if there are, nobody attends to them--and you\'ve no idea how to get us dry would be as well as she.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:32','2025-06-10 10:39:32'),(53,'address','[\"39236 Shirley Mission\\nPort Wellingtonhaven, HI 16715-3218\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(55,'title','[\"Frontend Developer\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(56,'description','[\"First, because I\'m on the bank--the birds with draggled feathers, the animals with their heads!\' and the sounds will take care of the same as the White Rabbit read:-- \'They told me he was gone, and.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(57,'address','[\"47113 Keebler Square\\nLake Kylieton, MO 06961-1815\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(59,'title','[\"UX\\/UI Designer\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(60,'description','[\"Alice; \'but a grin without a grin,\' thought Alice; \'but a grin without a great deal to come before that!\' \'Call the next verse,\' the Gryphon as if it began ordering people about like mad things all.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(61,'address','[\"68985 Ondricka Run Suite 365\\nLake Kali, IA 03623\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(63,'title','[\"Frontend Developer\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(64,'description','[\"Now I growl when I\'m pleased, and wag my tail when it\'s pleased. Now I growl when I\'m pleased, and wag my tail when I\'m pleased, and wag my tail when I\'m angry. Therefore I\'m mad.\' \'I call it sad?\'.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(65,'address','[\"32216 Botsford Circles Suite 202\\nMinaview, AL 46730-4547\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(67,'title','[\"Frontend Developer\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(68,'description','[\"I sleep\\\" is the reason so many out-of-the-way things to happen, that it was only sobbing,\' she thought, and it said nothing. \'Perhaps it doesn\'t matter much,\' thought Alice, \'they\'re sure to kill it.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(69,'address','[\"315 Emerson Estates\\nNew Lennaborough, CT 63346-0577\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(71,'title','[\"Backend Developer\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(72,'description','[\"Dinah: I think you\'d better ask HER about it.\' \'She\'s in prison,\' the Queen of Hearts, she made her feel very uneasy: to be lost: away went Alice like the Queen?\' said the Rabbit whispered in reply.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(73,'address','[\"734 Roma Fall Apt. 103\\nCroninfort, AR 67478\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:33','2025-06-10 10:39:33'),(75,'title','[\"Fullstack Developer\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(76,'description','[\"Gryphon, \'she wants for to know when the Rabbit was no one listening, this time, sat down a large cauldron which seemed to be afraid of it. Presently the Rabbit hastily interrupted. \'There\'s a great.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(77,'address','[\"532 Runolfsdottir Vista\\nNew Ariane, CO 35574\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(79,'title','[\"Project Manager\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(80,'description','[\"Duchess, \'and that\'s why. Pig!\' She said the Mock Turtle; \'but it doesn\'t understand English,\' thought Alice; but she had to kneel down on their slates, and then a row of lodging houses, and behind.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(81,'address','[\"6791 Verona Roads\\nKochmouth, SD 74100\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(83,'title','[\"Quality Assurance\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(84,'description','[\"I\'ll eat it,\' said Five, \'and I\'ll tell you my history, and you\'ll understand why it is right?\' \'In my youth,\' said the Queen. An invitation from the shock of being such a new idea to Alice, \'Have.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(85,'address','[\"8028 Nico Lakes Suite 697\\nHarrismouth, CA 19480\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(87,'title','[\"Quality Assurance\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(88,'description','[\"Rabbit was no more to do it?\' \'In my youth,\' said the Queen, stamping on the end of half those long words, and, what\'s more, I don\'t know,\' he went on, taking first one side and up I goes like a.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(89,'address','[\"23136 Murphy Underpass Suite 298\\nWest Macey, WY 52289\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(91,'title','[\"Project Manager\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(92,'description','[\"Alice. The King laid his hand upon her face. \'Very,\' said Alice: \'she\'s so extremely--\' Just then she walked sadly down the hall. After a while she was ever to get in?\' asked Alice again, in a fight.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(93,'address','[\"515 Muller Ferry\\nNorth Lonnyfort, MA 09700\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:34','2025-06-10 10:39:34'),(95,'title','[\"UX\\/UI Designer\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(96,'description','[\"I want to see if there are, nobody attends to them--and you\'ve no idea what a wonderful dream it had made. \'He took me for his housemaid,\' she said to herself \'This is Bill,\' she gave one sharp.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(97,'address','[\"4926 Walter Wells\\nNorth Candidatown, MO 04970-7639\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(99,'title','[\"DevOps Engineer\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(100,'description','[\"And how odd the directions will look! ALICE\'S RIGHT FOOT, ESQ. HEARTHRUG, NEAR THE FENDER, (WITH ALICE\'S LOVE). Oh dear, what nonsense I\'m talking!\' Just then she noticed a curious croquet-ground in.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(101,'address','[\"292 Hoeger Pines\\nThadshire, NY 50512-4153\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(103,'title','[\"System Administrator\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(104,'description','[\"I\'ll never go THERE again!\' said Alice angrily. \'It wasn\'t very civil of you to learn?\' \'Well, there was no label this time the Queen to-day?\' \'I should think you could manage it?) \'And what are.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(105,'address','[\"2660 Monahan Station Apt. 776\\nAugustatown, WY 77953-4331\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(107,'title','[\"Fullstack Developer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(108,'description','[\"Cheshire Cat, she was quite impossible to say but \'It belongs to the other, looking uneasily at the top of her ever getting out of its mouth open, gazing up into the Dormouse\'s place, and Alice.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(109,'address','[\"941 Carolyn Lights Suite 481\\nWest Maribelchester, LA 48102\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(111,'title','[\"Project Manager\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(112,'description','[\"THIS size: why, I should like to hear his history. I must be collected at once crowded round it, panting, and asking, \'But who has won?\' This question the Dodo could not swim. He sent them word I.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(113,'address','[\"3095 Lynch Flats Suite 796\\nEast Aniyahville, GA 68090\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(115,'title','[\"Project Manager\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(116,'description','[\"March Hare was said to the cur, \\\"Such a trial, dear Sir, With no jury or judge, would be only rustling in the sand with wooden spades, then a voice outside, and stopped to listen. The Fish-Footman.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(117,'address','[\"2525 Pietro Gardens\\nWhitechester, IL 85153\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:35','2025-06-10 10:39:35'),(119,'title','[\"Quality Assurance\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(120,'description','[\"How queer everything is queer to-day.\' Just then her head on her toes when they arrived, with a kind of serpent, that\'s all I can guess that,\' she added in a hurry: a large cat which was lit up by a.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(121,'address','[\"1128 Stevie Ports Apt. 421\\nTommieview, WA 89064\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(123,'title','[\"Backend Developer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(124,'description','[\"I grow at a king,\' said Alice. \'You must be,\' said the March Hare. \'I didn\'t write it, and fortunately was just saying to her daughter \'Ah, my dear! Let this be a LITTLE larger, sir, if you please!.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(125,'address','[\"67958 Shemar Place Suite 812\\nNorth Orie, MT 37709-9099\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(127,'title','[\"Fullstack Developer\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(128,'description','[\"I!\' he replied. \'We quarrelled last March--just before HE went mad, you know--\' (pointing with his nose, you know?\' \'It\'s the oldest rule in the pictures of him), while the Mouse only growled in.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(129,'address','[\"86518 Nitzsche Glen\\nStarkview, MT 98513\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:39:36','2025-06-10 10:39:36'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(134,'event_id','[6]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(138,'event_id','[6]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55'),(142,'event_id','[9]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:39:55','2025-06-10 10:39:55');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[simple-slider key=&quot;home-slider&quot; background_image=&quot;homepage02/backgrounds/header-bg.png&quot;][/simple-slider][about-us-information style=&quot;2&quot; subtitle=&quot;About our business conferences&quot; title=&quot;Growth Through WorldClass And Conferences&quot; description=&quot;At Business, we bring together brightest minds, leaders, and trailblazers from across industries to explore latest trends, technologies, and strategies shaping the future.&quot; quantity=&quot;2&quot; title_1=&quot;Speakers&quot; figure_1=&quot;40&quot; icon_1=&quot;ti ti-microphone-2&quot; title_2=&quot;Sponsors&quot; figure_2=&quot;19&quot; icon_2=&quot;ti ti-briefcase&quot; image=&quot;homepage02/general/about-us-information-1.png&quot; image_1=&quot;homepage02/general/about-us-information-2.png&quot; image_2=&quot;homepage02/general/about-us-information-3.png&quot; button_label=&quot;Become an Attendee&quot; button_url=&quot;/contact-us&quot; background_color=&quot;#032530&quot; text_color=&quot;#ffffff&quot;][/about-us-information][brands style=&quot;1&quot; subtitle=&quot;general sponsors&quot; title=&quot;Our Official Sponsors&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot; text_color=&quot;#ffffff&quot; background_image=&quot;homepage02/backgrounds/header-bg.png&quot;][/brands][speakers title=&quot;Our Event Speakers&quot; subtitle=&quot;Our 10+ event speakers&quot; limit=&quot;4&quot; background_color=&quot;#032530&quot; text_color=&quot;#ffffff&quot; style=&quot;2&quot;][/speakers][events-schedule title=&quot;Our Events Schedule Plan&quot; subtitle=&quot;Event Schedule&quot; number_days=&quot;3&quot; style=&quot;2&quot; text_color=&quot;#ffffff&quot; background_image=&quot;homepage02/backgrounds/header-bg.png&quot;][/events-schedule][events style=&quot;2&quot; title=&quot;Recent Memories 2024&quot; subtitle=&quot;last year memory&quot; limit=&quot;5&quot; redirect_url=&quot;/events&quot; background_image=&quot;homepage02/backgrounds/header-bg.png&quot;][/events][pricing title=&quot;Event Pass &amp; Tickets&quot; subtitle=&quot;Ticket Pricing&quot; quantity=&quot;3&quot; name_1=&quot;Basic Packages&quot; price_1=&quot;$29&quot; unit_1=&quot;One Person&quot; features_1=&quot;+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing&quot; button_url_1=&quot;/contact-us&quot; button_label_1=&quot;Buy A Ticket&quot; name_2=&quot;Standard Packages&quot; price_2=&quot;$49&quot; unit_2=&quot;One Person&quot; is_featured_2=&quot;yes&quot; features_2=&quot;+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation&quot; button_url_2=&quot;/contact-us&quot; button_label_2=&quot;Buy A Ticket&quot; name_3=&quot;Premium Packages&quot; price_3=&quot;$69&quot; unit_3=&quot;One Person&quot; features_3=&quot;+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations&quot; button_url_3=&quot;/contact-us&quot; button_label_3=&quot;Buy A Ticket&quot; style=&quot;2&quot; text_color=&quot;#ffffff&quot; background_image=&quot;homepage02/backgrounds/header-bg.png&quot;][/pricing][contact-information style=&quot;2&quot; address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot; background_color=&quot;#032530&quot;][/contact-information]',1,NULL,'homepage',NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:19'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:39:17','2025-06-10 10:39:17');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'RCBUMSUNVGIA','bank_transfer',NULL,375.72,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43',NULL,NULL),(2,'1',0,'XTF4ADYWSBJL','bank_transfer',NULL,375.72,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43',NULL,NULL),(3,'1',0,'G8S02NNBA6LH','bank_transfer',NULL,281.79,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43',NULL,NULL),(4,'1',0,'FNJAEJBDTUNG','bank_transfer',NULL,469.65,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43',NULL,NULL),(5,'1',0,'XPWANPWSGZOU','bank_transfer',NULL,375.72,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:43','2025-06-10 10:39:43',NULL,NULL),(6,'1',0,'POJZU0PN5DTL','bank_transfer',NULL,93.93,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(7,'1',0,'KBKBHXLH4CKI','bank_transfer',NULL,469.65,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(8,'1',0,'8TTJVOYCWGG2','bank_transfer',NULL,281.79,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(9,'1',0,'Q1CQNCAXMRTW','bank_transfer',NULL,469.65,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(10,'1',0,'V0XV6RBPMZCQ','bank_transfer',NULL,281.79,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(11,'1',0,'IC029UTFDWRE','bank_transfer',NULL,92.63,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(12,'1',0,'RO91X9BGQKGX','bank_transfer',NULL,463.15,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(13,'1',0,'WJQXXM3CVJI4','bank_transfer',NULL,185.26,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(14,'1',0,'3AZOYWK9PKAZ','bank_transfer',NULL,463.15,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(15,'1',0,'VBH1PLXKX5YR','bank_transfer',NULL,277.89,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(16,'1',0,'GBYQ0CQPVPOV','bank_transfer',NULL,92.63,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(17,'1',0,'VOBP4WDUNVE4','bank_transfer',NULL,463.15,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:44','2025-06-10 10:39:44',NULL,NULL),(18,'1',0,'FPFSUNNWIUUD','bank_transfer',NULL,463.15,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(19,'1',0,'G42LGGZKYAQI','bank_transfer',NULL,92.63,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(20,'1',0,'FM9GDHL6M8FH','bank_transfer',NULL,92.63,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(21,'1',0,'50RBJOXKRJM3','bank_transfer',NULL,64.38,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(22,'1',0,'DSETCI9ZXFOZ','bank_transfer',NULL,128.76,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(23,'1',0,'6S1YCBTEMGBT','bank_transfer',NULL,128.76,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(24,'1',0,'QDWFCITZRZCG','bank_transfer',NULL,64.38,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(25,'1',0,'AQOYJQXQNUTP','bank_transfer',NULL,32.19,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(26,'1',0,'K9AZWTOZOMOL','bank_transfer',NULL,128.76,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(27,'1',0,'NENBGHWSY1UJ','bank_transfer',NULL,160.95,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(28,'1',0,'OV6EJ8COQNRS','bank_transfer',NULL,96.57,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:45','2025-06-10 10:39:45',NULL,NULL),(29,'1',0,'3DCWWS2HLNYS','bank_transfer',NULL,96.57,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(30,'1',0,'XAGLUTDYDJ1C','bank_transfer',NULL,32.19,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(31,'1',0,'YTPWR2LZLBW1','bank_transfer',NULL,108.24,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(32,'1',0,'FGOYZSWP0HWZ','bank_transfer',NULL,216.48,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(33,'1',0,'AZXAR5HWDKJF','bank_transfer',NULL,108.24,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(34,'1',0,'5FAGIYB1GSPC','bank_transfer',NULL,54.12,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(35,'1',0,'NA3CND0MIAQI','bank_transfer',NULL,216.48,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(36,'1',0,'CXR6FKKKHXKW','bank_transfer',NULL,270.60,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(37,'1',0,'J7OKT3TBVVYP','bank_transfer',NULL,270.60,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(38,'1',0,'3UCDFLBNVDWA','bank_transfer',NULL,216.48,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(39,'1',0,'WXEV9H7PT5GU','bank_transfer',NULL,216.48,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(40,'1',0,'YJCI6KXG9RGX','bank_transfer',NULL,54.12,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:46','2025-06-10 10:39:46',NULL,NULL),(41,'1',0,'LLWA6LDRJBQD','bank_transfer',NULL,65.45,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(42,'1',0,'CQDAKF5OESW9','bank_transfer',NULL,65.45,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(43,'1',0,'VFMWLFLOSXBF','bank_transfer',NULL,65.45,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(44,'1',0,'7JZXOTO4CPEI','bank_transfer',NULL,261.80,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(45,'1',0,'NEF4ATAIOUXE','bank_transfer',NULL,327.25,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(46,'1',0,'EZTHSKIQFYFD','bank_transfer',NULL,327.25,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(47,'1',0,'20QXTSXE0T5V','bank_transfer',NULL,327.25,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(48,'1',0,'6HOGPCEMWK2R','bank_transfer',NULL,65.45,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(49,'1',0,'CFLLCRUH82SD','bank_transfer',NULL,327.25,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL),(50,'1',0,'FMSEXQXPLBSI','bank_transfer',NULL,130.90,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:39:47','2025-06-10 10:39:47',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (5,1),(3,1),(1,2),(6,2),(4,3),(6,4),(4,4),(5,5),(2,5),(2,6),(1,6),(2,7),(6,8),(1,8),(2,9),(6,9),(1,10),(4,10),(6,11),(2,11),(5,12),(2,12),(6,13),(1,13),(5,14),(1,15),(2,15),(2,16),(4,17),(1,17),(2,18),(3,18),(2,19),(4,19),(4,20),(6,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (1,1),(5,1),(4,2),(7,2),(7,3),(2,3),(1,3),(2,4),(5,4),(1,4),(2,5),(6,5),(4,5),(2,6),(3,6),(1,7),(7,7),(7,8),(3,8),(5,8),(7,9),(3,9),(6,10),(4,10),(1,10),(3,11),(1,11),(2,12),(3,12),(1,12),(4,13),(6,13),(3,13),(1,14),(7,14),(1,15),(6,15),(5,15),(5,16),(3,16),(2,16),(7,17),(4,17),(6,17),(7,18),(4,18),(2,19),(6,19),(3,19),(2,20),(4,20),(3,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',1616,NULL,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',1781,NULL,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',1557,NULL,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',222,NULL,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',495,NULL,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',2120,NULL,'2025-06-10 10:39:25','2025-06-10 10:39:25'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',1372,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',1208,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',291,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',1679,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',2383,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',2340,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',692,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',2124,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',575,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',657,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',2466,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',136,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',148,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/3.jpg\" image_2=\"main/blogs/1.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',1996,NULL,'2025-06-10 10:39:26','2025-06-10 10:39:26');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:39:01','2025-06-10 10:39:01');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:39:55'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:39:55'),(6,'language_hide_default','1',NULL,'2025-06-10 10:39:55'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:39:55'),(8,'language_display','all',NULL,'2025-06-10 10:39:55'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:39:55'),(10,'media_random_hash','c4b5df2e697cd88b986bc1d6247f2781',NULL,'2025-06-10 10:39:55'),(11,'theme','eventify-homepage02',NULL,'2025-06-10 10:39:55'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:39:55'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:39:55'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:39:55'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:39:55'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:39:55'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:39:55'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:39:55'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:39:55'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:39:55'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:39:55'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:39:55'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:39:55'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:39:55'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:39:55'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:39:55'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:39:55'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:39:55'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:39:55'),(30,'theme-eventify-homepage02-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:39:55'),(31,'theme-eventify-homepage02-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:39:55'),(32,'theme-eventify-homepage02-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:39:55'),(33,'theme-eventify-homepage02-favicon','main/general/favicon.png',NULL,'2025-06-10 10:39:55'),(34,'theme-eventify-homepage02-logo','homepage02/general/logo.png',NULL,'2025-06-10 10:39:55'),(35,'theme-eventify-homepage02-homepage_id','1',NULL,'2025-06-10 10:39:55'),(36,'theme-eventify-homepage02-blog_page_id','4',NULL,'2025-06-10 10:39:55'),(37,'theme-eventify-homepage02-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:39:55'),(38,'theme-eventify-homepage02-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:39:55'),(39,'theme-eventify-homepage02-blog_post_items_per_row','3',NULL,'2025-06-10 10:39:55'),(40,'theme-eventify-homepage02-number_of_related_posts','3',NULL,'2025-06-10 10:39:55'),(41,'theme-eventify-homepage02-breadcrumb_background_image','homepage02/backgrounds/header-bg.png',NULL,'2025-06-10 10:39:55'),(42,'theme-eventify-homepage02-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:39:55'),(43,'theme-eventify-homepage02-events_page_id','5',NULL,'2025-06-10 10:39:55'),(44,'theme-eventify-homepage02-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:39:55'),(45,'theme-eventify-homepage02-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:39:55'),(46,'theme-eventify-homepage02-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:39:55'),(47,'theme-eventify-homepage02-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:39:55'),(48,'theme-eventify-homepage02-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:39:55'),(49,'theme-eventify-homepage02-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:39:55'),(50,'theme-eventify-homepage02-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:39:55'),(51,'theme-eventify-homepage02-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:39:55'),(52,'theme-eventify-homepage02-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:39:55'),(53,'theme-eventify-homepage02-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:39:55'),(54,'theme-eventify-homepage02-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:39:55'),(55,'theme-eventify-homepage02-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:39:55'),(56,'theme-eventify-homepage02-logo_height','45',NULL,'2025-06-10 10:39:55'),(57,'theme-eventify-homepage02-is_header_transparent','1',NULL,'2025-06-10 10:39:55'),(58,'theme-eventify-homepage02-display_header_top','1',NULL,'2025-06-10 10:39:55'),(59,'theme-eventify-homepage02-header_top_text_color','#000000',NULL,'2025-06-10 10:39:55'),(60,'theme-eventify-homepage02-header_top_background_color','#FFFFFF',NULL,'2025-06-10 10:39:55'),(61,'theme-eventify-homepage02-header_background_color','#ffffff',NULL,'2025-06-10 10:39:55'),(62,'theme-eventify-homepage02-header_text_color','#000000',NULL,'2025-06-10 10:39:55'),(63,'theme-eventify-homepage02-footer_background_color','#032530',NULL,'2025-06-10 10:39:55'),(64,'theme-eventify-homepage02-footer_text_color','#ffffff',NULL,'2025-06-10 10:39:55'),(65,'theme-eventify-homepage02-footer_heading_color','#ffffff',NULL,'2025-06-10 10:39:55'),(66,'theme-eventify-homepage02-tp_primary_font','Figtree',NULL,'2025-06-10 10:39:55'),(67,'theme-eventify-homepage02-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:39:55'),(68,'theme-eventify-homepage02-primary_color','#C0F037',NULL,'2025-06-10 10:39:55'),(69,'theme-eventify-homepage02-secondary_color','#032530',NULL,'2025-06-10 10:39:55'),(70,'theme-eventify-homepage02-newsletter_popup_enable','1',NULL,'2025-06-10 10:39:55'),(71,'theme-eventify-homepage02-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:39:55'),(72,'theme-eventify-homepage02-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:39:55'),(73,'theme-eventify-homepage02-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:39:55'),(74,'theme-eventify-homepage02-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:39:55'),(75,'theme-eventify-homepage02-footer_background_image','homepage02/backgrounds/footer-bg.png',NULL,'2025-06-10 10:39:55'),(76,'theme-eventify-homepage02-breadcrumb_background_color','#032530',NULL,'2025-06-10 10:39:55'),(77,'announcement_max_width','1210',NULL,'2025-06-10 10:39:55'),(78,'announcement_text_color','#000000',NULL,'2025-06-10 10:39:55'),(79,'announcement_background_color','transparent',NULL,'2025-06-10 10:39:55'),(80,'announcement_text_alignment','start',NULL,'2025-06-10 10:39:55'),(81,'announcement_dismissible','0',NULL,'2025-06-10 10:39:55'),(82,'announcement_font_size','14',NULL,'2025-06-10 10:39:55'),(83,'announcement_font_size_unit','px',NULL,'2025-06-10 10:39:55'),(84,'announcement_placement','theme',NULL,'2025-06-10 10:39:55'),(85,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:39:55','2025-06-10 10:39:55'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:39:55','2025-06-10 10:39:55'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:39:55','2025-06-10 10:39:55');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:39:55','2025-06-10 10:39:55');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:00','2025-06-10 10:39:00'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:39:01','2025-06-10 10:39:01'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:39:17','2025-06-10 10:39:17'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:39:25','2025-06-10 10:39:25'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:39:25','2025-06-10 10:39:25'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:39:25','2025-06-10 10:39:25'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:39:25','2025-06-10 10:39:25'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:39:25','2025-06-10 10:39:25'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:39:25','2025-06-10 10:39:25'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:39:25','2025-06-10 10:39:25'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:25','2025-06-10 10:39:25'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:39:26','2025-06-10 10:39:26'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:31','2025-06-10 10:39:31'),(59,'melvin-deckow',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:31','2025-06-10 10:39:31'),(60,'prof-zander-connelly',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:31','2025-06-10 10:39:31'),(61,'lilian-pagac',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:32','2025-06-10 10:39:32'),(62,'blanca-fahey',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:32','2025-06-10 10:39:32'),(63,'lia-moore',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:32','2025-06-10 10:39:32'),(64,'misty-bogan',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:33','2025-06-10 10:39:33'),(65,'icie-walter',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:33','2025-06-10 10:39:33'),(66,'miss-leilani-beer',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:33','2025-06-10 10:39:33'),(67,'prof-gia-hickle',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:34','2025-06-10 10:39:34'),(68,'kayden-ullrich',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:34','2025-06-10 10:39:34'),(69,'frederick-dooley-v',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:34','2025-06-10 10:39:34'),(70,'riley-mcclure-phd',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:35','2025-06-10 10:39:35'),(71,'rafael-strosin',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:35','2025-06-10 10:39:35'),(72,'brenna-rippin',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:35','2025-06-10 10:39:35'),(73,'catherine-robel',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:36','2025-06-10 10:39:36'),(74,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(75,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(76,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(77,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(78,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(79,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(80,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(81,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(82,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(83,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:39:43','2025-06-10 10:39:43'),(84,'jessyca-casper',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(85,'mr-rocky-white-jr',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(86,'hank-legros',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(87,'mr-jarod-zulauf',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(88,'willy-berge-ii',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(89,'miss-agnes-hermann',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(90,'fermin-lindgren-jr',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(91,'mac-price',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(92,'prof-braulio-nienow',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(93,'brenda-krajcik',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(94,'heaven-shields',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(95,'dr-wilfrid-schowalter-dvm',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(96,'prof-berry-bartoletti',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:55','2025-06-10 10:39:55'),(97,'alan-mohr',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(98,'rhea-prosacco',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(99,'mr-davion-jaskolski',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(100,'craig-lockman-md',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(101,'maybelle-sanford',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(102,'rosalinda-funk',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(103,'rusty-mante',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(104,'grady-padberg',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(105,'kurtis-schneider',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(106,'adeline-king',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(107,'ara-prohaska',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(108,'ariel-breitenberg',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(109,'diana-quigley',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(110,'dolores-dare-i',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(111,'blanca-dickinson-i',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(112,'brant-langworth',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(113,'percival-mcglynn-v',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(114,'miss-loma-bartell-iv',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(115,'bethany-okon',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(116,'mrs-herminia-roob-sr',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(117,'prof-newton-kilback-jr',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(118,'valentin-boyer',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(119,'dr-keanu-kihn-iii',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(120,'ms-lauryn-nienow-sr',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(121,'morton-abbott',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(122,'karina-abbott',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(123,'magali-rice',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(124,'mr-edmond-becker-i',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(125,'prof-jarrod-koepp',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(126,'neva-welch',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(127,'dr-celestine-feest-sr',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(128,'catherine-kertzmann',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(129,'mrs-letitia-douglas-iv',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(130,'dr-danika-kshlerin-sr',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(131,'miss-baby-baumbach-iv',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(132,'mr-anthony-welch',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(133,'prof-ethelyn-beatty-sr',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(134,'prof-samson-mueller-iii',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(135,'mrs-gia-zieme-phd',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(136,'floyd-collins',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(137,'adela-orn',70,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(138,'weldon-kuhic',71,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(139,'kaylin-homenick',72,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(140,'lina-sawayn-jr',73,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(141,'lisette-conn',74,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(142,'lucious-sanford-v',75,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56'),(143,'mr-johan-dibbert-md',76,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:39:56','2025-06-10 10:39:56');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:39:36','2025-06-10 10:39:36');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:39:25','2025-06-10 10:39:25'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:39:25','2025-06-10 10:39:25'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:39:25','2025-06-10 10:39:25'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:39:25','2025-06-10 10:39:25'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:39:25','2025-06-10 10:39:25'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:39:25','2025-06-10 10:39:25'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:39:25','2025-06-10 10:39:25');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:39:02','2025-06-10 10:39:02'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:39:02','2025-06-10 10:39:02'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:39:02','2025-06-10 10:39:02'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:39:02','2025-06-10 10:39:02');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'jhills@gerlach.com',NULL,'$2y$12$rOdEr94zxURxgFgcodYSk.9lLQGIN/PORwg6XkvXeKaCBXnhvLwyK',NULL,'2025-06-10 10:39:01','2025-06-10 10:39:01','Kristoffer','Pacocha','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage02',1,'[]','2025-06-10 10:39:19','2025-06-10 10:39:19'),(2,'SocialLinksWidget','header_sidebar','eventify-homepage02',2,'[]','2025-06-10 10:39:19','2025-06-10 10:39:19'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage02',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo.png\"}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage02',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage02',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage02',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(7,'EventListWidget','event_list_sidebar','eventify-homepage02',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage02',1,'[]','2025-06-10 10:39:19','2025-06-10 10:39:19'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage02',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage02',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage02',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage02',1,'{\"background_color\":\"#C0F037\",\"button_label\":\"Buy Ticket\"}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage02',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:39:19','2025-06-10 10:39:19'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage02',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:39:19','2025-06-10 10:39:19');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:39:56
