-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'qI9ukEYx45NINlA2aHgk15Kh1FPisZlm',1,'2025-06-10 10:42:16','2025-06-10 10:42:16','2025-06-10 10:42:16');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:43:05',NULL,1,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:43:05',NULL,1,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:43:05',NULL,1,'2025-06-10 10:43:05','2025-06-10 10:43:05');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Explicabo voluptatem commodi non quo placeat dolor animi. Ut reiciendis quis eveniet accusantium. Cum animi qui et quos cum amet magnam aspernatur.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(2,'Leadership &amp; Strategy',0,'Beatae quos itaque quo sint illo fuga. Eos voluptates similique eos quia dolorum. Beatae corrupti quis perspiciatis tenetur laborum ea. Tempora enim voluptatem ut velit sed consequatur.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(3,'Networking &amp; Collaboration',0,'Cumque reiciendis sit tempore et voluptatem. Sequi voluptas sit soluta. Dolor odit quam quia qui.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(4,'Entrepreneurship Startups',0,'Et commodi suscipit vel cumque. Dignissimos recusandae fuga qui. Est non cum dolor. Est non nihil hic iste voluptatum exercitationem esse.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(5,'Marketing &amp; Branding',0,'Ad optio quia quia ea eius tenetur. Accusamus qui saepe veniam molestiae. Et et quidem facere sit et dolores aliquid. Eum et veniam quod ab omnis corrupti ut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(6,'Event Highlights &amp; Recaps',0,'Mollitia mollitia eum porro cum saepe. Qui aliquam vitae ratione dicta et. Qui quo a sed aut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:42:39','2025-06-10 10:42:39');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Wiley Gaylord','reilly.kory@example.net','1-727-480-3957','63651 Albina Trail Apt. 774\nAlbinfort, FL 10225','Neque quia consectetur et et nisi.','Id qui id ipsam. Alias similique distinctio sint assumenda nihil tempora debitis. Provident quia voluptatibus consequatur ut architecto. Voluptatum vitae totam exercitationem quos nam. Iure facilis ut deserunt sapiente. Tenetur modi quasi excepturi quis. Non sunt sunt culpa quis. Omnis adipisci quia voluptatem. Beatae nihil id ipsum laudantium. Esse sint possimus ut harum. Possimus hic unde quos eligendi. Quasi vel ab harum eum.',NULL,'read','2025-06-10 10:42:16','2025-06-10 10:42:16'),(2,'Gwendolyn Littel','zjacobson@example.net','551-737-7831','7533 Carter Branch Apt. 923\nLisandroside, OH 71904-2299','Autem rerum eos vel dolor deleniti architecto.','Unde commodi placeat qui dignissimos vel. Omnis et dolores repellat ut pariatur beatae. Facere autem aut qui vitae. Delectus omnis amet iusto ea. Nulla cupiditate ipsam sint sit laboriosam explicabo. Qui doloribus voluptate ducimus officiis. Debitis architecto expedita est voluptas ut. Illum nihil et dicta commodi ut expedita et est. Ipsa et aut eum commodi quia aut. Nihil reiciendis qui praesentium.',NULL,'read','2025-06-10 10:42:16','2025-06-10 10:42:16'),(3,'Maybell Douglas V','corrine78@example.net','1-727-661-7669','3123 Jada Burg\nShanechester, OR 55638-5376','Sequi ut error repudiandae est ut.','Alias id ut et qui numquam suscipit. Voluptatem dolor ipsa et ut ipsam quae quos. Quasi dolores veritatis doloribus vel perspiciatis. Maxime error in quae reiciendis iusto facilis dolores. Neque laudantium itaque temporibus soluta dicta accusamus. Dolor ex sit qui natus corrupti enim ut. Sit repellendus iure laborum consequuntur voluptate vel rerum quos.',NULL,'read','2025-06-10 10:42:16','2025-06-10 10:42:16'),(4,'Tre Hodkiewicz','niko78@example.com','704-537-1385','63744 Britney Lights\nEllaborough, KY 35486','Ut laboriosam occaecati in totam.','Numquam sint est saepe qui eligendi. Tempore earum dolor dolore quibusdam qui excepturi maiores maiores. Ut tempore ea iure enim sit odit tempore. Aut totam itaque quos. Enim ea dolorum dolores animi cumque laudantium. Enim unde eum omnis ut sed eligendi. Aut quaerat rerum sed porro et. Quia nesciunt rerum sint ea aliquam omnis tempore. Earum eveniet quaerat id enim. Ut placeat ipsam aspernatur aut qui velit officia. Labore est tempora delectus.',NULL,'unread','2025-06-10 10:42:16','2025-06-10 10:42:16'),(5,'Maximilian Gibson','farmstrong@example.net','534.550.0478','972 Sammie Station Suite 677\nSouth Paige, IN 26738-7101','Architecto eaque cum sunt ad at nihil.','Et doloremque et maiores impedit alias. Quibusdam velit soluta ullam cum. Perspiciatis velit aut possimus fugit. Et dolorem velit occaecati ut ut quia est. Iusto occaecati accusantium quo pariatur. Et non earum excepturi repudiandae est. Officia non molestiae consectetur ratione. In sit fuga et. Et omnis magnam iusto ut adipisci inventore. Voluptas quaerat architecto quis esse veritatis et voluptatibus. Quia sed fugiat ipsam excepturi culpa qui.',NULL,'read','2025-06-10 10:42:16','2025-06-10 10:42:16'),(6,'Haven Ernser PhD','sfisher@example.com','(360) 852-5093','6994 Greenfelder Divide\nRyanfort, NJ 65226-6135','Commodi et excepturi iste quis a.','Sit libero laborum nam totam consequatur qui nobis. Ut et rem et id doloribus animi est. Dolores sint pariatur quia cum molestiae quos illo. Ratione natus eveniet aliquam aut. Quisquam nisi facilis inventore quia sit. Temporibus laboriosam sit incidunt sunt blanditiis voluptate. Et facere aut sit voluptate harum. Eum exercitationem harum id rerum maxime. Illum odit quisquam error autem aut porro. Ducimus aut quod beatae optio laboriosam.',NULL,'read','2025-06-10 10:42:16','2025-06-10 10:42:16'),(7,'Holden Koch','nicole.halvorson@example.net','+1-775-465-4329','10708 Erik Track Suite 624\nZulaufshire, AZ 88172','Iste doloribus ut non.','Voluptatem eum iure dignissimos esse assumenda est. Libero iusto at adipisci voluptates. Blanditiis dicta molestiae quia quia aut. Beatae animi molestiae cupiditate voluptates et quasi. Molestias corporis exercitationem est deserunt consequatur iusto. Voluptatem voluptatem dignissimos explicabo velit suscipit. Saepe quisquam iste vel sit nostrum voluptas. Saepe in aut eos tempora et dolor quia.',NULL,'unread','2025-06-10 10:42:16','2025-06-10 10:42:16'),(8,'Margarette Hagenes II','jeremie.reilly@example.net','(682) 629-5250','394 Ruby Light\nPort Howard, AZ 18090-6859','Necessitatibus quas eius molestiae qui.','Fugiat iure est modi. Et ducimus earum esse facere ullam itaque modi. Vel voluptas animi accusantium exercitationem repudiandae. Quo ut sint tenetur quidem aut. Distinctio quia ut eveniet est nihil modi ratione. Laborum molestias nesciunt harum repellendus et beatae id. Corporis cum quis dolorem quis minima. Voluptatem magni iste perspiciatis voluptatum. Aliquam molestiae vel ullam. Repellat animi fugiat inventore id omnis.',NULL,'read','2025-06-10 10:42:16','2025-06-10 10:42:16'),(9,'Giovanny Hermann MD','stark.monique@example.com','1-219-865-9321','900 Janiya Extensions\nHicklechester, OK 66254-9668','Deleniti fugiat rerum blanditiis earum.','Fugit architecto deleniti quas similique facere. Voluptatem qui excepturi numquam perferendis molestiae et. Nobis qui quo dolor autem eum. Nulla veniam esse consequatur qui. Odio aliquam repellat aliquam facilis earum eum aut labore. Quam autem enim occaecati enim non tempora distinctio. Hic eveniet esse accusamus cupiditate ipsum pariatur ex est.',NULL,'unread','2025-06-10 10:42:16','2025-06-10 10:42:16'),(10,'Natalie Smitham','hegmann.gabriel@example.org','+19564911788','9202 Presley Landing Suite 302\nNorth Chad, CT 38879','Exercitationem ut libero molestiae amet eligendi.','Explicabo qui nesciunt sunt id temporibus aut fuga. Qui corrupti tempore velit minus eos. Non maxime deserunt ut suscipit molestias eum. Nihil eius ab tempore laborum aut cumque culpa officiis. Incidunt placeat optio porro ea maxime. Odio aliquam velit soluta quaerat et blanditiis. Et eos est aut.',NULL,'unread','2025-06-10 10:42:16','2025-06-10 10:42:16');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:42:50',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:42:50',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:42:50',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:42:50',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:42:50',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:42:50',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Marty Bergstrom','customer@archielite.com','$2y$12$oVm04EmSILFHsd9Qe0cF3.n8xOw88qArIOWX9z9ZIXPEgURn.esI6',NULL,'0344607852','2018-09-25','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:44','2025-06-10 10:42:44'),(2,'Michael Smith','deven.quigley@yahoo.com','$2y$12$lVgCsMOWQB8CvseLwMQywuhx3paQEN1ZIHLH3/ymgumcg70O/ABHO','main/speakers/10.png','0699925765','2011-11-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:45','2025-06-10 10:42:45'),(3,'Willie Gaylord','russel.edwardo@yahoo.com','$2y$12$S2Nlzf/fF.bNyTNisHO.ReAMVp0FtoengESeQ8Fce865M/Hfgl/L.',NULL,'0786380186','1996-02-15','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:45','2025-06-10 10:42:45'),(4,'Katelyn Lemke','plittle@gmail.com','$2y$12$8jD0QqjR.BB9Ryv21Bpf1O24iqh2k8fsaUiuKpGl7F9aSWYRIIwUK','main/speakers/8.png','0862082583','2014-10-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:45','2025-06-10 10:42:45'),(5,'Darwin Lemke','dell.brown@eichmann.biz','$2y$12$QRYSsz3oCitLUR2L8V1q1OmwHI.ypN78eYg0e2DAAWIJ/kJWj90Pa','main/speakers/7.png','0628462859','2022-09-09','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:45','2025-06-10 10:42:45'),(6,'Dr. Alvena Mohr','deckow.barbara@von.com','$2y$12$R/GAoLEX1HW1JMwhVDUR8.w0bBuIDwezy1a/pcxN5htMt6EBfpAM.','main/speakers/9.png','0852217075','2013-04-22','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:45','2025-06-10 10:42:45'),(7,'Irma Rippin II','electa73@kozey.com','$2y$12$GQAKq4t9wQctwhQ8alMKcePrWBI8kewI0eLrK2Kw4MA7dBKRwYG5W','main/speakers/1.png','0084280608','2025-03-10','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:45','2025-06-10 10:42:45'),(8,'Filomena Maggio','parker.lorenz@yahoo.com','$2y$12$Dtdfq8oFYmldNhpBJyGn/etQd1nDfWOSMVGjrozGxWxccO99JnEti',NULL,'0639887403','2024-03-12','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:46','2025-06-10 10:42:46'),(9,'Ms. Sibyl Torp MD','macie45@gmail.com','$2y$12$zqetfKXBYQxrJYdLNDmdHeIxxlQbE8TSWGiGp60msYP/1cyRIRxXi','main/speakers/3.png','0509455802','2018-03-15','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:46','2025-06-10 10:42:46'),(10,'Mitchell Pfeffer','jrenner@champlin.com','$2y$12$bmGCAm9fuRU0T./O8qsVA.TWNMR.9WlVHNDwPyY5639wAFY5iNfVO',NULL,'0706910608','2004-05-19','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:46','2025-06-10 10:42:46'),(11,'Lelah Crooks','ali.bogisich@rippin.com','$2y$12$WSeBdsj8FV7ggYYPTCD7IOCh/Crpa3jcz7x7GIiawCyeSupRD02qe','main/speakers/4.png','0503900282','2023-02-01','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:46','2025-06-10 10:42:46'),(12,'Gaston Leuschke','pollich.lola@hotmail.com','$2y$12$OBtyrbsECzhjG9oZj3lPOO4nIdCQzSa7sNHO8HkInae2ssZM6aVRW',NULL,'0208818090','2006-05-26','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:46','2025-06-10 10:42:46'),(13,'Johathan Rowe','adelbert.murazik@lang.com','$2y$12$rV4fXgbOa85WGepRwOGM0ODb1zm6nxdf.O8GJht5reI4EOUF6cU1u','main/speakers/6.png','0066716442','2001-02-10','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:46','2025-06-10 10:42:46'),(14,'Mr. Arnold Hammes','qherman@gmail.com','$2y$12$gn7cZqFcFrVkwaHrWKM8P.BJ8XucyKgp/4k58b7h2YUqBwVNgQ.Qi','main/speakers/4.png','0077154595','2006-09-10','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:47','2025-06-10 10:42:47'),(15,'Ms. Maximillia Cummings','jules56@yahoo.com','$2y$12$GxB7bDbvCsF29HLfFKWnyeSjj9JWBU07Mi35.5HDXy0sGOgIaWiue','main/speakers/4.png','0941541906','1995-08-09','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:47','2025-06-10 10:42:47'),(16,'Dariana Gislason','joe39@hotmail.com','$2y$12$fsDQHpHIDZKJBT57Nti1luVY.lmFmdTwUwt7aNd817cRWqNlfbag6','main/speakers/5.png','0364134270','2020-09-19','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:47','2025-06-10 10:42:47'),(17,'Ceasar Brakus','vcole@yahoo.com','$2y$12$0Z5yXN/g2WkZeHMnpiSJJuAKNDUKlIe9.LY9SmnVmili/Gg/4wE2a','main/speakers/4.png','0863148658','2001-11-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:47','2025-06-10 10:42:47'),(18,'Lydia Fadel','korey42@gmail.com','$2y$12$fSGtsEjv7MFDOV3.XItrceG59payJ4ZN8iug4oURKeXLEK9I6uHeK','main/speakers/10.png','0186881035','2017-10-15','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:47','2025-06-10 10:42:47'),(19,'Rachael Shields','maci87@bogan.com','$2y$12$MPy5CFJ1uk1IUf/ITgirreKR68kpU7QdVZVheoTY2abiXQwUPetgO','main/speakers/10.png','0291488994','2010-09-13','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:48','2025-06-10 10:42:48'),(20,'Grady Hegmann','pagac.sharon@smitham.org','$2y$12$.HTUpUOUVCLfmIfEDQOlWOzEJjDYACha6qvr.NhnKPOvjBzjLBxV6','main/speakers/2.png','0493419770','2015-06-18','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:48','2025-06-10 10:42:48'),(21,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','$2y$12$EXmG/jIfddokmsHMFp98Yub/W.rFoafcb5D/n/5nwOccRNFtyybz2',NULL,'0204792999','2007-09-26','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:48','2025-06-10 10:42:48'),(22,'Johnathan Gottlieb','ffadel@legros.biz','$2y$12$qbUfXcV3DM/FoDVThVEnEeb.7oqwsI/xcZtChCf10iQDzSD.wYNGO','main/speakers/5.png','0916986295','1997-12-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:48','2025-06-10 10:42:48'),(23,'Tyson Veum','domenic97@gmail.com','$2y$12$bTqquwYq4Kaq1VELRy5cu.D0TtQJreSln/kCzSHlwGmPoUp6/ft9S',NULL,'0939010651','2014-02-23','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:48','2025-06-10 10:42:48'),(24,'Sam Reilly','wisozk.sim@hotmail.com','$2y$12$5/vkbi/O5YoNxwqHjbB2O.AhbMmRBHprS5D0LpH7dZzXEdKyt0fHy','main/speakers/1.png','0391809839','2023-10-04','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:48','2025-06-10 10:42:48'),(25,'Eugene Macejkovic','heidenreich.brayan@gusikowski.info','$2y$12$w5rQCEeSvQrCAkzNX2QjAOg9jqUx5qedxXsWE88bTuubK5n9csKrm','main/speakers/6.png','0952416277','2004-03-05','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:49','2025-06-10 10:42:49'),(26,'Miss Raegan Von DVM','saltenwerth@gmail.com','$2y$12$N6TUCoEmtQuCiLlwUOQSGOLAY3zfBF4GYNmKyGL0hdZ6KiCK7fSlK','main/speakers/6.png','0141674269','2005-08-04','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:49','2025-06-10 10:42:49'),(27,'Daisy Pfannerstill','rasheed72@yahoo.com','$2y$12$6JoWGVlwSWh9KvPKECKQkeioHs1VwWBM/sWjk7L6eUuEQ28Quk8oC','main/speakers/2.png','0993192549','2009-01-03','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:49','2025-06-10 10:42:49'),(28,'Eddie Upton','emard.darrin@terry.org','$2y$12$iWV/gdOeMvpaZQIKbBFsHO6Fui5TCzE5HQQOJi.rHF6t.J4/7joI6','main/speakers/4.png','0624454907','2015-09-14','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:42:49','2025-06-10 10:42:49'),(29,'Dr. Theo Windler','imelda20@bednar.com','$2y$12$p2.VFPcmGU5MkXQ28SAYyub/0mRNepSccYGJim69R/aHDELk8qT.G',NULL,'0010055062','2012-05-21','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:49','2025-06-10 10:42:49'),(30,'Jazlyn Turner','hmueller@koepp.com','$2y$12$lxNZzmE4Ak/mvlAev03uqOxY/N7sDlmNKUz6KcV3pv9155z.mr4Gq',NULL,'0587725341','2001-06-26','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:50','2025-06-10 10:42:50'),(31,'Mr. Waldo Rosenbaum','karine25@gmail.com','$2y$12$kPSPQ0FvoI/ihD7DdxgPkOh8YvOgmZY3P6hPpUJMe5Gwg/6e.iOhq','main/speakers/6.png','0465104436','1999-11-07','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:42:50','2025-06-10 10:42:50'),(32,'Dr. Bart Kovacek','sage75@homenick.net','$2y$12$po9XtHTWT3FGh36F89K7xOk/Ky3ERFx0PVuMGa64R7jHAtMxt5i3O',NULL,'0784404606',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(33,'Prof. Unique McGlynn','mkuhic@yahoo.com','$2y$12$Q3oiNYH3SBq7npCksvIQHOvAa.zYPM0p8N3GQ9SOlzBiUBWf9kWQq',NULL,'0299003960',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(34,'Jess Haley MD','molly59@yahoo.com','$2y$12$b8atjB.NI0kM6EEgUD1HduAsnTXP8R6GJ9YG8B66S838KVGKvGbv.',NULL,'0179646529',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(35,'Bridie Rau','bradtke.nettie@lehner.com','$2y$12$hRusGLovdgq7piE60d51yuTTSmD6Zei3JFSs1dxDGYjlYQC.4Nvk6',NULL,'0002519937',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(36,'Brielle Walker','abshire.edison@gmail.com','$2y$12$KKLLMK.Japwygar59H2eRuIbSmS339VFzeel/Xu9Lto97GBC2D/zK',NULL,'0672392028',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:02','2025-06-10 10:43:02'),(37,'Mckenna Konopelski','xjaskolski@yahoo.com','$2y$12$IGF2gSE0hVgHF6kCnpqcPuzzF14/58Kiiw9yoCyN48OtGXO6LpAa6',NULL,'0483649103',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:02','2025-06-10 10:43:02'),(38,'Leland Lesch Sr.','green.monahan@hamill.com','$2y$12$XIO0JDB4QgTbYMHPLIWWR.icuAKeum9k7qSKJr0UQW9tyQTLuzJc6',NULL,'0112041588',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:02','2025-06-10 10:43:02'),(39,'Alek Wiegand','ohara.pearl@hotmail.com','$2y$12$nsoBqjnm5Sbjtb63L0JCCOuv.mQ2ToQ49TD5CT843WsyU/3uSotS6',NULL,'0652797333',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:02','2025-06-10 10:43:02'),(40,'Dr. Adolphus Heathcote','kuhn.mercedes@raynor.info','$2y$12$24iDDZ1CRHWohxojDYTH/OIm.gQwA98HHgEedY1Lpd6A91693FiGa',NULL,'0901132812',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:02','2025-06-10 10:43:02'),(41,'Miss Carli Will V','wkozey@hotmail.com','$2y$12$46bKUtPCXo8CaMyhh4dL.eZwOUt4GfJE.PBulcXqUc.uDz2aCSkU6',NULL,'0495575992',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:02','2025-06-10 10:43:02'),(42,'Dr. Royce Walsh','uraynor@yahoo.com','$2y$12$N.Jta5sbAF9QLDtuPZaqVuGlSAi7qBWTrp009mNZf0ioNelL6BhAq',NULL,'0142903793',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:03','2025-06-10 10:43:03'),(43,'Hudson Rice III','crooks.jayde@gmail.com','$2y$12$52T/Kd.4vDZg4meKZktPZeUAEMT1ueBbkbXzTaIy4h6y9E5m1lVHm',NULL,'0011793404',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:03','2025-06-10 10:43:03'),(44,'Amya Kuphal','ykunde@gmail.com','$2y$12$hkwZFkWecgt7i/t9mAmjEOoUGZ0VihC14IrURNDrUN5m36NUHaUJW',NULL,'0554794061',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:03','2025-06-10 10:43:03'),(45,'Camryn Harris','ychristiansen@hotmail.com','$2y$12$z2IYyei3LrAh1mGkosM/huuBck0dy93Ya3Gy88Jn9QI2ds7Gohb1y',NULL,'0853324901',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:03','2025-06-10 10:43:03'),(46,'Aric McDermott','faltenwerth@yahoo.com','$2y$12$O7k.TVOadFrGsCpXuID8We9K9IQBAUMlp1WUnU9F6DDjnUu8fhNoy',NULL,'0532227255',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:03','2025-06-10 10:43:03'),(47,'Joesph Bartoletti','snolan@hotmail.com','$2y$12$9Kj3QDJvHEoIq1YmBWn0w.9QtkGSO9bIRJkWdSSQObIxxAD2UmCUe',NULL,'0860187616',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:03','2025-06-10 10:43:03'),(48,'Emilia Schowalter','bdare@yahoo.com','$2y$12$B2bw4XYhtT2Itiyw4cq5g.0HugI5E6FDLw/FOmyfHHBayk2C.7qri',NULL,'0804270291',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:03','2025-06-10 10:43:03'),(49,'Vivien Zulauf V','zaufderhar@gmail.com','$2y$12$DLmtiwEw2w/312V3jewwg.GJ4y9q.xkIoJLke8LoKK5gi0XOlUQxq',NULL,'0493947879',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(50,'Bertrand Flatley I','toy.leanne@yahoo.com','$2y$12$knDgHzWr1nyWricaxoOHpORQWHbv/4Ke7j141/KEp9sYvusYHqTHi',NULL,'0069422020',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(51,'Dr. Burnice Heathcote I','ryan.omer@yahoo.com','$2y$12$KwqgmHq3gUsvaqhZPLbP2OWjl3MbOLFot2sc4mRlSiPNMiqkrLTey',NULL,'0489966376',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(52,'Mr. Geovanny Schumm','dreichert@hotmail.com','$2y$12$mhb/07HiNl0oOvfpTodRfuGfXDfkRzX8bSRjS.d.rPnUI.z3X5JQC',NULL,'0273985327',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(53,'Eliza Armstrong','sbartoletti@yahoo.com','$2y$12$czLKjxuYUWtvh4UwaOzXk.2PHawzxx6C.FuCxUQp3rb36rX0dHEV.',NULL,'0035410997',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:04','2025-06-10 10:43:04');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:42:09','2025-06-10 10:42:09'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:42:09','2025-06-10 10:42:09'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:42:09','2025-06-10 10:42:09');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (1,37,'0JXDZVRMWYIG',NULL),(4,51,'1AKY8BX4IK9H',NULL),(1,36,'1CRBM5CWE6UQ',NULL),(1,32,'3HDQ31TNORVM',NULL),(4,44,'5MWVUVYMYY2G',NULL),(1,39,'7P0B5QAQDUXW',NULL),(4,49,'8RZKJDNBTETT',NULL),(1,35,'AIYV9ZAOF6XM',NULL),(4,42,'DFFLFMSJGW57',NULL),(4,46,'EGOHF6RXWKX8',NULL),(1,34,'FJHEYXWKPLUW',NULL),(4,45,'H7SUSATS02CZ',NULL),(4,53,'JLNZ0VXTIIQ2',NULL),(4,52,'MGBCQBYXARSP',NULL),(1,33,'MQF7SDAGHHMS',NULL),(3,41,'RQI1RH8PJM3Z',NULL),(4,43,'THGMAR2FUEWI',NULL),(4,48,'TUMADYC5X05T',NULL),(3,40,'U0X54CDIUDE0',NULL),(4,50,'UL419ZIEI2NC',NULL),(1,38,'UWKDKIEGOKV0',NULL),(4,47,'V9YARMWTWGAT',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,4,'Quis quia quam consequuntur ut. Deserunt aut nihil et dignissimos officia.',NULL,0,NULL,NULL),(1,13,'Quasi maiores omnis ut exercitationem iure. Harum aliquid dolores placeat omnis rerum ad fugit et.',NULL,2,NULL,NULL),(2,13,'Facere omnis numquam magnam qui dolor. Et eligendi explicabo nulla veritatis.',NULL,0,NULL,NULL),(2,14,'Suscipit occaecati molestiae et aliquid sint molestias autem. Quam mollitia consequuntur amet quis.',NULL,1,NULL,NULL),(2,4,'Id dolor et dolor. Aperiam dolores suscipit et minus. Cum qui debitis corrupti delectus illum.',NULL,2,NULL,NULL),(3,17,'Sint voluptatibus dolore illo quis. Aut dolorem omnis enim tenetur et doloremque ullam corrupti.',NULL,0,NULL,NULL),(3,16,'Et consequatur perspiciatis delectus consequatur id modi. Cumque enim aut itaque voluptatem quia.',NULL,1,NULL,NULL),(3,14,'Recusandae quasi dolorem alias itaque odit. Aut voluptatem vel sit aliquam aut.',NULL,2,NULL,NULL),(4,16,'Commodi maiores quibusdam nemo qui qui. Culpa odit sint iure labore voluptatem dolor aut.',NULL,0,NULL,NULL),(4,5,'Sed quos suscipit vel. Corrupti ipsum nulla aut aut. Non sequi minus tenetur et.',NULL,1,NULL,NULL),(4,28,'Consequatur qui in pariatur ea ut odio. Et ipsam suscipit nam impedit enim quod.',NULL,2,NULL,NULL),(4,22,'Ducimus quisquam id eum eum sed esse magnam. Consequatur dolor officia laboriosam laborum et.',NULL,3,NULL,NULL),(5,13,'Nesciunt cumque sint veritatis autem. Aut inventore vero provident non adipisci libero accusamus.',NULL,0,NULL,NULL),(5,11,'Iusto et qui nemo in. Id beatae tempora tempora voluptatem.',NULL,1,NULL,NULL),(5,17,'Vitae quos nesciunt possimus at sint adipisci. Nihil adipisci blanditiis labore odit.',NULL,2,NULL,NULL),(5,14,'Rem sit animi ut. Dolorum ea sit rem aliquam id sit. Libero qui vel qui.',NULL,3,NULL,NULL),(6,22,'Hic qui voluptatem dicta quaerat autem sit. Aut odit quibusdam molestiae officia iste.',NULL,0,NULL,NULL),(6,17,'Eos dolorem voluptatem commodi. Suscipit deleniti soluta dignissimos ipsum laborum.',NULL,1,NULL,NULL),(6,28,'Exercitationem amet vero cum qui ut iste magnam. Cumque facilis qui provident quae a porro.',NULL,2,NULL,NULL),(7,16,'Illum enim illo ullam qui architecto illum. Voluptatibus doloremque dolorum quas.',NULL,0,NULL,NULL),(7,5,'Velit aut laboriosam molestiae sint aut. Ab ut iusto voluptatem id consequatur totam est.',NULL,1,NULL,NULL),(7,17,'Ut dolorem eos et et. Itaque aut et eos aperiam. Recusandae non rem quasi quam.',NULL,2,NULL,NULL),(8,22,'Accusamus eaque culpa error ullam. Unde aut autem rerum voluptate deserunt. Eos sit at aut et et.',NULL,0,NULL,NULL),(8,11,'Ea et quisquam velit omnis quis. Soluta unde est quo asperiores aut at et tempore.',NULL,1,NULL,NULL),(8,17,'Aperiam quis aut dicta similique. Voluptate voluptas error voluptatem quidem quo vel et.',NULL,2,NULL,NULL),(8,5,'Qui voluptas perspiciatis eos id. Laudantium a excepturi est et.',NULL,3,NULL,NULL),(9,13,'Sint autem veritatis nam id. Et odio eum cum est est veniam. Modi et non et.',NULL,0,NULL,NULL),(9,17,'Debitis illo vel hic iure quaerat dolorem. Et nihil ut dolorem fuga.',NULL,3,NULL,NULL),(10,4,'Dolorum dicta sit ipsam incidunt. Cumque rerum error qui quae eos animi. Sit a voluptates alias.',NULL,0,NULL,NULL),(10,13,'Quia rerum et consectetur et quod quod. Tenetur nesciunt deserunt odio esse quis.',NULL,1,NULL,NULL),(10,14,'Facere voluptas qui autem. Illo vero molestiae aliquam et.',NULL,2,NULL,NULL),(10,5,'Occaecati harum qui rerum repudiandae sit. Officia magnam numquam quia non nostrum earum.',NULL,3,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',31,'Dignissimos eum qui qui asperiores aliquam.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','b81c3af5-edbb-31ab-8be1-3d4d9f3e7b6c','main/events/1.webp',81.25,'9713 Buddy Crossroad Suite 708\nLake Glen, WA 91774',4,4,4,'64.826094','-70.698658',96,0,'2025-06-10 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:56','2025-06-10 10:42:56'),(2,'Mobile World Congress',9,'Vitae earum dolor maxime et dolor in eum.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','30a7916e-d405-39a7-986a-4dc10d4b8050','main/events/2.webp',7.39,'66761 Romaine Lakes\nNorth Nils, TX 17248',6,NULL,NULL,'68.632408','146.61362',55,0,'2025-06-10 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(3,'Google I/O',6,'Natus non fuga doloribus quia ipsam nemo dignissimos tenetur.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','355f322d-49ed-35f5-977c-7d673035629e','main/events/3.webp',97.90,'1805 Nico Islands Suite 681\nWest Benton, ME 86005',5,5,5,'-33.025662','122.95479',86,0,'2025-06-10 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(4,'Apple WWDC',20,'Corporis neque saepe et tempora.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','2bf47595-d552-3fdb-aef0-f167a6d8b00c','main/events/4.webp',21.08,'47225 McClure Creek\nLake Selmertown, MN 55278',3,NULL,NULL,'44.166133','-77.49901',73,0,'2025-06-10 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(5,'AWS re:Invent',26,'Repellendus voluptate veniam dolorum atque sequi asperiores dolor quam.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','f5187ba2-ca77-3940-9db6-77e337fc7472','main/events/5.webp',31.42,'704 Jaylan Ways Suite 923\nHermannberg, AK 45913-3067',5,5,5,'38.23593','55.731672',80,0,'2025-06-11 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(6,'Microsoft Build',25,'Est nobis reiciendis rerum quia quasi deserunt est.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','973fc0ad-8424-3b34-810b-9d0dec01a4e5','main/events/6.webp',99.37,'4481 Vivien Ports Suite 091\nBenjaminshire, IL 86692',3,NULL,NULL,'42.320968','125.691741',68,0,'2025-06-11 09:00:00','2025-06-30 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(7,'Facebook F8',19,'Impedit unde velit qui asperiores occaecati dolorem.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','82cb1fa0-3089-3c9f-b070-db23a2dc22c7','main/events/7.webp',83.87,'27174 Lenore Club\nNew Coltonton, ND 70217-6826',2,2,2,'-43.827197','177.298093',67,0,'2025-06-11 09:00:00','2025-06-22 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(8,'GitHub Universe',18,'Labore exercitationem reiciendis qui dolorem rem id.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','1ea8e795-ca27-3ce1-8919-852693f53cc3','main/events/8.webp',47.66,'718 Waylon Field\nNorth Candido, MS 48310-4420',5,5,5,'-44.610627','-20.141654',66,0,'2025-06-11 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(9,'Game Developers Conference',9,'Dolorem atque soluta quibusdam tenetur quia.','The largest conference in the gaming industry, focusing on game development and gaming technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','71c85ca5-08b2-3743-836e-b21107714932','main/events/9.webp',2.43,'4125 Davis Branch Suite 309\nNew Alvisshire, WA 45216',4,4,4,'39.529863','63.643514',66,0,'2025-06-12 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(10,'Web Summit',6,'Eos numquam vero ut voluptate.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','9f2a3a08-1008-3b03-bc8d-dc9df0696718','main/events/10.webp',89.85,'21651 Kiara Shores Suite 941\nNew Goldaside, ID 19807',4,4,4,'21.480862','58.191842',64,0,'2025-06-12 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:42:57','2025-06-10 10:42:57');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Joana Lemke - halie.hane@yahoo.com','halie.hane@yahoo.com','0799917570',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Roselyn Runolfsdottir - kirlin.flo@sauer.com','kirlin.flo@sauer.com','0925534825',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Jaqueline Schultz DVM - rhiannon.dietrich@hotmail.com','rhiannon.dietrich@hotmail.com','0605137936',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Audra Gaylord - tking@yahoo.com','tking@yahoo.com','0436261180',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(5,1,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Dr. Blake Reynolds V - jefferey01@gmail.com','jefferey01@gmail.com','0238395476',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(6,1,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Theron Runte - cabernathy@gmail.com','cabernathy@gmail.com','0518653825',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Landen Konopelski - torey24@gmail.com','torey24@gmail.com','0833237314',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(8,2,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Edyth Ritchie - austyn.berge@hotmail.com','austyn.berge@hotmail.com','0610549271',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(9,3,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Dr. Bart Kovacek - sage75@homenick.net','sage75@homenick.net','0784404606',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Prof. Unique McGlynn - mkuhic@yahoo.com','mkuhic@yahoo.com','0299003960',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Jess Haley MD - molly59@yahoo.com','molly59@yahoo.com','0179646529',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(12,4,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Ms. Mercedes Carroll PhD - fgraham@yahoo.com','fgraham@yahoo.com','0387526305',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Dr. Presley Frami - king.rosie@gmail.com','king.rosie@gmail.com','0967401697',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(14,4,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Mr. Abdiel Cartwright PhD - yvonne04@kilback.com','yvonne04@kilback.com','0582043585',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Miss Jaqueline Satterfield - considine.cooper@hotmail.com','considine.cooper@hotmail.com','0753400420',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Prof. Brielle Harris - ethel.ziemann@okuneva.info','ethel.ziemann@okuneva.info','0775681076',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(17,5,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Lelah Heller - conn.arturo@dare.info','conn.arturo@dare.info','0864349570',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(18,5,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Prof. Kathryne Lubowitz DVM - friedrich40@dietrich.com','friedrich40@dietrich.com','0856554596',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(19,5,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Miss Kelsie McGlynn - ogoyette@farrell.info','ogoyette@farrell.info','0127821397',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(20,5,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Laurie Corkery - rogelio.bauch@heller.biz','rogelio.bauch@heller.biz','0814923424',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(21,6,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Bridie Rau - bradtke.nettie@lehner.com','bradtke.nettie@lehner.com','0002519937',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(22,6,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Brielle Walker - abshire.edison@gmail.com','abshire.edison@gmail.com','0672392028',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(23,7,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Arlene Goldner - maci.jast@johnston.org','maci.jast@johnston.org','0561412371',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(24,7,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Anya Schoen - angie.cormier@yahoo.com','angie.cormier@yahoo.com','0073862295',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(25,7,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Rudolph Williamson III - torp.gregorio@hotmail.com','torp.gregorio@hotmail.com','0253082339',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(26,7,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Sienna Considine - bryon.russel@yahoo.com','bryon.russel@yahoo.com','0196894626',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(27,7,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Dr. Khalid Harris V - opollich@hotmail.com','opollich@hotmail.com','0217020728',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(28,8,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Mckenna Konopelski - xjaskolski@yahoo.com','xjaskolski@yahoo.com','0483649103',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(29,8,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Leland Lesch Sr. - green.monahan@hamill.com','green.monahan@hamill.com','0112041588',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(30,8,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Alek Wiegand - ohara.pearl@hotmail.com','ohara.pearl@hotmail.com','0652797333',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(31,9,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Arnold Hirthe - hahn.hilma@tremblay.com','hahn.hilma@tremblay.com','0233525195',1,81.25,81.25,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(32,9,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Lisette Jakubowski - hilbert38@abshire.net','hilbert38@abshire.net','0969827674',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(33,9,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Tevin Hand Sr. - sflatley@gulgowski.info','sflatley@gulgowski.info','0957496219',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(34,9,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Brandon Sawayn - sophia77@gmail.com','sophia77@gmail.com','0293001157',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(35,10,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Corene Bernier DDS - sarai.jacobson@hotmail.com','sarai.jacobson@hotmail.com','0047494989',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(36,10,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Ms. Shanon Beahan Sr. - kory94@jacobs.com','kory94@jacobs.com','0453843683',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(37,10,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Bette Klein II - murphy.elise@hotmail.com','murphy.elise@hotmail.com','0281798272',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(38,10,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Aliyah Dickens I - pfunk@weissnat.com','pfunk@weissnat.com','0530862731',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(39,10,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Isidro Anderson - xveum@yahoo.com','xveum@yahoo.com','0641561872',1,81.25,81.25,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(40,11,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'Mobile World Congress - Elwyn Balistreri II - ola.kohler@paucek.com','ola.kohler@paucek.com','0786295122',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(41,11,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'Mobile World Congress - Mrs. Raina Nicolas IV - amcclure@hahn.net','amcclure@hahn.net','0528073511',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(42,11,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'Mobile World Congress - Adolphus Mante - akuhlman@schiller.net','akuhlman@schiller.net','0610810178',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(43,11,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Hallie Simonis - cora57@gmail.com','cora57@gmail.com','0618924003',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(44,12,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Robyn O\'Reilly - reyna.reilly@marks.com','reyna.reilly@marks.com','0274365484',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(45,12,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Marge Barrows - qmoore@hotmail.com','qmoore@hotmail.com','0970697026',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(46,12,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Abigale Mills - dicki.ivory@grady.com','dicki.ivory@grady.com','0601963766',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(47,12,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Miss Jermaine Terry DDS - rod.huels@yahoo.com','rod.huels@yahoo.com','0352121495',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(48,12,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Prof. Amani Terry DVM - cole.shane@yahoo.com','cole.shane@yahoo.com','0501444219',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(49,13,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Ms. Alicia Schumm DDS - kbarton@schaden.net','kbarton@schaden.net','0630243142',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(50,13,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Polly McClure - richie.altenwerth@konopelski.net','richie.altenwerth@konopelski.net','0466301686',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(51,13,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Justen Berge Sr. - dhomenick@cummings.org','dhomenick@cummings.org','0740484356',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(52,14,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Whitney Jaskolski - brandy.flatley@hotmail.com','brandy.flatley@hotmail.com','0607408084',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(53,14,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Nicholaus Rohan - gerhard.farrell@hotmail.com','gerhard.farrell@hotmail.com','0023879093',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(54,15,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Miss Deborah Lehner - ocruickshank@hermann.com','ocruickshank@hermann.com','0799591193',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(55,15,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Aubree Donnelly III - mshanahan@howell.org','mshanahan@howell.org','0199524304',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(56,15,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Isac Bauch - baumbach.nikolas@hotmail.com','baumbach.nikolas@hotmail.com','0811328578',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(57,15,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Destin Wilkinson Jr. - emmerich.zelda@bruen.com','emmerich.zelda@bruen.com','0830189759',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(58,16,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Prof. Finn Blanda MD - rosenbaum.olen@lebsack.com','rosenbaum.olen@lebsack.com','0812130448',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(59,16,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Prof. Jacky D\'Amore Sr. - reed.skiles@homenick.com','reed.skiles@homenick.com','0318438894',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(60,16,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Edwina Bergstrom - fparker@medhurst.net','fparker@medhurst.net','0335512291',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(61,17,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Joanie Braun - leannon.jonatan@gmail.com','leannon.jonatan@gmail.com','0603876938',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(62,17,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Ezra Rempel - braulio90@skiles.com','braulio90@skiles.com','0666283571',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(63,18,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Alexie Stokes V - xvandervort@dietrich.org','xvandervort@dietrich.org','0166592192',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(64,18,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Efren Lind - ruecker.amber@gmail.com','ruecker.amber@gmail.com','0334015845',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(65,18,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Mr. Salvador Jenkins I - howe.haley@gmail.com','howe.haley@gmail.com','0939558400',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(66,18,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Miss Hulda Osinski - frederick69@hotmail.com','frederick69@hotmail.com','0809191343',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(67,18,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Prof. Amelia Parker - kautzer.marlen@hotmail.com','kautzer.marlen@hotmail.com','0661296806',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(68,19,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Cristina Roberts - pratke@hotmail.com','pratke@hotmail.com','0794449475',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(69,19,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Prof. Dallin Durgan Jr. - shaylee20@raynor.com','shaylee20@raynor.com','0810600493',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(70,20,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Loren Ernser - zhermann@gmail.com','zhermann@gmail.com','0154192211',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(71,20,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Rosa Gorczany - gharber@hotmail.com','gharber@hotmail.com','0747121820',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(72,20,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Lori Murazik - baumbach.elinor@kozey.info','baumbach.elinor@kozey.info','0827779558',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(73,20,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Emma Braun - mherman@gmail.com','mherman@gmail.com','0732477894',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(74,20,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Hector Lindgren - greenfelder.terry@yahoo.com','greenfelder.terry@yahoo.com','0229959111',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(75,20,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Raquel Reinger - ccasper@hirthe.com','ccasper@hirthe.com','0870585683',1,7.39,7.39,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(76,21,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Google I/O - Marisol Schneider - breitenberg.caroline@lebsack.com','breitenberg.caroline@lebsack.com','0670171282',1,97.90,97.90,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(77,21,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Google I/O - Miss Veda Pfannerstill Jr. - abbott.lemuel@gmail.com','abbott.lemuel@gmail.com','0906240876',1,97.90,97.90,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(78,22,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Google I/O - Liam Littel - myundt@gmail.com','myundt@gmail.com','0323586800',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(79,22,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Google I/O - Meta Russel - jazmyn49@yahoo.com','jazmyn49@yahoo.com','0359162552',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(80,22,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Google I/O - Santa Kunde DDS - jules11@yahoo.com','jules11@yahoo.com','0780474857',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(81,22,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Google I/O - Prof. Bernhard Kub Jr. - monica.rempel@medhurst.info','monica.rempel@medhurst.info','0694489737',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(82,22,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Google I/O - Garnett Terry - wolf.susan@turcotte.com','wolf.susan@turcotte.com','0250375911',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(83,22,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Google I/O - Wilford Kemmer - hoeger.zula@hotmail.com','hoeger.zula@hotmail.com','0241892669',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(84,23,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Google I/O - Antonetta Kunde V - eernser@hotmail.com','eernser@hotmail.com','0689866655',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(85,23,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Amya Altenwerth - yolson@schaden.org','yolson@schaden.org','0326981594',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(86,23,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Darien McCullough - thiel.jakayla@hotmail.com','thiel.jakayla@hotmail.com','0740928369',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(87,23,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Bernie Reynolds - aufderhar.bridie@yahoo.com','aufderhar.bridie@yahoo.com','0557925195',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(88,23,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Deja Jacobson - michelle.schowalter@heidenreich.com','michelle.schowalter@heidenreich.com','0034458616',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(89,24,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Gordon Flatley Jr. - howe.maiya@morissette.biz','howe.maiya@morissette.biz','0294839784',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(90,24,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Marilie Ankunding DDS - pmarquardt@daniel.com','pmarquardt@daniel.com','0547544226',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(91,24,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Prof. Noemie Cremin Sr. - israel.schaden@balistreri.info','israel.schaden@balistreri.info','0074112264',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(92,25,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Haleigh Von Sr. - jones.judy@tromp.org','jones.judy@tromp.org','0458574628',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(93,25,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Prof. Wilfredo Erdman - tyra48@yahoo.com','tyra48@yahoo.com','0599937350',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(94,25,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Baby Ferry III - zjohnson@prohaska.com','zjohnson@prohaska.com','0941084248',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(95,25,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Dr. Marcella Jakubowski Jr. - rick41@hotmail.com','rick41@hotmail.com','0215264739',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(96,26,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Dr. Adolphus Heathcote - kuhn.mercedes@raynor.info','kuhn.mercedes@raynor.info','0901132812',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(97,26,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Miss Carli Will V - wkozey@hotmail.com','wkozey@hotmail.com','0495575992',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(98,27,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Erling Champlin - bwalter@hotmail.com','bwalter@hotmail.com','0893117090',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(99,27,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Dr. Uriah Hill - esperanza.nicolas@moen.net','esperanza.nicolas@moen.net','0641314838',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(100,28,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Melissa Grant - barton.leanna@hotmail.com','barton.leanna@hotmail.com','0583309983',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(101,28,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Ari Hill - durgan.beth@stamm.com','durgan.beth@stamm.com','0371662293',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(102,28,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Everardo Purdy Sr. - kennedi.koelpin@hotmail.com','kennedi.koelpin@hotmail.com','0356910492',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(103,28,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Erwin Hudson MD - heaven.schneider@hoppe.com','heaven.schneider@hoppe.com','0725278602',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(104,28,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Mr. Walton Bode V - corn@quigley.biz','corn@quigley.biz','0291846832',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(105,28,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Darrick Torphy Jr. - lleffler@hotmail.com','lleffler@hotmail.com','0600159297',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(106,29,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Thaddeus McCullough - tiara80@gmail.com','tiara80@gmail.com','0643315661',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(107,29,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Iva Oberbrunner Jr. - heloise09@leuschke.com','heloise09@leuschke.com','0159135775',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(108,29,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Dr. Taylor Kiehn Jr. - quigley.zoila@gmail.com','quigley.zoila@gmail.com','0025698744',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(109,29,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Mr. Chandler Mraz - zwalker@gmail.com','zwalker@gmail.com','0914264947',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(110,29,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Jonathon Hirthe - ward.sister@hotmail.com','ward.sister@hotmail.com','0884943640',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(111,30,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Dwight Cummerata - jlittel@yahoo.com','jlittel@yahoo.com','0489929940',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(112,30,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Rhianna Kautzer - ondricka.johann@hotmail.com','ondricka.johann@hotmail.com','0239042326',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(113,30,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Dr. Fritz VonRueden I - verlie70@quigley.org','verlie70@quigley.org','0539890196',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(114,30,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Maud Dicki - sauer.novella@keebler.com','sauer.novella@keebler.com','0083603111',1,97.90,97.90,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(115,31,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Apple WWDC - Sister Deckow - sherman.altenwerth@gerlach.com','sherman.altenwerth@gerlach.com','0570520895',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(116,31,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Apple WWDC - Annie Casper - myles69@schroeder.info','myles69@schroeder.info','0049776087',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(117,31,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Apple WWDC - Mr. Cortez Skiles I - jrice@farrell.com','jrice@farrell.com','0211858600',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(118,31,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Apple WWDC - Karolann Anderson III - ethelyn15@jones.biz','ethelyn15@jones.biz','0745188404',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(119,32,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Apple WWDC - Prof. Blair Cartwright - karlie.stiedemann@yahoo.com','karlie.stiedemann@yahoo.com','0924981382',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(120,32,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Apple WWDC - Pearl Fahey - herminio.friesen@hotmail.com','herminio.friesen@hotmail.com','0051195190',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(121,32,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Apple WWDC - Ms. Elna Kihn DVM - conroy.amira@rohan.net','conroy.amira@rohan.net','0546736106',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(122,33,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Apple WWDC - Dr. Royce Walsh - uraynor@yahoo.com','uraynor@yahoo.com','0142903793',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(123,33,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Apple WWDC - Hudson Rice III - crooks.jayde@gmail.com','crooks.jayde@gmail.com','0011793404',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(124,33,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Apple WWDC - Amya Kuphal - ykunde@gmail.com','ykunde@gmail.com','0554794061',1,21.08,21.08,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(125,33,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Camryn Harris - ychristiansen@hotmail.com','ychristiansen@hotmail.com','0853324901',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(126,33,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Aric McDermott - faltenwerth@yahoo.com','faltenwerth@yahoo.com','0532227255',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(127,33,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Joesph Bartoletti - snolan@hotmail.com','snolan@hotmail.com','0860187616',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(128,34,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Jude Fritsch - rosemarie.klocko@schuppe.com','rosemarie.klocko@schuppe.com','0925361179',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(129,34,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Matt Roberts IV - trystan.feil@auer.net','trystan.feil@auer.net','0770689578',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(130,34,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Ramiro Greenfelder - oconnell.warren@kohler.biz','oconnell.warren@kohler.biz','0074529117',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(131,34,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Myrtie Towne - deontae26@hudson.org','deontae26@hudson.org','0910736246',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(132,34,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Kane Bailey - sstehr@bechtelar.biz','sstehr@bechtelar.biz','0855451780',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(133,35,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Emilia Schowalter - bdare@yahoo.com','bdare@yahoo.com','0804270291',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(134,35,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Vivien Zulauf V - zaufderhar@gmail.com','zaufderhar@gmail.com','0493947879',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(135,35,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Bertrand Flatley I - toy.leanne@yahoo.com','toy.leanne@yahoo.com','0069422020',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(136,35,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Dr. Burnice Heathcote I - ryan.omer@yahoo.com','ryan.omer@yahoo.com','0489966376',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(137,35,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Mr. Geovanny Schumm - dreichert@hotmail.com','dreichert@hotmail.com','0273985327',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(138,35,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Eliza Armstrong - sbartoletti@yahoo.com','sbartoletti@yahoo.com','0035410997',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(139,36,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Ova Balistreri - josephine41@yahoo.com','josephine41@yahoo.com','0514485060',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(140,36,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Berry Herzog - tillman.kurt@roberts.net','tillman.kurt@roberts.net','0115018745',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(141,36,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Danial Runte - beatty.hildegard@yahoo.com','beatty.hildegard@yahoo.com','0585845443',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(142,36,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Mr. Alberto Gerlach Jr. - bernhard.leila@towne.com','bernhard.leila@towne.com','0861269333',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(143,36,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Bryce Dooley III - mabelle44@hotmail.com','mabelle44@hotmail.com','0992702893',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(144,37,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Akeem Price - borer.jarvis@yahoo.com','borer.jarvis@yahoo.com','0318825797',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(145,37,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Eloy Stanton - marks.minerva@gmail.com','marks.minerva@gmail.com','0486609410',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(146,38,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Clint Dickens - gibson.lazaro@windler.com','gibson.lazaro@windler.com','0498993618',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(147,38,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Ms. Roslyn O\'Kon - jkemmer@yahoo.com','jkemmer@yahoo.com','0330845399',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(148,39,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Dr. Keegan Cartwright DDS - ortiz.dorris@gmail.com','ortiz.dorris@gmail.com','0947475006',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(149,39,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Carolanne Krajcik - aiyana79@abbott.com','aiyana79@abbott.com','0624053206',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(150,40,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Gisselle Boyer - prohaska.genoveva@yahoo.com','prohaska.genoveva@yahoo.com','0030399594',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(151,40,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Barbara Goyette - ymiller@collier.net','ymiller@collier.net','0761443257',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(152,40,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Leonie Reichel - buster.gutmann@senger.com','buster.gutmann@senger.com','0354772821',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(153,40,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Dr. Kenneth Goodwin MD - lavada60@gmail.com','lavada60@gmail.com','0095253236',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(154,40,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Ms. Dorothy Pouros - sabrina.zemlak@cruickshank.info','sabrina.zemlak@cruickshank.info','0501292678',1,21.08,21.08,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(155,41,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'AWS re:Invent - Betty Pouros - xschinner@senger.biz','xschinner@senger.biz','0879396289',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(156,41,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'AWS re:Invent - Mose Hermann II - madonna43@hotmail.com','madonna43@hotmail.com','0117973203',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(157,41,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'AWS re:Invent - Mrs. Rebeka Botsford MD - gibson.zechariah@yahoo.com','gibson.zechariah@yahoo.com','0328281687',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(158,41,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'AWS re:Invent - Faustino Wisoky - reinger.electa@hessel.com','reinger.electa@hessel.com','0324481759',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(159,41,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'AWS re:Invent - Lavonne Franecki MD - bert27@hotmail.com','bert27@hotmail.com','0544814092',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(160,41,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'AWS re:Invent - Jorge Torp - vern.boyle@murazik.com','vern.boyle@murazik.com','0221416282',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(161,42,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'AWS re:Invent - Kevon Mante - jermaine78@gmail.com','jermaine78@gmail.com','0398814302',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(162,42,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'AWS re:Invent - Bonnie Gutmann - lessie.koch@hotmail.com','lessie.koch@hotmail.com','0223548062',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(163,42,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'AWS re:Invent - Dr. Marcos Streich MD - stehr.annabel@gmail.com','stehr.annabel@gmail.com','0959673207',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(164,42,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'AWS re:Invent - Roberta Ziemann - xzavier53@gaylord.com','xzavier53@gaylord.com','0350307302',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(165,43,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'AWS re:Invent - Prof. Leora Mosciski - streich.lambert@hotmail.com','streich.lambert@hotmail.com','0322162138',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(166,43,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'AWS re:Invent - Ruthe Krajcik - evans.grady@gmail.com','evans.grady@gmail.com','0013169901',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(167,44,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Esmeralda Stracke - bruce.wyman@gmail.com','bruce.wyman@gmail.com','0957176910',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(168,44,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Ken Brakus - dubuque.rudy@mitchell.biz','dubuque.rudy@mitchell.biz','0676069339',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(169,44,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Meaghan Parker - sheldon58@gmail.com','sheldon58@gmail.com','0030558333',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(170,44,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Mariam Hermann MD - billie02@hotmail.com','billie02@hotmail.com','0975172800',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(171,45,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Zackary Langosh - pblick@stoltenberg.biz','pblick@stoltenberg.biz','0747891929',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(172,45,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Anita Gibson Jr. - purdy.elisha@hotmail.com','purdy.elisha@hotmail.com','0053622997',1,31.42,31.42,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(173,46,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Miss Lilly Champlin III - zfunk@jenkins.com','zfunk@jenkins.com','0803132848',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(174,46,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Madisyn Ortiz - katrina.wisoky@dickens.com','katrina.wisoky@dickens.com','0544508133',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(175,46,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Clovis Breitenberg MD - spinka.jordy@mills.com','spinka.jordy@mills.com','0726035023',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(176,46,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Eric Gerhold V - nsauer@gmail.com','nsauer@gmail.com','0377058346',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(177,46,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Matt Hamill - ashton17@carroll.com','ashton17@carroll.com','0043279038',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(178,46,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Angie Wilderman - khalid29@gleichner.net','khalid29@gleichner.net','0489811872',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(179,47,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Julianne Goodwin - mcglynn.ottilie@hotmail.com','mcglynn.ottilie@hotmail.com','0701710067',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(180,47,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Josephine Schowalter DVM - hershel.jacobi@hotmail.com','hershel.jacobi@hotmail.com','0809711027',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(181,47,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Troy Ryan - john27@yahoo.com','john27@yahoo.com','0838266939',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(182,47,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Ole Dicki - vkihn@waters.com','vkihn@waters.com','0485714578',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(183,48,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Donnell Purdy - reinger.brown@gmail.com','reinger.brown@gmail.com','0764863084',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(184,48,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Marianna Hilpert Sr. - mazie.ernser@kuvalis.net','mazie.ernser@kuvalis.net','0996639837',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(185,49,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Dr. Mona Harvey - jameson17@bahringer.net','jameson17@bahringer.net','0324432977',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(186,49,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Mr. Bruce Kutch - kiel35@gleichner.org','kiel35@gleichner.org','0258536975',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(187,49,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Corbin Stanton - will.pearl@hotmail.com','will.pearl@hotmail.com','0084413525',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(188,50,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Kale Kutch - florian.bahringer@emard.net','florian.bahringer@emard.net','0918971359',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(189,50,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Velda Sanford IV - chloe.kshlerin@yahoo.com','chloe.kshlerin@yahoo.com','0632747932',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(190,50,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Prof. Camryn Hauck I - donnie.frami@yahoo.com','donnie.frami@yahoo.com','0602970946',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(191,50,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Mr. Ewald Cronin - lowe.odie@bergnaum.com','lowe.odie@bergnaum.com','0199111560',1,31.42,31.42,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',81.25,'CES (Consumer Electronics Show)','Gaston Leuschke','pollich.lola@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',406.25,406.25,0.00,0.00,NULL,1,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',81.25,'CES (Consumer Electronics Show)','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',81.25,81.25,0.00,0.00,NULL,2,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',81.25,'CES (Consumer Electronics Show)','Tyson Veum','domenic97@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',162.50,162.50,0.00,0.00,NULL,3,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',81.25,'CES (Consumer Electronics Show)','Willie Gaylord','russel.edwardo@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',325.00,325.00,0.00,0.00,NULL,4,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',81.25,'CES (Consumer Electronics Show)','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',243.75,243.75,0.00,0.00,NULL,5,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',81.25,'CES (Consumer Electronics Show)','Gaston Leuschke','pollich.lola@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',81.25,81.25,0.00,0.00,NULL,6,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',81.25,'CES (Consumer Electronics Show)','Mitchell Pfeffer','jrenner@champlin.com',NULL,'ArchiElite','main/general/logo-light.png',325.00,325.00,0.00,0.00,NULL,7,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',81.25,'CES (Consumer Electronics Show)','Dr. Theo Windler','imelda20@bednar.com',NULL,'ArchiElite','main/general/logo-light.png',162.50,162.50,0.00,0.00,NULL,8,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',81.25,'CES (Consumer Electronics Show)','Filomena Maggio','parker.lorenz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',243.75,243.75,0.00,0.00,NULL,9,'completed','2025-06-10 10:42:57','2025-06-10 10:42:57','2025-06-10 10:42:57'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',81.25,'CES (Consumer Electronics Show)','Mitchell Pfeffer','jrenner@champlin.com',NULL,'ArchiElite','main/general/logo-light.png',325.00,325.00,0.00,0.00,NULL,10,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',7.39,'Mobile World Congress','Tyson Veum','domenic97@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',22.17,22.17,0.00,0.00,NULL,11,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',7.39,'Mobile World Congress','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',29.56,29.56,0.00,0.00,NULL,12,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',7.39,'Mobile World Congress','Gaston Leuschke','pollich.lola@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',14.78,14.78,0.00,0.00,NULL,13,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',7.39,'Mobile World Congress','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',7.39,7.39,0.00,0.00,NULL,14,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',7.39,'Mobile World Congress','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',22.17,22.17,0.00,0.00,NULL,15,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',7.39,'Mobile World Congress','Willie Gaylord','russel.edwardo@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',14.78,14.78,0.00,0.00,NULL,16,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',7.39,'Mobile World Congress','Mitchell Pfeffer','jrenner@champlin.com',NULL,'ArchiElite','main/general/logo-light.png',7.39,7.39,0.00,0.00,NULL,17,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',7.39,'Mobile World Congress','Gaston Leuschke','pollich.lola@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',29.56,29.56,0.00,0.00,NULL,18,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',7.39,'Mobile World Congress','Tyson Veum','domenic97@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',7.39,7.39,0.00,0.00,NULL,19,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',7.39,'Mobile World Congress','Marty Bergstrom','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',36.95,36.95,0.00,0.00,NULL,20,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',97.90,'Google I/O','Marty Bergstrom','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',97.90,97.90,0.00,0.00,NULL,21,'completed','2025-06-10 10:42:58','2025-06-10 10:42:58','2025-06-10 10:42:58'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',97.90,'Google I/O','Gaston Leuschke','pollich.lola@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',489.50,489.50,0.00,0.00,NULL,22,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',97.90,'Google I/O','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',391.60,391.60,0.00,0.00,NULL,23,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',97.90,'Google I/O','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',195.80,195.80,0.00,0.00,NULL,24,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',97.90,'Google I/O','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',293.70,293.70,0.00,0.00,NULL,25,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',97.90,'Google I/O','Marty Bergstrom','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',97.90,97.90,0.00,0.00,NULL,26,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',97.90,'Google I/O','Filomena Maggio','parker.lorenz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',97.90,97.90,0.00,0.00,NULL,27,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',97.90,'Google I/O','Dr. Theo Windler','imelda20@bednar.com',NULL,'ArchiElite','main/general/logo-light.png',489.50,489.50,0.00,0.00,NULL,28,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',97.90,'Google I/O','Dr. Theo Windler','imelda20@bednar.com',NULL,'ArchiElite','main/general/logo-light.png',391.60,391.60,0.00,0.00,NULL,29,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',97.90,'Google I/O','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',293.70,293.70,0.00,0.00,NULL,30,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',21.08,'Apple WWDC','Filomena Maggio','parker.lorenz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',63.24,63.24,0.00,0.00,NULL,31,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',21.08,'Apple WWDC','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',42.16,42.16,0.00,0.00,NULL,32,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',21.08,'Apple WWDC','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',105.40,105.40,0.00,0.00,NULL,33,'completed','2025-06-10 10:42:59','2025-06-10 10:42:59','2025-06-10 10:42:59'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',21.08,'Apple WWDC','Marty Bergstrom','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',84.32,84.32,0.00,0.00,NULL,34,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',21.08,'Apple WWDC','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',105.40,105.40,0.00,0.00,NULL,35,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',21.08,'Apple WWDC','Marty Bergstrom','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',84.32,84.32,0.00,0.00,NULL,36,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',21.08,'Apple WWDC','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',21.08,21.08,0.00,0.00,NULL,37,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',21.08,'Apple WWDC','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',21.08,21.08,0.00,0.00,NULL,38,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',21.08,'Apple WWDC','Dr. Theo Windler','imelda20@bednar.com',NULL,'ArchiElite','main/general/logo-light.png',21.08,21.08,0.00,0.00,NULL,39,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',21.08,'Apple WWDC','Willie Gaylord','russel.edwardo@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',84.32,84.32,0.00,0.00,NULL,40,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',31.42,'AWS re:Invent','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',157.10,157.10,0.00,0.00,NULL,41,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',31.42,'AWS re:Invent','Tyson Veum','domenic97@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',94.26,94.26,0.00,0.00,NULL,42,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',31.42,'AWS re:Invent','Marty Bergstrom','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',31.42,31.42,0.00,0.00,NULL,43,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',31.42,'AWS re:Invent','Marty Bergstrom','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',94.26,94.26,0.00,0.00,NULL,44,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',31.42,'AWS re:Invent','Jazlyn Turner','hmueller@koepp.com',NULL,'ArchiElite','main/general/logo-light.png',31.42,31.42,0.00,0.00,NULL,45,'completed','2025-06-10 10:43:00','2025-06-10 10:43:00','2025-06-10 10:43:00'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',31.42,'AWS re:Invent','Filomena Maggio','parker.lorenz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',157.10,157.10,0.00,0.00,NULL,46,'completed','2025-06-10 10:43:01','2025-06-10 10:43:00','2025-06-10 10:43:01'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',31.42,'AWS re:Invent','Mitchell Pfeffer','jrenner@champlin.com',NULL,'ArchiElite','main/general/logo-light.png',94.26,94.26,0.00,0.00,NULL,47,'completed','2025-06-10 10:43:01','2025-06-10 10:43:01','2025-06-10 10:43:01'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',31.42,'AWS re:Invent','Gaston Leuschke','pollich.lola@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',31.42,31.42,0.00,0.00,NULL,48,'completed','2025-06-10 10:43:01','2025-06-10 10:43:01','2025-06-10 10:43:01'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',31.42,'AWS re:Invent','Mitchell Pfeffer','jrenner@champlin.com',NULL,'ArchiElite','main/general/logo-light.png',62.84,62.84,0.00,0.00,NULL,49,'completed','2025-06-10 10:43:01','2025-06-10 10:43:01','2025-06-10 10:43:01'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',31.42,'AWS re:Invent','Prof. Reuben Bernhard II','powlowski.lee@christiansen.org',NULL,'ArchiElite','main/general/logo-light.png',94.26,94.26,0.00,0.00,NULL,50,'completed','2025-06-10 10:43:01','2025-06-10 10:43:01','2025-06-10 10:43:01');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'Z4XJBFTSCJJZ','028acc77-308d-4697-b4d5-28cd1a07ac43',1,'CES (Consumer Electronics Show)',81.25,12,1,'Gaston Leuschke','pollich.lola@hotmail.com','Alice, \'because I\'m not looking for them, but they were all crowded round her once more, while the.',NULL,'1',81.25,5,406.25,406.25,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(2,'NCZZWTP46OW9','0e0cb3ae-9ac3-4391-931f-358f0ab42e59',1,'CES (Consumer Electronics Show)',81.25,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','Mock Turtle, capering wildly about. \'Change lobsters again!\' yelled the Gryphon went on talking.',NULL,'2',81.25,1,81.25,81.25,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(3,'FCNVZWNGSIGQ','38544c89-06d2-4c91-88a2-ec2571d0aef0',1,'CES (Consumer Electronics Show)',81.25,23,1,'Tyson Veum','domenic97@gmail.com','Hatter: \'as the things I used to queer things happening. While she was now about two feet high.',NULL,'3',81.25,2,162.50,162.50,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(4,'UXEQHAQS9ZNP','326c7a4b-7af5-4810-9704-0aae46395d4c',1,'CES (Consumer Electronics Show)',81.25,3,1,'Willie Gaylord','russel.edwardo@yahoo.com','Hatter and the shrill voice of the game, feeling very curious sensation, which puzzled her too.',NULL,'4',81.25,4,325.00,325.00,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(5,'CSEBGINHGY9Y','0719008d-13f2-43ef-b7fb-7198b81b5630',1,'CES (Consumer Electronics Show)',81.25,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','Mock Turtle Soup is made from,\' said the Hatter. \'I told you that.\' \'If I\'d been the whiting,\'.',NULL,'5',81.25,3,243.75,243.75,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(6,'YB60JUIS6I66','f36ce997-4f2c-48c5-a2e5-f72ea05d86cf',1,'CES (Consumer Electronics Show)',81.25,12,1,'Gaston Leuschke','pollich.lola@hotmail.com','THE KING AND QUEEN OF HEARTS. Alice was too slippery; and when she looked back once or twice, and.',NULL,'6',81.25,1,81.25,81.25,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(7,'QZZB0N9UQYXE','dec2edea-9db0-4fc0-99d1-78c4ee85a976',1,'CES (Consumer Electronics Show)',81.25,10,1,'Mitchell Pfeffer','jrenner@champlin.com','Hatter, \'you wouldn\'t talk about cats or dogs either, if you cut your finger VERY deeply with a.',NULL,'7',81.25,4,325.00,325.00,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(8,'OU0ONKG7ECBH','cb85c3bc-8151-4d5a-b53b-e21eb5e56230',1,'CES (Consumer Electronics Show)',81.25,29,1,'Dr. Theo Windler','imelda20@bednar.com','I ought to have finished,\' said the Hatter. He had been all the things I used to it in asking.',NULL,'8',81.25,2,162.50,162.50,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(9,'AX6MBHADJ7MX','c84c0e34-e54e-44c8-b417-2cdf76804eb9',1,'CES (Consumer Electronics Show)',81.25,8,1,'Filomena Maggio','parker.lorenz@yahoo.com','ME.\' \'You!\' said the Cat. \'I\'d nearly forgotten that I\'ve got to the Hatter. This piece of.',NULL,'9',81.25,3,243.75,243.75,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57'),(10,'G9YUIXZFJHCC','a046687b-4c99-40d5-880c-aecc4161e172',1,'CES (Consumer Electronics Show)',81.25,10,1,'Mitchell Pfeffer','jrenner@champlin.com','Caterpillar angrily, rearing itself upright as it is.\' \'Then you keep moving round, I suppose?\'.',NULL,'10',81.25,4,325.00,325.00,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(11,'AITVC7KMVGNK','f7e5b5d2-23b9-4ba9-8ca2-ec3be52ccc0b',2,'Mobile World Congress',7.39,23,1,'Tyson Veum','domenic97@gmail.com','Mock Turtle in the sea, though you mayn\'t believe it--\' \'I never thought about it,\' added the.',NULL,'11',7.39,3,22.17,22.17,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(12,'0EAH2WCGMZIR','69bba708-6cbc-4fa4-a821-43fc04146d1a',2,'Mobile World Congress',7.39,30,1,'Jazlyn Turner','hmueller@koepp.com','Long Tale They were just beginning to feel which way you can;--but I must have a trial: For really.',NULL,'12',7.39,4,29.56,29.56,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(13,'0VVTTXD7GFMQ','866823cc-428a-4dc6-a7bc-d85c4a62ddba',2,'Mobile World Congress',7.39,12,1,'Gaston Leuschke','pollich.lola@hotmail.com','Alice quite hungry to look for her, and she went round the refreshments!\' But there seemed to be.',NULL,'13',7.39,2,14.78,14.78,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(14,'1IN55X6IJFQQ','224ab444-8b48-44f9-a7bf-c6ff3767dfba',2,'Mobile World Congress',7.39,30,1,'Jazlyn Turner','hmueller@koepp.com','Said his father; \'don\'t give yourself airs! Do you think you\'re changed, do you?\' \'I\'m afraid I\'ve.',NULL,'14',7.39,1,7.39,7.39,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(15,'QC2FGCTBRHLQ','747d9e8a-ad10-4d87-a80f-b021fcb9d747',2,'Mobile World Congress',7.39,30,1,'Jazlyn Turner','hmueller@koepp.com','Let me see--how IS it to her great delight it fitted! Alice opened the door as you liked.\' \'Is.',NULL,'15',7.39,3,22.17,22.17,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(16,'SORDRT8MSWOW','282b96dc-b5a6-49f9-8cd7-5dea859270eb',2,'Mobile World Congress',7.39,3,1,'Willie Gaylord','russel.edwardo@yahoo.com','Morcar, the earls of Mercia and Northumbria--\"\' \'Ugh!\' said the Gryphon. \'It all came different!\'.',NULL,'16',7.39,2,14.78,14.78,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(17,'HEXLPB14RP1G','dae35a4f-1e25-4ef5-8a46-df8a1c4361bd',2,'Mobile World Congress',7.39,10,1,'Mitchell Pfeffer','jrenner@champlin.com','I suppose.\' So she tucked it away under her arm, and timidly said \'Consider, my dear: she is of.',NULL,'17',7.39,1,7.39,7.39,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(18,'BUB1KYAJS1VC','fc30ae57-69cf-469f-9293-0bc7f4f3e096',2,'Mobile World Congress',7.39,12,1,'Gaston Leuschke','pollich.lola@hotmail.com','I don\'t think,\' Alice went on, taking first one side and then raised himself upon tiptoe, put his.',NULL,'18',7.39,4,29.56,29.56,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(19,'ICFBOFGLNIEA','8a8ffd98-b77e-4cd7-9341-8c3a033a8d98',2,'Mobile World Congress',7.39,23,1,'Tyson Veum','domenic97@gmail.com','Yet you turned a back-somersault in at once.\' However, she got up in great fear lest she should.',NULL,'19',7.39,1,7.39,7.39,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(20,'K62C3KFX7IHY','e9c48880-935f-43fd-8b03-4967d452c43b',2,'Mobile World Congress',7.39,1,1,'Marty Bergstrom','customer@archielite.com','Dormouse say?\' one of the court, arm-in-arm with the Dormouse. \'Fourteenth of March, I think I can.',NULL,'20',7.39,5,36.95,36.95,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(21,'BOGJG8WJ9CGQ','92888441-fb44-4e5f-b472-ec2a16cdefc9',3,'Google I/O',97.90,1,1,'Marty Bergstrom','customer@archielite.com','You gave us three or more; They all returned from him to you, Though they were all ornamented with.',NULL,'21',97.90,1,97.90,97.90,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58'),(22,'ABPGWVI3USR9','e99041a4-8303-4ade-8a8d-4b08e7da99b6',3,'Google I/O',97.90,12,1,'Gaston Leuschke','pollich.lola@hotmail.com','Stop this moment, I tell you, you coward!\' and at last turned sulky, and would only say, \'I am.',NULL,'22',97.90,5,489.50,489.50,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(23,'NNDF1YBAK7PT','fc23a0f0-d1c1-42ba-837e-cf3f24305dda',3,'Google I/O',97.90,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','Alice. \'Come on, then!\' roared the Queen, stamping on the hearth and grinning from ear to ear.',NULL,'23',97.90,4,391.60,391.60,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(24,'6C7TULCU9IBC','1e0b9fb2-6087-40e1-86b7-ed7b03f7dc08',3,'Google I/O',97.90,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','Pigeon had finished. \'As if it likes.\' \'I\'d rather finish my tea,\' said the Caterpillar. \'Well, I.',NULL,'24',97.90,2,195.80,195.80,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(25,'PXNHKHCWL2B4','18ea9299-209d-4794-bebc-c4c4e67e3975',3,'Google I/O',97.90,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','You see, she came up to them she heard her sentence three of the shepherd boy--and the sneeze of.',NULL,'25',97.90,3,293.70,293.70,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(26,'9R4ADTBTLEGF','45af0676-088b-49a8-a01c-0a8d166bab1e',3,'Google I/O',97.90,1,1,'Marty Bergstrom','customer@archielite.com','Alice, quite forgetting in the shade: however, the moment she appeared; but she ran off at once.',NULL,'26',97.90,1,97.90,97.90,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(27,'JYTPXCCSWOO7','6b7732c2-8179-4d38-96d9-da1020b9f467',3,'Google I/O',97.90,8,1,'Filomena Maggio','parker.lorenz@yahoo.com','And it\'ll fetch things when you throw them, and just as I\'d taken the highest tree in the air, I\'m.',NULL,'27',97.90,1,97.90,97.90,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(28,'KL09LBAQ7LPA','82e30a3c-a29c-4dfa-aefe-2c1734f1a027',3,'Google I/O',97.90,29,1,'Dr. Theo Windler','imelda20@bednar.com','Alice: \'besides, that\'s not a bit of the evening, beautiful Soup! \'Beautiful Soup! Who cares for.',NULL,'28',97.90,5,489.50,489.50,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(29,'2BEF78HIJ5K2','10ee799e-f1d3-4e5e-ae36-cad78e45f642',3,'Google I/O',97.90,29,1,'Dr. Theo Windler','imelda20@bednar.com','HERE.\' \'But then,\' thought Alice, \'and those twelve creatures,\' (she was obliged to have been.',NULL,'29',97.90,4,391.60,391.60,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(30,'0YOXNYOXX4XD','cadb2133-d5e5-4f6f-bb79-30249344e04b',3,'Google I/O',97.90,30,1,'Jazlyn Turner','hmueller@koepp.com','Why, I do it again and again.\' \'You are old, Father William,\' the young man said, \'And your hair.',NULL,'30',97.90,3,293.70,293.70,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(31,'XDIC5EM4LLQ8','21b7b998-d414-4858-a153-65865fddb299',4,'Apple WWDC',21.08,8,1,'Filomena Maggio','parker.lorenz@yahoo.com','Him, and ourselves, and it. Don\'t let him know she liked them best, For this must ever be A.',NULL,'31',21.08,3,63.24,63.24,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(32,'Q5JBOIFRFNYP','72fd66c8-9e81-42cf-ac52-f909bceea937',4,'Apple WWDC',21.08,30,1,'Jazlyn Turner','hmueller@koepp.com','I think?\' he said in a tone of great surprise. \'Of course twinkling begins with an important air.',NULL,'32',21.08,2,42.16,42.16,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(33,'KQSCTGLH6FRI','f947a039-3d09-485f-bb91-f4c18ef4dc0c',4,'Apple WWDC',21.08,30,1,'Jazlyn Turner','hmueller@koepp.com','Gryphon went on, \'What\'s your name, child?\' \'My name is Alice, so please your Majesty?\' he asked.',NULL,'33',21.08,5,105.40,105.40,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59'),(34,'OP0PZB6QZQI9','650e27a8-8b10-45e2-b2eb-617333f17024',4,'Apple WWDC',21.08,1,1,'Marty Bergstrom','customer@archielite.com','Gryphon repeated impatiently: \'it begins \"I passed by his face only, she would keep, through all.',NULL,'34',21.08,4,84.32,84.32,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(35,'OZGDADRJM1XF','b6920bd5-f271-42de-a069-bdc07549087a',4,'Apple WWDC',21.08,30,1,'Jazlyn Turner','hmueller@koepp.com','And the Gryphon never learnt it.\' \'Hadn\'t time,\' said the Rabbit in a very decided tone: \'tell her.',NULL,'35',21.08,5,105.40,105.40,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(36,'VMFCDTSFWLZI','e00c170b-213c-494c-9898-b1f7ddd4f6bb',4,'Apple WWDC',21.08,1,1,'Marty Bergstrom','customer@archielite.com','Dodo, a Lory and an Eaglet, and several other curious creatures. Alice led the way, and nothing.',NULL,'36',21.08,4,84.32,84.32,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(37,'GENPTORWHJYY','623e561c-ae2f-4606-9904-e0ff3915a401',4,'Apple WWDC',21.08,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','I should like to drop the jar for fear of their wits!\' So she stood watching them, and it\'ll sit.',NULL,'37',21.08,1,21.08,21.08,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(38,'ZD23VVI3EWRJ','1fefe3e3-83db-4972-ab32-dc46f9926f22',4,'Apple WWDC',21.08,30,1,'Jazlyn Turner','hmueller@koepp.com','BEST butter, you know.\' He was an old Turtle--we used to come once a week: HE taught us Drawling.',NULL,'38',21.08,1,21.08,21.08,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(39,'1LEAIABXP1FW','e76e4e65-e185-4495-be5c-9f924ed8149a',4,'Apple WWDC',21.08,29,1,'Dr. Theo Windler','imelda20@bednar.com','Yet you turned a back-somersault in at the moment, \'My dear! I wish you were INSIDE, you might.',NULL,'39',21.08,1,21.08,21.08,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(40,'55BN6MKDRBW1','5a8b0d6d-3d72-4eb3-aea3-b6c90f36eb93',4,'Apple WWDC',21.08,3,1,'Willie Gaylord','russel.edwardo@yahoo.com','And yet I don\'t want to go! Let me see: I\'ll give them a railway station.) However, she got to go.',NULL,'40',21.08,4,84.32,84.32,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(41,'48S1I1NI4UPW','e130fc6d-dd2c-48e6-9a71-e035797f76e1',5,'AWS re:Invent',31.42,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','Mock Turtle recovered his voice, and, with tears running down his cheeks, he went on for some way.',NULL,'41',31.42,5,157.10,157.10,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(42,'4LMYHNXIXCK5','233fb293-2a8d-43b2-a354-bf126404805a',5,'AWS re:Invent',31.42,23,1,'Tyson Veum','domenic97@gmail.com','Dormouse shall!\' they both sat silent for a good deal until she made her look up in spite of all.',NULL,'42',31.42,3,94.26,94.26,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(43,'UQND0SS2VRRD','f960a99e-ed35-4357-9d70-193dc2f18c9e',5,'AWS re:Invent',31.42,1,1,'Marty Bergstrom','customer@archielite.com','THROUGH the earth! How funny it\'ll seem, sending presents to one\'s own feet! And how odd the.',NULL,'43',31.42,1,31.42,31.42,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(44,'X1VSXYWNURPY','ad04282f-57d7-45ca-9d29-b6f72bda936e',5,'AWS re:Invent',31.42,1,1,'Marty Bergstrom','customer@archielite.com','However, the Multiplication Table doesn\'t signify: let\'s try Geography. London is the same size.',NULL,'44',31.42,3,94.26,94.26,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(45,'QP3ZYED6JPST','f6916227-140a-4f65-8ed9-d612e2fa9b7f',5,'AWS re:Invent',31.42,30,1,'Jazlyn Turner','hmueller@koepp.com','X. The Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'What IS a long argument with the Gryphon.',NULL,'45',31.42,1,31.42,31.42,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00'),(46,'QRHPHYJFMVPG','1c29f722-8321-4200-81fe-759309277c8b',5,'AWS re:Invent',31.42,8,1,'Filomena Maggio','parker.lorenz@yahoo.com','Hatter instead!\' CHAPTER VII. A Mad Tea-Party There was not otherwise than what you had been.',NULL,'46',31.42,5,157.10,157.10,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:43:00','2025-06-10 10:43:01'),(47,'BCSTQBXTMMKM','0038a3b4-751f-4f96-8ed8-ff374c91b32d',5,'AWS re:Invent',31.42,10,1,'Mitchell Pfeffer','jrenner@champlin.com','Alice, quite forgetting that she was playing against herself, for this time she heard a little.',NULL,'47',31.42,3,94.26,94.26,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(48,'5ZMCYHBEYDB2','71e23468-7b89-4eb4-aeb9-865b28fa6a6f',5,'AWS re:Invent',31.42,12,1,'Gaston Leuschke','pollich.lola@hotmail.com','Queen had only one who got any advantage from the trees upon her face. \'Very,\' said Alice.',NULL,'48',31.42,1,31.42,31.42,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(49,'LK1AN7A2RXXN','880e5990-ce14-4705-82a8-52aa043c3a03',5,'AWS re:Invent',31.42,10,1,'Mitchell Pfeffer','jrenner@champlin.com','I\'m mad?\' said Alice. \'Why, there they lay on the trumpet, and then another confusion of.',NULL,'49',31.42,2,62.84,62.84,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01'),(50,'RVNTQQ2FBOPX','74086a5e-5a68-4cdb-b3d3-600513ccada7',5,'AWS re:Invent',31.42,21,1,'Prof. Reuben Bernhard II','powlowski.lee@christiansen.org','The only things in the after-time, be herself a grown woman; and how she was in a tone of great.',NULL,'50',31.42,3,94.26,94.26,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'UTSTOR8A5OAH','Joana Lemke','halie.hane@yahoo.com','0799917570','Mock Turtle sighed deeply, and began, in a sulky tone; \'Seven jogged my elbow.\' On which Seven.',NULL,'transferred','2025-06-10 10:42:57','2025-06-10 10:42:57'),(2,1,'OL3M8CIHIDNK','Roselyn Runolfsdottir','kirlin.flo@sauer.com','0925534825','Alice, whose thoughts were still running on the glass table and the little door: but, alas! either.',NULL,'checked_in','2025-06-10 10:42:57','2025-06-10 10:42:57'),(3,1,'IMUOIDCFVRAL','Jaqueline Schultz DVM','rhiannon.dietrich@hotmail.com','0605137936','I don\'t want YOU with us!\"\' \'They were learning to draw, you know--\' She had not gone much farther.',NULL,'cancelled','2025-06-10 10:42:57','2025-06-10 10:42:57'),(4,1,'UI2YJ1XFT7YO','Audra Gaylord','tking@yahoo.com','0436261180','Queen\'s absence, and were resting in the lock, and to hear it say, as it left no mark on the top.',NULL,'reserved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(5,1,'D0JHPHVIJKEZ','Dr. Blake Reynolds V','jefferey01@gmail.com','0238395476','OUTSIDE.\' He unfolded the paper as he spoke, and the bright eager eyes were nearly out of a candle.',NULL,'pending','2025-06-10 10:42:57','2025-06-10 10:42:57'),(6,1,'ZCJPRNFGISZG','Theron Runte','cabernathy@gmail.com','0518653825','Duchess: \'flamingoes and mustard both bite. And the muscular strength, which it gave to my right.',NULL,'purchased','2025-06-10 10:42:57','2025-06-10 10:42:57'),(7,2,'CAQIX2GCGKUD','Landen Konopelski','torey24@gmail.com','0833237314','I don\'t want to get out again. That\'s all.\' \'Thank you,\' said the March Hare said--\' \'I didn\'t!\'.',NULL,'refunded','2025-06-10 10:42:57','2025-06-10 10:42:57'),(8,2,'0BWWFQBP6ERL','Edyth Ritchie','austyn.berge@hotmail.com','0610549271','Trims his belt and his friends shared their never-ending meal, and the words don\'t FIT you,\' said.',NULL,'pending','2025-06-10 10:42:57','2025-06-10 10:42:57'),(9,3,'3HDQ31TNORVM','Dr. Bart Kovacek','sage75@homenick.net','0784404606','Who for such a capital one for catching mice--oh, I beg your acceptance of this was not a mile.',NULL,'cancelled','2025-06-10 10:42:57','2025-06-10 10:42:57'),(10,3,'MQF7SDAGHHMS','Prof. Unique McGlynn','mkuhic@yahoo.com','0299003960','The adventures first,\' said the Cat in a melancholy air, and, after glaring at her feet in the.',NULL,'checked_in','2025-06-10 10:42:57','2025-06-10 10:42:57'),(11,3,'FJHEYXWKPLUW','Jess Haley MD','molly59@yahoo.com','0179646529','Shall I try the first witness,\' said the Dodo, \'the best way you can;--but I must have been.',NULL,'transferred','2025-06-10 10:42:57','2025-06-10 10:42:57'),(12,4,'AXPMXVDCGFXR','Ms. Mercedes Carroll PhD','fgraham@yahoo.com','0387526305','Mouse, in a bit.\' \'Perhaps it doesn\'t understand English,\' thought Alice; \'only, as it\'s asleep, I.',NULL,'reserved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(13,4,'XWMXIXMSFOKZ','Dr. Presley Frami','king.rosie@gmail.com','0967401697','I begin, please your Majesty,\' the Hatter hurriedly left the court, by the officers of the court,\".',NULL,'cancelled','2025-06-10 10:42:57','2025-06-10 10:42:57'),(14,4,'XE1X0MPSB6KH','Mr. Abdiel Cartwright PhD','yvonne04@kilback.com','0582043585','These were the cook, to see anything; then she walked on in the same thing as \"I get what I should.',NULL,'transferred','2025-06-10 10:42:57','2025-06-10 10:42:57'),(15,4,'USAN7APLOZ82','Miss Jaqueline Satterfield','considine.cooper@hotmail.com','0753400420','Queens, and among them Alice recognised the White Rabbit with pink eyes ran close by her. There.',NULL,'refunded','2025-06-10 10:42:57','2025-06-10 10:42:57'),(16,4,'Y7IN6A7OAIOR','Prof. Brielle Harris','ethel.ziemann@okuneva.info','0775681076','These were the cook, to see what was on the second time round, she came upon a neat little house.',NULL,'cancelled','2025-06-10 10:42:57','2025-06-10 10:42:57'),(17,5,'UPWUDLZ0VTR6','Lelah Heller','conn.arturo@dare.info','0864349570','Mouse was bristling all over, and both footmen, Alice noticed, had powdered hair that curled all.',NULL,'purchased','2025-06-10 10:42:57','2025-06-10 10:42:57'),(18,5,'HYQ8QGHBXBPV','Prof. Kathryne Lubowitz DVM','friedrich40@dietrich.com','0856554596','It quite makes my forehead ache!\' Alice watched the White Rabbit, \'and that\'s a fact.\' Alice did.',NULL,'reserved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(19,5,'D9GCJSNLECLA','Miss Kelsie McGlynn','ogoyette@farrell.info','0127821397','Dormouse into the roof was thatched with fur. It was all about, and crept a little queer, won\'t.',NULL,'transferred','2025-06-10 10:42:57','2025-06-10 10:42:57'),(20,5,'DQOHKIIYYCMW','Laurie Corkery','rogelio.bauch@heller.biz','0814923424','It\'s by far the most curious thing I ask! It\'s always six o\'clock now.\' A bright idea came into.',NULL,'cancelled','2025-06-10 10:42:57','2025-06-10 10:42:57'),(21,6,'AIYV9ZAOF6XM','Bridie Rau','bradtke.nettie@lehner.com','0002519937','I\'m a hatter.\' Here the Queen said--\' \'Get to your little boy, And beat him when he sneezes: He.',NULL,'purchased','2025-06-10 10:42:57','2025-06-10 10:42:57'),(22,6,'1CRBM5CWE6UQ','Brielle Walker','abshire.edison@gmail.com','0672392028','The Dormouse again took a great deal too far off to other parts of the game, feeling very curious.',NULL,'reserved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(23,7,'0WL0SN28DY36','Arlene Goldner','maci.jast@johnston.org','0561412371','It was high time you were down here with me! There are no mice in the kitchen. \'When I\'M a.',NULL,'reserved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(24,7,'PXBJKM2ONYIA','Anya Schoen','angie.cormier@yahoo.com','0073862295','THEN--she found herself falling down a large piece out of sight. Alice remained looking.',NULL,'pending','2025-06-10 10:42:57','2025-06-10 10:42:57'),(25,7,'RYU9976ACC7H','Rudolph Williamson III','torp.gregorio@hotmail.com','0253082339','Hatter. \'You might just as I\'d taken the highest tree in front of them, with her friend. When she.',NULL,'pending','2025-06-10 10:42:57','2025-06-10 10:42:57'),(26,7,'QLW49PDZ3M7D','Sienna Considine','bryon.russel@yahoo.com','0196894626','Alice joined the procession, wondering very much to-night, I should be free of them with one of.',NULL,'purchased','2025-06-10 10:42:57','2025-06-10 10:42:57'),(27,7,'O13YOER6ME7B','Dr. Khalid Harris V','opollich@hotmail.com','0217020728','YOUR table,\' said Alice; \'I daresay it\'s a set of verses.\' \'Are they in the pool a little timidly.',NULL,'refunded','2025-06-10 10:42:57','2025-06-10 10:42:57'),(28,8,'0JXDZVRMWYIG','Mckenna Konopelski','xjaskolski@yahoo.com','0483649103','The door led right into a cucumber-frame, or something of the Queen never left off when they met.',NULL,'reserved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(29,8,'UWKDKIEGOKV0','Leland Lesch Sr.','green.monahan@hamill.com','0112041588','Alice started to her to speak good English); \'now I\'m opening out like the three gardeners who.',NULL,'transferred','2025-06-10 10:42:57','2025-06-10 10:42:57'),(30,8,'7P0B5QAQDUXW','Alek Wiegand','ohara.pearl@hotmail.com','0652797333','I suppose it were white, but there was a little snappishly. \'You\'re enough to try the experiment?\'.',NULL,'purchased','2025-06-10 10:42:57','2025-06-10 10:42:57'),(31,9,'GU5XOSMVDYJX','Arnold Hirthe','hahn.hilma@tremblay.com','0233525195','I wish you would have appeared to them to sell,\' the Hatter and the Queen, \'and take this child.',NULL,'pending','2025-06-10 10:42:57','2025-06-10 10:42:57'),(32,9,'HFAJBSC07ETV','Lisette Jakubowski','hilbert38@abshire.net','0969827674','Alice, so please your Majesty,\' said the Mock Turtle said: \'advance twice, set to work, and very.',NULL,'purchased','2025-06-10 10:42:57','2025-06-10 10:42:57'),(33,9,'F2YSH8OCICO2','Tevin Hand Sr.','sflatley@gulgowski.info','0957496219','I think--\' (she was obliged to write with one eye, How the Owl and the Queen shrieked out. \'Behead.',NULL,'refunded','2025-06-10 10:42:57','2025-06-10 10:42:57'),(34,9,'QG8PLC2IVD86','Brandon Sawayn','sophia77@gmail.com','0293001157','Alice, who had not noticed before, and he poured a little girl she\'ll think me for his housemaid,\'.',NULL,'reserved','2025-06-10 10:42:57','2025-06-10 10:42:57'),(35,10,'GTCL0FXXXWJE','Corene Bernier DDS','sarai.jacobson@hotmail.com','0047494989','Alice took up the conversation a little. \'\'Tis so,\' said the Duchess. \'I make you grow shorter.\'.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(36,10,'7XRRNB9VNPWS','Ms. Shanon Beahan Sr.','kory94@jacobs.com','0453843683','Ugh, Serpent!\' \'But I\'m not particular as to prevent its undoing itself,) she carried it off. * *.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(37,10,'VNE706VNWBKZ','Bette Klein II','murphy.elise@hotmail.com','0281798272','Dormouse: \'not in that poky little house, and wondering whether she could see this, as she came.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(38,10,'KGPAODJ5DUS0','Aliyah Dickens I','pfunk@weissnat.com','0530862731','Duchess was VERY ugly; and secondly, because she was peering about anxiously among the distant.',NULL,'purchased','2025-06-10 10:42:58','2025-06-10 10:42:58'),(39,10,'OGVBI0M3BWHO','Isidro Anderson','xveum@yahoo.com','0641561872','I wonder what I could show you our cat Dinah: I think you\'d take a fancy to cats if you drink much.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(40,11,'ESBEKGXJ6VNI','Elwyn Balistreri II','ola.kohler@paucek.com','0786295122','Bill\'s place for a minute or two to think about it, even if my head would go through,\' thought.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(41,11,'EVMXEG702BAM','Mrs. Raina Nicolas IV','amcclure@hahn.net','0528073511','For some minutes the whole pack of cards!\' At this moment Alice appeared, she was quite pleased to.',NULL,'pending','2025-06-10 10:42:58','2025-06-10 10:42:58'),(42,11,'S3TKRU43KN8N','Adolphus Mante','akuhlman@schiller.net','0610810178','TWO little shrieks, and more sounds of broken glass. \'What a pity it wouldn\'t stay!\' sighed the.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(43,11,'MVSPTI1EMT30','Hallie Simonis','cora57@gmail.com','0618924003','Stretching, and Fainting in Coils.\' \'What was THAT like?\' said Alice. \'Why, you don\'t know where.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(44,12,'PN3GNGGNIM83','Robyn O\'Reilly','reyna.reilly@marks.com','0274365484','Cat again, sitting on a little shriek, and went stamping about, and called out to the Gryphon.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(45,12,'FIPQU8GG8UYD','Marge Barrows','qmoore@hotmail.com','0970697026','Rabbit\'s voice along--\'Catch him, you by the way, was the matter with it. There was a dispute.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(46,12,'G4EUIICU7YCJ','Abigale Mills','dicki.ivory@grady.com','0601963766','If she should push the matter on, What would become of you? I gave her one, they gave him two, You.',NULL,'reserved','2025-06-10 10:42:58','2025-06-10 10:42:58'),(47,12,'QBG7Y9HSRAH6','Miss Jermaine Terry DDS','rod.huels@yahoo.com','0352121495','Alice. \'Come on, then,\' said the Cat again, sitting on a branch of a water-well,\' said the.',NULL,'pending','2025-06-10 10:42:58','2025-06-10 10:42:58'),(48,12,'0T7MGLLI6VB8','Prof. Amani Terry DVM','cole.shane@yahoo.com','0501444219','Pigeon. \'I\'m NOT a serpent!\' said Alice sadly. \'Hand it over afterwards, it occurred to her great.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(49,13,'GUYRCTMPKSPP','Ms. Alicia Schumm DDS','kbarton@schaden.net','0630243142','It was high time to see what the next question is, what?\' The great question certainly was, what?.',NULL,'pending','2025-06-10 10:42:58','2025-06-10 10:42:58'),(50,13,'OWSBK7IK2CS5','Polly McClure','richie.altenwerth@konopelski.net','0466301686','I should be raving mad after all! I almost wish I hadn\'t drunk quite so much!\' Alas! it was.',NULL,'transferred','2025-06-10 10:42:58','2025-06-10 10:42:58'),(51,13,'15OFXLZX9ZNA','Justen Berge Sr.','dhomenick@cummings.org','0740484356','Alice, \'Have you seen the Mock Turtle: \'nine the next, and so on; then, when you\'ve cleared all.',NULL,'transferred','2025-06-10 10:42:58','2025-06-10 10:42:58'),(52,14,'3IKK8AJVHQGI','Whitney Jaskolski','brandy.flatley@hotmail.com','0607408084','I ought to be treated with respect. \'Cheshire Puss,\' she began, in a very respectful tone, but.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(53,14,'ITNLFH47AKQX','Nicholaus Rohan','gerhard.farrell@hotmail.com','0023879093','Alice for some minutes. The Caterpillar and Alice called after it; and while she was trying to.',NULL,'pending','2025-06-10 10:42:58','2025-06-10 10:42:58'),(54,15,'RTIHFGADS1N2','Miss Deborah Lehner','ocruickshank@hermann.com','0799591193','Five! Always lay the blame on others!\' \'YOU\'D better not talk!\' said Five. \'I heard every word you.',NULL,'reserved','2025-06-10 10:42:58','2025-06-10 10:42:58'),(55,15,'SNYFNLD7FF8Z','Aubree Donnelly III','mshanahan@howell.org','0199524304','VERY wide, but she had read several nice little dog near our house I should understand that.',NULL,'refunded','2025-06-10 10:42:58','2025-06-10 10:42:58'),(56,15,'P8TVBLHEZCWF','Isac Bauch','baumbach.nikolas@hotmail.com','0811328578','Footman went on muttering over the edge of her sister, as well look and see after some executions.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(57,15,'RJIA9V4X5FZJ','Destin Wilkinson Jr.','emmerich.zelda@bruen.com','0830189759','I? Ah, THAT\'S the great wonder is, that there\'s any one of them didn\'t know it was in confusion.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(58,16,'9J1GOAZK5OSQ','Prof. Finn Blanda MD','rosenbaum.olen@lebsack.com','0812130448','Alice. \'Now we shall have somebody to talk about trouble!\' said the March Hare: she thought there.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(59,16,'4UMAJKO7ONMS','Prof. Jacky D\'Amore Sr.','reed.skiles@homenick.com','0318438894','Cheshire cat,\' said the King had said that day. \'No, no!\' said the March Hare. \'Exactly so,\' said.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(60,16,'SQUSJKOBIWEA','Edwina Bergstrom','fparker@medhurst.net','0335512291','Alice glanced rather anxiously at the mushroom for a rabbit! I suppose you\'ll be asleep again.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(61,17,'4RPVIHAQBGIK','Joanie Braun','leannon.jonatan@gmail.com','0603876938','The King\'s argument was, that her idea of having nothing to do.\" Said the mouse doesn\'t get out.\".',NULL,'transferred','2025-06-10 10:42:58','2025-06-10 10:42:58'),(62,17,'M2AJMJ2XOOQ4','Ezra Rempel','braulio90@skiles.com','0666283571','Oh my dear paws! Oh my dear paws! Oh my fur and whiskers! She\'ll get me executed, as sure as.',NULL,'purchased','2025-06-10 10:42:58','2025-06-10 10:42:58'),(63,18,'JYVVZDE5RCFG','Alexie Stokes V','xvandervort@dietrich.org','0166592192','I will tell you how the Dodo managed it.) First it marked out a new kind of rule, \'and vinegar.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(64,18,'ZJENHBXHNMEB','Efren Lind','ruecker.amber@gmail.com','0334015845','Duck and a scroll of parchment in the sea!\' cried the Gryphon, and the other end of the suppressed.',NULL,'purchased','2025-06-10 10:42:58','2025-06-10 10:42:58'),(65,18,'FWTFQ6QAIGBH','Mr. Salvador Jenkins I','howe.haley@gmail.com','0939558400','HERE.\' \'But then,\' thought Alice, \'or perhaps they won\'t walk the way out of a book,\' thought.',NULL,'pending','2025-06-10 10:42:58','2025-06-10 10:42:58'),(66,18,'TUMA9LMTL2IX','Miss Hulda Osinski','frederick69@hotmail.com','0809191343','They are waiting on the back. However, it was YOUR table,\' said Alice; \'living at the door-- Pray.',NULL,'pending','2025-06-10 10:42:58','2025-06-10 10:42:58'),(67,18,'E9XHIWHGCRMH','Prof. Amelia Parker','kautzer.marlen@hotmail.com','0661296806','Pigeon went on, looking anxiously round to see it trying in a piteous tone. And she tried hard to.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(68,19,'DL8CKKMOBQGA','Cristina Roberts','pratke@hotmail.com','0794449475','NOT marked \'poison,\' so Alice soon came upon a neat little house, on the second time round, she.',NULL,'refunded','2025-06-10 10:42:58','2025-06-10 10:42:58'),(69,19,'XVJD67XPKIQK','Prof. Dallin Durgan Jr.','shaylee20@raynor.com','0810600493','The Hatter was the same when I breathe\"!\' \'It IS the same tone, exactly as if she meant to take.',NULL,'cancelled','2025-06-10 10:42:58','2025-06-10 10:42:58'),(70,20,'ICXOSSUECMH8','Loren Ernser','zhermann@gmail.com','0154192211','Gryphon never learnt it.\' \'Hadn\'t time,\' said the Cat, \'if you only kept on puzzling about it.',NULL,'purchased','2025-06-10 10:42:58','2025-06-10 10:42:58'),(71,20,'VWOT01EXSOQW','Rosa Gorczany','gharber@hotmail.com','0747121820','I\'m mad?\' said Alice. \'Did you say \"What a pity!\"?\' the Rabbit say to itself in a whisper.) \'That.',NULL,'transferred','2025-06-10 10:42:58','2025-06-10 10:42:58'),(72,20,'TPIO8FB5B46B','Lori Murazik','baumbach.elinor@kozey.info','0827779558','Alice, who felt very glad to do it.\' (And, as you are; secondly, because they\'re making such VERY.',NULL,'purchased','2025-06-10 10:42:58','2025-06-10 10:42:58'),(73,20,'4LUOBRMQQKYB','Emma Braun','mherman@gmail.com','0732477894','Hatter, \'or you\'ll be asleep again before it\'s done.\' \'Once upon a Gryphon, lying fast asleep in.',NULL,'pending','2025-06-10 10:42:58','2025-06-10 10:42:58'),(74,20,'N2I8G6WNKJTD','Hector Lindgren','greenfelder.terry@yahoo.com','0229959111','March Hare. Visit either you like: they\'re both mad.\' \'But I don\'t want YOU with us!\"\' \'They were.',NULL,'checked_in','2025-06-10 10:42:58','2025-06-10 10:42:58'),(75,20,'YYOAGCVDELVQ','Raquel Reinger','ccasper@hirthe.com','0870585683','Hatter said, turning to the Queen. \'You make me giddy.\' And then, turning to Alice, and her eyes.',NULL,'transferred','2025-06-10 10:42:58','2025-06-10 10:42:58'),(76,21,'P10KGV1XLLOQ','Marisol Schneider','breitenberg.caroline@lebsack.com','0670171282','There seemed to be managed? I suppose I ought to have the experiment tried. \'Very true,\' said the.',NULL,'purchased','2025-06-10 10:42:58','2025-06-10 10:42:58'),(77,21,'WFDCQPEUGRAC','Miss Veda Pfannerstill Jr.','abbott.lemuel@gmail.com','0906240876','Alice. \'Of course not,\' said the Hatter. \'Does YOUR watch tell you how it was a little irritated.',NULL,'reserved','2025-06-10 10:42:58','2025-06-10 10:42:58'),(78,22,'WWQWJ9TZXDHS','Liam Littel','myundt@gmail.com','0323586800','Dodo replied very solemnly. Alice was beginning to end,\' said the Gryphon, with a bound into the.',NULL,'refunded','2025-06-10 10:42:59','2025-06-10 10:42:59'),(79,22,'65ENTVZYBKHZ','Meta Russel','jazmyn49@yahoo.com','0359162552','I can\'t show it you myself,\' the Mock Turtle: \'nine the next, and so on; then, when you\'ve cleared.',NULL,'refunded','2025-06-10 10:42:59','2025-06-10 10:42:59'),(80,22,'RVQ8IYZDOPN1','Santa Kunde DDS','jules11@yahoo.com','0780474857','Alice, as she went to the croquet-ground. The other side of the song, perhaps?\' \'I\'ve heard.',NULL,'cancelled','2025-06-10 10:42:59','2025-06-10 10:42:59'),(81,22,'WNU9MI0PFCYP','Prof. Bernhard Kub Jr.','monica.rempel@medhurst.info','0694489737','Queen said to the jury. They were just beginning to think that proved it at last, and managed to.',NULL,'checked_in','2025-06-10 10:42:59','2025-06-10 10:42:59'),(82,22,'2IARFGFQR71C','Garnett Terry','wolf.susan@turcotte.com','0250375911','For really this morning I\'ve nothing to what I eat\" is the capital of Paris, and Paris is the.',NULL,'refunded','2025-06-10 10:42:59','2025-06-10 10:42:59'),(83,22,'PCBWGNPGYGWX','Wilford Kemmer','hoeger.zula@hotmail.com','0241892669','I to do?\' said Alice. \'And where HAVE my shoulders got to? And oh, I wish I hadn\'t gone down that.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(84,23,'IXIEZVFPEKRA','Antonetta Kunde V','eernser@hotmail.com','0689866655','WOULD not remember ever having heard of \"Uglification,\"\' Alice ventured to ask. \'Suppose we change.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(85,23,'WGYRMNDLAWIP','Amya Altenwerth','yolson@schaden.org','0326981594','Queen of Hearts, she made her next remark. \'Then the Dormouse went on, \'you throw the--\' \'The.',NULL,'refunded','2025-06-10 10:42:59','2025-06-10 10:42:59'),(86,23,'IA6HEYMCSPEZ','Darien McCullough','thiel.jakayla@hotmail.com','0740928369','Alice: \'she\'s so extremely--\' Just then her head struck against the door, she walked sadly down.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(87,23,'WBIXFYYPRRDX','Bernie Reynolds','aufderhar.bridie@yahoo.com','0557925195','Queen. \'Never!\' said the White Rabbit cried out, \'Silence in the book,\' said the White Rabbit.',NULL,'checked_in','2025-06-10 10:42:59','2025-06-10 10:42:59'),(88,23,'ESTLPSK91BHN','Deja Jacobson','michelle.schowalter@heidenreich.com','0034458616','Queen. \'Can you play croquet?\' The soldiers were silent, and looked at the top of her head to hide.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(89,24,'MKDR2ZGAKUON','Gordon Flatley Jr.','howe.maiya@morissette.biz','0294839784','Come on!\' \'Everybody says \"come on!\" here,\' thought Alice, \'it\'ll never do to ask: perhaps I shall.',NULL,'refunded','2025-06-10 10:42:59','2025-06-10 10:42:59'),(90,24,'1SYRKNYOSLJJ','Marilie Ankunding DDS','pmarquardt@daniel.com','0547544226','I only knew how to get us dry would be QUITE as much as she could, for the hedgehogs; and in THAT.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(91,24,'AFFUC3OVMBAO','Prof. Noemie Cremin Sr.','israel.schaden@balistreri.info','0074112264','I have none, Why, I haven\'t had a little pattering of feet on the bank, and of having nothing to.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(92,25,'7GZ0SDCVOPYC','Haleigh Von Sr.','jones.judy@tromp.org','0458574628','Queen\'s shrill cries to the little creature down, and the m--\' But here, to Alice\'s great.',NULL,'cancelled','2025-06-10 10:42:59','2025-06-10 10:42:59'),(93,25,'GQQKMR8SUIFK','Prof. Wilfredo Erdman','tyra48@yahoo.com','0599937350','Though they were gardeners, or soldiers, or courtiers, or three pairs of tiny white kid gloves.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(94,25,'PO9IMXE8J9YV','Baby Ferry III','zjohnson@prohaska.com','0941084248','Time, and round Alice, every now and then, and holding it to be ashamed of yourself for asking.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(95,25,'5POYGZUQOU6H','Dr. Marcella Jakubowski Jr.','rick41@hotmail.com','0215264739','Alice, \'they\'re sure to kill it in asking riddles that have no sort of life! I do it again and.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(96,26,'U0X54CDIUDE0','Dr. Adolphus Heathcote','kuhn.mercedes@raynor.info','0901132812','Though they were all turning into little cakes as they used to say anything. \'Why,\' said the.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(97,26,'RQI1RH8PJM3Z','Miss Carli Will V','wkozey@hotmail.com','0495575992','Alice; \'only, as it\'s asleep, I suppose you\'ll be telling me next that you weren\'t to talk to.\'.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(98,27,'MUHS3OKPKIWD','Erling Champlin','bwalter@hotmail.com','0893117090','Alice like the look of the treat. When the sands are all pardoned.\' \'Come, THAT\'S a good deal.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(99,27,'3WLIH3MSSKZG','Dr. Uriah Hill','esperanza.nicolas@moen.net','0641314838','And yet I don\'t like them raw.\' \'Well, be off, then!\' said the March Hare will be the use of.',NULL,'checked_in','2025-06-10 10:42:59','2025-06-10 10:42:59'),(100,28,'9BUAR1VBURFZ','Melissa Grant','barton.leanna@hotmail.com','0583309983','Pennyworth only of beautiful Soup? Beau--ootiful Soo--oop! Soo--oop of the trees under which she.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(101,28,'LEMW5GJQ6TI0','Ari Hill','durgan.beth@stamm.com','0371662293','And the Gryphon replied rather impatiently: \'any shrimp could have told you that.\' \'If I\'d been.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(102,28,'HO5UAWIKF2B9','Everardo Purdy Sr.','kennedi.koelpin@hotmail.com','0356910492','Alice. \'Reeling and Writhing, of course, I meant,\' the King was the first position in dancing.\'.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(103,28,'WHRE2GOB9CIO','Erwin Hudson MD','heaven.schneider@hoppe.com','0725278602','Alice an excellent plan, no doubt, and very soon finished off the mushroom, and raised herself to.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(104,28,'S4WG7X9RRXQX','Mr. Walton Bode V','corn@quigley.biz','0291846832','Queen: so she set the little dears came jumping merrily along hand in hand, in couples: they were.',NULL,'checked_in','2025-06-10 10:42:59','2025-06-10 10:42:59'),(105,28,'TLL0ASOAWCI9','Darrick Torphy Jr.','lleffler@hotmail.com','0600159297','Gryphon. \'We can do without lobsters, you know. But do cats eat bats?\' and sometimes, \'Do bats eat.',NULL,'transferred','2025-06-10 10:42:59','2025-06-10 10:42:59'),(106,29,'GCLK6LNMMSQZ','Thaddeus McCullough','tiara80@gmail.com','0643315661','SOMETHING interesting is sure to happen,\' she said to Alice. \'What IS a Caucus-race?\' said Alice.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(107,29,'07YCP5GC87JL','Iva Oberbrunner Jr.','heloise09@leuschke.com','0159135775','Alice joined the procession, wondering very much what would happen next. The first question of.',NULL,'transferred','2025-06-10 10:42:59','2025-06-10 10:42:59'),(108,29,'WTPWGHAPC46D','Dr. Taylor Kiehn Jr.','quigley.zoila@gmail.com','0025698744','Queen say only yesterday you deserved to be trampled under its feet, ran round the hall, but they.',NULL,'transferred','2025-06-10 10:42:59','2025-06-10 10:42:59'),(109,29,'5CA6H1N816O9','Mr. Chandler Mraz','zwalker@gmail.com','0914264947','Duchess and the Gryphon interrupted in a few minutes she heard a little ledge of rock, and, as the.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(110,29,'AYFLZHDTZJFS','Jonathon Hirthe','ward.sister@hotmail.com','0884943640','ARE OLD, FATHER WILLIAM,\"\' said the King. Here one of the party went back to the Gryphon. \'Then.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(111,30,'HK36YKJ192F6','Dwight Cummerata','jlittel@yahoo.com','0489929940','Alice. \'Of course twinkling begins with a growl, And concluded the banquet--] \'What IS a long.',NULL,'checked_in','2025-06-10 10:42:59','2025-06-10 10:42:59'),(112,30,'NZIHXAOVNKAI','Rhianna Kautzer','ondricka.johann@hotmail.com','0239042326','COULD grin.\' \'They all can,\' said the King, and the little door about fifteen inches high: she.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(113,30,'IANOJQ78JPZN','Dr. Fritz VonRueden I','verlie70@quigley.org','0539890196','And the Gryphon went on again:-- \'You may go,\' said the Rabbit\'s voice along--\'Catch him, you by.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(114,30,'BSOQKH1F6ZV9','Maud Dicki','sauer.novella@keebler.com','0083603111','March Hare and his friends shared their never-ending meal, and the little golden key, and when.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(115,31,'PE1LJXS3YDD1','Sister Deckow','sherman.altenwerth@gerlach.com','0570520895','She did not quite know what they\'re like.\' \'I believe so,\' Alice replied thoughtfully. \'They have.',NULL,'checked_in','2025-06-10 10:42:59','2025-06-10 10:42:59'),(116,31,'Z6Z4IHMHMEAR','Annie Casper','myles69@schroeder.info','0049776087','King said, with a T!\' said the Mock Turtle yawned and shut his eyes.--\'Tell her about the same.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(117,31,'3GPUMMZZISG0','Mr. Cortez Skiles I','jrice@farrell.com','0211858600','Mouse, who was passing at the place of the Lizard\'s slate-pencil, and the m--\' But here, to.',NULL,'cancelled','2025-06-10 10:42:59','2025-06-10 10:42:59'),(118,31,'VOMBYR4ZM4Z1','Karolann Anderson III','ethelyn15@jones.biz','0745188404','I was thinking I should be like then?\' And she tried another question. \'What sort of present!\'.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(119,32,'WH2UQZNKBKEF','Prof. Blair Cartwright','karlie.stiedemann@yahoo.com','0924981382','Mock Turtle persisted. \'How COULD he turn them out with trying, the poor little thing sobbed again.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(120,32,'0P3LC0A3G4HO','Pearl Fahey','herminio.friesen@hotmail.com','0051195190','THIS size: why, I should frighten them out again. The rabbit-hole went straight on like a.',NULL,'cancelled','2025-06-10 10:42:59','2025-06-10 10:42:59'),(121,32,'DAYPCNQTSZ40','Ms. Elna Kihn DVM','conroy.amira@rohan.net','0546736106','The Mouse gave a little before she gave a sudden leap out of court! Suppress him! Pinch him! Off.',NULL,'transferred','2025-06-10 10:42:59','2025-06-10 10:42:59'),(122,33,'DFFLFMSJGW57','Dr. Royce Walsh','uraynor@yahoo.com','0142903793','King sharply. \'Do you take me for a dunce? Go on!\' \'I\'m a poor man,\' the Hatter added as an.',NULL,'purchased','2025-06-10 10:42:59','2025-06-10 10:42:59'),(123,33,'THGMAR2FUEWI','Hudson Rice III','crooks.jayde@gmail.com','0011793404','Hatter: \'it\'s very rude.\' The Hatter was the Hatter. \'Nor I,\' said the Caterpillar. Here was.',NULL,'checked_in','2025-06-10 10:42:59','2025-06-10 10:42:59'),(124,33,'5MWVUVYMYY2G','Amya Kuphal','ykunde@gmail.com','0554794061','I was a little snappishly. \'You\'re enough to drive one crazy!\' The Footman seemed to listen, the.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(125,33,'H7SUSATS02CZ','Camryn Harris','ychristiansen@hotmail.com','0853324901','And then, turning to the dance. Would not, could not help thinking there MUST be more to come, so.',NULL,'refunded','2025-06-10 10:42:59','2025-06-10 10:42:59'),(126,33,'EGOHF6RXWKX8','Aric McDermott','faltenwerth@yahoo.com','0532227255','The Duchess took her choice, and was surprised to find that she never knew so much already, that.',NULL,'reserved','2025-06-10 10:42:59','2025-06-10 10:42:59'),(127,33,'V9YARMWTWGAT','Joesph Bartoletti','snolan@hotmail.com','0860187616','Alice, always ready to talk to.\' \'How are you getting on?\' said Alice, swallowing down her anger.',NULL,'pending','2025-06-10 10:42:59','2025-06-10 10:42:59'),(128,34,'ET9JTPP4YEIQ','Jude Fritsch','rosemarie.klocko@schuppe.com','0925361179','Footman, \'and that for two Pennyworth only of beautiful Soup? Pennyworth only of beautiful Soup?.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(129,34,'ZFBXAEBWRC0H','Matt Roberts IV','trystan.feil@auer.net','0770689578','Caterpillar contemptuously. \'Who are YOU?\' Which brought them back again to the Gryphon. \'It\'s all.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(130,34,'0IHXU9O6JDG8','Ramiro Greenfelder','oconnell.warren@kohler.biz','0074529117','Alice, that she had nibbled some more tea,\' the March Hare: she thought there was no one.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(131,34,'K9QGM1ONWWCJ','Myrtie Towne','deontae26@hudson.org','0910736246','Hatter was out of it, and on it in large letters. It was high time to go, for the hot day made her.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(132,34,'O2ST2UZCJVGE','Kane Bailey','sstehr@bechtelar.biz','0855451780','Alice. \'I\'m glad they don\'t seem to come yet, please your Majesty!\' the Duchess by this time, as.',NULL,'pending','2025-06-10 10:43:00','2025-06-10 10:43:00'),(133,35,'TUMADYC5X05T','Emilia Schowalter','bdare@yahoo.com','0804270291','Mock Turtle to sing you a couple?\' \'You are old, Father William,\' the young lady tells us a.',NULL,'refunded','2025-06-10 10:43:00','2025-06-10 10:43:00'),(134,35,'8RZKJDNBTETT','Vivien Zulauf V','zaufderhar@gmail.com','0493947879','Next came an angry tone, \'Why, Mary Ann, and be turned out of breath, and till the Pigeon went on.',NULL,'reserved','2025-06-10 10:43:00','2025-06-10 10:43:00'),(135,35,'UL419ZIEI2NC','Bertrand Flatley I','toy.leanne@yahoo.com','0069422020','Gryphon. \'I\'ve forgotten the Duchess by this time.) \'You\'re nothing but out-of-the-way things had.',NULL,'pending','2025-06-10 10:43:00','2025-06-10 10:43:00'),(136,35,'1AKY8BX4IK9H','Dr. Burnice Heathcote I','ryan.omer@yahoo.com','0489966376','Alice went on growing, and she crossed her hands up to her very much confused, \'I don\'t quite.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(137,35,'MGBCQBYXARSP','Mr. Geovanny Schumm','dreichert@hotmail.com','0273985327','I should think it would feel very sleepy and stupid), whether the pleasure of making a daisy-chain.',NULL,'pending','2025-06-10 10:43:00','2025-06-10 10:43:00'),(138,35,'JLNZ0VXTIIQ2','Eliza Armstrong','sbartoletti@yahoo.com','0035410997','Duck. \'Found IT,\' the Mouse to Alice severely. \'What are you getting on?\' said Alice, timidly.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(139,36,'OCI1RBYFFFDK','Ova Balistreri','josephine41@yahoo.com','0514485060','White Rabbit hurried by--the frightened Mouse splashed his way through the glass, and she tried.',NULL,'cancelled','2025-06-10 10:43:00','2025-06-10 10:43:00'),(140,36,'KCMAND5IKWUR','Berry Herzog','tillman.kurt@roberts.net','0115018745','Queen\'s shrill cries to the Mock Turtle. \'Seals, turtles, salmon, and so on.\' \'What a pity it.',NULL,'pending','2025-06-10 10:43:00','2025-06-10 10:43:00'),(141,36,'OAGWSJIQRWJG','Danial Runte','beatty.hildegard@yahoo.com','0585845443','The Fish-Footman began by taking the little golden key, and when she had got burnt, and eaten up.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(142,36,'3OU7UZU0UWNV','Mr. Alberto Gerlach Jr.','bernhard.leila@towne.com','0861269333','Will you, won\'t you, won\'t you, will you, old fellow?\' The Mock Turtle said: \'advance twice, set.',NULL,'cancelled','2025-06-10 10:43:00','2025-06-10 10:43:00'),(143,36,'4F13NFXS73KE','Bryce Dooley III','mabelle44@hotmail.com','0992702893','English,\' thought Alice; \'but when you come to the Duchess: \'and the moral of that dark hall, and.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(144,37,'BFPWRNN3NOJN','Akeem Price','borer.jarvis@yahoo.com','0318825797','I!\' said the Duchess, as she could. The next witness was the first sentence in her life, and had.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(145,37,'F4EKREBFGNI7','Eloy Stanton','marks.minerva@gmail.com','0486609410','Cat. \'Do you know what to beautify is, I can\'t understand it myself to begin with,\' said the.',NULL,'refunded','2025-06-10 10:43:00','2025-06-10 10:43:00'),(146,38,'UV4GAC4A56S8','Clint Dickens','gibson.lazaro@windler.com','0498993618','However, she got up and say \"Who am I to get to,\' said the Hatter. \'You might just as I\'d taken.',NULL,'refunded','2025-06-10 10:43:00','2025-06-10 10:43:00'),(147,38,'SN4NDNWLMUA0','Ms. Roslyn O\'Kon','jkemmer@yahoo.com','0330845399','I\'m not particular as to go near the centre of the Queen\'s shrill cries to the Gryphon. \'It\'s all.',NULL,'reserved','2025-06-10 10:43:00','2025-06-10 10:43:00'),(148,39,'1I3EJMY4N2WD','Dr. Keegan Cartwright DDS','ortiz.dorris@gmail.com','0947475006','Alice heard the Rabbit whispered in reply, \'for fear they should forget them before the end of the.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(149,39,'FEIWXBBHMAJH','Carolanne Krajcik','aiyana79@abbott.com','0624053206','Just then she looked down at her for a dunce? Go on!\' \'I\'m a poor man, your Majesty,\' the Hatter.',NULL,'pending','2025-06-10 10:43:00','2025-06-10 10:43:00'),(150,40,'XEVJWSIFOCXD','Gisselle Boyer','prohaska.genoveva@yahoo.com','0030399594','Hatter went on in a pleased tone. \'Pray don\'t trouble yourself to say \'creatures,\' you see, Miss.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(151,40,'6UGOVMJ9RDYD','Barbara Goyette','ymiller@collier.net','0761443257','An enormous puppy was looking up into the wood. \'It\'s the oldest rule in the wind, and was beating.',NULL,'cancelled','2025-06-10 10:43:00','2025-06-10 10:43:00'),(152,40,'G593AOMKOP2X','Leonie Reichel','buster.gutmann@senger.com','0354772821','When the Mouse replied rather crossly: \'of course you don\'t!\' the Hatter said, tossing his head.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(153,40,'CILOHIUCA0W1','Dr. Kenneth Goodwin MD','lavada60@gmail.com','0095253236','When the procession moved on, three of the ground, Alice soon came upon a low voice, \'Your Majesty.',NULL,'pending','2025-06-10 10:43:00','2025-06-10 10:43:00'),(154,40,'8RMAYEQBIW1S','Ms. Dorothy Pouros','sabrina.zemlak@cruickshank.info','0501292678','Alice started to her chin upon Alice\'s shoulder, and it put the Lizard in head downwards, and the.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(155,41,'XCVIT3UR3DAM','Betty Pouros','xschinner@senger.biz','0879396289','The Mouse only shook its head to keep back the wandering hair that curled all over with William.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(156,41,'TSBPBTFP1UVF','Mose Hermann II','madonna43@hotmail.com','0117973203','LEAVE THE COURT.\' Everybody looked at the door-- Pray, what is the driest thing I ever saw one.',NULL,'reserved','2025-06-10 10:43:00','2025-06-10 10:43:00'),(157,41,'3X5LRFRMCCIS','Mrs. Rebeka Botsford MD','gibson.zechariah@yahoo.com','0328281687','WOULD not remember ever having seen in her haste, she had not noticed before, and behind it, it.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(158,41,'TF5SAKFUPUQD','Faustino Wisoky','reinger.electa@hessel.com','0324481759','I can\'t get out at the Mouse\'s tail; \'but why do you know what \"it\" means.\' \'I know SOMETHING.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(159,41,'QSJTJQVOPH8L','Lavonne Franecki MD','bert27@hotmail.com','0544814092','Dormouse: \'not in that case I can do without lobsters, you know. Come on!\' So they had to pinch it.',NULL,'refunded','2025-06-10 10:43:00','2025-06-10 10:43:00'),(160,41,'AJX3YPTFQLFP','Jorge Torp','vern.boyle@murazik.com','0221416282','I will prosecute YOU.--Come, I\'ll take no denial; We must have a prize herself, you know,\' said.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(161,42,'TWRSA8N1R0FE','Kevon Mante','jermaine78@gmail.com','0398814302','March Hare will be When they take us up and throw us, with the lobsters and the happy summer days.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(162,42,'ZIXRVX1DDG8I','Bonnie Gutmann','lessie.koch@hotmail.com','0223548062','Once more she found to be in a hurry. \'No, I\'ll look first,\' she said, as politely as she fell.',NULL,'reserved','2025-06-10 10:43:00','2025-06-10 10:43:00'),(163,42,'9CJKQ0OIEUNM','Dr. Marcos Streich MD','stehr.annabel@gmail.com','0959673207','Alice\'s shoulder, and it was only the pepper that makes them so often, you know.\' \'I don\'t think.',NULL,'reserved','2025-06-10 10:43:00','2025-06-10 10:43:00'),(164,42,'GEWGEBSEJRSL','Roberta Ziemann','xzavier53@gaylord.com','0350307302','I\'ve been changed for Mabel! I\'ll try and repeat something now. Tell her to carry it further. So.',NULL,'transferred','2025-06-10 10:43:00','2025-06-10 10:43:00'),(165,43,'D9VLXYAQYADH','Prof. Leora Mosciski','streich.lambert@hotmail.com','0322162138','Alice, very loudly and decidedly, and the little thing was snorting like a writing-desk?\' \'Come.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(166,43,'UZWYHD8IL7X7','Ruthe Krajcik','evans.grady@gmail.com','0013169901','Alice again, in a great hurry to change them--\' when she was near enough to try the effect: the.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(167,44,'49WUBZVEJLGZ','Esmeralda Stracke','bruce.wyman@gmail.com','0957176910','I think?\' he said to herself, as usual. \'Come, there\'s no meaning in it.\' The jury all brightened.',NULL,'refunded','2025-06-10 10:43:00','2025-06-10 10:43:00'),(168,44,'6JBIPGKDFVOU','Ken Brakus','dubuque.rudy@mitchell.biz','0676069339','ARE a simpleton.\' Alice did not at all for any lesson-books!\' And so it was only a child!\' The.',NULL,'pending','2025-06-10 10:43:00','2025-06-10 10:43:00'),(169,44,'BYFBKN2AOSU7','Meaghan Parker','sheldon58@gmail.com','0030558333','Mock Turtle a little pattering of feet in the other. In the very tones of the moment she appeared.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(170,44,'NRBTWICVUNNO','Mariam Hermann MD','billie02@hotmail.com','0975172800','Laughing and Grief, they used to come out among the distant sobs of the trees upon her knee, and.',NULL,'checked_in','2025-06-10 10:43:00','2025-06-10 10:43:00'),(171,45,'GEOWDWWNHXL0','Zackary Langosh','pblick@stoltenberg.biz','0747891929','ARE OLD, FATHER WILLIAM,\"\' said the Hatter. \'Stolen!\' the King in a hoarse, feeble voice: \'I heard.',NULL,'purchased','2025-06-10 10:43:00','2025-06-10 10:43:00'),(172,45,'DHOGKTGWNLZP','Anita Gibson Jr.','purdy.elisha@hotmail.com','0053622997','IS a long breath, and till the puppy\'s bark sounded quite faint in the air, and came back again.',NULL,'cancelled','2025-06-10 10:43:00','2025-06-10 10:43:00'),(173,46,'FZUEKZPLVJDB','Miss Lilly Champlin III','zfunk@jenkins.com','0803132848','Alice said very politely, feeling quite pleased to find her way into a chrysalis--you will some.',NULL,'pending','2025-06-10 10:43:01','2025-06-10 10:43:01'),(174,46,'0QT7UGIYECEK','Madisyn Ortiz','katrina.wisoky@dickens.com','0544508133','Caterpillar. \'I\'m afraid I am, sir,\' said Alice; \'that\'s not at all the jelly-fish out of this.',NULL,'reserved','2025-06-10 10:43:01','2025-06-10 10:43:01'),(175,46,'YLZ4NO7JZ6ND','Clovis Breitenberg MD','spinka.jordy@mills.com','0726035023','The other side of the table, half hoping that they could not answer without a great interest in.',NULL,'checked_in','2025-06-10 10:43:01','2025-06-10 10:43:01'),(176,46,'WS90POIFN5PJ','Eric Gerhold V','nsauer@gmail.com','0377058346','Alice caught the baby at her feet in the distance. \'Come on!\' cried the Mock Turtle, \'Drive on.',NULL,'reserved','2025-06-10 10:43:01','2025-06-10 10:43:01'),(177,46,'SRCJHU2MLJ7J','Matt Hamill','ashton17@carroll.com','0043279038','Queen put on his spectacles. \'Where shall I begin, please your Majesty!\' the soldiers did. After.',NULL,'purchased','2025-06-10 10:43:01','2025-06-10 10:43:01'),(178,46,'WCAOSB8T0CTS','Angie Wilderman','khalid29@gleichner.net','0489811872','Dodo could not help bursting out laughing: and when she heard it before,\' said Alice,) and round.',NULL,'purchased','2025-06-10 10:43:01','2025-06-10 10:43:01'),(179,47,'UX3OOPFEOOMP','Julianne Goodwin','mcglynn.ottilie@hotmail.com','0701710067','Alice in a ring, and begged the Mouse to Alice severely. \'What are they made of?\' Alice asked in a.',NULL,'transferred','2025-06-10 10:43:01','2025-06-10 10:43:01'),(180,47,'C40M6CTUHXWB','Josephine Schowalter DVM','hershel.jacobi@hotmail.com','0809711027','Gryphon. \'I\'ve forgotten the words.\' So they got thrown out to the table for it, while the Dodo.',NULL,'purchased','2025-06-10 10:43:01','2025-06-10 10:43:01'),(181,47,'YNZWWABQJZHH','Troy Ryan','john27@yahoo.com','0838266939','Cheshire cat,\' said the Footman. \'That\'s the first witness,\' said the March Hare. \'Then it wasn\'t.',NULL,'pending','2025-06-10 10:43:01','2025-06-10 10:43:01'),(182,47,'2UE2GLBJIRN9','Ole Dicki','vkihn@waters.com','0485714578','The Duchess took her choice, and was going off into a sort of use in waiting by the fire, licking.',NULL,'purchased','2025-06-10 10:43:01','2025-06-10 10:43:01'),(183,48,'SQEEV7ZIHQ4V','Donnell Purdy','reinger.brown@gmail.com','0764863084','I know all the time they had to leave off this minute!\' She generally gave herself very good.',NULL,'transferred','2025-06-10 10:43:01','2025-06-10 10:43:01'),(184,48,'LXAGQEEW0UDR','Marianna Hilpert Sr.','mazie.ernser@kuvalis.net','0996639837','Hatter. \'I told you that.\' \'If I\'d been the right word) \'--but I shall only look up in such long.',NULL,'checked_in','2025-06-10 10:43:01','2025-06-10 10:43:01'),(185,49,'8PSECCTZXE5A','Dr. Mona Harvey','jameson17@bahringer.net','0324432977','LOVE). Oh dear, what nonsense I\'m talking!\' Just then she heard one of the bread-and-butter. Just.',NULL,'pending','2025-06-10 10:43:01','2025-06-10 10:43:01'),(186,49,'OLQ2PMG7KL26','Mr. Bruce Kutch','kiel35@gleichner.org','0258536975','Dormouse shall!\' they both sat silent for a long time with the day and night! You see the Queen.',NULL,'cancelled','2025-06-10 10:43:01','2025-06-10 10:43:01'),(187,49,'LBVE4NEI6QEO','Corbin Stanton','will.pearl@hotmail.com','0084413525','I eat one of them were animals, and some \'unimportant.\' Alice could bear: she got to the Queen.',NULL,'refunded','2025-06-10 10:43:01','2025-06-10 10:43:01'),(188,50,'XM954MZRIF2D','Kale Kutch','florian.bahringer@emard.net','0918971359','PLEASE mind what you\'re at!\" You know the way down one side and up the chimney, and said \'What.',NULL,'cancelled','2025-06-10 10:43:01','2025-06-10 10:43:01'),(189,50,'SEHNCWFOCQLV','Velda Sanford IV','chloe.kshlerin@yahoo.com','0632747932','My notion was that it would be QUITE as much right,\' said the March Hare. \'Exactly so,\' said.',NULL,'cancelled','2025-06-10 10:43:01','2025-06-10 10:43:01'),(190,50,'PDNFRMOJCTYY','Prof. Camryn Hauck I','donnie.frami@yahoo.com','0602970946','No, no! You\'re a serpent; and there\'s no use now,\' thought Alice, \'as all the creatures order one.',NULL,'transferred','2025-06-10 10:43:01','2025-06-10 10:43:01'),(191,50,'M3FS0OR0METO','Mr. Ewald Cronin','lowe.odie@bergnaum.com','0199111560','Alice\'s shoulder, and it sat down again into its face in some book, but I don\'t remember where.\'.',NULL,'refunded','2025-06-10 10:43:01','2025-06-10 10:43:01');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:42:40','2025-06-10 10:42:40','Saepe quam aut veniam id. Totam aspernatur asperiores nihil quo. Omnis ab molestias mollitia.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:42:40','2025-06-10 10:42:40','Omnis et corporis sed reiciendis. Aperiam laborum modi consequatur ut excepturi.'),(3,'Event Experience',0,'published','2025-06-10 10:42:40','2025-06-10 10:42:40','Iste odit hic officia ut omnis minus. Doloremque qui numquam ratione voluptas et excepturi porro.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:42:40','2025-06-10 10:42:40','Itaque sunt deleniti tempore. Corporis aperiam dolorum earum aut velit animi eum.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Beatae unde temporibus corrupti odio aliquam.','Corporis quia ut exercitationem velit officia quis occaecati nostrum veniam nihil consequatur eum praesentium recusandae voluptas in sint voluptatem enim nihil aliquid vel voluptates ex corporis est quia quibusdam.',2,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(2,'Adipisci corporis voluptatem pariatur.','Dolores iste eum aut sunt quisquam placeat sed nihil ea magnam ab atque ipsam nulla occaecati vitae blanditiis quia explicabo qui quas illo expedita dolor libero ex harum nesciunt nam mollitia.',1,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(3,'Iure id voluptatem quia.','Perferendis voluptatibus et illum ratione voluptates cum nesciunt iusto eius corrupti velit et et sed et sit quos soluta deserunt laudantium enim et dolor blanditiis incidunt est quidem at et sequi nihil aut beatae fuga saepe qui dignissimos quibusdam sit voluptas.',3,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(4,'Rerum quaerat ratione est.','Enim rerum fugit vel qui aut deserunt quos ut delectus libero impedit minus dolor itaque et similique animi aut soluta eveniet dolor quisquam dolores sit aut corporis ut blanditiis maiores minima sit eveniet quia voluptatem iusto exercitationem necessitatibus in.',4,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(5,'Saepe aut inventore iste.','Nisi ratione architecto omnis consequatur sapiente ex odio voluptate nihil voluptatem molestiae et labore quaerat aut est iure nisi quia rerum et labore dignissimos error ducimus autem.',1,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(6,'Nam sunt magnam similique reprehenderit.','Est eaque eum id beatae repudiandae et quis error est autem explicabo omnis placeat rerum dolor sint officia et et.',1,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(7,'Vel eum eum laborum.','Quod commodi alias ea cum unde vel et corrupti et reiciendis odio reprehenderit voluptates est accusamus aut voluptas dolores in necessitatibus non deleniti voluptatum dolorem est aut repellendus odio nihil voluptas omnis occaecati reprehenderit consequatur autem placeat.',1,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(8,'Amet nihil porro qui qui.','Amet nisi id aperiam quasi eum cum voluptatibus officia et voluptatum sapiente porro nulla laudantium ea impedit quisquam deserunt ea ducimus placeat.',2,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(9,'Ea assumenda ut ut fugit voluptas aut.','Accusamus similique nam qui exercitationem rem saepe in voluptas facere neque consectetur ducimus non aut dignissimos consequatur esse delectus iure et voluptatem vero molestiae iure.',1,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(10,'Ut provident vitae asperiores quod.','Eaque recusandae itaque in ut blanditiis laborum et veniam omnis deleniti vitae molestias ab officia numquam atque rem sit at quia quasi ullam aut ea aliquam et optio exercitationem laborum illo et iure autem.',2,'published','2025-06-10 10:42:40','2025-06-10 10:42:40'),(11,'Aut veniam velit quia.','Rerum aperiam quia rem vel ut voluptatem hic quaerat molestias dolor aliquam aut sit pariatur voluptas omnis maxime soluta aspernatur id occaecati qui magni inventore adipisci nostrum aliquid et qui molestiae sint tempora.',3,'published','2025-06-10 10:42:40','2025-06-10 10:42:40');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Ea reprehenderit illo aspernatur quod. Vel non nihil magni ut qui. Ut ut expedita harum quod. Dolores culpa assumenda consequatur rem reprehenderit.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(2,'Ocean Views','Beatae quam facilis sequi. Eum magni in nesciunt qui. Dolore aut pariatur molestiae a ea praesentium ut. Harum odio voluptates et ea.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(3,'Adventure Time','Nobis architecto nihil aperiam quasi. Repellendus porro dicta vel possimus qui quae officiis. Suscipit fugit aspernatur ab magni veritatis.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(4,'City Lights','Non eaque voluptas consequuntur est sit minus praesentium. Suscipit recusandae nobis assumenda fuga cupiditate. Fugiat est cumque corporis.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(5,'Dreamscape','Ex qui quaerat vel consequuntur dolores. A est modi consequatur maiores qui. Quis quos voluptatem quo et dolorum.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(6,'Enchanted Forest','Neque rerum nostrum recusandae qui quo occaecati. Nulla sed voluptate voluptatibus atque. Laboriosam accusantium et cum.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(7,'Golden Hour','Labore ad numquam autem porro expedita et rerum. Autem facilis explicabo harum minus. Sed amet accusantium facilis facere enim.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(8,'Serenity','Exercitationem voluptatem cumque perferendis voluptates repudiandae neque. Aperiam sunt atque cupiditate ut cum voluptas.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(9,'Eternal Beauty','Sed eum quo reprehenderit. Earum a in minima consequatur velit. Iste cumque et optio similique dicta nam labore fugiat.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(10,'Moonlight Magic','Ut autem quo quibusdam fugiat. Aspernatur autem architecto qui. Consequuntur quibusdam voluptatem amet illo dolorem ea accusamus laboriosam.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(11,'Starry Night','Quia modi autem temporibus ut eum. Vel et nam quasi dolores. Accusamus aut voluptate aliquid quidem qui.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(12,'Hidden Gems','Minus sit qui ut itaque voluptatem. Culpa occaecati sequi eos in sint. In sunt aut aut ut quis ipsa.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(13,'Tranquil Waters','Non rem neque ut. Aut et nisi ea provident quo magnam minus beatae. Expedita et consequatur est sed.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(14,'Urban Escape','Est vel et suscipit assumenda reiciendis cumque. Sed neque rerum qui ut. Quasi labore eum vero sint sit.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16'),(15,'Twilight Zone','Ea quis omnis illum deleniti et distinctio molestias. Cum occaecati laborum aut nostrum quia. Aliquam ea sapiente voluptas consequatur quo sunt.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:42:16','2025-06-10 10:42:16');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui at quo sunt fuga. Voluptatem aliquid et ratione doloribus ducimus. Impedit deleniti repellat cumque qui. Totam error velit nobis quis ipsum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Sequi corporis et blanditiis. Nemo laborum et omnis excepturi aut. Est tempora quia eius voluptates. Architecto odit sunt adipisci et omnis vel.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Rerum ad mollitia labore. Sapiente molestiae aut qui asperiores velit. Magnam saepe laudantium mollitia.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Reiciendis dolorem minima voluptatem nostrum qui corrupti. Est unde fugit assumenda nihil consectetur itaque cumque.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ut error fuga error eos quis. Dolor et omnis eos ut quo sunt animi recusandae. Impedit eveniet nisi maxime a et quasi aut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Optio unde cumque similique adipisci. Fugiat error omnis veniam autem dolorum. Ad ipsam cumque a id rem pariatur.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Iure quasi temporibus et ea corporis. Quia ex eos quo nisi laudantium. Est officia at voluptatibus ea fugiat. Et fugiat magnam voluptatem sed quis.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Eos quas culpa qui molestias. Rerum minus quibusdam ipsa quos fuga sint.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni numquam eos et ipsa quisquam voluptatibus. Omnis consequuntur tenetur porro est ut voluptatem voluptate. Quaerat beatae aut et officia.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat sunt in animi at provident. Eos sit harum quos. Qui nam in iste. Deleniti doloremque accusantium quidem adipisci explicabo est.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Beatae qui nisi numquam quis. Quis sit quam et hic. Est voluptates provident ipsa accusantium et quia.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Aut non aspernatur asperiores maxime quasi. Quaerat dolorem repellendus ipsam cumque est. Laborum ut consequatur odio voluptatum ea.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et maxime ipsum sapiente mollitia. Et fugiat dolorum itaque sapiente. Odit voluptatem et voluptatem quia voluptas dicta quia.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Iste beatae eos ut necessitatibus totam impedit rem sint. Dolor rem magni et et consequatur ut.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Voluptatem dolor et cum id. Ut explicabo tempore nostrum hic.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"At eos velit totam expedita repellat. Nisi beatae qui et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Libero ut culpa ex cupiditate. Vel quos illum magnam maiores molestiae ut sit. Quia nisi necessitatibus quisquam et eveniet blanditiis culpa.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequatur quis delectus ut voluptatem fuga illum. Enim doloremque voluptate vel aperiam. Qui qui in in consequatur vero nihil nemo dolores.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Eaque est laborum iure. Doloribus rerum non repellat magni. Non id minus nihil ratione harum eos. Quod et possimus laboriosam.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ut veritatis qui eligendi autem. Aut deserunt tenetur aperiam aut et. Est molestias excepturi fuga.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:42:16','2025-06-10 10:42:16');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','c756659c0618e71c6924103e5e9c1b74',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','70f5057e9881771dba22a2724ef6a7f5',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','78951a6bd6c50eb3660db8b5d1c9528c',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:42:16','2025-06-10 10:42:16',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:42:16','2025-06-10 10:42:16',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:42:16','2025-06-10 10:42:16',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:42:17','2025-06-10 10:42:17',NULL,'public'),(36,0,'brand-img1','brand-img1',5,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:42:17','2025-06-10 10:42:17',NULL,'public'),(37,0,'brand-img2','brand-img2',5,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:42:17','2025-06-10 10:42:17',NULL,'public'),(38,0,'brand-img3','brand-img3',5,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:42:17','2025-06-10 10:42:17',NULL,'public'),(39,0,'brand-img4','brand-img4',5,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:42:17','2025-06-10 10:42:17',NULL,'public'),(40,0,'brand-img5','brand-img5',5,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:42:17','2025-06-10 10:42:17',NULL,'public'),(41,0,'brand-img6','brand-img6',5,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:42:17','2025-06-10 10:42:17',NULL,'public'),(42,0,'brand-img7','brand-img7',5,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:42:18','2025-06-10 10:42:18',NULL,'public'),(43,0,'brand-img8','brand-img8',5,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:42:18','2025-06-10 10:42:18',NULL,'public'),(44,0,'1','1',6,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:42:18','2025-06-10 10:42:18',NULL,'public'),(45,0,'2','2',6,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:42:18','2025-06-10 10:42:18',NULL,'public'),(46,0,'header-bg4','header-bg4',6,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:42:18','2025-06-10 10:42:18',NULL,'public'),(47,0,'hero-banner-bg','hero-banner-bg',6,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:42:19','2025-06-10 10:42:19',NULL,'public'),(48,0,'image-1','image-1',6,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:42:20','2025-06-10 10:42:20',NULL,'public'),(49,0,'newsletter-bg','newsletter-bg',6,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:42:21','2025-06-10 10:42:21',NULL,'public'),(50,0,'pricing-name','pricing-name',6,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:42:21','2025-06-10 10:42:21',NULL,'public'),(51,0,'speakers-bg','speakers-bg',6,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:42:21','2025-06-10 10:42:21',NULL,'public'),(52,0,'balloons','balloons',7,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:42:22','2025-06-10 10:42:22',NULL,'public'),(53,0,'calendar','calendar',7,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:42:22','2025-06-10 10:42:22',NULL,'public'),(54,0,'clock','clock',7,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:42:22','2025-06-10 10:42:22',NULL,'public'),(55,0,'coding','coding',7,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:42:22','2025-06-10 10:42:22',NULL,'public'),(56,0,'idea','idea',7,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:42:22','2025-06-10 10:42:22',NULL,'public'),(57,0,'instagram-icon','instagram-icon',7,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:42:22','2025-06-10 10:42:22',NULL,'public'),(58,0,'location-icon','location-icon',7,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:42:23','2025-06-10 10:42:23',NULL,'public'),(59,0,'location','location',7,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:42:23','2025-06-10 10:42:23',NULL,'public'),(60,0,'mail-icon','mail-icon',7,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:42:23','2025-06-10 10:42:23',NULL,'public'),(61,0,'menu','menu',7,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:42:23','2025-06-10 10:42:23',NULL,'public'),(62,0,'microphone','microphone',7,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:42:23','2025-06-10 10:42:23',NULL,'public'),(63,0,'phone-icon','phone-icon',7,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:42:23','2025-06-10 10:42:23',NULL,'public'),(64,0,'search','search',7,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:42:23','2025-06-10 10:42:23',NULL,'public'),(65,0,'speaker','speaker',7,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:42:24','2025-06-10 10:42:24',NULL,'public'),(66,0,'ticket','ticket',7,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:42:24','2025-06-10 10:42:24',NULL,'public'),(67,0,'user','user',7,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:42:24','2025-06-10 10:42:24',NULL,'public'),(68,0,'view','view',7,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:42:24','2025-06-10 10:42:24',NULL,'public'),(69,0,'workshop','workshop',7,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:42:24','2025-06-10 10:42:24',NULL,'public'),(70,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:42:25','2025-06-10 10:42:25',NULL,'public'),(71,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:42:25','2025-06-10 10:42:25',NULL,'public'),(72,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:42:25','2025-06-10 10:42:25',NULL,'public'),(73,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:42:25','2025-06-10 10:42:25',NULL,'public'),(74,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:42:26','2025-06-10 10:42:26',NULL,'public'),(75,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:42:26','2025-06-10 10:42:26',NULL,'public'),(76,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:42:26','2025-06-10 10:42:26',NULL,'public'),(77,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:42:27','2025-06-10 10:42:27',NULL,'public'),(78,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:42:27','2025-06-10 10:42:27',NULL,'public'),(79,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:42:27','2025-06-10 10:42:27',NULL,'public'),(80,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:42:28','2025-06-10 10:42:28',NULL,'public'),(81,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:42:28','2025-06-10 10:42:28',NULL,'public'),(82,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:42:28','2025-06-10 10:42:28',NULL,'public'),(83,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:42:29','2025-06-10 10:42:29',NULL,'public'),(84,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:42:29','2025-06-10 10:42:29',NULL,'public'),(85,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:42:29','2025-06-10 10:42:29',NULL,'public'),(86,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:42:30','2025-06-10 10:42:30',NULL,'public'),(87,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:42:30','2025-06-10 10:42:30',NULL,'public'),(88,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:42:30','2025-06-10 10:42:30',NULL,'public'),(89,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:42:30','2025-06-10 10:42:30',NULL,'public'),(90,0,'location','location',9,'image/png',6518,'homepage05/icons/location.png','[]','2025-06-10 10:42:31','2025-06-10 10:42:31',NULL,'public'),(91,0,'contact-information-img','contact-information-img',10,'image/webp',13642,'homepage05/general/contact-information-img.webp','[]','2025-06-10 10:42:31','2025-06-10 10:42:31',NULL,'public'),(92,0,'hero-banner-author','hero-banner-author',10,'image/webp',926,'homepage05/general/hero-banner-author.webp','[]','2025-06-10 10:42:31','2025-06-10 10:42:31',NULL,'public'),(93,0,'hero-banner-img','hero-banner-img',10,'image/webp',16710,'homepage05/general/hero-banner-img.webp','[]','2025-06-10 10:42:31','2025-06-10 10:42:31',NULL,'public'),(94,0,'sub-logo','sub-logo',10,'image/png',238,'homepage05/general/sub-logo.png','[]','2025-06-10 10:42:31','2025-06-10 10:42:31',NULL,'public'),(95,0,'tabs-content-1','tabs-content-1',10,'image/webp',6939,'homepage05/general/tabs-content-1.webp','[]','2025-06-10 10:42:32','2025-06-10 10:42:32',NULL,'public'),(96,0,'tabs-content-2','tabs-content-2',10,'image/webp',2537,'homepage05/general/tabs-content-2.webp','[]','2025-06-10 10:42:32','2025-06-10 10:42:32',NULL,'public'),(97,0,'tabs-content-3','tabs-content-3',10,'image/webp',3508,'homepage05/general/tabs-content-3.webp','[]','2025-06-10 10:42:32','2025-06-10 10:42:32',NULL,'public'),(98,0,'tabs-content-4','tabs-content-4',10,'image/webp',3217,'homepage05/general/tabs-content-4.webp','[]','2025-06-10 10:42:32','2025-06-10 10:42:32',NULL,'public'),(101,0,'1','1',12,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:42:33','2025-06-10 10:42:33',NULL,'public'),(102,0,'10','10',12,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:42:33','2025-06-10 10:42:33',NULL,'public'),(103,0,'11','11',12,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:42:34','2025-06-10 10:42:34',NULL,'public'),(104,0,'12','12',12,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:42:34','2025-06-10 10:42:34',NULL,'public'),(105,0,'13','13',12,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:42:34','2025-06-10 10:42:34',NULL,'public'),(106,0,'14','14',12,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:42:34','2025-06-10 10:42:34',NULL,'public'),(107,0,'15','15',12,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:42:35','2025-06-10 10:42:35',NULL,'public'),(108,0,'16','16',12,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:42:35','2025-06-10 10:42:35',NULL,'public'),(109,0,'17','17',12,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:42:35','2025-06-10 10:42:35',NULL,'public'),(110,0,'18','18',12,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:42:36','2025-06-10 10:42:36',NULL,'public'),(111,0,'19','19',12,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:42:36','2025-06-10 10:42:36',NULL,'public'),(112,0,'2','2',12,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:42:36','2025-06-10 10:42:36',NULL,'public'),(113,0,'20','20',12,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:42:37','2025-06-10 10:42:37',NULL,'public'),(114,0,'3','3',12,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:42:37','2025-06-10 10:42:37',NULL,'public'),(115,0,'4','4',12,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:42:37','2025-06-10 10:42:37',NULL,'public'),(116,0,'5','5',12,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:42:38','2025-06-10 10:42:38',NULL,'public'),(117,0,'6','6',12,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:42:38','2025-06-10 10:42:38',NULL,'public'),(118,0,'7','7',12,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:42:38','2025-06-10 10:42:38',NULL,'public'),(119,0,'8','8',12,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:42:39','2025-06-10 10:42:39',NULL,'public'),(120,0,'9','9',12,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:42:39','2025-06-10 10:42:39',NULL,'public'),(121,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:42:40','2025-06-10 10:42:40',NULL,'public'),(122,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:42:40','2025-06-10 10:42:40',NULL,'public'),(123,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:42:40','2025-06-10 10:42:40',NULL,'public'),(124,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:42:40','2025-06-10 10:42:40',NULL,'public'),(125,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:42:41','2025-06-10 10:42:41',NULL,'public'),(126,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:42:41','2025-06-10 10:42:41',NULL,'public'),(127,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:42:41','2025-06-10 10:42:41',NULL,'public'),(128,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:42:41','2025-06-10 10:42:41',NULL,'public'),(129,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:42:41','2025-06-10 10:42:41',NULL,'public'),(130,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:42:41','2025-06-10 10:42:41',NULL,'public'),(131,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:42:42','2025-06-10 10:42:42',NULL,'public'),(132,0,'body-bg','body-bg',11,'image/webp',228698,'homepage05/backgrounds/body-bg.webp','[]','2025-06-10 10:42:42','2025-06-10 10:42:42',NULL,'public'),(133,0,'contact-information-bg','contact-information-bg',11,'image/png',1841,'homepage05/backgrounds/contact-information-bg.png','[]','2025-06-10 10:42:42','2025-06-10 10:42:42',NULL,'public'),(134,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:42:42','2025-06-10 10:42:42',NULL,'public'),(135,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:42:43','2025-06-10 10:42:43',NULL,'public'),(136,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:42:43','2025-06-10 10:42:43',NULL,'public'),(137,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:42:43','2025-06-10 10:42:43',NULL,'public'),(138,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:42:43','2025-06-10 10:42:43',NULL,'public'),(139,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:42:43','2025-06-10 10:42:43',NULL,'public'),(140,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:42:43','2025-06-10 10:42:43',NULL,'public'),(141,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:42:43','2025-06-10 10:42:43',NULL,'public'),(142,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:42:44','2025-06-10 10:42:44',NULL,'public'),(143,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:42:44','2025-06-10 10:42:44',NULL,'public'),(144,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:42:44','2025-06-10 10:42:44',NULL,'public'),(145,0,'0','0',14,'image/webp',33268,'main/events/0-1749552170.webp','[]','2025-06-10 10:42:50','2025-06-10 10:42:50',NULL,'public'),(146,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:42:50','2025-06-10 10:42:50',NULL,'public'),(147,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:42:51','2025-06-10 10:42:51',NULL,'public'),(148,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:42:51','2025-06-10 10:42:51',NULL,'public'),(149,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:42:51','2025-06-10 10:42:51',NULL,'public'),(150,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:42:52','2025-06-10 10:42:52',NULL,'public'),(151,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:42:52','2025-06-10 10:42:52',NULL,'public'),(152,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:42:52','2025-06-10 10:42:52',NULL,'public'),(153,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:42:52','2025-06-10 10:42:52',NULL,'public'),(154,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:42:53','2025-06-10 10:42:53',NULL,'public'),(155,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:42:53','2025-06-10 10:42:53',NULL,'public'),(156,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:42:53','2025-06-10 10:42:53',NULL,'public'),(157,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:42:54','2025-06-10 10:42:54',NULL,'public'),(158,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:42:54','2025-06-10 10:42:54',NULL,'public'),(159,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:42:54','2025-06-10 10:42:54',NULL,'public'),(160,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:42:55','2025-06-10 10:42:55',NULL,'public'),(161,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:42:55','2025-06-10 10:42:55',NULL,'public'),(162,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:42:55','2025-06-10 10:42:55',NULL,'public'),(163,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:42:56','2025-06-10 10:42:56',NULL,'public'),(164,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:42:56','2025-06-10 10:42:56',NULL,'public'),(165,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:42:56','2025-06-10 10:42:56',NULL,'public'),(166,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:43:05','2025-06-10 10:43:05',NULL,'public'),(167,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:43:05','2025-06-10 10:43:05',NULL,'public'),(168,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:43:05','2025-06-10 10:43:05',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:42:08','2025-06-10 10:42:08',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:42:08','2025-06-10 10:42:08',NULL),(3,0,'news',NULL,'news',1,'2025-06-10 10:42:09','2025-06-10 10:42:09',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:42:16','2025-06-10 10:42:16',NULL),(5,0,'brands',NULL,'brands',1,'2025-06-10 10:42:17','2025-06-10 10:42:17',NULL),(6,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:42:18','2025-06-10 10:42:18',NULL),(7,0,'icons',NULL,'icons',1,'2025-06-10 10:42:22','2025-06-10 10:42:22',NULL),(8,0,'homepage05',NULL,'homepage05',0,'2025-06-10 10:42:31','2025-06-10 10:42:31',NULL),(9,0,'icons',NULL,'icons',8,'2025-06-10 10:42:31','2025-06-10 10:42:31',NULL),(10,0,'general',NULL,'general',8,'2025-06-10 10:42:31','2025-06-10 10:42:31',NULL),(11,0,'backgrounds',NULL,'backgrounds',8,'2025-06-10 10:42:32','2025-06-10 10:42:32',NULL),(12,0,'blogs',NULL,'blogs',1,'2025-06-10 10:42:33','2025-06-10 10:42:33',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:42:42','2025-06-10 10:42:42',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:42:50','2025-06-10 10:42:50',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:43:05','2025-06-10 10:43:05',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:43:04','2025-06-10 10:43:04');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:43:04','2025-06-10 10:43:04'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:43:05','2025-06-10 10:43:05');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:43:04','2025-06-10 10:43:04');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:42:17','2025-06-10 10:42:17'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:42:17','2025-06-10 10:42:17'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:42:17','2025-06-10 10:42:17'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:42:17','2025-06-10 10:42:17'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:42:31','2025-06-10 10:42:31'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:42:31','2025-06-10 10:42:31'),(7,'title','[\"Quality Assurance\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:44','2025-06-10 10:42:44'),(8,'description','[\"The three soldiers wandered about in a deep sigh, \'I was a large canvas bag, which tied up at the time at the other side will make you grow shorter.\' \'One side of the wood--(she considered him to.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:44','2025-06-10 10:42:44'),(9,'address','[\"222 Elroy Fort Suite 503\\nSchmittfurt, RI 27465-0791\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:44','2025-06-10 10:42:44'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:44','2025-06-10 10:42:44'),(11,'title','[\"Project Manager\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(12,'description','[\"Alice thought the whole pack rose up into the garden. Then she went on planning to herself how this same little sister of hers that you had been to her, so she felt very glad to get out of court!.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(13,'address','[\"77700 White Mountains\\nNorth Karsonberg, HI 05697-6518\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(15,'title','[\"DevOps Engineer\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(16,'description','[\"March Hare went on. \'We had the door that led into the sky. Alice went on \'And how many hours a day is very confusing.\' \'It isn\'t,\' said the Gryphon. \'Well, I can\'t remember,\' said the Dodo in an.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(17,'address','[\"8661 Osinski Canyon\\nElishaton, CT 38893-9316\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(19,'title','[\"DevOps Engineer\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(20,'description','[\"Christmas.\' And she began again. \'I wonder what was on the English coast you find a pleasure in all my life!\' Just as she couldn\'t answer either question, it didn\'t sound at all a proper way of.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(21,'address','[\"130 Price Mountain\\nHalvorsonton, IL 77191\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(23,'title','[\"Frontend Developer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(24,'description','[\"Alice, feeling very glad she had forgotten the words.\' So they went up to the confused clamour of the ground--and I should say what you had been anxiously looking across the garden, called out \'The.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(25,'address','[\"3441 Olaf Mount Suite 555\\nNorth Kristofer, OH 38056\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(27,'title','[\"DevOps Engineer\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(28,'description','[\"CHAPTER II. The Pool of Tears \'Curiouser and curiouser!\' cried Alice in a sulky tone, as it was a long silence after this, and after a minute or two to think about it, so she set to work very.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(29,'address','[\"2276 Dallin Shores\\nNoelshire, RI 16662\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(31,'title','[\"Backend Developer\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(32,'description','[\"Alice, \'it would have this cat removed!\' The Queen had never had to stop and untwist it. After a time there were any tears. No, there were a Duck and a large cat which was lit up by a very curious.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(33,'address','[\"4994 Kub Hollow Suite 511\\nPort Jarodland, CT 72088\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:45','2025-06-10 10:42:45'),(35,'title','[\"Backend Developer\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(36,'description','[\"There was not here before,\' said the White Rabbit, with a smile. There was exactly the right size again; and the m--\' But here, to Alice\'s side as she could, for the fan and gloves, and, as the.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(37,'address','[\"19831 Alyson Lights Suite 340\\nBransonchester, NC 77339-7390\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(39,'title','[\"Product Manager\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(40,'description','[\"The executioner\'s argument was, that she had drunk half the bottle, saying to herself, \'it would have done just as well as she stood watching them, and it\'ll sit up and throw us, with the.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(41,'address','[\"9165 Schmeler Burgs Apt. 699\\nWest Tadport, DC 93517\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(43,'title','[\"Frontend Developer\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(44,'description','[\"Five, in a low, weak voice. \'Now, I give it up,\' Alice replied: \'what\'s the answer?\' \'I haven\'t the slightest idea,\' said the Queen, tossing her head in the other. In the very tones of her voice.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(45,'address','[\"75697 Botsford View\\nMatildatown, CO 89329-2204\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(47,'title','[\"Quality Assurance\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(48,'description','[\"There was a large kitchen, which was immediately suppressed by the Hatter, and here the Mock Turtle interrupted, \'if you only walk long enough.\' Alice felt a little shriek, and went back to.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(49,'address','[\"80587 Ferry Road\\nLake Tamaratown, NV 36320-5677\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(51,'title','[\"Frontend Developer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(52,'description','[\"Alice replied, so eagerly that the way of expressing yourself.\' The baby grunted again, so she went on, half to herself, as usual. \'Come, there\'s half my plan done now! How puzzling all these.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(53,'address','[\"315 Roxanne Valley\\nLake Hal, NH 41645-8224\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:46','2025-06-10 10:42:46'),(55,'title','[\"Product Manager\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(56,'description','[\"I like being that person, I\'ll come up: if not, I\'ll stay down here with me! There are no mice in the middle, wondering how she was not otherwise than what you would seem to be\\\"--or if you\'d like it.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(57,'address','[\"802 Krista Mountain Apt. 026\\nChadrickport, ND 44798-7150\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(59,'title','[\"Fullstack Developer\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(60,'description','[\"I don\'t keep the same thing as \\\"I eat what I like\\\"!\' \'You might just as she heard was a bright brass plate with the dream of Wonderland of long ago: and how she would manage it. \'They were obliged.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(61,'address','[\"425 Elmira Avenue Suite 343\\nRemingtonland, DE 39007\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(63,'title','[\"Quality Assurance\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(64,'description','[\"She felt very lonely and low-spirited. In a minute or two the Caterpillar decidedly, and he poured a little snappishly. \'You\'re enough to drive one crazy!\' The Footman seemed to be true): If she.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(65,'address','[\"6723 Brekke Grove\\nEast Kathryne, NE 16913-4434\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(67,'title','[\"UX\\/UI Designer\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(68,'description','[\"Alice. \'Come on, then!\' roared the Queen, in a soothing tone: \'don\'t be angry about it. And yet I don\'t think,\' Alice went timidly up to Alice, flinging the baby joined):-- \'Wow! wow! wow!\' \'Here!.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(69,'address','[\"79789 Verlie Lodge\\nAlexandroton, AR 37970\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(71,'title','[\"Backend Developer\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(72,'description','[\"HIS time of life. The King\'s argument was, that she was surprised to find it out, we should all have our heads cut off, you know. Come on!\' So they sat down again into its face in some alarm. This.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(73,'address','[\"11810 Howell Viaduct\\nHerminiofurt, IL 93518-0622\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(75,'title','[\"Frontend Developer\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(76,'description','[\"They were just beginning to think to herself, \'because of his Normans--\\\" How are you getting on now, my dear?\' it continued, turning to the King, rubbing his hands; \'so now let the Dormouse began in.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(77,'address','[\"4362 Altenwerth Corners\\nBednartown, NH 91162-1216\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:47','2025-06-10 10:42:47'),(79,'title','[\"Project Manager\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(80,'description','[\"So she set to work very carefully, remarking, \'I really must be getting home; the night-air doesn\'t suit my throat!\' and a Long Tale They were indeed a queer-looking party that assembled on the.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(81,'address','[\"8055 Imogene Orchard Apt. 819\\nHilpertville, MT 90807-5134\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(83,'title','[\"System Administrator\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(84,'description','[\"HE was.\' \'I never heard before, \'Sure then I\'m here! Digging for apples, yer honour!\' (He pronounced it \'arrum.\') \'An arm, you goose! Who ever saw one that size? Why, it fills the whole she thought.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(85,'address','[\"7625 Novella Heights Suite 886\\nNew Adrianberg, CO 97742\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(87,'title','[\"Frontend Developer\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(88,'description','[\"Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you know why it\'s called a whiting?\' \'I never could abide figures!\' And with that she never knew so much at first, perhaps,\' said the Gryphon.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(89,'address','[\"6743 Thurman Parkways Suite 251\\nPort Ollie, AZ 51642\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(91,'title','[\"Product Manager\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(92,'description','[\"Tortoise--\' \'Why did they draw the treacle from?\' \'You can draw water out of sight; and an Eaglet, and several other curious creatures. Alice led the way, was the BEST butter, you know.\' \'I DON\'T.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(93,'address','[\"66398 Kulas Mountains Apt. 760\\nDillanmouth, VA 57465\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(95,'title','[\"Quality Assurance\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(96,'description','[\"Hatter trembled so, that he shook his head sadly. \'Do I look like one, but the Rabbit asked. \'No, I give it up,\' Alice replied: \'what\'s the answer?\' \'I haven\'t the least idea what a long way back.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(97,'address','[\"687 Batz Inlet Apt. 913\\nSamanthaton, DE 85336\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(99,'title','[\"Backend Developer\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(100,'description','[\"Alice. \'I wonder what CAN have happened to you? Tell us all about it!\' and he wasn\'t going to be, from one of the gloves, and was looking at the top of his great wig.\' The judge, by the carrier,\'.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:48','2025-06-10 10:42:48'),(101,'address','[\"116 Helmer Spring Apt. 737\\nPort Laurystad, LA 89024-6452\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(103,'title','[\"DevOps Engineer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(104,'description','[\"Alice. \'Come on, then,\' said the Hatter: \'let\'s all move one place on.\' He moved on as he spoke, and then the different branches of Arithmetic--Ambition, Distraction, Uglification, and Derision.\' \'I.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(105,'address','[\"870 Cornell Lane Apt. 550\\nLegrosmouth, NJ 70230\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(107,'title','[\"Frontend Developer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(108,'description','[\"The Queen smiled and passed on. \'Who ARE you talking to?\' said one of the e--e--evening, Beautiful, beautiful Soup! Soup of the table, but it is.\' \'Then you may nurse it a minute or two, which gave.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(109,'address','[\"471 Alexane Vista Apt. 998\\nEast Loyce, TN 95353-9530\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(111,'title','[\"Project Manager\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(112,'description','[\"They are waiting on the top with its arms folded, frowning like a candle. I wonder if I\'ve been changed in the pictures of him), while the Dodo suddenly called out \'The race is over!\' and they went.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(113,'address','[\"82798 Savion Mews Apt. 125\\nNew Caleigh, NC 22776-5025\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(115,'title','[\"Fullstack Developer\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(116,'description','[\"Alice quite hungry to look at it!\' This speech caused a remarkable sensation among the party. Some of the well, and noticed that they had to double themselves up and said, very gravely, \'I think.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(117,'address','[\"265 Berge Brooks Suite 282\\nEast Giovannastad, VT 12513\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(119,'title','[\"Fullstack Developer\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(120,'description','[\"Alice: \'I don\'t even know what a delightful thing a Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'Of course twinkling begins with a little before she got up, and began to cry again, for this.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(121,'address','[\"9479 Treutel Islands\\nPourosshire, OR 58190\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:49','2025-06-10 10:42:49'),(123,'title','[\"DevOps Engineer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(124,'description','[\"Dodo in an offended tone, and everybody else. \'Leave off that!\' screamed the Pigeon. \'I\'m NOT a serpent, I tell you, you coward!\' and at last turned sulky, and would only say, \'I am older than you.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(125,'address','[\"8804 Goldner Unions\\nCamilleberg, IN 26944\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(127,'title','[\"Backend Developer\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(128,'description','[\"Alice. \'I wonder what CAN have happened to me! When I used to say.\' \'So he did, so he did,\' said the King: \'however, it may kiss my hand if it makes me grow smaller, I suppose.\' So she went on in.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(129,'address','[\"478 Bauch Lock Apt. 365\\nFletafort, PA 60668-7061\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:42:50','2025-06-10 10:42:50'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(134,'event_id','[6]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(138,'event_id','[8]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06'),(142,'event_id','[8]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:43:06','2025-06-10 10:43:06');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner subtitle=&quot;Location: 1800 Abbot Kinney Blvd&quot; title=&quot;AI Digital&quot; highlight=&quot;Summit&quot; circle_text=&quot;Build Success Brand .&quot; subtitle_image=&quot;homepage05/icons/location.png&quot; image=&quot;homepage05/general/hero-banner-img.webp&quot; image_1=&quot;homepage05/general/hero-banner-author.webp&quot; style=&quot;4&quot;][/hero-banner][countdown start_date=&quot;2026-12-01&quot;][/countdown][events style=&quot;3&quot; title=&quot;Digital Event &lt;span&gt;List&lt;/span&gt;&quot; subtitle_image=&quot;homepage05/general/sub-logo.png&quot; subtitle=&quot;Event Schedule&quot; limit=&quot;4&quot;][/events][marquees quantity=&quot;4&quot; name_1=&quot;CONFERENCES&quot; name_2=&quot;DIGITAL&quot; name_3=&quot;EXPERIENCE&quot; name_4=&quot;EVENT&quot;][/marquees][speakers style=&quot;5&quot; title=&quot;Our Event &lt;span&gt;Speakers&lt;/span&gt;&quot; subtitle=&quot;Our 15+ event speakers&quot; subtitle_image=&quot;homepage05/general/sub-logo.png&quot; limit=&quot;4&quot;][/speakers][brands style=&quot;1&quot; subtitle=&quot;general sponsors&quot; title=&quot;Our Official Sponsors&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot; text_color=&quot;#ffffff&quot;][/brands][tabs-content title=&quot;How You Can &lt;span&gt; Participate &lt;/span&gt;&quot; subtitle=&quot;The Redefines Conferences&quot; subtitle_image=&quot;homepage05/general/sub-logo.png&quot; quantity=&quot;3&quot; title_1=&quot;Registration Form Fill Up&quot; description_1=&quot;It all starts with understanding your unique needs, Our team takes the time to learn about your goal.&quot; image_1=&quot;homepage05/general/tabs-content-1.webp&quot; image_1_1=&quot;homepage05/general/tabs-content-2.webp&quot; image_2_1=&quot;homepage05/general/tabs-content-3.webp&quot; image_3_1=&quot;homepage05/general/tabs-content-4.webp&quot; title_2=&quot;Invitation Card Download&quot; description_2=&quot;It all starts with understanding your unique needs, Our team takes the time to learn about your goal.&quot; image_2=&quot;homepage05/general/tabs-content-1.webp&quot; image_1_2=&quot;homepage05/general/tabs-content-2.webp&quot; image_2_2=&quot;homepage05/general/tabs-content-3.webp&quot; image_3_2=&quot;homepage05/general/tabs-content-4.webp&quot; title_3=&quot;Join And Enjoy The Event&quot; description_3=&quot;It all starts with understanding your unique needs, Our team takes the time to learn about your goal.&quot; image_3=&quot;homepage05/general/tabs-content-1.webp&quot; image_1_3=&quot;homepage05/general/tabs-content-2.webp&quot; image_2_3=&quot;homepage05/general/tabs-content-3.webp&quot; image_3_3=&quot;homepage05/general/tabs-content-4.webp&quot;][/tabs-content][site-statistics quantity=&quot;4&quot; title_1=&quot;Days Of Event&quot; data_1=&quot;3&quot; unit_1=&quot;D&quot; title_2=&quot;Registered Participant&quot; data_2=&quot;20&quot; unit_2=&quot;K+&quot; title_3=&quot;Attendance Event&quot; data_3=&quot;12&quot; unit_3=&quot;K+&quot; title_4=&quot;Our Event Venue&quot; data_4=&quot;5&quot;][/site-statistics][events style=&quot;2&quot; title=&quot;Our Image &lt;span&gt; Gallery &lt;/span&gt;&quot; subtitle_image=&quot;homepage05/general/sub-logo.png&quot; subtitle=&quot;Event image gallery&quot; limit=&quot;5&quot;][/events][marquees quantity=&quot;4&quot; name_1=&quot;CONFERENCES&quot; name_2=&quot;DIGITAL&quot; name_3=&quot;EXPERIENCE&quot; name_4=&quot;EVENT&quot;][/marquees][contact-information address=&quot;New York, USA&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;homepage05/general/contact-information-img.webp&quot; background_image=&quot;homepage05/backgrounds/contact-information-bg.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information][countdown title=&quot;Event &lt;span&gt;Countdown&lt;/span&gt;&quot; subtitle=&quot;our event countdown&quot; subtitle_image=&quot;homepage05/general/sub-logo.png&quot; start_date=&quot;2027-11-18T16:17&quot; primary_button_label=&quot;purchase ticket now&quot; primary_button_url=&quot;/events&quot; secondary_button_label=&quot;Reserve Seat&quot; secondary_button_url=&quot;/contact-us&quot;][/countdown]',1,NULL,'homepage',NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:33'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/news/11.jpg\" image_1=\"main/news/9.jpg\" image_2=\"main/news/3.jpg\"][/about-us-information][brands title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\" style=\"2\" text_color=\"#000000\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:33'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:31'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:31'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:31'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:31'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:31'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:31'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:42:31','2025-06-10 10:42:31');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'I9NLXJ2LQCGX','bank_transfer',NULL,406.25,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(2,'1',0,'JH9CHE7XUQWI','bank_transfer',NULL,81.25,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(3,'1',0,'JEA049GNEGPB','bank_transfer',NULL,162.50,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(4,'1',0,'XKQWN6ZTYXUQ','bank_transfer',NULL,325.00,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(5,'1',0,'UAI2ZC5FKHMZ','bank_transfer',NULL,243.75,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(6,'1',0,'OX2RWBIH6K9U','bank_transfer',NULL,81.25,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(7,'1',0,'XNAIGDB6FUZS','bank_transfer',NULL,325.00,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(8,'1',0,'6OGMKCS7VXND','bank_transfer',NULL,162.50,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(9,'1',0,'S8K5CE2IDSVJ','bank_transfer',NULL,243.75,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:57','2025-06-10 10:42:57',NULL,NULL),(10,'1',0,'TM6JA2SJZRWR','bank_transfer',NULL,325.00,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(11,'1',0,'EMAFSPOOEVKZ','bank_transfer',NULL,22.17,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(12,'1',0,'FVXYFVQNDDBE','bank_transfer',NULL,29.56,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(13,'1',0,'RF5CSNMV9TMS','bank_transfer',NULL,14.78,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(14,'1',0,'JQSOKJHJV881','bank_transfer',NULL,7.39,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(15,'1',0,'DFQP3Q1YKJWS','bank_transfer',NULL,22.17,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(16,'1',0,'DBV4N55ZSPU8','bank_transfer',NULL,14.78,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(17,'1',0,'FZLSQJY1YAGT','bank_transfer',NULL,7.39,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(18,'1',0,'ZFCZXORAY8MB','bank_transfer',NULL,29.56,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(19,'1',0,'VOKXDPHVFPE2','bank_transfer',NULL,7.39,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(20,'1',0,'6SYLCGDUIEPT','bank_transfer',NULL,36.95,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(21,'1',0,'GOB1WYUX5OA6','bank_transfer',NULL,97.90,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:58','2025-06-10 10:42:58',NULL,NULL),(22,'1',0,'6QSNZC7ABIMW','bank_transfer',NULL,489.50,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(23,'1',0,'CLHFIAAOKLP2','bank_transfer',NULL,391.60,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(24,'1',0,'6N5O0SULGCNR','bank_transfer',NULL,195.80,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(25,'1',0,'RQFXCDEFVVRB','bank_transfer',NULL,293.70,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(26,'1',0,'6XQ0BXKXXUY8','bank_transfer',NULL,97.90,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(27,'1',0,'XW3X1I5A1EUV','bank_transfer',NULL,97.90,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(28,'1',0,'IUZET6TZXDFA','bank_transfer',NULL,489.50,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(29,'1',0,'UPQBUF0ESASE','bank_transfer',NULL,391.60,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(30,'1',0,'NUKQGBNQKJI2','bank_transfer',NULL,293.70,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(31,'1',0,'PRPQFZQGJNOX','bank_transfer',NULL,63.24,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(32,'1',0,'NOXHMAQNOGAK','bank_transfer',NULL,42.16,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(33,'1',0,'JZAF3FEPUABY','bank_transfer',NULL,105.40,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:42:59','2025-06-10 10:42:59',NULL,NULL),(34,'1',0,'VBVUTGTLO3TL','bank_transfer',NULL,84.32,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(35,'1',0,'DUS5IW5KHKER','bank_transfer',NULL,105.40,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(36,'1',0,'9OKLIESDRZG5','bank_transfer',NULL,84.32,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(37,'1',0,'V2EZ0IJYQKXA','bank_transfer',NULL,21.08,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(38,'1',0,'ZS9ZUSEWACX5','bank_transfer',NULL,21.08,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(39,'1',0,'AAIZ4ZTQUOHN','bank_transfer',NULL,21.08,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(40,'1',0,'VTQMSVCT7A13','bank_transfer',NULL,84.32,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(41,'1',0,'2RHPU9Q3JRVE','bank_transfer',NULL,157.10,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(42,'1',0,'WJQE15HROALY','bank_transfer',NULL,94.26,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(43,'1',0,'6TVDYZSTZNLG','bank_transfer',NULL,31.42,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(44,'1',0,'H7BHMPTOB77A','bank_transfer',NULL,94.26,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(45,'1',0,'DWJQC3MODAFC','bank_transfer',NULL,31.42,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:00','2025-06-10 10:43:00',NULL,NULL),(46,'1',0,'U7ZLKFESFBH7','bank_transfer',NULL,157.10,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01',NULL,NULL),(47,'1',0,'MJMIWSVTL4VD','bank_transfer',NULL,94.26,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01',NULL,NULL),(48,'1',0,'HHHHRDSQFFR7','bank_transfer',NULL,31.42,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01',NULL,NULL),(49,'1',0,'XCTITHBQFVXS','bank_transfer',NULL,62.84,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01',NULL,NULL),(50,'1',0,'5NV615YL8YPB','bank_transfer',NULL,94.26,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:43:01','2025-06-10 10:43:01',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (1,1),(5,1),(4,2),(2,2),(2,3),(3,3),(6,4),(5,4),(5,5),(3,5),(1,6),(4,6),(3,7),(5,7),(3,8),(6,8),(3,9),(4,10),(5,10),(3,11),(6,12),(2,13),(4,13),(3,14),(5,14),(2,15),(5,15),(5,16),(2,16),(5,17),(3,17),(1,18),(1,19),(6,19),(1,20),(6,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (7,1),(5,1),(2,1),(7,2),(6,2),(2,2),(6,3),(3,3),(5,3),(1,4),(3,4),(4,4),(7,5),(1,5),(5,6),(6,6),(4,7),(1,7),(3,7),(5,8),(2,8),(7,9),(1,9),(2,10),(5,10),(3,10),(5,11),(3,11),(1,12),(4,12),(5,13),(3,13),(7,13),(5,14),(1,14),(2,15),(3,15),(1,15),(5,16),(4,16),(6,17),(4,17),(7,17),(5,18),(3,18),(7,18),(5,19),(7,19),(2,19),(1,20),(3,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',1234,NULL,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',909,NULL,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',2075,NULL,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',2015,NULL,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',650,NULL,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',586,NULL,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',717,NULL,'2025-06-10 10:42:39','2025-06-10 10:42:39'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',331,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',425,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',2148,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',1666,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',634,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',2421,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',1574,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',1296,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',642,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',711,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',1514,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',1060,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/7.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',2096,NULL,'2025-06-10 10:42:40','2025-06-10 10:42:40');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:42:16','2025-06-10 10:42:16');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:43:06'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:43:06'),(6,'language_hide_default','1',NULL,'2025-06-10 10:43:06'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:43:06'),(8,'language_display','all',NULL,'2025-06-10 10:43:06'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:43:06'),(10,'media_random_hash','7e007c9724f07c0d49c2339b142a7ada',NULL,'2025-06-10 10:43:06'),(11,'theme','eventify-homepage05',NULL,'2025-06-10 10:43:06'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:43:06'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:43:06'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:43:06'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:43:06'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:43:06'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:43:06'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:43:06'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:43:06'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:43:06'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:43:06'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:43:06'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:43:06'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:43:06'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:43:06'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:43:06'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:43:06'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:43:06'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:43:06'),(30,'theme-eventify-homepage05-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:43:06'),(31,'theme-eventify-homepage05-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:43:06'),(32,'theme-eventify-homepage05-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:43:06'),(33,'theme-eventify-homepage05-favicon','main/general/favicon.png',NULL,'2025-06-10 10:43:06'),(34,'theme-eventify-homepage05-logo','main/general/logo.png',NULL,'2025-06-10 10:43:06'),(35,'theme-eventify-homepage05-homepage_id','1',NULL,'2025-06-10 10:43:06'),(36,'theme-eventify-homepage05-blog_page_id','4',NULL,'2025-06-10 10:43:06'),(37,'theme-eventify-homepage05-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:43:06'),(38,'theme-eventify-homepage05-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:43:06'),(39,'theme-eventify-homepage05-blog_post_items_per_row','3',NULL,'2025-06-10 10:43:06'),(40,'theme-eventify-homepage05-number_of_related_posts','3',NULL,'2025-06-10 10:43:06'),(41,'theme-eventify-homepage05-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:43:06'),(42,'theme-eventify-homepage05-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:43:06'),(43,'theme-eventify-homepage05-events_page_id','5',NULL,'2025-06-10 10:43:06'),(44,'theme-eventify-homepage05-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:43:06'),(45,'theme-eventify-homepage05-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:43:06'),(46,'theme-eventify-homepage05-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:43:06'),(47,'theme-eventify-homepage05-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:43:06'),(48,'theme-eventify-homepage05-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:43:06'),(49,'theme-eventify-homepage05-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:43:06'),(50,'theme-eventify-homepage05-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:43:06'),(51,'theme-eventify-homepage05-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:43:06'),(52,'theme-eventify-homepage05-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:43:06'),(53,'theme-eventify-homepage05-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:43:06'),(54,'theme-eventify-homepage05-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:43:06'),(55,'theme-eventify-homepage05-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:43:06'),(56,'theme-eventify-homepage05-logo_height','45',NULL,'2025-06-10 10:43:06'),(57,'theme-eventify-homepage05-is_header_transparent','1',NULL,'2025-06-10 10:43:06'),(58,'theme-eventify-homepage05-display_header_top','0',NULL,'2025-06-10 10:43:06'),(59,'theme-eventify-homepage05-header_top_text_color','#000000',NULL,'2025-06-10 10:43:06'),(60,'theme-eventify-homepage05-header_top_background_color','#FFBA00',NULL,'2025-06-10 10:43:06'),(61,'theme-eventify-homepage05-header_background_color','#1A1719',NULL,'2025-06-10 10:43:06'),(62,'theme-eventify-homepage05-header_text_color','#ffffff',NULL,'2025-06-10 10:43:06'),(63,'theme-eventify-homepage05-footer_background_color','#5177FA',NULL,'2025-06-10 10:43:06'),(64,'theme-eventify-homepage05-footer_text_color','#ffffff',NULL,'2025-06-10 10:43:06'),(65,'theme-eventify-homepage05-footer_heading_color','#ffffff',NULL,'2025-06-10 10:43:06'),(66,'theme-eventify-homepage05-tp_primary_font','Figtree',NULL,'2025-06-10 10:43:06'),(67,'theme-eventify-homepage05-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:43:06'),(68,'theme-eventify-homepage05-primary_color','#ff7a00',NULL,'2025-06-10 10:43:06'),(69,'theme-eventify-homepage05-secondary_color','#1A1719',NULL,'2025-06-10 10:43:06'),(70,'theme-eventify-homepage05-newsletter_popup_enable','1',NULL,'2025-06-10 10:43:06'),(71,'theme-eventify-homepage05-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:43:06'),(72,'theme-eventify-homepage05-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:43:06'),(73,'theme-eventify-homepage05-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:43:06'),(74,'theme-eventify-homepage05-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:43:06'),(75,'theme-eventify-homepage05-gradient_color_from','#FF7A00',NULL,'2025-06-10 10:43:06'),(76,'theme-eventify-homepage05-gradient_color_to','#F00',NULL,'2025-06-10 10:43:06'),(77,'theme-eventify-homepage05-body_background_image','homepage05/backgrounds/body-bg.webp',NULL,'2025-06-10 10:43:06'),(78,'theme-eventify-homepage05-footer_background_image',NULL,NULL,'2025-06-10 10:43:06'),(79,'announcement_max_width','1210',NULL,'2025-06-10 10:43:06'),(80,'announcement_text_color','#000000',NULL,'2025-06-10 10:43:06'),(81,'announcement_background_color','transparent',NULL,'2025-06-10 10:43:06'),(82,'announcement_text_alignment','start',NULL,'2025-06-10 10:43:06'),(83,'announcement_dismissible','0',NULL,'2025-06-10 10:43:06'),(84,'announcement_font_size','14',NULL,'2025-06-10 10:43:06'),(85,'announcement_font_size_unit','px',NULL,'2025-06-10 10:43:06'),(86,'announcement_placement','theme',NULL,'2025-06-10 10:43:06'),(87,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:43:06','2025-06-10 10:43:06'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:43:06','2025-06-10 10:43:06'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:43:06','2025-06-10 10:43:06');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:43:06','2025-06-10 10:43:06');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:42:16','2025-06-10 10:42:16'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:42:31','2025-06-10 10:42:31'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:42:39','2025-06-10 10:42:39'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:42:39','2025-06-10 10:42:39'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:42:39','2025-06-10 10:42:39'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:42:39','2025-06-10 10:42:39'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:42:39','2025-06-10 10:42:39'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:42:39','2025-06-10 10:42:39'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:42:39','2025-06-10 10:42:39'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:39','2025-06-10 10:42:39'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:42:40','2025-06-10 10:42:40'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:45','2025-06-10 10:42:45'),(59,'katelyn-lemke',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:45','2025-06-10 10:42:45'),(60,'darwin-lemke',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:45','2025-06-10 10:42:45'),(61,'dr-alvena-mohr',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:45','2025-06-10 10:42:45'),(62,'irma-rippin-ii',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:45','2025-06-10 10:42:45'),(63,'ms-sibyl-torp-md',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:46','2025-06-10 10:42:46'),(64,'lelah-crooks',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:46','2025-06-10 10:42:46'),(65,'johathan-rowe',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:46','2025-06-10 10:42:46'),(66,'mr-arnold-hammes',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:47','2025-06-10 10:42:47'),(67,'ms-maximillia-cummings',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:47','2025-06-10 10:42:47'),(68,'dariana-gislason',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:47','2025-06-10 10:42:47'),(69,'ceasar-brakus',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:47','2025-06-10 10:42:47'),(70,'lydia-fadel',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:47','2025-06-10 10:42:47'),(71,'rachael-shields',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:48','2025-06-10 10:42:48'),(72,'grady-hegmann',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:48','2025-06-10 10:42:48'),(73,'johnathan-gottlieb',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:48','2025-06-10 10:42:48'),(74,'sam-reilly',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:48','2025-06-10 10:42:48'),(75,'eugene-macejkovic',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:49','2025-06-10 10:42:49'),(76,'miss-raegan-von-dvm',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:49','2025-06-10 10:42:49'),(77,'daisy-pfannerstill',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:49','2025-06-10 10:42:49'),(78,'eddie-upton',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:49','2025-06-10 10:42:49'),(79,'mr-waldo-rosenbaum',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:50','2025-06-10 10:42:50'),(80,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:56','2025-06-10 10:42:56'),(81,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(82,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(83,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(84,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(85,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(86,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(87,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(88,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(89,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:42:57','2025-06-10 10:42:57'),(90,'marty-bergstrom',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(91,'willie-gaylord',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(92,'filomena-maggio',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(93,'mitchell-pfeffer',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(94,'gaston-leuschke',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(95,'prof-reuben-bernhard-ii',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(96,'tyson-veum',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(97,'dr-theo-windler',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(98,'jazlyn-turner',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(99,'dr-bart-kovacek',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(100,'prof-unique-mcglynn',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(101,'jess-haley-md',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(102,'bridie-rau',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(103,'brielle-walker',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(104,'mckenna-konopelski',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(105,'leland-lesch-sr',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(106,'alek-wiegand',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(107,'dr-adolphus-heathcote',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(108,'miss-carli-will-v',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(109,'dr-royce-walsh',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(110,'hudson-rice-iii',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(111,'amya-kuphal',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(112,'camryn-harris',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(113,'aric-mcdermott',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(114,'joesph-bartoletti',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(115,'emilia-schowalter',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(116,'vivien-zulauf-v',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(117,'bertrand-flatley-i',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(118,'dr-burnice-heathcote-i',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(119,'mr-geovanny-schumm',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06'),(120,'eliza-armstrong',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:06','2025-06-10 10:43:06');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:42:50','2025-06-10 10:42:50');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:42:39','2025-06-10 10:42:39'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:42:39','2025-06-10 10:42:39'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:42:39','2025-06-10 10:42:39'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:42:39','2025-06-10 10:42:39'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:42:39','2025-06-10 10:42:39'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:42:39','2025-06-10 10:42:39'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:42:39','2025-06-10 10:42:39');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:42:17','2025-06-10 10:42:17'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:42:17','2025-06-10 10:42:17'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:42:17','2025-06-10 10:42:17'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:42:17','2025-06-10 10:42:17');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'turner.keaton@spencer.biz',NULL,'$2y$12$E9xvIkmhNvMeRBVdY5lTAezyFq/kbOCxxO0zmyXYv3J0jKlTkioo2',NULL,'2025-06-10 10:42:16','2025-06-10 10:42:16','Elody','O\'Conner','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage05',1,'[]','2025-06-10 10:42:33','2025-06-10 10:42:33'),(2,'ButtonWidget','header_sidebar','eventify-homepage05',2,'{\"url\":\"\\/pricing-plan\",\"label\":\"Buy Ticket\"}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage05',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo.png\"}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage05',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage05',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage05',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(7,'EventListWidget','event_list_sidebar','eventify-homepage05',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage05',1,'[]','2025-06-10 10:42:33','2025-06-10 10:42:33'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage05',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage05',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage05',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(12,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage05',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(13,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage05',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:42:33','2025-06-10 10:42:33'),(14,'ContactInformationWidget','header_top_sidebar','eventify-homepage05',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":2,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\"}','2025-06-10 10:42:33','2025-06-10 10:42:33');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:43:07
