-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'QxNSx7pQpyVVlpadlOeIjmYMoaGAA4ji',1,'2025-06-10 10:43:20','2025-06-10 10:43:20','2025-06-10 10:43:20');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:44:09',NULL,1,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:44:09',NULL,1,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:44:09',NULL,1,'2025-06-10 10:44:09','2025-06-10 10:44:09');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Harum dolor aut fuga tenetur. Ut autem sunt inventore et nisi accusamus voluptas. Saepe fugiat modi dolores sunt.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(2,'Leadership &amp; Strategy',0,'Quidem est voluptatem aspernatur. Quaerat doloremque inventore sit sit ex accusamus nemo perspiciatis. Nam sunt voluptates unde aut non repellat. Quia accusantium sequi quia non dolore.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(3,'Networking &amp; Collaboration',0,'Quasi illo nulla assumenda. Eius molestiae itaque eum assumenda dolorum est. Expedita culpa a eaque eaque vitae aut. Natus aut repellat et qui.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(4,'Entrepreneurship Startups',0,'Facere facere pariatur magnam maiores assumenda vel et. Laboriosam ut sunt quasi error. Illum id fuga vel et dolorum dolorem asperiores molestiae.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(5,'Marketing &amp; Branding',0,'Quas rerum quia iure sint voluptate sunt earum. Nemo harum sed enim cumque. Excepturi incidunt est dolor corporis vero distinctio possimus. Sunt modi ut quam impedit iste.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(6,'Event Highlights &amp; Recaps',0,'Voluptas deleniti commodi id architecto sed. Eos possimus distinctio nesciunt quia illo nam nemo ut. Fugit aliquid repellendus in aut soluta iure.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:43:41','2025-06-10 10:43:41');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Chasity Ward','minerva.barton@example.net','(813) 567-1345','151 Rickie Square\nPort Chauncey, TX 85111-2193','Enim voluptas ea quaerat consequatur.','Fuga saepe perferendis molestias quo repudiandae rem. Fuga odit esse quia aspernatur non tempora. Maiores ea ipsum assumenda ipsa accusamus. Eveniet eum harum sequi enim sapiente alias. Voluptatem ratione enim quo repellat eum iste vel. Quia beatae nam quis aut sapiente tempore atque. Nihil beatae excepturi eveniet praesentium. Iste et facere et vitae expedita. Rerum expedita non id soluta eveniet qui consectetur sit. Et sit aut et voluptatem dolores laudantium sit.',NULL,'unread','2025-06-10 10:43:20','2025-06-10 10:43:20'),(2,'Miss Natasha Olson V','treutel.darrick@example.com','252-645-2094','77923 Reilly Street Suite 986\nWest Reecebury, MO 55846','Accusamus qui nostrum tenetur excepturi velit.','Quae assumenda atque non consequatur sit. Qui ut eos doloribus in beatae dolorum. Ea velit expedita debitis nisi ipsa odit. Reiciendis ad doloribus corrupti molestiae. Delectus qui distinctio voluptates et quo. Delectus aut eveniet nobis beatae. Deserunt architecto recusandae quaerat porro. Ratione asperiores eius quaerat iusto facere qui. Et iusto est officia dolorem tenetur. Eos aut aperiam necessitatibus. Voluptates molestiae enim nemo voluptatem maiores.',NULL,'unread','2025-06-10 10:43:20','2025-06-10 10:43:20'),(3,'Khalid Wintheiser','sdooley@example.org','+1-716-633-7413','84309 Jayden Inlet\nPort Chaseshire, DC 88115','Omnis dolores sunt qui.','Repellat minus suscipit magni autem voluptas. Reiciendis corporis esse iste porro. Temporibus in qui corrupti eligendi. Vitae atque asperiores laborum est numquam qui dolor sint. Laudantium qui natus consequatur quia reiciendis. Voluptates aut qui qui quas sunt accusantium. Vel quia hic aut fugiat. Pariatur vel pariatur ratione ut inventore. Fugiat voluptas eos error quis similique quae. Iusto ut harum veniam ipsum.',NULL,'unread','2025-06-10 10:43:20','2025-06-10 10:43:20'),(4,'Dr. Kamron Jerde IV','deangelo02@example.net','845-479-6315','228 Bruen Drives Suite 948\nNorwoodbury, OH 32669','Soluta iste eum cum deleniti temporibus maxime.','Praesentium dicta et aut sunt libero et velit. Alias et maiores soluta ab. Officiis occaecati omnis voluptates quidem. Laborum magnam vel natus consequatur. Quaerat ducimus aliquid est ut amet. Est nihil autem doloribus corporis veniam quae. Sapiente reiciendis officia corporis modi. Ea corporis non maxime ex reiciendis magnam eaque. Et deleniti dignissimos voluptate quam fugit ipsam eum. Voluptatum iusto debitis et ut accusamus. Quam mollitia sapiente laudantium eveniet dolor ad.',NULL,'unread','2025-06-10 10:43:20','2025-06-10 10:43:20'),(5,'Prof. Shanie Littel III','wilfrid93@example.org','+13862878440','345 McClure Point\nPort Adellebury, MD 67246','Et eveniet doloremque tempora repellendus qui.','Eligendi minima et vitae veniam necessitatibus ipsam. Non sit architecto nisi sint. Non facere et dicta molestiae. Sed quis temporibus nihil velit ipsa. Eius sint quasi voluptatem architecto porro. Repudiandae vel omnis fugit dolorem maxime qui. Porro numquam a modi doloremque veritatis velit aut. Est aut harum est molestias et cumque omnis minima. Quia labore alias dignissimos omnis possimus non fugiat. Aspernatur et beatae maxime dolor eaque et a.',NULL,'unread','2025-06-10 10:43:20','2025-06-10 10:43:20'),(6,'Patricia Robel','bartell.tyler@example.net','1-301-909-5985','719 Cassin Road\nSchowalterland, SC 73772','Iusto veritatis ab accusamus incidunt.','Rerum impedit ut reiciendis nostrum deserunt expedita. Esse sunt quos sapiente autem nesciunt exercitationem quo. Distinctio veniam aut voluptates magnam. Fugiat quis suscipit est deleniti. Voluptatibus nesciunt tempore nihil deserunt. Rerum repellat cumque ut placeat. Dolore quis nihil officiis sit neque minima dolore doloribus. Laudantium impedit esse sint et dolore. Eos distinctio maxime debitis officia aliquam.',NULL,'read','2025-06-10 10:43:20','2025-06-10 10:43:20'),(7,'Greg Wolff','zieme.elsa@example.com','(820) 624-9142','3923 Klocko Shores\nWest Murray, NC 35277','Aperiam dolorum quis voluptatem et nemo ut.','Nesciunt voluptas voluptatem architecto aliquam ipsa rerum. Quidem consequuntur consectetur rerum sunt rerum voluptatem quo. Iure ipsam a aut est voluptates nihil corporis. Consequatur quidem temporibus dolor. Aperiam quam vel nihil consequatur. Sed qui sint praesentium fugiat placeat recusandae eligendi. Magnam nesciunt totam nisi aut et tenetur expedita. Aut aliquam sit placeat. Dicta et et qui ea laborum id dignissimos.',NULL,'unread','2025-06-10 10:43:20','2025-06-10 10:43:20'),(8,'Prof. Florence Ritchie MD','adrain.schmidt@example.com','(863) 223-6447','116 Jules Knolls\nPasqualeburgh, OR 75287','Itaque earum ipsum omnis quasi et.','Consequatur illum sit ut nihil quia. Explicabo et aut reprehenderit nobis ipsam quis. Quae eum et est voluptas velit deserunt. Dolores nostrum tempora ut. Consequuntur dolores eius quos. Omnis nisi suscipit maiores est quis. Maiores architecto eaque maiores fugiat incidunt. Ipsum tempora perspiciatis enim minus omnis quod explicabo. Sequi id rerum libero totam assumenda. Rerum impedit et vero voluptatem.',NULL,'read','2025-06-10 10:43:20','2025-06-10 10:43:20'),(9,'Kayley Wilkinson II','zechariah07@example.com','1-470-734-4522','80341 Jacinthe Crossroad Suite 561\nWest Amiramouth, TX 95189-0193','Consectetur et molestiae odio quo.','Aut molestiae facere aspernatur dolor eum molestiae. Modi officia voluptatem similique facilis harum quam quae. Necessitatibus debitis temporibus reprehenderit consequuntur fugit ut quo. Molestias qui et velit sint vero sed. Doloribus nobis voluptatum laborum voluptates. Deleniti est quisquam hic et. Minus neque omnis sed eligendi. Dolorem amet rerum nemo nobis quod pariatur nihil. Omnis aliquid consectetur cupiditate placeat quos dolor. Quia dolor id et est eos.',NULL,'read','2025-06-10 10:43:20','2025-06-10 10:43:20'),(10,'Jaeden Effertz','ntillman@example.com','(213) 819-5591','906 Cruz Pines\nKlockoberg, NM 07561','Aut voluptates blanditiis dolor.','Sint nisi ut qui qui et. Ea dolor et dolorem architecto sapiente consequatur. Ut perspiciatis est necessitatibus voluptatum dolorem ea sint. Voluptatem et commodi qui ducimus corporis occaecati reiciendis. Sit consequatur ut exercitationem. Enim asperiores repellendus nihil voluptas unde aut ea repellat. Repellat doloremque non alias est quos quo dolor.',NULL,'unread','2025-06-10 10:43:20','2025-06-10 10:43:20');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:43:52',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:43:52',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:43:52',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:43:52',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:43:52',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:43:52',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Dr. Felton Bruen II','customer@archielite.com','$2y$12$Tfmgg0OxaO/MOqiIwq33muTGGn.BqUszFtBY1SgRehfipxStyZ4D.',NULL,'0560226077','1996-09-30','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:47','2025-06-10 10:43:47'),(2,'Michael Smith','kenny.abbott@jakubowski.com','$2y$12$HnrqbMzqWzp0NEIhnxGE8es4ljVXS79lFxV3jelp.3cw7dFoG4.YG','homepage06/speakers/4.png','0747516504','2014-11-24','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:47','2025-06-10 10:43:47'),(3,'Ms. Athena Graham V','emmerich.jessie@simonis.org','$2y$12$gH3NQEtKIS4kkg8rXrJl.e3jJtUSsw2.Uk0nY3V4pQkHvQvjH8dPm','homepage06/speakers/5.png','0930990132','2017-03-25','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:47','2025-06-10 10:43:47'),(4,'Maryse Collier I','zohara@yahoo.com','$2y$12$2h5O7On1d4TvlodqJqCQmeetvt4oxzJis.HU5F4idF2/Ntlc4wQ1S','homepage06/speakers/5.png','0344034904','2008-06-26','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:47','2025-06-10 10:43:47'),(5,'Yesenia Kessler','schinner.isai@yahoo.com','$2y$12$ZBhV6E33TEzgxrTloh.wIe5qvdC9Ph/pK60x67jV9oTlEUmq/faBW','homepage06/speakers/1.png','0915239460','2005-03-23','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:48','2025-06-10 10:43:48'),(6,'Katelyn Hill','carlos.king@trantow.com','$2y$12$gHLamtLWwV6/E6i8ZPgUAeQwo64ck7GwLtunnfzmpSHfJEXbYzRVq','homepage06/speakers/1.png','0643180111','2006-12-23','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:48','2025-06-10 10:43:48'),(7,'Edwin Boyle','abigale37@gmail.com','$2y$12$YvVH4hOdN/5I0NSo0nvXsODVaMm6a.P3TmKa3varpVSjs91u64Doq',NULL,'0250145239','2019-07-25','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:48','2025-06-10 10:43:48'),(8,'Dr. Beverly Zulauf','hbeatty@spencer.info','$2y$12$V.05utLGnIGRyspbwb86MOaJBScL76o9G4Dx5Admds31Ph956Bjam',NULL,'0333774867','2001-08-06','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:48','2025-06-10 10:43:48'),(9,'Ena Leuschke','jaycee.berge@swift.net','$2y$12$MrrvjkPFnaWUCpseO8TbXuyEJRMB3GH6NzZ27c5GPlcEXVZOQgvpy','homepage06/speakers/8.png','0157636906','2023-05-14','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:48','2025-06-10 10:43:48'),(10,'Vivien Runolfsdottir','nyah.baumbach@pouros.com','$2y$12$wreJYKjAPhIlD2s7AEurp.BHRIlgRG6L/O70kEv.8YZ1CRsa0cL.G','homepage06/speakers/5.png','0596719088','2011-04-12','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:48','2025-06-10 10:43:48'),(11,'Marianna Skiles','orrin.anderson@gmail.com','$2y$12$N7pQmyMW9dBgMf49DqLpquxq1ufNUidEiTsa7NAfsYO75tQbZRWUa',NULL,'0386825627','2021-04-16','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:49','2025-06-10 10:43:49'),(12,'Miss Leilani Lynch','buckridge.jacky@yahoo.com','$2y$12$7v4Gvvjj2UX0X2rrDwMVXePcGf6JCidgmApdsrzZWLjfhlTDFzfTe','homepage06/speakers/3.png','0784349756','2000-04-22','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:49','2025-06-10 10:43:49'),(13,'Bethany Corkery V','kacie52@gmail.com','$2y$12$9rGPzoZKrikeqVBKqkWL.OCq6QfNQaOGCW4qF8pcJWGSBkzCwD9AW',NULL,'0503116458','2012-09-12','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:49','2025-06-10 10:43:49'),(14,'Amara Swaniawski','zlang@yahoo.com','$2y$12$Hcct60Ru83IgrIN2KjuUuOFV9eWGW37fihzKOxgcp3FGphoSh8hhy','homepage06/speakers/5.png','0418546894','2025-02-20','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:49','2025-06-10 10:43:49'),(15,'Gladys Schneider','jmiller@gmail.com','$2y$12$JcAVrKmtX7at.3cLSb9pjuocErOFw9vMT9X50kgAeT6Ax11fPWM0K','homepage06/speakers/3.png','0266118437','2023-09-22','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:49','2025-06-10 10:43:49'),(16,'Jarod Heller III','roel86@mann.org','$2y$12$6cIvJ82YZh3E/CO8iJfYJOZ8QOactvPOemBeu0EQnwB2UrXt4j3xK','homepage06/speakers/1.png','0899155340','2002-08-04','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:50','2025-06-10 10:43:50'),(17,'Prof. Kaelyn Armstrong','gustave.mosciski@yahoo.com','$2y$12$QmYIG2Ih1P9fUZ4dBMfsG.9jsdhE6l1CH13m3nBc7ZhSlfHMVBtym','homepage06/speakers/6.png','0270580438','2020-10-25','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:50','2025-06-10 10:43:50'),(18,'Myrtis Rosenbaum','teresa.barton@hotmail.com','$2y$12$XAVk9vccVMb0cq3wygpBVelGa4qZFzC0cTRfC52FZsA3TDedR.r06','homepage06/speakers/3.png','0908400044','2018-08-08','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:50','2025-06-10 10:43:50'),(19,'Weldon Howe','barton.aubrey@schuppe.com','$2y$12$8fEGGaAD.FOpvSCvmpqpcui5COActrsH23fe2QtyV1Bt.mZwYzDk6','homepage06/speakers/1.png','0997729305','2003-07-14','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:50','2025-06-10 10:43:50'),(20,'Mr. Toy Ebert','zpouros@abbott.com','$2y$12$wvaoPS4lDLKy26v.fJU.9uWbLwcytlRfnAeq.GCMEZERBLC/Lty7G',NULL,'0950457729','2024-03-10','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:50','2025-06-10 10:43:50'),(21,'Aiden Ondricka','heidenreich.creola@jerde.biz','$2y$12$gnAVj6.J9NlETQ1dnuumHOIX8/OgpTwHLvLYpjI7CGvFMscDzqqly',NULL,'0496309820','2014-11-05','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:50','2025-06-10 10:43:50'),(22,'Miss Eldora Daugherty II','okey50@hotmail.com','$2y$12$svwHKG6ejMvpfHdhamwd0uGWZ9kftLV/LbzKq7htDEY.ex4BX.JU6','homepage06/speakers/5.png','0683724107','2004-10-14','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:51','2025-06-10 10:43:51'),(23,'Pamela Block','hamill.lauriane@zieme.com','$2y$12$Bfj1omNVokcHIaLaApepU.dI4X1svM18bccjIWGJDJ9RqnJN8GaA2','homepage06/speakers/3.png','0032290850','2006-04-24','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:51','2025-06-10 10:43:51'),(24,'Woodrow Fahey','eusebio.sipes@mann.info','$2y$12$rL0bar727y5f3GtQDmLN1eaUwJYBVVPIti2w1BpszXPZMUbIbQIEu','homepage06/speakers/2.png','0484649414','2024-03-14','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:51','2025-06-10 10:43:51'),(25,'Prof. Janiya Von','lcummerata@hotmail.com','$2y$12$Jn4bzrT7H5OE5t8bQ2QVx.WoiOqdZWt8HF13Pq.QTU9lvxVSS8Dxu','homepage06/speakers/3.png','0135360637','2011-10-28','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:51','2025-06-10 10:43:51'),(26,'Anissa Jenkins Jr.','fhermiston@schoen.biz','$2y$12$Ey4RLKL8OGAw99hv7JVQhOEBU.IWmFsH6qe2Wq5TkMy4x3V.nkgOS','homepage06/speakers/3.png','0098203975','2005-02-19','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:51','2025-06-10 10:43:51'),(27,'Tina Hermiston V','octavia.dickinson@block.com','$2y$12$cfXdLhE5ct3n4OjvanNKV.ngebDV5cf37mQ46iigRMA2hRAnoRnmq','homepage06/speakers/2.png','0885106622','2016-07-24','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:52','2025-06-10 10:43:52'),(28,'Tamara Will','mikel40@schoen.biz','$2y$12$YonlFU.aeWREw4xDB4SfLeVBUovOv.m54EEsUn3spi79VDgW2m7yW','homepage06/speakers/6.png','0293443336','2015-05-07','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:43:52','2025-06-10 10:43:52'),(29,'Pearline Cummerata','chadd95@rolfson.com','$2y$12$OblN3jUxaeNZ781gViJ8rOSobrdd0ImtqCjQRmvohY/ftGWRWOL12',NULL,'0963147453','2023-02-16','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:52','2025-06-10 10:43:52'),(30,'Mr. Benjamin Watsica','miller.friedrich@dach.com','$2y$12$esiHkLfwJ/Db1o.GveNuhuX2YMLDdlarhS5jhrZ/gpmPCjFZyX0jK','homepage06/speakers/8.png','0644040180','1997-05-19','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:43:52','2025-06-10 10:43:52'),(31,'Elmore Schneider V','fflatley@sanford.net','$2y$12$uNMF0B/CYvNdR6neNHkxEuH4YdOtZj9xA3opo6uaZT1Z81q1m7LnK',NULL,'0070407730','2005-07-25','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:43:52','2025-06-10 10:43:52'),(32,'Marcelina Auer II','boyer.jaclyn@rice.biz','$2y$12$wgSgteT.CqL.O4F1pASXaukivUM1bUcRtf3QrHM14ZBL8nWYr/VKO',NULL,'0844462974',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(33,'Marcia Thompson','eschmidt@hotmail.com','$2y$12$Q7EY9xhpdK6h396nU5jUVuad/d3EIZPSREDgiHQNIkreNE43YR0xy',NULL,'0698886762',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(34,'Prof. Lea Waters PhD','jade.osinski@kilback.biz','$2y$12$O0ov8sPg0Z5fkDvhXD78wO/mbLd3VvEdH9hEh52waAR8e4XzMSLYq',NULL,'0470703472',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(35,'Dr. Aric Brown','marietta35@hotmail.com','$2y$12$zo04yA5QQT7HH6hXEVNBNeyHk3mIIKbwMGW8m79a2moqC.KjZcanC',NULL,'0128263009',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(36,'Jarred Cartwright','fupton@hotmail.com','$2y$12$BBhJrTgh7/8Kci.NbyfPMuIjsozeaxraXjOdU1IpRdndBAco8vnz6',NULL,'0220649076',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:05','2025-06-10 10:44:05'),(37,'Marcia Lebsack','alvera08@yahoo.com','$2y$12$E7IJRQqL5M/BKeruOFk4pO7hTYzrfL8rq6Dk4KTP5j3xY7yfVgcLe',NULL,'0399171978',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:05','2025-06-10 10:44:05'),(38,'Gustave Strosin V','qgoldner@kulas.com','$2y$12$I2QQJpm4OmSpYRO6zeVYZ.20tccw3oZfiLliut.jq4HeqBULRqM0q',NULL,'0066881090',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:05','2025-06-10 10:44:05'),(39,'Jordi Baumbach','cameron33@connelly.com','$2y$12$vdX.DjVtfLs9qwaCm60yWe8IBz0g6S5i5Pa4LltzIWO1kR1.YmdF.',NULL,'0031974031',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:05','2025-06-10 10:44:05'),(40,'Elliot Grimes MD','dboehm@yahoo.com','$2y$12$cXwXiNjYnHks2ujwtJSpROUwJ.RgHIhcTufscf348TGs1r4bGAbG.',NULL,'0206196982',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:05','2025-06-10 10:44:05'),(41,'Dr. Raymond Jakubowski DDS','apacocha@hotmail.com','$2y$12$ynR.V38JzTej7EoLd.90GuFYX1/tYSlLQx1mBaYByTPegjzQcH.MW',NULL,'0530920750',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:05','2025-06-10 10:44:05'),(42,'Mason Bode','gulgowski.buck@ledner.biz','$2y$12$alFsbfcdNCUxA8C9Fll/B.WQhrpf6L.bXmvWmuAOcSTEXwt.zJLK6',NULL,'0403520524',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:05','2025-06-10 10:44:05'),(43,'Laney Douglas','zkshlerin@witting.biz','$2y$12$tHhSL/b3/PX7i3GiVgkNGOzvn0u/LwdwZuZiV5Q7MJ7CxnIxhSDey',NULL,'0298133924',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:06','2025-06-10 10:44:06'),(44,'Zachery Terry IV','ccollier@yahoo.com','$2y$12$u/gp/XWhyymN1oG40yf3D.2jnxhCWS8bZKIiacUnHY34VjqRSIRz2',NULL,'0308913626',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:06','2025-06-10 10:44:06'),(45,'Mr. Danial Nitzsche','ohane@gmail.com','$2y$12$fLPtgcE78N5PTYOiwtzzHO9e/9fEoxhxc23MOPK5x9tu99E99owAa',NULL,'0602469871',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:06','2025-06-10 10:44:06'),(46,'Josianne Ankunding','umosciski@robel.biz','$2y$12$X4taY0iuLLW2mMsgAiv3AeSuSrG681w/ZzIGS60dgoYNb8eAyaKQ6',NULL,'0910202938',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:06','2025-06-10 10:44:06'),(47,'Angel Yundt IV','nelda60@glover.biz','$2y$12$kFWHEIpQeLe5DKKWGF7RMe7xHTL.LRse88ODXuVpUMYZL7bL3aCvq',NULL,'0169952265',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:06','2025-06-10 10:44:06'),(48,'Sadie Konopelski','fahey.jesus@kuhic.com','$2y$12$7XAACchjhWDPrLs5RKwqZuh5GfAFyVNdJQMOAGGib2AvbITmFPHmS',NULL,'0431116588',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:06','2025-06-10 10:44:06'),(49,'Scotty Ernser','elinore.gusikowski@gmail.com','$2y$12$/zM2.7KNjDEE.Bnv3I6DkOYVOx5/0F6v.0HXbcGWN1XJivJjuUVfS',NULL,'0634426019',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:06','2025-06-10 10:44:06'),(50,'Lonzo Hoppe','bschamberger@gmail.com','$2y$12$J8cB7Gd3GIG8OnhjAMaOueGLipDvqQNuU0bKjBOHHBBa3GCoSwHmm',NULL,'0503440231',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:07','2025-06-10 10:44:07'),(51,'Kamryn Littel','brittany.shanahan@feeney.info','$2y$12$JBHfaWR/DAZ2NzhNsEyc8ekYM/Z.bX3mMy39fG8xwwqr2fVinMM6a',NULL,'0339316089',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:07','2025-06-10 10:44:07'),(52,'Joyce Zboncak','lueilwitz.caleb@huels.com','$2y$12$IZHgxRe6nzYhwIU9Dmwv7OayrTI947oYpDxsQ0ZDrm6kHzBKrH9ji',NULL,'0505137196',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:07','2025-06-10 10:44:07'),(53,'Aisha Quitzon','asia18@yahoo.com','$2y$12$bACU3HjPMGHsUM2Blty3Yem91ZZLN0OIKtZIYaJiEpQ8qgNuSWAlq',NULL,'0459562747',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:07','2025-06-10 10:44:07'),(54,'Mrs. Carlotta Nolan V','myriam.denesik@bruen.com','$2y$12$o32gusHFe/RxzlM9DJQtoepP5AJBv6Wf7cPG5FN5Q/7aNw.pt5f0a',NULL,'0054969271',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:07','2025-06-10 10:44:07'),(55,'Jaquan Dickinson','pasquale52@prosacco.biz','$2y$12$pqPAvSM9qbPl/oxxzhS3Aev6pIhp/HBHpF2OVin0JNoi6WufgFY7e',NULL,'0240065771',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:07','2025-06-10 10:44:07'),(56,'Estevan Mante','yundt.myrtie@yahoo.com','$2y$12$ZBB/tC7oTfLHLapKKKMSDOBSAepE1cpsRK4c5OkAV8PIxYcDcD6B2',NULL,'0755782278',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:08','2025-06-10 10:44:08'),(57,'Geo Rice V','gbuckridge@yahoo.com','$2y$12$xbVASLWISVtyOye/76Phku.umVssD4hAc/k989L5/e1AFMcYGfGei',NULL,'0309149091',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:08','2025-06-10 10:44:08'),(58,'Isabelle Ernser','edoyle@borer.com','$2y$12$d8R2J7zbw.8KDpDWxjg1E.Evef5PfEKbwKVxOy38kMnx8o2RD/hhG',NULL,'0681655805',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:08','2025-06-10 10:44:08'),(59,'Destinee Orn','rau.leila@gmail.com','$2y$12$zZRO7G9xYh9AioSQogClZOVpJIu3yfouSYFWJURCfpU6yt0kBljiO',NULL,'0749281570',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:08','2025-06-10 10:44:08'),(60,'Anastacio McGlynn','kuhn.morgan@hotmail.com','$2y$12$n89n2p9pnaAaG.e0k/oIp.3egPfHHMFsfyj3Ynb20bMqRu3/EM0Yi',NULL,'0851799656',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:08','2025-06-10 10:44:08'),(61,'Mikel Bernier','oberbrunner.april@boyer.com','$2y$12$K5L3TVxqrvdD2Wp6dhvd0.Sblu/v47XfZEMmMVcVSSSoK3MdPVNhC',NULL,'0343448781',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:08','2025-06-10 10:44:08'),(62,'Karen Emard','jacobson.elwin@wyman.com','$2y$12$.iOnfydjY2U5R0Y6gCjqne5IxMu.MjqldV9ExRoXBBmlTgnU2BFPG',NULL,'0194355646',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:08','2025-06-10 10:44:08'),(63,'Chyna Jacobson','anthony23@yahoo.com','$2y$12$ze2spC3BuTCdzojLV7GqsexGw4kURzn1qO/gEQt0IGSKgYzimpFya',NULL,'0389013647',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(64,'Dr. Estrella Mayert DVM','bailey.vanessa@greenholt.info','$2y$12$vhUsXoOhQdELUv64j9htt.kixj8IfAHFusO7k7wv9hnNFFRgL9NpO',NULL,'0400345819',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:09','2025-06-10 10:44:09');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:43:13','2025-06-10 10:43:13'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:43:13','2025-06-10 10:43:13'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:43:13','2025-06-10 10:43:13');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (3,55,'08CICI9CTY3G',NULL),(3,57,'2B2ORSJZ6IJG',NULL),(2,47,'6INXTJDVYYYS',NULL),(3,50,'8T57UY1UOO6G',NULL),(2,49,'CY4BXMVK2TS5',NULL),(3,61,'D006K0JTZ9E5',NULL),(2,43,'DDHO4NVMLDAE',NULL),(3,54,'DPJF4CJATWPD',NULL),(3,60,'E6TGLCOJ0KVJ',NULL),(2,41,'FEF2LCJLWNAH',NULL),(1,32,'GMCDZDEOQQ0W',NULL),(2,46,'GRTR47HYLMLT',NULL),(1,37,'I5Z3JZCFDPE2',NULL),(3,51,'MXPBYFCZRVJT',NULL),(2,38,'NA6R384UETM3',NULL),(1,35,'OS16CQMSW8PI',NULL),(3,56,'P3S155WVHMRF',NULL),(1,36,'PC4ULRVC8ONY',NULL),(2,45,'QACYOHP0ID7H',NULL),(2,39,'RO1F7F6UNZJ4',NULL),(3,59,'SVVFK5A7XUD0',NULL),(2,44,'TYW6OANDDGJ6',NULL),(3,58,'TYWY4M3G6HBD',NULL),(2,42,'UNYYDRRT8RC9',NULL),(1,34,'VTIBD5RDDVZN',NULL),(4,62,'W3CSX3VWWRCE',NULL),(3,53,'WKXTDCYGV9DL',NULL),(4,63,'X0557FSJFQVL',NULL),(1,33,'XA0QAVFNNVSG',NULL),(2,48,'YGSOO128UTMB',NULL),(3,52,'YZ13UVM47IAM',NULL),(4,64,'ZVYNNGZ0NTWC',NULL),(2,40,'ZXEAHSBBTB4Z',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,9,'Sed qui vel nesciunt necessitatibus facilis aut earum rerum. Et et rem quas id voluptate.',NULL,0,NULL,NULL),(1,23,'Illo id et et facilis culpa consequatur. Ipsum sed suscipit assumenda debitis quidem.',NULL,1,NULL,NULL),(1,10,'Iusto magnam est odit sunt dolorem. Fugiat voluptas suscipit sit ipsam delectus minus ipsum.',NULL,2,NULL,NULL),(2,9,'Quod fuga eum voluptas repudiandae. Dolores et molestias totam harum. Aut ut debitis fuga tempora.',NULL,0,NULL,NULL),(2,10,'Autem necessitatibus aut qui quasi. Officia molestias cum quidem et repellendus dolor quis.',NULL,1,NULL,NULL),(2,5,'Fuga commodi ex rerum sint. At rerum doloribus hic in eum autem quia.',NULL,2,NULL,NULL),(2,27,'Magni ut nihil ut et vero natus eaque. Ab odit beatae ex. In itaque odit suscipit qui nisi.',NULL,3,NULL,NULL),(3,12,'Porro ab sit sit. Minima ea ratione nam animi quia nisi amet. Quibusdam numquam est quia at at ut.',NULL,0,NULL,NULL),(3,27,'Quae sit non nihil. Sunt fuga dicta aut eveniet. Beatae impedit et sit sed.',NULL,1,NULL,NULL),(3,3,'Et dignissimos nemo quo eveniet doloribus et veritatis. Dolor non hic in eos voluptate quae.',NULL,2,NULL,NULL),(3,5,'Nihil maxime voluptatum accusamus sint officia soluta maxime. Corporis ea occaecati et veniam.',NULL,3,NULL,NULL),(4,16,'Laborum vel quibusdam aliquid dicta. Vitae porro est dolor ducimus sunt omnis.',NULL,0,NULL,NULL),(4,30,'Velit in facere enim. Odit sed tempora labore totam suscipit et.',NULL,2,NULL,NULL),(4,12,'Nam qui occaecati id voluptas. Ea quo ex sequi unde. Est expedita neque id minus molestias.',NULL,3,NULL,NULL),(5,10,'Qui accusamus quaerat est assumenda. Eos veritatis aliquid et quo consectetur voluptatem.',NULL,0,NULL,NULL),(5,12,'Ipsam quia harum sequi. Aut commodi minima error eveniet et enim. Libero id dolores et et sint.',NULL,1,NULL,NULL),(5,16,'Sint velit iste voluptatibus. Accusantium modi tempora quia adipisci eos.',NULL,2,NULL,NULL),(5,5,'Laboriosam sapiente tempore aperiam. Odio et vel fugiat eos vitae.',NULL,3,NULL,NULL),(6,16,'Assumenda eius facilis et architecto. Aut labore deserunt dolores fugit.',NULL,0,NULL,NULL),(6,30,'Est velit est sed dicta. Expedita officia beatae veritatis a id sapiente fuga ut.',NULL,1,NULL,NULL),(6,12,'Cumque esse qui cumque labore et eligendi. Ut deserunt quo dolorum tempore est quas asperiores.',NULL,2,NULL,NULL),(7,9,'Quaerat quam dolore dolor et aspernatur non. Eveniet cumque porro error velit molestias aut.',NULL,0,NULL,NULL),(7,12,'Id error occaecati quis non consectetur aut quae. Ex dignissimos enim perferendis.',NULL,1,NULL,NULL),(7,3,'Non laborum voluptas ut molestias. Qui enim dicta quos omnis.',NULL,2,NULL,NULL),(7,16,'Expedita quis dolorem cupiditate omnis. Omnis aliquid labore est fugiat sunt maiores.',NULL,3,NULL,NULL),(8,3,'Nam dicta non voluptate alias debitis velit. Sunt repudiandae nisi et et autem quae.',NULL,0,NULL,NULL),(8,9,'Quia iure unde temporibus deleniti deleniti. Veniam dolor similique porro error.',NULL,1,NULL,NULL),(8,30,'Eveniet omnis ut voluptates deserunt voluptatem nam enim. In dolore rerum rerum aperiam sit.',NULL,2,NULL,NULL),(8,17,'Earum rerum debitis qui labore totam. Architecto veritatis beatae sint quidem et.',NULL,3,NULL,NULL),(9,17,'Consequuntur magnam quia provident aut et et. Recusandae aliquam et illum neque.',NULL,0,NULL,NULL),(9,16,'Aliquam inventore occaecati sint consequatur voluptas. Odit animi soluta eos perferendis est.',NULL,1,NULL,NULL),(9,5,'Quis quo et necessitatibus quo asperiores. Id sed sit id. Fugit ea sit est expedita nostrum libero.',NULL,2,NULL,NULL),(10,23,'Accusantium quis deleniti officia quia. Molestiae nulla enim sint dolorem porro nisi.',NULL,0,NULL,NULL),(10,9,'Enim quod esse et. Sequi quo quisquam quis veniam est cum. Et nam facere facere fugiat.',NULL,1,NULL,NULL),(10,16,'Nesciunt eos nam quasi alias ex. Esse nostrum fugiat facere eius.',NULL,2,NULL,NULL),(10,30,'Totam nobis vero officia. Officia nam a doloribus perspiciatis hic hic. Qui et eaque ut magnam.',NULL,3,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',15,'Voluptates porro nemo iure temporibus ut.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','ed331a8d-3d02-39be-9032-ee22990e7325','main/events/1.webp',60.73,'653 Aliza Plains Apt. 887\nGutkowskiport, VA 58988',5,5,5,'-76.423604','-33.092625',94,0,'2025-06-10 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(2,'Mobile World Congress',6,'Deleniti est ea explicabo unde.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','d777d2a8-e273-3244-a3c1-ee67791509ad','main/events/2.webp',18.34,'60255 Koss Road\nEast Kendratown, WA 82330',3,NULL,NULL,'5.593766','-148.498749',92,0,'2025-06-10 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(3,'Google I/O',15,'Quidem occaecati aliquam totam culpa occaecati.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','62f4dc1b-f974-32b3-910d-22eb22fafa79','main/events/3.webp',79.58,'7431 Santiago Prairie Suite 955\nNorth Misael, WV 95556',2,2,2,'-69.44481','168.199849',50,0,'2025-06-10 09:00:00','2025-06-22 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(4,'Apple WWDC',28,'Neque voluptatibus aperiam modi sit praesentium voluptatum nostrum.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','f1c29b62-e5b5-38d9-9893-48f3d49980bf','main/events/4.webp',59.08,'306 Ferry Points Suite 982\nWernertown, MI 64310',2,2,2,'-1.982429','62.718614',61,0,'2025-06-10 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(5,'AWS re:Invent',25,'Atque sapiente ipsam ratione et provident illum sit molestias.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','85ff95b5-d543-3fea-8d81-013cdb4afb00','main/events/5.webp',96.86,'825 Tyrell Fork\nBlickview, NE 21297-5053',4,4,4,'30.694805','-49.200335',88,0,'2025-06-11 09:00:00','2025-06-22 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(6,'Microsoft Build',6,'Deleniti facilis explicabo ratione.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','659f7d10-a7e3-3843-bf61-4309d7d85161','main/events/6.webp',35.71,'755 Jakubowski Well Apt. 015\nKertzmannmouth, KY 76978',4,4,4,'-5.40393','136.832007',70,0,'2025-06-11 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(7,'Facebook F8',28,'Saepe dolore ipsa aspernatur autem eum voluptas enim.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','dd3c9af9-539d-3983-8f9c-3dbcf52ebd54','main/events/7.webp',58.79,'2985 Cleo Islands Apt. 397\nNorth Orenfurt, MA 42592',2,2,2,'1.810548','161.328238',80,0,'2025-06-11 09:00:00','2025-06-25 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(8,'GitHub Universe',18,'Repellendus voluptas dolor nostrum.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','6833ae25-66af-3389-bc9d-2dc447eff000','main/events/8.webp',93.99,'44692 Buckridge Estate\nCreolafurt, ID 20257-2914',5,5,5,'16.153303','-1.272605',53,0,'2025-06-11 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:43:59','2025-06-10 10:43:59'),(9,'Game Developers Conference',14,'Error nihil consectetur accusamus.','The largest conference in the gaming industry, focusing on game development and gaming technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','b31e094d-ea55-37a6-a6b3-2e1728e4d590','main/events/9.webp',88.49,'739 Stroman Common Suite 090\nEast Humbertochester, NE 17482-8769',1,3,3,'82.529692','-4.342317',56,0,'2025-06-12 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:44:00','2025-06-10 10:44:00'),(10,'Web Summit',4,'Quo error ab tenetur est qui ut.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','1e598a9a-8957-3d75-a6bb-c7dbd406304b','main/events/10.webp',99.48,'23263 Maximilian Parkway\nNew Gussiefurt, VA 00627',3,NULL,NULL,'-52.263619','-150.870102',85,0,'2025-06-12 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:44:00','2025-06-10 10:44:00');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Miss Aisha Walter MD - dbechtelar@yahoo.com','dbechtelar@yahoo.com','0228296771',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Duncan Mann DVM - gbosco@hotmail.com','gbosco@hotmail.com','0210551840',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Kaya Rogahn DDS - esauer@mitchell.com','esauer@mitchell.com','0434272445',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(4,2,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Tatum Sporer - elmore.christiansen@thiel.com','elmore.christiansen@thiel.com','0004774962',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(5,2,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Fannie Herzog - qlockman@larkin.com','qlockman@larkin.com','0662261823',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Forrest Wehner - werdman@gmail.com','werdman@gmail.com','0093753538',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Myrna Rodriguez - ischaefer@hotmail.com','ischaefer@hotmail.com','0948383628',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(8,2,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Cleta Lynch - jaime.murphy@yahoo.com','jaime.murphy@yahoo.com','0030899117',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(9,3,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Anahi Hackett - jacobi.arden@oberbrunner.com','jacobi.arden@oberbrunner.com','0167468587',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Prof. Zena Schinner MD - jerod.dietrich@heidenreich.com','jerod.dietrich@heidenreich.com','0377285319',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(11,4,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Kenny Bashirian - lemke.odell@hettinger.com','lemke.odell@hettinger.com','0366590822',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(12,4,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Prof. Kenyon Connelly - kuhic.ransom@yahoo.com','kuhic.ransom@yahoo.com','0175963982',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Mr. Salvador Reynolds - maida.walsh@bernier.com','maida.walsh@bernier.com','0261183238',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(14,5,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Winifred Gerhold - ross82@hotmail.com','ross82@hotmail.com','0044915965',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(15,5,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Prof. Craig Wiza DVM - joaquin.lind@yahoo.com','joaquin.lind@yahoo.com','0184813544',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(16,5,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Brayan O\'Kon - kendra.schiller@dare.org','kendra.schiller@dare.org','0975631647',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(17,5,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Queenie Sanford - rrempel@gmail.com','rrempel@gmail.com','0248908913',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(18,6,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Marcelina Auer II - boyer.jaclyn@rice.biz','boyer.jaclyn@rice.biz','0844462974',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(19,6,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Marcia Thompson - eschmidt@hotmail.com','eschmidt@hotmail.com','0698886762',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(20,6,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Prof. Lea Waters PhD - jade.osinski@kilback.biz','jade.osinski@kilback.biz','0470703472',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(21,6,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Dr. Aric Brown - marietta35@hotmail.com','marietta35@hotmail.com','0128263009',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(22,6,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Jarred Cartwright - fupton@hotmail.com','fupton@hotmail.com','0220649076',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(23,6,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Marcia Lebsack - alvera08@yahoo.com','alvera08@yahoo.com','0399171978',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(24,7,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Stephon Mraz - tomas23@smitham.com','tomas23@smitham.com','0538395135',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(25,7,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Prof. Tyree Friesen - clemmie.prosacco@rolfson.org','clemmie.prosacco@rolfson.org','0840580592',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(26,7,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Reanna Watsica - chelsie.baumbach@jaskolski.com','chelsie.baumbach@jaskolski.com','0205329211',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(27,7,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Wanda Cassin - senger.rodrick@thiel.com','senger.rodrick@thiel.com','0528418439',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(28,7,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Irma Botsford - umosciski@adams.com','umosciski@adams.com','0891181911',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(29,8,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Prof. Jessie Paucek PhD - regan52@gmail.com','regan52@gmail.com','0698676807',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(30,8,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Koby Schmitt - jgoyette@schuppe.biz','jgoyette@schuppe.biz','0359580297',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(31,8,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Jermey Labadie - cdouglas@brakus.org','cdouglas@brakus.org','0909221164',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(32,8,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Dr. Caleb Romaguera - schaefer.gay@gmail.com','schaefer.gay@gmail.com','0852437670',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(33,8,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Marco Ratke - genevieve.orn@gmail.com','genevieve.orn@gmail.com','0496266755',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(34,9,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Connie Paucek DVM - wprosacco@mueller.org','wprosacco@mueller.org','0690372913',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(35,9,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Florine Swift II - ambrose.quigley@gmail.com','ambrose.quigley@gmail.com','0107176981',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(36,9,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Abdullah Lubowitz PhD - lschulist@bayer.net','lschulist@bayer.net','0048162000',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(37,9,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Kristofer Paucek II - wallace.lang@yahoo.com','wallace.lang@yahoo.com','0671649862',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(38,9,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Nikita Windler - lester97@krajcik.com','lester97@krajcik.com','0502559369',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(39,9,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Davin Ziemann - margarita.beier@haag.com','margarita.beier@haag.com','0089334746',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(40,10,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'CES (Consumer Electronics Show) - Prof. Stephan Bartell V - rutherford.elda@bednar.biz','rutherford.elda@bednar.biz','0264182645',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(41,10,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'CES (Consumer Electronics Show) - Jayde Klein - cassandra48@gmail.com','cassandra48@gmail.com','0101952277',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(42,10,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'CES (Consumer Electronics Show) - Ottis Pollich II - medhurst.jeanie@gislason.biz','medhurst.jeanie@gislason.biz','0007830517',1,60.73,60.73,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(43,11,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Gustave Strosin V - qgoldner@kulas.com','qgoldner@kulas.com','0066881090',1,18.34,18.34,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(44,11,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Jordi Baumbach - cameron33@connelly.com','cameron33@connelly.com','0031974031',1,18.34,18.34,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(45,12,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Darby Beier - cindy58@gmail.com','cindy58@gmail.com','0517252890',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(46,12,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Ursula Witting - goldner.cecil@yahoo.com','goldner.cecil@yahoo.com','0882726534',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(47,12,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Dion Goldner - mara74@gmail.com','mara74@gmail.com','0381601001',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(48,12,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Jay Wiegand Sr. - hermiston.ofelia@friesen.com','hermiston.ofelia@friesen.com','0615488811',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(49,12,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Louie Schneider MD - kprohaska@gmail.com','kprohaska@gmail.com','0273305731',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(50,12,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Dr. Emil Lindgren Sr. - steuber.russell@yahoo.com','steuber.russell@yahoo.com','0711180478',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(51,13,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Prof. Ivy Batz - mdare@brekke.com','mdare@brekke.com','0569020565',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(52,13,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Roosevelt Christiansen PhD - kuphal.mona@cummings.com','kuphal.mona@cummings.com','0237264109',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(53,14,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Elliot Grimes MD - dboehm@yahoo.com','dboehm@yahoo.com','0206196982',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(54,14,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Dr. Raymond Jakubowski DDS - apacocha@hotmail.com','apacocha@hotmail.com','0530920750',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(55,14,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Mason Bode - gulgowski.buck@ledner.biz','gulgowski.buck@ledner.biz','0403520524',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(56,14,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Laney Douglas - zkshlerin@witting.biz','zkshlerin@witting.biz','0298133924',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(57,14,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Zachery Terry IV - ccollier@yahoo.com','ccollier@yahoo.com','0308913626',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(58,15,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Leda Jaskolski - gmcglynn@hotmail.com','gmcglynn@hotmail.com','0621626179',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(59,15,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Kane Jacobson - corwin.juvenal@gmail.com','corwin.juvenal@gmail.com','0117140879',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(60,16,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Madie Kuhn - tomasa.mclaughlin@hotmail.com','tomasa.mclaughlin@hotmail.com','0040305646',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(61,16,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Makayla Senger - xbogan@moen.org','xbogan@moen.org','0178861381',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(62,17,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Reba Mitchell - orie54@gmail.com','orie54@gmail.com','0261723710',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(63,17,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Mohammad O\'Keefe IV - kuhn.hillard@hotmail.com','kuhn.hillard@hotmail.com','0301036706',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(64,18,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Mr. Julien Haag - macie53@gmail.com','macie53@gmail.com','0496428300',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(65,18,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Prof. Darrick Waters - renee.schmeler@dickens.com','renee.schmeler@dickens.com','0125848808',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(66,18,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Prof. Al Koelpin I - darrin53@sanford.com','darrin53@sanford.com','0303721313',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(67,18,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Beaulah Skiles - richard34@veum.com','richard34@veum.com','0047536309',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(68,18,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Mr. Cloyd O\'Connell - jauer@gmail.com','jauer@gmail.com','0070036084',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(69,18,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Ms. Faye Waelchi Sr. - avery.lang@marks.com','avery.lang@marks.com','0468822080',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(70,19,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Mr. Danial Nitzsche - ohane@gmail.com','ohane@gmail.com','0602469871',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(71,19,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Josianne Ankunding - umosciski@robel.biz','umosciski@robel.biz','0910202938',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(72,19,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Angel Yundt IV - nelda60@glover.biz','nelda60@glover.biz','0169952265',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(73,19,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Sadie Konopelski - fahey.jesus@kuhic.com','fahey.jesus@kuhic.com','0431116588',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(74,19,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Scotty Ernser - elinore.gusikowski@gmail.com','elinore.gusikowski@gmail.com','0634426019',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(75,20,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Dr. Dejah O\'Keefe - nya59@wunsch.com','nya59@wunsch.com','0182946539',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(76,20,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Mr. Houston Kshlerin - edison.gerhold@corkery.net','edison.gerhold@corkery.net','0611185452',1,18.34,18.34,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(77,21,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Google I/O - Lowell Adams DVM - christiana.rosenbaum@rowe.info','christiana.rosenbaum@rowe.info','0949547887',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(78,21,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Google I/O - Lisa Johnston MD - haylie.beer@stehr.com','haylie.beer@stehr.com','0754898095',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(79,21,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Google I/O - Brenden Kohler - gino91@schmeler.com','gino91@schmeler.com','0676960807',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(80,21,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Google I/O - Mrs. Mabelle Metz - dauer@hotmail.com','dauer@hotmail.com','0389744343',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(81,21,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Google I/O - Kevin Streich - mylene.gutkowski@parker.com','mylene.gutkowski@parker.com','0745398948',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(82,21,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Google I/O - Dorthy Graham - lhuel@bayer.com','lhuel@bayer.com','0873896688',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(83,22,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Google I/O - Lonzo Hoppe - bschamberger@gmail.com','bschamberger@gmail.com','0503440231',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(84,22,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Google I/O - Kamryn Littel - brittany.shanahan@feeney.info','brittany.shanahan@feeney.info','0339316089',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(85,22,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Joyce Zboncak - lueilwitz.caleb@huels.com','lueilwitz.caleb@huels.com','0505137196',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(86,22,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Aisha Quitzon - asia18@yahoo.com','asia18@yahoo.com','0459562747',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(87,22,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Mrs. Carlotta Nolan V - myriam.denesik@bruen.com','myriam.denesik@bruen.com','0054969271',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(88,23,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Jaquan Dickinson - pasquale52@prosacco.biz','pasquale52@prosacco.biz','0240065771',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(89,23,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Estevan Mante - yundt.myrtie@yahoo.com','yundt.myrtie@yahoo.com','0755782278',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(90,23,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Geo Rice V - gbuckridge@yahoo.com','gbuckridge@yahoo.com','0309149091',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(91,23,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Isabelle Ernser - edoyle@borer.com','edoyle@borer.com','0681655805',1,79.58,79.58,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(92,24,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Austen Collier - kertzmann.eliseo@stark.info','kertzmann.eliseo@stark.info','0460400985',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(93,24,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Ken Konopelski - stracke.austin@bartoletti.com','stracke.austin@bartoletti.com','0533379800',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(94,24,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Modesta Adams - madge18@hotmail.com','madge18@hotmail.com','0117776868',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(95,24,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Furman Morar - alfredo.wisoky@hotmail.com','alfredo.wisoky@hotmail.com','0012369342',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(96,25,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Mr. Skye Russel V - wleffler@hilpert.com','wleffler@hilpert.com','0010125345',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(97,25,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Nathaniel Beer - vonrueden.kenyatta@gmail.com','vonrueden.kenyatta@gmail.com','0358287159',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(98,26,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Mrs. Lela Friesen I - abbott.amelie@bednar.net','abbott.amelie@bednar.net','0018656122',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(99,26,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Kory Kihn Sr. - ebert.gwen@bruen.com','ebert.gwen@bruen.com','0196603370',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(100,26,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Dorthy Cronin - sebastian06@yahoo.com','sebastian06@yahoo.com','0629244470',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(101,26,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Sherman Koelpin - mitchel43@mante.com','mitchel43@mante.com','0136085403',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(102,26,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Hortense Torphy IV - xfunk@hotmail.com','xfunk@hotmail.com','0530614286',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(103,26,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Bonita Ledner - evangeline46@hotmail.com','evangeline46@hotmail.com','0124667242',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(104,27,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Otis Zieme III - hohara@upton.com','hohara@upton.com','0789972610',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(105,27,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Dr. Hank Kuvalis - bernhard53@runolfsdottir.com','bernhard53@runolfsdottir.com','0191241981',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(106,27,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Erna Welch II - reba52@kshlerin.info','reba52@kshlerin.info','0818745566',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(107,27,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Philip Powlowski - gmertz@hotmail.com','gmertz@hotmail.com','0868224462',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(108,27,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Kenny Prosacco - julianne30@schiller.net','julianne30@schiller.net','0918448938',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(109,27,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Donavon Langosh - francisca40@franecki.com','francisca40@franecki.com','0696248496',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(110,28,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Kade Greenholt - hauck.rupert@bergnaum.com','hauck.rupert@bergnaum.com','0121042581',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(111,28,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Mona Brakus - carlo06@yahoo.com','carlo06@yahoo.com','0614074739',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(112,28,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Ansley Rutherford MD - adalberto.adams@gmail.com','adalberto.adams@gmail.com','0483181257',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(113,28,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Krista Barton - sandy80@gmail.com','sandy80@gmail.com','0220922238',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(114,29,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Mr. Milo Spencer V - ronny.simonis@gmail.com','ronny.simonis@gmail.com','0082469018',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(115,29,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Mrs. Karelle Upton III - alehner@hotmail.com','alehner@hotmail.com','0126414381',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(116,29,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Alysa Gleichner - stefan.franecki@yahoo.com','stefan.franecki@yahoo.com','0961043742',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(117,30,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Google I/O - Destinee Orn - rau.leila@gmail.com','rau.leila@gmail.com','0749281570',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(118,30,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Google I/O - Anastacio McGlynn - kuhn.morgan@hotmail.com','kuhn.morgan@hotmail.com','0851799656',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(119,30,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Google I/O - Mikel Bernier - oberbrunner.april@boyer.com','oberbrunner.april@boyer.com','0343448781',1,79.58,79.58,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(120,31,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Apple WWDC - Lionel Kshlerin - luna45@kulas.org','luna45@kulas.org','0049439851',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(121,31,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Apple WWDC - Minnie Kub - helmer.russel@yahoo.com','helmer.russel@yahoo.com','0372536993',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(122,31,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Apple WWDC - Romaine Abernathy - woodrow79@yahoo.com','woodrow79@yahoo.com','0057856633',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(123,31,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Apple WWDC - Miss Adrianna Schmitt - rosalinda23@gmail.com','rosalinda23@gmail.com','0300369456',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(124,31,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Apple WWDC - Bernhard Monahan - august95@gmail.com','august95@gmail.com','0234618161',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(125,31,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Keira Schroeder MD - bashirian.cornell@schmeler.com','bashirian.cornell@schmeler.com','0986062043',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(126,32,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Destiney Dare - thirthe@kassulke.info','thirthe@kassulke.info','0120556242',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(127,32,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Norma Braun - jazmyn.toy@gmail.com','jazmyn.toy@gmail.com','0969762986',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(128,32,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Miss Mable O\'Reilly IV - tstroman@gorczany.info','tstroman@gorczany.info','0122349086',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(129,33,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Tyra Stehr - maymie74@reichel.com','maymie74@reichel.com','0642571742',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(130,33,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Anabel Kunze - goyette.carmen@gmail.com','goyette.carmen@gmail.com','0962220038',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(131,33,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Arnold McLaughlin - alysson25@yahoo.com','alysson25@yahoo.com','0231790133',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(132,33,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Pasquale Wilderman - frederique.nienow@gmail.com','frederique.nienow@gmail.com','0922721469',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(133,34,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Federico Ryan - qherman@yahoo.com','qherman@yahoo.com','0363497737',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(134,34,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Zella Mosciski DVM - hailie.lockman@waelchi.biz','hailie.lockman@waelchi.biz','0072312692',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(135,34,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Leland Smith - kathlyn20@yahoo.com','kathlyn20@yahoo.com','0419472542',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(136,34,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Francesco Hodkiewicz - bstark@yahoo.com','bstark@yahoo.com','0354536107',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(137,34,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Mr. Mervin Jacobson III - runolfsson.armani@jacobi.info','runolfsson.armani@jacobi.info','0555490290',1,59.08,59.08,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(138,35,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Ms. Lurline Smith - hills.howell@shields.com','hills.howell@shields.com','0509092489',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(139,35,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Dell Toy - emorar@parker.com','emorar@parker.com','0130175780',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(140,35,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Felicia Bins - daphney.hauck@homenick.com','daphney.hauck@homenick.com','0693493560',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(141,35,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Adam Abbott - zieme.reagan@grady.net','zieme.reagan@grady.net','0838634579',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(142,36,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Rebekah Hintz - peichmann@keebler.net','peichmann@keebler.net','0641927989',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(143,36,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Prof. Madge Doyle II - ramon70@walker.com','ramon70@walker.com','0854780250',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(144,36,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Prof. Makenna O\'Connell - dicki.hulda@abbott.biz','dicki.hulda@abbott.biz','0702694670',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(145,36,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Prof. Alysson Hauck - homenick.malvina@schowalter.com','homenick.malvina@schowalter.com','0340301962',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(146,36,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Viviane Boyle - jake.gleason@yahoo.com','jake.gleason@yahoo.com','0220602928',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(147,36,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Frankie Gerlach - lschuster@gmail.com','lschuster@gmail.com','0573426342',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(148,37,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Karen Emard - jacobson.elwin@wyman.com','jacobson.elwin@wyman.com','0194355646',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(149,37,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Chyna Jacobson - anthony23@yahoo.com','anthony23@yahoo.com','0389013647',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(150,37,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Dr. Estrella Mayert DVM - bailey.vanessa@greenholt.info','bailey.vanessa@greenholt.info','0400345819',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(151,38,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Alysson Wisoky - sage.armstrong@swaniawski.com','sage.armstrong@swaniawski.com','0169833178',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(152,38,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Dr. Emanuel McKenzie - bruen.audreanne@gmail.com','bruen.audreanne@gmail.com','0879430898',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(153,38,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Zora Vandervort - dicki.gabrielle@pfeffer.com','dicki.gabrielle@pfeffer.com','0433681310',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(154,38,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Roxane Pfeffer - dylan63@hotmail.com','dylan63@hotmail.com','0573835431',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(155,38,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Dr. Stephan Monahan Sr. - joanny.heller@yahoo.com','joanny.heller@yahoo.com','0638265685',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(156,38,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Dr. Jazmyn Wisoky - cartwright.maggie@haley.com','cartwright.maggie@haley.com','0657229411',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(157,39,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Jocelyn Kub - prudence19@schulist.com','prudence19@schulist.com','0659875550',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(158,39,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Raphael Hyatt - hcremin@gmail.com','hcremin@gmail.com','0878958564',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(159,39,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'Apple WWDC - Miss Freda Cummerata - dach.karen@miller.com','dach.karen@miller.com','0098593156',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(160,39,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'Apple WWDC - Deven Emmerich - lemuel09@aufderhar.com','lemuel09@aufderhar.com','0728910149',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(161,39,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'Apple WWDC - Armando Ruecker I - russel.makenzie@hotmail.com','russel.makenzie@hotmail.com','0120166095',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(162,39,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'Apple WWDC - Miss Ivah Padberg Sr. - barrett52@hotmail.com','barrett52@hotmail.com','0588175322',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(163,40,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'Apple WWDC - Prof. Randy Herzog III - qterry@gmail.com','qterry@gmail.com','0162635383',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(164,40,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'Apple WWDC - Colleen Toy - golda.bahringer@nikolaus.info','golda.bahringer@nikolaus.info','0028516054',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(165,40,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'Apple WWDC - Gay Wisozk - abbott.otis@yahoo.com','abbott.otis@yahoo.com','0232861223',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(166,40,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'Apple WWDC - Kadin Stehr - vrogahn@gmail.com','vrogahn@gmail.com','0832379841',1,59.08,59.08,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(167,41,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Prof. Sterling Rolfson Jr. - dylan.bogan@lindgren.com','dylan.bogan@lindgren.com','0051420581',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(168,41,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Christina Torp - jackie04@abbott.net','jackie04@abbott.net','0519179759',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(169,41,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Lavina Mitchell - herman.veronica@yahoo.com','herman.veronica@yahoo.com','0051886791',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(170,41,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Cristopher Champlin - astiedemann@herzog.com','astiedemann@herzog.com','0685980368',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(171,42,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Dr. Tracey Heidenreich - nader.lelia@reinger.com','nader.lelia@reinger.com','0977876891',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(172,42,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Abdul Reichert - kathleen.littel@gmail.com','kathleen.littel@gmail.com','0878888479',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(173,42,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Nadia Dibbert - demarco35@gmail.com','demarco35@gmail.com','0194943840',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(174,42,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Margarete Tremblay - albertha.mayert@hotmail.com','albertha.mayert@hotmail.com','0594136784',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(175,42,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Andreane Rohan - mokuneva@hermiston.net','mokuneva@hermiston.net','0690769061',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(176,43,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Mrs. Kaya Quigley - bradley59@gusikowski.com','bradley59@gusikowski.com','0296019695',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(177,43,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Buford Predovic - hillard30@yahoo.com','hillard30@yahoo.com','0363788762',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(178,44,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Emmalee Klocko - reichert.jaeden@yahoo.com','reichert.jaeden@yahoo.com','0570609667',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(179,44,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Prof. Dario Ritchie - jedidiah.schmitt@hotmail.com','jedidiah.schmitt@hotmail.com','0569781794',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(180,45,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Prof. Jaclyn Hammes - blanda.claudine@gmail.com','blanda.claudine@gmail.com','0651151530',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(181,45,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Lorna Schaden - kylee.steuber@mante.info','kylee.steuber@mante.info','0002764456',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(182,46,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Melisa Hirthe - elian.collins@hotmail.com','elian.collins@hotmail.com','0027165570',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(183,46,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Francesco Schowalter - boehm.toy@lehner.com','boehm.toy@lehner.com','0564012373',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(184,46,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Christian Schulist MD - matilda88@wiza.net','matilda88@wiza.net','0930786429',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(185,47,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Ms. Shemar Strosin V - ernesto.mckenzie@hotmail.com','ernesto.mckenzie@hotmail.com','0127905543',1,96.86,96.86,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(186,47,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Alvera Pfeffer - javon74@becker.com','javon74@becker.com','0146623300',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(187,48,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Kaycee Thompson - conn.kailyn@rau.info','conn.kailyn@rau.info','0070000985',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(188,48,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Retta Kutch - sanford.alicia@gmail.com','sanford.alicia@gmail.com','0057189492',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(189,48,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Erich Donnelly - fkeeling@hotmail.com','fkeeling@hotmail.com','0571976974',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(190,48,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Rogers Treutel - kstokes@gusikowski.biz','kstokes@gusikowski.biz','0670883949',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(191,48,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Frederick Wiza Jr. - martin89@grimes.org','martin89@grimes.org','0700807041',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(192,49,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Emma Corwin - rosa19@buckridge.com','rosa19@buckridge.com','0746387519',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(193,49,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Danial Rogahn - sandra32@heathcote.com','sandra32@heathcote.com','0642374501',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(194,49,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Maureen Schmitt - donnell46@franecki.info','donnell46@franecki.info','0411858160',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(195,49,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Dr. Koby Deckow - amara.nienow@greenfelder.com','amara.nienow@greenfelder.com','0262267167',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(196,49,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Avis Simonis - maureen16@hotmail.com','maureen16@hotmail.com','0363389807',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(197,50,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Asia Rau - alessandra36@cole.biz','alessandra36@cole.biz','0653563802',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(198,50,'ArchiElite\\EventsBooking\\Models\\Ticket',198,'AWS re:Invent - Ms. Althea Hahn DVM - kovacek.katlynn@gmail.com','kovacek.katlynn@gmail.com','0684562645',1,96.86,96.86,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',60.73,'CES (Consumer Electronics Show)','Elmore Schneider V','fflatley@sanford.net',NULL,'ArchiElite','main/general/logo-light.png',121.46,121.46,0.00,0.00,NULL,1,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',60.73,'CES (Consumer Electronics Show)','Elmore Schneider V','fflatley@sanford.net',NULL,'ArchiElite','main/general/logo-light.png',242.92,242.92,0.00,0.00,NULL,2,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',60.73,'CES (Consumer Electronics Show)','Marianna Skiles','orrin.anderson@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',60.73,60.73,0.00,0.00,NULL,3,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',60.73,'CES (Consumer Electronics Show)','Aiden Ondricka','heidenreich.creola@jerde.biz',NULL,'ArchiElite','main/general/logo-light.png',121.46,121.46,0.00,0.00,NULL,4,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',60.73,'CES (Consumer Electronics Show)','Aiden Ondricka','heidenreich.creola@jerde.biz',NULL,'ArchiElite','main/general/logo-light.png',182.19,182.19,0.00,0.00,NULL,5,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',60.73,'CES (Consumer Electronics Show)','Mr. Toy Ebert','zpouros@abbott.com',NULL,'ArchiElite','main/general/logo-light.png',303.65,303.65,0.00,0.00,NULL,6,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',60.73,'CES (Consumer Electronics Show)','Aiden Ondricka','heidenreich.creola@jerde.biz',NULL,'ArchiElite','main/general/logo-light.png',242.92,242.92,0.00,0.00,NULL,7,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',60.73,'CES (Consumer Electronics Show)','Edwin Boyle','abigale37@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',242.92,242.92,0.00,0.00,NULL,8,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',60.73,'CES (Consumer Electronics Show)','Dr. Beverly Zulauf','hbeatty@spencer.info',NULL,'ArchiElite','main/general/logo-light.png',303.65,303.65,0.00,0.00,NULL,9,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',60.73,'CES (Consumer Electronics Show)','Bethany Corkery V','kacie52@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',121.46,121.46,0.00,0.00,NULL,10,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',18.34,'Mobile World Congress','Elmore Schneider V','fflatley@sanford.net',NULL,'ArchiElite','main/general/logo-light.png',18.34,18.34,0.00,0.00,NULL,11,'completed','2025-06-10 10:44:00','2025-06-10 10:44:00','2025-06-10 10:44:00'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',18.34,'Mobile World Congress','Elmore Schneider V','fflatley@sanford.net',NULL,'ArchiElite','main/general/logo-light.png',91.70,91.70,0.00,0.00,NULL,12,'completed','2025-06-10 10:44:01','2025-06-10 10:44:00','2025-06-10 10:44:01'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',18.34,'Mobile World Congress','Aiden Ondricka','heidenreich.creola@jerde.biz',NULL,'ArchiElite','main/general/logo-light.png',18.34,18.34,0.00,0.00,NULL,13,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',18.34,'Mobile World Congress','Dr. Beverly Zulauf','hbeatty@spencer.info',NULL,'ArchiElite','main/general/logo-light.png',73.36,73.36,0.00,0.00,NULL,14,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',18.34,'Mobile World Congress','Pearline Cummerata','chadd95@rolfson.com',NULL,'ArchiElite','main/general/logo-light.png',18.34,18.34,0.00,0.00,NULL,15,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',18.34,'Mobile World Congress','Edwin Boyle','abigale37@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',18.34,18.34,0.00,0.00,NULL,16,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',18.34,'Mobile World Congress','Bethany Corkery V','kacie52@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',18.34,18.34,0.00,0.00,NULL,17,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',18.34,'Mobile World Congress','Dr. Felton Bruen II','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',91.70,91.70,0.00,0.00,NULL,18,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',18.34,'Mobile World Congress','Mr. Toy Ebert','zpouros@abbott.com',NULL,'ArchiElite','main/general/logo-light.png',73.36,73.36,0.00,0.00,NULL,19,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',18.34,'Mobile World Congress','Bethany Corkery V','kacie52@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',18.34,18.34,0.00,0.00,NULL,20,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',79.58,'Google I/O','Aiden Ondricka','heidenreich.creola@jerde.biz',NULL,'ArchiElite','main/general/logo-light.png',397.90,397.90,0.00,0.00,NULL,21,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',79.58,'Google I/O','Mr. Toy Ebert','zpouros@abbott.com',NULL,'ArchiElite','main/general/logo-light.png',318.32,318.32,0.00,0.00,NULL,22,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',79.58,'Google I/O','Mr. Toy Ebert','zpouros@abbott.com',NULL,'ArchiElite','main/general/logo-light.png',238.74,238.74,0.00,0.00,NULL,23,'completed','2025-06-10 10:44:01','2025-06-10 10:44:01','2025-06-10 10:44:01'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',79.58,'Google I/O','Elmore Schneider V','fflatley@sanford.net',NULL,'ArchiElite','main/general/logo-light.png',238.74,238.74,0.00,0.00,NULL,24,'completed','2025-06-10 10:44:02','2025-06-10 10:44:01','2025-06-10 10:44:02'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',79.58,'Google I/O','Bethany Corkery V','kacie52@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',79.58,79.58,0.00,0.00,NULL,25,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',79.58,'Google I/O','Marianna Skiles','orrin.anderson@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',397.90,397.90,0.00,0.00,NULL,26,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',79.58,'Google I/O','Bethany Corkery V','kacie52@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',397.90,397.90,0.00,0.00,NULL,27,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',79.58,'Google I/O','Pearline Cummerata','chadd95@rolfson.com',NULL,'ArchiElite','main/general/logo-light.png',238.74,238.74,0.00,0.00,NULL,28,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',79.58,'Google I/O','Pearline Cummerata','chadd95@rolfson.com',NULL,'ArchiElite','main/general/logo-light.png',159.16,159.16,0.00,0.00,NULL,29,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',79.58,'Google I/O','Edwin Boyle','abigale37@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',159.16,159.16,0.00,0.00,NULL,30,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',59.08,'Apple WWDC','Mr. Toy Ebert','zpouros@abbott.com',NULL,'ArchiElite','main/general/logo-light.png',295.40,295.40,0.00,0.00,NULL,31,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',59.08,'Apple WWDC','Pearline Cummerata','chadd95@rolfson.com',NULL,'ArchiElite','main/general/logo-light.png',118.16,118.16,0.00,0.00,NULL,32,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',59.08,'Apple WWDC','Aiden Ondricka','heidenreich.creola@jerde.biz',NULL,'ArchiElite','main/general/logo-light.png',177.24,177.24,0.00,0.00,NULL,33,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',59.08,'Apple WWDC','Dr. Beverly Zulauf','hbeatty@spencer.info',NULL,'ArchiElite','main/general/logo-light.png',236.32,236.32,0.00,0.00,NULL,34,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:02'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',59.08,'Apple WWDC','Dr. Felton Bruen II','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',177.24,177.24,0.00,0.00,NULL,35,'completed','2025-06-10 10:44:02','2025-06-10 10:44:02','2025-06-10 10:44:03'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',59.08,'Apple WWDC','Aiden Ondricka','heidenreich.creola@jerde.biz',NULL,'ArchiElite','main/general/logo-light.png',295.40,295.40,0.00,0.00,NULL,36,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',59.08,'Apple WWDC','Elmore Schneider V','fflatley@sanford.net',NULL,'ArchiElite','main/general/logo-light.png',118.16,118.16,0.00,0.00,NULL,37,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',59.08,'Apple WWDC','Edwin Boyle','abigale37@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',295.40,295.40,0.00,0.00,NULL,38,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',59.08,'Apple WWDC','Mr. Toy Ebert','zpouros@abbott.com',NULL,'ArchiElite','main/general/logo-light.png',295.40,295.40,0.00,0.00,NULL,39,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',59.08,'Apple WWDC','Mr. Toy Ebert','zpouros@abbott.com',NULL,'ArchiElite','main/general/logo-light.png',177.24,177.24,0.00,0.00,NULL,40,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',96.86,'AWS re:Invent','Dr. Beverly Zulauf','hbeatty@spencer.info',NULL,'ArchiElite','main/general/logo-light.png',290.58,290.58,0.00,0.00,NULL,41,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',96.86,'AWS re:Invent','Marianna Skiles','orrin.anderson@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',387.44,387.44,0.00,0.00,NULL,42,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',96.86,'AWS re:Invent','Dr. Beverly Zulauf','hbeatty@spencer.info',NULL,'ArchiElite','main/general/logo-light.png',96.86,96.86,0.00,0.00,NULL,43,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',96.86,'AWS re:Invent','Dr. Felton Bruen II','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',96.86,96.86,0.00,0.00,NULL,44,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',96.86,'AWS re:Invent','Marianna Skiles','orrin.anderson@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',96.86,96.86,0.00,0.00,NULL,45,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',96.86,'AWS re:Invent','Dr. Felton Bruen II','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',193.72,193.72,0.00,0.00,NULL,46,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',96.86,'AWS re:Invent','Bethany Corkery V','kacie52@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',96.86,96.86,0.00,0.00,NULL,47,'completed','2025-06-10 10:44:03','2025-06-10 10:44:03','2025-06-10 10:44:03'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',96.86,'AWS re:Invent','Dr. Felton Bruen II','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',387.44,387.44,0.00,0.00,NULL,48,'completed','2025-06-10 10:44:04','2025-06-10 10:44:04','2025-06-10 10:44:04'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',96.86,'AWS re:Invent','Dr. Felton Bruen II','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',387.44,387.44,0.00,0.00,NULL,49,'completed','2025-06-10 10:44:04','2025-06-10 10:44:04','2025-06-10 10:44:04'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',96.86,'AWS re:Invent','Pearline Cummerata','chadd95@rolfson.com',NULL,'ArchiElite','main/general/logo-light.png',96.86,96.86,0.00,0.00,NULL,50,'completed','2025-06-10 10:44:04','2025-06-10 10:44:04','2025-06-10 10:44:04');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'ILHZCVA94ZH4','a85ceeb8-5524-4d50-bd1d-47a1a7248acd',1,'CES (Consumer Electronics Show)',60.73,31,1,'Elmore Schneider V','fflatley@sanford.net','Caterpillar contemptuously. \'Who are YOU?\' Which brought them back again to the jury. They were.',NULL,'1',60.73,2,121.46,121.46,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(2,'TBKVVZLWOL4W','ab8712b0-04bc-413e-82af-0b88a38e0494',1,'CES (Consumer Electronics Show)',60.73,31,1,'Elmore Schneider V','fflatley@sanford.net','I\'ll manage better this time,\' she said this, she looked down at once, with a kind of sob, \'I\'ve.',NULL,'2',60.73,4,242.92,242.92,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(3,'Y31PW1Y4ZZXD','f1c8fc75-80fd-4a81-8735-b0f0c7ce28a8',1,'CES (Consumer Electronics Show)',60.73,11,1,'Marianna Skiles','orrin.anderson@gmail.com','And with that she was quite a crowd of little animals and birds waiting outside. The poor little.',NULL,'3',60.73,1,60.73,60.73,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(4,'HZLET0FJUKRJ','69558d17-eb00-411c-a77e-f2e2bc30f4f3',1,'CES (Consumer Electronics Show)',60.73,21,1,'Aiden Ondricka','heidenreich.creola@jerde.biz','Queen, \'Really, my dear, YOU must cross-examine the next witness was the only difficulty was, that.',NULL,'4',60.73,2,121.46,121.46,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(5,'CCB82SWRWERQ','485d8452-b652-42f2-b067-06c4c0f0e41b',1,'CES (Consumer Electronics Show)',60.73,21,1,'Aiden Ondricka','heidenreich.creola@jerde.biz','Alice looked all round her, calling out in a Little Bill It was opened by another footman in.',NULL,'5',60.73,3,182.19,182.19,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(6,'CLQC5DWXOEOX','390ad4a2-78da-4eaf-94c1-e1420498cf64',1,'CES (Consumer Electronics Show)',60.73,20,1,'Mr. Toy Ebert','zpouros@abbott.com','The March Hare meekly replied. \'Yes, but some crumbs must have got in as well,\' the Hatter went.',NULL,'6',60.73,5,303.65,303.65,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(7,'K44JCRWPAGRG','6478a4ed-bd1a-47a0-bf7d-5c6f2a7fed99',1,'CES (Consumer Electronics Show)',60.73,21,1,'Aiden Ondricka','heidenreich.creola@jerde.biz','Alice had no pictures or conversations in it, \'and what is the capital of Rome, and Rome--no.',NULL,'7',60.73,4,242.92,242.92,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(8,'NR9DXC0RXPB5','cc1a71c3-37f3-4c99-82b6-221d8621d0dd',1,'CES (Consumer Electronics Show)',60.73,7,1,'Edwin Boyle','abigale37@gmail.com','Alice in a very good height indeed!\' said the Gryphon. \'Then, you know,\' said the Duck. \'Found.',NULL,'8',60.73,4,242.92,242.92,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(9,'MOOWXPB60NII','563cab3f-a9ff-4c58-b26f-8f2c9a9dcc20',1,'CES (Consumer Electronics Show)',60.73,8,1,'Dr. Beverly Zulauf','hbeatty@spencer.info','Alice heard it muttering to himself as he fumbled over the verses on his spectacles. \'Where shall.',NULL,'9',60.73,5,303.65,303.65,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(10,'XME946XAWZVZ','61f9ced3-3ea6-45bd-b140-443634a7023b',1,'CES (Consumer Electronics Show)',60.73,13,1,'Bethany Corkery V','kacie52@gmail.com','I think--\' (for, you see, Miss, this here ought to have got in as well,\' the Hatter grumbled: \'you.',NULL,'10',60.73,2,121.46,121.46,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(11,'JMVYEPEAR9NF','887b62bb-baaf-4fb5-867e-4ced022f831b',2,'Mobile World Congress',18.34,31,1,'Elmore Schneider V','fflatley@sanford.net','THAT. Then again--\"BEFORE SHE HAD THIS FIT--\" you never tasted an egg!\' \'I HAVE tasted eggs.',NULL,'11',18.34,1,18.34,18.34,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(12,'8SDUTK0X1CM5','cc2e9633-9f7a-47b3-a7b7-c6b9910018cb',2,'Mobile World Congress',18.34,31,1,'Elmore Schneider V','fflatley@sanford.net','Twinkle, twinkle--\"\' Here the Dormouse turned out, and, by the time she saw maps and pictures hung.',NULL,'12',18.34,5,91.70,91.70,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00'),(13,'2XWYSS4QOMS3','e6a94e61-66e2-4c8e-958b-065f74fa8822',2,'Mobile World Congress',18.34,21,1,'Aiden Ondricka','heidenreich.creola@jerde.biz','Footman, and began to get in at the Hatter, it woke up again as she swam nearer to make out.',NULL,'13',18.34,1,18.34,18.34,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(14,'YDHX2NHKE5P3','9ab2f62e-5d40-4bb3-befa-345416e80256',2,'Mobile World Congress',18.34,8,1,'Dr. Beverly Zulauf','hbeatty@spencer.info','Latin Grammar, \'A mouse--of a mouse--to a mouse--a mouse--O mouse!\') The Mouse did not seem to.',NULL,'14',18.34,4,73.36,73.36,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(15,'E84OGTTYDXFY','ffe20e5b-82d8-4d45-bb7a-3f33b9a8a22c',2,'Mobile World Congress',18.34,29,1,'Pearline Cummerata','chadd95@rolfson.com','Mock Turtle sang this, very slowly and sadly:-- \'\"Will you walk a little way off, and found.',NULL,'15',18.34,1,18.34,18.34,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(16,'NG1XCX3NT0VX','f08e5cb1-6895-4a28-8a9d-635c4c9e31e5',2,'Mobile World Congress',18.34,7,1,'Edwin Boyle','abigale37@gmail.com','Gryphon. \'Well, I shan\'t go, at any rate I\'ll never go THERE again!\' said Alice sadly. \'Hand it.',NULL,'16',18.34,1,18.34,18.34,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(17,'9XV2IKO3VHEQ','1ea7fc0e-5a1f-4224-9d50-61ab9aea29b6',2,'Mobile World Congress',18.34,13,1,'Bethany Corkery V','kacie52@gmail.com','Alice, \'I\'ve often seen them so often, you know.\' \'Not the same age as herself, to see if there.',NULL,'17',18.34,1,18.34,18.34,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(18,'E5NC8MYQZCFU','77ff7d09-459b-460f-9ca1-2fbaf0ca8d42',2,'Mobile World Congress',18.34,1,1,'Dr. Felton Bruen II','customer@archielite.com','I\'m Mabel, I\'ll stay down here! It\'ll be no sort of knot, and then she walked down the bottle, she.',NULL,'18',18.34,5,91.70,91.70,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(19,'HNML5AXJ6FYQ','e5dd69f7-7974-4162-b3be-a7758a9da2fa',2,'Mobile World Congress',18.34,20,1,'Mr. Toy Ebert','zpouros@abbott.com','I will just explain to you to get in?\' she repeated, aloud. \'I must be getting home; the night-air.',NULL,'19',18.34,4,73.36,73.36,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(20,'ULFUAC7TFLYH','a5526038-bfe1-4a5d-8c9e-0baf02c46a77',2,'Mobile World Congress',18.34,13,1,'Bethany Corkery V','kacie52@gmail.com','Caterpillar\'s making such VERY short remarks, and she grew no larger: still it was out of the edge.',NULL,'20',18.34,1,18.34,18.34,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(21,'MCQA2UEXX8XW','5d62bc11-8c49-4b99-8b56-c642d2dfd07b',3,'Google I/O',79.58,21,1,'Aiden Ondricka','heidenreich.creola@jerde.biz','Oh, how I wish you wouldn\'t squeeze so.\' said the King. Here one of these cakes,\' she thought.',NULL,'21',79.58,5,397.90,397.90,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(22,'J96BP3FVENWA','40909623-5fba-441f-9478-4e4b327a1f70',3,'Google I/O',79.58,20,1,'Mr. Toy Ebert','zpouros@abbott.com','ONE with such a fall as this, I shall think nothing of tumbling down stairs! How brave they\'ll all.',NULL,'22',79.58,4,318.32,318.32,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(23,'C6LZH0BGYSYL','05277efe-b42c-4da7-80e9-26cc28366650',3,'Google I/O',79.58,20,1,'Mr. Toy Ebert','zpouros@abbott.com','Alice could see her after the birds! Why, she\'ll eat a bat?\' when suddenly, thump! thump! down she.',NULL,'23',79.58,3,238.74,238.74,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01'),(24,'ESOAXSCKKXNT','ea43be25-8da7-42f1-9f43-64027727e665',3,'Google I/O',79.58,31,1,'Elmore Schneider V','fflatley@sanford.net','IS that to be sure, this generally happens when you have of putting things!\' \'It\'s a friend of.',NULL,'24',79.58,3,238.74,238.74,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:01','2025-06-10 10:44:02'),(25,'VB7QYJRWBDWE','8e4df027-d33e-4b9a-ad86-013c0a2ee412',3,'Google I/O',79.58,13,1,'Bethany Corkery V','kacie52@gmail.com','Alice looked all round her head. \'If I eat one of the Rabbit\'s little white kid gloves, and was.',NULL,'25',79.58,1,79.58,79.58,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(26,'PZ45GZVK7IGE','e235f8a4-18ab-4dfa-b2e8-dd358af6f9fd',3,'Google I/O',79.58,11,1,'Marianna Skiles','orrin.anderson@gmail.com','Alice said; but was dreadfully puzzled by the little magic bottle had now had its full effect, and.',NULL,'26',79.58,5,397.90,397.90,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(27,'6VT52S3GW0ZC','91c4e33d-5a56-40b1-91d6-eef8a2476902',3,'Google I/O',79.58,13,1,'Bethany Corkery V','kacie52@gmail.com','And the Gryphon repeated impatiently: \'it begins \"I passed by his garden.\"\' Alice did not appear.',NULL,'27',79.58,5,397.90,397.90,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(28,'KDA6ECQKNG8I','5c40bf16-2507-4ec7-9737-53fce2f41228',3,'Google I/O',79.58,29,1,'Pearline Cummerata','chadd95@rolfson.com','Mock Turtle. \'She can\'t explain it,\' said Alice. \'I\'ve tried every way, and the game was in.',NULL,'28',79.58,3,238.74,238.74,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(29,'WYHEQJYJW9S8','39a50ca8-6aaf-4f0f-917d-d1651c5b3375',3,'Google I/O',79.58,29,1,'Pearline Cummerata','chadd95@rolfson.com','Drawling--the Drawling-master was an old crab, HE was.\' \'I never was so ordered about in the.',NULL,'29',79.58,2,159.16,159.16,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(30,'PKUY91GARVYR','66958291-a768-43b1-b45a-3020f62b2061',3,'Google I/O',79.58,7,1,'Edwin Boyle','abigale37@gmail.com','King. On this the whole pack rose up into hers--she could hear the very tones of her voice, and.',NULL,'30',79.58,2,159.16,159.16,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(31,'ZNS6Q03OC3FN','9cb08000-97a3-4abe-951f-b5520a940b60',4,'Apple WWDC',59.08,20,1,'Mr. Toy Ebert','zpouros@abbott.com','Caterpillar called after her. \'I\'ve something important to say!\' This sounded promising.',NULL,'31',59.08,5,295.40,295.40,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(32,'IJA4B4Z995FH','6bab2663-3448-4240-a02d-d26ece4de5f0',4,'Apple WWDC',59.08,29,1,'Pearline Cummerata','chadd95@rolfson.com','When she got back to them, they set to work very diligently to write with one eye, How the Owl had.',NULL,'32',59.08,2,118.16,118.16,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(33,'HOEHCXSAW9FI','3d7c5ac9-7c2f-4a05-913d-1b7a9326162e',4,'Apple WWDC',59.08,21,1,'Aiden Ondricka','heidenreich.creola@jerde.biz','There seemed to quiver all over with fright. \'Oh, I BEG your pardon!\' cried Alice hastily, afraid.',NULL,'33',59.08,3,177.24,177.24,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(34,'U2QAX9JF512Q','f5dd4058-6fb3-4a27-b4c0-2b61e2934c3e',4,'Apple WWDC',59.08,8,1,'Dr. Beverly Zulauf','hbeatty@spencer.info','I shall never get to twenty at that rate! However, the Multiplication Table doesn\'t signify: let\'s.',NULL,'34',59.08,4,236.32,236.32,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(35,'9R6WGAJXOJL8','780f19cb-e4d6-4059-93e1-ab8568b1d5e2',4,'Apple WWDC',59.08,1,1,'Dr. Felton Bruen II','customer@archielite.com','So she called softly after it, and kept doubling itself up very sulkily and crossed over to.',NULL,'35',59.08,3,177.24,177.24,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02'),(36,'CQJGBTXAM7OC','31ac180a-abbd-41d5-a269-080012fe9e33',4,'Apple WWDC',59.08,21,1,'Aiden Ondricka','heidenreich.creola@jerde.biz','Alice\'s great surprise, the Duchess\'s voice died away, even in the other: the Duchess to play.',NULL,'36',59.08,5,295.40,295.40,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(37,'8IVX9IIYPOIB','54d364bf-717f-47e1-be4e-b402148c13af',4,'Apple WWDC',59.08,31,1,'Elmore Schneider V','fflatley@sanford.net','And yet I wish I hadn\'t to bring tears into her eyes; and once again the tiny hands were clasped.',NULL,'37',59.08,2,118.16,118.16,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(38,'IXQPGVKHX2GL','9a53240d-5274-4ac7-b4ee-beb2af78f85a',4,'Apple WWDC',59.08,7,1,'Edwin Boyle','abigale37@gmail.com','Be off, or I\'ll have you executed.\' The miserable Hatter dropped his teacup instead of onions.\'.',NULL,'38',59.08,5,295.40,295.40,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(39,'YMS29ABKCJ6Z','cc10ac2a-584c-44b2-a4a2-340015fb6bef',4,'Apple WWDC',59.08,20,1,'Mr. Toy Ebert','zpouros@abbott.com','I hadn\'t drunk quite so much!\' Alas! it was over at last: \'and I do wonder what they said. The.',NULL,'39',59.08,5,295.40,295.40,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(40,'MLLHHHZUKUQT','3b0f0d7c-e198-47c7-a913-c896a66af9e7',4,'Apple WWDC',59.08,20,1,'Mr. Toy Ebert','zpouros@abbott.com','Alice, and looking anxiously round to see what this bottle was a general chorus of voices asked.',NULL,'40',59.08,3,177.24,177.24,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(41,'YT6MDDPVRE4M','ceffaa59-6edf-4623-b06f-697af63f398a',5,'AWS re:Invent',96.86,8,1,'Dr. Beverly Zulauf','hbeatty@spencer.info','Cheshire cat,\' said the Gryphon, before Alice could only hear whispers now and then; such as.',NULL,'41',96.86,3,290.58,290.58,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(42,'DPWNG81ZTSD9','58aa2608-0c61-406c-90a9-8cd0feea7f08',5,'AWS re:Invent',96.86,11,1,'Marianna Skiles','orrin.anderson@gmail.com','I\'m perfectly sure I can\'t tell you more than that, if you don\'t know the song, she kept tossing.',NULL,'42',96.86,4,387.44,387.44,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(43,'EMLOYL0TSW5R','6763868a-69de-4edf-968e-d4d7326b839c',5,'AWS re:Invent',96.86,8,1,'Dr. Beverly Zulauf','hbeatty@spencer.info','Do cats eat bats? Do cats eat bats, I wonder?\' As she said this, she came upon a low voice, to the.',NULL,'43',96.86,1,96.86,96.86,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(44,'4MKNLMF5KWP7','923bd383-e503-4e86-a5f5-c65da43457af',5,'AWS re:Invent',96.86,1,1,'Dr. Felton Bruen II','customer@archielite.com','WHAT? The other side of WHAT?\' thought Alice; \'but when you throw them, and then keep tight hold.',NULL,'44',96.86,1,96.86,96.86,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(45,'0DYOWF5LRFDD','b20886a1-845c-40eb-a351-b13f1d5aa70f',5,'AWS re:Invent',96.86,11,1,'Marianna Skiles','orrin.anderson@gmail.com','I mentioned before, And have grown most uncommonly fat; Yet you finished the guinea-pigs!\' thought.',NULL,'45',96.86,1,96.86,96.86,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(46,'DTDF4NK3LNP2','d28f2723-0cd8-46b9-9e3b-1569a0839a97',5,'AWS re:Invent',96.86,1,1,'Dr. Felton Bruen II','customer@archielite.com','This is the capital of Rome, and Rome--no, THAT\'S all wrong, I\'m certain! I must be off, then!\'.',NULL,'46',96.86,2,193.72,193.72,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(47,'5ORTXRLAARJR','496fa584-878c-4210-84be-d089223475e8',5,'AWS re:Invent',96.86,13,1,'Bethany Corkery V','kacie52@gmail.com','Duchess to play croquet.\' The Frog-Footman repeated, in the house, quite forgetting her promise.',NULL,'47',96.86,1,96.86,96.86,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03'),(48,'O6KAS0HMXTCI','ced80949-331c-4166-8baf-9a3a48338ef3',5,'AWS re:Invent',96.86,1,1,'Dr. Felton Bruen II','customer@archielite.com','INSIDE, you might do something better with the Duchess, \'as pigs have to go nearer till she was.',NULL,'48',96.86,4,387.44,387.44,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(49,'CKEUA4SUL5WW','50e10eb3-b220-41d4-8463-f1241106432f',5,'AWS re:Invent',96.86,1,1,'Dr. Felton Bruen II','customer@archielite.com','Mock Turtle, capering wildly about. \'Change lobsters again!\' yelled the Gryphon at the stick.',NULL,'49',96.86,4,387.44,387.44,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04'),(50,'WIXLQKJLXUDK','c7a6d43e-42da-4a4c-9296-460bc1b511ff',5,'AWS re:Invent',96.86,29,1,'Pearline Cummerata','chadd95@rolfson.com','It means much the most important piece of evidence we\'ve heard yet,\' said Alice; \'it\'s laid for a.',NULL,'50',96.86,1,96.86,96.86,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'OVWRYWAPDS2S','Miss Aisha Walter MD','dbechtelar@yahoo.com','0228296771','Alice would not allow without knowing how old it was, even before she gave one sharp kick, and.',NULL,'checked_in','2025-06-10 10:44:00','2025-06-10 10:44:00'),(2,1,'UOTIYPQMF5AB','Duncan Mann DVM','gbosco@hotmail.com','0210551840','I say again!\' repeated the Pigeon, but in a day did you ever eat a little startled when she had.',NULL,'reserved','2025-06-10 10:44:00','2025-06-10 10:44:00'),(3,1,'2CMNOCJQMGS4','Kaya Rogahn DDS','esauer@mitchell.com','0434272445','Caterpillar sternly. \'Explain yourself!\' \'I can\'t explain it,\' said the Hatter. \'Does YOUR watch.',NULL,'purchased','2025-06-10 10:44:00','2025-06-10 10:44:00'),(4,2,'6GJZ5SGNOH1U','Tatum Sporer','elmore.christiansen@thiel.com','0004774962','I\'ll stay down here till I\'m somebody else\"--but, oh dear!\' cried Alice, quite forgetting that she.',NULL,'checked_in','2025-06-10 10:44:00','2025-06-10 10:44:00'),(5,2,'WHPY9B30MFP8','Fannie Herzog','qlockman@larkin.com','0662261823','Gryphon. \'The reason is,\' said the Cat, and vanished. Alice was silent. The Dormouse had closed.',NULL,'reserved','2025-06-10 10:44:00','2025-06-10 10:44:00'),(6,2,'IHAI1KOAAPVC','Forrest Wehner','werdman@gmail.com','0093753538','I wonder if I like being that person, I\'ll come up: if not, I\'ll stay down here with me! There are.',NULL,'checked_in','2025-06-10 10:44:00','2025-06-10 10:44:00'),(7,2,'8PQBTPSPNEM8','Myrna Rodriguez','ischaefer@hotmail.com','0948383628','Hatter: \'I\'m on the ground near the house till she too began dreaming after a pause: \'the reason.',NULL,'refunded','2025-06-10 10:44:00','2025-06-10 10:44:00'),(8,2,'ND8NOOWPQVCZ','Cleta Lynch','jaime.murphy@yahoo.com','0030899117','Derision.\' \'I never saw one, or heard of one,\' said Alice. \'I mean what I was a little bird as.',NULL,'purchased','2025-06-10 10:44:00','2025-06-10 10:44:00'),(9,3,'S9LCJUHDJNX2','Anahi Hackett','jacobi.arden@oberbrunner.com','0167468587','Panther received knife and fork with a soldier on each side to guard him; and near the house if it.',NULL,'transferred','2025-06-10 10:44:00','2025-06-10 10:44:00'),(10,3,'Q19EEEHTEJEQ','Prof. Zena Schinner MD','jerod.dietrich@heidenreich.com','0377285319','It\'s by far the most important piece of evidence we\'ve heard yet,\' said Alice; \'you needn\'t be.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(11,4,'LXEBKRAKVOOW','Kenny Bashirian','lemke.odell@hettinger.com','0366590822','I begin, please your Majesty,\' said Alice to herself, rather sharply; \'I advise you to sit down.',NULL,'transferred','2025-06-10 10:44:00','2025-06-10 10:44:00'),(12,4,'7EKEGZFIQBYE','Prof. Kenyon Connelly','kuhic.ransom@yahoo.com','0175963982','Hatter went on, spreading out the proper way of speaking to it,\' she said to the Knave. The Knave.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(13,4,'1N5C3GVUGWD8','Mr. Salvador Reynolds','maida.walsh@bernier.com','0261183238','I am, sir,\' said Alice; \'but when you come to the Knave. The Knave of Hearts, who only bowed and.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(14,5,'IELRI2E4HKQR','Winifred Gerhold','ross82@hotmail.com','0044915965','Knave \'Turn them over!\' The Knave shook his head off outside,\' the Queen was to eat her up in such.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(15,5,'U44DGNKEG8GP','Prof. Craig Wiza DVM','joaquin.lind@yahoo.com','0184813544','And yet you incessantly stand on their throne when they met in the beautiful garden, among the.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(16,5,'HC1GVFKAMJF0','Brayan O\'Kon','kendra.schiller@dare.org','0975631647','I mentioned before, And have grown most uncommonly fat; Yet you balanced an eel on the same tone.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(17,5,'8XVPFGVSNB4R','Queenie Sanford','rrempel@gmail.com','0248908913','Dodo managed it.) First it marked out a history of the song. \'What trial is it?\' \'Why,\' said the.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(18,6,'GMCDZDEOQQ0W','Marcelina Auer II','boyer.jaclyn@rice.biz','0844462974','I like being that person, I\'ll come up: if not, I\'ll stay down here! It\'ll be no use going back to.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(19,6,'XA0QAVFNNVSG','Marcia Thompson','eschmidt@hotmail.com','0698886762','Alice an excellent opportunity for making her escape; so she bore it as far as they came nearer.',NULL,'transferred','2025-06-10 10:44:00','2025-06-10 10:44:00'),(20,6,'VTIBD5RDDVZN','Prof. Lea Waters PhD','jade.osinski@kilback.biz','0470703472','Sir, With no jury or judge, would be the best plan.\' It sounded an excellent plan, no doubt, and.',NULL,'refunded','2025-06-10 10:44:00','2025-06-10 10:44:00'),(21,6,'OS16CQMSW8PI','Dr. Aric Brown','marietta35@hotmail.com','0128263009','King exclaimed, turning to the jury, and the three were all writing very busily on slates. \'What.',NULL,'refunded','2025-06-10 10:44:00','2025-06-10 10:44:00'),(22,6,'PC4ULRVC8ONY','Jarred Cartwright','fupton@hotmail.com','0220649076','Hatter. \'I told you that.\' \'If I\'d been the whiting,\' said the Hatter, it woke up again as she.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(23,6,'I5Z3JZCFDPE2','Marcia Lebsack','alvera08@yahoo.com','0399171978','Hatter hurriedly left the court, \'Bring me the truth: did you do either!\' And the Eaglet bent down.',NULL,'transferred','2025-06-10 10:44:00','2025-06-10 10:44:00'),(24,7,'ZJX3E8PWCIEJ','Stephon Mraz','tomas23@smitham.com','0538395135','Turtle--we used to know. Let me see: four times seven is--oh dear! I wish I hadn\'t to bring tears.',NULL,'transferred','2025-06-10 10:44:00','2025-06-10 10:44:00'),(25,7,'MAYDXZI7GISF','Prof. Tyree Friesen','clemmie.prosacco@rolfson.org','0840580592','The Rabbit started violently, dropped the white kid gloves in one hand and a long and a sad tale!\'.',NULL,'transferred','2025-06-10 10:44:00','2025-06-10 10:44:00'),(26,7,'TLBURKTWHJC5','Reanna Watsica','chelsie.baumbach@jaskolski.com','0205329211','I\'ll eat it,\' said the Queen, who was beginning to think that will be much the same side of the.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(27,7,'KQB10OG9NZ7U','Wanda Cassin','senger.rodrick@thiel.com','0528418439','The Knave of Hearts, carrying the King\'s crown on a little shriek, and went on: \'But why did they.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(28,7,'D4KMZSXNDRGS','Irma Botsford','umosciski@adams.com','0891181911','The three soldiers wandered about for a baby: altogether Alice did not like the look of it.',NULL,'purchased','2025-06-10 10:44:00','2025-06-10 10:44:00'),(29,8,'9FFMF6CAFBCT','Prof. Jessie Paucek PhD','regan52@gmail.com','0698676807','What would become of it; then Alice dodged behind a great deal to ME,\' said Alice in a sort of.',NULL,'checked_in','2025-06-10 10:44:00','2025-06-10 10:44:00'),(30,8,'MASMDZIJGOL9','Koby Schmitt','jgoyette@schuppe.biz','0359580297','EVEN finish, if he would deny it too: but the cook till his eyes were looking up into a pig, my.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(31,8,'BVWTKY5QS3ZV','Jermey Labadie','cdouglas@brakus.org','0909221164','Alice asked. \'We called him a fish)--and rapped loudly at the flowers and those cool fountains.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(32,8,'X9NSCJOANIMS','Dr. Caleb Romaguera','schaefer.gay@gmail.com','0852437670','Lizard, who seemed too much of it in the pool of tears which she had to kneel down on one side, to.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(33,8,'RZ4ILO3GRGWF','Marco Ratke','genevieve.orn@gmail.com','0496266755','Five! Don\'t go splashing paint over me like that!\' By this time the Queen shouted at the end.\' \'If.',NULL,'refunded','2025-06-10 10:44:00','2025-06-10 10:44:00'),(34,9,'CL7TMRZKFV15','Connie Paucek DVM','wprosacco@mueller.org','0690372913','Alice was soon submitted to by the officers of the same side of the Shark, But, when the Rabbit.',NULL,'reserved','2025-06-10 10:44:00','2025-06-10 10:44:00'),(35,9,'TCUOCIYZ67XR','Florine Swift II','ambrose.quigley@gmail.com','0107176981','I sleep\" is the same solemn tone, only changing the order of the house opened, and a Canary called.',NULL,'cancelled','2025-06-10 10:44:00','2025-06-10 10:44:00'),(36,9,'17XL6BRTZ8HV','Abdullah Lubowitz PhD','lschulist@bayer.net','0048162000','Cat went on, half to Alice. \'What IS the same words as before, \'and things are worse than ever,\'.',NULL,'transferred','2025-06-10 10:44:00','2025-06-10 10:44:00'),(37,9,'XBBX7Y5DP9QQ','Kristofer Paucek II','wallace.lang@yahoo.com','0671649862','He looked at her feet as the soldiers shouted in reply. \'That\'s right!\' shouted the Queen say only.',NULL,'reserved','2025-06-10 10:44:00','2025-06-10 10:44:00'),(38,9,'GSGBWQVZAY6T','Nikita Windler','lester97@krajcik.com','0502559369','ALL RETURNED FROM HIM TO YOU,\"\' said Alice. \'I\'ve tried every way, and then quietly marched off.',NULL,'refunded','2025-06-10 10:44:00','2025-06-10 10:44:00'),(39,9,'PCK3HBBSPZNT','Davin Ziemann','margarita.beier@haag.com','0089334746','Alice quite jumped; but she stopped hastily, for the first position in which the wretched Hatter.',NULL,'refunded','2025-06-10 10:44:00','2025-06-10 10:44:00'),(40,10,'GTZXG7X75ULQ','Prof. Stephan Bartell V','rutherford.elda@bednar.biz','0264182645','How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure.',NULL,'checked_in','2025-06-10 10:44:00','2025-06-10 10:44:00'),(41,10,'ZV4VOFGSR59N','Jayde Klein','cassandra48@gmail.com','0101952277','Alice. \'I wonder if I know is, it would be only rustling in the beautiful garden, among the.',NULL,'checked_in','2025-06-10 10:44:00','2025-06-10 10:44:00'),(42,10,'WQC2MPQQ68HY','Ottis Pollich II','medhurst.jeanie@gislason.biz','0007830517','YOU with us!\"\' \'They were obliged to have any pepper in that case I can listen all day about it!\'.',NULL,'checked_in','2025-06-10 10:44:00','2025-06-10 10:44:00'),(43,11,'NA6R384UETM3','Gustave Strosin V','qgoldner@kulas.com','0066881090','Alice would not allow without knowing how old it was, and, as they were nowhere to be no doubt.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(44,11,'RO1F7F6UNZJ4','Jordi Baumbach','cameron33@connelly.com','0031974031','There was a very difficult game indeed. The players all played at once set to work very carefully.',NULL,'reserved','2025-06-10 10:44:00','2025-06-10 10:44:00'),(45,12,'8UDMZ6QD2A0U','Darby Beier','cindy58@gmail.com','0517252890','Alice; \'but when you throw them, and the little door, so she turned the corner, but the Gryphon.',NULL,'pending','2025-06-10 10:44:00','2025-06-10 10:44:00'),(46,12,'UGANKIEWG0KE','Ursula Witting','goldner.cecil@yahoo.com','0882726534','Soup! Soup of the suppressed guinea-pigs, filled the air, mixed up with the Dormouse. \'Fourteenth.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(47,12,'QSG5GY91DVRQ','Dion Goldner','mara74@gmail.com','0381601001','March Hare. \'Yes, please do!\' but the Hatter was the first figure!\' said the Caterpillar. This was.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(48,12,'6LJSLN9NSAQR','Jay Wiegand Sr.','hermiston.ofelia@friesen.com','0615488811','Mouse with an M?\' said Alice. \'Well, I never knew whether it was too late to wish that! She went.',NULL,'checked_in','2025-06-10 10:44:01','2025-06-10 10:44:01'),(49,12,'IGFJCF0CUWYD','Louie Schneider MD','kprohaska@gmail.com','0273305731','The great question certainly was, what? Alice looked at her own child-life, and the beak-- Pray.',NULL,'cancelled','2025-06-10 10:44:01','2025-06-10 10:44:01'),(50,12,'SZMH3EREU3PS','Dr. Emil Lindgren Sr.','steuber.russell@yahoo.com','0711180478','Gryphon, and the baby was howling so much at this, that she did so, and giving it a minute or two.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(51,13,'QAMTZGSF5O7N','Prof. Ivy Batz','mdare@brekke.com','0569020565','Caterpillar decidedly, and there stood the Queen never left off staring at the end of his tail.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(52,13,'USICRMWUJRGN','Roosevelt Christiansen PhD','kuphal.mona@cummings.com','0237264109','Hatter, it woke up again with a melancholy tone: \'it doesn\'t seem to have it explained,\' said the.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(53,14,'ZXEAHSBBTB4Z','Elliot Grimes MD','dboehm@yahoo.com','0206196982','Ma!\' said the King said, for about the crumbs,\' said the Cat, \'or you wouldn\'t have come here.\'.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(54,14,'FEF2LCJLWNAH','Dr. Raymond Jakubowski DDS','apacocha@hotmail.com','0530920750','Turtle. \'Very much indeed,\' said Alice. \'Oh, don\'t talk about cats or dogs either, if you like,\'.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(55,14,'UNYYDRRT8RC9','Mason Bode','gulgowski.buck@ledner.biz','0403520524','I only knew the right size again; and the Panther were sharing a pie--\' [later editions continued.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(56,14,'DDHO4NVMLDAE','Laney Douglas','zkshlerin@witting.biz','0298133924','In another minute there was no \'One, two, three, and away,\' but they all spoke at once, she found.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(57,14,'TYW6OANDDGJ6','Zachery Terry IV','ccollier@yahoo.com','0308913626','Lory positively refused to tell you--all I know is, it would be so stingy about it, even if my.',NULL,'checked_in','2025-06-10 10:44:01','2025-06-10 10:44:01'),(58,15,'2K9HAQCXFZSX','Leda Jaskolski','gmcglynn@hotmail.com','0621626179','Hatter. \'Stolen!\' the King repeated angrily, \'or I\'ll have you executed on the top with its arms.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(59,15,'PW1X3TSFPTVZ','Kane Jacobson','corwin.juvenal@gmail.com','0117140879','Some of the words \'DRINK ME,\' but nevertheless she uncorked it and put it right; \'not that it.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(60,16,'1J2O1EZTYLIV','Madie Kuhn','tomasa.mclaughlin@hotmail.com','0040305646','Those whom she sentenced were taken into custody by the soldiers, who of course you know why it\'s.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(61,16,'MFB300RCRT99','Makayla Senger','xbogan@moen.org','0178861381','In the very middle of her own mind (as well as pigs, and was delighted to find her way through the.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(62,17,'0PGZFKEWSNAP','Reba Mitchell','orie54@gmail.com','0261723710','Mouse to Alice to herself. At this moment Alice appeared, she was now about two feet high, and her.',NULL,'cancelled','2025-06-10 10:44:01','2025-06-10 10:44:01'),(63,17,'IYUWCFQXR0DB','Mohammad O\'Keefe IV','kuhn.hillard@hotmail.com','0301036706','Pennyworth only of beautiful Soup? Pennyworth only of beautiful Soup? Pennyworth only of beautiful.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(64,18,'5ZK4WFHVENFI','Mr. Julien Haag','macie53@gmail.com','0496428300','Duchess sneezed occasionally; and as for the hot day made her feel very sleepy and stupid).',NULL,'reserved','2025-06-10 10:44:01','2025-06-10 10:44:01'),(65,18,'0ECJP8VHQZXN','Prof. Darrick Waters','renee.schmeler@dickens.com','0125848808','Rabbit say to itself in a day did you manage on the whole party look so grave that she did not.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(66,18,'TVMUX2L21LIV','Prof. Al Koelpin I','darrin53@sanford.com','0303721313','Alice had got so much surprised, that for the White Rabbit. She was a long sleep you\'ve had!\' \'Oh.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(67,18,'IEW5P68H3QF5','Beaulah Skiles','richard34@veum.com','0047536309','Panther were sharing a pie--\' [later editions continued as follows When the pie was all about, and.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(68,18,'TBMXTYQIGCDM','Mr. Cloyd O\'Connell','jauer@gmail.com','0070036084','And the muscular strength, which it gave to my right size for going through the air! Do you think.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(69,18,'JM7HNGCFHBKF','Ms. Faye Waelchi Sr.','avery.lang@marks.com','0468822080','I shall ever see you again, you dear old thing!\' said Alice, \'because I\'m not Ada,\' she said.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(70,19,'QACYOHP0ID7H','Mr. Danial Nitzsche','ohane@gmail.com','0602469871','I eat one of them were animals, and some \'unimportant.\' Alice could not taste theirs, and the.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(71,19,'GRTR47HYLMLT','Josianne Ankunding','umosciski@robel.biz','0910202938','Hatter trembled so, that he shook both his shoes off. \'Give your evidence,\' said the Hatter.',NULL,'reserved','2025-06-10 10:44:01','2025-06-10 10:44:01'),(72,19,'6INXTJDVYYYS','Angel Yundt IV','nelda60@glover.biz','0169952265','Alice would not join the dance. So they couldn\'t get them out of sight, he said do. Alice looked.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(73,19,'YGSOO128UTMB','Sadie Konopelski','fahey.jesus@kuhic.com','0431116588','White Rabbit, jumping up and said, very gravely, \'I think, you ought to eat some of the pack, she.',NULL,'cancelled','2025-06-10 10:44:01','2025-06-10 10:44:01'),(74,19,'CY4BXMVK2TS5','Scotty Ernser','elinore.gusikowski@gmail.com','0634426019','Alice to herself. (Alice had no reason to be a footman in livery came running out of sight: then.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(75,20,'QXU0U3MDJQZT','Dr. Dejah O\'Keefe','nya59@wunsch.com','0182946539','Pennyworth only of beautiful Soup? Pennyworth only of beautiful Soup? Beau--ootiful Soo--oop!.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(76,20,'DZK9JAZVOKVJ','Mr. Houston Kshlerin','edison.gerhold@corkery.net','0611185452','Puss,\' she began, in a very difficult game indeed. The players all played at once took up the.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(77,21,'0TYKMBHZLXDC','Lowell Adams DVM','christiana.rosenbaum@rowe.info','0949547887','Gryphon whispered in reply, \'for fear they should forget them before the end of the hall; but.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(78,21,'HBHQUE1HNRFH','Lisa Johnston MD','haylie.beer@stehr.com','0754898095','Alice, flinging the baby with some severity; \'it\'s very easy to know when the race was over.',NULL,'pending','2025-06-10 10:44:01','2025-06-10 10:44:01'),(79,21,'EEDRGXVVKBLB','Brenden Kohler','gino91@schmeler.com','0676960807','The first witness was the first really clever thing the King said gravely, \'and go on in a great.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(80,21,'868TWZDEDIMB','Mrs. Mabelle Metz','dauer@hotmail.com','0389744343','And so it was very likely it can talk: at any rate: go and take it away!\' There was not an.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(81,21,'CIR80SA58IYR','Kevin Streich','mylene.gutkowski@parker.com','0745398948','Gryphon added \'Come, let\'s try Geography. London is the use of a sea of green leaves that lay far.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(82,21,'ESCLLA8HVSCK','Dorthy Graham','lhuel@bayer.com','0873896688','Dormouse, who seemed to be a great deal too flustered to tell him. \'A nice muddle their slates\'ll.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(83,22,'8T57UY1UOO6G','Lonzo Hoppe','bschamberger@gmail.com','0503440231','King said to herself; \'the March Hare interrupted in a tone of great curiosity. \'It\'s a friend of.',NULL,'checked_in','2025-06-10 10:44:01','2025-06-10 10:44:01'),(84,22,'MXPBYFCZRVJT','Kamryn Littel','brittany.shanahan@feeney.info','0339316089','Knave, \'I didn\'t mean it!\' pleaded poor Alice. \'But you\'re so easily offended!\' \'You\'ll get used.',NULL,'reserved','2025-06-10 10:44:01','2025-06-10 10:44:01'),(85,22,'YZ13UVM47IAM','Joyce Zboncak','lueilwitz.caleb@huels.com','0505137196','Mouse. \'--I proceed. \"Edwin and Morcar, the earls of Mercia and Northumbria, declared for him: and.',NULL,'refunded','2025-06-10 10:44:01','2025-06-10 10:44:01'),(86,22,'WKXTDCYGV9DL','Aisha Quitzon','asia18@yahoo.com','0459562747','The long grass rustled at her as she couldn\'t answer either question, it didn\'t much matter which.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(87,22,'DPJF4CJATWPD','Mrs. Carlotta Nolan V','myriam.denesik@bruen.com','0054969271','Alice, quite forgetting her promise. \'Treacle,\' said the Hatter, and he hurried off. Alice thought.',NULL,'purchased','2025-06-10 10:44:01','2025-06-10 10:44:01'),(88,23,'08CICI9CTY3G','Jaquan Dickinson','pasquale52@prosacco.biz','0240065771','Lizard\'s slate-pencil, and the party went back to her: first, because the Duchess said after a.',NULL,'cancelled','2025-06-10 10:44:01','2025-06-10 10:44:01'),(89,23,'P3S155WVHMRF','Estevan Mante','yundt.myrtie@yahoo.com','0755782278','So she set to work, and very angrily. \'A knot!\' said Alice, and she drew herself up closer to.',NULL,'checked_in','2025-06-10 10:44:01','2025-06-10 10:44:01'),(90,23,'2B2ORSJZ6IJG','Geo Rice V','gbuckridge@yahoo.com','0309149091','VERY ugly; and secondly, because she was talking. \'How CAN I have done that, you know,\' the Mock.',NULL,'transferred','2025-06-10 10:44:01','2025-06-10 10:44:01'),(91,23,'TYWY4M3G6HBD','Isabelle Ernser','edoyle@borer.com','0681655805','I wonder what CAN have happened to me! I\'LL soon make you a song?\' \'Oh, a song, please, if the.',NULL,'cancelled','2025-06-10 10:44:01','2025-06-10 10:44:01'),(92,24,'B2NCQ7HQUV67','Austen Collier','kertzmann.eliseo@stark.info','0460400985','Alice, \'and why it is I hate cats and dogs.\' It was the BEST butter,\' the March Hare took the.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(93,24,'EYX4YSQPRXSS','Ken Konopelski','stracke.austin@bartoletti.com','0533379800','King, \'or I\'ll have you executed on the second verse of the same tone, exactly as if he had taken.',NULL,'checked_in','2025-06-10 10:44:02','2025-06-10 10:44:02'),(94,24,'OFXRRFYGWSRS','Modesta Adams','madge18@hotmail.com','0117776868','And she kept tossing the baby at her side. She was a dead silence. Alice noticed with some.',NULL,'pending','2025-06-10 10:44:02','2025-06-10 10:44:02'),(95,24,'GYBLIZXIIOYJ','Furman Morar','alfredo.wisoky@hotmail.com','0012369342','King said to herself; \'the March Hare went on. \'I do,\' Alice hastily replied; \'at least--at least.',NULL,'checked_in','2025-06-10 10:44:02','2025-06-10 10:44:02'),(96,25,'LGGHLI9LDFKH','Mr. Skye Russel V','wleffler@hilpert.com','0010125345','For some minutes the whole party at once without waiting for the Duchess said in a day is very.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(97,25,'PANFILCJQOP5','Nathaniel Beer','vonrueden.kenyatta@gmail.com','0358287159','March Hare and his buttons, and turns out his toes.\' [later editions continued as follows The.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(98,26,'NGBUUP3QUY0Q','Mrs. Lela Friesen I','abbott.amelie@bednar.net','0018656122','Alice desperately: \'he\'s perfectly idiotic!\' And she tried the little door into that beautiful.',NULL,'checked_in','2025-06-10 10:44:02','2025-06-10 10:44:02'),(99,26,'JBBJGJQZ1KZM','Kory Kihn Sr.','ebert.gwen@bruen.com','0196603370','Queen. \'Sentence first--verdict afterwards.\' \'Stuff and nonsense!\' said Alice more boldly: \'you.',NULL,'pending','2025-06-10 10:44:02','2025-06-10 10:44:02'),(100,26,'HZBUWDE8OWVT','Dorthy Cronin','sebastian06@yahoo.com','0629244470','Gryphon answered, very nearly getting up and say \"How doth the little glass table. \'Now, I\'ll.',NULL,'pending','2025-06-10 10:44:02','2025-06-10 10:44:02'),(101,26,'X5RHBEVYE5FH','Sherman Koelpin','mitchel43@mante.com','0136085403','Queen, and Alice, were in custody and under sentence of execution.\' \'What for?\' said the King.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(102,26,'RWBH9CJLYNLB','Hortense Torphy IV','xfunk@hotmail.com','0530614286','She felt very lonely and low-spirited. In a minute or two, she made her look up in her life, and.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(103,26,'KIPSWJWDM2BF','Bonita Ledner','evangeline46@hotmail.com','0124667242','Alice, whose thoughts were still running on the floor, and a Canary called out \'The race is over!\'.',NULL,'checked_in','2025-06-10 10:44:02','2025-06-10 10:44:02'),(104,27,'LB6XUWDT2ZIG','Otis Zieme III','hohara@upton.com','0789972610','Alice, in a great hurry; \'this paper has just been reading about; and when she went on, \'I must be.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(105,27,'NROS6MULBCOX','Dr. Hank Kuvalis','bernhard53@runolfsdottir.com','0191241981','Alice dear!\' said her sister; \'Why, what a dear little puppy it was!\' said Alice, in a sorrowful.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(106,27,'UYUZUUVHHBSM','Erna Welch II','reba52@kshlerin.info','0818745566','He looked anxiously round, to make it stop. \'Well, I\'d hardly finished the guinea-pigs!\' thought.',NULL,'reserved','2025-06-10 10:44:02','2025-06-10 10:44:02'),(107,27,'ABI1JWIXRXO2','Philip Powlowski','gmertz@hotmail.com','0868224462','Hatter. This piece of rudeness was more hopeless than ever: she sat down and make out who was.',NULL,'reserved','2025-06-10 10:44:02','2025-06-10 10:44:02'),(108,27,'WJQBIRT1E5VC','Kenny Prosacco','julianne30@schiller.net','0918448938','AND WASHING--extra.\"\' \'You couldn\'t have wanted it much,\' said Alice, \'because I\'m not used to say.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(109,27,'AKPMOQZU52PR','Donavon Langosh','francisca40@franecki.com','0696248496','I can\'t get out again. That\'s all.\' \'Thank you,\' said the Mock Turtle a little irritated at the.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(110,28,'ASYGYAFVXPAN','Kade Greenholt','hauck.rupert@bergnaum.com','0121042581','Everybody looked at Alice. \'I\'M not a regular rule: you invented it just at present--at least I.',NULL,'cancelled','2025-06-10 10:44:02','2025-06-10 10:44:02'),(111,28,'11VOVY3CHXAM','Mona Brakus','carlo06@yahoo.com','0614074739','MINE.\' The Queen turned crimson with fury, and, after waiting till she heard a voice of the words.',NULL,'cancelled','2025-06-10 10:44:02','2025-06-10 10:44:02'),(112,28,'D65TNYW5MOGG','Ansley Rutherford MD','adalberto.adams@gmail.com','0483181257','PROVES his guilt,\' said the Caterpillar. \'Well, perhaps not,\' said Alice thoughtfully: \'but.',NULL,'transferred','2025-06-10 10:44:02','2025-06-10 10:44:02'),(113,28,'KCZYZ6XKQMQR','Krista Barton','sandy80@gmail.com','0220922238','Alice would not allow without knowing how old it was, and, as the jury eagerly wrote down on their.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(114,29,'H3JXV7NVRW71','Mr. Milo Spencer V','ronny.simonis@gmail.com','0082469018','An obstacle that came between Him, and ourselves, and it. Don\'t let me help to undo it!\' \'I shall.',NULL,'transferred','2025-06-10 10:44:02','2025-06-10 10:44:02'),(115,29,'QW6OZQRSZSUJ','Mrs. Karelle Upton III','alehner@hotmail.com','0126414381','She had just begun to think about stopping herself before she found she could remember them, all.',NULL,'cancelled','2025-06-10 10:44:02','2025-06-10 10:44:02'),(116,29,'K9BAWSD4BMOD','Alysa Gleichner','stefan.franecki@yahoo.com','0961043742','March Hare. \'Yes, please do!\' pleaded Alice. \'And where HAVE my shoulders got to? And oh, I wish.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(117,30,'SVVFK5A7XUD0','Destinee Orn','rau.leila@gmail.com','0749281570','Next came an angry tone, \'Why, Mary Ann, what ARE you talking to?\' said one of its little eyes.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(118,30,'E6TGLCOJ0KVJ','Anastacio McGlynn','kuhn.morgan@hotmail.com','0851799656','For the Mouse only growled in reply. \'Idiot!\' said the King: \'leave out that it led into a doze.',NULL,'pending','2025-06-10 10:44:02','2025-06-10 10:44:02'),(119,30,'D006K0JTZ9E5','Mikel Bernier','oberbrunner.april@boyer.com','0343448781','Alice severely. \'What are tarts made of?\' Alice asked in a court of justice before, but she.',NULL,'reserved','2025-06-10 10:44:02','2025-06-10 10:44:02'),(120,31,'APITO2PBWJYY','Lionel Kshlerin','luna45@kulas.org','0049439851','ONE.\' \'One, indeed!\' said Alice, \'a great girl like you,\' (she might well say that \"I see what was.',NULL,'pending','2025-06-10 10:44:02','2025-06-10 10:44:02'),(121,31,'PFEEJDK9TG3Z','Minnie Kub','helmer.russel@yahoo.com','0372536993','She had not gone (We know it was certainly not becoming. \'And that\'s the jury, and the baby with.',NULL,'cancelled','2025-06-10 10:44:02','2025-06-10 10:44:02'),(122,31,'BIQ2HSYWJ6BR','Romaine Abernathy','woodrow79@yahoo.com','0057856633','SOMETHING interesting is sure to happen,\' she said to the Knave of Hearts, he stole those tarts.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(123,31,'6STG3TOOETQQ','Miss Adrianna Schmitt','rosalinda23@gmail.com','0300369456','Caterpillar contemptuously. \'Who are YOU?\' said the Mock Turtle went on. \'Or would you like to be.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(124,31,'BXMYAMZURGOF','Bernhard Monahan','august95@gmail.com','0234618161','The Mouse did not get hold of anything, but she got back to yesterday, because I was sent for.\'.',NULL,'reserved','2025-06-10 10:44:02','2025-06-10 10:44:02'),(125,31,'JAD5HDVXWWR8','Keira Schroeder MD','bashirian.cornell@schmeler.com','0986062043','Caterpillar The Caterpillar and Alice was not here before,\' said the Mock Turtle. \'Very much.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(126,32,'WUOEAWQB5TS1','Destiney Dare','thirthe@kassulke.info','0120556242','The Cat only grinned a little shaking among the branches, and every now and then; such as, that a.',NULL,'checked_in','2025-06-10 10:44:02','2025-06-10 10:44:02'),(127,32,'IHQZQCUMGYV6','Norma Braun','jazmyn.toy@gmail.com','0969762986','Caterpillar. \'Not QUITE right, I\'m afraid,\' said Alice, rather alarmed at the top of it. She.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(128,32,'KOD0RMBSONLN','Miss Mable O\'Reilly IV','tstroman@gorczany.info','0122349086','I don\'t want YOU with us!\"\' \'They were obliged to have the experiment tried. \'Very true,\' said the.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(129,33,'NAQOEQK3OYJO','Tyra Stehr','maymie74@reichel.com','0642571742','French mouse, come over with William the Conqueror.\' (For, with all speed back to my jaw, Has.',NULL,'checked_in','2025-06-10 10:44:02','2025-06-10 10:44:02'),(130,33,'DG9J5XYFOJXG','Anabel Kunze','goyette.carmen@gmail.com','0962220038','Alice called out as loud as she heard it before,\' said the Gryphon. \'It\'s all his fancy, that: he.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(131,33,'K5XQEY0YWAAN','Arnold McLaughlin','alysson25@yahoo.com','0231790133','YOUR table,\' said Alice; \'I must be kind to them,\' thought Alice, \'as all the first position in.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(132,33,'MAXSXHRRRIMN','Pasquale Wilderman','frederique.nienow@gmail.com','0922721469','YOU like cats if you want to go nearer till she was beginning very angrily, but the Dodo said.',NULL,'reserved','2025-06-10 10:44:02','2025-06-10 10:44:02'),(133,34,'MCLXMTGAJJSQ','Federico Ryan','qherman@yahoo.com','0363497737','Alice did not like to be told so. \'It\'s really dreadful,\' she muttered to herself, as well as she.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(134,34,'W6MREDISWT6I','Zella Mosciski DVM','hailie.lockman@waelchi.biz','0072312692','Alice, \'to pretend to be lost, as she left her, leaning her head through the glass, and she could.',NULL,'pending','2025-06-10 10:44:02','2025-06-10 10:44:02'),(135,34,'UIMBCF9JUNAY','Leland Smith','kathlyn20@yahoo.com','0419472542','Alice said very politely, feeling quite pleased to find that she had not gone much farther before.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(136,34,'4NQAOLGNE0ZF','Francesco Hodkiewicz','bstark@yahoo.com','0354536107','Alice, \'they\'re sure to kill it in a minute or two, which gave the Pigeon the opportunity of.',NULL,'reserved','2025-06-10 10:44:02','2025-06-10 10:44:02'),(137,34,'8LB3VOMHCW6Y','Mr. Mervin Jacobson III','runolfsson.armani@jacobi.info','0555490290','I needn\'t be so stingy about it, so she began looking at the time she went on. \'Would you tell.',NULL,'purchased','2025-06-10 10:44:02','2025-06-10 10:44:02'),(138,35,'YDQY5BK46U2M','Ms. Lurline Smith','hills.howell@shields.com','0509092489','Duck. \'Found IT,\' the Mouse replied rather impatiently: \'any shrimp could have told you butter.',NULL,'checked_in','2025-06-10 10:44:02','2025-06-10 10:44:02'),(139,35,'F0PJLRZYE5KM','Dell Toy','emorar@parker.com','0130175780','I\'ll kick you down stairs!\' \'That is not said right,\' said the Queen, in a day did you manage to.',NULL,'refunded','2025-06-10 10:44:02','2025-06-10 10:44:02'),(140,35,'K0UM1H7HW31I','Felicia Bins','daphney.hauck@homenick.com','0693493560','Majesty,\' said the Gryphon. \'I\'ve forgotten the little golden key and hurried upstairs, in great.',NULL,'cancelled','2025-06-10 10:44:02','2025-06-10 10:44:02'),(141,35,'1HE9K6GSQUMB','Adam Abbott','zieme.reagan@grady.net','0838634579','At this the White Rabbit read:-- \'They told me he was going on within--a constant howling and.',NULL,'reserved','2025-06-10 10:44:02','2025-06-10 10:44:02'),(142,36,'96IWEKFSIMJN','Rebekah Hintz','peichmann@keebler.net','0641927989','This is the capital of Paris, and Paris is the same solemn tone, only changing the order of the.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(143,36,'SBRXS7W1BRPG','Prof. Madge Doyle II','ramon70@walker.com','0854780250','WAS a narrow escape!\' said Alice, in a low, hurried tone. He looked at them with one finger; and.',NULL,'refunded','2025-06-10 10:44:03','2025-06-10 10:44:03'),(144,36,'QSEZG0B4GAG8','Prof. Makenna O\'Connell','dicki.hulda@abbott.biz','0702694670','However, I\'ve got back to the Knave of Hearts, and I shall remember it in a whisper, half afraid.',NULL,'pending','2025-06-10 10:44:03','2025-06-10 10:44:03'),(145,36,'UQP7WHAP3QQL','Prof. Alysson Hauck','homenick.malvina@schowalter.com','0340301962','I eat or drink something or other; but the Rabbit just under the circumstances. There was nothing.',NULL,'transferred','2025-06-10 10:44:03','2025-06-10 10:44:03'),(146,36,'8XGP456GH77V','Viviane Boyle','jake.gleason@yahoo.com','0220602928','Hatter. \'I told you butter wouldn\'t suit the works!\' he added looking angrily at the thought that.',NULL,'pending','2025-06-10 10:44:03','2025-06-10 10:44:03'),(147,36,'2DRPVHXAXYCM','Frankie Gerlach','lschuster@gmail.com','0573426342','Alice was only the pepper that had slipped in like herself. \'Would it be of very little way.',NULL,'cancelled','2025-06-10 10:44:03','2025-06-10 10:44:03'),(148,37,'W3CSX3VWWRCE','Karen Emard','jacobson.elwin@wyman.com','0194355646','I think that will be much the same thing, you know.\' \'I DON\'T know,\' said Alice sharply, for she.',NULL,'pending','2025-06-10 10:44:03','2025-06-10 10:44:03'),(149,37,'X0557FSJFQVL','Chyna Jacobson','anthony23@yahoo.com','0389013647','She gave me a good deal worse off than before, as the Rabbit, and had to sing \"Twinkle, twinkle.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(150,37,'ZVYNNGZ0NTWC','Dr. Estrella Mayert DVM','bailey.vanessa@greenholt.info','0400345819','Duchess. \'Everything\'s got a moral, if only you can find them.\' As she said to the seaside once in.',NULL,'pending','2025-06-10 10:44:03','2025-06-10 10:44:03'),(151,38,'MAWKQ6R02I7G','Alysson Wisoky','sage.armstrong@swaniawski.com','0169833178','Alice said very politely, \'if I had our Dinah here, I know is, something comes at me like that!\'.',NULL,'purchased','2025-06-10 10:44:03','2025-06-10 10:44:03'),(152,38,'CTDIWOLOFZKJ','Dr. Emanuel McKenzie','bruen.audreanne@gmail.com','0879430898','Alice to find her in such a neck as that! No, no! You\'re a serpent; and there\'s no meaning in it.',NULL,'cancelled','2025-06-10 10:44:03','2025-06-10 10:44:03'),(153,38,'RXAB8GV0R21I','Zora Vandervort','dicki.gabrielle@pfeffer.com','0433681310','Five, \'and I\'ll tell you what year it is?\' \'Of course not,\' said the last words out loud, and the.',NULL,'pending','2025-06-10 10:44:03','2025-06-10 10:44:03'),(154,38,'MVEBJT8HPU05','Roxane Pfeffer','dylan63@hotmail.com','0573835431','I like being that person, I\'ll come up: if not, I\'ll stay down here! It\'ll be no doubt that it was.',NULL,'reserved','2025-06-10 10:44:03','2025-06-10 10:44:03'),(155,38,'W9JY2QJRBXMK','Dr. Stephan Monahan Sr.','joanny.heller@yahoo.com','0638265685','I was thinking I should think!\' (Dinah was the first question, you know.\' It was, no doubt: only.',NULL,'purchased','2025-06-10 10:44:03','2025-06-10 10:44:03'),(156,38,'UH8AM9VLWVR9','Dr. Jazmyn Wisoky','cartwright.maggie@haley.com','0657229411','Gryphon, the squeaking of the country is, you ARE a simpleton.\' Alice did not get hold of it; then.',NULL,'refunded','2025-06-10 10:44:03','2025-06-10 10:44:03'),(157,39,'PWXLYYHGSXBA','Jocelyn Kub','prudence19@schulist.com','0659875550','Alice. \'And be quick about it,\' said the Gryphon. \'It\'s all his fancy, that: they never executes.',NULL,'transferred','2025-06-10 10:44:03','2025-06-10 10:44:03'),(158,39,'UXU7ZDDXKMVE','Raphael Hyatt','hcremin@gmail.com','0878958564','How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure I\'m.',NULL,'purchased','2025-06-10 10:44:03','2025-06-10 10:44:03'),(159,39,'OEK3NBCEO5Q7','Miss Freda Cummerata','dach.karen@miller.com','0098593156','French lesson-book. The Mouse looked at the number of changes she had found her head in the wind.',NULL,'reserved','2025-06-10 10:44:03','2025-06-10 10:44:03'),(160,39,'8WEJW1QG4AA7','Deven Emmerich','lemuel09@aufderhar.com','0728910149','YOU must cross-examine the next witness.\' And he added in a moment like a telescope! I think I.',NULL,'refunded','2025-06-10 10:44:03','2025-06-10 10:44:03'),(161,39,'DAIFOCCOZG8I','Armando Ruecker I','russel.makenzie@hotmail.com','0120166095','Alice would not join the dance. So they got settled down again very sadly and quietly, and looked.',NULL,'refunded','2025-06-10 10:44:03','2025-06-10 10:44:03'),(162,39,'P3MO18AQDBEK','Miss Ivah Padberg Sr.','barrett52@hotmail.com','0588175322','I\'ve finished.\' So they went on in a more subdued tone, and added with a little glass box that was.',NULL,'purchased','2025-06-10 10:44:03','2025-06-10 10:44:03'),(163,40,'CV5JFS8N4HPZ','Prof. Randy Herzog III','qterry@gmail.com','0162635383','I get it home?\' when it saw Alice. It looked good-natured, she thought: still it was perfectly.',NULL,'reserved','2025-06-10 10:44:03','2025-06-10 10:44:03'),(164,40,'ZSEGETU1B1T2','Colleen Toy','golda.bahringer@nikolaus.info','0028516054','March Hare went \'Sh! sh!\' and the little door about fifteen inches high: she tried the roots of.',NULL,'reserved','2025-06-10 10:44:03','2025-06-10 10:44:03'),(165,40,'4BF9PIGN3G3A','Gay Wisozk','abbott.otis@yahoo.com','0232861223','Hatter. \'He won\'t stand beating. Now, if you don\'t explain it as you are; secondly, because she.',NULL,'reserved','2025-06-10 10:44:03','2025-06-10 10:44:03'),(166,40,'IL7SXERTZNIF','Kadin Stehr','vrogahn@gmail.com','0832379841','Soup? Pennyworth only of beautiful Soup? Beau--ootiful Soo--oop! Soo--oop of the mushroom, and.',NULL,'cancelled','2025-06-10 10:44:03','2025-06-10 10:44:03'),(167,41,'VHUSAEXKJHWR','Prof. Sterling Rolfson Jr.','dylan.bogan@lindgren.com','0051420581','Hatter: \'let\'s all move one place on.\' He moved on as he came, \'Oh! the Duchess, as she added, to.',NULL,'cancelled','2025-06-10 10:44:03','2025-06-10 10:44:03'),(168,41,'XU3HUUNJO7DF','Christina Torp','jackie04@abbott.net','0519179759','Alice said nothing; she had never seen such a puzzled expression that she was playing against.',NULL,'purchased','2025-06-10 10:44:03','2025-06-10 10:44:03'),(169,41,'CRJMW6ID0EF7','Lavina Mitchell','herman.veronica@yahoo.com','0051886791','That\'s all.\' \'Thank you,\' said the White Rabbit read out, at the corners: next the ten courtiers.',NULL,'refunded','2025-06-10 10:44:03','2025-06-10 10:44:03'),(170,41,'ZQTGLIPKQJ0M','Cristopher Champlin','astiedemann@herzog.com','0685980368','But here, to Alice\'s great surprise, the Duchess\'s cook. She carried the pepper-box in her haste.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(171,42,'4F0FWDA84REP','Dr. Tracey Heidenreich','nader.lelia@reinger.com','0977876891','The Hatter\'s remark seemed to quiver all over their shoulders, that all the rest of the words came.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(172,42,'FTMJUDZBYK9A','Abdul Reichert','kathleen.littel@gmail.com','0878888479','Hatter hurriedly left the court, \'Bring me the list of singers. \'You may go,\' said the Dodo. Then.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(173,42,'3H0GV9KTPQKS','Nadia Dibbert','demarco35@gmail.com','0194943840','So Alice got up this morning, but I don\'t believe it,\' said Alice, very much pleased at having.',NULL,'refunded','2025-06-10 10:44:03','2025-06-10 10:44:03'),(174,42,'QALQLSUZA7SU','Margarete Tremblay','albertha.mayert@hotmail.com','0594136784','CHAPTER X. The Lobster Quadrille The Mock Turtle went on. \'Or would you like to hear it say, as it.',NULL,'transferred','2025-06-10 10:44:03','2025-06-10 10:44:03'),(175,42,'OERGB1VA6BRN','Andreane Rohan','mokuneva@hermiston.net','0690769061','It was the first to break the silence. \'What day of the bread-and-butter. Just at this moment the.',NULL,'cancelled','2025-06-10 10:44:03','2025-06-10 10:44:03'),(176,43,'9ZVQMMDX0DKI','Mrs. Kaya Quigley','bradley59@gusikowski.com','0296019695','I COULD NOT SWIM--\" you can\'t swim, can you?\' he added, turning to the door, and tried to beat.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(177,43,'EM3IBJ4C105O','Buford Predovic','hillard30@yahoo.com','0363788762','I suppose?\' said Alice. \'You did,\' said the Caterpillar. \'Well, perhaps you haven\'t found it made.',NULL,'purchased','2025-06-10 10:44:03','2025-06-10 10:44:03'),(178,44,'JO8AJCKWHORV','Emmalee Klocko','reichert.jaeden@yahoo.com','0570609667','As they walked off together. Alice was not here before,\' said the Gryphon: \'I went to the baby.',NULL,'cancelled','2025-06-10 10:44:03','2025-06-10 10:44:03'),(179,44,'KNWYSZCYGEP5','Prof. Dario Ritchie','jedidiah.schmitt@hotmail.com','0569781794','I\'ll have you executed.\' The miserable Hatter dropped his teacup instead of the table, but there.',NULL,'cancelled','2025-06-10 10:44:03','2025-06-10 10:44:03'),(180,45,'LKE98LLCB0YF','Prof. Jaclyn Hammes','blanda.claudine@gmail.com','0651151530','I suppose you\'ll be telling me next that you think you could keep it to be almost out of sight.',NULL,'pending','2025-06-10 10:44:03','2025-06-10 10:44:03'),(181,45,'I2BJNU0MFJ73','Lorna Schaden','kylee.steuber@mante.info','0002764456','Lobster Quadrille?\' the Gryphon replied rather crossly: \'of course you don\'t!\' the Hatter replied.',NULL,'purchased','2025-06-10 10:44:03','2025-06-10 10:44:03'),(182,46,'XY2SNDNAGQYK','Melisa Hirthe','elian.collins@hotmail.com','0027165570','She was looking at Alice for protection. \'You shan\'t be able! I shall remember it in large.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(183,46,'CEHTZF5PAZCE','Francesco Schowalter','boehm.toy@lehner.com','0564012373','XI. Who Stole the Tarts? The King turned pale, and shut his note-book hastily. \'Consider your.',NULL,'reserved','2025-06-10 10:44:03','2025-06-10 10:44:03'),(184,46,'35H2KMOZ0ZQL','Christian Schulist MD','matilda88@wiza.net','0930786429','The King laid his hand upon her face. \'Very,\' said Alice: \'besides, that\'s not a mile high,\' said.',NULL,'transferred','2025-06-10 10:44:03','2025-06-10 10:44:03'),(185,47,'DARQGXJZA4ZF','Ms. Shemar Strosin V','ernesto.mckenzie@hotmail.com','0127905543','While she was surprised to see some meaning in it,\' said Alice in a court of justice before, but.',NULL,'reserved','2025-06-10 10:44:03','2025-06-10 10:44:03'),(186,47,'QDZFVLEV0TYA','Alvera Pfeffer','javon74@becker.com','0146623300','I eat\" is the reason is--\' here the Mock Turtle replied, counting off the cake. * * * * * * * * *.',NULL,'checked_in','2025-06-10 10:44:03','2025-06-10 10:44:03'),(187,48,'OZNCROHFBKSM','Kaycee Thompson','conn.kailyn@rau.info','0070000985','THAT in a deep, hollow tone: \'sit down, both of you, and don\'t speak a word till I\'ve finished.\'.',NULL,'pending','2025-06-10 10:44:04','2025-06-10 10:44:04'),(188,48,'IIZHQBUPX2V4','Retta Kutch','sanford.alicia@gmail.com','0057189492','Dinah!\' she said this, she looked up, but it just grazed his nose, you know?\' \'It\'s the thing Mock.',NULL,'pending','2025-06-10 10:44:04','2025-06-10 10:44:04'),(189,48,'GKYXA9YAHGZY','Erich Donnelly','fkeeling@hotmail.com','0571976974','Hatter. Alice felt so desperate that she looked up, and there was a table, with a whiting. Now you.',NULL,'cancelled','2025-06-10 10:44:04','2025-06-10 10:44:04'),(190,48,'D3LS3HSOFWPJ','Rogers Treutel','kstokes@gusikowski.biz','0670883949','Majesty?\' he asked. \'Begin at the place of the jury eagerly wrote down on one knee as he spoke.',NULL,'reserved','2025-06-10 10:44:04','2025-06-10 10:44:04'),(191,48,'FWMXUBQEM3LN','Frederick Wiza Jr.','martin89@grimes.org','0700807041','And yet you incessantly stand on their throne when they passed too close, and waving their.',NULL,'cancelled','2025-06-10 10:44:04','2025-06-10 10:44:04'),(192,49,'UZDEEQBAXARC','Emma Corwin','rosa19@buckridge.com','0746387519','Alice timidly. \'Would you like the Mock Turtle repeated thoughtfully. \'I should like to be sure.',NULL,'reserved','2025-06-10 10:44:04','2025-06-10 10:44:04'),(193,49,'P4AWLP8GFRER','Danial Rogahn','sandra32@heathcote.com','0642374501','Then followed the Knave of Hearts, carrying the King\'s crown on a branch of a well--\' \'What did.',NULL,'purchased','2025-06-10 10:44:04','2025-06-10 10:44:04'),(194,49,'0AIQE1USHD9H','Maureen Schmitt','donnell46@franecki.info','0411858160','Alice; \'and I wish I hadn\'t quite finished my tea when I find a number of cucumber-frames there.',NULL,'reserved','2025-06-10 10:44:04','2025-06-10 10:44:04'),(195,49,'CSTWWQ0YGBTV','Dr. Koby Deckow','amara.nienow@greenfelder.com','0262267167','As they walked off together. Alice was a general chorus of \'There goes Bill!\' then the puppy began.',NULL,'purchased','2025-06-10 10:44:04','2025-06-10 10:44:04'),(196,49,'VCHNYQUAOLLA','Avis Simonis','maureen16@hotmail.com','0363389807','Alice called after her. \'I\'ve something important to say!\' This sounded promising, certainly.',NULL,'cancelled','2025-06-10 10:44:04','2025-06-10 10:44:04'),(197,50,'DFAFSHJAU2NL','Asia Rau','alessandra36@cole.biz','0653563802','Hatter, \'I cut some more of it now in sight, hurrying down it. There was a dead silence instantly.',NULL,'transferred','2025-06-10 10:44:04','2025-06-10 10:44:04'),(198,50,'WULNT6HU0DOE','Ms. Althea Hahn DVM','kovacek.katlynn@gmail.com','0684562645','Dormouse denied nothing, being fast asleep. \'After that,\' continued the Hatter, and here the.',NULL,'cancelled','2025-06-10 10:44:04','2025-06-10 10:44:04');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:43:42','2025-06-10 10:43:42','Quae voluptas ut eos occaecati. Iusto eum quia sint alias.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:43:42','2025-06-10 10:43:42','Ut et fuga voluptatem ad vero molestiae laudantium voluptatibus. Quos quod temporibus sunt.'),(3,'Event Experience',0,'published','2025-06-10 10:43:42','2025-06-10 10:43:42','Exercitationem dolor eaque voluptates nihil cum. Modi placeat distinctio nesciunt.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:43:42','2025-06-10 10:43:42','Non blanditiis iure quibusdam. Vitae voluptatum debitis autem totam. Non aut beatae et quo velit.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Quam ullam quaerat fugit impedit dolore a.','Rerum velit quas et quasi ipsam accusamus est dolor consequatur culpa quidem et voluptatem molestiae sed voluptatem reiciendis optio sed qui esse neque sapiente id asperiores sunt enim et cum eum optio aspernatur deserunt rem eum sapiente.',3,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(2,'Numquam optio aut dolores tempore modi.','Aut sunt et veritatis maiores voluptatem eveniet provident voluptatibus rem expedita et rem dolores possimus incidunt rem consequatur animi neque dolores amet voluptatum porro nobis voluptatibus quia sed aut non voluptas.',3,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(3,'Sunt molestiae distinctio ipsa minima et.','Et animi molestiae magni maxime et architecto dolorem dignissimos dolores non doloribus in facere tenetur ipsa quia culpa in ipsa officiis accusantium.',2,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(4,'Rerum voluptates et ea sequi ullam.','Blanditiis quaerat aut esse consequatur vel adipisci eaque et repudiandae porro omnis suscipit consequatur quod reprehenderit minus et cumque quia qui architecto et libero quis eum qui minima quo magnam laudantium odit et eius quas perspiciatis error.',1,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(5,'Commodi ipsa dolore est molestiae.','Consequatur voluptatem alias amet sit accusamus omnis modi animi tempore expedita enim iure aliquam nobis blanditiis cupiditate consequatur qui eveniet beatae praesentium ea omnis et atque fugiat quaerat cumque ipsum sint doloremque harum laborum.',3,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(6,'Et nisi dolore et blanditiis eveniet.','Saepe beatae sunt natus dolores qui quos sed deserunt blanditiis minus cumque ut eum quia nemo rem quas aperiam quidem eligendi cum vero consequatur natus vero laborum repellendus laborum non consequatur reiciendis exercitationem temporibus sed voluptates esse.',1,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(7,'Voluptate asperiores iste ut ut est.','Perferendis ipsa similique ullam sunt debitis laborum dolor itaque est voluptatibus autem ut iure quae dolor vero omnis iste porro molestiae tempora velit molestias soluta ut voluptatum quos voluptatibus tempora porro vel quis.',1,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(8,'Corrupti dolorum autem ipsam deserunt corrupti quia.','Nisi veniam vel ut cum eaque tempore ut aut sed exercitationem eaque repellat nisi suscipit voluptatem est ipsum nostrum sint maxime tempora tempore magnam sunt ut unde maxime ad quasi.',2,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(9,'Ea quidem eos et amet iste accusamus.','Ducimus occaecati libero non maiores ea nobis aperiam necessitatibus ratione est ad fugit omnis expedita fuga provident nesciunt in magnam saepe sint perspiciatis ut quos qui facilis architecto sunt culpa sunt.',1,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(10,'Quaerat inventore aut commodi expedita aut quidem.','Distinctio dolorum suscipit enim perferendis aspernatur et quos eligendi aut molestiae itaque vel sunt ex officiis eaque sint tempora quia non omnis voluptatem.',2,'published','2025-06-10 10:43:42','2025-06-10 10:43:42'),(11,'Aut sit aut non voluptatibus.','Est qui delectus vero sequi in aperiam quia voluptates quae dolorem ut animi ratione autem pariatur et et non et id sequi et dicta nostrum dignissimos ipsam qui aspernatur rerum repellat qui numquam illum doloremque suscipit officiis aspernatur pariatur quaerat.',2,'published','2025-06-10 10:43:42','2025-06-10 10:43:42');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Reiciendis eligendi et est. Porro cumque rem et. Necessitatibus accusamus esse magni quam qui saepe.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(2,'Ocean Views','Aut iure officia culpa commodi voluptatem veritatis voluptatem. Eos dignissimos et omnis est magnam. Qui ab aut quisquam.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(3,'Adventure Time','Molestiae at fugiat sapiente. Sit quos consequuntur voluptas rerum nobis quia atque facilis. Molestias esse maxime in ratione et.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(4,'City Lights','Blanditiis esse eos at quia quasi. Ut facilis corporis quasi autem. A quibusdam et quia distinctio aut.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(5,'Dreamscape','Officiis tempore deserunt sapiente et aut quam repellendus. Fuga totam quia expedita ad in. Dolores corporis est suscipit quasi dolor.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(6,'Enchanted Forest','Assumenda sunt eos accusantium et voluptatem velit consequuntur. Rem nihil et eos dolor. Sed aspernatur dolor dolorem mollitia accusantium.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(7,'Golden Hour','Cumque vero voluptatem amet ex. Pariatur culpa ut assumenda nam vel est. Sunt voluptas dignissimos perspiciatis explicabo in dicta ea explicabo.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(8,'Serenity','Iste sed voluptatem eum quis enim labore eveniet. Nihil et iusto sunt dolor dolor quia praesentium.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(9,'Eternal Beauty','Expedita optio aperiam sit omnis. Asperiores libero reprehenderit velit non animi. Odit quasi asperiores ex ut et.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(10,'Moonlight Magic','Maxime voluptas est eum voluptates eum. Modi veniam porro dicta eum quos.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(11,'Starry Night','Ducimus omnis ut vero aliquid amet. Rerum voluptas adipisci in rerum velit illum ut. Optio molestias laudantium aliquid in quos.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(12,'Hidden Gems','Reprehenderit voluptatem sit reprehenderit quia. Minus dolore maxime corporis similique. Dolorem explicabo ipsa voluptatem.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(13,'Tranquil Waters','Consectetur voluptatem expedita ut repudiandae. Autem voluptatem est vel perferendis itaque eaque sunt. Qui unde cum qui consequatur sequi.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:43:19','2025-06-10 10:43:19'),(14,'Urban Escape','Quasi est minus delectus vel debitis. Et optio voluptatem suscipit velit. Enim laboriosam et tempore occaecati deserunt nobis et.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:43:20','2025-06-10 10:43:20'),(15,'Twilight Zone','Aliquid sint odio sunt ad inventore esse. Delectus aspernatur quam aut odit aut. Aliquid debitis aut illum fugiat ipsam est.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:43:20','2025-06-10 10:43:20');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:19','2025-06-10 10:43:19'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:20','2025-06-10 10:43:20'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:20','2025-06-10 10:43:20'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Modi voluptates sequi corrupti. Id et consequuntur in nemo. Commodi tenetur quia ipsum est ipsam. Cum sit est exercitationem et vel corrupti.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Et impedit est voluptas expedita a aut quisquam. At fugiat placeat eligendi aliquid esse quia. Assumenda a dolore velit ut. Non repellat tenetur at.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Aliquam blanditiis tempore nesciunt. Cumque praesentium sunt omnis et. Et aperiam quo ratione ea voluptatibus eum aut.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"In praesentium autem qui enim sapiente in. Quia ex eos voluptate sapiente. Sunt distinctio voluptatibus dolor perferendis quos.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Aut modi omnis qui voluptatibus. Aut sed repellendus accusantium similique a. Culpa eos omnis sed.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Voluptates in dolorem sint sed non voluptates optio. Sed expedita dolorem et et. Ab aliquid ut quam rem.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Sit sed voluptate voluptas a commodi. Quia ab et tenetur quam consequatur totam. Nobis possimus et et a officiis ea.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Blanditiis facilis est distinctio qui laborum veniam quia. Necessitatibus similique ea aut amet.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Reiciendis ut accusamus molestiae delectus. Doloremque deserunt et nobis rerum perferendis. Quam est et nulla eos adipisci qui in.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Voluptas quod optio deserunt quibusdam in totam. Aspernatur hic officiis cumque et modi et itaque.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Magni molestias et voluptatem autem. Optio voluptate temporibus animi fugit. Earum suscipit quidem non iusto. Omnis autem pariatur ipsum hic earum.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Incidunt delectus quas voluptate aut officia. Atque similique quidem ullam quos. Et quam quia sed tenetur.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Qui reiciendis sed quaerat quisquam. Iste labore voluptatem rem ducimus. Et minus voluptas consequuntur omnis nemo hic.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Veniam non ab eius molestias enim minima. Atque delectus ducimus amet at excepturi. Repellendus mollitia est quae laborum corrupti voluptas.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Corporis est veniam est deserunt. Dolorem quia eos amet nihil voluptatem. Natus ducimus repellendus ut adipisci numquam. Est illum vel omnis.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Veniam vel fugiat aut consectetur dolor. Vitae in ab eveniet sapiente minus. Maxime voluptatem id qui corporis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Sed consequatur a iusto omnis quos. Dolorum maiores animi deserunt quae doloremque.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Suscipit optio minus qui voluptatem. Aut est consequuntur reprehenderit quisquam eum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Cum recusandae perferendis repudiandae ea in commodi. Sit aspernatur neque laudantium ad. Cumque dolores dolore expedita voluptatem.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sint earum animi maxime fugiat aut at veniam. Iure nihil provident ullam et ut autem.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:43:20','2025-06-10 10:43:20');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','4f541e1d5d9044f773948265c594ce13',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','7662e9c97c47ad219c9e84e6cdf3d425',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','01e4c8c2690f64dd3e4eab3f9ef8ea4c',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (12,0,'about-us-information-6-1','about-us-information-6-1',4,'image/png',5649,'homepage06/general/about-us-information-6-1.png','[]','2025-06-10 10:43:11','2025-06-10 10:43:11',NULL,'public'),(13,0,'about-us-information-6-2','about-us-information-6-2',4,'image/png',3762,'homepage06/general/about-us-information-6-2.png','[]','2025-06-10 10:43:12','2025-06-10 10:43:12',NULL,'public'),(14,0,'about-us-information-6-3','about-us-information-6-3',4,'image/png',4322,'homepage06/general/about-us-information-6-3.png','[]','2025-06-10 10:43:12','2025-06-10 10:43:12',NULL,'public'),(15,0,'featured-block-1','featured-block-1',4,'image/png',407,'homepage06/general/featured-block-1.png','[]','2025-06-10 10:43:12','2025-06-10 10:43:12',NULL,'public'),(16,0,'featured-block-2','featured-block-2',4,'image/png',407,'homepage06/general/featured-block-2.png','[]','2025-06-10 10:43:12','2025-06-10 10:43:12',NULL,'public'),(17,0,'featured-block-3','featured-block-3',4,'image/png',407,'homepage06/general/featured-block-3.png','[]','2025-06-10 10:43:12','2025-06-10 10:43:12',NULL,'public'),(18,0,'hero-banner-5','hero-banner-5',4,'image/webp',18045,'homepage06/general/hero-banner-5.webp','[]','2025-06-10 10:43:12','2025-06-10 10:43:12',NULL,'public'),(19,0,'logo','logo',4,'image/png',1811,'homepage06/general/logo.png','[]','2025-06-10 10:43:12','2025-06-10 10:43:12',NULL,'public'),(20,0,'sub-logo-black','sub-logo-black',4,'image/png',737,'homepage06/general/sub-logo-black.png','[]','2025-06-10 10:43:13','2025-06-10 10:43:13',NULL,'public'),(21,0,'sub-logo','sub-logo',4,'image/png',238,'homepage06/general/sub-logo.png','[]','2025-06-10 10:43:13','2025-06-10 10:43:13',NULL,'public'),(22,0,'hero-banner-bg','hero-banner-bg',5,'image/webp',11970,'homepage06/backgrounds/hero-banner-bg.webp','[]','2025-06-10 10:43:13','2025-06-10 10:43:13',NULL,'public'),(43,0,'1','1',7,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:43:20','2025-06-10 10:43:20',NULL,'public'),(44,0,'2','2',7,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:43:20','2025-06-10 10:43:20',NULL,'public'),(45,0,'3','3',7,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:43:20','2025-06-10 10:43:20',NULL,'public'),(46,0,'4','4',7,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:43:20','2025-06-10 10:43:20',NULL,'public'),(47,0,'brand-img1','brand-img1',8,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:43:21','2025-06-10 10:43:21',NULL,'public'),(48,0,'brand-img2','brand-img2',8,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:43:21','2025-06-10 10:43:21',NULL,'public'),(49,0,'brand-img3','brand-img3',8,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:43:21','2025-06-10 10:43:21',NULL,'public'),(50,0,'brand-img4','brand-img4',8,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:43:21','2025-06-10 10:43:21',NULL,'public'),(51,0,'brand-img5','brand-img5',8,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:43:21','2025-06-10 10:43:21',NULL,'public'),(52,0,'brand-img6','brand-img6',8,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:43:21','2025-06-10 10:43:21',NULL,'public'),(53,0,'brand-img7','brand-img7',8,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:43:21','2025-06-10 10:43:21',NULL,'public'),(54,0,'brand-img8','brand-img8',8,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:43:22','2025-06-10 10:43:22',NULL,'public'),(55,0,'1','1',9,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:43:22','2025-06-10 10:43:22',NULL,'public'),(56,0,'2','2',9,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:43:22','2025-06-10 10:43:22',NULL,'public'),(57,0,'header-bg4','header-bg4',9,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:43:22','2025-06-10 10:43:22',NULL,'public'),(58,0,'hero-banner-bg','hero-banner-bg',9,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:43:23','2025-06-10 10:43:23',NULL,'public'),(59,0,'image-1','image-1',9,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:43:24','2025-06-10 10:43:24',NULL,'public'),(60,0,'newsletter-bg','newsletter-bg',9,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:43:25','2025-06-10 10:43:25',NULL,'public'),(61,0,'pricing-name','pricing-name',9,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:43:25','2025-06-10 10:43:25',NULL,'public'),(62,0,'speakers-bg','speakers-bg',9,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:43:25','2025-06-10 10:43:25',NULL,'public'),(63,0,'balloons','balloons',10,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:43:26','2025-06-10 10:43:26',NULL,'public'),(64,0,'calendar','calendar',10,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:43:26','2025-06-10 10:43:26',NULL,'public'),(65,0,'clock','clock',10,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:43:26','2025-06-10 10:43:26',NULL,'public'),(66,0,'coding','coding',10,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:43:26','2025-06-10 10:43:26',NULL,'public'),(67,0,'idea','idea',10,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:43:26','2025-06-10 10:43:26',NULL,'public'),(68,0,'instagram-icon','instagram-icon',10,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:43:26','2025-06-10 10:43:26',NULL,'public'),(69,0,'location-icon','location-icon',10,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:43:27','2025-06-10 10:43:27',NULL,'public'),(70,0,'location','location',10,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:43:27','2025-06-10 10:43:27',NULL,'public'),(71,0,'mail-icon','mail-icon',10,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:43:27','2025-06-10 10:43:27',NULL,'public'),(72,0,'menu','menu',10,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:43:27','2025-06-10 10:43:27',NULL,'public'),(73,0,'microphone','microphone',10,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:43:27','2025-06-10 10:43:27',NULL,'public'),(74,0,'phone-icon','phone-icon',10,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:43:27','2025-06-10 10:43:27',NULL,'public'),(75,0,'search','search',10,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:43:27','2025-06-10 10:43:27',NULL,'public'),(76,0,'speaker','speaker',10,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:43:28','2025-06-10 10:43:28',NULL,'public'),(77,0,'ticket','ticket',10,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:43:28','2025-06-10 10:43:28',NULL,'public'),(78,0,'user','user',10,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:43:28','2025-06-10 10:43:28',NULL,'public'),(79,0,'view','view',10,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:43:28','2025-06-10 10:43:28',NULL,'public'),(80,0,'workshop','workshop',10,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:43:28','2025-06-10 10:43:28',NULL,'public'),(81,0,'1','1',6,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:43:29','2025-06-10 10:43:29',NULL,'public'),(82,0,'10','10',6,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:43:29','2025-06-10 10:43:29',NULL,'public'),(83,0,'11','11',6,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:43:29','2025-06-10 10:43:29',NULL,'public'),(84,0,'12','12',6,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:43:29','2025-06-10 10:43:29',NULL,'public'),(85,0,'13','13',6,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:43:30','2025-06-10 10:43:30',NULL,'public'),(86,0,'14','14',6,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:43:30','2025-06-10 10:43:30',NULL,'public'),(87,0,'15','15',6,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:43:30','2025-06-10 10:43:30',NULL,'public'),(88,0,'16','16',6,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:43:31','2025-06-10 10:43:31',NULL,'public'),(89,0,'17','17',6,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:43:31','2025-06-10 10:43:31',NULL,'public'),(90,0,'18','18',6,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:43:31','2025-06-10 10:43:31',NULL,'public'),(91,0,'19','19',6,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:43:32','2025-06-10 10:43:32',NULL,'public'),(92,0,'2','2',6,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:43:32','2025-06-10 10:43:32',NULL,'public'),(93,0,'20','20',6,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:43:32','2025-06-10 10:43:32',NULL,'public'),(94,0,'3','3',6,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:43:33','2025-06-10 10:43:33',NULL,'public'),(95,0,'4','4',6,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:43:33','2025-06-10 10:43:33',NULL,'public'),(96,0,'5','5',6,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:43:33','2025-06-10 10:43:33',NULL,'public'),(97,0,'6','6',6,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:43:34','2025-06-10 10:43:34',NULL,'public'),(98,0,'7','7',6,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:43:34','2025-06-10 10:43:34',NULL,'public'),(99,0,'8','8',6,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:43:34','2025-06-10 10:43:34',NULL,'public'),(100,0,'9','9',6,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:43:35','2025-06-10 10:43:35',NULL,'public'),(101,0,'1','1',11,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:43:35','2025-06-10 10:43:35',NULL,'public'),(102,0,'10','10',11,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:43:35','2025-06-10 10:43:35',NULL,'public'),(103,0,'11','11',11,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:43:36','2025-06-10 10:43:36',NULL,'public'),(104,0,'12','12',11,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:43:36','2025-06-10 10:43:36',NULL,'public'),(105,0,'13','13',11,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:43:36','2025-06-10 10:43:36',NULL,'public'),(106,0,'14','14',11,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:43:37','2025-06-10 10:43:37',NULL,'public'),(107,0,'15','15',11,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:43:37','2025-06-10 10:43:37',NULL,'public'),(108,0,'16','16',11,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:43:37','2025-06-10 10:43:37',NULL,'public'),(109,0,'17','17',11,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:43:38','2025-06-10 10:43:38',NULL,'public'),(110,0,'18','18',11,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:43:38','2025-06-10 10:43:38',NULL,'public'),(111,0,'19','19',11,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:43:38','2025-06-10 10:43:38',NULL,'public'),(112,0,'2','2',11,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:43:38','2025-06-10 10:43:38',NULL,'public'),(113,0,'20','20',11,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:43:39','2025-06-10 10:43:39',NULL,'public'),(114,0,'3','3',11,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:43:39','2025-06-10 10:43:39',NULL,'public'),(115,0,'4','4',11,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:43:39','2025-06-10 10:43:39',NULL,'public'),(116,0,'5','5',11,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:43:40','2025-06-10 10:43:40',NULL,'public'),(117,0,'6','6',11,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:43:40','2025-06-10 10:43:40',NULL,'public'),(118,0,'7','7',11,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:43:40','2025-06-10 10:43:40',NULL,'public'),(119,0,'8','8',11,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:43:41','2025-06-10 10:43:41',NULL,'public'),(120,0,'9','9',11,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:43:41','2025-06-10 10:43:41',NULL,'public'),(121,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:43:42','2025-06-10 10:43:42',NULL,'public'),(122,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:43:42','2025-06-10 10:43:42',NULL,'public'),(123,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:43:42','2025-06-10 10:43:42',NULL,'public'),(124,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:43:42','2025-06-10 10:43:42',NULL,'public'),(125,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:43:43','2025-06-10 10:43:43',NULL,'public'),(126,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:43:43','2025-06-10 10:43:43',NULL,'public'),(127,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:43:43','2025-06-10 10:43:43',NULL,'public'),(128,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:43:43','2025-06-10 10:43:43',NULL,'public'),(129,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:43:43','2025-06-10 10:43:43',NULL,'public'),(130,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:43:43','2025-06-10 10:43:43',NULL,'public'),(131,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:43:44','2025-06-10 10:43:44',NULL,'public'),(132,0,'1','1',12,'image/png',6515,'homepage06/speakers/1.png','[]','2025-06-10 10:43:44','2025-06-10 10:43:44',NULL,'public'),(133,0,'2','2',12,'image/png',6515,'homepage06/speakers/2.png','[]','2025-06-10 10:43:44','2025-06-10 10:43:44',NULL,'public'),(134,0,'3','3',12,'image/png',6515,'homepage06/speakers/3.png','[]','2025-06-10 10:43:44','2025-06-10 10:43:44',NULL,'public'),(135,0,'4','4',12,'image/png',6515,'homepage06/speakers/4.png','[]','2025-06-10 10:43:44','2025-06-10 10:43:44',NULL,'public'),(136,0,'5','5',12,'image/png',6001,'homepage06/speakers/5.png','[]','2025-06-10 10:43:44','2025-06-10 10:43:44',NULL,'public'),(137,0,'6','6',12,'image/png',6001,'homepage06/speakers/6.png','[]','2025-06-10 10:43:44','2025-06-10 10:43:44',NULL,'public'),(138,0,'7','7',12,'image/png',6001,'homepage06/speakers/7.png','[]','2025-06-10 10:43:45','2025-06-10 10:43:45',NULL,'public'),(139,0,'8','8',12,'image/png',6001,'homepage06/speakers/8.png','[]','2025-06-10 10:43:45','2025-06-10 10:43:45',NULL,'public'),(140,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:43:45','2025-06-10 10:43:45',NULL,'public'),(141,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:43:45','2025-06-10 10:43:45',NULL,'public'),(142,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:43:45','2025-06-10 10:43:45',NULL,'public'),(143,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:43:45','2025-06-10 10:43:45',NULL,'public'),(144,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:43:46','2025-06-10 10:43:46',NULL,'public'),(145,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:43:46','2025-06-10 10:43:46',NULL,'public'),(146,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:43:46','2025-06-10 10:43:46',NULL,'public'),(147,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:43:46','2025-06-10 10:43:46',NULL,'public'),(148,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:43:46','2025-06-10 10:43:46',NULL,'public'),(149,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:43:46','2025-06-10 10:43:46',NULL,'public'),(150,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:43:47','2025-06-10 10:43:47',NULL,'public'),(151,0,'0','0',14,'image/webp',33268,'main/events/0-1749552232.webp','[]','2025-06-10 10:43:53','2025-06-10 10:43:53',NULL,'public'),(152,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:43:53','2025-06-10 10:43:53',NULL,'public'),(153,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:43:53','2025-06-10 10:43:53',NULL,'public'),(154,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:43:53','2025-06-10 10:43:53',NULL,'public'),(155,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:43:54','2025-06-10 10:43:54',NULL,'public'),(156,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:43:54','2025-06-10 10:43:54',NULL,'public'),(157,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:43:54','2025-06-10 10:43:54',NULL,'public'),(158,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:43:55','2025-06-10 10:43:55',NULL,'public'),(159,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:43:55','2025-06-10 10:43:55',NULL,'public'),(160,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:43:55','2025-06-10 10:43:55',NULL,'public'),(161,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:43:56','2025-06-10 10:43:56',NULL,'public'),(162,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:43:56','2025-06-10 10:43:56',NULL,'public'),(163,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:43:56','2025-06-10 10:43:56',NULL,'public'),(164,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:43:57','2025-06-10 10:43:57',NULL,'public'),(165,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:43:57','2025-06-10 10:43:57',NULL,'public'),(166,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:43:57','2025-06-10 10:43:57',NULL,'public'),(167,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:43:58','2025-06-10 10:43:58',NULL,'public'),(168,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:43:58','2025-06-10 10:43:58',NULL,'public'),(169,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:43:58','2025-06-10 10:43:58',NULL,'public'),(170,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:43:59','2025-06-10 10:43:59',NULL,'public'),(171,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:43:59','2025-06-10 10:43:59',NULL,'public'),(172,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:44:09','2025-06-10 10:44:09',NULL,'public'),(173,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:44:09','2025-06-10 10:44:09',NULL,'public'),(174,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:44:10','2025-06-10 10:44:10',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:43:10','2025-06-10 10:43:10',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:43:10','2025-06-10 10:43:10',NULL),(3,0,'homepage06',NULL,'homepage06',0,'2025-06-10 10:43:11','2025-06-10 10:43:11',NULL),(4,0,'general',NULL,'general',3,'2025-06-10 10:43:11','2025-06-10 10:43:11',NULL),(5,0,'backgrounds',NULL,'backgrounds',3,'2025-06-10 10:43:13','2025-06-10 10:43:13',NULL),(6,0,'news',NULL,'news',1,'2025-06-10 10:43:13','2025-06-10 10:43:13',NULL),(7,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:43:20','2025-06-10 10:43:20',NULL),(8,0,'brands',NULL,'brands',1,'2025-06-10 10:43:21','2025-06-10 10:43:21',NULL),(9,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:43:22','2025-06-10 10:43:22',NULL),(10,0,'icons',NULL,'icons',1,'2025-06-10 10:43:26','2025-06-10 10:43:26',NULL),(11,0,'blogs',NULL,'blogs',1,'2025-06-10 10:43:35','2025-06-10 10:43:35',NULL),(12,0,'speakers',NULL,'speakers',3,'2025-06-10 10:43:44','2025-06-10 10:43:44',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:43:45','2025-06-10 10:43:45',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:43:52','2025-06-10 10:43:52',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:44:09','2025-06-10 10:44:09',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:44:09','2025-06-10 10:44:09');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:44:09','2025-06-10 10:44:09');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:44:09','2025-06-10 10:44:09');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:43:21','2025-06-10 10:43:21'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:43:21','2025-06-10 10:43:21'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:43:21','2025-06-10 10:43:21'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:43:21','2025-06-10 10:43:21'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:43:35','2025-06-10 10:43:35'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:43:35','2025-06-10 10:43:35'),(7,'title','[\"Product Manager\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(8,'description','[\"I\'LL soon make you grow shorter.\' \'One side will make you dry enough!\' They all returned from him to you, Though they were gardeners, or soldiers, or courtiers, or three times over to the jury, of.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(9,'address','[\"376 Emmerich Forges Apt. 141\\nJarenhaven, PA 22549-4074\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(11,'title','[\"Quality Assurance\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(12,'description','[\"For some minutes the whole thing very absurd, but they were nice grand words to say.) Presently she began thinking over all the rats and--oh dear!\' cried Alice, quite forgetting her promise.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(13,'address','[\"40773 Tiffany Bridge Suite 959\\nSchillerton, CO 40178\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(15,'title','[\"Project Manager\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(16,'description','[\"Alice in a minute. Alice began telling them her adventures from the Gryphon, and the baby with some curiosity. \'What a curious plan!\' exclaimed Alice. \'And be quick about it,\' said Alice. \'Oh, don\'t.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(17,'address','[\"565 Roselyn Lake Apt. 249\\nZiemeberg, NJ 97072\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(19,'title','[\"Project Manager\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(20,'description','[\"Hatter. \'Stolen!\' the King in a confused way, \'Prizes! Prizes!\' Alice had not long to doubt, for the first minute or two, and the March Hare, who had been to the company generally, \'You are not the.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(21,'address','[\"501 Bahringer Ford Apt. 590\\nPort Catherinechester, NV 42647\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:47','2025-06-10 10:43:47'),(23,'title','[\"Fullstack Developer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(24,'description','[\"Alice remarked. \'Right, as usual,\' said the Mock Turtle would be the best cat in the act of crawling away: besides all this, there was mouth enough for it to half-past one as long as you liked.\' \'Is.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(25,'address','[\"846 Lindgren Squares\\nLake Eloisastad, AR 15285\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(27,'title','[\"Frontend Developer\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(28,'description','[\"It was so much already, that it signifies much,\' she said to Alice, very loudly and decidedly, and there stood the Queen said severely \'Who is it twelve? I--\' \'Oh, don\'t talk about cats or dogs.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(29,'address','[\"98922 Danika Turnpike Apt. 606\\nPort Lola, SC 36892-3944\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(31,'title','[\"Backend Developer\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(32,'description','[\"Mock Turtle angrily: \'really you are very dull!\' \'You ought to go from here?\' \'That depends a good many voices all talking at once, with a sudden leap out of this pool? I am so VERY much out of a.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(33,'address','[\"501 Minerva Walks\\nWindlerburgh, FL 55936\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(35,'title','[\"System Administrator\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(36,'description','[\"Lizard, who seemed to be seen: she found she could do to hold it. As soon as she could get to twenty at that rate! However, the Multiplication Table doesn\'t signify: let\'s try the experiment?\' \'HE.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(37,'address','[\"641 Nick Run Suite 479\\nMarafort, VA 83254\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(39,'title','[\"System Administrator\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(40,'description','[\"Mock Turtle replied, counting off the subjects on his spectacles and looked at her, and the moon, and memory, and muchness--you know you say things are worse than ever,\' thought the poor child, \'for.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(41,'address','[\"3790 Herzog View Apt. 915\\nNew Javon, KS 77855\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(43,'title','[\"Frontend Developer\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:48','2025-06-10 10:43:48'),(44,'description','[\"I was going to turn into a conversation. Alice replied, so eagerly that the hedgehog to, and, as there seemed to Alice for some time after the birds! Why, she\'ll eat a bat?\' when suddenly, thump!.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(45,'address','[\"791 Marilyne Squares\\nElnaview, WY 41059-8341\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(47,'title','[\"DevOps Engineer\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(48,'description','[\"Alice, a little pattering of footsteps in the kitchen that did not sneeze, were the two creatures, who had been would have this cat removed!\' The Queen turned crimson with fury, and, after waiting.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(49,'address','[\"263 Walter Place\\nKyleighstad, CO 28003\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(51,'title','[\"Frontend Developer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(52,'description','[\"At this moment the King, and the moment how large she had plenty of time as she came upon a heap of sticks and dry leaves, and the three gardeners instantly jumped up, and reduced the answer to it?\'.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(53,'address','[\"1454 Raegan Mission\\nConroyville, OR 04948\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(55,'title','[\"Backend Developer\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(56,'description','[\"CURTSEYING as you\'re falling through the little dears came jumping merrily along hand in her life; it was only the pepper that had fluttered down from the time she saw them, they set to work.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(57,'address','[\"5293 Bailee Place Suite 510\\nNew Damion, NM 66588\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(59,'title','[\"Frontend Developer\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(60,'description','[\"White Rabbit hurried by--the frightened Mouse splashed his way through the neighbouring pool--she could hear him sighing as if it please your Majesty!\' the soldiers did. After these came the guests.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(61,'address','[\"17335 Kailee Stravenue Suite 059\\nPort Rick, OR 22966\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(63,'title','[\"System Administrator\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(64,'description','[\"Will you, won\'t you join the dance? Will you, won\'t you join the dance? \\\"You can really have no idea what to uglify is, you ARE a simpleton.\' Alice did not seem to be\\\"--or if you\'d like it put the.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(65,'address','[\"561 Sven Mews Apt. 403\\nConnellyton, MN 80410-5087\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:49','2025-06-10 10:43:49'),(67,'title','[\"Quality Assurance\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(68,'description','[\"She went in search of her voice. Nobody moved. \'Who cares for fish, Game, or any other dish? Who would not open any of them. \'I\'m sure I\'m not used to call him Tortoise--\' \'Why did you begin?\' The.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(69,'address','[\"245 Rachael Throughway\\nMayerport, CO 45329-3084\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(71,'title','[\"Product Manager\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(72,'description','[\"Queen\'s hedgehog just now, only it ran away when it saw Alice. It looked good-natured, she thought: still it was getting so thin--and the twinkling of the guinea-pigs cheered, and was in livery.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(73,'address','[\"79230 Ruth Square Apt. 204\\nSatterfieldchester, MN 00325-7300\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(75,'title','[\"Quality Assurance\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(76,'description','[\"I think I can reach the key; and if it had finished this short speech, they all quarrel so dreadfully one can\'t hear oneself speak--and they don\'t give birthday presents like that!\' \'I couldn\'t.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(77,'address','[\"270 Mills Heights Suite 922\\nLake Sigurd, CO 01091-5455\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(79,'title','[\"Frontend Developer\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(80,'description','[\"Mock Turtle angrily: \'really you are very dull!\' \'You ought to have been ill.\' \'So they were,\' said the Duchess, the Duchess! Oh! won\'t she be savage if I\'ve kept her eyes immediately met those of a.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(81,'address','[\"363 Carroll Extensions Apt. 839\\nPaytonberg, VA 97659-9728\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(83,'title','[\"Product Manager\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(84,'description','[\"Mouse, in a helpless sort of way to hear her try and repeat \\\"\'TIS THE VOICE OF THE SLUGGARD,\\\"\' said the Mock Turtle. So she went back to the little door, so she went on. Her listeners were perfectly.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(85,'address','[\"293 Preston Row\\nPort Saraifort, MS 47078-0236\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(87,'title','[\"UX\\/UI Designer\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(88,'description','[\"Alice did not like to be otherwise than what it was: at first was in such long curly brown hair! And it\'ll fetch things when you have just been reading about; and when she was shrinking rapidly; so.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(89,'address','[\"9123 Clay Flat\\nArnulfoview, TX 94258\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:50','2025-06-10 10:43:50'),(91,'title','[\"Fullstack Developer\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(92,'description','[\"Alice indignantly. \'Let me alone!\' \'Serpent, I say again!\' repeated the Pigeon, raising its voice to a shriek, \'and just as well as the Caterpillar angrily, rearing itself upright as it could go.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(93,'address','[\"982 Benton Landing\\nLake Kearaside, NJ 49287\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(95,'title','[\"Frontend Developer\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(96,'description','[\"Turtle--we used to know. Let me see: that would happen: \'\\\"Miss Alice! Come here directly, and get ready for your interesting story,\' but she heard the Rabbit began. Alice gave a little timidly, \'why.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(97,'address','[\"402 Una Views\\nKilbackberg, MD 68282-4317\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(99,'title','[\"Project Manager\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(100,'description','[\"Caterpillar, and the March Hare. \'Exactly so,\' said Alice. The poor little feet, I wonder what they\'ll do well enough; and what does it to the Hatter. \'You might just as if nothing had happened.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(101,'address','[\"343 Kuvalis Track Suite 938\\nLake Glennieburgh, WV 47688\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(103,'title','[\"Fullstack Developer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(104,'description','[\"Geography. London is the same thing,\' said the Hatter. This piece of evidence we\'ve heard yet,\' said Alice; \'but when you have just been picked up.\' \'What\'s in it?\' said the Caterpillar. Here was.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(105,'address','[\"7147 Howe Tunnel Suite 158\\nEbonyville, MD 56168-2344\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(107,'title','[\"UX\\/UI Designer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(108,'description','[\"The Duchess took her choice, and was surprised to find my way into a line along the course, here and there was a most extraordinary noise going on shrinking rapidly: she soon made out the.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(109,'address','[\"68564 Steuber Courts\\nAstridside, PA 20502\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:51','2025-06-10 10:43:51'),(111,'title','[\"DevOps Engineer\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(112,'description','[\"Knave, \'I didn\'t know it was written to nobody, which isn\'t usual, you know.\' \'I DON\'T know,\' said the Queen. First came ten soldiers carrying clubs; these were ornamented all over with fright. \'Oh.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(113,'address','[\"9615 Tillman Mountain Apt. 408\\nLubowitzfort, WV 38489-7864\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(115,'title','[\"Project Manager\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(116,'description','[\"If I or she fell very slowly, for she felt that it led into a large pigeon had flown into her face. \'Very,\' said Alice: \'I don\'t quite understand you,\' she said, as politely as she left her, leaning.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(117,'address','[\"79700 Bryon Village\\nPort Keonburgh, NM 56083-8046\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(119,'title','[\"DevOps Engineer\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(120,'description','[\"Fish-Footman was gone, and the second time round, she found herself in the morning, just time to begin with.\' \'A barrowful will do, to begin at HIS time of life. The King\'s argument was, that.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(121,'address','[\"774 Goldner Summit Suite 631\\nWest Rosella, MS 82575\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(123,'title','[\"DevOps Engineer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(124,'description','[\"Alice heard it say to itself, \'Oh dear! Oh dear! I wish you could only hear whispers now and then, \'we went to work shaking him and punching him in the air. \'--as far out to the shore, and then I\'ll.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(125,'address','[\"604 Lexi Crossroad\\nFeilmouth, VT 93063-9079\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(127,'title','[\"Project Manager\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(128,'description','[\"If she should push the matter with it. There was no more of it had been. But her sister was reading, but it is.\' \'I quite agree with you,\' said Alice, looking down with one eye; but to get to,\' said.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(129,'address','[\"928 Sipes Corners\\nNorth Connieton, WV 83150\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:43:52','2025-06-10 10:43:52'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(134,'event_id','[9]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(138,'event_id','[6]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10'),(142,'event_id','[8]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:44:10','2025-06-10 10:44:10');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner style=&quot;5&quot; title=&quot;Empowering &lt;br&gt; Tomorrow&#039;s &lt;br&gt; Marketers&quot; subtitle=&quot;Marketing Summit &quot;2025&quot;&quot; sub_image=&quot;homepage06/general/sub-logo.png&quot; circle_text=&quot;Build Success Brand .&quot; image=&quot;homepage06/general/hero-banner-5.webp&quot; button_primary_label=&quot;Buy Ticket Now&quot; button_primary_url=&quot;/events&quot; background_image=&quot;homepage06/backgrounds/hero-banner-bg.webp&quot;][/hero-banner]\n[about-us-information style=&quot;6&quot; title=&quot;Why Attend the Marketing &lt;br&gt; Summit Event 2025&quot; subtitle=&quot;About Summit&quot; subtitle_image=&quot;homepage06/general/sub-logo-black.png&quot; description=&quot;The Marketing Summit 2024 is more than just a conference&mdash;it&#039;s an opportunity to redefine your marketing approach. From seasoned professionals to emerging talents, this summit is designed for those who are passionate about staying ahead of the curve. &lt;br&gt; &lt;br&gt; With a focus on digital transformation, content strategies, and data-driven decision-making, attendees will walk away with actionable insigh&quot; button_label=&quot;About Event&quot; button_url=&quot;/events&quot; quantity=&quot;3&quot; image=&quot;homepage06/general/about-us-information-6-1.png&quot; image_1=&quot;homepage06/general/about-us-information-6-2.png&quot; image_2=&quot;homepage06/general/about-us-information-6-3.png&quot;][/about-us-information]\n[events style=&quot;5&quot; title=&quot;Event Location &amp; How to Get There&quot; subtitle_image=&quot;homepage06/general/sub-logo-black.png&quot; subtitle=&quot;Event Schedule&quot; limit=&quot;3&quot;][/events]\n[featured-block style=&quot;2&quot; title=&quot;Where Marketers Go to Learn&quot; subtitle=&quot;What You Learn&quot; subtitle_image=&quot;homepage06/general/sub-logo-black.png&quot; quantity=&quot;3&quot; title_1=&quot;Connect with Visionaries&quot; description_1=&quot; Join industry leaders and like-minded peers, and expand your network with a dynamic community ready to support your career growth and aspirations.&quot; url_1=&quot;/&quot; icon_image_1=&quot;homepage06/general/featured-block-1.png&quot; title_2=&quot;Master New Skills&quot; description_2=&quot;Every obstacle has a solution, and we bring together experts who&#039;ve been through it all. Get practical advice, tips, and guidance to challenges faster.&quot; url_2=&quot;/&quot; icon_image_2=&quot;homepage06/general/featured-block-2.png&quot; title_3=&quot;Take Actionable Insight&quot; description_3=&quot;Immerse yourself in tailored sessions that address your biggest marketing hurdles. Leave with proven strategies and innovative ideas to elevate success.&quot; url_3=&quot;/&quot; icon_image_3=&quot;homepage06/general/featured-block-3.png&quot;][/featured-block]\n[speakers style=&quot;6&quot; title=&quot;Meet Our Event Speaker&#039;s&quot; subtitle=&quot;EVENT SPEAKERS &quot; subtitle_image=&quot;homepage06/general/sub-logo-black.png&quot; limit=&quot;4&quot; background_color=&quot;#F9FAFB&quot;][/speakers]\n[pricing style=&quot;3&quot; title=&quot;Register For Eventify 2025&quot; subtitle_image=&quot;homepage06/general/sub-logo-black.png&quot; subtitle=&quot;PRICING&quot; quantity=&quot;2&quot; name_1=&quot;Conference Pass&quot; description_1=&quot;Get full access to all man stage keynotes, mastermind sessions, and installation for the conference at Eventify.&quot; price_1=&quot;$249&quot; is_featured_1=&quot;no&quot; features_1=&quot;+ Main Stage Keynotes \\n + Mastermind Sessions (Booking Required) \\n + Unlimited Coffee at event Conference \\n + Breakfast, Snaks, and Buffet Lunch \\n + Post Event Cocktail Reception \\n + Event Party On 14 January 2025 + Semrush Swag&quot; button_label_1=&quot;Buy Tickets Now &quot; button_url_1=&quot;/events&quot; background_color_1=&quot;#1C58CC&quot; name_2=&quot;VIP Pass&quot; description_2=&quot;Get full access to all man stage keynotes, mastermind sessions, and installation for the conference at Eventify.&quot; price_2=&quot;$449&quot; is_featured_2=&quot;no&quot; features_2=&quot;+ Main Stage Keynotes \\n + Mastermind Sessions (Booking Required) \\n + Unlimited Coffee at event Conference \\n + Breakfast, Snaks, and Buffet Lunch \\n + Post Event Cocktail Reception \\n + Event Party On 14 January 2025 \\n + Semrush Swag \\n + Exclusive Speaker &amp; VIP Welcome Party on 15 January 2025 \\n + Fast Track VIP Check In \\n + 60 Min Site Clinic (On Site or within a Month) \\n + Semrush Certification Workshop of Your Choice On January 2025&quot; button_label_2=&quot;Buy Tickets Now &quot; button_url_2=&quot;/events&quot; background_color_2=&quot;#FF3A86&quot; text_color=&quot;#000000&quot;][/pricing]\n[testimonials style=&quot;3&quot; title=&quot;Register For Eventify 2025&quot; subtitle_image=&quot;homepage06/general/sub-logo.png&quot; subtitle=&quot;Testimonials&quot; testimonial_ids=&quot;1,2,3,4&quot; background_color=&quot;rgb(0, 0, 0)&quot;][/testimonials]\n[brands style=&quot;2&quot; subtitle=&quot;PARTNERS&quot; subtitle_image=&quot;homepage06/general/sub-logo-black.png&quot; title=&quot;Our Valued Sponsors &amp; Partners&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot; text_color=&quot;#000000&quot; background_color=&quot;#FFF3F6&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:43:35','2025-06-10 10:43:35');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'YLSM5DQ0BPFD','bank_transfer',NULL,121.46,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(2,'1',0,'SRFX7UBECEHH','bank_transfer',NULL,242.92,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(3,'1',0,'WACB1YYSJEEV','bank_transfer',NULL,60.73,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(4,'1',0,'4MHZPMUIH03X','bank_transfer',NULL,121.46,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(5,'1',0,'5LZ8CWVMF9Q6','bank_transfer',NULL,182.19,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(6,'1',0,'G1LAJCOFCHM3','bank_transfer',NULL,303.65,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(7,'1',0,'HDNXGAK9WJZD','bank_transfer',NULL,242.92,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(8,'1',0,'HXZ29Z1ZACIY','bank_transfer',NULL,242.92,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(9,'1',0,'YRCA7UE1UNCI','bank_transfer',NULL,303.65,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(10,'1',0,'IJGGTYGPXKSN','bank_transfer',NULL,121.46,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(11,'1',0,'DFLRYFO2LQ8V','bank_transfer',NULL,18.34,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(12,'1',0,'QKD2WGGMRJGL','bank_transfer',NULL,91.70,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:00','2025-06-10 10:44:00',NULL,NULL),(13,'1',0,'061ZJ6JDVTRO','bank_transfer',NULL,18.34,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(14,'1',0,'BXRECARO2RYP','bank_transfer',NULL,73.36,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(15,'1',0,'Y3BOE58AD181','bank_transfer',NULL,18.34,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(16,'1',0,'FLXFFVRTB28K','bank_transfer',NULL,18.34,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(17,'1',0,'HE8KRHQ9QI96','bank_transfer',NULL,18.34,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(18,'1',0,'4ZRUJE4Z6KFQ','bank_transfer',NULL,91.70,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(19,'1',0,'QKKZ20TBDGYN','bank_transfer',NULL,73.36,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(20,'1',0,'IABNWF2WTOZH','bank_transfer',NULL,18.34,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(21,'1',0,'HRKJMNUNANBE','bank_transfer',NULL,397.90,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(22,'1',0,'LB08SD8QOZWB','bank_transfer',NULL,318.32,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(23,'1',0,'ABGBCZBGXM28','bank_transfer',NULL,238.74,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:01','2025-06-10 10:44:01',NULL,NULL),(24,'1',0,'HYDPF0ZRSR7K','bank_transfer',NULL,238.74,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(25,'1',0,'IR1QE7ME7IXL','bank_transfer',NULL,79.58,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(26,'1',0,'VRALQ8XVVSUY','bank_transfer',NULL,397.90,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(27,'1',0,'ZXUN5PR2KNOL','bank_transfer',NULL,397.90,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(28,'1',0,'03IWHWPF8G9U','bank_transfer',NULL,238.74,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(29,'1',0,'XS3S97FZSQAR','bank_transfer',NULL,159.16,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(30,'1',0,'OTQPV07TSUUZ','bank_transfer',NULL,159.16,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(31,'1',0,'RUMZDTYPE6B6','bank_transfer',NULL,295.40,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(32,'1',0,'KXOODFPBPWMK','bank_transfer',NULL,118.16,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(33,'1',0,'KHTMEVW72JMJ','bank_transfer',NULL,177.24,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(34,'1',0,'QHCMBIKNMGNY','bank_transfer',NULL,236.32,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(35,'1',0,'CTYDHH4WQ4AK','bank_transfer',NULL,177.24,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:02','2025-06-10 10:44:02',NULL,NULL),(36,'1',0,'AMO5QRP7RHBM','bank_transfer',NULL,295.40,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(37,'1',0,'XBILZNHWQBEU','bank_transfer',NULL,118.16,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(38,'1',0,'DGAFIZRAKMRX','bank_transfer',NULL,295.40,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(39,'1',0,'BMVSHT9JELB0','bank_transfer',NULL,295.40,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(40,'1',0,'DCBW15ICZ5AT','bank_transfer',NULL,177.24,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(41,'1',0,'NTIZE7YF3VBC','bank_transfer',NULL,290.58,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(42,'1',0,'R9ICAUDPHCDK','bank_transfer',NULL,387.44,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(43,'1',0,'7BZ3YGCEGWOP','bank_transfer',NULL,96.86,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(44,'1',0,'7UPVIBZXBMXD','bank_transfer',NULL,96.86,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(45,'1',0,'QOQOPDHJ7VFF','bank_transfer',NULL,96.86,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(46,'1',0,'OCTZFRLHXTWP','bank_transfer',NULL,193.72,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(47,'1',0,'I5GJUFED7E37','bank_transfer',NULL,96.86,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:03','2025-06-10 10:44:03',NULL,NULL),(48,'1',0,'PTXQ42WDTDHX','bank_transfer',NULL,387.44,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04',NULL,NULL),(49,'1',0,'F6NQWJMVIAIP','bank_transfer',NULL,387.44,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04',NULL,NULL),(50,'1',0,'HCKCKGHME9MJ','bank_transfer',NULL,96.86,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:44:04','2025-06-10 10:44:04',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (1,1),(4,1),(1,2),(2,2),(6,3),(3,3),(5,4),(4,4),(3,5),(1,5),(2,6),(3,6),(2,7),(1,7),(2,8),(4,8),(5,9),(4,9),(2,10),(5,10),(1,11),(3,11),(6,12),(5,12),(6,13),(2,13),(5,14),(4,14),(3,15),(2,15),(1,16),(4,16),(1,17),(5,17),(6,18),(4,19),(2,20),(1,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (5,1),(6,1),(3,1),(3,2),(4,2),(7,3),(2,3),(5,3),(7,4),(6,4),(1,5),(6,5),(2,5),(7,6),(2,6),(4,6),(4,7),(2,7),(6,7),(4,8),(5,8),(2,9),(6,9),(4,9),(3,10),(1,10),(2,10),(5,11),(7,11),(6,11),(7,12),(2,12),(3,13),(2,13),(6,13),(2,14),(4,14),(3,14),(2,15),(6,15),(5,15),(5,16),(6,16),(6,17),(5,17),(1,17),(4,18),(5,18),(1,18),(3,19),(7,19),(6,20),(7,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',636,NULL,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',1931,NULL,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',445,NULL,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',1947,NULL,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',707,NULL,'2025-06-10 10:43:41','2025-06-10 10:43:41'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',521,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',715,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',910,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',2282,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',169,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',191,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',1332,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',167,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',1960,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',1274,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',1359,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',478,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',667,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',1034,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',310,NULL,'2025-06-10 10:43:42','2025-06-10 10:43:42');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:43:20','2025-06-10 10:43:20');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:44:10'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:44:10'),(6,'language_hide_default','1',NULL,'2025-06-10 10:44:10'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:44:10'),(8,'language_display','all',NULL,'2025-06-10 10:44:10'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:44:10'),(10,'media_random_hash','8febb03870ae2867d4209a5d679ddf5d',NULL,'2025-06-10 10:44:10'),(11,'theme','eventify-homepage06',NULL,'2025-06-10 10:44:10'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:44:10'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:44:10'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:44:10'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:44:10'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:44:10'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:44:10'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:44:10'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:44:10'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:44:10'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:44:10'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:44:10'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:44:10'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:44:10'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:44:10'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:44:10'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:44:10'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:44:10'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:44:10'),(30,'theme-eventify-homepage06-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:44:10'),(31,'theme-eventify-homepage06-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:44:10'),(32,'theme-eventify-homepage06-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:44:10'),(33,'theme-eventify-homepage06-favicon','main/general/favicon.png',NULL,'2025-06-10 10:44:10'),(34,'theme-eventify-homepage06-logo','homepage06/general/logo.png',NULL,'2025-06-10 10:44:10'),(35,'theme-eventify-homepage06-homepage_id','1',NULL,'2025-06-10 10:44:10'),(36,'theme-eventify-homepage06-blog_page_id','4',NULL,'2025-06-10 10:44:10'),(37,'theme-eventify-homepage06-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:44:10'),(38,'theme-eventify-homepage06-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:44:10'),(39,'theme-eventify-homepage06-blog_post_items_per_row','3',NULL,'2025-06-10 10:44:10'),(40,'theme-eventify-homepage06-number_of_related_posts','3',NULL,'2025-06-10 10:44:10'),(41,'theme-eventify-homepage06-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:44:10'),(42,'theme-eventify-homepage06-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:44:10'),(43,'theme-eventify-homepage06-events_page_id','5',NULL,'2025-06-10 10:44:10'),(44,'theme-eventify-homepage06-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:44:10'),(45,'theme-eventify-homepage06-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:44:10'),(46,'theme-eventify-homepage06-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:44:10'),(47,'theme-eventify-homepage06-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:44:10'),(48,'theme-eventify-homepage06-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:44:10'),(49,'theme-eventify-homepage06-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:44:10'),(50,'theme-eventify-homepage06-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:44:10'),(51,'theme-eventify-homepage06-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:44:10'),(52,'theme-eventify-homepage06-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:44:10'),(53,'theme-eventify-homepage06-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:44:10'),(54,'theme-eventify-homepage06-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:44:10'),(55,'theme-eventify-homepage06-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:44:10'),(56,'theme-eventify-homepage06-logo_height','45px',NULL,'2025-06-10 10:44:10'),(57,'theme-eventify-homepage06-is_header_transparent','1',NULL,'2025-06-10 10:44:10'),(58,'theme-eventify-homepage06-display_header_top','1',NULL,'2025-06-10 10:44:10'),(59,'theme-eventify-homepage06-header_top_text_color','#ffffff',NULL,'2025-06-10 10:44:10'),(60,'theme-eventify-homepage06-header_top_background_color','#FF6700',NULL,'2025-06-10 10:44:10'),(61,'theme-eventify-homepage06-header_background_color','#ffffff',NULL,'2025-06-10 10:44:10'),(62,'theme-eventify-homepage06-header_text_color','#000000',NULL,'2025-06-10 10:44:10'),(63,'theme-eventify-homepage06-footer_background_color','#F9FAFB',NULL,'2025-06-10 10:44:10'),(64,'theme-eventify-homepage06-footer_text_color','#544E51',NULL,'2025-06-10 10:44:10'),(65,'theme-eventify-homepage06-footer_heading_color','#1A1719',NULL,'2025-06-10 10:44:10'),(66,'theme-eventify-homepage06-tp_primary_font','Figtree',NULL,'2025-06-10 10:44:10'),(67,'theme-eventify-homepage06-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:44:10'),(68,'theme-eventify-homepage06-primary_color','#FF6700',NULL,'2025-06-10 10:44:10'),(69,'theme-eventify-homepage06-secondary_color','#1A1719',NULL,'2025-06-10 10:44:10'),(70,'theme-eventify-homepage06-newsletter_popup_enable','1',NULL,'2025-06-10 10:44:10'),(71,'theme-eventify-homepage06-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:44:10'),(72,'theme-eventify-homepage06-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:44:10'),(73,'theme-eventify-homepage06-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:44:10'),(74,'theme-eventify-homepage06-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:44:10'),(75,'theme-eventify-homepage06-breadcrumb_background_color','#FF6700',NULL,'2025-06-10 10:44:10'),(76,'announcement_max_width','1210',NULL,'2025-06-10 10:44:10'),(77,'announcement_text_color','#000000',NULL,'2025-06-10 10:44:10'),(78,'announcement_background_color','transparent',NULL,'2025-06-10 10:44:10'),(79,'announcement_text_alignment','start',NULL,'2025-06-10 10:44:10'),(80,'announcement_dismissible','0',NULL,'2025-06-10 10:44:10'),(81,'announcement_font_size','14',NULL,'2025-06-10 10:44:10'),(82,'announcement_font_size_unit','px',NULL,'2025-06-10 10:44:10'),(83,'announcement_placement','theme',NULL,'2025-06-10 10:44:10'),(84,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:44:10','2025-06-10 10:44:10'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:44:10','2025-06-10 10:44:10'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:44:10','2025-06-10 10:44:10');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:44:10','2025-06-10 10:44:10');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:19','2025-06-10 10:43:19'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:20','2025-06-10 10:43:20'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:20','2025-06-10 10:43:20'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:43:20','2025-06-10 10:43:20'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:43:35','2025-06-10 10:43:35'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:43:41','2025-06-10 10:43:41'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:43:41','2025-06-10 10:43:41'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:43:41','2025-06-10 10:43:41'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:43:41','2025-06-10 10:43:41'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:43:41','2025-06-10 10:43:41'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:43:41','2025-06-10 10:43:41'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:43:41','2025-06-10 10:43:41'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:41','2025-06-10 10:43:41'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:43:42','2025-06-10 10:43:42'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:47','2025-06-10 10:43:47'),(59,'ms-athena-graham-v',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:47','2025-06-10 10:43:47'),(60,'maryse-collier-i',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:47','2025-06-10 10:43:47'),(61,'yesenia-kessler',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:48','2025-06-10 10:43:48'),(62,'katelyn-hill',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:48','2025-06-10 10:43:48'),(63,'ena-leuschke',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:48','2025-06-10 10:43:48'),(64,'vivien-runolfsdottir',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:48','2025-06-10 10:43:48'),(65,'miss-leilani-lynch',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:49','2025-06-10 10:43:49'),(66,'amara-swaniawski',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:49','2025-06-10 10:43:49'),(67,'gladys-schneider',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:49','2025-06-10 10:43:49'),(68,'jarod-heller-iii',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:50','2025-06-10 10:43:50'),(69,'prof-kaelyn-armstrong',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:50','2025-06-10 10:43:50'),(70,'myrtis-rosenbaum',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:50','2025-06-10 10:43:50'),(71,'weldon-howe',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:50','2025-06-10 10:43:50'),(72,'miss-eldora-daugherty-ii',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:51','2025-06-10 10:43:51'),(73,'pamela-block',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:51','2025-06-10 10:43:51'),(74,'woodrow-fahey',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:51','2025-06-10 10:43:51'),(75,'prof-janiya-von',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:51','2025-06-10 10:43:51'),(76,'anissa-jenkins-jr',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:51','2025-06-10 10:43:51'),(77,'tina-hermiston-v',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:52','2025-06-10 10:43:52'),(78,'tamara-will',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:52','2025-06-10 10:43:52'),(79,'mr-benjamin-watsica',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:43:52','2025-06-10 10:43:52'),(80,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(81,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(82,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(83,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(84,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(85,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(86,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(87,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:43:59','2025-06-10 10:43:59'),(88,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:44:00','2025-06-10 10:44:00'),(89,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:44:00','2025-06-10 10:44:00'),(90,'dr-felton-bruen-ii',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(91,'edwin-boyle',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(92,'dr-beverly-zulauf',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(93,'marianna-skiles',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(94,'bethany-corkery-v',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(95,'mr-toy-ebert',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(96,'aiden-ondricka',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(97,'pearline-cummerata',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(98,'elmore-schneider-v',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(99,'marcelina-auer-ii',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(100,'marcia-thompson',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(101,'prof-lea-waters-phd',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(102,'dr-aric-brown',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(103,'jarred-cartwright',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(104,'marcia-lebsack',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(105,'gustave-strosin-v',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(106,'jordi-baumbach',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(107,'elliot-grimes-md',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(108,'dr-raymond-jakubowski-dds',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(109,'mason-bode',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(110,'laney-douglas',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(111,'zachery-terry-iv',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(112,'mr-danial-nitzsche',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(113,'josianne-ankunding',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(114,'angel-yundt-iv',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(115,'sadie-konopelski',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(116,'scotty-ernser',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(117,'lonzo-hoppe',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(118,'kamryn-littel',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(119,'joyce-zboncak',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(120,'aisha-quitzon',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(121,'mrs-carlotta-nolan-v',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(122,'jaquan-dickinson',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(123,'estevan-mante',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(124,'geo-rice-v',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(125,'isabelle-ernser',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(126,'destinee-orn',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(127,'anastacio-mcglynn',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(128,'mikel-bernier',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(129,'karen-emard',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(130,'chyna-jacobson',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10'),(131,'dr-estrella-mayert-dvm',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:10','2025-06-10 10:44:10');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:43:52','2025-06-10 10:43:52');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:43:41','2025-06-10 10:43:41'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:43:41','2025-06-10 10:43:41'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:43:41','2025-06-10 10:43:41'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:43:41','2025-06-10 10:43:41'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:43:41','2025-06-10 10:43:41'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:43:41','2025-06-10 10:43:41'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:43:41','2025-06-10 10:43:41');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:43:21','2025-06-10 10:43:21'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:43:21','2025-06-10 10:43:21'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:43:21','2025-06-10 10:43:21'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:43:21','2025-06-10 10:43:21');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'ford.wolf@lehner.net',NULL,'$2y$12$D.93dieowb/oDe8y8VMIV.pl9aCQCOf.Y7ZU5BYxRXo7k4dOCGlqa',NULL,'2025-06-10 10:43:20','2025-06-10 10:43:20','Noah','Bergnaum','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage06',1,'[]','2025-06-10 10:43:35','2025-06-10 10:43:35'),(2,'SocialLinksWidget','header_sidebar','eventify-homepage06',2,'[]','2025-06-10 10:43:35','2025-06-10 10:43:35'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage06',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo-light.png\"}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage06',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage06',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage06',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(7,'EventListWidget','event_list_sidebar','eventify-homepage06',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage06',1,'[]','2025-06-10 10:43:35','2025-06-10 10:43:35'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage06',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage06',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage06',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage06',1,'{\"background_color\":\"#FF6700\",\"button_label\":\"Buy Ticket\"}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage06',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:43:35','2025-06-10 10:43:35'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage06',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:43:35','2025-06-10 10:43:35');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:44:11
