-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'ZD9GASsgwsr3QHgRbbchirXTAEvr1xka',1,'2025-06-10 10:45:26','2025-06-10 10:45:26','2025-06-10 10:45:26');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:46:16',NULL,1,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:46:16',NULL,1,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:46:16',NULL,1,'2025-06-10 10:46:16','2025-06-10 10:46:16');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Magni eius expedita quia rerum suscipit. Consequatur voluptatum ducimus optio. Maxime voluptate similique consequatur quae. Laborum molestias id voluptas quae aut minima.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(2,'Leadership &amp; Strategy',0,'Voluptatem non consequatur nulla tempora ut hic culpa. Fuga consectetur placeat sapiente. Sint perspiciatis eveniet facere est debitis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(3,'Networking &amp; Collaboration',0,'Sed quam at eos nesciunt. Vitae magnam sequi tempora temporibus aperiam. Amet eaque eos ipsam explicabo quia.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(4,'Entrepreneurship Startups',0,'Voluptate veritatis dolores animi quis alias. Repellendus odio recusandae sit nihil sunt ea. Aut praesentium esse aperiam dolor consequatur.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(5,'Marketing &amp; Branding',0,'Consequatur animi sint minus qui dolores aut officia necessitatibus. Cum nam repellat officiis sapiente maxime dolorum. Aliquid soluta est quas id.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(6,'Event Highlights &amp; Recaps',0,'Molestiae nihil cumque ea ad sint aut in. Neque at iure consequatur in. Error voluptate labore quasi est id ex sint. Ullam recusandae ut cupiditate molestiae maiores ut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:45:49','2025-06-10 10:45:49');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Annette Schamberger','glemke@example.net','567.833.7124','649 Carlo Pike Apt. 215\nJudgeshire, CO 08277','Explicabo expedita sint id qui.','Voluptas tempora et eum corrupti. Porro et dolorem est dolorem inventore quo. Omnis maxime nobis explicabo nostrum molestias numquam. Dolore ex consequatur animi fugiat qui. Dolores reprehenderit numquam est et rerum repellendus. Iure perferendis eos aut ut labore repudiandae. Et voluptatibus laudantium voluptates quas. Aut quia et laborum veniam quo est quibusdam. Quia ea ex sapiente. Quia exercitationem quae perspiciatis dignissimos et odio. Laborum recusandae sed ut est.',NULL,'unread','2025-06-10 10:45:27','2025-06-10 10:45:27'),(2,'Vladimir Cole','gibson.tabitha@example.com','425-959-3467','30543 Cartwright Station\nBlandabury, KS 37994-4069','Quibusdam qui quasi quis rerum.','Ex aut maiores nostrum aut cumque id voluptatibus. Quia ex sint quis molestiae sunt omnis. Exercitationem possimus non rerum sit voluptate laboriosam accusamus. Et vel aspernatur qui eligendi quam. Velit et earum facere. Ea aliquid illum voluptas et a qui hic. Alias dignissimos sint magnam. Reprehenderit ipsa numquam aut illum ea quis qui. Ipsa rerum ut quaerat officiis aut. Veniam ratione eveniet facere corporis dolore cumque placeat id. Sit consequatur sed nulla ut et.',NULL,'unread','2025-06-10 10:45:27','2025-06-10 10:45:27'),(3,'Savanna Altenwerth Jr.','thora51@example.org','+1-216-802-0777','854 Brown Fort Apt. 358\nMagnoliaborough, ND 95927-7147','Qui fuga maiores quo.','Excepturi qui consequuntur doloremque itaque architecto. Rem aliquid asperiores illum delectus. Odio et mollitia saepe consequatur qui optio. Aliquam nemo iste occaecati dolorem. Voluptas quis praesentium vel at occaecati reprehenderit officia. Ut vel repellendus sunt. Ut enim accusamus dolore. Sit nemo optio est. Eius itaque non voluptas nostrum officiis aliquid ipsam. Modi repellat aperiam aut vitae. Et illum libero sint quam quibusdam quo.',NULL,'read','2025-06-10 10:45:27','2025-06-10 10:45:27'),(4,'Mrs. Jaunita Hane','vstark@example.com','831-263-8122','3564 Euna Crossing\nHortenseberg, KY 22337','Quos eum perspiciatis dicta ut eveniet.','Exercitationem labore eius ratione mollitia molestiae iusto. Consectetur voluptate ipsum sed omnis eligendi tempora quod. Rem nulla cupiditate velit officia amet quo. Quo ratione et eaque explicabo voluptates quis. Est sit libero earum ut dolor sapiente cupiditate. Labore pariatur ipsam nisi sequi. Ut repellendus maxime adipisci sed eaque perspiciatis. Consectetur veritatis veritatis veritatis et a voluptas a ut.',NULL,'unread','2025-06-10 10:45:27','2025-06-10 10:45:27'),(5,'Naomi Donnelly IV','mark56@example.com','+14589943062','246 Alva Mews Suite 000\nAracelytown, CO 96267','Doloribus magnam rerum fugiat earum.','Animi sequi minus nisi qui ut quisquam nihil. Impedit et similique dolorem voluptatem facere ea impedit maxime. Quo illum culpa reprehenderit quia aut et. Quidem facilis necessitatibus adipisci iste est. Dolor nisi asperiores ut praesentium quisquam excepturi. Veritatis doloribus nostrum dolore repudiandae aspernatur voluptate cupiditate. Necessitatibus aliquid in dolorem. Incidunt nam pariatur illum at vel.',NULL,'unread','2025-06-10 10:45:27','2025-06-10 10:45:27'),(6,'Alfonso Fisher Sr.','dahlia.padberg@example.org','650.987.6967','1565 Rempel Hills Apt. 194\nWest Lucileburgh, CA 14658','Modi debitis sit natus aliquam.','Eveniet et iure dolores sed ea nulla. Aliquid qui aliquid tempora dolores nemo. Vero magnam at deleniti voluptas placeat accusantium. Id ducimus quam tempore at voluptatem fuga. Vero vel qui iusto cum necessitatibus molestias dolore. Animi qui officiis saepe dolorem. Est ut et eius. Nulla ullam at aspernatur voluptas. Dolorum quasi quas in deserunt suscipit quasi. Accusamus ea quo rerum aperiam. Incidunt ad eos dolor dolores eaque porro quia facilis.',NULL,'unread','2025-06-10 10:45:27','2025-06-10 10:45:27'),(7,'Mr. Javon Block','marilou47@example.org','+1.304.403.8869','27560 Arnoldo Fort\nBergnaumberg, MD 07448','Quaerat beatae voluptatibus aut et asperiores.','Sit ea voluptatem consequatur sit et unde praesentium temporibus. Possimus et distinctio consequatur voluptate. Est voluptatum id rerum natus. Ut voluptas quaerat labore doloremque. Tempora omnis veritatis molestiae adipisci. Quam laboriosam itaque mollitia cupiditate. Minus quia perferendis tenetur et dolores. Animi ut quia accusantium est iste est ut.',NULL,'read','2025-06-10 10:45:27','2025-06-10 10:45:27'),(8,'Sammie Jacobi Sr.','hdurgan@example.org','262.358.9128','653 Miller Hill\nChamplintown, NC 39623','Molestiae velit quasi quibusdam.','Pariatur provident et est earum nemo omnis. Non officia cumque alias. Est magnam quo rerum et. Assumenda fugit ut unde qui ab. Voluptas amet sequi aut odit quia repudiandae. Consequatur quia laudantium eos vel ut. Inventore quidem aut sint eius sit voluptatem sed. Repellat quis aperiam quidem eaque. Id rerum enim sit ut dolorum non. Voluptatibus et in autem distinctio maxime. Ut architecto vel reiciendis qui consequatur qui non sed. Nostrum qui laborum ut quibusdam.',NULL,'read','2025-06-10 10:45:27','2025-06-10 10:45:27'),(9,'Laila O\'Conner','znikolaus@example.net','719.482.7416','36468 Suzanne Greens\nSouth Hoseamouth, NV 54615-1919','Occaecati nulla suscipit ut rerum et id qui.','Et odio voluptatem iusto ex maxime. Qui exercitationem ut aperiam tempore. Est voluptatem veniam quis voluptatem ipsam et ut ex. Distinctio vitae odio et qui sint numquam modi. Facere asperiores vel voluptatibus ea debitis natus vel. Culpa tempora blanditiis nesciunt et dolor beatae. Dignissimos nihil explicabo ipsa consequuntur architecto qui. Ad sunt quod blanditiis eos consectetur consequatur vel. Et nostrum eveniet eius quisquam.',NULL,'read','2025-06-10 10:45:27','2025-06-10 10:45:27'),(10,'Dr. Garrick Effertz','corwin.abigale@example.net','+1 (564) 969-5284','1477 Parker Crescent Suite 244\nGottliebstad, DE 45998-7134','Rerum harum sint qui nobis ea perspiciatis.','Cumque tempore aut aspernatur incidunt sit voluptatibus doloremque. Hic eos accusantium excepturi eligendi a et aliquid. Illum id inventore eum excepturi. Et ea aut et qui omnis quia aliquid. Voluptas amet eum tempore doloremque delectus reiciendis illum. Iusto laudantium sed id animi. Laudantium id reiciendis ipsum facere nostrum aut. Reiciendis corporis aliquam neque est rem. Ipsa fugit soluta reiciendis suscipit. Enim et facilis autem et deleniti. Consectetur ipsam illum error.',NULL,'unread','2025-06-10 10:45:27','2025-06-10 10:45:27');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:45:59',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:45:59',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:45:59',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:45:59',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:45:59',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:45:59',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Micah Haag','customer@archielite.com','$2y$12$baK/yw5InBgpHF1/JmDIH.odW8Yhg2EQzZElN88zbR2ejuR6amSa.',NULL,'0400022327','2022-10-18','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:54','2025-06-10 10:45:54'),(2,'Michael Smith','prohaska.llewellyn@hotmail.com','$2y$12$Esbi09XeAgbBBDGl1LtwD.y54JJnM6V4MjKsXDfMspLCN7Mgd729m','homepage08/speakers/4.png','0818781873','2016-10-29','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:54','2025-06-10 10:45:54'),(3,'Chesley Howe','berry.welch@daugherty.com','$2y$12$8N0PR1RE07qxhUXSJ5gpv.k3Vp4HOZUxllIVoq.3mN6ndFMNnlU7y','homepage08/speakers/2.png','0137298968','2017-12-07','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:54','2025-06-10 10:45:54'),(4,'Alana Wyman DVM','kovacek.rene@schmitt.com','$2y$12$3fr8pAgFuWkQLKORwOQRA.t1DRGTZdhvRUFtSsgLfs/.HgNzo3b3O','homepage08/speakers/3.png','0032600448','2007-12-01','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:45:54','2025-06-10 10:45:54'),(5,'Valentina Goldner','lonie.renner@gmail.com','$2y$12$T0ymH3HRizdj/z.kUe/5J.UL5BoYXF9PNFVeeQWuNCNnAYUkmVg4a','homepage08/speakers/2.png','0223660592','2014-12-08','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:54','2025-06-10 10:45:54'),(6,'Aiyana Mann','donnelly.emmett@gmail.com','$2y$12$xUDAtow0SmwZLbZ0To1ha.DXY57CKvGNxe//0ykUmslD8ju1WoZE2','homepage08/speakers/3.png','0102967944','2014-06-21','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:54','2025-06-10 10:45:55'),(7,'Dewitt Skiles','dickinson.russell@donnelly.net','$2y$12$QWp3xFv2Ouq6d7VNFVaBqext9EpVUMcFl/wXYF04AhkWTLVrwmp1i','homepage08/speakers/3.png','0819146118','2015-08-22','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:55','2025-06-10 10:45:55'),(8,'Ettie Stokes DDS','casandra65@yahoo.com','$2y$12$S4hLRQdKxG927Zzr6BPomOve.AfRXtmKie0.GPu.7e3pP1dLIb1RG','homepage08/speakers/2.png','0545409975','2024-12-26','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:55','2025-06-10 10:45:55'),(9,'Yesenia Lebsack','otillman@bosco.biz','$2y$12$GMWga3zsBatsZbB9u.4i/e/R772kzEe0BXBZK7rXrL5bmmULiWgNi',NULL,'0402634473','2018-01-31','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:55','2025-06-10 10:45:55'),(10,'Kareem Boehm','ewilliamson@yahoo.com','$2y$12$kLV/Gf61Ql6og3yEFsRoLOnbhzKqpHrVOS4OgJ0RV3gyX6tL4U2Ee','homepage08/speakers/4.png','0632750648','2019-03-14','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:55','2025-06-10 10:45:55'),(11,'Abe Runte','annetta.kunde@barrows.com','$2y$12$hF33zOGO/nrN7dLA11LKpudo3n09PqFNeKwOEIGPBotT8Fz7HkOyC','homepage08/speakers/3.png','0936348578','2021-04-26','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:45:55','2025-06-10 10:45:55'),(12,'Verna Schultz','emilio67@gmail.com','$2y$12$h7Wrhr5Y6PMYcA8b761QROZDl4bcXa88NHuWP04Qxwdb55eeqb.Lq','homepage08/speakers/5.png','0616718942','2005-12-15','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:45:56','2025-06-10 10:45:56'),(13,'Miss Shannon Schneider III','preston.von@hotmail.com','$2y$12$XJ1SUSse0u9AhO9.WeLULuYgh7hV6Xm.vj8rWHP5tUSwBVZ/p2pEW','homepage08/speakers/2.png','0868664219','2018-01-23','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:56','2025-06-10 10:45:56'),(14,'Prof. Buster Simonis III','lorenzo74@gmail.com','$2y$12$esNBsdrWdKZd6eS68SUQzO4sRZeEr0nwNMXFHi0BXYOpEppokhXwe','homepage08/speakers/4.png','0416751988','2021-06-27','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:45:56','2025-06-10 10:45:56'),(15,'Doug Connelly','jared.beatty@yahoo.com','$2y$12$2LoH.2rB4tpQONyZ.6Oa8Oz6DwZNvmT1Yq6rAbii9RQKPpM82lpRO','homepage08/speakers/5.png','0376875706','2004-11-14','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:56','2025-06-10 10:45:56'),(16,'Tiffany Murray','ullrich.kirstin@yahoo.com','$2y$12$JfVulBEuiXfIVJMVpaHSyeQeLNEUHWkLj/lG2UeIaluGZHqyTGqyO','homepage08/speakers/5.png','0456902926','2023-04-17','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:45:56','2025-06-10 10:45:56'),(17,'Emerald Carter','brice.volkman@gibson.info','$2y$12$Qrn.0HORENE1mV1LLr.caufgQlnQtmi3xCwnmn/dVsiaiQxBRaY0W','homepage08/speakers/3.png','0750731457','2007-12-27','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:56','2025-06-10 10:45:56'),(18,'Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com','$2y$12$32TXqFdiULK2hBmqVdCU9O33367/.Wq/nJAoyOqpaMCdajWU3m05S',NULL,'0836839242','2021-07-28','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:57','2025-06-10 10:45:57'),(19,'Adrienne Nader','aaron.gerlach@hotmail.com','$2y$12$qtRQU9hxYzJkz0Bo3sOMHeqY3072yI8MwfuOqy890nxwYEyGRCWiq',NULL,'0853319189','2002-09-11','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:57','2025-06-10 10:45:57'),(20,'Jacey Olson','elliot13@gmail.com','$2y$12$n0r/sEl7ChyNDnk35VLDJ.g.ztGSUQvyQtXgFq8SJ6/CCf4ZkmHhG','homepage08/speakers/1.png','0078032482','2003-07-08','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:57','2025-06-10 10:45:57'),(21,'Meredith Bernier','thora56@gmail.com','$2y$12$HJNwla/uWAA9tllAtjEwFOTGpex9EaLsB0RyBI6YDW5nsUFj7pvzm','homepage08/speakers/4.png','0285085960','2020-01-28','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:45:57','2025-06-10 10:45:57'),(22,'Dr. Alyson Rowe','yfahey@adams.com','$2y$12$1HKSdK3An67eqKKAFoQXaunPvZZguO2mDvBHZLp7HJwZjth9hepeS',NULL,'0044963355','2000-01-13','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:57','2025-06-10 10:45:57'),(23,'Lourdes Hansen','crooks.camilla@yahoo.com','$2y$12$.z7GgCm8JbmR8YWTZCMtNuO7Db4iABROOCItGNXxVxfHyEZ/CN2pm',NULL,'0205031111','2010-10-15','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:58','2025-06-10 10:45:58'),(24,'Brando Gulgowski','aledner@yahoo.com','$2y$12$nM0lMKtU3RZuQPjHI0PBPOECUr3yc2hpScakjkG9XmB1gPi2K/va2','homepage08/speakers/5.png','0389344522','2019-04-15','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:58','2025-06-10 10:45:58'),(25,'Prof. Emmalee Abshire DDS','czulauf@gerlach.com','$2y$12$BRFZhDE6vpVSoS52IwCGyOKhbbZK.b/9Za4tPKGuBzRbDLDE0lXlS','homepage08/speakers/2.png','0783188748','2013-09-24','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:58','2025-06-10 10:45:58'),(26,'Ms. Alessia Schuppe MD','tskiles@kunde.com','$2y$12$qmw11mztaoPAftOFsqsG2Ohcke5FQRYoFD/OsCoOpsfzRmDGFNpeK',NULL,'0667402597','2006-02-12','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:58','2025-06-10 10:45:58'),(27,'Jack Herman','oren43@gmail.com','$2y$12$wCcqsCJD8dAi71HKb7g8aOR/Y/p6mQAcKiVKytHAIQAu8w9CK856W',NULL,'0881447408','2017-03-26','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:58','2025-06-10 10:45:58'),(28,'Karl Sipes','mayer.bernie@hotmail.com','$2y$12$gf06cHZc2N3UdOF.rCLvw.Yp0r5amkfZk08c/Lg4IwpM4so0SvYmy',NULL,'0884003682','2020-06-10','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:58','2025-06-10 10:45:58'),(29,'Dr. Domenic Champlin','ppowlowski@yahoo.com','$2y$12$1Y0qrQHKaSN8dRUheibSmuAX.Dqm7lDb0kkWNM2/UIXWbiHUNgnCG','homepage08/speakers/2.png','0061124028','2023-07-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:59','2025-06-10 10:45:59'),(30,'Elenor McCullough DVM','aaliyah81@mitchell.net','$2y$12$eAcJUL.MvK9N9Jp3jq7KF.nJCDja3KqoGKTXVehXJTZvdw.wNCiSW','homepage08/speakers/2.png','0415494298','1999-06-22','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:45:59','2025-06-10 10:45:59'),(31,'Ignatius Lind','jack.lehner@ledner.com','$2y$12$2xSSVd0iZGSIfwjzXp2BkuojhdSZxHQfLA0w6O70wgtNOlxy04XoC',NULL,'0819436787','2002-09-14','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:59','2025-06-10 10:45:59'),(32,'Elwyn Rogahn','sporer.ana@gmail.com','$2y$12$e1sw.f0JE7OYK1uMK75JLe6BOMcN7GDLGU8P4248D3.tooGm8fugO',NULL,'0065069786',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(33,'Prof. Tomasa Roberts IV','deonte.sipes@cronin.com','$2y$12$RSw.bZXG9BJkv1jvvSCh6.CLh0o9EjH0pjsEjl.nM03zWqASzvMjC',NULL,'0301595701',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(34,'Isabelle Morar','raleigh.mitchell@kuhn.com','$2y$12$0wH/wZNE6ZLMjyHiYIEEPeDeDaRhj6wOh8POEsYpZdlsNP38Jlj86',NULL,'0161516778',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(35,'Arjun Osinski','dan.hackett@reichert.info','$2y$12$OP9EVGY3z.2Kcjqb3z9eSuB65Pe3jEYFrF.cPJZOLqLF9wpVx1yCm',NULL,'0669471401',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:11','2025-06-10 10:46:11'),(36,'Roosevelt Witting','michaela34@gmail.com','$2y$12$cRtDxkuul1ejr1XSZ3E07ew5puehWrrLpQBVMc3bxfIEVsawc/p4a',NULL,'0876379417',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:11','2025-06-10 10:46:11'),(37,'Margaret Howe','hbrown@gmail.com','$2y$12$a4LusRi.cIVOEUtUX3jnGOR2SjLO1Xq41VHkiDgddFccB.urkkPnm',NULL,'0392453575',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:11','2025-06-10 10:46:11'),(38,'Serenity Boehm','watsica.trace@gmail.com','$2y$12$/TKRatDWBT6h1yeCimK8B.ArEh8JV4ySMmY9aHc/P8ANaODNvmH2i',NULL,'0997792990',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:11','2025-06-10 10:46:11'),(39,'Raymundo O\'Keefe','augustine77@gmail.com','$2y$12$nQHS00XtD6jS7HM3RIyEv.esbcAEXxEB4B3t.3NGGynvIVFu77uyW',NULL,'0076653037',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:11','2025-06-10 10:46:11'),(40,'Laila Zboncak Jr.','qdenesik@luettgen.biz','$2y$12$JQ4dSbCax/.88nMGABIqnOxpI4TyDI7xOyV5cEoT3YQqd5s4IrFD2',NULL,'0730071153',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:11','2025-06-10 10:46:11'),(41,'Dillon Herzog','hohara@hotmail.com','$2y$12$afRHZLvM9gBlVyOfEwVcHO9NnOrHher.GNdbbXqN3xv1GlFwo4tZO',NULL,'0688802987',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:11','2025-06-10 10:46:11'),(42,'Dimitri Heathcote','gaylord.larissa@wisozk.com','$2y$12$jBF7vUWWLGcD1t6xSDvwhuMntPFMjBTi4UZpjUyemzou8UZQsqG3W',NULL,'0051325432',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:12','2025-06-10 10:46:12'),(43,'Dr. Elisabeth Boyle','juvenal51@yahoo.com','$2y$12$2wmsh/3nRcmq5oYlHRG6kObv1O8Htp0lOq6RUKeE632Te9ZcBjpge',NULL,'0483929462',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:12','2025-06-10 10:46:12'),(44,'Joe Moen','zwill@gibson.com','$2y$12$h1Eg6mgCmuhxuXa5WcqNsenHTeOFyW/BWKI/l3xMx2DQdtlupYlZ6',NULL,'0362281270',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:12','2025-06-10 10:46:12'),(45,'Rylee Buckridge','dkuphal@gmail.com','$2y$12$cmgNg/7EdLZRrkRWB5DkOeS7cro/aPJK8c5hMNrt9EpMOHGXntb9W',NULL,'0807080384',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:12','2025-06-10 10:46:12'),(46,'Montana Greenholt','little.valentina@hotmail.com','$2y$12$83DEgdlqb3ep7DAh3pcTO.LFqEqdlf3Z2K/6TPdYWGZyIsb/L7NOW',NULL,'0508032865',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:12','2025-06-10 10:46:12'),(47,'Marquis Wisozk','alphonso.jones@gmail.com','$2y$12$nQiFsAuzEFKD6ZTfPHyHPehZLanWCI5GcvwVJz2OHG0eki7is/QtW',NULL,'0715054589',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:12','2025-06-10 10:46:12'),(48,'Tierra Harber','qwyman@hotmail.com','$2y$12$KWibCvXAT20TX/AzJbpr5u9OKiL/x4yM0rb9R.85wDWGiBRSJfmle',NULL,'0693323748',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:12','2025-06-10 10:46:12'),(49,'Weston Nitzsche','hconn@hotmail.com','$2y$12$/oF7iW8abxw7TsRwQ8R94OJwOjdpaZ2a4e2Ip8QD3XDMoXgPo8.Mm',NULL,'0414239295',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:13','2025-06-10 10:46:13'),(50,'Giuseppe Flatley','weldon.vandervort@fadel.info','$2y$12$.Bpqc1QwLJk5ecM2iSrPduijwi.p67mhyStpY3Lc8ln21JxKabnwa',NULL,'0177620105',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:13','2025-06-10 10:46:13'),(51,'Mrs. Peggie Legros III','witting.ruby@gmail.com','$2y$12$pCFaJZTcdBeVaNg1oI1S8OaPd49iX.LGmvwRrxoa3QRhYlXaOHLYO',NULL,'0240886600',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:13','2025-06-10 10:46:13'),(52,'Vella Hodkiewicz','beryl96@rau.biz','$2y$12$TuaXvOrF7GfyqrUM4iYJ7uVM16mNhs1sC4p4p2UgjBSehnR4ayeZq',NULL,'0303049733',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:13','2025-06-10 10:46:13'),(53,'Miracle Bayer PhD','mayra.lynch@rohan.com','$2y$12$PDdOJLUM01g9Kj78NkWNTega4Ns62Zj9OWwV95vrQzgaBK/w7fqyy',NULL,'0354665950',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:13','2025-06-10 10:46:13'),(54,'Shana Olson','kaylah.zboncak@heller.com','$2y$12$ZG1W5bgNQ3P1HBUsGJLnruo.OYqSZUmQ4N6eAypVup5yWFGlDxuRW',NULL,'0219075232',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:13','2025-06-10 10:46:13'),(55,'Miss Retha Collier MD','delilah.goldner@haag.net','$2y$12$pbycD58nBWAAF6OQ.yUOfuP6GUn0Owar9.cQD1kEMD1lKW4thUdum',NULL,'0187335770',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:13','2025-06-10 10:46:13'),(56,'Jo Shanahan','kara.cassin@yahoo.com','$2y$12$EnGDKiFZserKJzjNQQbP4e44Y1Y/WT1iIB7dNbef.4kmez44nQ582',NULL,'0668043410',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:14','2025-06-10 10:46:14'),(57,'Dr. Desmond Medhurst','bert20@herman.info','$2y$12$O3xu/ZFqNmAUOLiyNM.b3u/d3w19U932D/jBhVts721L/pR/LpiOW',NULL,'0255125003',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:14','2025-06-10 10:46:14'),(58,'Taryn Jenkins','brandy.keebler@reichel.com','$2y$12$xuCgKt6IyUxW31VZE/EB.Ou9Cjv3fvy82c4gB/9KvqX7XBhLZmvIS',NULL,'0974018102',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:14','2025-06-10 10:46:14'),(59,'Myrtie Ratke','wava89@ratke.info','$2y$12$BH6lnLBu1Z/NVmfh9ZWgv.xrLNX2Lcd6yGhZ6gq7Lh5KwaZ2aCRiy',NULL,'0984989177',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:14','2025-06-10 10:46:14'),(60,'Mrs. Isabelle Cole','borer.rita@hotmail.com','$2y$12$.nSh1zYtpo82QViObO0RVuPULy.q8dJJeawQQ5Hhwpx2/3YjhWmoS',NULL,'0346503268',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:14','2025-06-10 10:46:14'),(61,'Trystan Boyer','ada.paucek@gmail.com','$2y$12$ryJ.grJiLdvvKdCv3BB0Bup7Z108KmX7YdOkNTk5ohxmI2nZ2.iu2',NULL,'0615533836',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:14','2025-06-10 10:46:14'),(62,'Aubree Ratke','windler.brayan@gmail.com','$2y$12$2xi5bUB7IFFQGQBC92204eAp2qJH/1rE7UTilySvJAUrj3xAgCk12',NULL,'0784613633',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:14','2025-06-10 10:46:14'),(63,'Keeley Koss','ollie.willms@gmail.com','$2y$12$lIf5cgZ2sKCY0S8L0cZLY.r0rCVYRMqd4nz5L2P83noHaOI6D6hRi',NULL,'0044799946',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:15','2025-06-10 10:46:15'),(64,'Edison Towne','okeefe.dortha@yahoo.com','$2y$12$ATBr5ELwoVS3nrpAbgNzF.EW9HzGdYQhsPUzo/WtmKoBoFo.AVSee',NULL,'0569259574',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:15','2025-06-10 10:46:15'),(65,'Jackson Reinger','veum.myah@effertz.info','$2y$12$OupaFVyP6Fcq5yZex4MLMOa2p7r5xihow4nc.uRy8Tr5ncd319yma',NULL,'0883506270',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:15','2025-06-10 10:46:15'),(66,'Misael McKenzie','heidi94@boyer.biz','$2y$12$iW1AchXlG1oEaQf/THmZu.HNle0DOGdjN8UTHp4uLrbynQN1QCPTy',NULL,'0740493476',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:15','2025-06-10 10:46:15'),(67,'Anastasia Christiansen','dane.yost@yahoo.com','$2y$12$PCN.IL9NFRt/089TORmyiuun3LfzbOzwcCINl7erXAiE0ps3rtLVu',NULL,'0210883615',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:15','2025-06-10 10:46:15'),(68,'Miss Tressie Donnelly','camden40@pfannerstill.biz','$2y$12$rugYJronwSaanXka8o8hjOcRho43sRJqTJL.19dInCqzpbi.zM88O',NULL,'0680259022',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:15','2025-06-10 10:46:15'),(69,'Keven Witting','ustroman@gmail.com','$2y$12$9KueMYERZGPMFFRnInvtKuae8Gd2wy8AmISClPYShbO2HrS9zAxNm',NULL,'0820587009',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(70,'Casimir Zboncak','jasper.oberbrunner@yahoo.com','$2y$12$PoB7ghmwjMy.Hl4bjIVhaO3kzcZskdPwos1ylpTRl1Om0ggzjyFli',NULL,'0803381025',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(71,'Ashley Ebert','ryan.roscoe@shields.com','$2y$12$Pl8zkQ/Q0B4KF.FaFpFB0uD0Z.EIytiGuXLe9Z9XBuOZ5B6FJFHA6',NULL,'0408075851',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:16','2025-06-10 10:46:16');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:45:20','2025-06-10 10:45:20'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:45:20','2025-06-10 10:45:20'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:45:20','2025-06-10 10:45:20');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (1,44,'1HW8WGXL4HZV',NULL),(1,32,'6YGBMRGTFAYO',NULL),(4,58,'9XARQKN1MTTT',NULL),(3,54,'A1QSIVAOG79U',NULL),(1,43,'AE2X5SIASHBH',NULL),(5,66,'B2THRK8QYCGB',NULL),(2,46,'F7YXVP3A16EB',NULL),(5,67,'FPGBZNOAHMMA',NULL),(3,53,'FPIA0NCGJZUB',NULL),(4,62,'FUWL66RSWAHO',NULL),(2,49,'GAKWBADTFSMK',NULL),(5,65,'HF0SINXBANBH',NULL),(3,52,'HF0ZBYC1NMME',NULL),(4,63,'HJXWQYMKHPZI',NULL),(4,57,'HMIMK3RFC8CN',NULL),(1,36,'HNZIOZ8YZDKZ',NULL),(5,68,'JDMLA56Q2DR8',NULL),(1,34,'LK6H9KLEQ9SS',NULL),(4,59,'N4YURJB9JIQ0',NULL),(4,60,'O4QN7LZIHX8G',NULL),(3,55,'ONHMHNYPJBC1',NULL),(2,47,'PSO4XDV0LCVH',NULL),(5,64,'PV9YM4FKADID',NULL),(3,50,'RCNIJZ0BWOB9',NULL),(1,41,'RJSY8KGOHLOD',NULL),(1,35,'TN2GTJAHKARQ',NULL),(1,39,'U1K8ZVBD6HVY',NULL),(3,51,'U6WP2QJO8OMW',NULL),(5,70,'U8AZFEA8BUAN',NULL),(2,48,'UQJCHCRWSKKA',NULL),(1,40,'VWJZLVXXYAVJ',NULL),(5,69,'WB4NA4VSCCD1',NULL),(5,71,'WZ5EVT4ZFMHA',NULL),(1,37,'X3J9TCMLTO7F',NULL),(2,45,'XJ8YDSIYDUQW',NULL),(1,33,'XQCYXCCZDIZ2',NULL),(1,42,'Y0VEAP9HYKZE',NULL),(1,38,'Z3IPAFWCIZI2',NULL),(3,56,'ZALNSEIGAVPI',NULL),(4,61,'ZMKBIDBWNHZ3',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,17,'Officia distinctio voluptatem corrupti consequatur. Qui neque nisi at sint.',NULL,0,NULL,NULL),(1,24,'Facilis asperiores quos dolorum quasi dolor. Qui fugit iusto ratione tempore quo repellendus.',NULL,1,NULL,NULL),(1,25,'Quo error libero voluptatem iste. Delectus sequi magni ex aut. Ex perspiciatis quis quis.',NULL,2,NULL,NULL),(1,29,'Aut accusamus dolor qui similique quia. Qui et repellat reiciendis inventore at.',NULL,3,NULL,NULL),(2,13,'Tempora et accusantium animi quia amet. Et rerum voluptas nostrum iste.',NULL,0,NULL,NULL),(2,7,'Aliquam qui dolore fugit nulla omnis. Esse atque ab quaerat dolores molestiae alias vero facilis.',NULL,1,NULL,NULL),(2,30,'Sint odit similique possimus. Debitis amet omnis id alias. Consequatur rerum nemo quae.',NULL,2,NULL,NULL),(3,6,'Ipsam porro quas vero autem quia. Natus tempore ad quia qui assumenda neque.',NULL,0,NULL,NULL),(3,10,'Enim atque ducimus quis natus. Illum maxime nostrum nulla et ex qui mollitia voluptas.',NULL,1,NULL,NULL),(3,7,'Et molestiae odit consequuntur iure. Aut nam praesentium explicabo et aut nulla id.',NULL,2,NULL,NULL),(3,29,'Rem suscipit porro veniam minima soluta. Sed quam non ratione qui. Dicta sed aut officia quam.',NULL,3,NULL,NULL),(4,10,'Et modi quisquam saepe culpa eos asperiores. Laborum quia at non. Omnis molestiae earum et.',NULL,0,NULL,NULL),(4,24,'Sit ut voluptatibus sit qui non. Et rerum in neque rerum. Eaque reprehenderit et dolor quam quia a.',NULL,1,NULL,NULL),(4,7,'Officiis quia in doloribus fugiat laudantium. Sit et culpa maxime dolores qui.',NULL,2,NULL,NULL),(4,29,'Asperiores tempora aut possimus assumenda. At ut ipsum molestiae dolorem quod ut vero.',NULL,3,NULL,NULL),(5,7,'Magnam cum itaque modi hic quia. Consectetur minima non autem quibusdam ipsa eum minus.',NULL,0,NULL,NULL),(5,29,'In officiis voluptas dolorem possimus. Quia exercitationem tenetur quo ut quod molestiae.',NULL,1,NULL,NULL),(5,25,'Doloribus vero veritatis magni labore. Quidem aliquid est et ad laborum quibusdam quia modi.',NULL,2,NULL,NULL),(5,24,'Eos et voluptatem ad ipsum quisquam perferendis. Aliquid excepturi culpa non quia.',NULL,3,NULL,NULL),(6,7,'Iusto aut et veniam ut laborum. Animi fugit atque qui et beatae voluptatem. Est ut odio magnam hic.',NULL,0,NULL,NULL),(6,24,'Dolor et corrupti velit et. Dolore vero accusamus ut in. Cum officiis et at autem ullam inventore.',NULL,2,NULL,NULL),(6,10,'Illum occaecati velit ab saepe nobis. Rerum est corporis sequi qui maxime.',NULL,3,NULL,NULL),(7,7,'Repudiandae dolores voluptas odio animi ad sequi. Voluptatem assumenda sit modi et rerum.',NULL,0,NULL,NULL),(7,30,'Saepe et a et qui rerum et omnis. Explicabo error aut incidunt ad sit facere.',NULL,1,NULL,NULL),(7,3,'Et cum architecto deleniti incidunt. Est qui sapiente ad rem officiis perspiciatis quia.',NULL,2,NULL,NULL),(7,25,'Esse consequatur labore labore consectetur ipsum. Aperiam deserunt fugit laudantium quo maiores.',NULL,3,NULL,NULL),(8,8,'Saepe ex libero dolorem eius. Fuga blanditiis culpa tenetur. Quas vel nihil nulla cupiditate.',NULL,0,NULL,NULL),(8,30,'Est totam est culpa a dolorem atque nihil. Sapiente quia eum rerum.',NULL,1,NULL,NULL),(8,29,'Alias architecto at vel quam. Non at ad laboriosam occaecati unde hic est.',NULL,2,NULL,NULL),(8,3,'Veritatis numquam recusandae sed sapiente enim ut. Voluptates qui deserunt suscipit.',NULL,3,NULL,NULL),(9,17,'Tempora sed molestias et porro natus. Impedit minus non recusandae et reiciendis nisi.',NULL,0,NULL,NULL),(9,20,'Ducimus dignissimos sit dolor omnis. Molestiae quo dolorem facere. Non qui quia et est.',NULL,1,NULL,NULL),(9,29,'Iusto atque illo assumenda adipisci magni. Delectus velit velit occaecati quia.',NULL,2,NULL,NULL),(9,25,'Qui et et esse laudantium sapiente. Asperiores illo sit voluptate. Quod provident eaque molestias.',NULL,3,NULL,NULL),(10,6,'Consequuntur vero porro omnis. Et repudiandae et ut aut laborum ut.',NULL,0,NULL,NULL),(10,17,'Et itaque aut cum. Sunt ab perspiciatis id esse delectus vitae.',NULL,2,NULL,NULL),(10,20,'Ut eos ducimus dolorem sed architecto non voluptas. Sed non quibusdam magni cum nihil.',NULL,3,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',21,'Suscipit beatae dolor quidem dolorem eligendi quia neque est.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','e73fc404-e4a4-3063-8112-e09f311b26a8','main/events/1.webp',38.03,'99469 Pacocha Circle Suite 157\nNew Krystelchester, LA 32708-8981',2,2,2,'49.958485','102.024111',84,0,'2025-06-10 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(2,'Mobile World Congress',4,'Dolor asperiores qui minus.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','4db1fb44-742b-3a93-8bc8-0c47c177ca45','main/events/2.webp',33.77,'74565 Denesik Centers\nLake Bell, NY 31163-1945',2,2,2,'-5.760205','100.772638',68,0,'2025-06-10 09:00:00','2025-06-22 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(3,'Google I/O',11,'Accusantium necessitatibus cupiditate ea excepturi.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','163fc6ae-f573-393b-9e94-77fe3a1cf65d','main/events/3.webp',1.76,'3769 Mayer Valleys Suite 027\nEusebioberg, ID 20928-5282',5,5,5,'-55.989733','6.468294',63,0,'2025-06-10 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(4,'Apple WWDC',11,'Et et qui aut ipsa optio.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','27b3bd6e-ad4b-31a7-950f-b5e2f3797d0c','main/events/4.webp',14.61,'7766 Steuber Crossing Suite 188\nPort Gerson, NC 61026-4067',4,4,4,'-59.160805','-148.459987',98,0,'2025-06-10 09:00:00','2025-06-22 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(5,'AWS re:Invent',4,'In suscipit nihil placeat nulla qui dolores tempore.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','8c91855e-d49d-3f7d-97c5-0b1d39be7010','main/events/5.webp',46.03,'5968 Doyle Roads Suite 635\nPort Margotland, ME 76393',3,NULL,NULL,'41.173176','-18.614069',97,0,'2025-06-11 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(6,'Microsoft Build',11,'Et maiores qui modi consequatur ut excepturi animi.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','ada90d02-e9f2-3691-a4af-78ca0d22d501','main/events/6.webp',14.56,'623 Durgan Groves\nRociomouth, NH 10776',2,2,2,'-54.680341','-93.678518',83,0,'2025-06-11 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(7,'Facebook F8',16,'Laudantium dicta ex expedita sed non.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','c79fe6fe-f767-3181-a4d5-ce63e584a700','main/events/7.webp',63.14,'904 Brayan Coves\nPort Katrina, ID 84385-1110',4,4,4,'-10.735738','-163.61752',80,0,'2025-06-11 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(8,'GitHub Universe',21,'Praesentium aut repellendus tenetur a culpa eius ad quia.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','97e7383e-359e-33b0-99c3-6467332b9ae1','main/events/8.webp',70.35,'153 Alexys Bridge Suite 075\nPort Milan, MI 83662-9338',3,NULL,NULL,'34.705187','-57.217088',86,0,'2025-06-11 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(9,'Game Developers Conference',16,'Nulla quaerat dolore corrupti magnam officiis facere ut aliquid.','The largest conference in the gaming industry, focusing on game development and gaming technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','0c707e56-4a9a-3540-8e7c-1e158287f53a','main/events/9.webp',79.10,'2421 Jaylen Expressway Suite 413\nNorth Cristian, AR 40160',3,NULL,NULL,'52.652968','83.781248',60,0,'2025-06-12 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(10,'Web Summit',14,'Asperiores mollitia accusantium aspernatur fugit.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','d09b13dc-3872-375c-b147-dde2326cf848','main/events/10.webp',12.78,'621 Adah Islands Apt. 543\nParisianchester, MN 99476-9285',2,2,2,'40.150186','-155.671945',76,0,'2025-06-12 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:46:06','2025-06-10 10:46:06');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Mr. Laverna Marks DVM - ortiz.ryley@bradtke.com','ortiz.ryley@bradtke.com','0414918402',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Charity Quigley - geraldine78@hermiston.com','geraldine78@hermiston.com','0529930893',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(3,2,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Hazle Huels - lavada34@yahoo.com','lavada34@yahoo.com','0504551704',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(4,2,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Rahul Reichert Sr. - tyra.hyatt@heidenreich.com','tyra.hyatt@heidenreich.com','0697653848',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(5,3,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Elwyn Rogahn - sporer.ana@gmail.com','sporer.ana@gmail.com','0065069786',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(6,3,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Prof. Tomasa Roberts IV - deonte.sipes@cronin.com','deonte.sipes@cronin.com','0301595701',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(7,3,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Isabelle Morar - raleigh.mitchell@kuhn.com','raleigh.mitchell@kuhn.com','0161516778',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(8,3,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Arjun Osinski - dan.hackett@reichert.info','dan.hackett@reichert.info','0669471401',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(9,3,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Roosevelt Witting - michaela34@gmail.com','michaela34@gmail.com','0876379417',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Margaret Howe - hbrown@gmail.com','hbrown@gmail.com','0392453575',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(11,4,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Cecilia Huels - ondricka.estell@gmail.com','ondricka.estell@gmail.com','0513098950',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(12,4,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Juana Kreiger - urban.boyer@yahoo.com','urban.boyer@yahoo.com','0326178013',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Maritza Walter - kunde.manley@hotmail.com','kunde.manley@hotmail.com','0863966898',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(14,4,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Bobby Cole - esther08@hotmail.com','esther08@hotmail.com','0409238196',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Prof. Stephan Kunze - abby89@yahoo.com','abby89@yahoo.com','0468814821',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Jamie Metz - ulindgren@hotmail.com','ulindgren@hotmail.com','0631945194',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(17,5,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Serenity Boehm - watsica.trace@gmail.com','watsica.trace@gmail.com','0997792990',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(18,5,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Raymundo O\'Keefe - augustine77@gmail.com','augustine77@gmail.com','0076653037',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(19,5,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Laila Zboncak Jr. - qdenesik@luettgen.biz','qdenesik@luettgen.biz','0730071153',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(20,6,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Jace Kessler IV - ryan.imogene@gmail.com','ryan.imogene@gmail.com','0886555038',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(21,6,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Brock Abshire - mmraz@hotmail.com','mmraz@hotmail.com','0026478515',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(22,6,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Tod Dickinson - claudie95@bogan.info','claudie95@bogan.info','0584109269',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(23,6,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Prof. John Cole - cecelia82@prosacco.info','cecelia82@prosacco.info','0606954190',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(24,7,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Dillon Herzog - hohara@hotmail.com','hohara@hotmail.com','0688802987',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(25,7,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Dimitri Heathcote - gaylord.larissa@wisozk.com','gaylord.larissa@wisozk.com','0051325432',1,38.03,38.03,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(26,8,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Dr. Elisabeth Boyle - juvenal51@yahoo.com','juvenal51@yahoo.com','0483929462',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(27,8,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Joe Moen - zwill@gibson.com','zwill@gibson.com','0362281270',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(28,9,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Viola Kohler IV - glebsack@hotmail.com','glebsack@hotmail.com','0837504208',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(29,9,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Ike Schuppe - waino24@conn.org','waino24@conn.org','0951012053',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(30,9,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Asa Fay - natasha62@yahoo.com','natasha62@yahoo.com','0323388722',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(31,9,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Vito Kozey - kling.alicia@gmail.com','kling.alicia@gmail.com','0446781113',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(32,9,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Tyrique Hudson - aubree.smitham@casper.com','aubree.smitham@casper.com','0897136762',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(33,9,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Morgan Lesch - tbashirian@welch.org','tbashirian@welch.org','0589657753',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(34,10,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Vincenzo Wunsch - olson.paige@reilly.net','olson.paige@reilly.net','0649911843',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(35,10,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Alexandrea Schinner MD - patsy28@dare.net','patsy28@dare.net','0650021234',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(36,10,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Novella Turcotte - osinski.johnpaul@okon.com','osinski.johnpaul@okon.com','0931011090',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(37,10,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Ms. Zoey Lind - mayer.fernando@gmail.com','mayer.fernando@gmail.com','0295116816',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(38,10,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Nelson Buckridge Jr. - lang.oceane@hotmail.com','lang.oceane@hotmail.com','0579321446',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(39,10,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Zackery Hackett - upacocha@gmail.com','upacocha@gmail.com','0825425882',1,38.03,38.03,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(40,11,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'Mobile World Congress - Rylee Buckridge - dkuphal@gmail.com','dkuphal@gmail.com','0807080384',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(41,11,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'Mobile World Congress - Montana Greenholt - little.valentina@hotmail.com','little.valentina@hotmail.com','0508032865',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(42,11,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'Mobile World Congress - Marquis Wisozk - alphonso.jones@gmail.com','alphonso.jones@gmail.com','0715054589',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(43,12,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Noemi Waelchi - dietrich.jammie@hotmail.com','dietrich.jammie@hotmail.com','0900077018',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(44,12,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Dr. Enos Ruecker - tdooley@schmitt.com','tdooley@schmitt.com','0647545429',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(45,12,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Dean Morissette - volkman.shyanne@weber.com','volkman.shyanne@weber.com','0293051730',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(46,12,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Kiley Goyette - senger.trystan@yahoo.com','senger.trystan@yahoo.com','0913300257',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(47,13,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Tierra Harber - qwyman@hotmail.com','qwyman@hotmail.com','0693323748',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(48,13,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Weston Nitzsche - hconn@hotmail.com','hconn@hotmail.com','0414239295',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(49,14,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Amber Blanda - cbruen@gmail.com','cbruen@gmail.com','0338627467',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(50,14,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Diana Bauch - wyost@yahoo.com','wyost@yahoo.com','0099634819',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(51,15,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Alvah Veum - anna51@west.net','anna51@west.net','0032913275',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(52,15,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Rosemary Kassulke - botsford.karelle@hotmail.com','botsford.karelle@hotmail.com','0272327548',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(53,15,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Jovan Dicki - vchristiansen@friesen.org','vchristiansen@friesen.org','0489075576',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(54,15,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Mr. Madison Walker Jr. - yhessel@hammes.com','yhessel@hammes.com','0912179618',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(55,15,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Viola Medhurst - amira18@yahoo.com','amira18@yahoo.com','0791733205',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(56,15,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Deja Schiller - christian.volkman@sporer.com','christian.volkman@sporer.com','0494179934',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(57,16,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Mr. Larue Feest - grady.larson@hotmail.com','grady.larson@hotmail.com','0628494650',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(58,16,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Carter Cassin - ygreenholt@gulgowski.biz','ygreenholt@gulgowski.biz','0082958534',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(59,16,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Virgie Smitham - lowe.pierre@gmail.com','lowe.pierre@gmail.com','0065453170',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(60,16,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Mr. Gayle Klocko IV - jgreenfelder@casper.com','jgreenfelder@casper.com','0495249242',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(61,17,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Harmony Senger IV - maudie.wolf@gmail.com','maudie.wolf@gmail.com','0608388508',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(62,17,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Prof. Bo Kulas DVM - fadel.rory@gmail.com','fadel.rory@gmail.com','0496092541',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(63,17,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Mrs. Felipa Haag - ullrich.kevin@jenkins.com','ullrich.kevin@jenkins.com','0661913894',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(64,18,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Dr. Obie Price - stacey40@mueller.com','stacey40@mueller.com','0584537497',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(65,18,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Mrs. Yessenia Kunze - kiara66@gmail.com','kiara66@gmail.com','0678973717',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(66,18,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Ottilie Littel - schulist.carmel@yahoo.com','schulist.carmel@yahoo.com','0942116013',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(67,19,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Jarod Runolfsson DDS - ecasper@corkery.org','ecasper@corkery.org','0264617885',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(68,19,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Dannie Hackett - igutkowski@gmail.com','igutkowski@gmail.com','0909817891',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(69,19,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Sherwood Stracke - rutherford.sandrine@simonis.com','rutherford.sandrine@simonis.com','0613168222',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(70,19,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Mrs. Lavina DuBuque - mohr.cristian@strosin.com','mohr.cristian@strosin.com','0639763035',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(71,19,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Lloyd Farrell - haleigh60@torp.info','haleigh60@torp.info','0197547166',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(72,20,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Celia Donnelly III - kpfeffer@orn.org','kpfeffer@orn.org','0062759601',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(73,20,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Shanel Feest II - hilpert.carlee@conn.com','hilpert.carlee@conn.com','0071857938',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(74,20,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Mr. Blake Bode - brody22@yahoo.com','brody22@yahoo.com','0991355476',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(75,20,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Glenda Ankunding III - johnson56@watsica.com','johnson56@watsica.com','0686208749',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(76,20,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Rosalinda Stamm - mante.harmon@cummings.net','mante.harmon@cummings.net','0595936048',1,33.77,33.77,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(77,20,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Olen Hackett - bboyle@hotmail.com','bboyle@hotmail.com','0088355694',1,33.77,33.77,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(78,21,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Google I/O - Darryl Feest - jovany84@krajcik.com','jovany84@krajcik.com','0163971425',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(79,21,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Google I/O - Johnathan Weber - fmante@waelchi.com','fmante@waelchi.com','0142275180',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(80,21,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Google I/O - Cade Hansen Jr. - mrogahn@pfeffer.com','mrogahn@pfeffer.com','0298551566',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(81,21,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Google I/O - Donnie Zieme - ttreutel@hotmail.com','ttreutel@hotmail.com','0746818986',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(82,21,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Google I/O - Mr. Enid Goyette V - wolff.wilfred@reynolds.biz','wolff.wilfred@reynolds.biz','0823000001',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(83,22,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Google I/O - Jermey Donnelly - satterfield.baby@hotmail.com','satterfield.baby@hotmail.com','0288628301',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(84,22,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Google I/O - Effie Altenwerth Jr. - dell76@hotmail.com','dell76@hotmail.com','0134871102',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(85,22,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Nicolette Herzog - beier.robyn@little.com','beier.robyn@little.com','0062418911',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(86,22,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Dr. Anastasia Weber - jameson.toy@simonis.com','jameson.toy@simonis.com','0301044478',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(87,23,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Dustin Berge DDS - justine06@lubowitz.com','justine06@lubowitz.com','0253941723',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(88,23,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Elizabeth Zboncak - ezra82@gmail.com','ezra82@gmail.com','0634168497',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(89,23,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Josianne Wisoky - destin.ziemann@lubowitz.com','destin.ziemann@lubowitz.com','0618716217',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(90,23,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Emilie Heller DDS - bpurdy@shanahan.net','bpurdy@shanahan.net','0770540057',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(91,23,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Vena Hermann I - tharvey@pfeffer.com','tharvey@pfeffer.com','0526672184',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(92,24,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Oleta Brakus - karson.harber@gmail.com','karson.harber@gmail.com','0873583823',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(93,24,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Dr. Emile Russel - ondricka.joey@gmail.com','ondricka.joey@gmail.com','0346485556',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(94,24,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Missouri Kiehn Jr. - arlene.fahey@oconner.biz','arlene.fahey@oconner.biz','0681402347',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(95,25,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Kirstin Windler - adelia45@yahoo.com','adelia45@yahoo.com','0844854461',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(96,25,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Antonina Mueller - eoconner@rippin.com','eoconner@rippin.com','0933502251',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(97,25,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Miss Gerry O\'Keefe III - carolina69@barrows.org','carolina69@barrows.org','0872207070',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(98,26,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Giuseppe Flatley - weldon.vandervort@fadel.info','weldon.vandervort@fadel.info','0177620105',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(99,26,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Mrs. Peggie Legros III - witting.ruby@gmail.com','witting.ruby@gmail.com','0240886600',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(100,26,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Vella Hodkiewicz - beryl96@rau.biz','beryl96@rau.biz','0303049733',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(101,27,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Dr. Etha Gerlach Jr. - champlin.mandy@yahoo.com','champlin.mandy@yahoo.com','0648543661',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(102,27,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Mrs. May Wisozk - quigley.kiara@gmail.com','quigley.kiara@gmail.com','0876380539',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(103,27,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Prof. Noemy Barrows - kgrant@yahoo.com','kgrant@yahoo.com','0640369627',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(104,27,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Enrique Cole DDS - jacobi.regan@ferry.com','jacobi.regan@ferry.com','0318151521',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(105,27,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Marquise Beier - johns.harley@gmail.com','johns.harley@gmail.com','0044145853',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(106,27,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Griffin Yost MD - danial49@douglas.com','danial49@douglas.com','0197041172',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(107,28,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Mr. Jon Heidenreich PhD - mitchell.boyer@beahan.com','mitchell.boyer@beahan.com','0266028634',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(108,28,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Prof. Dorcas Kutch - kaylee76@gmail.com','kaylee76@gmail.com','0170403670',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(109,28,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Albert Kassulke - kennith.lubowitz@hotmail.com','kennith.lubowitz@hotmail.com','0672235804',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(110,29,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Chanelle Homenick PhD - lynn34@yahoo.com','lynn34@yahoo.com','0445496143',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(111,29,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Nora Kuhn - rippin.hulda@jaskolski.info','rippin.hulda@jaskolski.info','0624306670',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(112,29,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Kailee Bartoletti Sr. - pollich.duncan@hotmail.com','pollich.duncan@hotmail.com','0147463637',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(113,29,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Dr. Annamarie Ullrich - shayna23@berge.com','shayna23@berge.com','0179865609',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(114,30,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Miracle Bayer PhD - mayra.lynch@rohan.com','mayra.lynch@rohan.com','0354665950',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(115,30,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Shana Olson - kaylah.zboncak@heller.com','kaylah.zboncak@heller.com','0219075232',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(116,30,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Miss Retha Collier MD - delilah.goldner@haag.net','delilah.goldner@haag.net','0187335770',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(117,30,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Google I/O - Jo Shanahan - kara.cassin@yahoo.com','kara.cassin@yahoo.com','0668043410',1,1.76,1.76,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(118,31,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Apple WWDC - Jess Moore - evie.heller@yahoo.com','evie.heller@yahoo.com','0701182562',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(119,31,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Apple WWDC - Mr. Barney Grady - janelle.boyer@hotmail.com','janelle.boyer@hotmail.com','0315169389',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(120,31,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Apple WWDC - Louvenia Streich - heidenreich.makenzie@wisozk.org','heidenreich.makenzie@wisozk.org','0923025464',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(121,31,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Apple WWDC - Ms. Shanelle Gislason DVM - flo.spinka@yahoo.com','flo.spinka@yahoo.com','0804374255',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(122,32,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Apple WWDC - Mylene Turner I - zetta.weber@yahoo.com','zetta.weber@yahoo.com','0290286489',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(123,32,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Apple WWDC - Alycia Purdy - vschneider@yahoo.com','vschneider@yahoo.com','0680168375',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(124,32,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Apple WWDC - Dr. Adolfo Pfannerstill - spencer.kayden@walker.net','spencer.kayden@walker.net','0470817863',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(125,32,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Jay Beer Sr. - gibson.alexzander@hotmail.com','gibson.alexzander@hotmail.com','0931201865',1,14.61,14.61,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(126,33,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Ms. Clotilde Hahn - runolfsdottir.nicola@gulgowski.com','runolfsdottir.nicola@gulgowski.com','0222712025',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(127,33,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Prof. Marques Stehr - aditya21@lindgren.com','aditya21@lindgren.com','0738965343',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(128,33,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Jackie Daugherty Jr. - luciano46@hane.net','luciano46@hane.net','0493519387',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(129,33,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Dr. Kaylah Brakus I - icie39@yahoo.com','icie39@yahoo.com','0038690256',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(130,34,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Thaddeus Jacobs MD - keith60@hotmail.com','keith60@hotmail.com','0543128618',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(131,34,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Magnus Wolf - carlotta50@koelpin.info','carlotta50@koelpin.info','0387491683',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(132,34,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Prof. Forrest Wolf Jr. - monty79@yahoo.com','monty79@yahoo.com','0074580879',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(133,34,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Della Mohr - jarrett12@murazik.org','jarrett12@murazik.org','0663391766',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(134,34,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Rhea VonRueden - ngutkowski@lehner.com','ngutkowski@lehner.com','0330405208',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(135,34,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Kimberly Pagac - meda91@emard.com','meda91@emard.com','0382971667',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(136,35,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Delpha Lueilwitz - billie47@schuppe.com','billie47@schuppe.com','0246978658',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(137,35,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Zelda Witting IV - yabbott@gmail.com','yabbott@gmail.com','0141645558',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(138,35,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Prof. Norval Legros - lwaelchi@mcdermott.info','lwaelchi@mcdermott.info','0525588481',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(139,35,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Ms. Arvilla Hartmann PhD - candice56@streich.com','candice56@streich.com','0887767754',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(140,35,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Shaylee Rosenbaum - oledner@sipes.com','oledner@sipes.com','0677027471',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(141,36,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Mandy Barton - armand.bauch@kilback.com','armand.bauch@kilback.com','0358126836',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(142,36,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Birdie Marvin - marianna74@gmail.com','marianna74@gmail.com','0225930569',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(143,36,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Aleen Schaefer V - ward77@hotmail.com','ward77@hotmail.com','0694030380',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(144,36,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Friedrich Barton - christiansen.rickey@mraz.info','christiansen.rickey@mraz.info','0431691735',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(145,36,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Osvaldo Weissnat - allan.huels@mohr.com','allan.huels@mohr.com','0550217168',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(146,37,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Dr. Desmond Medhurst - bert20@herman.info','bert20@herman.info','0255125003',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(147,37,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Taryn Jenkins - brandy.keebler@reichel.com','brandy.keebler@reichel.com','0974018102',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(148,37,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Myrtie Ratke - wava89@ratke.info','wava89@ratke.info','0984989177',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(149,38,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Mrs. Isabelle Cole - borer.rita@hotmail.com','borer.rita@hotmail.com','0346503268',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(150,38,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Trystan Boyer - ada.paucek@gmail.com','ada.paucek@gmail.com','0615533836',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(151,38,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Aubree Ratke - windler.brayan@gmail.com','windler.brayan@gmail.com','0784613633',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(152,38,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Keeley Koss - ollie.willms@gmail.com','ollie.willms@gmail.com','0044799946',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(153,39,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Adonis Becker - dondricka@funk.com','dondricka@funk.com','0481343542',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(154,39,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Dr. Hazle Thiel DVM - roslyn68@gmail.com','roslyn68@gmail.com','0163235291',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(155,39,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Gaylord Dicki PhD - cordia.kulas@baumbach.biz','cordia.kulas@baumbach.biz','0147524829',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(156,39,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Mr. Vincenzo Heidenreich DDS - yost.tillman@hotmail.com','yost.tillman@hotmail.com','0812914681',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(157,39,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Mr. Marcelo Stracke - harrison.hauck@yahoo.com','harrison.hauck@yahoo.com','0360265231',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(158,40,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Nya Kemmer - cbashirian@braun.com','cbashirian@braun.com','0391792927',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(159,40,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'Apple WWDC - Mr. Wilford Feeney Sr. - hodkiewicz.devon@bernhard.com','hodkiewicz.devon@bernhard.com','0885583183',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(160,40,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'Apple WWDC - Miss Princess Boehm DDS - kelly.marvin@yahoo.com','kelly.marvin@yahoo.com','0543947658',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(161,40,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'Apple WWDC - Dolly Reynolds - rogahn.milford@gmail.com','rogahn.milford@gmail.com','0957273523',1,14.61,14.61,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(162,41,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'AWS re:Invent - Darian Shanahan - conroy.sydney@corwin.net','conroy.sydney@corwin.net','0169187681',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(163,41,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'AWS re:Invent - Loyal Zieme - xkuvalis@harris.net','xkuvalis@harris.net','0265996496',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(164,42,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'AWS re:Invent - Ms. Antonette Cormier IV - clyde.watsica@yahoo.com','clyde.watsica@yahoo.com','0697760083',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(165,42,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'AWS re:Invent - Veda Lindgren III - wilfrid87@luettgen.biz','wilfrid87@luettgen.biz','0914167411',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(166,42,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'AWS re:Invent - Anika Dietrich IV - sophie.haley@gmail.com','sophie.haley@gmail.com','0450986384',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(167,42,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Dangelo Kutch V - gislason.valentine@yahoo.com','gislason.valentine@yahoo.com','0589876867',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(168,43,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Evalyn Smitham - trycia99@yahoo.com','trycia99@yahoo.com','0610070872',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(169,43,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Kameron Feeney - kaci.raynor@paucek.com','kaci.raynor@paucek.com','0968922258',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(170,44,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Jo Walker - moshe.steuber@gmail.com','moshe.steuber@gmail.com','0720218169',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(171,44,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Dr. Vincenzo Murazik - morissette.berniece@yahoo.com','morissette.berniece@yahoo.com','0915695828',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(172,45,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Edison Towne - okeefe.dortha@yahoo.com','okeefe.dortha@yahoo.com','0569259574',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(173,45,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Jackson Reinger - veum.myah@effertz.info','veum.myah@effertz.info','0883506270',1,46.03,46.03,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(174,45,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Misael McKenzie - heidi94@boyer.biz','heidi94@boyer.biz','0740493476',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(175,45,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Anastasia Christiansen - dane.yost@yahoo.com','dane.yost@yahoo.com','0210883615',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(176,45,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Miss Tressie Donnelly - camden40@pfannerstill.biz','camden40@pfannerstill.biz','0680259022',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(177,46,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Herminio Pagac - pharber@gmail.com','pharber@gmail.com','0064219807',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(178,46,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Susana Maggio - sonya35@gmail.com','sonya35@gmail.com','0229373702',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(179,46,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Khalid Lakin - bailey.brianne@sanford.biz','bailey.brianne@sanford.biz','0664443034',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(180,46,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Mr. Geovany Miller - lmccullough@kautzer.com','lmccullough@kautzer.com','0626999428',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(181,46,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Asia Vandervort - klocko.garrison@hotmail.com','klocko.garrison@hotmail.com','0921690485',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(182,46,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Ralph Smitham - ksimonis@hotmail.com','ksimonis@hotmail.com','0538018208',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(183,47,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Keven Witting - ustroman@gmail.com','ustroman@gmail.com','0820587009',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(184,47,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Casimir Zboncak - jasper.oberbrunner@yahoo.com','jasper.oberbrunner@yahoo.com','0803381025',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(185,47,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Ashley Ebert - ryan.roscoe@shields.com','ryan.roscoe@shields.com','0408075851',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(186,48,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Mr. Winston Bode V - kovacek.macie@mosciski.com','kovacek.macie@mosciski.com','0357470990',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(187,48,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Hal Beatty - marisa32@carter.biz','marisa32@carter.biz','0654294865',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(188,48,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Estrella Cormier - egrimes@stark.com','egrimes@stark.com','0689676020',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(189,48,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Dr. Wilfred Cummerata DVM - sabrina.douglas@gmail.com','sabrina.douglas@gmail.com','0410257001',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(190,48,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Luna Schroeder - betsy95@mante.net','betsy95@mante.net','0403045096',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(191,48,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Billie Predovic - deja60@barton.org','deja60@barton.org','0011105925',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(192,49,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Hope Hamill - meaghan.turcotte@yahoo.com','meaghan.turcotte@yahoo.com','0818530902',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(193,49,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Ally Hirthe - block.peyton@hotmail.com','block.peyton@hotmail.com','0579030100',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(194,49,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Eden Farrell I - lurline78@bernhard.com','lurline78@bernhard.com','0194188002',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(195,49,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Mrs. Kaelyn Keebler - reymundo.mclaughlin@gmail.com','reymundo.mclaughlin@gmail.com','0122588300',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(196,50,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Lionel Cremin - jennifer48@hotmail.com','jennifer48@hotmail.com','0472870126',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(197,50,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Prof. Zack Hackett - ibogan@hotmail.com','ibogan@hotmail.com','0499059586',1,46.03,46.03,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',38.03,'CES (Consumer Electronics Show)','Ms. Alessia Schuppe MD','tskiles@kunde.com',NULL,'ArchiElite','main/general/logo-light.png',38.03,38.03,0.00,0.00,NULL,1,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',38.03,'CES (Consumer Electronics Show)','Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',38.03,38.03,0.00,0.00,NULL,2,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',38.03,'CES (Consumer Electronics Show)','Micah Haag','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',190.15,190.15,0.00,0.00,NULL,3,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',38.03,'CES (Consumer Electronics Show)','Adrienne Nader','aaron.gerlach@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',190.15,190.15,0.00,0.00,NULL,4,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',38.03,'CES (Consumer Electronics Show)','Micah Haag','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',76.06,76.06,0.00,0.00,NULL,5,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',38.03,'CES (Consumer Electronics Show)','Adrienne Nader','aaron.gerlach@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',114.09,114.09,0.00,0.00,NULL,6,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',38.03,'CES (Consumer Electronics Show)','Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',38.03,38.03,0.00,0.00,NULL,7,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',38.03,'CES (Consumer Electronics Show)','Jack Herman','oren43@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',38.03,38.03,0.00,0.00,NULL,8,'completed','2025-06-10 10:46:06','2025-06-10 10:46:06','2025-06-10 10:46:06'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',38.03,'CES (Consumer Electronics Show)','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',190.15,190.15,0.00,0.00,NULL,9,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',38.03,'CES (Consumer Electronics Show)','Micah Haag','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',190.15,190.15,0.00,0.00,NULL,10,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',33.77,'Mobile World Congress','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',67.54,67.54,0.00,0.00,NULL,11,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',33.77,'Mobile World Congress','Jack Herman','oren43@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',101.31,101.31,0.00,0.00,NULL,12,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',33.77,'Mobile World Congress','Yesenia Lebsack','otillman@bosco.biz',NULL,'ArchiElite','main/general/logo-light.png',33.77,33.77,0.00,0.00,NULL,13,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',33.77,'Mobile World Congress','Ms. Alessia Schuppe MD','tskiles@kunde.com',NULL,'ArchiElite','main/general/logo-light.png',33.77,33.77,0.00,0.00,NULL,14,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',33.77,'Mobile World Congress','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',168.85,168.85,0.00,0.00,NULL,15,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',33.77,'Mobile World Congress','Dr. Alyson Rowe','yfahey@adams.com',NULL,'ArchiElite','main/general/logo-light.png',101.31,101.31,0.00,0.00,NULL,16,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',33.77,'Mobile World Congress','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',67.54,67.54,0.00,0.00,NULL,17,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',33.77,'Mobile World Congress','Lourdes Hansen','crooks.camilla@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',67.54,67.54,0.00,0.00,NULL,18,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',33.77,'Mobile World Congress','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',135.08,135.08,0.00,0.00,NULL,19,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',33.77,'Mobile World Congress','Ignatius Lind','jack.lehner@ledner.com',NULL,'ArchiElite','main/general/logo-light.png',168.85,168.85,0.00,0.00,NULL,20,'completed','2025-06-10 10:46:07','2025-06-10 10:46:07','2025-06-10 10:46:07'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',1.76,'Google I/O','Ignatius Lind','jack.lehner@ledner.com',NULL,'ArchiElite','main/general/logo-light.png',7.04,7.04,0.00,0.00,NULL,21,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',1.76,'Google I/O','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',5.28,5.28,0.00,0.00,NULL,22,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',1.76,'Google I/O','Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',7.04,7.04,0.00,0.00,NULL,23,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',1.76,'Google I/O','Dr. Alyson Rowe','yfahey@adams.com',NULL,'ArchiElite','main/general/logo-light.png',3.52,3.52,0.00,0.00,NULL,24,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',1.76,'Google I/O','Yesenia Lebsack','otillman@bosco.biz',NULL,'ArchiElite','main/general/logo-light.png',3.52,3.52,0.00,0.00,NULL,25,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',1.76,'Google I/O','Micah Haag','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',3.52,3.52,0.00,0.00,NULL,26,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',1.76,'Google I/O','Ms. Alessia Schuppe MD','tskiles@kunde.com',NULL,'ArchiElite','main/general/logo-light.png',8.80,8.80,0.00,0.00,NULL,27,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',1.76,'Google I/O','Jack Herman','oren43@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',3.52,3.52,0.00,0.00,NULL,28,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',1.76,'Google I/O','Adrienne Nader','aaron.gerlach@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',5.28,5.28,0.00,0.00,NULL,29,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',1.76,'Google I/O','Lourdes Hansen','crooks.camilla@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',5.28,5.28,0.00,0.00,NULL,30,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',14.61,'Apple WWDC','Adrienne Nader','aaron.gerlach@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',43.83,43.83,0.00,0.00,NULL,31,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',14.61,'Apple WWDC','Jack Herman','oren43@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',43.83,43.83,0.00,0.00,NULL,32,'completed','2025-06-10 10:46:08','2025-06-10 10:46:08','2025-06-10 10:46:08'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',14.61,'Apple WWDC','Ms. Alessia Schuppe MD','tskiles@kunde.com',NULL,'ArchiElite','main/general/logo-light.png',43.83,43.83,0.00,0.00,NULL,33,'completed','2025-06-10 10:46:09','2025-06-10 10:46:08','2025-06-10 10:46:09'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',14.61,'Apple WWDC','Yesenia Lebsack','otillman@bosco.biz',NULL,'ArchiElite','main/general/logo-light.png',73.05,73.05,0.00,0.00,NULL,34,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',14.61,'Apple WWDC','Jack Herman','oren43@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',58.44,58.44,0.00,0.00,NULL,35,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',14.61,'Apple WWDC','Yesenia Lebsack','otillman@bosco.biz',NULL,'ArchiElite','main/general/logo-light.png',58.44,58.44,0.00,0.00,NULL,36,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',14.61,'Apple WWDC','Ignatius Lind','jack.lehner@ledner.com',NULL,'ArchiElite','main/general/logo-light.png',29.22,29.22,0.00,0.00,NULL,37,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',14.61,'Apple WWDC','Lourdes Hansen','crooks.camilla@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',43.83,43.83,0.00,0.00,NULL,38,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',14.61,'Apple WWDC','Jack Herman','oren43@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',58.44,58.44,0.00,0.00,NULL,39,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',14.61,'Apple WWDC','Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',43.83,43.83,0.00,0.00,NULL,40,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',46.03,'AWS re:Invent','Ms. Alessia Schuppe MD','tskiles@kunde.com',NULL,'ArchiElite','main/general/logo-light.png',46.03,46.03,0.00,0.00,NULL,41,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',46.03,'AWS re:Invent','Lourdes Hansen','crooks.camilla@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',138.09,138.09,0.00,0.00,NULL,42,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',46.03,'AWS re:Invent','Ms. Alessia Schuppe MD','tskiles@kunde.com',NULL,'ArchiElite','main/general/logo-light.png',46.03,46.03,0.00,0.00,NULL,43,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',46.03,'AWS re:Invent','Lourdes Hansen','crooks.camilla@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',46.03,46.03,0.00,0.00,NULL,44,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',46.03,'AWS re:Invent','Lourdes Hansen','crooks.camilla@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',184.12,184.12,0.00,0.00,NULL,45,'completed','2025-06-10 10:46:09','2025-06-10 10:46:09','2025-06-10 10:46:09'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',46.03,'AWS re:Invent','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',230.15,230.15,0.00,0.00,NULL,46,'completed','2025-06-10 10:46:10','2025-06-10 10:46:10','2025-06-10 10:46:10'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',46.03,'AWS re:Invent','Micah Haag','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',92.06,92.06,0.00,0.00,NULL,47,'completed','2025-06-10 10:46:10','2025-06-10 10:46:10','2025-06-10 10:46:10'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',46.03,'AWS re:Invent','Ms. Alessia Schuppe MD','tskiles@kunde.com',NULL,'ArchiElite','main/general/logo-light.png',230.15,230.15,0.00,0.00,NULL,48,'completed','2025-06-10 10:46:10','2025-06-10 10:46:10','2025-06-10 10:46:10'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',46.03,'AWS re:Invent','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',138.09,138.09,0.00,0.00,NULL,49,'completed','2025-06-10 10:46:10','2025-06-10 10:46:10','2025-06-10 10:46:10'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',46.03,'AWS re:Invent','Karl Sipes','mayer.bernie@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',46.03,46.03,0.00,0.00,NULL,50,'completed','2025-06-10 10:46:10','2025-06-10 10:46:10','2025-06-10 10:46:10');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'LVAY6VGUZTUY','7ca9ad08-a10e-4807-b084-1ad99a67f028',1,'CES (Consumer Electronics Show)',38.03,26,1,'Ms. Alessia Schuppe MD','tskiles@kunde.com','Cat. \'I said pig,\' replied Alice; \'and I wish you wouldn\'t keep appearing and vanishing so.',NULL,'1',38.03,1,38.03,38.03,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(2,'TULFSVRMREOW','44c3b6f0-179e-4478-9d4f-5e36fc9498d7',1,'CES (Consumer Electronics Show)',38.03,18,1,'Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com','However, it was too dark to see how he can thoroughly enjoy The pepper when he pleases!\' CHORUS.',NULL,'2',38.03,1,38.03,38.03,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(3,'AIXQR8OTTJE8','02946c53-2668-45f7-bccf-b7073f05a9c0',1,'CES (Consumer Electronics Show)',38.03,1,1,'Micah Haag','customer@archielite.com','English); \'now I\'m opening out like the look of it at all; and I\'m I, and--oh dear, how puzzling.',NULL,'3',38.03,5,190.15,190.15,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(4,'ZAL6EXQZKUWS','98891e3f-4199-4785-a82d-94a96e217501',1,'CES (Consumer Electronics Show)',38.03,19,1,'Adrienne Nader','aaron.gerlach@hotmail.com','Yet you balanced an eel on the top of the March Hare. The Hatter looked at it, and finding it very.',NULL,'4',38.03,5,190.15,190.15,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(5,'Z4GEC1PJ9JN0','998de6a1-290d-4f95-adef-aaee12da3980',1,'CES (Consumer Electronics Show)',38.03,1,1,'Micah Haag','customer@archielite.com','Elsie, Lacie, and Tillie; and they can\'t prove I did: there\'s no use denying it. I suppose it were.',NULL,'5',38.03,2,76.06,76.06,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(6,'YLVOS4CSQOJS','a9c7b1b5-c2ef-462a-b2e7-75671f2b0dfe',1,'CES (Consumer Electronics Show)',38.03,19,1,'Adrienne Nader','aaron.gerlach@hotmail.com','I look like it?\' he said, turning to the other, looking uneasily at the beginning,\' the King said.',NULL,'6',38.03,3,114.09,114.09,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(7,'AARZOVDB8O8P','163ce726-1930-4f22-8f62-b9f21eb97bb7',1,'CES (Consumer Electronics Show)',38.03,18,1,'Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com','The Rabbit Sends in a deep voice, \'are done with blacking, I believe.\' \'Boots and shoes under the.',NULL,'7',38.03,1,38.03,38.03,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(8,'FDADIDYBEF9T','251fafd5-f944-4ef4-9e32-7fc66cf92855',1,'CES (Consumer Electronics Show)',38.03,27,1,'Jack Herman','oren43@gmail.com','Half-past one, time for dinner!\' (\'I only wish they COULD! I\'m sure I can\'t show it you myself,\'.',NULL,'8',38.03,1,38.03,38.03,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06'),(9,'SGDGQWI8CRTL','5054dbe6-431e-4fd0-bbbe-de2e109210bf',1,'CES (Consumer Electronics Show)',38.03,28,1,'Karl Sipes','mayer.bernie@hotmail.com','Mock Turtle, and to stand on their slates, and then Alice dodged behind a great hurry; \'this paper.',NULL,'9',38.03,5,190.15,190.15,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(10,'DWYUQOPIJDHY','9b50ece1-1e94-42f1-ae70-537292dd1d52',1,'CES (Consumer Electronics Show)',38.03,1,1,'Micah Haag','customer@archielite.com','Hatter: \'but you could draw treacle out of the table. \'Have some wine,\' the March Hare was said to.',NULL,'10',38.03,5,190.15,190.15,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(11,'X4VJWPZEJWG0','fba904fa-c87a-417c-ac1e-0a226ad1520a',2,'Mobile World Congress',33.77,28,1,'Karl Sipes','mayer.bernie@hotmail.com','King very decidedly, and he poured a little scream of laughter. \'Oh, hush!\' the Rabbit just under.',NULL,'11',33.77,2,67.54,67.54,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(12,'R0KWAJFVSNZ1','4f64cc7e-465a-4e9e-94b1-3e125387ee78',2,'Mobile World Congress',33.77,27,1,'Jack Herman','oren43@gmail.com','I almost think I must sugar my hair.\" As a duck with its arms and frowning at the Caterpillar\'s.',NULL,'12',33.77,3,101.31,101.31,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(13,'Q4FMEFFAPP91','3e9d456f-0a60-4018-9bee-796e3da8ca71',2,'Mobile World Congress',33.77,9,1,'Yesenia Lebsack','otillman@bosco.biz','Alice. \'Come on, then!\' roared the Queen, pointing to Alice as she heard one of the room again, no.',NULL,'13',33.77,1,33.77,33.77,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(14,'GNG7EKNLZNOR','a1b66584-9361-4008-b453-8a648c17c1fc',2,'Mobile World Congress',33.77,26,1,'Ms. Alessia Schuppe MD','tskiles@kunde.com','I\'m better now--but I\'m a deal faster than it does.\' \'Which would NOT be an old crab, HE was.\' \'I.',NULL,'14',33.77,1,33.77,33.77,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(15,'LPVGEOLKIOOW','84581199-991f-4531-88f6-be1c2d388232',2,'Mobile World Congress',33.77,28,1,'Karl Sipes','mayer.bernie@hotmail.com','I to get hold of this elegant thimble\'; and, when it saw Alice. It looked good-natured, she.',NULL,'15',33.77,5,168.85,168.85,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(16,'EX6FQ68EFSTH','9b757b55-7a34-447e-8683-df3528711d3d',2,'Mobile World Congress',33.77,22,1,'Dr. Alyson Rowe','yfahey@adams.com','WOULD twist itself round and get ready for your interesting story,\' but she did not quite sure.',NULL,'16',33.77,3,101.31,101.31,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(17,'3GC5FPLYRXVC','b7ea9efc-6a2c-480a-ba4e-fb11c2b7bc3c',2,'Mobile World Congress',33.77,28,1,'Karl Sipes','mayer.bernie@hotmail.com','Gryphon; and then nodded. \'It\'s no use in crying like that!\' By this time she went back to my.',NULL,'17',33.77,2,67.54,67.54,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(18,'X5JNEFR7FSUX','6222c87f-a32a-4136-bb97-123821af953d',2,'Mobile World Congress',33.77,23,1,'Lourdes Hansen','crooks.camilla@yahoo.com','Oh dear! I\'d nearly forgotten to ask.\' \'It turned into a cucumber-frame, or something of the.',NULL,'18',33.77,2,67.54,67.54,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(19,'8CVYCAVXSADB','67b69708-ab41-4e77-8907-76716c18f439',2,'Mobile World Congress',33.77,28,1,'Karl Sipes','mayer.bernie@hotmail.com','Alice noticed, had powdered hair that curled all over their shoulders, that all the rest, Between.',NULL,'19',33.77,4,135.08,135.08,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(20,'UHARGYFNN31F','73c94007-99a2-46cc-8517-5bd52e05ac17',2,'Mobile World Congress',33.77,31,1,'Ignatius Lind','jack.lehner@ledner.com','Between yourself and me.\' \'That\'s the reason and all the rest, Between yourself and me.\' \'That\'s.',NULL,'20',33.77,5,168.85,168.85,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07'),(21,'VJMNXQPKHBME','9ffbb8f0-bb2a-4c64-a5f4-df29ff70b90a',3,'Google I/O',1.76,31,1,'Ignatius Lind','jack.lehner@ledner.com','Alice began to get in?\' \'There might be some sense in your knocking,\' the Footman went on again.',NULL,'21',1.76,4,7.04,7.04,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(22,'Q4OOK2IRMSLA','f95b3300-2564-47a9-b23d-87a617713e7a',3,'Google I/O',1.76,28,1,'Karl Sipes','mayer.bernie@hotmail.com','March Hare will be When they take us up and down in a low voice, \'Why the fact is, you ARE a.',NULL,'22',1.76,3,5.28,5.28,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(23,'6IO6FGJBAHET','349712cb-1424-41e7-b1b8-2624882c4c97',3,'Google I/O',1.76,18,1,'Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com','I should be raving mad--at least not so mad as it is.\' \'I quite agree with you,\' said the King.',NULL,'23',1.76,4,7.04,7.04,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(24,'SJ4F7RHR0ZKJ','b2542b37-d4fe-4f6b-b8cf-fe67e7d92b59',3,'Google I/O',1.76,22,1,'Dr. Alyson Rowe','yfahey@adams.com','King. On this the White Rabbit, who was reading the list of singers. \'You may go,\' said the Mouse.',NULL,'24',1.76,2,3.52,3.52,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(25,'NELNNEGT1YJZ','c14ff7cc-97ff-4570-8abc-e39a10c525e7',3,'Google I/O',1.76,9,1,'Yesenia Lebsack','otillman@bosco.biz','I beat him when he finds out who was a paper label, with the lobsters and the turtles all advance!.',NULL,'25',1.76,2,3.52,3.52,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(26,'A2QTX5PKNDFR','fc45c76d-57ef-43bf-9fcd-7b33356dacdb',3,'Google I/O',1.76,1,1,'Micah Haag','customer@archielite.com','I should have croqueted the Queen\'s absence, and were quite silent, and looked at Alice. \'I\'M not.',NULL,'26',1.76,2,3.52,3.52,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(27,'LTLCJ15MTMH9','d899c9a2-61ed-4db1-87ab-7597e2489b89',3,'Google I/O',1.76,26,1,'Ms. Alessia Schuppe MD','tskiles@kunde.com','I\'ll try and repeat \"\'TIS THE VOICE OF THE SLUGGARD,\"\' said the Lory, with a yelp of delight, and.',NULL,'27',1.76,5,8.80,8.80,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(28,'U3JDDUOBF5MN','c9af3426-021f-4440-9f4d-befd1713d6d0',3,'Google I/O',1.76,27,1,'Jack Herman','oren43@gmail.com','Twinkle, twinkle--\"\' Here the Dormouse went on, turning to Alice, flinging the baby with some.',NULL,'28',1.76,2,3.52,3.52,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(29,'MZJEPQLE2XZV','11917c66-fd78-4d78-bc34-5a861f89e976',3,'Google I/O',1.76,19,1,'Adrienne Nader','aaron.gerlach@hotmail.com','NOT, being made entirely of cardboard.) \'All right, so far,\' said the Duck. \'Found IT,\' the Mouse.',NULL,'29',1.76,3,5.28,5.28,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(30,'Z5YKDT8FMZQ2','3100620f-98c2-48c2-b693-7693fcbdde18',3,'Google I/O',1.76,23,1,'Lourdes Hansen','crooks.camilla@yahoo.com','Though they were gardeners, or soldiers, or courtiers, or three times over to the jury, who.',NULL,'30',1.76,3,5.28,5.28,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(31,'HSF0W8C2YMAY','07837c0f-d13c-4abb-8593-3dc55aa059c9',4,'Apple WWDC',14.61,19,1,'Adrienne Nader','aaron.gerlach@hotmail.com','Pigeon went on, \'that they\'d let Dinah stop in the sun. (IF you don\'t know what a Mock Turtle.',NULL,'31',14.61,3,43.83,43.83,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(32,'UJYPVQE5FKIT','bcd22e51-eee9-48e9-aa79-135b637a6b5a',4,'Apple WWDC',14.61,27,1,'Jack Herman','oren43@gmail.com','Dormouse crossed the court, arm-in-arm with the other side of WHAT?\' thought Alice to find her way.',NULL,'32',14.61,3,43.83,43.83,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08'),(33,'WVEISITGRO7H','b585bdc1-fb6b-47b6-b35f-aad66209fb27',4,'Apple WWDC',14.61,26,1,'Ms. Alessia Schuppe MD','tskiles@kunde.com','Queen, the royal children; there were any tears. No, there were a Duck and a Canary called out.',NULL,'33',14.61,3,43.83,43.83,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:08','2025-06-10 10:46:09'),(34,'T0NUWI75IGZB','ad225178-e357-4062-ad98-1843ce842a94',4,'Apple WWDC',14.61,9,1,'Yesenia Lebsack','otillman@bosco.biz','Alice thought), and it set to work, and very soon found out that part.\' \'Well, at any rate,\' said.',NULL,'34',14.61,5,73.05,73.05,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(35,'IKCPMOY8SGYP','a30487f4-1ace-4825-ad70-95dde58a8003',4,'Apple WWDC',14.61,27,1,'Jack Herman','oren43@gmail.com','I get SOMEWHERE,\' Alice added as an explanation; \'I\'ve none of them even when they met in the.',NULL,'35',14.61,4,58.44,58.44,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(36,'J22M47YZKA8Q','a1370e8b-97f5-440e-ac5c-c66b95b43260',4,'Apple WWDC',14.61,9,1,'Yesenia Lebsack','otillman@bosco.biz','The Rabbit started violently, dropped the white kid gloves: she took courage, and went on: \'--that.',NULL,'36',14.61,4,58.44,58.44,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(37,'XI1NRXCWMGWF','d9a429ea-4197-4e02-9974-77e1ba13f3c0',4,'Apple WWDC',14.61,31,1,'Ignatius Lind','jack.lehner@ledner.com','So you see, as she could, and soon found out that the poor little thing howled so, that he had to.',NULL,'37',14.61,2,29.22,29.22,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(38,'N6PQTGDVQBBR','ef3ba3a7-6e6b-4fca-86a7-cb544fee44ba',4,'Apple WWDC',14.61,23,1,'Lourdes Hansen','crooks.camilla@yahoo.com','I needn\'t be afraid of it. She went on saying to herself, rather sharply; \'I advise you to sit.',NULL,'38',14.61,3,43.83,43.83,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(39,'TB4MANOJUZ9M','827c95bf-5a51-425d-85a3-ebf9dea91653',4,'Apple WWDC',14.61,27,1,'Jack Herman','oren43@gmail.com','THIS size: why, I should be free of them didn\'t know that Cheshire cats always grinned; in fact, I.',NULL,'39',14.61,4,58.44,58.44,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(40,'7OEA6BI5RBYY','4692e051-bc90-4d01-9ce1-150fe7cb2f33',4,'Apple WWDC',14.61,18,1,'Dr. Isaias O\'Reilly','schaefer.sunny@yahoo.com','Lizard, who seemed ready to sink into the open air. \'IF I don\'t put my arm round your waist,\' the.',NULL,'40',14.61,3,43.83,43.83,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(41,'C0VA0SOGVSY8','8f47d35d-f7a5-4d6d-810d-4ee0eeda713d',5,'AWS re:Invent',46.03,26,1,'Ms. Alessia Schuppe MD','tskiles@kunde.com','Shakespeare, in the pictures of him), while the Mock Turtle. \'Very much indeed,\' said Alice. \'Come.',NULL,'41',46.03,1,46.03,46.03,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(42,'MHAPQO0KUW2A','3b212894-d814-43f2-8ca9-26c9ca818963',5,'AWS re:Invent',46.03,23,1,'Lourdes Hansen','crooks.camilla@yahoo.com','Alice could not possibly reach it: she could see, as they were mine before. If I or she fell past.',NULL,'42',46.03,3,138.09,138.09,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(43,'XSF5SEYMA7ZZ','e2d93671-64ad-41e0-9af5-d926f35e8675',5,'AWS re:Invent',46.03,26,1,'Ms. Alessia Schuppe MD','tskiles@kunde.com','LITTLE larger, sir, if you were INSIDE, you might like to be lost: away went Alice after it, and.',NULL,'43',46.03,1,46.03,46.03,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(44,'T2HWJKGNRIUS','c3525ce2-20c9-4af9-85f5-82a3b8ee41c4',5,'AWS re:Invent',46.03,23,1,'Lourdes Hansen','crooks.camilla@yahoo.com','I mentioned before, And have grown most uncommonly fat; Yet you finished the guinea-pigs!\' thought.',NULL,'44',46.03,1,46.03,46.03,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(45,'7AENOJEMO3SE','f37dc9b5-fd50-4a9e-81eb-9372b657c883',5,'AWS re:Invent',46.03,23,1,'Lourdes Hansen','crooks.camilla@yahoo.com','And yet you incessantly stand on their slates, \'SHE doesn\'t believe there\'s an atom of meaning in.',NULL,'45',46.03,4,184.12,184.12,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09'),(46,'W9D7UXXEGRZN','7bd3849e-e13a-499e-818b-5c175f106d34',5,'AWS re:Invent',46.03,28,1,'Karl Sipes','mayer.bernie@hotmail.com','Turtle.\' These words were followed by a very grave voice, \'until all the while, till at last it.',NULL,'46',46.03,5,230.15,230.15,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(47,'KOXUSQUFNJCO','0897a2a3-507e-4161-a8a5-59c63d6dfa4b',5,'AWS re:Invent',46.03,1,1,'Micah Haag','customer@archielite.com','Alice, as she couldn\'t answer either question, it didn\'t much matter which way you have of putting.',NULL,'47',46.03,2,92.06,92.06,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(48,'IHAMMH3UIXEX','3809ab82-d97b-44e3-94db-134e53f324cc',5,'AWS re:Invent',46.03,26,1,'Ms. Alessia Schuppe MD','tskiles@kunde.com','It was opened by another footman in livery, with a trumpet in one hand, and a crash of broken.',NULL,'48',46.03,5,230.15,230.15,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(49,'9PNRSZFFGCJ1','6b40d017-ca43-43ae-a72e-a67ff3de1a46',5,'AWS re:Invent',46.03,28,1,'Karl Sipes','mayer.bernie@hotmail.com','Mock Turtle said: \'no wise fish would go anywhere without a great many teeth, so she waited. The.',NULL,'49',46.03,3,138.09,138.09,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10'),(50,'SCNZZP2I1BWI','68d00488-65a9-4bf1-a8ea-f49ad9c7ebab',5,'AWS re:Invent',46.03,28,1,'Karl Sipes','mayer.bernie@hotmail.com','The master was an old conger-eel, that used to know. Let me see--how IS it to the Hatter. \'It.',NULL,'50',46.03,1,46.03,46.03,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'CM503I238PNG','Mr. Laverna Marks DVM','ortiz.ryley@bradtke.com','0414918402','Let me see: I\'ll give them a new idea to Alice, flinging the baby joined):-- \'Wow! wow! wow!\'.',NULL,'reserved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(2,1,'U9BOPIKZKBCQ','Charity Quigley','geraldine78@hermiston.com','0529930893','I\'ve finished.\' So they began solemnly dancing round and get in at the cook till his eyes were.',NULL,'cancelled','2025-06-10 10:46:06','2025-06-10 10:46:06'),(3,2,'0JUUAZH8MQKQ','Hazle Huels','lavada34@yahoo.com','0504551704','Tell me that first, and then, if I like being that person, I\'ll come up: if not, I\'ll stay down.',NULL,'checked_in','2025-06-10 10:46:06','2025-06-10 10:46:06'),(4,2,'B91UK7XHMR3C','Rahul Reichert Sr.','tyra.hyatt@heidenreich.com','0697653848','She was close behind her, listening: so she began looking at Alice the moment how large she had.',NULL,'purchased','2025-06-10 10:46:06','2025-06-10 10:46:06'),(5,3,'6YGBMRGTFAYO','Elwyn Rogahn','sporer.ana@gmail.com','0065069786','VERY deeply with a sigh: \'he taught Laughing and Grief, they used to it in asking riddles that.',NULL,'cancelled','2025-06-10 10:46:06','2025-06-10 10:46:06'),(6,3,'XQCYXCCZDIZ2','Prof. Tomasa Roberts IV','deonte.sipes@cronin.com','0301595701','So they got thrown out to the beginning again?\' Alice ventured to remark. \'Tut, tut, child!\' said.',NULL,'checked_in','2025-06-10 10:46:06','2025-06-10 10:46:06'),(7,3,'LK6H9KLEQ9SS','Isabelle Morar','raleigh.mitchell@kuhn.com','0161516778','After these came the royal children, and everybody laughed, \'Let the jury eagerly wrote down on.',NULL,'pending','2025-06-10 10:46:06','2025-06-10 10:46:06'),(8,3,'TN2GTJAHKARQ','Arjun Osinski','dan.hackett@reichert.info','0669471401','Alice. \'Only a thimble,\' said Alice aloud, addressing nobody in particular. \'She\'d soon fetch it.',NULL,'transferred','2025-06-10 10:46:06','2025-06-10 10:46:06'),(9,3,'HNZIOZ8YZDKZ','Roosevelt Witting','michaela34@gmail.com','0876379417','Mock Turtle, who looked at Two. Two began in a very grave voice, \'until all the players, except.',NULL,'checked_in','2025-06-10 10:46:06','2025-06-10 10:46:06'),(10,3,'X3J9TCMLTO7F','Margaret Howe','hbrown@gmail.com','0392453575','Pigeon in a moment that it made no mark; but he would not allow without knowing how old it was.',NULL,'cancelled','2025-06-10 10:46:06','2025-06-10 10:46:06'),(11,4,'REC1RYUCL0SX','Cecilia Huels','ondricka.estell@gmail.com','0513098950','Hatter: and in despair she put them into a chrysalis--you will some day, you know--and then after.',NULL,'purchased','2025-06-10 10:46:06','2025-06-10 10:46:06'),(12,4,'BHMHYZAWL64U','Juana Kreiger','urban.boyer@yahoo.com','0326178013','CHORUS. \'Wow! wow! wow!\' While the Owl had the best plan.\' It sounded an excellent plan, no doubt.',NULL,'pending','2025-06-10 10:46:06','2025-06-10 10:46:06'),(13,4,'MMH99FUURW4O','Maritza Walter','kunde.manley@hotmail.com','0863966898','Alice, (she had kept a piece of bread-and-butter in the chimney close above her: then, saying to.',NULL,'purchased','2025-06-10 10:46:06','2025-06-10 10:46:06'),(14,4,'TFKCG4K42PUS','Bobby Cole','esther08@hotmail.com','0409238196','The further off from England the nearer is to find her in an encouraging tone. Alice looked down.',NULL,'refunded','2025-06-10 10:46:06','2025-06-10 10:46:06'),(15,4,'HVPL5PFQGL72','Prof. Stephan Kunze','abby89@yahoo.com','0468814821','William the Conqueror.\' (For, with all her coaxing. Hardly knowing what she was out of its mouth.',NULL,'cancelled','2025-06-10 10:46:06','2025-06-10 10:46:06'),(16,4,'ZITBMJAGCJ0Y','Jamie Metz','ulindgren@hotmail.com','0631945194','MINE.\' The Queen had never done such a nice little histories about children who had been found and.',NULL,'refunded','2025-06-10 10:46:06','2025-06-10 10:46:06'),(17,5,'Z3IPAFWCIZI2','Serenity Boehm','watsica.trace@gmail.com','0997792990','And she squeezed herself up closer to Alice\'s great surprise, the Duchess\'s voice died away, even.',NULL,'refunded','2025-06-10 10:46:06','2025-06-10 10:46:06'),(18,5,'U1K8ZVBD6HVY','Raymundo O\'Keefe','augustine77@gmail.com','0076653037','White Rabbit, jumping up and said, \'That\'s right, Five! Always lay the blame on others!\' \'YOU\'D.',NULL,'checked_in','2025-06-10 10:46:06','2025-06-10 10:46:06'),(19,5,'VWJZLVXXYAVJ','Laila Zboncak Jr.','qdenesik@luettgen.biz','0730071153','No, it\'ll never do to come yet, please your Majesty,\' the Hatter instead!\' CHAPTER VII. A Mad.',NULL,'transferred','2025-06-10 10:46:06','2025-06-10 10:46:06'),(20,6,'EIP9U3AFUFCS','Jace Kessler IV','ryan.imogene@gmail.com','0886555038','Alice, and, after waiting till she fancied she heard a little now and then; such as, \'Sure, I.',NULL,'cancelled','2025-06-10 10:46:06','2025-06-10 10:46:06'),(21,6,'YQSSYRGLNDJG','Brock Abshire','mmraz@hotmail.com','0026478515','Alice led the way, and the Gryphon replied rather crossly: \'of course you don\'t!\' the Hatter went.',NULL,'reserved','2025-06-10 10:46:06','2025-06-10 10:46:06'),(22,6,'FFQLPB2XTXIV','Tod Dickinson','claudie95@bogan.info','0584109269','Dormouse slowly opened his eyes. \'I wasn\'t asleep,\' he said in a tone of the day; and this Alice.',NULL,'cancelled','2025-06-10 10:46:06','2025-06-10 10:46:06'),(23,6,'5XXNAQZPEOGF','Prof. John Cole','cecelia82@prosacco.info','0606954190','On various pretexts they all spoke at once, while all the other end of half an hour or so there.',NULL,'pending','2025-06-10 10:46:06','2025-06-10 10:46:06'),(24,7,'RJSY8KGOHLOD','Dillon Herzog','hohara@hotmail.com','0688802987','Alice began in a low voice, \'Why the fact is, you see, because some of YOUR adventures.\' \'I could.',NULL,'transferred','2025-06-10 10:46:06','2025-06-10 10:46:06'),(25,7,'Y0VEAP9HYKZE','Dimitri Heathcote','gaylord.larissa@wisozk.com','0051325432','The Mouse only growled in reply. \'Idiot!\' said the Duchess: \'flamingoes and mustard both bite. And.',NULL,'purchased','2025-06-10 10:46:06','2025-06-10 10:46:06'),(26,8,'AE2X5SIASHBH','Dr. Elisabeth Boyle','juvenal51@yahoo.com','0483929462','I shan\'t grow any more--As it is, I can\'t quite follow it as to size,\' Alice hastily replied.',NULL,'purchased','2025-06-10 10:46:06','2025-06-10 10:46:06'),(27,8,'1HW8WGXL4HZV','Joe Moen','zwill@gibson.com','0362281270','Dormouse turned out, and, by the English, who wanted leaders, and had come to the tarts on the.',NULL,'refunded','2025-06-10 10:46:06','2025-06-10 10:46:06'),(28,9,'NWU6TCYT9AS6','Viola Kohler IV','glebsack@hotmail.com','0837504208','Alice was more hopeless than ever: she sat on, with closed eyes, and feebly stretching out one.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(29,9,'WJYXU5PHQ36L','Ike Schuppe','waino24@conn.org','0951012053','Will you, won\'t you, will you join the dance. Would not, could not, would not, could not, would.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(30,9,'4C05R0PXHAAX','Asa Fay','natasha62@yahoo.com','0323388722','Alice, \'we learned French and music.\' \'And washing?\' said the Pigeon; \'but if you\'ve seen them at.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(31,9,'KZJF8FVOXFNJ','Vito Kozey','kling.alicia@gmail.com','0446781113','SOMETHING interesting is sure to make the arches. The chief difficulty Alice found at first was.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(32,9,'XF7OOZXQHT3M','Tyrique Hudson','aubree.smitham@casper.com','0897136762','Alice. \'I\'M not a VERY unpleasant state of mind, she turned to the King, who had meanwhile been.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(33,9,'0XDMN2TDB3MQ','Morgan Lesch','tbashirian@welch.org','0589657753','Puss,\' she began, in rather a complaining tone, \'and they all looked puzzled.) \'He must have been.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(34,10,'IQY8J7OQIRNY','Vincenzo Wunsch','olson.paige@reilly.net','0649911843','THAT direction,\' the Cat remarked. \'Don\'t be impertinent,\' said the Cat: \'we\'re all mad here. I\'m.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(35,10,'FIEPXKDIEA5F','Alexandrea Schinner MD','patsy28@dare.net','0650021234','Gryphon. \'It\'s all his fancy, that: he hasn\'t got no business there, at any rate: go and take it.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(36,10,'GXFZVBPYK54S','Novella Turcotte','osinski.johnpaul@okon.com','0931011090','King eagerly, and he poured a little glass box that was trickling down his face, as long as it.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(37,10,'ICZ7CR6WC6EY','Ms. Zoey Lind','mayer.fernando@gmail.com','0295116816','I can\'t get out again. The rabbit-hole went straight on like a candle. I wonder what you\'re.',NULL,'refunded','2025-06-10 10:46:07','2025-06-10 10:46:07'),(38,10,'GWGHQJJH5MZM','Nelson Buckridge Jr.','lang.oceane@hotmail.com','0579321446','Soup! Beau--ootiful Soo--oop! Soo--oop of the March Hare: she thought it had entirely disappeared.',NULL,'checked_in','2025-06-10 10:46:07','2025-06-10 10:46:07'),(39,10,'ORWVGOTEUKHY','Zackery Hackett','upacocha@gmail.com','0825425882','Still she went on, half to herself, and once again the tiny hands were clasped upon her arm, that.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(40,11,'XJ8YDSIYDUQW','Rylee Buckridge','dkuphal@gmail.com','0807080384','But she went on. \'Would you like to be found: all she could not help thinking there MUST be more.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(41,11,'F7YXVP3A16EB','Montana Greenholt','little.valentina@hotmail.com','0508032865','IS that to be a very small cake, on which the wretched Hatter trembled so, that he had a wink of.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(42,11,'PSO4XDV0LCVH','Marquis Wisozk','alphonso.jones@gmail.com','0715054589','Caterpillar. \'Is that the Mouse to tell me the list of the sea.\' \'I couldn\'t afford to learn it.\'.',NULL,'reserved','2025-06-10 10:46:07','2025-06-10 10:46:07'),(43,12,'3MTFKGL08HY3','Noemi Waelchi','dietrich.jammie@hotmail.com','0900077018','Queen. \'Well, I never was so ordered about by mice and rabbits. I almost wish I had our Dinah.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(44,12,'YFQ7RY1BHXHO','Dr. Enos Ruecker','tdooley@schmitt.com','0647545429','Duchess, the Duchess! Oh! won\'t she be savage if I\'ve kept her waiting!\' Alice felt dreadfully.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(45,12,'DQULP96CIBYO','Dean Morissette','volkman.shyanne@weber.com','0293051730','Mock Turtle drew a long and a fan! Quick, now!\' And Alice was soon left alone. \'I wish I hadn\'t.',NULL,'refunded','2025-06-10 10:46:07','2025-06-10 10:46:07'),(46,12,'BSOZTIFYMOAJ','Kiley Goyette','senger.trystan@yahoo.com','0913300257','Queen: so she went back to the law, And argued each case with my wife; And the Eaglet bent down.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(47,13,'UQJCHCRWSKKA','Tierra Harber','qwyman@hotmail.com','0693323748','YOURS: I don\'t take this young lady to see some meaning in it,\' said Alice, a little pattering of.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(48,13,'GAKWBADTFSMK','Weston Nitzsche','hconn@hotmail.com','0414239295','And how odd the directions will look! ALICE\'S RIGHT FOOT, ESQ. HEARTHRUG, NEAR THE FENDER, (WITH.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(49,14,'IY0W5BKKAPD2','Amber Blanda','cbruen@gmail.com','0338627467','Seven flung down his brush, and had to kneel down on one knee. \'I\'m a poor man, your Majesty,\'.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(50,14,'GDZW5Y0YL5T1','Diana Bauch','wyost@yahoo.com','0099634819','Good-bye, feet!\' (for when she had plenty of time as she could. The next witness was the Hatter.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(51,15,'J3L0BSB0OMCD','Alvah Veum','anna51@west.net','0032913275','White Rabbit: it was addressed to the table for it, he was in the shade: however, the moment how.',NULL,'checked_in','2025-06-10 10:46:07','2025-06-10 10:46:07'),(52,15,'OUZKHQZMG95P','Rosemary Kassulke','botsford.karelle@hotmail.com','0272327548','Pigeon, but in a moment to be full of tears, but said nothing. \'This here young lady,\' said the.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(53,15,'YJERYUUP9IDC','Jovan Dicki','vchristiansen@friesen.org','0489075576','Father William replied to his son, \'I feared it might belong to one of the way to change the.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(54,15,'CQZTCAVNJBPS','Mr. Madison Walker Jr.','yhessel@hammes.com','0912179618','I\'m sure I have none, Why, I do it again and again.\' \'You are old,\' said the King, the Queen.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(55,15,'ROMPI7ZMUFRM','Viola Medhurst','amira18@yahoo.com','0791733205','Alice went on, turning to Alice a little nervous about it while the Mock Turtle said: \'no wise.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(56,15,'RI7XK98CUQXA','Deja Schiller','christian.volkman@sporer.com','0494179934','After a minute or two she walked down the chimney!\' \'Oh! So Bill\'s got the other--Bill! fetch it.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(57,16,'GVHYMJSYMFFZ','Mr. Larue Feest','grady.larson@hotmail.com','0628494650','I do,\' said Alice hastily; \'but I\'m not looking for it, you know.\' \'And what are YOUR shoes done.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(58,16,'9CYKWOPJ6JSV','Carter Cassin','ygreenholt@gulgowski.biz','0082958534','Lobster Quadrille?\' the Gryphon never learnt it.\' \'Hadn\'t time,\' said the King, the Queen.',NULL,'refunded','2025-06-10 10:46:07','2025-06-10 10:46:07'),(59,16,'HBACCNVZRWMR','Virgie Smitham','lowe.pierre@gmail.com','0065453170','I shall fall right THROUGH the earth! How funny it\'ll seem, sending presents to one\'s own feet!.',NULL,'refunded','2025-06-10 10:46:07','2025-06-10 10:46:07'),(60,16,'XFK2Z02QQQBK','Mr. Gayle Klocko IV','jgreenfelder@casper.com','0495249242','Dodo had paused as if she could have been ill.\' \'So they were,\' said the Cat, as soon as look at.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(61,17,'2COKCEEEEZF7','Harmony Senger IV','maudie.wolf@gmail.com','0608388508','King. \'I can\'t explain MYSELF, I\'m afraid, sir\' said Alice, a good many voices all talking.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(62,17,'YCVIBSO4JSKC','Prof. Bo Kulas DVM','fadel.rory@gmail.com','0496092541','Hatter. He came in sight of the song, she kept on puzzling about it while the rest were quite.',NULL,'checked_in','2025-06-10 10:46:07','2025-06-10 10:46:07'),(63,17,'YBMUX6MKZZWU','Mrs. Felipa Haag','ullrich.kevin@jenkins.com','0661913894','Lory positively refused to tell him. \'A nice muddle their slates\'ll be in a confused way, \'Prizes!.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(64,18,'OYMCCP2OD87H','Dr. Obie Price','stacey40@mueller.com','0584537497','I don\'t care which happens!\' She ate a little scream, half of them--and it belongs to the table to.',NULL,'refunded','2025-06-10 10:46:07','2025-06-10 10:46:07'),(65,18,'LOSBXGFSGT6T','Mrs. Yessenia Kunze','kiara66@gmail.com','0678973717','Alice did not see anything that looked like the Mock Turtle went on for some time busily writing.',NULL,'checked_in','2025-06-10 10:46:07','2025-06-10 10:46:07'),(66,18,'3CFCDZQVXRPR','Ottilie Littel','schulist.carmel@yahoo.com','0942116013','Seaography: then Drawling--the Drawling-master was an old crab, HE was.\' \'I never thought about.',NULL,'checked_in','2025-06-10 10:46:07','2025-06-10 10:46:07'),(67,19,'KFT5FTLWNXQ5','Jarod Runolfsson DDS','ecasper@corkery.org','0264617885','Majesty?\' he asked. \'Begin at the Cat\'s head with great emphasis, looking hard at Alice the moment.',NULL,'transferred','2025-06-10 10:46:07','2025-06-10 10:46:07'),(68,19,'KVNDM3JS5ZDZ','Dannie Hackett','igutkowski@gmail.com','0909817891','Forty-two. ALL PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at it, and kept.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(69,19,'RCOOBOQE4RQQ','Sherwood Stracke','rutherford.sandrine@simonis.com','0613168222','Mouse, sharply and very soon found herself at last it unfolded its arms, took the place of the.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(70,19,'DPTYXSBOW9Q7','Mrs. Lavina DuBuque','mohr.cristian@strosin.com','0639763035','And he added in a tone of great surprise. \'Of course twinkling begins with a growl, And concluded.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(71,19,'IWVLQTXIEGMC','Lloyd Farrell','haleigh60@torp.info','0197547166','Queen. \'Sentence first--verdict afterwards.\' \'Stuff and nonsense!\' said Alice loudly. \'The idea of.',NULL,'refunded','2025-06-10 10:46:07','2025-06-10 10:46:07'),(72,20,'J4B3TUQ0EEBZ','Celia Donnelly III','kpfeffer@orn.org','0062759601','Gryphon, \'that they WOULD not remember ever having seen such a curious feeling!\' said Alice; \'all.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(73,20,'CHS5QBVTYRMT','Shanel Feest II','hilpert.carlee@conn.com','0071857938','Stole the Tarts? The King laid his hand upon her face. \'Very,\' said Alice: \'I don\'t much care.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(74,20,'UG6IJNVLSJRK','Mr. Blake Bode','brody22@yahoo.com','0991355476','Shark, But, when the White Rabbit hurried by--the frightened Mouse splashed his way through the.',NULL,'pending','2025-06-10 10:46:07','2025-06-10 10:46:07'),(75,20,'GIIU6T79HEAQ','Glenda Ankunding III','johnson56@watsica.com','0686208749','VERY tired of being all alone here!\' As she said these words her foot slipped, and in another.',NULL,'purchased','2025-06-10 10:46:07','2025-06-10 10:46:07'),(76,20,'NGNQVBD5K9YL','Rosalinda Stamm','mante.harmon@cummings.net','0595936048','Seven flung down his face, as long as it spoke (it was Bill, the Lizard) could not even room for.',NULL,'cancelled','2025-06-10 10:46:07','2025-06-10 10:46:07'),(77,20,'SHESXMTPB4J2','Olen Hackett','bboyle@hotmail.com','0088355694','King, \'that saves a world of trouble, you know, with oh, such long ringlets, and mine doesn\'t go.',NULL,'refunded','2025-06-10 10:46:07','2025-06-10 10:46:07'),(78,21,'PGCGGHRESN7H','Darryl Feest','jovany84@krajcik.com','0163971425','Alice; \'but when you throw them, and all would change to dull reality--the grass would be a.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(79,21,'QTSCDCD03ZC9','Johnathan Weber','fmante@waelchi.com','0142275180','The great question is, Who in the pool as it happens; and if the Mock Turtle interrupted, \'if you.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(80,21,'O4ZFA9XQQUVZ','Cade Hansen Jr.','mrogahn@pfeffer.com','0298551566','Forty-two. ALL PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at her, and the.',NULL,'reserved','2025-06-10 10:46:08','2025-06-10 10:46:08'),(81,21,'SUDBAEPT3BPT','Donnie Zieme','ttreutel@hotmail.com','0746818986','She stretched herself up and repeat something now. Tell her to speak first, \'why your cat grins.',NULL,'transferred','2025-06-10 10:46:08','2025-06-10 10:46:08'),(82,21,'ZBHFZUDTS283','Mr. Enid Goyette V','wolff.wilfred@reynolds.biz','0823000001','Even the Duchess asked, with another dig of her head in the chimney as she spoke; \'either you or.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(83,22,'GENRM96J4JQJ','Jermey Donnelly','satterfield.baby@hotmail.com','0288628301','Pigeon, raising its voice to its feet, \'I move that the hedgehog to, and, as there seemed to Alice.',NULL,'transferred','2025-06-10 10:46:08','2025-06-10 10:46:08'),(84,22,'M8CSQZRP1LOG','Effie Altenwerth Jr.','dell76@hotmail.com','0134871102','I\'ve seen that done,\' thought Alice. \'I\'m glad they don\'t seem to be\"--or if you\'d rather not.\'.',NULL,'reserved','2025-06-10 10:46:08','2025-06-10 10:46:08'),(85,22,'S0APQKPCKR22','Nicolette Herzog','beier.robyn@little.com','0062418911','SOMETHING interesting is sure to do it?\' \'In my youth,\' said the Gryphon. \'Turn a somersault in.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(86,22,'46NIIJ82AQ8L','Dr. Anastasia Weber','jameson.toy@simonis.com','0301044478','I\'d been the right thing to eat or drink under the sea,\' the Gryphon repeated impatiently: \'it.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(87,23,'H6MQXHY80DTX','Dustin Berge DDS','justine06@lubowitz.com','0253941723','Who for such dainties would not give all else for two reasons. First, because I\'m on the other.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(88,23,'JJQSA8DPELAK','Elizabeth Zboncak','ezra82@gmail.com','0634168497','Then she went on without attending to her, And mentioned me to introduce it.\' \'I don\'t think--\'.',NULL,'cancelled','2025-06-10 10:46:08','2025-06-10 10:46:08'),(89,23,'UX047ZYCOGXA','Josianne Wisoky','destin.ziemann@lubowitz.com','0618716217','Father William replied to his son, \'I feared it might not escape again, and she looked back once.',NULL,'cancelled','2025-06-10 10:46:08','2025-06-10 10:46:08'),(90,23,'7XCLL8IN8T2I','Emilie Heller DDS','bpurdy@shanahan.net','0770540057','I beg your pardon!\' cried Alice again, in a soothing tone: \'don\'t be angry about it. And yet I.',NULL,'reserved','2025-06-10 10:46:08','2025-06-10 10:46:08'),(91,23,'OMLGAQ0DXMTA','Vena Hermann I','tharvey@pfeffer.com','0526672184','DON\'T know,\' said Alice, whose thoughts were still running on the second time round, she came.',NULL,'checked_in','2025-06-10 10:46:08','2025-06-10 10:46:08'),(92,24,'DEQIYZL8OPOC','Oleta Brakus','karson.harber@gmail.com','0873583823','Wonderland, though she looked down at her own courage. \'It\'s no use in talking to herself.',NULL,'purchased','2025-06-10 10:46:08','2025-06-10 10:46:08'),(93,24,'XV0KPLXECBSM','Dr. Emile Russel','ondricka.joey@gmail.com','0346485556','Gryphon at the Hatter, \'I cut some more of the jurymen. \'It isn\'t a bird,\' Alice remarked. \'Oh.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(94,24,'XUUEPXRS7QQJ','Missouri Kiehn Jr.','arlene.fahey@oconner.biz','0681402347','Mock Turtle, \'Drive on, old fellow! Don\'t be all day about it!\' and he went on in a hurry: a large.',NULL,'reserved','2025-06-10 10:46:08','2025-06-10 10:46:08'),(95,25,'KCIHHBRSAAU6','Kirstin Windler','adelia45@yahoo.com','0844854461','Alice was not a mile high,\' said Alice. \'Nothing WHATEVER?\' persisted the King. \'It began with the.',NULL,'cancelled','2025-06-10 10:46:08','2025-06-10 10:46:08'),(96,25,'5FCANDAQHOZV','Antonina Mueller','eoconner@rippin.com','0933502251','King, the Queen, pointing to the Knave of Hearts, and I never knew so much contradicted in her.',NULL,'purchased','2025-06-10 10:46:08','2025-06-10 10:46:08'),(97,25,'UPFOAFYCP6YZ','Miss Gerry O\'Keefe III','carolina69@barrows.org','0872207070','Mock Turtle. \'And how many miles I\'ve fallen by this time?\' she said to itself \'The Duchess! The.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(98,26,'RCNIJZ0BWOB9','Giuseppe Flatley','weldon.vandervort@fadel.info','0177620105','Gryphon, \'she wants for to know what to say which), and they went on to her usual height. It was.',NULL,'checked_in','2025-06-10 10:46:08','2025-06-10 10:46:08'),(99,26,'U6WP2QJO8OMW','Mrs. Peggie Legros III','witting.ruby@gmail.com','0240886600','I\'ve fallen by this time, and was going a journey, I should think it so yet,\' said Alice; \'it\'s.',NULL,'purchased','2025-06-10 10:46:08','2025-06-10 10:46:08'),(100,26,'HF0ZBYC1NMME','Vella Hodkiewicz','beryl96@rau.biz','0303049733','Duchess, who seemed ready to agree to everything that was trickling down his brush, and had been.',NULL,'transferred','2025-06-10 10:46:08','2025-06-10 10:46:08'),(101,27,'L6VMHUJTEKEX','Dr. Etha Gerlach Jr.','champlin.mandy@yahoo.com','0648543661','Rome, and Rome--no, THAT\'S all wrong, I\'m certain! I must be a great hurry; \'this paper has just.',NULL,'checked_in','2025-06-10 10:46:08','2025-06-10 10:46:08'),(102,27,'XPLKPDAPT2JY','Mrs. May Wisozk','quigley.kiara@gmail.com','0876380539','I got up this morning, but I shall have to turn into a pig, and she walked on in a tone of this.',NULL,'checked_in','2025-06-10 10:46:08','2025-06-10 10:46:08'),(103,27,'LIGMHGDWPPYD','Prof. Noemy Barrows','kgrant@yahoo.com','0640369627','I do it again and again.\' \'You are old,\' said the Mock Turtle sighed deeply, and drew the back of.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(104,27,'2STRSPAFMGS5','Enrique Cole DDS','jacobi.regan@ferry.com','0318151521','William and offer him the crown. William\'s conduct at first she thought it over here,\' said the.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(105,27,'JMDDWOYADQUS','Marquise Beier','johns.harley@gmail.com','0044145853','Some of the legs of the other arm curled round her head. \'If I eat one of the March Hare. \'Yes.',NULL,'purchased','2025-06-10 10:46:08','2025-06-10 10:46:08'),(106,27,'O4QXNXKN5UID','Griffin Yost MD','danial49@douglas.com','0197041172','M--\' \'Why with an air of great relief. \'Now at OURS they had been looking at them with one eye.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(107,28,'PQHI9MNCU3XK','Mr. Jon Heidenreich PhD','mitchell.boyer@beahan.com','0266028634','Frog-Footman repeated, in the wind, and the roof of the conversation. Alice replied, so eagerly.',NULL,'reserved','2025-06-10 10:46:08','2025-06-10 10:46:08'),(108,28,'EOBDGGE1SLEY','Prof. Dorcas Kutch','kaylee76@gmail.com','0170403670','Majesty,\' said Alice timidly. \'Would you tell me,\' said Alice, \'but I haven\'t had a wink of sleep.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(109,28,'VEATOF3ZFOIG','Albert Kassulke','kennith.lubowitz@hotmail.com','0672235804','Gryphon. \'Turn a somersault in the last concert!\' on which the words have got into the loveliest.',NULL,'cancelled','2025-06-10 10:46:08','2025-06-10 10:46:08'),(110,29,'KETEFXTRCUAN','Chanelle Homenick PhD','lynn34@yahoo.com','0445496143','And beat him when he sneezes: He only does it to annoy, Because he knows it teases.\' CHORUS. (In.',NULL,'purchased','2025-06-10 10:46:08','2025-06-10 10:46:08'),(111,29,'0HKQPY2Y46YU','Nora Kuhn','rippin.hulda@jaskolski.info','0624306670','At last the Mouse, turning to Alice, they all spoke at once, she found this a very deep well.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(112,29,'AFXBMH3B7BXX','Kailee Bartoletti Sr.','pollich.duncan@hotmail.com','0147463637','ARE OLD, FATHER WILLIAM,\' to the jury, in a natural way again. \'I should have liked teaching it.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(113,29,'QS5FK9NQFGOS','Dr. Annamarie Ullrich','shayna23@berge.com','0179865609','Sir, With no jury or judge, would be quite as much as she went down on her face in some alarm.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(114,30,'FPIA0NCGJZUB','Miracle Bayer PhD','mayra.lynch@rohan.com','0354665950','Alice did not like to drop the jar for fear of killing somebody, so managed to swallow a morsel of.',NULL,'checked_in','2025-06-10 10:46:08','2025-06-10 10:46:08'),(115,30,'A1QSIVAOG79U','Shana Olson','kaylah.zboncak@heller.com','0219075232','Lobster Quadrille, that she ought not to be listening, so she went on so long since she had hoped).',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(116,30,'ONHMHNYPJBC1','Miss Retha Collier MD','delilah.goldner@haag.net','0187335770','Pat, what\'s that in about half no time! Take your choice!\' The Duchess took no notice of her.',NULL,'refunded','2025-06-10 10:46:08','2025-06-10 10:46:08'),(117,30,'ZALNSEIGAVPI','Jo Shanahan','kara.cassin@yahoo.com','0668043410','The question is, what?\' The great question certainly was, what? Alice looked all round her head.',NULL,'checked_in','2025-06-10 10:46:08','2025-06-10 10:46:08'),(118,31,'SOJCYEZF4A63','Jess Moore','evie.heller@yahoo.com','0701182562','The moment Alice felt that she never knew so much about a thousand times as large as himself, and.',NULL,'purchased','2025-06-10 10:46:08','2025-06-10 10:46:08'),(119,31,'MFZUU73ZFB9O','Mr. Barney Grady','janelle.boyer@hotmail.com','0315169389','Alice thought this a good deal until she had put the hookah into its face to see the earth takes.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(120,31,'DQTP7BKOQIZH','Louvenia Streich','heidenreich.makenzie@wisozk.org','0923025464','The first witness was the first really clever thing the King very decidedly, and the sound of many.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(121,31,'IHJAHG45EPMO','Ms. Shanelle Gislason DVM','flo.spinka@yahoo.com','0804374255','Gryphon: and it set to work throwing everything within her reach at the March Hare. \'It was the.',NULL,'pending','2025-06-10 10:46:08','2025-06-10 10:46:08'),(122,32,'8BR77F13JX35','Mylene Turner I','zetta.weber@yahoo.com','0290286489','Alice: \'--where\'s the Duchess?\' \'Hush! Hush!\' said the youth, \'one would hardly suppose That your.',NULL,'checked_in','2025-06-10 10:46:08','2025-06-10 10:46:08'),(123,32,'ISD3MQBNVLHS','Alycia Purdy','vschneider@yahoo.com','0680168375','The cook threw a frying-pan after her as she ran. \'How surprised he\'ll be when he sneezes; For he.',NULL,'reserved','2025-06-10 10:46:08','2025-06-10 10:46:08'),(124,32,'PBYYCF1APIJB','Dr. Adolfo Pfannerstill','spencer.kayden@walker.net','0470817863','Gryphon. \'It\'s all his fancy, that: they never executes nobody, you know. Come on!\' So they sat.',NULL,'purchased','2025-06-10 10:46:08','2025-06-10 10:46:08'),(125,32,'ZMGOYG7VN71H','Jay Beer Sr.','gibson.alexzander@hotmail.com','0931201865','Pigeon; \'but I know all the time he was obliged to write with one of the house opened, and a large.',NULL,'transferred','2025-06-10 10:46:08','2025-06-10 10:46:08'),(126,33,'LKWMS63A9JPA','Ms. Clotilde Hahn','runolfsdottir.nicola@gulgowski.com','0222712025','I should be free of them say, \'Look out now, Five! Don\'t go splashing paint over me like that!\' By.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(127,33,'LZW9GSQWMES2','Prof. Marques Stehr','aditya21@lindgren.com','0738965343','Christmas.\' And she began again. \'I should like to have changed since her swim in the kitchen that.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(128,33,'2Q6S1LSUIOEO','Jackie Daugherty Jr.','luciano46@hane.net','0493519387','She is such a long silence after this, and she felt that it was all very well to introduce some.',NULL,'pending','2025-06-10 10:46:09','2025-06-10 10:46:09'),(129,33,'BC6XLR1OCDMY','Dr. Kaylah Brakus I','icie39@yahoo.com','0038690256','ARE OLD, FATHER WILLIAM,\' to the rose-tree, she went on, \'that they\'d let Dinah stop in the.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(130,34,'OHW3FE9LVCAK','Thaddeus Jacobs MD','keith60@hotmail.com','0543128618','WHAT? The other guests had taken his watch out of sight: \'but it seems to be full of tears, \'I do.',NULL,'pending','2025-06-10 10:46:09','2025-06-10 10:46:09'),(131,34,'JSDCNTFEX0ZN','Magnus Wolf','carlotta50@koelpin.info','0387491683','King eagerly, and he went on, \'if you don\'t even know what a Gryphon is, look at me like that!\' By.',NULL,'checked_in','2025-06-10 10:46:09','2025-06-10 10:46:09'),(132,34,'VL6ZBHJQJY4B','Prof. Forrest Wolf Jr.','monty79@yahoo.com','0074580879','YOU sing,\' said the Hatter. He had been wandering, when a sharp hiss made her draw back in a.',NULL,'pending','2025-06-10 10:46:09','2025-06-10 10:46:09'),(133,34,'ZGKZ08QBG0VU','Della Mohr','jarrett12@murazik.org','0663391766','Majesty?\' he asked. \'Begin at the righthand bit again, and looking anxiously about her. \'Oh, do.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(134,34,'3UVRAQCOZ5RT','Rhea VonRueden','ngutkowski@lehner.com','0330405208','I don\'t want to stay with it as well wait, as she spoke. Alice did not venture to go down the.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(135,34,'6WXOE36HZLTB','Kimberly Pagac','meda91@emard.com','0382971667','I can guess that,\' she added in a natural way. \'I thought it must make me grow large again, for.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(136,35,'NTXMPTFVN2EQ','Delpha Lueilwitz','billie47@schuppe.com','0246978658','Stop this moment, I tell you!\' said Alice. \'What IS a long and a scroll of parchment in the last.',NULL,'cancelled','2025-06-10 10:46:09','2025-06-10 10:46:09'),(137,35,'WPD8JUN8Y0FZ','Zelda Witting IV','yabbott@gmail.com','0141645558','Alice looked all round the court with a lobster as a lark, And will talk in contemptuous tones of.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(138,35,'B4FGZXNUQR0H','Prof. Norval Legros','lwaelchi@mcdermott.info','0525588481','Wonderland, though she felt sure it would be the right word) \'--but I shall see it trot away.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(139,35,'LGTPR8MYCUQM','Ms. Arvilla Hartmann PhD','candice56@streich.com','0887767754','Caterpillar\'s making such VERY short remarks, and she hastily dried her eyes filled with cupboards.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(140,35,'VBDCAZNDV86F','Shaylee Rosenbaum','oledner@sipes.com','0677027471','Then followed the Knave was standing before them, in chains, with a great deal too flustered to.',NULL,'cancelled','2025-06-10 10:46:09','2025-06-10 10:46:09'),(141,36,'8VC6KDGIN63A','Mandy Barton','armand.bauch@kilback.com','0358126836','Come on!\' So they sat down with wonder at the sides of it; and as it was too much pepper in my.',NULL,'cancelled','2025-06-10 10:46:09','2025-06-10 10:46:09'),(142,36,'KI68FHFLFWPE','Birdie Marvin','marianna74@gmail.com','0225930569','Alice, and she jumped up and down, and was gone in a melancholy air, and, after folding his arms.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(143,36,'RV8JY1DDK5GB','Aleen Schaefer V','ward77@hotmail.com','0694030380','However, she did not look at it!\' This speech caused a remarkable sensation among the leaves.',NULL,'cancelled','2025-06-10 10:46:09','2025-06-10 10:46:09'),(144,36,'OTFVNBIOZWZ3','Friedrich Barton','christiansen.rickey@mraz.info','0431691735','The Mouse only shook its head down, and was coming to, but it did not venture to ask his neighbour.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(145,36,'N8TI8QQNFG1E','Osvaldo Weissnat','allan.huels@mohr.com','0550217168','Alice thought), and it was good practice to say \'I once tasted--\' but checked herself hastily. \'I.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(146,37,'HMIMK3RFC8CN','Dr. Desmond Medhurst','bert20@herman.info','0255125003','No, it\'ll never do to hold it. As soon as the rest of it appeared. \'I don\'t even know what they\'re.',NULL,'checked_in','2025-06-10 10:46:09','2025-06-10 10:46:09'),(147,37,'9XARQKN1MTTT','Taryn Jenkins','brandy.keebler@reichel.com','0974018102','William and offer him the crown. William\'s conduct at first she would manage it. \'They must go by.',NULL,'checked_in','2025-06-10 10:46:09','2025-06-10 10:46:09'),(148,37,'N4YURJB9JIQ0','Myrtie Ratke','wava89@ratke.info','0984989177','Hatter. This piece of rudeness was more hopeless than ever: she sat down with one of them hit her.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(149,38,'O4QN7LZIHX8G','Mrs. Isabelle Cole','borer.rita@hotmail.com','0346503268','Latin Grammar, \'A mouse--of a mouse--to a mouse--a mouse--O mouse!\') The Mouse did not like to.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(150,38,'ZMKBIDBWNHZ3','Trystan Boyer','ada.paucek@gmail.com','0615533836','M?\' said Alice. \'I\'ve tried every way, and nothing seems to grin, How neatly spread his claws, And.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(151,38,'FUWL66RSWAHO','Aubree Ratke','windler.brayan@gmail.com','0784613633','And the Gryphon went on, taking first one side and up the other, trying every door, she found that.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(152,38,'HJXWQYMKHPZI','Keeley Koss','ollie.willms@gmail.com','0044799946','William the Conqueror.\' (For, with all speed back to finish his story. CHAPTER IV. The Rabbit.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(153,39,'RBZIBOBEIWCF','Adonis Becker','dondricka@funk.com','0481343542','I was thinking I should think!\' (Dinah was the first to break the silence. \'What day of the bill.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(154,39,'FYFNN0XIRG1K','Dr. Hazle Thiel DVM','roslyn68@gmail.com','0163235291','Alice, feeling very glad to do that,\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\'.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(155,39,'FYNOY04FOIH4','Gaylord Dicki PhD','cordia.kulas@baumbach.biz','0147524829','VERY wide, but she could not think of what sort it was) scratching and scrambling about in a.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(156,39,'R7DRR9VF59LV','Mr. Vincenzo Heidenreich DDS','yost.tillman@hotmail.com','0812914681','King, with an M, such as mouse-traps, and the arm that was linked into hers began to cry again.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(157,39,'8P0R1ZNII9YK','Mr. Marcelo Stracke','harrison.hauck@yahoo.com','0360265231','Let this be a footman in livery came running out of breath, and said \'No, never\') \'--so you can.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(158,40,'MNSONWCO9AJF','Nya Kemmer','cbashirian@braun.com','0391792927','Lory. Alice replied very gravely. \'What else had you to learn?\' \'Well, there was not going to.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(159,40,'YTOQQNFTKXAX','Mr. Wilford Feeney Sr.','hodkiewicz.devon@bernhard.com','0885583183','Majesty means, of course,\' said the Rabbit say to itself, \'Oh dear! Oh dear! I wish you were down.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(160,40,'82CDBT7CXWWD','Miss Princess Boehm DDS','kelly.marvin@yahoo.com','0543947658','Mock Turtle yet?\' \'No,\' said the Duchess, \'as pigs have to fly; and the words came very queer to.',NULL,'checked_in','2025-06-10 10:46:09','2025-06-10 10:46:09'),(161,40,'LQXBI86IVZUG','Dolly Reynolds','rogahn.milford@gmail.com','0957273523','Mock Turtle\'s heavy sobs. Lastly, she pictured to herself that perhaps it was all dark overhead.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(162,41,'XVBDULQUBOTD','Darian Shanahan','conroy.sydney@corwin.net','0169187681','Footman. \'That\'s the first figure!\' said the Pigeon; \'but I know all the while, till at last.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(163,41,'TPFS5R2LSF0G','Loyal Zieme','xkuvalis@harris.net','0265996496','The Cat only grinned when it saw Alice. It looked good-natured, she thought: still it had grown in.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(164,42,'4ATCGQMOCMUL','Ms. Antonette Cormier IV','clyde.watsica@yahoo.com','0697760083','Turtle.\' These words were followed by a very short time the Queen said--\' \'Get to your little boy.',NULL,'refunded','2025-06-10 10:46:09','2025-06-10 10:46:09'),(165,42,'VQS0UGN1HG9Q','Veda Lindgren III','wilfrid87@luettgen.biz','0914167411','Lizard\'s slate-pencil, and the constant heavy sobbing of the court. (As that is rather a handsome.',NULL,'pending','2025-06-10 10:46:09','2025-06-10 10:46:09'),(166,42,'HFMVLSZO33UI','Anika Dietrich IV','sophie.haley@gmail.com','0450986384','At last the Caterpillar took the hookah into its face in her pocket) till she was beginning to.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(167,42,'HEL4MMOHMZED','Dangelo Kutch V','gislason.valentine@yahoo.com','0589876867','I\'ve finished.\' So they went on again:-- \'I didn\'t mean it!\' pleaded poor Alice began to repeat.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(168,43,'D0F35MDG4KB0','Evalyn Smitham','trycia99@yahoo.com','0610070872','Let me see: that would be only rustling in the pool, \'and she sits purring so nicely by the.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(169,43,'LMXHUN0XHYQW','Kameron Feeney','kaci.raynor@paucek.com','0968922258','She was moving them about as it settled down again into its mouth and yawned once or twice, half.',NULL,'reserved','2025-06-10 10:46:09','2025-06-10 10:46:09'),(170,44,'N8KVKO4NKS2G','Jo Walker','moshe.steuber@gmail.com','0720218169','Let me think: was I the same as they were all turning into little cakes as they came nearer, Alice.',NULL,'checked_in','2025-06-10 10:46:09','2025-06-10 10:46:09'),(171,44,'KFCMUNVG5YGU','Dr. Vincenzo Murazik','morissette.berniece@yahoo.com','0915695828','Queen left off, quite out of his Normans--\" How are you getting on?\' said the Duchess.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(172,45,'PV9YM4FKADID','Edison Towne','okeefe.dortha@yahoo.com','0569259574','Mock Turtle, capering wildly about. \'Change lobsters again!\' yelled the Gryphon answered, very.',NULL,'checked_in','2025-06-10 10:46:09','2025-06-10 10:46:09'),(173,45,'HF0SINXBANBH','Jackson Reinger','veum.myah@effertz.info','0883506270','So they got settled down in a great letter, nearly as she could not stand, and she hurried out of.',NULL,'transferred','2025-06-10 10:46:09','2025-06-10 10:46:09'),(174,45,'B2THRK8QYCGB','Misael McKenzie','heidi94@boyer.biz','0740493476','White Rabbit read out, at the top of it. She stretched herself up closer to Alice\'s great.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(175,45,'FPGBZNOAHMMA','Anastasia Christiansen','dane.yost@yahoo.com','0210883615','Alice quite jumped; but she saw maps and pictures hung upon pegs. She took down a good deal until.',NULL,'checked_in','2025-06-10 10:46:09','2025-06-10 10:46:09'),(176,45,'JDMLA56Q2DR8','Miss Tressie Donnelly','camden40@pfannerstill.biz','0680259022','I know!\' exclaimed Alice, who felt ready to ask the question?\' said the Queen, the royal children.',NULL,'purchased','2025-06-10 10:46:09','2025-06-10 10:46:09'),(177,46,'GWSSRFAXWFRX','Herminio Pagac','pharber@gmail.com','0064219807','XII. Alice\'s Evidence \'Here!\' cried Alice, jumping up in spite of all her coaxing. Hardly knowing.',NULL,'pending','2025-06-10 10:46:10','2025-06-10 10:46:10'),(178,46,'8LZWY6UGCAOV','Susana Maggio','sonya35@gmail.com','0229373702','Ann! Mary Ann!\' said the Dormouse, without considering at all like the look of things at all, as.',NULL,'cancelled','2025-06-10 10:46:10','2025-06-10 10:46:10'),(179,46,'ZRJIZQPN0NZ3','Khalid Lakin','bailey.brianne@sanford.biz','0664443034','Tortoise--\' \'Why did you manage to do it! Oh dear! I\'d nearly forgotten that I\'ve got to do,\' said.',NULL,'refunded','2025-06-10 10:46:10','2025-06-10 10:46:10'),(180,46,'MUURKDUP0WS2','Mr. Geovany Miller','lmccullough@kautzer.com','0626999428','I don\'t want to get to,\' said the Mock Turtle sighed deeply, and drew the back of one flapper.',NULL,'transferred','2025-06-10 10:46:10','2025-06-10 10:46:10'),(181,46,'JB8OXXRN3FEE','Asia Vandervort','klocko.garrison@hotmail.com','0921690485','Alice knew it was an old conger-eel, that used to it in with the name of nearly everything there.',NULL,'reserved','2025-06-10 10:46:10','2025-06-10 10:46:10'),(182,46,'HXELRK0NG1JU','Ralph Smitham','ksimonis@hotmail.com','0538018208','Queen. First came ten soldiers carrying clubs; these were all writing very busily on slates. \'What.',NULL,'transferred','2025-06-10 10:46:10','2025-06-10 10:46:10'),(183,47,'WB4NA4VSCCD1','Keven Witting','ustroman@gmail.com','0820587009','THAT in a very pretty dance,\' said Alice hastily; \'but I\'m not myself, you see.\' \'I don\'t know.',NULL,'pending','2025-06-10 10:46:10','2025-06-10 10:46:10'),(184,47,'U8AZFEA8BUAN','Casimir Zboncak','jasper.oberbrunner@yahoo.com','0803381025','Lory, as soon as there was no label this time the Queen merely remarking as it can talk: at any.',NULL,'reserved','2025-06-10 10:46:10','2025-06-10 10:46:10'),(185,47,'WZ5EVT4ZFMHA','Ashley Ebert','ryan.roscoe@shields.com','0408075851','I\'m Mabel, I\'ll stay down here! It\'ll be no use denying it. I suppose Dinah\'ll be sending me on.',NULL,'reserved','2025-06-10 10:46:10','2025-06-10 10:46:10'),(186,48,'ASPEKQWCJBA2','Mr. Winston Bode V','kovacek.macie@mosciski.com','0357470990','THESE?\' said the King. The next thing is, to get through was more hopeless than ever: she sat on.',NULL,'checked_in','2025-06-10 10:46:10','2025-06-10 10:46:10'),(187,48,'SEHMGAV02WHR','Hal Beatty','marisa32@carter.biz','0654294865','I used to it in with a great letter, nearly as she had hurt the poor child, \'for I can\'t get out.',NULL,'transferred','2025-06-10 10:46:10','2025-06-10 10:46:10'),(188,48,'SM3PZC4XLC8L','Estrella Cormier','egrimes@stark.com','0689676020','Mabel, for I know THAT well enough; and what does it to her chin upon Alice\'s shoulder, and it set.',NULL,'purchased','2025-06-10 10:46:10','2025-06-10 10:46:10'),(189,48,'CSZV8EBOAV9A','Dr. Wilfred Cummerata DVM','sabrina.douglas@gmail.com','0410257001','Alice had no very clear notion how long ago anything had happened.) So she began shrinking.',NULL,'reserved','2025-06-10 10:46:10','2025-06-10 10:46:10'),(190,48,'UJJKZ3BU8EZP','Luna Schroeder','betsy95@mante.net','0403045096','Mock Turtle said: \'no wise fish would go through,\' thought poor Alice, \'when one wasn\'t always.',NULL,'cancelled','2025-06-10 10:46:10','2025-06-10 10:46:10'),(191,48,'XW53XFYQ1BQO','Billie Predovic','deja60@barton.org','0011105925','Alice had not a moment to think that there was the matter with it. There could be NO mistake about.',NULL,'pending','2025-06-10 10:46:10','2025-06-10 10:46:10'),(192,49,'BYRVZU6BCXCG','Hope Hamill','meaghan.turcotte@yahoo.com','0818530902','Alice. \'Then it ought to have it explained,\' said the Hatter continued, \'in this way:-- \"Up above.',NULL,'cancelled','2025-06-10 10:46:10','2025-06-10 10:46:10'),(193,49,'AAOJLHAENSWJ','Ally Hirthe','block.peyton@hotmail.com','0579030100','I THINK,\' said Alice. \'That\'s the first really clever thing the King said gravely, \'and go on in.',NULL,'refunded','2025-06-10 10:46:10','2025-06-10 10:46:10'),(194,49,'DTWBQHPJD1JK','Eden Farrell I','lurline78@bernhard.com','0194188002','MINE.\' The Queen turned crimson with fury, and, after folding his arms and legs in all directions.',NULL,'purchased','2025-06-10 10:46:10','2025-06-10 10:46:10'),(195,49,'MVN2OFV9NQ8Q','Mrs. Kaelyn Keebler','reymundo.mclaughlin@gmail.com','0122588300','The chief difficulty Alice found at first she thought it would all wash off in the book,\' said the.',NULL,'cancelled','2025-06-10 10:46:10','2025-06-10 10:46:10'),(196,50,'HMNMSG06VOGU','Lionel Cremin','jennifer48@hotmail.com','0472870126','When she got up, and there was no label this time it vanished quite slowly, beginning with the.',NULL,'checked_in','2025-06-10 10:46:10','2025-06-10 10:46:10'),(197,50,'LGEQSDJOHTXX','Prof. Zack Hackett','ibogan@hotmail.com','0499059586','On which Seven looked up and said, \'So you think I should think it so quickly that the cause of.',NULL,'pending','2025-06-10 10:46:10','2025-06-10 10:46:10');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:45:49','2025-06-10 10:45:49','Ex fuga similique tempore ratione quia. Eum occaecati corporis qui repellat.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:45:49','2025-06-10 10:45:49','Consectetur vitae reprehenderit earum. Aut ut cum rerum recusandae autem dolorum ut.'),(3,'Event Experience',0,'published','2025-06-10 10:45:49','2025-06-10 10:45:49','Et quae laboriosam sit quia ut. Vitae repellat sapiente nisi eaque qui molestiae.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:45:49','2025-06-10 10:45:49','Et quia aliquid ratione eos. Dolore eum tenetur maxime neque omnis. Itaque id molestias eaque at.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Optio quibusdam quae facere.','Provident et repudiandae fugit et harum corporis in quaerat molestiae ab nihil qui nam quisquam possimus tempore voluptatem asperiores et iusto facere quasi quia tempore distinctio quia minus repellendus minima quos reprehenderit.',1,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(2,'Qui culpa cumque possimus excepturi perferendis inventore.','Nemo et dolor et ex at et sed aut perspiciatis et voluptatum nihil dolorem consequatur hic eligendi sunt aliquam non enim neque voluptatibus fugit accusantium et.',2,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(3,'Perspiciatis consequatur dolorem corrupti ratione.','Deleniti est maxime reprehenderit et tempore autem quo sit esse dicta labore atque sed rerum voluptas illo deleniti non et laborum itaque natus dicta dignissimos voluptatibus molestiae et neque in sed doloribus qui aut officiis voluptatem fugit ut iure perspiciatis.',4,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(4,'Blanditiis et quis ut.','Similique quaerat quis cum rem voluptate vero harum aut dolorem modi dolorem reprehenderit ut et ut magnam nulla quod placeat illo reprehenderit cupiditate consequuntur at.',1,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(5,'Eveniet itaque voluptatem rerum facilis aperiam.','Aut dolorem qui quia et ut repudiandae qui et ut consequuntur omnis quasi aut nihil ex sed illum doloribus enim quaerat nesciunt voluptas ea dolores expedita soluta dolorum consectetur sit rerum in repellat molestiae harum est architecto esse delectus quam.',4,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(6,'Nam quas dolor delectus quia.','Minus reprehenderit provident asperiores ducimus quibusdam eum dicta assumenda impedit asperiores sit id beatae id cupiditate culpa deleniti vel.',4,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(7,'Eveniet totam et rerum ipsa.','Ullam non accusamus officiis ex reiciendis dolorem minima iusto aut blanditiis et quia impedit autem omnis tenetur voluptatem voluptates quod neque voluptatem omnis consequatur consequatur quisquam aspernatur molestiae autem aspernatur facere in excepturi ad qui ipsam iure dolores iure incidunt voluptatum.',3,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(8,'Saepe est praesentium alias illum ut.','Tempora dolorum saepe porro iusto rerum id vel provident debitis et esse et ducimus suscipit et voluptas ipsa vitae nihil earum impedit nisi pariatur quas aspernatur ut ex odio.',1,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(9,'Sit ut nulla unde nobis qui.','Eum qui sed non modi cumque cupiditate qui dolorem quos necessitatibus cupiditate modi temporibus nostrum molestiae placeat quibusdam rerum sed sequi ut dolorum quia quo dolor earum qui sed eius modi accusantium autem quaerat dolorem qui ipsum sit ut.',4,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(10,'Quidem sapiente a ducimus amet id.','Et ex numquam a dignissimos cumque corporis nemo harum molestiae libero ea ut saepe sint ut excepturi ea rerum quos iure quibusdam delectus magni et autem et laboriosam in sunt magnam quia veritatis qui sint corrupti doloribus.',1,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(11,'Qui provident architecto aliquid quos tempora doloremque.','Sit id et et consequatur amet laboriosam commodi accusantium eos saepe similique veniam voluptates non quae quibusdam itaque ut ad et possimus architecto officiis officiis perferendis pariatur culpa aperiam commodi dignissimos eos optio mollitia ipsam ducimus voluptatem dignissimos.',4,'published','2025-06-10 10:45:49','2025-06-10 10:45:49');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Quia repudiandae quibusdam et voluptas cupiditate aut. Laborum incidunt in ullam laboriosam magni non minus. Error voluptatibus et enim voluptates.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(2,'Ocean Views','Sunt atque et quae non sed sapiente corporis. Quia nihil neque quisquam eum occaecati. Ratione qui possimus quia exercitationem.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(3,'Adventure Time','Et dolores distinctio facere numquam. Incidunt ullam dolores et consequatur. Nihil soluta nulla excepturi est sed.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(4,'City Lights','Enim corporis nostrum magni ad. Quo id sequi fugiat et autem. Facere eius consequatur nostrum id enim ex. Quis qui fuga rerum sit et ut est culpa.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(5,'Dreamscape','Ipsam minus ut qui dolores. Deleniti quae cum voluptate deleniti. Omnis qui beatae omnis. Dolorem non atque rerum ut.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(6,'Enchanted Forest','Voluptas corrupti similique iste quas. Velit dolor ipsum harum porro et molestiae. Et velit maiores quas sit et dolor.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(7,'Golden Hour','Ut atque magnam reprehenderit delectus nam quia. Est assumenda neque officia et ex.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(8,'Serenity','Dolores ex et et est. Et consequatur sed aperiam consequatur quia. Quis enim numquam autem explicabo ea voluptatem quibusdam soluta.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(9,'Eternal Beauty','Consequatur accusamus laboriosam laborum ut laboriosam. Sed necessitatibus harum qui sequi. Doloremque et sunt quia est ut laudantium quia.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(10,'Moonlight Magic','Placeat qui necessitatibus in. Et alias non sunt.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(11,'Starry Night','Dolore nam exercitationem dolores. Qui nemo sed distinctio dolorem molestiae quibusdam. Rerum aperiam natus adipisci cumque aut sed et molestiae.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(12,'Hidden Gems','Et et consequatur quaerat vero. Totam porro repudiandae quia optio. Nisi in dignissimos sit eveniet minus in tempora commodi.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(13,'Tranquil Waters','Qui qui praesentium qui et et cumque suscipit. Ut adipisci est reiciendis dolorem id. Quis rem aut ut enim.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(14,'Urban Escape','Ad nisi ad pariatur illo voluptates velit. Saepe atque perspiciatis et et ut omnis nemo. Placeat adipisci non odit ad.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26'),(15,'Twilight Zone','Est animi voluptate est illo quod quis quia autem. Ex eum id atque ea nesciunt quas alias.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:45:26','2025-06-10 10:45:26');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Beatae repudiandae sunt adipisci sed nam quisquam voluptates. Beatae eum sequi mollitia voluptate. Sunt sit sit labore aliquid reiciendis.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deleniti numquam aut dolorem rerum. Magnam consequatur tempora natus facilis. Perspiciatis iure quasi aut.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Omnis voluptatibus sunt quia cumque consequatur. Sit harum qui aut ut voluptatibus deserunt aliquam.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Eius ut et quo impedit dicta. Quae maxime et est quia voluptate. Amet tempora sint cum sed.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non vel blanditiis rem aut voluptatem in non. Id quasi cupiditate ducimus. Itaque porro laudantium ea vero molestiae voluptates.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Qui corrupti rem perferendis quam aut qui. Eius officiis reiciendis ab omnis quia soluta ut. Inventore nihil voluptas placeat cum.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Voluptas est et itaque quae esse. Doloribus dolores dolorem dignissimos accusamus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Rerum cum fugit similique sunt. Enim ipsa ea itaque eum iure. Est fugit ut eius neque facere. Cumque deleniti aut sunt voluptas.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Sunt ullam nulla corporis est quo consequuntur sint. Cumque et accusantium asperiores et qui in. Autem dolorum voluptas ut modi.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Animi aliquid placeat soluta deserunt sequi non. Eveniet autem reprehenderit omnis qui saepe tempore qui.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Minus magni dolorem et qui. Facere assumenda dolore sed laborum non iste sed. Fuga impedit quas vel harum numquam cupiditate.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Debitis ut voluptatum sapiente. In et repellendus pariatur quia. Illum itaque ut omnis qui.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Quibusdam beatae ut quibusdam aut. Officia ea quo vero quisquam quia ad.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Fugit ut laborum asperiores fuga modi. Esse in et labore odit rerum libero. Inventore magnam dolore recusandae veritatis placeat reprehenderit.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Dolores deserunt molestiae blanditiis et et non quae. Natus ab enim dignissimos dolore dolores. Voluptatem rem similique possimus.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Rerum impedit itaque ut et est ut. Magni sit aliquid exercitationem. Officia ullam est quo. Ut fuga ut modi ea illum cupiditate autem qui.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Amet labore nobis et. Vel ex sit enim dolor nesciunt. Non consequuntur voluptatem impedit porro totam nobis aperiam.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Optio libero sunt voluptatum ea. Omnis optio aspernatur consequatur minus quia. Sed expedita hic odit omnis error.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Sed cumque doloribus doloremque labore quia. Cumque animi quae non unde. Maiores voluptas id consequatur.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Sunt incidunt recusandae repudiandae quis est dolores et occaecati. Qui ut labore possimus est laborum. Perspiciatis unde saepe autem.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:45:26','2025-06-10 10:45:26');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','0c4e3738da508707a210d94204e95908',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','89603da68eb9ef924a8589ee57c63e9e',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','dc6aab431bb2e72e1c15755fd83fb8ef',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:45:27','2025-06-10 10:45:27',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:45:27','2025-06-10 10:45:27',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:45:27','2025-06-10 10:45:27',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:45:27','2025-06-10 10:45:27',NULL,'public'),(36,0,'sub-logo','sub-logo',6,'image/png',238,'homepage08/general/sub-logo.png','[]','2025-06-10 10:45:27','2025-06-10 10:45:27',NULL,'public'),(37,0,'countdown-bg','countdown-bg',7,'image/webp',10266,'homepage08/backgrounds/countdown-bg.webp','[]','2025-06-10 10:45:28','2025-06-10 10:45:28',NULL,'public'),(38,0,'footer-bg','footer-bg',7,'image/webp',6436,'homepage08/backgrounds/footer-bg.webp','[]','2025-06-10 10:45:28','2025-06-10 10:45:28',NULL,'public'),(39,0,'hero-banner-bg','hero-banner-bg',7,'image/webp',23542,'homepage08/backgrounds/hero-banner-bg.webp','[]','2025-06-10 10:45:28','2025-06-10 10:45:28',NULL,'public'),(40,0,'brand-img1','brand-img1',8,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:45:28','2025-06-10 10:45:28',NULL,'public'),(41,0,'brand-img2','brand-img2',8,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:45:28','2025-06-10 10:45:28',NULL,'public'),(42,0,'brand-img3','brand-img3',8,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(43,0,'brand-img4','brand-img4',8,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(44,0,'brand-img5','brand-img5',8,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(45,0,'brand-img6','brand-img6',8,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(46,0,'brand-img7','brand-img7',8,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(47,0,'brand-img8','brand-img8',8,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(48,0,'1','1',9,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(49,0,'2','2',9,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:45:29','2025-06-10 10:45:29',NULL,'public'),(50,0,'header-bg4','header-bg4',9,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:45:30','2025-06-10 10:45:30',NULL,'public'),(51,0,'hero-banner-bg','hero-banner-bg',9,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:45:30','2025-06-10 10:45:30',NULL,'public'),(52,0,'image-1','image-1',9,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:45:31','2025-06-10 10:45:31',NULL,'public'),(53,0,'newsletter-bg','newsletter-bg',9,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:45:32','2025-06-10 10:45:32',NULL,'public'),(54,0,'pricing-name','pricing-name',9,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:45:33','2025-06-10 10:45:33',NULL,'public'),(55,0,'speakers-bg','speakers-bg',9,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:45:33','2025-06-10 10:45:33',NULL,'public'),(56,0,'balloons','balloons',10,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:45:33','2025-06-10 10:45:33',NULL,'public'),(57,0,'calendar','calendar',10,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:45:33','2025-06-10 10:45:33',NULL,'public'),(58,0,'clock','clock',10,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:45:33','2025-06-10 10:45:33',NULL,'public'),(59,0,'coding','coding',10,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:45:34','2025-06-10 10:45:34',NULL,'public'),(60,0,'idea','idea',10,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:45:34','2025-06-10 10:45:34',NULL,'public'),(61,0,'instagram-icon','instagram-icon',10,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:45:34','2025-06-10 10:45:34',NULL,'public'),(62,0,'location-icon','location-icon',10,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:45:34','2025-06-10 10:45:34',NULL,'public'),(63,0,'location','location',10,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:45:34','2025-06-10 10:45:34',NULL,'public'),(64,0,'mail-icon','mail-icon',10,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:45:34','2025-06-10 10:45:34',NULL,'public'),(65,0,'menu','menu',10,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:45:34','2025-06-10 10:45:34',NULL,'public'),(66,0,'microphone','microphone',10,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:45:35','2025-06-10 10:45:35',NULL,'public'),(67,0,'phone-icon','phone-icon',10,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:45:35','2025-06-10 10:45:35',NULL,'public'),(68,0,'search','search',10,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:45:35','2025-06-10 10:45:35',NULL,'public'),(69,0,'speaker','speaker',10,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:45:35','2025-06-10 10:45:35',NULL,'public'),(70,0,'ticket','ticket',10,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:45:35','2025-06-10 10:45:35',NULL,'public'),(71,0,'user','user',10,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:45:35','2025-06-10 10:45:35',NULL,'public'),(72,0,'view','view',10,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:45:36','2025-06-10 10:45:36',NULL,'public'),(73,0,'workshop','workshop',10,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:45:36','2025-06-10 10:45:36',NULL,'public'),(74,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:45:36','2025-06-10 10:45:36',NULL,'public'),(75,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:45:36','2025-06-10 10:45:36',NULL,'public'),(76,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:45:37','2025-06-10 10:45:37',NULL,'public'),(77,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:45:37','2025-06-10 10:45:37',NULL,'public'),(78,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:45:37','2025-06-10 10:45:37',NULL,'public'),(79,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:45:37','2025-06-10 10:45:37',NULL,'public'),(80,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:45:38','2025-06-10 10:45:38',NULL,'public'),(81,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:45:38','2025-06-10 10:45:38',NULL,'public'),(82,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:45:38','2025-06-10 10:45:38',NULL,'public'),(83,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:45:39','2025-06-10 10:45:39',NULL,'public'),(84,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:45:39','2025-06-10 10:45:39',NULL,'public'),(85,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:45:39','2025-06-10 10:45:39',NULL,'public'),(86,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:45:40','2025-06-10 10:45:40',NULL,'public'),(87,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:45:40','2025-06-10 10:45:40',NULL,'public'),(88,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:45:40','2025-06-10 10:45:40',NULL,'public'),(89,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:45:41','2025-06-10 10:45:41',NULL,'public'),(90,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:45:41','2025-06-10 10:45:41',NULL,'public'),(91,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:45:41','2025-06-10 10:45:41',NULL,'public'),(92,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:45:42','2025-06-10 10:45:42',NULL,'public'),(93,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:45:42','2025-06-10 10:45:42',NULL,'public'),(94,0,'1','1',11,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:45:42','2025-06-10 10:45:42',NULL,'public'),(95,0,'10','10',11,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:45:43','2025-06-10 10:45:43',NULL,'public'),(96,0,'11','11',11,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:45:43','2025-06-10 10:45:43',NULL,'public'),(97,0,'12','12',11,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:45:43','2025-06-10 10:45:43',NULL,'public'),(98,0,'13','13',11,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:45:44','2025-06-10 10:45:44',NULL,'public'),(99,0,'14','14',11,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:45:44','2025-06-10 10:45:44',NULL,'public'),(100,0,'15','15',11,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:45:44','2025-06-10 10:45:44',NULL,'public'),(101,0,'16','16',11,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:45:45','2025-06-10 10:45:45',NULL,'public'),(102,0,'17','17',11,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:45:45','2025-06-10 10:45:45',NULL,'public'),(103,0,'18','18',11,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:45:45','2025-06-10 10:45:45',NULL,'public'),(104,0,'19','19',11,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:45:46','2025-06-10 10:45:46',NULL,'public'),(105,0,'2','2',11,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:45:46','2025-06-10 10:45:46',NULL,'public'),(106,0,'20','20',11,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:45:46','2025-06-10 10:45:46',NULL,'public'),(107,0,'3','3',11,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:45:46','2025-06-10 10:45:46',NULL,'public'),(108,0,'4','4',11,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:45:47','2025-06-10 10:45:47',NULL,'public'),(109,0,'5','5',11,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:45:47','2025-06-10 10:45:47',NULL,'public'),(110,0,'6','6',11,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:45:47','2025-06-10 10:45:47',NULL,'public'),(111,0,'7','7',11,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:45:48','2025-06-10 10:45:48',NULL,'public'),(112,0,'8','8',11,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:45:48','2025-06-10 10:45:48',NULL,'public'),(113,0,'9','9',11,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:45:48','2025-06-10 10:45:48',NULL,'public'),(114,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:45:49','2025-06-10 10:45:49',NULL,'public'),(115,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:45:49','2025-06-10 10:45:49',NULL,'public'),(116,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:45:50','2025-06-10 10:45:50',NULL,'public'),(117,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:45:50','2025-06-10 10:45:50',NULL,'public'),(118,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:45:50','2025-06-10 10:45:50',NULL,'public'),(119,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:45:50','2025-06-10 10:45:50',NULL,'public'),(120,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:45:50','2025-06-10 10:45:50',NULL,'public'),(121,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:45:50','2025-06-10 10:45:50',NULL,'public'),(122,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:45:51','2025-06-10 10:45:51',NULL,'public'),(123,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:45:51','2025-06-10 10:45:51',NULL,'public'),(124,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:45:51','2025-06-10 10:45:51',NULL,'public'),(125,0,'1','1',12,'image/png',5025,'homepage08/speakers/1.png','[]','2025-06-10 10:45:51','2025-06-10 10:45:51',NULL,'public'),(126,0,'2','2',12,'image/png',5025,'homepage08/speakers/2.png','[]','2025-06-10 10:45:51','2025-06-10 10:45:51',NULL,'public'),(127,0,'3','3',12,'image/png',5025,'homepage08/speakers/3.png','[]','2025-06-10 10:45:51','2025-06-10 10:45:51',NULL,'public'),(128,0,'4','4',12,'image/png',5025,'homepage08/speakers/4.png','[]','2025-06-10 10:45:51','2025-06-10 10:45:51',NULL,'public'),(129,0,'5','5',12,'image/png',5025,'homepage08/speakers/5.png','[]','2025-06-10 10:45:52','2025-06-10 10:45:52',NULL,'public'),(130,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:45:52','2025-06-10 10:45:52',NULL,'public'),(131,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:45:52','2025-06-10 10:45:52',NULL,'public'),(132,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:45:52','2025-06-10 10:45:52',NULL,'public'),(133,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:45:52','2025-06-10 10:45:52',NULL,'public'),(134,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:45:52','2025-06-10 10:45:52',NULL,'public'),(135,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:45:52','2025-06-10 10:45:52',NULL,'public'),(136,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:45:53','2025-06-10 10:45:53',NULL,'public'),(137,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:45:53','2025-06-10 10:45:53',NULL,'public'),(138,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:45:53','2025-06-10 10:45:53',NULL,'public'),(139,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:45:53','2025-06-10 10:45:53',NULL,'public'),(140,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:45:53','2025-06-10 10:45:53',NULL,'public'),(141,0,'0','0',14,'image/webp',33268,'main/events/0-1749552359.webp','[]','2025-06-10 10:45:59','2025-06-10 10:45:59',NULL,'public'),(142,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:46:00','2025-06-10 10:46:00',NULL,'public'),(143,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:46:00','2025-06-10 10:46:00',NULL,'public'),(144,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:46:00','2025-06-10 10:46:00',NULL,'public'),(145,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:46:00','2025-06-10 10:46:00',NULL,'public'),(146,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:46:01','2025-06-10 10:46:01',NULL,'public'),(147,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:46:01','2025-06-10 10:46:01',NULL,'public'),(148,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:46:01','2025-06-10 10:46:01',NULL,'public'),(149,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:46:02','2025-06-10 10:46:02',NULL,'public'),(150,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:46:02','2025-06-10 10:46:02',NULL,'public'),(151,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:46:02','2025-06-10 10:46:02',NULL,'public'),(152,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:46:03','2025-06-10 10:46:03',NULL,'public'),(153,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:46:03','2025-06-10 10:46:03',NULL,'public'),(154,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:46:03','2025-06-10 10:46:03',NULL,'public'),(155,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:46:04','2025-06-10 10:46:04',NULL,'public'),(156,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:46:04','2025-06-10 10:46:04',NULL,'public'),(157,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:46:04','2025-06-10 10:46:04',NULL,'public'),(158,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:46:04','2025-06-10 10:46:04',NULL,'public'),(159,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:46:05','2025-06-10 10:46:05',NULL,'public'),(160,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:46:05','2025-06-10 10:46:05',NULL,'public'),(161,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:46:05','2025-06-10 10:46:05',NULL,'public'),(162,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:46:16','2025-06-10 10:46:16',NULL,'public'),(163,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:46:16','2025-06-10 10:46:16',NULL,'public'),(164,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:46:17','2025-06-10 10:46:17',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:45:18','2025-06-10 10:45:18',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:45:18','2025-06-10 10:45:18',NULL),(3,0,'news',NULL,'news',1,'2025-06-10 10:45:20','2025-06-10 10:45:20',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:45:27','2025-06-10 10:45:27',NULL),(5,0,'homepage08',NULL,'homepage08',0,'2025-06-10 10:45:27','2025-06-10 10:45:27',NULL),(6,0,'general',NULL,'general',5,'2025-06-10 10:45:27','2025-06-10 10:45:27',NULL),(7,0,'backgrounds',NULL,'backgrounds',5,'2025-06-10 10:45:27','2025-06-10 10:45:27',NULL),(8,0,'brands',NULL,'brands',1,'2025-06-10 10:45:28','2025-06-10 10:45:28',NULL),(9,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:45:29','2025-06-10 10:45:29',NULL),(10,0,'icons',NULL,'icons',1,'2025-06-10 10:45:33','2025-06-10 10:45:33',NULL),(11,0,'blogs',NULL,'blogs',1,'2025-06-10 10:45:42','2025-06-10 10:45:42',NULL),(12,0,'speakers',NULL,'speakers',5,'2025-06-10 10:45:51','2025-06-10 10:45:51',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:45:52','2025-06-10 10:45:52',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:45:59','2025-06-10 10:45:59',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:46:16','2025-06-10 10:46:16',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:46:16','2025-06-10 10:46:16');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:46:16','2025-06-10 10:46:16');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:46:16','2025-06-10 10:46:16');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:45:27','2025-06-10 10:45:27'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:45:27','2025-06-10 10:45:27'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:45:27','2025-06-10 10:45:27'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:45:27','2025-06-10 10:45:27'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:45:42','2025-06-10 10:45:42'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:45:42','2025-06-10 10:45:42'),(7,'title','[\"Quality Assurance\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(8,'description','[\"Yet you turned a corner, \'Oh my ears and whiskers, how late it\'s getting!\' She was walking hand in hand with Dinah, and saying \\\"Come up again, dear!\\\" I shall be punished for it flashed across her.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(9,'address','[\"87304 Simonis Locks\\nLehnerchester, ID 75625\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(11,'title','[\"DevOps Engineer\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(12,'description','[\"Gryphon; and then Alice dodged behind a great deal of thought, and it was getting very sleepy; \'and they all crowded together at one corner of it: \'No room! No room!\' they cried out when they had to.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(13,'address','[\"670 Hoppe Village\\nLake Dagmar, CT 71674\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(15,'title','[\"System Administrator\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(16,'description','[\"Hatter. \'I deny it!\' said the Duchess; \'and most things twinkled after that--only the March Hare interrupted in a twinkling! Half-past one, time for dinner!\' (\'I only wish people knew that: then.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(17,'address','[\"894 Lea Cliffs\\nSouth Arnulfo, TX 67102\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(19,'title','[\"Project Manager\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(20,'description','[\"Majesty,\' he began, \'for bringing these in: but I grow up, I\'ll write one--but I\'m grown up now,\' she added in a confused way, \'Prizes! Prizes!\' Alice had no idea what to beautify is, I suppose?\'.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(21,'address','[\"636 Joaquin Islands\\nWest Sonnytown, SC 13980\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(23,'title','[\"Backend Developer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(24,'description','[\"Alice, \'how am I to do?\' said Alice. \'What sort of thing that would be only rustling in the pool rippling to the beginning again?\' Alice ventured to taste it, and behind it, it occurred to her that.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(25,'address','[\"280 Runolfsdottir Squares Apt. 249\\nPort Eulaliaview, TN 88065-9891\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:54','2025-06-10 10:45:54'),(27,'title','[\"Fullstack Developer\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(28,'description','[\"Oh, how I wish you would seem to dry me at home! Why, I wouldn\'t say anything about it, you may stand down,\' continued the King. \'Shan\'t,\' said the Rabbit\'s voice; and Alice was not going to do.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(29,'address','[\"97241 Gerhold Parkways\\nGeorgianafurt, TN 57764-7830\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(31,'title','[\"Project Manager\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(32,'description','[\"So Alice began in a piteous tone. And the muscular strength, which it gave to my jaw, Has lasted the rest waited in silence. At last the Caterpillar decidedly, and the jury eagerly wrote down all.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(33,'address','[\"350 Jasper Brooks\\nNew Rosariofort, DC 85122\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(35,'title','[\"Frontend Developer\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(36,'description','[\"Gryphon: and it said nothing. \'Perhaps it hasn\'t one,\' Alice ventured to say. \'What is it?\' Alice panted as she leant against a buttercup to rest her chin upon Alice\'s shoulder, and it sat for a.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(37,'address','[\"4176 Tromp Common Suite 416\\nNorbertburgh, MA 09888-1890\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(39,'title','[\"Product Manager\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(40,'description','[\"Duchess: \'flamingoes and mustard both bite. And the Gryphon never learnt it.\' \'Hadn\'t time,\' said the King, \'and don\'t be particular--Here, Bill! catch hold of anything, but she had never forgotten.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(41,'address','[\"595 Cyril Square Apt. 867\\nBrayanchester, CT 83624-8022\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(43,'title','[\"Fullstack Developer\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(44,'description','[\"Alice was only a child!\' The Queen turned angrily away from him, and said anxiously to herself, \'it would be so kind,\' Alice replied, rather shyly, \'I--I hardly know, sir, just at first, but, after.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(45,'address','[\"24455 Buckridge Bridge Apt. 910\\nKarellemouth, UT 99295\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(47,'title','[\"Quality Assurance\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(48,'description','[\"Hatter, \'or you\'ll be telling me next that you had been would have this cat removed!\' The Queen had never been in a hoarse, feeble voice: \'I heard the Rabbit hastily interrupted. \'There\'s a great.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(49,'address','[\"21646 Wilkinson Mills Suite 450\\nBrionnaport, CO 72651\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:55','2025-06-10 10:45:55'),(51,'title','[\"Frontend Developer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(52,'description','[\"King: \'leave out that one of the court. \'What do you like to go on till you come to the seaside once in her pocket) till she too began dreaming after a few yards off. The Cat only grinned when it.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(53,'address','[\"3236 Ledner Prairie Apt. 548\\nElisefort, MA 08510-9481\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(55,'title','[\"Backend Developer\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(56,'description','[\"Majesty,\' he began. \'You\'re a very humble tone, going down on their slates, when the Rabbit coming to look down and looked along the course, here and there was the first really clever thing the King.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(57,'address','[\"46029 Windler Points\\nNorth Wilfredhaven, PA 97468-8089\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(59,'title','[\"System Administrator\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(60,'description','[\"Alice had no reason to be a letter, written by the carrier,\' she thought; \'and how funny it\'ll seem, sending presents to one\'s own feet! And how odd the directions will look! ALICE\'S RIGHT FOOT.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(61,'address','[\"100 Noe Road Apt. 051\\nSkilestown, DC 80175-2436\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(63,'title','[\"Quality Assurance\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(64,'description','[\"King. \'Nearly two miles high,\' added the Queen. \'Can you play croquet?\' The soldiers were always getting up and say \\\"Who am I then? Tell me that first, and then unrolled the parchment scroll, and.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(65,'address','[\"36689 Schaden Harbors\\nKihnville, IA 55903\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(67,'title','[\"Product Manager\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(68,'description','[\"Mock Turtle persisted. \'How COULD he turn them out with trying, the poor little feet, I wonder who will put on one knee as he came, \'Oh! the Duchess, as she had not a mile high,\' said Alice.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(69,'address','[\"111 Jermain Trail Suite 124\\nRobelville, IA 33381-6419\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:56','2025-06-10 10:45:56'),(71,'title','[\"Product Manager\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(72,'description','[\"IS his business!\' said Five, \'and I\'ll tell him--it was for bringing the cook took the place where it had been, it suddenly appeared again. \'By-the-bye, what became of the mushroom, and crawled away.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(73,'address','[\"8533 Aric Port Suite 401\\nNorth Hobartstad, ND 71668-7365\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(75,'title','[\"Product Manager\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(76,'description','[\"So Alice got up in a tone of great surprise. \'Of course not,\' said the Dodo. Then they both sat silent for a few minutes she heard one of them.\' In another minute the whole party look so grave and.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(77,'address','[\"53580 Verner Haven\\nRobinshire, NE 20515-9288\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(79,'title','[\"UX\\/UI Designer\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(80,'description','[\"Hatter continued, \'in this way:-- \\\"Up above the world you fly, Like a tea-tray in the newspapers, at the March Hare was said to herself, as she fell very slowly, for she had a bone in his throat,\'.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(81,'address','[\"6846 Paucek Harbors Apt. 886\\nAdrienneport, HI 11204-8577\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(83,'title','[\"Quality Assurance\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(84,'description','[\"William\'s conduct at first she thought it over afterwards, it occurred to her great disappointment it was addressed to the Queen. \'Never!\' said the Duchess, it had been, it suddenly appeared again.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(85,'address','[\"175 Fadel Mission\\nPort Thalia, VA 51127\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(87,'title','[\"System Administrator\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(88,'description','[\"Magpie began wrapping itself up and walking away. \'You insult me by talking such nonsense!\' \'I didn\'t mean it!\' pleaded poor Alice. \'But you\'re so easily offended!\' \'You\'ll get used to come once a.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(89,'address','[\"920 Isabell Curve Apt. 522\\nStehrmouth, MN 33820-4177\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(91,'title','[\"Frontend Developer\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(92,'description','[\"I\'ll just see what would happen next. First, she tried to say it any longer than that,\' said the Cat: \'we\'re all mad here. I\'m mad. You\'re mad.\' \'How do you know why it\'s called a whiting?\' \'I never.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(93,'address','[\"100 Hessel Meadow Apt. 907\\nConnorside, ID 09225-7896\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:57','2025-06-10 10:45:57'),(95,'title','[\"Backend Developer\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(96,'description','[\"Off--\' \'Nonsense!\' said Alice, \'we learned French and music.\' \'And washing?\' said the March Hare moved into the garden, and marked, with one finger, as he came, \'Oh! the Duchess, \'chop off her.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(97,'address','[\"7334 Kirlin Crossing\\nBrianafort, FL 61649\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(99,'title','[\"System Administrator\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(100,'description','[\"Alice joined the procession, wondering very much of it at all; however, she again heard a little bottle that stood near the door and found quite a large piece out of his shrill little voice, the.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(101,'address','[\"110 Rice Meadows\\nLeifmouth, ID 77786-7940\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(103,'title','[\"Fullstack Developer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(104,'description','[\"For anything tougher than suet; Yet you balanced an eel on the song, she kept tossing the baby was howling so much already, that it might appear to others that what you mean,\' said Alice. \'Nothing.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(105,'address','[\"26239 Schaefer Junctions Suite 401\\nEast Destanyside, TX 20110-5097\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(107,'title','[\"Fullstack Developer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(108,'description','[\"Alice again, in a solemn tone, \'For the Duchess. \'I make you a present of everything I\'ve said as yet.\' \'A cheap sort of use in saying anything more till the Pigeon the opportunity of saying to.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(109,'address','[\"93272 Jenkins Rest Suite 138\\nTeresaville, WV 84648\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(111,'title','[\"System Administrator\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(112,'description','[\"The cook threw a frying-pan after her as hard as it happens; and if the Queen of Hearts were seated on their throne when they arrived, with a table set out under a tree a few minutes she heard.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(113,'address','[\"3939 Mathias Squares\\nNew Ronny, KS 54214-8344\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(115,'title','[\"System Administrator\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(116,'description','[\"For some minutes it puffed away without speaking, but at last it unfolded its arms, took the hookah out of THIS!\' (Sounds of more energetic remedies--\' \'Speak English!\' said the Mock Turtle, \'Drive.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(117,'address','[\"85502 Nikko Plaza\\nNorth Catharineside, OH 91488-8608\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:58','2025-06-10 10:45:58'),(119,'title','[\"UX\\/UI Designer\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(120,'description','[\"It means much the same solemn tone, \'For the Duchess. \'I make you a song?\' \'Oh, a song, please, if the Mock Turtle sighed deeply, and began, in rather a hard word, I will just explain to you never.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(121,'address','[\"257 Johann Lake Apt. 818\\nDaughertyville, CT 93199-0982\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(123,'title','[\"Frontend Developer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(124,'description','[\"Queen furiously, throwing an inkstand at the top of her ever getting out of sight, he said to Alice; and Alice thought she might find another key on it, (\'which certainly was not a regular rule: you.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(125,'address','[\"6371 Carroll Wells Suite 755\\nCamillestad, DC 98345\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(127,'title','[\"Fullstack Developer\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(128,'description','[\"Mouse, getting up and repeat something now. Tell her to speak again. In a little nervous about this; \'for it might appear to others that what you had been anything near the centre of the table, but.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(129,'address','[\"415 Heathcote Groves\\nTimmothyside, PA 08307\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:45:59','2025-06-10 10:45:59'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(134,'event_id','[9]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(138,'event_id','[8]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17'),(142,'event_id','[9]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:46:17','2025-06-10 10:46:17');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner style=&quot;7&quot; title=&quot;Digital crypto &lt;br&gt; Conferences 25&quot; subtitle=&quot;Join the the Future of crypto&quot; subtitle_image=&quot;homepage08/general/sub-logo.png&quot; circle_text=&quot;Build Success Brand .&quot; button_primary_label=&quot;Reserve premium Seat&quot; button_primary_url=&quot;/events&quot; background_image=&quot;homepage08/backgrounds/hero-banner-bg.webp&quot;][/hero-banner]\n[countdown style=&quot;3&quot; title=&quot;Countdown: Hurry Up!&quot; subtitle=&quot;event day countdown&quot; start_date=&quot;2026-06-06T11:12&quot; background_image=&quot;homepage08/backgrounds/countdown-bg.webp&quot;][/countdown]\n[events-schedule style=&quot;5&quot; title=&quot;Our Event Schedule&quot; subtitle=&quot;economy event schedule&quot; number_days=&quot;2&quot; number_each_days=&quot;4&quot; text_color=&quot;#ffffff&quot; background_image=&quot;homepage08/backgrounds/countdown-bg.webp&quot;][/events-schedule]\n[brands style=&quot;1&quot; title=&quot;Join 4,000+ companies already growing&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot; text_color=&quot;#ffffff&quot; background_image=&quot;homepage08/backgrounds/countdown-bg.webp&quot;][/brands]\n[contact-information style=&quot;4&quot; address=&quot;Los Angeles, CA 90013&quot; background_image=&quot;homepage08/backgrounds/countdown-bg.webp&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]\n[speakers style=&quot;8&quot; title=&quot;Meet Our Speakers&quot; subtitle=&quot;15+ Event Speakers&quot; limit=&quot;8&quot; text_color=&quot;#ffffff&quot; background_image=&quot;homepage08/backgrounds/countdown-bg.webp&quot;][/speakers]',1,NULL,'homepage',NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/news/13.jpg\" image_1=\"main/news/2.jpg\" image_2=\"main/news/15.jpg\"][/about-us-information][brands title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\" style=\"2\" text_color=\"#000000\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:45:42','2025-06-10 10:45:42');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'NIPGOXJASA1F','bank_transfer',NULL,38.03,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(2,'1',0,'X4NOZ5YJFLBX','bank_transfer',NULL,38.03,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(3,'1',0,'C7G2IHOEFTRB','bank_transfer',NULL,190.15,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(4,'1',0,'Q0NTHQ0EDPB5','bank_transfer',NULL,190.15,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(5,'1',0,'WSUHSMAXV0SE','bank_transfer',NULL,76.06,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(6,'1',0,'IJXF0SZOPHL6','bank_transfer',NULL,114.09,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(7,'1',0,'0KIZ4WAWWPON','bank_transfer',NULL,38.03,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(8,'1',0,'BHAUTY17FBFR','bank_transfer',NULL,38.03,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:06','2025-06-10 10:46:06',NULL,NULL),(9,'1',0,'1VCMKZZWWMVM','bank_transfer',NULL,190.15,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(10,'1',0,'WQTV9URSEVOI','bank_transfer',NULL,190.15,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(11,'1',0,'LXGPKETCPGT4','bank_transfer',NULL,67.54,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(12,'1',0,'F97CGRWKQFXE','bank_transfer',NULL,101.31,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(13,'1',0,'XKWWSVSXYSXH','bank_transfer',NULL,33.77,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(14,'1',0,'1PYEFJDFZ0C0','bank_transfer',NULL,33.77,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(15,'1',0,'0Y5ZMNE1QTCL','bank_transfer',NULL,168.85,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(16,'1',0,'UHGOIXTBIRNK','bank_transfer',NULL,101.31,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(17,'1',0,'PRL4E0UY2ENL','bank_transfer',NULL,67.54,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(18,'1',0,'GUONNBQ3HXWW','bank_transfer',NULL,67.54,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(19,'1',0,'YGRSXJERDCBU','bank_transfer',NULL,135.08,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(20,'1',0,'JI5JODWKWZMA','bank_transfer',NULL,168.85,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:07','2025-06-10 10:46:07',NULL,NULL),(21,'1',0,'MDCBMAYBENE9','bank_transfer',NULL,7.04,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(22,'1',0,'LFXENWE8UFXY','bank_transfer',NULL,5.28,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(23,'1',0,'H7RS63GBT0DG','bank_transfer',NULL,7.04,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(24,'1',0,'LT8EPT1D1NZS','bank_transfer',NULL,3.52,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(25,'1',0,'ZE6FOOKDI3QL','bank_transfer',NULL,3.52,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(26,'1',0,'DLQN3TZWCMRQ','bank_transfer',NULL,3.52,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(27,'1',0,'04SKOIG3LGN9','bank_transfer',NULL,8.80,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(28,'1',0,'9CJTLGV1YTXX','bank_transfer',NULL,3.52,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(29,'1',0,'6VSYLBEA9DGL','bank_transfer',NULL,5.28,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(30,'1',0,'FB1ZNITZFMUE','bank_transfer',NULL,5.28,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(31,'1',0,'0GJ98AJQ8EDF','bank_transfer',NULL,43.83,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(32,'1',0,'PXWW9ZETEULN','bank_transfer',NULL,43.83,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:08','2025-06-10 10:46:08',NULL,NULL),(33,'1',0,'IJWEAZJ7ZEDK','bank_transfer',NULL,43.83,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(34,'1',0,'HWK6GPYNVAIH','bank_transfer',NULL,73.05,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(35,'1',0,'WOSR8WUW2DEN','bank_transfer',NULL,58.44,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(36,'1',0,'QOV7YIZIINQZ','bank_transfer',NULL,58.44,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(37,'1',0,'JTVGQOTCHMZQ','bank_transfer',NULL,29.22,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(38,'1',0,'EOORDABZ9GO7','bank_transfer',NULL,43.83,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(39,'1',0,'ZEK0MDERXBCP','bank_transfer',NULL,58.44,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(40,'1',0,'SNCLETZYUXEH','bank_transfer',NULL,43.83,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(41,'1',0,'GIAUDI94EXPM','bank_transfer',NULL,46.03,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(42,'1',0,'LXGDIQAGYIMU','bank_transfer',NULL,138.09,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(43,'1',0,'PJYL9QE3RCTM','bank_transfer',NULL,46.03,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(44,'1',0,'J41CR7GVD0TH','bank_transfer',NULL,46.03,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(45,'1',0,'KPB3F0HAVRY0','bank_transfer',NULL,184.12,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:09','2025-06-10 10:46:09',NULL,NULL),(46,'1',0,'SXGHS79WE0JG','bank_transfer',NULL,230.15,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10',NULL,NULL),(47,'1',0,'KBNL9SG3J9DP','bank_transfer',NULL,92.06,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10',NULL,NULL),(48,'1',0,'6QY67RW5VC89','bank_transfer',NULL,230.15,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10',NULL,NULL),(49,'1',0,'XOG2ZTWHIMGI','bank_transfer',NULL,138.09,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10',NULL,NULL),(50,'1',0,'FHETDJUIPU6V','bank_transfer',NULL,46.03,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:46:10','2025-06-10 10:46:10',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (2,1),(1,1),(3,2),(2,2),(3,3),(1,3),(1,4),(3,4),(1,5),(5,5),(6,6),(6,7),(2,7),(6,8),(1,8),(3,9),(1,10),(3,10),(5,11),(3,11),(2,12),(2,13),(3,13),(3,14),(2,14),(2,15),(3,15),(4,16),(1,16),(3,17),(1,17),(1,18),(6,19),(5,19),(4,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (2,1),(6,1),(3,1),(7,2),(4,2),(7,3),(3,3),(2,4),(3,4),(4,5),(2,5),(6,5),(3,6),(7,6),(4,6),(4,7),(6,7),(5,7),(5,8),(4,8),(7,8),(3,9),(6,9),(7,9),(2,10),(1,10),(6,11),(5,11),(6,12),(1,12),(7,12),(2,13),(4,13),(7,13),(4,14),(3,14),(5,14),(7,15),(5,15),(3,15),(3,16),(4,16),(6,16),(4,17),(1,17),(3,17),(5,18),(1,18),(4,19),(7,19),(3,19),(3,20),(4,20),(2,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',2280,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',414,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',1667,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',1209,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',636,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',415,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',1825,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',2478,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',273,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',2081,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',1099,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',2463,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',2099,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',1287,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',1411,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',1992,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',1247,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',621,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',1532,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/1.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',942,NULL,'2025-06-10 10:45:49','2025-06-10 10:45:49');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:45:26','2025-06-10 10:45:26');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:46:17'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:46:17'),(6,'language_hide_default','1',NULL,'2025-06-10 10:46:17'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:46:17'),(8,'language_display','all',NULL,'2025-06-10 10:46:17'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:46:17'),(10,'media_random_hash','d3aeb53ea385f5c9be29b4d2456ce124',NULL,'2025-06-10 10:46:17'),(11,'theme','eventify-homepage08',NULL,'2025-06-10 10:46:17'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:46:17'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:46:17'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:46:17'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:46:17'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:46:17'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:46:17'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:46:17'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:46:17'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:46:17'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:46:17'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:46:17'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:46:17'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:46:17'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:46:17'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:46:17'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:46:17'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:46:17'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:46:17'),(30,'theme-eventify-homepage08-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:46:17'),(31,'theme-eventify-homepage08-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:46:17'),(32,'theme-eventify-homepage08-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:46:17'),(33,'theme-eventify-homepage08-favicon','main/general/favicon.png',NULL,'2025-06-10 10:46:17'),(34,'theme-eventify-homepage08-logo','main/general/logo.png',NULL,'2025-06-10 10:46:17'),(35,'theme-eventify-homepage08-homepage_id','1',NULL,'2025-06-10 10:46:17'),(36,'theme-eventify-homepage08-blog_page_id','4',NULL,'2025-06-10 10:46:17'),(37,'theme-eventify-homepage08-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:46:17'),(38,'theme-eventify-homepage08-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:46:17'),(39,'theme-eventify-homepage08-blog_post_items_per_row','3',NULL,'2025-06-10 10:46:17'),(40,'theme-eventify-homepage08-number_of_related_posts','3',NULL,'2025-06-10 10:46:17'),(41,'theme-eventify-homepage08-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:46:17'),(42,'theme-eventify-homepage08-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:46:17'),(43,'theme-eventify-homepage08-events_page_id','5',NULL,'2025-06-10 10:46:17'),(44,'theme-eventify-homepage08-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:46:17'),(45,'theme-eventify-homepage08-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:46:17'),(46,'theme-eventify-homepage08-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:46:17'),(47,'theme-eventify-homepage08-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:46:17'),(48,'theme-eventify-homepage08-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:46:17'),(49,'theme-eventify-homepage08-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:46:17'),(50,'theme-eventify-homepage08-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:46:17'),(51,'theme-eventify-homepage08-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:46:17'),(52,'theme-eventify-homepage08-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:46:17'),(53,'theme-eventify-homepage08-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:46:17'),(54,'theme-eventify-homepage08-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:46:17'),(55,'theme-eventify-homepage08-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:46:17'),(56,'theme-eventify-homepage08-logo_height','45',NULL,'2025-06-10 10:46:17'),(57,'theme-eventify-homepage08-is_header_transparent','1',NULL,'2025-06-10 10:46:17'),(58,'theme-eventify-homepage08-display_header_top','1',NULL,'2025-06-10 10:46:17'),(59,'theme-eventify-homepage08-header_top_text_color','#ffffff',NULL,'2025-06-10 10:46:17'),(60,'theme-eventify-homepage08-header_top_background_color','#FF2D55',NULL,'2025-06-10 10:46:17'),(61,'theme-eventify-homepage08-header_background_color','#1A1719',NULL,'2025-06-10 10:46:17'),(62,'theme-eventify-homepage08-header_text_color','#ffffff',NULL,'2025-06-10 10:46:17'),(63,'theme-eventify-homepage08-footer_background_color','#FBF9F4',NULL,'2025-06-10 10:46:17'),(64,'theme-eventify-homepage08-footer_text_color','#ffffff',NULL,'2025-06-10 10:46:17'),(65,'theme-eventify-homepage08-footer_heading_color','#ffffff',NULL,'2025-06-10 10:46:17'),(66,'theme-eventify-homepage08-tp_primary_font','Figtree',NULL,'2025-06-10 10:46:17'),(67,'theme-eventify-homepage08-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:46:17'),(68,'theme-eventify-homepage08-primary_color','#FF2D55',NULL,'2025-06-10 10:46:17'),(69,'theme-eventify-homepage08-secondary_color','#1A1719',NULL,'2025-06-10 10:46:17'),(70,'theme-eventify-homepage08-newsletter_popup_enable','1',NULL,'2025-06-10 10:46:17'),(71,'theme-eventify-homepage08-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:46:17'),(72,'theme-eventify-homepage08-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:46:17'),(73,'theme-eventify-homepage08-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:46:17'),(74,'theme-eventify-homepage08-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:46:17'),(75,'theme-eventify-homepage08-footer_background_image','homepage08/backgrounds/footer-bg.webp',NULL,'2025-06-10 10:46:17'),(76,'announcement_max_width','1210',NULL,'2025-06-10 10:46:17'),(77,'announcement_text_color','#000000',NULL,'2025-06-10 10:46:17'),(78,'announcement_background_color','transparent',NULL,'2025-06-10 10:46:17'),(79,'announcement_text_alignment','start',NULL,'2025-06-10 10:46:17'),(80,'announcement_dismissible','0',NULL,'2025-06-10 10:46:17'),(81,'announcement_font_size','14',NULL,'2025-06-10 10:46:17'),(82,'announcement_font_size_unit','px',NULL,'2025-06-10 10:46:17'),(83,'announcement_placement','theme',NULL,'2025-06-10 10:46:17'),(84,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:46:17','2025-06-10 10:46:17'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:46:17','2025-06-10 10:46:17'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:46:17','2025-06-10 10:46:17');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:46:17','2025-06-10 10:46:17');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:45:26','2025-06-10 10:45:26'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:45:42','2025-06-10 10:45:42'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:45:49','2025-06-10 10:45:49'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:45:49','2025-06-10 10:45:49'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:45:49','2025-06-10 10:45:49'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:45:49','2025-06-10 10:45:49'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:45:49','2025-06-10 10:45:49'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:45:49','2025-06-10 10:45:49'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:45:49','2025-06-10 10:45:49'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:45:49','2025-06-10 10:45:49'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:54','2025-06-10 10:45:54'),(59,'chesley-howe',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:54','2025-06-10 10:45:54'),(60,'alana-wyman-dvm',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:54','2025-06-10 10:45:54'),(61,'valentina-goldner',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:54','2025-06-10 10:45:54'),(62,'aiyana-mann',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:55','2025-06-10 10:45:55'),(63,'dewitt-skiles',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:55','2025-06-10 10:45:55'),(64,'ettie-stokes-dds',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:55','2025-06-10 10:45:55'),(65,'kareem-boehm',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:55','2025-06-10 10:45:55'),(66,'abe-runte',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:55','2025-06-10 10:45:55'),(67,'verna-schultz',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:56','2025-06-10 10:45:56'),(68,'miss-shannon-schneider-iii',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:56','2025-06-10 10:45:56'),(69,'prof-buster-simonis-iii',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:56','2025-06-10 10:45:56'),(70,'doug-connelly',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:56','2025-06-10 10:45:56'),(71,'tiffany-murray',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:56','2025-06-10 10:45:56'),(72,'emerald-carter',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:57','2025-06-10 10:45:57'),(73,'jacey-olson',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:57','2025-06-10 10:45:57'),(74,'meredith-bernier',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:57','2025-06-10 10:45:57'),(75,'brando-gulgowski',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:58','2025-06-10 10:45:58'),(76,'prof-emmalee-abshire-dds',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:58','2025-06-10 10:45:58'),(77,'dr-domenic-champlin',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:59','2025-06-10 10:45:59'),(78,'elenor-mccullough-dvm',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:59','2025-06-10 10:45:59'),(79,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(80,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(81,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(82,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(83,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(84,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(85,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(86,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(87,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(88,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:46:06','2025-06-10 10:46:06'),(89,'micah-haag',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(90,'yesenia-lebsack',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(91,'dr-isaias-oreilly',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(92,'adrienne-nader',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(93,'dr-alyson-rowe',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(94,'lourdes-hansen',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(95,'ms-alessia-schuppe-md',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(96,'jack-herman',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(97,'karl-sipes',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(98,'ignatius-lind',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(99,'elwyn-rogahn',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(100,'prof-tomasa-roberts-iv',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(101,'isabelle-morar',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(102,'arjun-osinski',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(103,'roosevelt-witting',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(104,'margaret-howe',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(105,'serenity-boehm',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(106,'raymundo-okeefe',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(107,'laila-zboncak-jr',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(108,'dillon-herzog',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(109,'dimitri-heathcote',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(110,'dr-elisabeth-boyle',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(111,'joe-moen',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(112,'rylee-buckridge',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(113,'montana-greenholt',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(114,'marquis-wisozk',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(115,'tierra-harber',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(116,'weston-nitzsche',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(117,'giuseppe-flatley',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(118,'mrs-peggie-legros-iii',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(119,'vella-hodkiewicz',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(120,'miracle-bayer-phd',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(121,'shana-olson',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(122,'miss-retha-collier-md',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(123,'jo-shanahan',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(124,'dr-desmond-medhurst',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(125,'taryn-jenkins',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(126,'myrtie-ratke',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(127,'mrs-isabelle-cole',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(128,'trystan-boyer',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(129,'aubree-ratke',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(130,'keeley-koss',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(131,'edison-towne',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(132,'jackson-reinger',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(133,'misael-mckenzie',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(134,'anastasia-christiansen',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(135,'miss-tressie-donnelly',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(136,'keven-witting',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(137,'casimir-zboncak',70,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17'),(138,'ashley-ebert',71,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:17','2025-06-10 10:46:17');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:45:59','2025-06-10 10:45:59');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:45:49','2025-06-10 10:45:49'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:45:49','2025-06-10 10:45:49');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:45:27','2025-06-10 10:45:27'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:45:27','2025-06-10 10:45:27'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:45:27','2025-06-10 10:45:27'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:45:27','2025-06-10 10:45:27');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'kenyatta88@daugherty.com',NULL,'$2y$12$x3z64iY4WCjGC6ATNT4s0ObUMbTbfyPnpXHYp4kQR3XufxV8UEuA2',NULL,'2025-06-10 10:45:26','2025-06-10 10:45:26','Pascale','Boehm','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage08',1,'[]','2025-06-10 10:45:42','2025-06-10 10:45:42'),(2,'ButtonWidget','header_sidebar','eventify-homepage08',2,'{\"label\":\"Buy Ticket\",\"url\":\"\\/events\"}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage08',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo.png\"}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage08',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage08',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage08',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(7,'EventListWidget','event_list_sidebar','eventify-homepage08',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage08',1,'[]','2025-06-10 10:45:42','2025-06-10 10:45:42'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage08',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage08',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage08',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage08',1,'{\"background_color\":\"#ff2d55\",\"button_label\":\"Buy Ticket\",\"background_image\":\"homepage08\\/backgrounds\\/countdown-bg.webp\"}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage08',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:45:42','2025-06-10 10:45:42'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage08',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:45:42','2025-06-10 10:45:42');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:46:18
