-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'pDXcHQOH4jkFkZ5zAwzDrkAyuDQlPIQD',1,'2025-06-10 10:46:29','2025-06-10 10:46:29','2025-06-10 10:46:29');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:47:20',NULL,1,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:47:20',NULL,1,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:47:20',NULL,1,'2025-06-10 10:47:20','2025-06-10 10:47:20');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Eos qui modi voluptas voluptatem aut voluptatibus voluptas. Fuga est tempora in qui alias. Labore est ducimus maiores.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(2,'Leadership &amp; Strategy',0,'Repellendus repellendus porro officia quo. Ea asperiores impedit quos facere. Fugit tenetur corporis quibusdam laboriosam dolor. Sed ab et odio ipsam. Iure ab nihil nobis repellendus ratione.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(3,'Networking &amp; Collaboration',0,'Ex aspernatur reprehenderit quibusdam veritatis adipisci. Quae ipsa occaecati quia. Fugiat illum aut vel. Voluptas quo sit minima sit totam dolorem.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(4,'Entrepreneurship Startups',0,'Culpa recusandae id et cupiditate vero minus a. Laborum repudiandae asperiores itaque esse qui recusandae quaerat sint. Accusamus maxime rerum porro explicabo soluta.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(5,'Marketing &amp; Branding',0,'Aut molestiae mollitia et et quos eos. Accusamus nihil quae assumenda magnam fugiat quidem doloremque error. Omnis accusantium omnis fugiat omnis rem. Cupiditate sint sunt accusamus sed aut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(6,'Event Highlights &amp; Recaps',0,'Nemo iste est quaerat doloribus perspiciatis eaque. Error ut amet et temporibus totam laboriosam ipsam. Perspiciatis in officiis labore temporibus et.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:46:51','2025-06-10 10:46:51');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Nicholaus Hills','jana.tillman@example.com','+1 (979) 328-3019','8661 Fay Path\nNorth Rosella, CT 73437-0606','Sapiente qui amet et. Minima et aut dolor.','Dolores ut aut ea dolor quia iste. Molestiae quo dignissimos dolores dicta qui. Maiores vel rerum asperiores incidunt. Quisquam consequatur non aliquam error. Adipisci temporibus quia non eos quisquam illum. Corrupti sint porro expedita sit debitis debitis earum odit. Rerum distinctio eligendi molestias quibusdam harum consectetur odio. Adipisci aut ut a totam.',NULL,'read','2025-06-10 10:46:29','2025-06-10 10:46:29'),(2,'Aaron Bayer','igutmann@example.com','+14124946305','23196 Wilmer River Suite 629\nCassiefort, MA 69468','Voluptas iusto ea nihil aut.','Dolorem praesentium a blanditiis est. Pariatur voluptatum nemo dolorem distinctio ut exercitationem vel. Iure neque dolores doloribus veniam aut debitis et. Doloremque cumque minima possimus corrupti facere id vel. Quia voluptatum unde quasi. Voluptatem maiores laborum optio quod. Temporibus nesciunt dolore repudiandae neque. Non voluptatum delectus quo officia consequuntur perspiciatis. Et asperiores itaque eius minima et fugiat. Velit ipsam est laborum asperiores aut exercitationem enim.',NULL,'unread','2025-06-10 10:46:29','2025-06-10 10:46:29'),(3,'Prof. Miles Cole','sawayn.susan@example.net','(870) 963-7826','17034 Della Points\nSpencermouth, KY 77692','Vel natus eum minima nobis et.','Doloremque et sunt ut qui unde ut debitis. Possimus officia enim atque et animi ex et omnis. Porro nemo impedit provident magnam iusto eligendi. Voluptatum similique accusantium et corporis est. Deleniti eius cumque sunt mollitia nesciunt. Omnis officia dolor voluptas vel ut nemo cumque. Ipsum qui saepe sit veritatis esse aut aut officia. Facilis temporibus aspernatur aut voluptatibus magni recusandae animi. Ipsam velit perferendis dolores tenetur fuga.',NULL,'unread','2025-06-10 10:46:29','2025-06-10 10:46:29'),(4,'Luther Dickens V','mitchell.sandra@example.org','+1-689-471-9760','8334 Emilie Crossing Suite 770\nHillsbury, IN 48998','Quaerat sint enim qui quia repellat ut sit natus.','Et aperiam repellat tempore dolores. Modi molestias ratione doloremque nobis consequatur facere. Quam enim minima in nihil rem. Voluptatum beatae quae sapiente quibusdam est impedit fugiat. Aut sed ab corporis est architecto quisquam ut. Voluptas libero a saepe earum. Perferendis aut in repellendus quidem et.',NULL,'unread','2025-06-10 10:46:29','2025-06-10 10:46:29'),(5,'Janessa Herman','isobel.lynch@example.com','505.322.8366','569 Ryder Lane\nNorth Lillianaview, PA 91152','Voluptate qui qui totam dolorem nemo.','Et necessitatibus fuga facilis quisquam dolor ea. Sequi ab voluptatibus corrupti omnis quisquam voluptas non. Itaque ducimus dolores labore quam incidunt ad ut. Ex veniam corrupti totam non impedit. Nihil dolorem pariatur sunt. Sapiente delectus atque debitis quia. Ad blanditiis velit ipsam. Nulla quidem fugit temporibus ut. Ipsam quaerat quo impedit sed aspernatur. Aut et exercitationem saepe. Quos est maxime vel quidem neque.',NULL,'read','2025-06-10 10:46:29','2025-06-10 10:46:29'),(6,'Harrison Muller','gislason.tremayne@example.net','+19387925603','1456 Konopelski Avenue\nLeannonfort, FL 83591','Iure veniam et quo accusantium sed consectetur.','Et architecto sapiente officiis vel. Soluta recusandae voluptas tempora quisquam mollitia unde aspernatur. Accusantium dicta voluptatem est excepturi. Libero omnis qui eius eligendi rem. Sint quo ad et. Corporis dicta a repudiandae quam quaerat. Quo non voluptas dolorem molestiae eum assumenda. Atque adipisci qui ut ut voluptatum id ut. Sunt voluptas natus laudantium aliquam harum aut temporibus. Qui quisquam omnis molestiae qui voluptates excepturi ex ducimus. Ipsa voluptatem est sunt sit.',NULL,'read','2025-06-10 10:46:29','2025-06-10 10:46:29'),(7,'Lloyd Torphy','marlee.keeling@example.org','+1-680-830-0972','10803 Gerry Plains\nFerminburgh, NH 74658','Voluptas et earum ab nesciunt.','Sint deserunt libero neque in eaque maiores. Omnis et est nisi voluptatem aperiam. Quisquam occaecati magnam sint velit et sunt. Voluptatem odit beatae et. Ipsam autem eum sit omnis nostrum deserunt. Eligendi ea dolor veniam occaecati. Expedita ut libero quasi non. Sunt architecto voluptas dicta mollitia quaerat eum. Quam est alias minus. Quisquam repellat aliquam nihil. Qui tempore totam eum necessitatibus ut et. Est repellendus laboriosam asperiores tempora nisi.',NULL,'unread','2025-06-10 10:46:29','2025-06-10 10:46:29'),(8,'Rudy Bergnaum Sr.','skihn@example.com','+1.364.385.2948','38378 Nikolaus Avenue Apt. 402\nPort Anahi, RI 55918-3918','Soluta similique aut amet autem quaerat tenetur.','Saepe incidunt et consequatur ad minus est aperiam quis. Voluptatum labore consequatur quaerat nihil necessitatibus eum ab voluptas. Delectus at fuga velit quas reprehenderit blanditiis vero sit. Distinctio dignissimos rerum rem sed porro sunt magni. Id nostrum dolor quia debitis perferendis. Voluptas voluptas officiis officiis praesentium. Delectus alias dolore et nisi quia excepturi. Ducimus vero assumenda rem aut et fugiat. Fugiat earum quae nihil id.',NULL,'read','2025-06-10 10:46:29','2025-06-10 10:46:29'),(9,'Sibyl VonRueden IV','bradford57@example.com','605.760.0068','86259 Ambrose Throughway\nEast Verla, ND 17079-3440','Tempora praesentium autem non.','Tenetur ullam odit et soluta impedit sequi itaque. Neque corporis quod repellat labore animi. Rerum quas minima ea. Et debitis eaque vel accusantium. Aut qui veritatis quaerat est repellat consequuntur. Quibusdam minus inventore molestias optio. Autem maiores vitae qui rem facilis. Eos adipisci quo assumenda porro nam et. Illum illo perspiciatis unde rerum. Sed corporis enim ex ut et voluptates voluptatibus. Fugiat asperiores ipsam voluptatem expedita deleniti est.',NULL,'unread','2025-06-10 10:46:29','2025-06-10 10:46:29'),(10,'Maribel Mertz DVM','ubaldo90@example.com','1-304-662-5791','4471 Mariana Dam\nTrinityport, WA 05876','Blanditiis facilis ut sunt.','Exercitationem esse animi cupiditate ut rerum. Error ad unde facilis nobis labore eveniet aspernatur. Eum quibusdam veritatis impedit. At expedita ab minima omnis dolore omnis assumenda. Vel quidem autem asperiores est. In quae reprehenderit perferendis sit itaque. Commodi fugiat vitae sit eaque. Aperiam soluta modi similique mollitia. Cumque deleniti quod aliquid laboriosam consequatur rerum. Molestiae molestiae consequatur quibusdam.',NULL,'unread','2025-06-10 10:46:29','2025-06-10 10:46:29');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:47:01',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:47:01',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:47:01',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:47:01',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:47:01',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:47:01',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Mr. Delmer Grant','customer@archielite.com','$2y$12$3s5SSduQiRjIkZRVrndeSO9BJbKm144/qe70tP.KKGgb6GhgtcIle',NULL,'0094548324','2024-02-22','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:56','2025-06-10 10:46:56'),(2,'Michael Smith','cchristiansen@hotmail.com','$2y$12$JarbmX1TRkZPjQOETjpvnOZAHSl4IpOpzgT/3ycCfzUs4AHGylN8O','homepage09/speakers/2.png','0476010878','1998-08-09','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:56','2025-06-10 10:46:56'),(3,'Kelli McGlynn','ibeatty@funk.com','$2y$12$FnA.BQlPbBNGW8d.V38ujuDY0tQye.o1URkagPfZmDw9fL3HOW4Ei','homepage09/speakers/5.png','0475402212','1995-12-30','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:46:56','2025-06-10 10:46:56'),(4,'Emmet Fritsch','okon.eduardo@gmail.com','$2y$12$T4fncOMyvc9/jkO/x2/Nxud8QxNJ26zXRrqR9rJDxh6OciACwL.3i','homepage09/speakers/3.png','0099156094','2004-06-28','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:46:57','2025-06-10 10:46:57'),(5,'Melany Greenfelder','keeley.mertz@bins.info','$2y$12$mD02Br4DVxgre2K0FE7oYu2DOjDQJ8jEPvFM4T4NpjTj2Mn/Qs6XO',NULL,'0303386304','2017-05-28','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:57','2025-06-10 10:46:57'),(6,'Lilla Huel','reynolds.aletha@hotmail.com','$2y$12$eJYpsCPnk3a8VzSFKwuoh.yhY3gXo2qZ6dw9vrw1571SIH3d.g3uq','homepage09/speakers/4.png','0094864117','2006-01-18','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:46:57','2025-06-10 10:46:57'),(7,'Ophelia Wolf','gorczany.glen@yahoo.com','$2y$12$DNUDyZcVOi0eO24QTdBvvuuzgGqb//EtB37zWG2TddP5YWXbBqWZy','homepage09/speakers/1.png','0353817766','2005-01-04','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:57','2025-06-10 10:46:57'),(8,'Cooper Boyer','lauretta.grant@yahoo.com','$2y$12$/3Rvo0wHB9KX1ysMFT1cKuD3lgpOHhMXiX7ZPSs9oKVZQGofXpxmS','homepage09/speakers/1.png','0660690043','2017-07-05','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:46:57','2025-06-10 10:46:57'),(9,'Garry Fadel PhD','freddie36@bergstrom.com','$2y$12$KMCFs9xcALmCecKTUsBYsej8IS2M/zaMuAYDbHkipbol0Vzhwc8ZK','homepage09/speakers/4.png','0535680133','2017-08-13','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:46:57','2025-06-10 10:46:57'),(10,'Rick Mann','gutkowski.giovanni@hotmail.com','$2y$12$aGM2cE5M.5ASDWlvzIAz0uDBkFAUS9LBm42zFbktINcQb4An6M7SK','homepage09/speakers/4.png','0971710534','2021-10-04','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:46:58','2025-06-10 10:46:58'),(11,'Esta Wiegand','brando.thiel@stokes.net','$2y$12$lMqkwHcWefR5RDOtDRq8TuOtOGh.uPLW43wCQxuYsq0FS.cyn6jPm','homepage09/speakers/5.png','0607275044','2020-11-15','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:58','2025-06-10 10:46:58'),(12,'Vinnie Cummerata','iva.quigley@yahoo.com','$2y$12$gFxOOAb6SSxKRGvz9U7x6u/u8xnZBhRwMqPYQjlHrOffM8AG7hESK','homepage09/speakers/1.png','0860777548','2008-03-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:58','2025-06-10 10:46:58'),(13,'Milan Stanton','nkozey@hotmail.com','$2y$12$D5fEg753AJXm0nXdRyAhnOHbeHxPDMQvpzsSgXP2FDiBZBeiNkUEK','homepage09/speakers/4.png','0222054312','2014-03-05','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:58','2025-06-10 10:46:58'),(14,'Prof. Dax Kemmer','friesen.aleen@kilback.com','$2y$12$3Z0TC0dcDM52Bc2csYkh9ONgB2wo63qliTkArXtVVwdhTI1UtEwLy',NULL,'0073549103','1998-09-07','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:58','2025-06-10 10:46:58'),(15,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','$2y$12$LF8HXSUrB8NpNL/bNpAM6evBi78KGOLS0ERYs6UOWzWPyZeOB4S8y',NULL,'0638283351','2020-12-02','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:46:59','2025-06-10 10:46:59'),(16,'Frances Runte','alberta.hand@gmail.com','$2y$12$t.yAeVSU5zEGJJj6IKQgXuMcYeZ51qd6We1HffumfGwF9/WALd5gS','homepage09/speakers/2.png','0277424936','2000-11-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:59','2025-06-10 10:46:59'),(17,'Dimitri Hessel','emely.carter@hotmail.com','$2y$12$wKPBiKRljOgKJD3og7V9o.yym8ranQlr9BItL1.NH7.nnmda7YndW','homepage09/speakers/3.png','0637549677','2006-04-13','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:46:59','2025-06-10 10:46:59'),(18,'Arden Gulgowski MD','frami.alf@hotmail.com','$2y$12$RxvdfSoz0FFuCnvw5YFiMuVzM/PATciMqjIR2a7JwSoKfT4pp9pVq','homepage09/speakers/4.png','0951865619','2013-03-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:59','2025-06-10 10:46:59'),(19,'Prudence Nicolas','hector33@klocko.info','$2y$12$WJYyL/ZehihAWfjE1fWH9.R2/.S.Y5NZdk.FBmDvGEZvI1ffGxiaC','homepage09/speakers/4.png','0352439024','2025-03-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:59','2025-06-10 10:46:59'),(20,'Lyda Durgan','mireille68@auer.biz','$2y$12$u2q9ZZ0s1QNG6ML4VSKumOsc/3S35GlUW3BfRuf/PXjOuPkhAASo6','homepage09/speakers/3.png','0228411259','1995-07-07','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:46:59','2025-06-10 10:46:59'),(21,'Dr. Rozella Spinka II','swalker@pagac.biz','$2y$12$NGclWNNHqPsw59jqAVc/T.66zbbGBQlvV2NdgWmTu0kn/XfXcef9O','homepage09/speakers/2.png','0578645576','1998-11-15','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:47:00','2025-06-10 10:47:00'),(22,'Mackenzie Hintz','collin.lindgren@yahoo.com','$2y$12$QQzLxSh5C2ed8kFe0WU3pO7kuGVxvgyFHdABcZt9zdoHiMM.Qge0S','homepage09/speakers/2.png','0094925696','2003-03-21','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:47:00','2025-06-10 10:47:00'),(23,'Gerry Nienow','beth.spinka@lueilwitz.com','$2y$12$UdD/IBjYlXRPQhMtygRTXOu.5Ix/0U3hzzT84/T38M41Vo9C1OPNi',NULL,'0475738394','1997-01-03','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:00','2025-06-10 10:47:00'),(24,'Aileen Ortiz V','adam.kerluke@gmail.com','$2y$12$z0H8bbMD1W9lPaPDuF7kfewakif4MbO7YSI1K4usLVwRzEermYc7W','homepage09/speakers/4.png','0840851144','2015-06-04','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:47:00','2025-06-10 10:47:00'),(25,'Vince Jerde','nicolas.camren@gmail.com','$2y$12$zrp7EAHwzxfv0ulECOCIYOSp1MG4B9Uk6ZUUpTTVkKzOqZTYVOua.','homepage09/speakers/4.png','0826899238','2023-11-23','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:47:00','2025-06-10 10:47:00'),(26,'Neil Shanahan','paltenwerth@stroman.com','$2y$12$0VX/BG5fFW0CcR.IInM7ZONDJylB7Mb7ercCenCSL6Eus/9qhAzsC',NULL,'0100653271','2025-02-23','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:01','2025-06-10 10:47:01'),(27,'Velva Bernhard','vschumm@green.com','$2y$12$OocFcGxjZVwFoNW3o1Q3meDMhhQP8lMa/1Fxipjyh9Fd1HS8jDWsy',NULL,'0654700218','2010-04-28','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:01','2025-06-10 10:47:01'),(28,'Monte Schinner','khalil.will@mann.biz','$2y$12$nDm4VaeBufXm8RIJNKU69.0fjrg7oAWSJ.fX.4hUbPxhhz84KR3Ua',NULL,'0187170321','2017-10-01','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:01','2025-06-10 10:47:01'),(29,'Rachel Franecki PhD','johnpaul.hahn@hartmann.com','$2y$12$ROwcWtl0P4MrLbAQlN2Fm.fgarM2b5XkRI2Z0MbD0cD2nGaS7ir/2','homepage09/speakers/5.png','0065214621','2019-03-01','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:47:01','2025-06-10 10:47:01'),(30,'Mrs. Cecelia Harvey','vkovacek@yahoo.com','$2y$12$5LG6sI21lcffvRBNTV4LS.Tw3BhvQIYKBK3VHzgf/XkkE17oZnsVC','homepage09/speakers/3.png','0856985001','2003-02-05','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:47:01','2025-06-10 10:47:01'),(31,'Mr. Ted Frami III','yturcotte@yahoo.com','$2y$12$9gyd2RZupxAHPP9SwyNDwueGX.RY6iI3jiL5km6ZTxuDl5sGIIRIi',NULL,'0425069953','2006-04-03','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:01','2025-06-10 10:47:01'),(32,'Alivia Borer MD','ryan.jovani@gmail.com','$2y$12$rhpk0x717T9j6xXABW3VzOoJXdlqiZVaN.Migk2v2S8AyHRg4tk7y',NULL,'0978677160',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(33,'Rachel Kunde','schaefer.gillian@gmail.com','$2y$12$cnEqm5O7hEIFSGWNDasM8Oy41R8jRemSw3rUzqOo9UbPSO3MV2WCu',NULL,'0232305565',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:13','2025-06-10 10:47:13'),(34,'Kavon Nikolaus','zpouros@okeefe.com','$2y$12$qp0BEO2SmZIHS4iTpAKV9.CGnug6ZjLnpPJcJYoB2vPg59x1jiP1y',NULL,'0793140465',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:13','2025-06-10 10:47:13'),(35,'Prof. Joshua Sauer','oheathcote@rodriguez.com','$2y$12$sGpP5Hh2a6E2f5OpJNevwuxxLULtxgVu7arP4Kmaoh/KPb.KhT2ge',NULL,'0878605886',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:13','2025-06-10 10:47:13'),(36,'Veronica Pfannerstill Sr.','gutkowski.elmer@hotmail.com','$2y$12$t2KvhdWDona/dvLHKpxCtuBX/c1KSX206xR87mTGLVsdGwJ9zRGqm',NULL,'0592605453',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:13','2025-06-10 10:47:13'),(37,'Brooklyn Ullrich','fheidenreich@gmail.com','$2y$12$NYymeeUR1AzRrlrtIF0XWeCkKpJgxt1/pgpw8xLNISyutNDfoufBK',NULL,'0130383861',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:13','2025-06-10 10:47:13'),(38,'Dr. Toy Purdy','elaina.mitchell@lubowitz.com','$2y$12$D9DKRKmnD8FCUaq/ZlBmW.LI9nliguZx1TYnr1JUXHW5bhIXBQWP2',NULL,'0070194190',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:13','2025-06-10 10:47:13'),(39,'Ray Fay','skylar39@quitzon.info','$2y$12$6OZsfLHsJczUqHY7N6rDFuPDxIDNJvWLiiJvFpwYVWqKC/JyFXm2y',NULL,'0175117570',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:13','2025-06-10 10:47:13'),(40,'Mrs. Aurore Stiedemann','gretchen.pfannerstill@effertz.biz','$2y$12$xb.QmYq41YQTvVrGT80Gi.fGg8AZ3JQu1Xo/5gIk2x4EyYmWajXMK',NULL,'0455915072',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:14','2025-06-10 10:47:14'),(41,'Jayce Hermiston','trantow.mae@hotmail.com','$2y$12$sej9rXEmSadahWrhOni26OQR1TFzR1gN5lsCyfTakTm5.tW0AUWU6',NULL,'0540968377',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:14','2025-06-10 10:47:14'),(42,'Lonzo Friesen','xwaters@nolan.info','$2y$12$r1HRWjXA4bxOHrb1bE3dy.QsXDhUsWwmqJgE7IpgvLJ1wyaAC45IK',NULL,'0927362940',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:14','2025-06-10 10:47:14'),(43,'Dewayne Kshlerin II','eddie.upton@hotmail.com','$2y$12$E3/Rs2ErSNSX4RVocKymGeyazrzecx7xoo/CIkLQZFxSsXPlsXIMa',NULL,'0494340684',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:14','2025-06-10 10:47:14'),(44,'Zion Rice','bspinka@gmail.com','$2y$12$px18wMVakLWwPh6B9MiCIefOT9o1.9QAMO6b/Cd7lssylWZfz/vde',NULL,'0601369292',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:14','2025-06-10 10:47:14'),(45,'Myra Mayer','tiara.nikolaus@skiles.com','$2y$12$EGeGLlNIi2Ut3l9FSOkbjunVuYs7xygPwVO4kwmGUY3jV8qo/yJIm',NULL,'0847477279',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:14','2025-06-10 10:47:14'),(46,'Zora Gottlieb','wwilkinson@borer.com','$2y$12$PoXBjjiOEJMC2fgB81Lqtuzoozo2cfCWL0aC8Hhtipn5cJRAZlJM6',NULL,'0738784000',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:15','2025-06-10 10:47:15'),(47,'Jalen Torphy','rlebsack@gmail.com','$2y$12$7oNbjzJ6rIvNnvBqHRtNHecY0cRTNhs.R4p7Kc3kAV10qmgCyvze.',NULL,'0493523927',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:15','2025-06-10 10:47:15'),(48,'Syble Hermann','cummings.della@gmail.com','$2y$12$Gkb4.D3hVaAEeMeOqIL7M.Mxl4Tc/Gn/A1r9sNR2RPR957RYV1H2a',NULL,'0087921370',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:15','2025-06-10 10:47:15'),(49,'Eileen Dickinson','kaylee37@zulauf.com','$2y$12$CyQsCPEtFDrkV8E.ieqLkucpVt74ky4Ozt9vD8KqkS7BpvB7ZF.Gq',NULL,'0449559623',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:15','2025-06-10 10:47:15'),(50,'Margaretta Lesch','kiara19@gmail.com','$2y$12$YXsvdjdk69fCD3XRx7rM.ejXTHgXF/JmfN44Z1zWEbQCMgXhsC5lC',NULL,'0789376629',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:15','2025-06-10 10:47:15'),(51,'Joe Goldner','emelie.rice@yahoo.com','$2y$12$dSG4TiW5uSAkcDqxsPA8sO4ff6RXk2a8aNZ/IbD/fwp3pHnwVCwWq',NULL,'0813604616',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:15','2025-06-10 10:47:15'),(52,'Amina Marquardt','thea.grady@gmail.com','$2y$12$ZO/CkZ3FQZapEF99hNtDa.gZ1YUO2.iXTTDD/n92KSuZHCWJIeipS',NULL,'0391173843',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:15','2025-06-10 10:47:15'),(53,'Cleta Grimes DDS','jacobs.holly@yahoo.com','$2y$12$xcKneLtnrHvnbSSvkfqtcOg/.0aguHfvqNabxlv6B8aPzlPYfb7Tq',NULL,'0469887736',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:16','2025-06-10 10:47:16'),(54,'Prof. Wava Kihn','ben.mraz@yahoo.com','$2y$12$HTMHc7tWIy1Br.YIayYgXeUUkNbzwOgaQgImluPgRyu06TXVKBaRm',NULL,'0288309333',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:16','2025-06-10 10:47:16'),(55,'Prof. Gus Monahan','ryan.carole@hotmail.com','$2y$12$rT3iTtLh.BaRqRDX.2FzEuelctqUsFFVR5bRwWl30B3z1/fEYocAW',NULL,'0016831812',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:16','2025-06-10 10:47:16'),(56,'Royce Daniel','yjakubowski@yahoo.com','$2y$12$OubRc.tgnj.Cf2bZsw/y3.k0UoNRU2NDAkq2SZiogmyp0lSsToHWC',NULL,'0325031710',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:16','2025-06-10 10:47:16'),(57,'Lavon Heller','helmer72@gmail.com','$2y$12$CwnS3s1FsVFW0ntXxgwfsue9kK6h1V1/yzTam8B2gUitZTZjGN7rq',NULL,'0453554930',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:16','2025-06-10 10:47:16'),(58,'Sunny Auer','rhickle@hintz.net','$2y$12$opPWpTl1o0r2AGOpks890.IR2DzqjmFqbIK2balj9llr0LYZ30YZu',NULL,'0325969062',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:16','2025-06-10 10:47:16'),(59,'Prof. Crawford Dach','caesar13@yahoo.com','$2y$12$vlNNvzxslHUjOJuLpah.VO8.YPfH/WskR0gwYNEB4a4UlubqQTL2K',NULL,'0528629191',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:16','2025-06-10 10:47:16'),(60,'Birdie Cruickshank DDS','sgutkowski@gmail.com','$2y$12$5dgWVo39bAdqWm6gdPvQsurPCl89/dpM4zx.ibl1/Do.NwEPruBlm',NULL,'0513313720',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:17','2025-06-10 10:47:17'),(61,'Dr. Erica Keebler','vcruickshank@hotmail.com','$2y$12$4HVI6U6Hzfmk4UKOUOT/fO44LKzegjn3fikC5nv56CvaJWmyomy9C',NULL,'0762079913',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:17','2025-06-10 10:47:17'),(62,'Dagmar Pagac','bette.beatty@gmail.com','$2y$12$kHRg1uZal1Pr8Im/HcZ4O.rRWwyNBsohORldZyVqEM6p.aD7GEWjK',NULL,'0247726169',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:17','2025-06-10 10:47:17'),(63,'Jean Douglas','jking@hoppe.com','$2y$12$xdIIs1wQeadvYmkXUvJtouguzXvn7Xy5Q6Grxrsl5Q1ybBgdXQ1hy',NULL,'0360245144',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:17','2025-06-10 10:47:17'),(64,'Jaylon Schimmel DVM','sam.padberg@bergstrom.biz','$2y$12$r8MMZ2EZyCc9Dv3DxyY55.npfMJrHnMudFTK1idleWfnjjlhPdrEq',NULL,'0561983128',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:17','2025-06-10 10:47:17'),(65,'Dr. Saige Orn','cummerata.kenny@schmitt.com','$2y$12$w40vJfSDkTIc3D2UdywzC.XvDe0TVZzS5hMBQGAakO1DvZGXtAVX.',NULL,'0564948330',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:17','2025-06-10 10:47:17'),(66,'Cleveland Howell','queen.witting@hotmail.com','$2y$12$7ziYZxevwVTur9kNvBLxjOwQYJZfaIXTrGUdxmGLGknBBBzO8yq36',NULL,'0824811837',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:17','2025-06-10 10:47:17'),(67,'Mr. Ali Feil IV','rodriguez.colby@gmail.com','$2y$12$Zyx9.DwVZaCZsoNL/Qo4de3J5n.cqsvOZf7crDJVYnmNwTgLo7PUi',NULL,'0754577897',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:18','2025-06-10 10:47:18'),(68,'Dawn Quigley','okuneva.quinten@yahoo.com','$2y$12$M2BCkkN4HQp1JeTbqbABNO5EakRKLGmnW5auIKi/XXGceEPlzO7f.',NULL,'0439340285',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:18','2025-06-10 10:47:18'),(69,'Rodrigo Ratke','rickie61@yahoo.com','$2y$12$HzsIHQ.RBjZsHGDKxMJhQ.yjDZqIFCpSNkJLU1NmwkfdN3dP0KISm',NULL,'0165185643',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:18','2025-06-10 10:47:18'),(70,'Dr. Twila Hudson Jr.','victoria.effertz@hotmail.com','$2y$12$eZXxPi7O5t6zpRgL8jaKa.bLfeZPM02gAhgsrPQp0BM7ivncwt4lO',NULL,'0037605959',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:18','2025-06-10 10:47:18'),(71,'Rey Bernier','pacocha.antoinette@hartmann.com','$2y$12$SkX5iAfWJopnTSXepwnNYuFnD1zaHhkdh56M98wxT9yOCCUF4JO1S',NULL,'0745735870',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:18','2025-06-10 10:47:18'),(72,'Colleen Schroeder PhD','angela.jacobs@gmail.com','$2y$12$jweXzdTFJMHA3krIOkCbbejAjzMqBt/ExuIJ27OzZAOhcFm3Wk4sa',NULL,'0032295419',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:18','2025-06-10 10:47:18'),(73,'Earnest Larson','rogahn.nicole@hermann.biz','$2y$12$d6ySeL.3rI7I/jtmnmUf5.9VRwnL8YV92gJVfblWVafDV6clUHKRe',NULL,'0247422359',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:18','2025-06-10 10:47:18'),(74,'Mr. Nestor Rice IV','jayden.ratke@gmail.com','$2y$12$lNv1vRxHrs5.U4S4kWz/SeO7mqkH089pIWCZFiAxXdIm8hDIQSZea',NULL,'0185793296',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:19','2025-06-10 10:47:19'),(75,'Karianne Kerluke','gregg.brekke@wolf.com','$2y$12$bXo59rLOvbV..UHUeEE8B.I5NqHHtWj0wvqVQnfhevJ//AyRdNBle',NULL,'0171622961',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:19','2025-06-10 10:47:19'),(76,'Abbey Homenick','lueilwitz.percy@lang.com','$2y$12$Nt0RkzKQUimMO8OCNzfOaOm4nok4CVqeYBXrQ3hwVdUQqPqoGm3i.',NULL,'0964442957',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:19','2025-06-10 10:47:19'),(77,'Miss Rachael O\'Reilly','rogahn.theodore@harvey.com','$2y$12$M4PdyZnuCY7jEtDgwgCctOsz60Kz0yScQpU/PJ56j14QsuA4xeQ5a',NULL,'0294027867',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:19','2025-06-10 10:47:19'),(78,'Sarai Hegmann','fisher.alene@gmail.com','$2y$12$7VZlm6GI6I8OR.t4fAIAke5/eW6/7z21iwZMmJWW4ktykyXHh1WsW',NULL,'0676770982',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:19','2025-06-10 10:47:19'),(79,'Destiny Renner III','helen85@gmail.com','$2y$12$zyHaAhS8HdDoBOq82mPDzeDDYQhL0zozVQRuApOY.AWZaMsda6dIq',NULL,'0837213015',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:19','2025-06-10 10:47:19'),(80,'Cyril Wunsch','christina.blick@gmail.com','$2y$12$WClfU3CR2ZuoZYGYx4drZOYfnBC5zmiECbJGI1r6oLEH8FiIU/Hai',NULL,'0682076901',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(81,'Horace Hayes','xstehr@bogisich.com','$2y$12$OOznKRKK9xQIvymcJk1jK.CAMfZgYWYmSygiAPUMIvLPawOlt6dma',NULL,'0677695042',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:47:20','2025-06-10 10:47:20');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:46:23','2025-06-10 10:46:23'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:46:23','2025-06-10 10:46:23'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:46:23','2025-06-10 10:46:23');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (3,42,'0GNQYOERZ3BS',NULL),(5,80,'49HN5OZGMOMQ',NULL),(4,59,'5MUY54SSXABI',NULL),(3,46,'5NFS2VS2HVGQ',NULL),(4,65,'6TGLF7KPE97E',NULL),(3,49,'8JMCTTBHSQ9T',NULL),(2,38,'9HZNHFKXFGFT',NULL),(3,45,'9PDGOMR4U0EP',NULL),(3,47,'AHP3YM1ET8I6',NULL),(4,69,'AJNAXBQE2XUW',NULL),(5,72,'APC9ZOYYPY9H',NULL),(5,78,'DTCIOJMTKJWF',NULL),(2,40,'DTKLXXPOIQFU',NULL),(3,51,'DUAH7J6OGW8E',NULL),(5,76,'EAUNPN2IWZ3J',NULL),(1,36,'FTKXZCBQNNVV',NULL),(4,66,'G60FQY9MBYGQ',NULL),(1,34,'H1PJLTZGPM9U',NULL),(4,54,'HJZMULVEEQMO',NULL),(1,33,'HT5HFGRR9LLI',NULL),(4,64,'IMA80KZR13TD',NULL),(1,35,'J8TCGMOAZDPW',NULL),(1,32,'JWLKNDXJ67SA',NULL),(4,67,'KJ9W4ZCEIBJC',NULL),(5,73,'KMAULHTUQDGC',NULL),(5,77,'LEZEAKYMONYF',NULL),(4,70,'LMEGL6LCHDUH',NULL),(5,75,'M6XYTFIHHLSS',NULL),(5,79,'MI33NFI0ANPP',NULL),(4,68,'MPEIUQV2ZPHC',NULL),(3,48,'MWSM4A73LIFK',NULL),(4,58,'NJNVC9BJZU18',NULL),(4,56,'NSQXHMHFR9VF',NULL),(3,44,'NX6QKMLHGF18',NULL),(4,57,'OI1FQISBXOU2',NULL),(3,43,'QD4GVSJ6CDTH',NULL),(2,37,'QOFJT4XZFDGF',NULL),(4,63,'ROBJZ1YKV2BC',NULL),(2,39,'RYWZMQOJT57Y',NULL),(4,61,'T9M0GJTPXJB3',NULL),(4,52,'TFRXRELTYU9Q',NULL),(4,60,'TJKTRY9FSJXO',NULL),(4,62,'TK9RY3DTNRZV',NULL),(4,71,'U6JALU42MVSK',NULL),(4,55,'UJMRZ66SADMU',NULL),(5,74,'UQIWFNVP2ZYV',NULL),(2,41,'UWSE21QSQ2JZ',NULL),(3,50,'WILIXAC5OGYM',NULL),(4,53,'X23A6GLTSFGY',NULL),(5,81,'XJHMZJPQFV3I',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,11,'Et quia et accusamus molestiae. Dolorem qui earum autem dolorem doloribus sit reiciendis.',NULL,0,NULL,NULL),(1,7,'Iusto asperiores qui qui. Similique in cupiditate qui sit. Aut non sint qui laudantium.',NULL,1,NULL,NULL),(1,13,'Molestias vero quia similique. Et doloremque deleniti suscipit.',NULL,2,NULL,NULL),(1,20,'Qui sint non autem eum. Nostrum vero id velit cumque non neque. Sit nobis sit dolor voluptatem eum.',NULL,3,NULL,NULL),(2,29,'Sed non repellat est. Aut accusamus vero ab. Est recusandae similique quam recusandae sunt dolor.',NULL,0,NULL,NULL),(2,11,'Velit minima maiores sed nemo. Accusantium commodi id distinctio tempore repellat.',NULL,1,NULL,NULL),(2,7,'Atque ipsa incidunt omnis aliquam nesciunt. Molestiae vero non aspernatur rerum id molestias.',NULL,2,NULL,NULL),(2,18,'Eaque porro unde dolorem nesciunt. Aut velit natus et aut. Soluta hic consectetur officia labore.',NULL,3,NULL,NULL),(3,13,'Eveniet maxime blanditiis fugit iure qui autem eos. Qui eos quaerat aut voluptatem quis velit.',NULL,0,NULL,NULL),(3,20,'Mollitia maxime dolorum nulla veniam minus ut commodi. Exercitationem adipisci est ipsum eligendi.',NULL,1,NULL,NULL),(3,16,'Veritatis asperiores quasi sapiente iusto adipisci sit. Quia consequatur ut ullam veniam non.',NULL,2,NULL,NULL),(3,7,'Aut sed delectus velit est aliquid eius consequatur. Aperiam quisquam rem fugit saepe sunt.',NULL,3,NULL,NULL),(4,16,'Nobis atque molestias inventore consequatur et. Consequuntur ut voluptas optio dolore qui.',NULL,0,NULL,NULL),(4,12,'Veritatis ratione beatae sit est. Quis in illo excepturi eveniet.',NULL,2,NULL,NULL),(5,12,'Autem adipisci sit quo et cupiditate quas dolorum. Dolorum cum a odit.',NULL,0,NULL,NULL),(5,18,'Repellat ut nisi iusto eos quisquam eius hic. Accusantium qui voluptatem quia sint.',NULL,1,NULL,NULL),(5,7,'Et nulla sit consectetur quaerat nobis consequatur eius. Consectetur quae iusto consequatur.',NULL,2,NULL,NULL),(5,20,'Enim fugit voluptatem distinctio corrupti. Debitis error voluptatem mollitia consectetur assumenda.',NULL,3,NULL,NULL),(6,20,'Est sit recusandae praesentium rerum. Dolorem qui et nam qui provident et.',NULL,0,NULL,NULL),(6,18,'Perspiciatis earum repellat exercitationem magni et quos. Dolorum molestias voluptas laborum.',NULL,1,NULL,NULL),(6,30,'Voluptas praesentium corrupti sit vel maiores. Et nihil aut aut est totam quia accusantium.',NULL,2,NULL,NULL),(7,18,'Ea veritatis quisquam hic recusandae. Aliquid autem fuga labore omnis est dolor.',NULL,0,NULL,NULL),(7,19,'Iure ea rerum et. Consequuntur alias fuga facere quos. Iste ea atque et nemo.',NULL,1,NULL,NULL),(7,12,'Animi aliquam quam non animi. Odio enim sint a omnis omnis quasi. Aut et voluptates iste.',NULL,3,NULL,NULL),(8,18,'Rem et id qui ipsam. Voluptas veniam ea et pariatur.',NULL,0,NULL,NULL),(8,16,'Vel provident cum modi ut quod a. Vel et dolorem pariatur. Ut est aspernatur rerum culpa dicta.',NULL,1,NULL,NULL),(8,30,'Accusantium eos maxime molestias doloribus id aperiam ullam. Ut quas vel officia voluptas.',NULL,2,NULL,NULL),(8,19,'Doloribus enim rem et dolorem occaecati. Voluptas voluptatem delectus laborum unde fugit quis.',NULL,3,NULL,NULL),(9,19,'Laudantium laudantium voluptates ut maxime natus ut quod. Et et et incidunt.',NULL,0,NULL,NULL),(9,12,'Sint et qui et. Saepe ab nobis consectetur magnam repellat. In atque quo omnis.',NULL,1,NULL,NULL),(9,18,'Non consequatur voluptatem doloremque velit ut. Et ab incidunt deleniti velit sunt possimus.',NULL,2,NULL,NULL),(10,7,'Modi rem eum quos sit atque. Distinctio qui fuga provident voluptatem quo sit animi.',NULL,0,NULL,NULL),(10,16,'Qui non vel quasi dolores quis. Nihil eius quo maxime id sint quos neque sunt.',NULL,1,NULL,NULL),(10,19,'Tempora quam quia ad. Nihil quaerat et eaque. Quis tenetur nemo eum ducimus quis optio.',NULL,2,NULL,NULL),(10,12,'Sunt quis incidunt nam mollitia velit quis inventore. Accusantium corrupti corrupti culpa placeat.',NULL,3,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',24,'Perspiciatis saepe ea numquam ut maxime numquam.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','113ab989-a6e8-3f32-915d-a2b6cd6c02e3','main/events/1.webp',62.64,'1168 Sawayn Island Apt. 666\nWest Alan, UT 47311-9926',4,4,4,'-39.001292','31.645112',79,0,'2025-06-10 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(2,'Mobile World Congress',9,'Vitae nihil nihil id et eos nihil laborum.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','24ce4d08-bb0d-3227-addc-080b9f6f11c5','main/events/2.webp',65.95,'753 Gerhold Fields Apt. 016\nNew Ari, WY 04151',4,4,4,'-68.436456','36.03121',91,0,'2025-06-10 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(3,'Google I/O',8,'Rerum beatae inventore ea aut quis.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','1b252740-0a16-3110-a936-62c44aaf92b6','main/events/3.webp',1.37,'99710 Rosenbaum Trafficway\nCassinstad, AZ 37119-3636',6,NULL,NULL,'89.929728','-103.615351',100,0,'2025-06-10 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(4,'Apple WWDC',9,'Dolor voluptatem dolorem modi corporis enim placeat.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','e7d2b9ac-cfe7-3c9d-893a-276ccd760550','main/events/4.webp',45.37,'89535 Kilback Valley\nNew Cali, WV 38583',4,4,4,'19.917236','-65.192983',81,0,'2025-06-10 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(5,'AWS re:Invent',3,'Architecto id aut qui et est harum.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','d7afbe82-58b9-3680-98c9-f2ef864d8435','main/events/5.webp',77.82,'26324 Autumn Course Apt. 658\nRaynorstad, HI 45439',6,NULL,NULL,'87.088087','-98.909362',61,0,'2025-06-11 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(6,'Microsoft Build',9,'Nostrum ullam ut aut ut expedita possimus et.','Microsoft\'s developer event, introducing new development tools and platforms.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','7efb8fb0-cb68-3e94-bbe5-ea7ba72d1b77','main/events/6.webp',97.71,'762 Eloisa Radial Suite 594\nPort Amber, VA 25380-4469',6,NULL,NULL,'42.160147','-88.702724',57,0,'2025-06-11 09:00:00','2025-06-25 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(7,'Facebook F8',6,'Nemo aliquam quo similique consequatur libero.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','5cfb5957-2670-3970-be67-5dab91352cd4','main/events/7.webp',58.22,'94050 Lueilwitz Road\nSouth Abelfort, MA 15006-5138',1,3,3,'4.55381','176.617179',78,0,'2025-06-11 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(8,'GitHub Universe',10,'Illo quas repellendus aut veniam aspernatur saepe fugit aperiam.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','1559a616-ff62-301c-aa9f-4e93b03fd158','main/events/8.webp',28.59,'9497 Zachery Cliff\nAmyaside, NC 30080-5020',2,2,2,'59.307073','-159.989924',50,0,'2025-06-11 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(9,'Game Developers Conference',17,'Aliquam voluptatibus in quia earum ipsam maiores.','The largest conference in the gaming industry, focusing on game development and gaming technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','7bef27cf-e542-31df-b2f2-11751b872906','main/events/9.webp',6.76,'3089 Padberg Walk Suite 505\nLake Reeceburgh, VT 72728-6824',4,4,4,'-47.571859','-148.387378',62,0,'2025-06-12 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(10,'Web Summit',22,'Eligendi officiis ab fugiat ab omnis facere fugiat voluptatum.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','27266ae6-f55f-306f-8019-a002de212491','main/events/10.webp',44.31,'162 Johnston Terrace Suite 941\nEast Lonnyside, NV 52169',2,2,2,'0.708092','75.598955',99,0,'2025-06-12 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:47:08','2025-06-10 10:47:08');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Alivia Borer MD - ryan.jovani@gmail.com','ryan.jovani@gmail.com','0978677160',1,62.64,62.64,NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Rachel Kunde - schaefer.gillian@gmail.com','schaefer.gillian@gmail.com','0232305565',1,62.64,62.64,NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Kavon Nikolaus - zpouros@okeefe.com','zpouros@okeefe.com','0793140465',1,62.64,62.64,NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Prof. Joshua Sauer - oheathcote@rodriguez.com','oheathcote@rodriguez.com','0878605886',1,62.64,62.64,NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08'),(5,1,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Veronica Pfannerstill Sr. - gutkowski.elmer@hotmail.com','gutkowski.elmer@hotmail.com','0592605453',1,62.64,62.64,NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Ashly Ratke IV - jones.pinkie@hotmail.com','jones.pinkie@hotmail.com','0426558504',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Prof. Demarco Metz - frank14@gmail.com','frank14@gmail.com','0825338606',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(8,2,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Prof. Fannie Wolf PhD - joana.roberts@yahoo.com','joana.roberts@yahoo.com','0481750413',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(9,3,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Ibrahim VonRueden - mayer.sandy@jacobi.net','mayer.sandy@jacobi.net','0454590949',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Dr. Rogers Bosco - mquitzon@russel.info','mquitzon@russel.info','0678790501',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(11,4,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Prof. Christa Kovacek - magdalena89@wintheiser.com','magdalena89@wintheiser.com','0077807263',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(12,4,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Dameon Koepp - lilla27@gmail.com','lilla27@gmail.com','0216497335',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Kristopher Leannon - kling.berenice@yahoo.com','kling.berenice@yahoo.com','0897012275',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(14,4,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Rudy Spinka - ayana.mraz@morissette.com','ayana.mraz@morissette.com','0586415748',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Alverta Wintheiser - kamron.carter@yahoo.com','kamron.carter@yahoo.com','0511081476',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(16,5,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Dr. Ricardo Leannon V - owhite@walker.com','owhite@walker.com','0918331875',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(17,5,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Mr. Dayton Nolan PhD - jschuster@yahoo.com','jschuster@yahoo.com','0714236624',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(18,6,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Irving Jakubowski - johnson.margarete@gmail.com','johnson.margarete@gmail.com','0661856998',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(19,6,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Cara Streich - oswaldo70@hotmail.com','oswaldo70@hotmail.com','0400622821',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(20,6,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Norwood Senger - dvolkman@yahoo.com','dvolkman@yahoo.com','0158461100',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(21,6,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Mr. Merlin Mills - nluettgen@prosacco.com','nluettgen@prosacco.com','0127281659',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(22,7,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Wilburn Barton Sr. - augustus53@yahoo.com','augustus53@yahoo.com','0440398150',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(23,7,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Arnulfo Reynolds PhD - ogusikowski@hotmail.com','ogusikowski@hotmail.com','0883724235',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(24,7,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Keven Hamill - gregoria00@hotmail.com','gregoria00@hotmail.com','0449022899',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(25,7,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Mr. Colin Leannon - pouros.angus@gmail.com','pouros.angus@gmail.com','0049385259',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(26,7,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Finn Bradtke - damore.winston@auer.com','damore.winston@auer.com','0625654049',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(27,8,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Aiden Monahan - axel06@yahoo.com','axel06@yahoo.com','0284459007',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(28,8,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Marcella Kohler - goyette.loyce@gmail.com','goyette.loyce@gmail.com','0667232623',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(29,8,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Bennie Marvin - vincent06@fritsch.com','vincent06@fritsch.com','0008120923',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(30,8,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Aliyah Schiller - icremin@gmail.com','icremin@gmail.com','0446292870',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(31,8,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Miss Estefania Rohan Jr. - vincenza.kuvalis@yahoo.com','vincenza.kuvalis@yahoo.com','0742910134',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(32,9,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Sven Stehr - ibeier@marquardt.com','ibeier@marquardt.com','0142605709',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(33,9,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Marcos Murazik - jborer@marks.com','jborer@marks.com','0980159910',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(34,9,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Carol O\'Hara - ymarvin@durgan.info','ymarvin@durgan.info','0554119682',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(35,9,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Prof. Mossie Feil Jr. - mbaumbach@keeling.com','mbaumbach@keeling.com','0654452503',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(36,9,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Mr. Jonas Turcotte PhD - ariel.adams@bins.com','ariel.adams@bins.com','0626715176',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(37,10,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Prof. Maurice Hammes III - qryan@hotmail.com','qryan@hotmail.com','0346928174',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(38,10,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Dr. Alice Gutkowski - cathy84@bruen.com','cathy84@bruen.com','0247771962',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(39,10,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Karine Smith - huels.trey@gmail.com','huels.trey@gmail.com','0167085782',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(40,10,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'CES (Consumer Electronics Show) - Ernestine Pacocha - achristiansen@durgan.com','achristiansen@durgan.com','0513917790',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(41,10,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'CES (Consumer Electronics Show) - Johanna Watsica - jovan77@gmail.com','jovan77@gmail.com','0401091771',1,62.64,62.64,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(42,11,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'Mobile World Congress - Dessie Lowe - reva.feeney@gmail.com','reva.feeney@gmail.com','0979542109',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(43,11,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Hollis Kertzmann - nicklaus14@bashirian.com','nicklaus14@bashirian.com','0215545470',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(44,11,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Mr. Timothy Wiza MD - kulas.kiarra@wilkinson.com','kulas.kiarra@wilkinson.com','0392016507',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(45,11,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Liza Moore - kub.margarete@hotmail.com','kub.margarete@hotmail.com','0687914138',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(46,11,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Prof. Abigail Hagenes - lilyan.glover@corwin.biz','lilyan.glover@corwin.biz','0755077082',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(47,12,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Flavie Denesik - torrance68@schuster.com','torrance68@schuster.com','0543834939',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(48,12,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Nora Rohan - cary.stoltenberg@predovic.com','cary.stoltenberg@predovic.com','0464992555',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(49,12,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Felipa Murazik I - jtremblay@kessler.com','jtremblay@kessler.com','0192496212',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(50,13,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Mr. Cameron Wuckert - herman.edgardo@rosenbaum.org','herman.edgardo@rosenbaum.org','0546010994',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(51,13,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Hershel Cummerata - ipurdy@yahoo.com','ipurdy@yahoo.com','0144148671',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(52,13,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Carmine Hilpert - hand.beverly@christiansen.info','hand.beverly@christiansen.info','0993829877',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(53,14,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Amina Huels V - nettie.rogahn@larson.info','nettie.rogahn@larson.info','0291773871',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(54,14,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Quinten Daniel - shemar76@kessler.net','shemar76@kessler.net','0977185337',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(55,14,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Kathryn Stiedemann - walsh.jon@tillman.biz','walsh.jon@tillman.biz','0119017374',1,65.95,65.95,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(56,15,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Muriel Heller - verda02@ondricka.com','verda02@ondricka.com','0762095637',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(57,15,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Mario Rodriguez Jr. - champlin.jerel@hotmail.com','champlin.jerel@hotmail.com','0860631404',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(58,15,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Dr. Samantha Kozey Jr. - qglover@hotmail.com','qglover@hotmail.com','0438558176',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(59,15,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Magali Lehner - hettinger.vida@morar.com','hettinger.vida@morar.com','0542975876',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(60,15,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Raheem Blick - angus31@yahoo.com','angus31@yahoo.com','0560854270',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(61,16,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Lazaro Trantow - edamore@hotmail.com','edamore@hotmail.com','0458664936',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(62,16,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Mr. Jarrod Collins - nikolas76@yahoo.com','nikolas76@yahoo.com','0026315220',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(63,17,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Brooklyn Ullrich - fheidenreich@gmail.com','fheidenreich@gmail.com','0130383861',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(64,17,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Dr. Toy Purdy - elaina.mitchell@lubowitz.com','elaina.mitchell@lubowitz.com','0070194190',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(65,17,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Ray Fay - skylar39@quitzon.info','skylar39@quitzon.info','0175117570',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(66,17,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Mrs. Aurore Stiedemann - gretchen.pfannerstill@effertz.biz','gretchen.pfannerstill@effertz.biz','0455915072',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(67,17,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Jayce Hermiston - trantow.mae@hotmail.com','trantow.mae@hotmail.com','0540968377',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(68,18,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Norval Senger - birdie.keeling@hotmail.com','birdie.keeling@hotmail.com','0527155197',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(69,18,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Grayson Fisher - clark.becker@von.com','clark.becker@von.com','0101847964',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(70,18,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Irma Christiansen - jamal20@yahoo.com','jamal20@yahoo.com','0276641726',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(71,18,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Elody Rice - vabbott@gmail.com','vabbott@gmail.com','0148369263',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(72,18,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Jaden Koss - flabadie@hotmail.com','flabadie@hotmail.com','0632084398',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(73,18,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Jamar Marquardt - sporer.tanner@deckow.info','sporer.tanner@deckow.info','0114140886',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(74,19,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Ruby Rolfson - stracke.heath@yahoo.com','stracke.heath@yahoo.com','0346090630',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(75,19,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Madie Hickle - christiansen.flo@hotmail.com','christiansen.flo@hotmail.com','0522332677',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(76,19,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Savion Schumm - cronin.geraldine@toy.com','cronin.geraldine@toy.com','0874342768',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(77,19,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Stewart Wilkinson - ocie.crona@denesik.com','ocie.crona@denesik.com','0153270675',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(78,19,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Mobile World Congress - Deion Cruickshank - nils.powlowski@yahoo.com','nils.powlowski@yahoo.com','0204094740',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(79,20,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Mobile World Congress - Kyra Rempel - vtremblay@ullrich.biz','vtremblay@ullrich.biz','0721269155',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(80,20,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Mobile World Congress - Prof. Dedrick Fay - leffler.frederic@gibson.com','leffler.frederic@gibson.com','0711909634',1,65.95,65.95,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(81,21,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Google I/O - Lonzo Friesen - xwaters@nolan.info','xwaters@nolan.info','0927362940',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(82,21,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Google I/O - Dewayne Kshlerin II - eddie.upton@hotmail.com','eddie.upton@hotmail.com','0494340684',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(83,21,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Google I/O - Zion Rice - bspinka@gmail.com','bspinka@gmail.com','0601369292',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(84,21,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Google I/O - Myra Mayer - tiara.nikolaus@skiles.com','tiara.nikolaus@skiles.com','0847477279',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(85,21,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Zora Gottlieb - wwilkinson@borer.com','wwilkinson@borer.com','0738784000',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(86,21,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Jalen Torphy - rlebsack@gmail.com','rlebsack@gmail.com','0493523927',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(87,22,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Syble Hermann - cummings.della@gmail.com','cummings.della@gmail.com','0087921370',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(88,22,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Eileen Dickinson - kaylee37@zulauf.com','kaylee37@zulauf.com','0449559623',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(89,22,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Margaretta Lesch - kiara19@gmail.com','kiara19@gmail.com','0789376629',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(90,22,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Joe Goldner - emelie.rice@yahoo.com','emelie.rice@yahoo.com','0813604616',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(91,23,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Talon Mraz Jr. - qcorwin@wisoky.info','qcorwin@wisoky.info','0054368969',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(92,23,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Michel Emmerich - magnolia.hauck@yahoo.com','magnolia.hauck@yahoo.com','0550527974',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(93,23,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Kristian Wiegand - dkunze@hansen.net','dkunze@hansen.net','0982605459',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(94,23,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Jan Walker - mandy.keeling@ratke.com','mandy.keeling@ratke.com','0151811063',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(95,23,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Letitia Bruen V - coconner@yahoo.com','coconner@yahoo.com','0907226990',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(96,23,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Dr. Lavina Koepp Sr. - natalia51@hotmail.com','natalia51@hotmail.com','0670326624',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(97,24,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Mrs. Fabiola Krajcik V - ervin.runolfsdottir@yahoo.com','ervin.runolfsdottir@yahoo.com','0674757887',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(98,24,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Tre Skiles Sr. - winfield.lang@gmail.com','winfield.lang@gmail.com','0141138199',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(99,24,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Manuel Pagac DDS - agoyette@renner.com','agoyette@renner.com','0857368897',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(100,24,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Dr. Jalon Bernier - neil02@hotmail.com','neil02@hotmail.com','0924928921',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(101,25,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Prof. Charley Jacobson - veronica81@gmail.com','veronica81@gmail.com','0634148855',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(102,25,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Emmalee Bode - friesen.domenick@damore.org','friesen.domenick@damore.org','0099002883',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(103,25,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Wyatt O\'Conner II - ffranecki@yost.net','ffranecki@yost.net','0197472988',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(104,26,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Gerhard Rath - ressie20@hotmail.com','ressie20@hotmail.com','0967681237',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(105,26,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Mr. Christian Denesik - miracle26@strosin.com','miracle26@strosin.com','0658297713',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(106,26,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Christopher Witting MD - mkoelpin@gmail.com','mkoelpin@gmail.com','0744171668',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(107,27,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Marcel Zieme IV - crooks.sid@mcclure.com','crooks.sid@mcclure.com','0567121225',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(108,27,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Alba Kuvalis - yschinner@yahoo.com','yschinner@yahoo.com','0886223213',1,1.37,1.37,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(109,28,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Monica Schmidt - rath.bradford@gmail.com','rath.bradford@gmail.com','0092894032',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(110,28,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Ryder Moore - legros.alvina@block.com','legros.alvina@block.com','0730138664',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(111,28,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Elsie Shields - crystal90@lynch.org','crystal90@lynch.org','0422339099',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(112,28,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Mrs. Danielle Howe II - imurphy@watsica.com','imurphy@watsica.com','0510265699',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(113,28,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Yolanda Stokes - frederique.wolff@king.org','frederique.wolff@king.org','0529659630',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(114,29,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Dr. Conrad McCullough - grant96@sauer.com','grant96@sauer.com','0455254111',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(115,29,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Kayden Heller - bauch.dedrick@hotmail.com','bauch.dedrick@hotmail.com','0627807370',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(116,29,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Cordie Ankunding - devan.larkin@gmail.com','devan.larkin@gmail.com','0397007043',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(117,29,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Google I/O - Arne Stroman - kiarra.murray@padberg.com','kiarra.murray@padberg.com','0197784094',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(118,29,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Google I/O - Juwan Gorczany - rath.emilie@yahoo.com','rath.emilie@yahoo.com','0917857097',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(119,30,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Google I/O - Arnulfo O\'Keefe - vidal24@kutch.com','vidal24@kutch.com','0545937443',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(120,30,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Google I/O - Prof. Drake Kovacek Sr. - roy17@cremin.com','roy17@cremin.com','0858200017',1,1.37,1.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(121,31,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Apple WWDC - Amina Marquardt - thea.grady@gmail.com','thea.grady@gmail.com','0391173843',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(122,31,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Apple WWDC - Cleta Grimes DDS - jacobs.holly@yahoo.com','jacobs.holly@yahoo.com','0469887736',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(123,31,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Apple WWDC - Prof. Wava Kihn - ben.mraz@yahoo.com','ben.mraz@yahoo.com','0288309333',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(124,31,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Apple WWDC - Prof. Gus Monahan - ryan.carole@hotmail.com','ryan.carole@hotmail.com','0016831812',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(125,31,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Royce Daniel - yjakubowski@yahoo.com','yjakubowski@yahoo.com','0325031710',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(126,32,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Lavon Heller - helmer72@gmail.com','helmer72@gmail.com','0453554930',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(127,32,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Sunny Auer - rhickle@hintz.net','rhickle@hintz.net','0325969062',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(128,32,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Prof. Crawford Dach - caesar13@yahoo.com','caesar13@yahoo.com','0528629191',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(129,33,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Clyde Pollich Sr. - heller.gudrun@wiza.info','heller.gudrun@wiza.info','0630696882',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(130,33,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Mrs. Edythe Medhurst Jr. - fwintheiser@boehm.com','fwintheiser@boehm.com','0930127937',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(131,33,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Juanita Hirthe I - isaac05@schroeder.com','isaac05@schroeder.com','0834952296',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(132,33,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Mrs. Eliane Reinger I - jaleel.lowe@hotmail.com','jaleel.lowe@hotmail.com','0456830184',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(133,33,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Eino Swift - farrell.lacey@yahoo.com','farrell.lacey@yahoo.com','0631520908',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(134,34,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Mauricio West - mraz.graham@mcglynn.net','mraz.graham@mcglynn.net','0455264447',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(135,34,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Osvaldo Grant - geraldine11@ebert.com','geraldine11@ebert.com','0284965902',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(136,34,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Kaitlin Runolfsson - woodrow94@hotmail.com','woodrow94@hotmail.com','0944221141',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(137,34,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Vergie Cassin - qlegros@lockman.biz','qlegros@lockman.biz','0833223189',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(138,34,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Alexys Marks - okrajcik@ohara.org','okrajcik@ohara.org','0718002204',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(139,34,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Ruthie Konopelski - bridgette.von@beatty.biz','bridgette.von@beatty.biz','0180106500',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(140,35,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Arch Bailey - sage17@mertz.com','sage17@mertz.com','0718650524',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(141,35,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Prof. Maribel Bednar Jr. - sgoldner@hotmail.com','sgoldner@hotmail.com','0269027030',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(142,35,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Andres Borer - hdickens@smitham.com','hdickens@smitham.com','0458159231',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(143,35,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Brooke Schroeder - myrl36@hotmail.com','myrl36@hotmail.com','0902461736',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(144,36,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Birdie Cruickshank DDS - sgutkowski@gmail.com','sgutkowski@gmail.com','0513313720',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(145,36,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Dr. Erica Keebler - vcruickshank@hotmail.com','vcruickshank@hotmail.com','0762079913',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(146,36,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Dagmar Pagac - bette.beatty@gmail.com','bette.beatty@gmail.com','0247726169',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(147,36,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Jean Douglas - jking@hoppe.com','jking@hoppe.com','0360245144',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(148,36,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Jaylon Schimmel DVM - sam.padberg@bergstrom.biz','sam.padberg@bergstrom.biz','0561983128',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(149,36,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Dr. Saige Orn - cummerata.kenny@schmitt.com','cummerata.kenny@schmitt.com','0564948330',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(150,37,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Prof. Phoebe Reinger Jr. - ryan.nelle@quigley.com','ryan.nelle@quigley.com','0708820610',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(151,37,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Dejon Farrell - therzog@emard.biz','therzog@emard.biz','0357438163',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(152,37,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Prof. Brody Kiehn - vivien.jacobs@kovacek.com','vivien.jacobs@kovacek.com','0170432780',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(153,37,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Lorena Schneider MD - tiffany47@moore.com','tiffany47@moore.com','0181163546',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(154,38,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Mrs. Grace Rau - zcummings@murray.com','zcummings@murray.com','0546696477',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(155,38,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Lamar Frami - zmcdermott@gmail.com','zmcdermott@gmail.com','0182135530',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(156,39,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Alayna Towne - amina09@block.com','amina09@block.com','0030865964',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(157,39,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Antonio Kertzmann - buster.hickle@gmail.com','buster.hickle@gmail.com','0941972772',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(158,39,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Deontae Bernhard - elva.stamm@hotmail.com','elva.stamm@hotmail.com','0157213356',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(159,39,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'Apple WWDC - Royce Haley - quinten37@jacobi.info','quinten37@jacobi.info','0031863274',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(160,39,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'Apple WWDC - Prof. Lourdes Dickens - mlegros@hyatt.com','mlegros@hyatt.com','0946453147',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(161,39,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'Apple WWDC - Odessa Durgan - darrick47@yahoo.com','darrick47@yahoo.com','0668904015',1,45.37,45.37,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(162,40,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'Apple WWDC - Cleveland Howell - queen.witting@hotmail.com','queen.witting@hotmail.com','0824811837',1,45.37,45.37,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(163,40,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'Apple WWDC - Mr. Ali Feil IV - rodriguez.colby@gmail.com','rodriguez.colby@gmail.com','0754577897',1,45.37,45.37,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(164,40,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'Apple WWDC - Dawn Quigley - okuneva.quinten@yahoo.com','okuneva.quinten@yahoo.com','0439340285',1,45.37,45.37,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(165,40,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'Apple WWDC - Rodrigo Ratke - rickie61@yahoo.com','rickie61@yahoo.com','0165185643',1,45.37,45.37,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(166,40,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'Apple WWDC - Dr. Twila Hudson Jr. - victoria.effertz@hotmail.com','victoria.effertz@hotmail.com','0037605959',1,45.37,45.37,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(167,40,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'Apple WWDC - Rey Bernier - pacocha.antoinette@hartmann.com','pacocha.antoinette@hartmann.com','0745735870',1,45.37,45.37,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(168,41,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Blair Fadel DVM - hklocko@hermiston.com','hklocko@hermiston.com','0105789143',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(169,41,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Joany Blanda - jenkins.idell@connelly.info','jenkins.idell@connelly.info','0695339486',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(170,42,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Blaise Toy - xavier48@yahoo.com','xavier48@yahoo.com','0238017401',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(171,42,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Verner Veum - ettie.feil@hotmail.com','ettie.feil@hotmail.com','0841721262',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(172,42,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Hope Bosco II - clint54@hotmail.com','clint54@hotmail.com','0327110032',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(173,42,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Kevon Armstrong - rhuel@yahoo.com','rhuel@yahoo.com','0317590507',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(174,42,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Prof. Madyson Bode - monahan.concepcion@hickle.com','monahan.concepcion@hickle.com','0413259956',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(175,42,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Prof. Javonte Heller - lilliana37@yahoo.com','lilliana37@yahoo.com','0141701525',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(176,43,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Ms. Esmeralda Hagenes PhD - george.koss@toy.com','george.koss@toy.com','0473546155',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(177,43,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Amanda Greenholt - mertz.sydnie@kub.org','mertz.sydnie@kub.org','0656099123',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(178,44,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Alize Heller - khessel@okeefe.com','khessel@okeefe.com','0220306631',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(179,44,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Dr. Darion VonRueden - jerde.kennith@hotmail.com','jerde.kennith@hotmail.com','0026988746',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(180,44,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Vella Treutel I - qswaniawski@hessel.net','qswaniawski@hessel.net','0639478110',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(181,44,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Gilda Fadel - rath.karlee@hotmail.com','rath.karlee@hotmail.com','0432444523',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(182,44,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Kellie Kautzer Jr. - murray.wilfredo@gmail.com','murray.wilfredo@gmail.com','0217594647',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(183,45,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Nicholas Conroy - vhansen@yahoo.com','vhansen@yahoo.com','0606025946',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(184,45,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Concepcion Mraz I - andrew.larkin@hotmail.com','andrew.larkin@hotmail.com','0397041336',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(185,45,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Eli Heidenreich - bruce75@hoeger.com','bruce75@hoeger.com','0873718537',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(186,45,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Pascale Torphy - kihn.devonte@gmail.com','kihn.devonte@gmail.com','0046593883',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(187,46,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Dr. Kenya Gottlieb - efren.kovacek@gmail.com','efren.kovacek@gmail.com','0192812278',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(188,46,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Ms. Elva Ryan V - phayes@jacobson.com','phayes@jacobson.com','0846069275',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(189,46,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Elena McLaughlin - pkertzmann@gmail.com','pkertzmann@gmail.com','0763152821',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(190,47,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Alphonso Cassin - ischaden@hotmail.com','ischaden@hotmail.com','0468290000',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(191,47,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Mr. Tomas Schiller - victor.toy@rodriguez.com','victor.toy@rodriguez.com','0297464885',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(192,47,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Mavis Hamill II - bernice.pfeffer@yahoo.com','bernice.pfeffer@yahoo.com','0087572793',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(193,48,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Ms. Hanna Mraz - wwiegand@gmail.com','wwiegand@gmail.com','0391289984',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(194,48,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Kara Welch - qmorissette@gleason.com','qmorissette@gleason.com','0103986113',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(195,48,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Dr. Scot Kiehn - murphy.hodkiewicz@mckenzie.com','murphy.hodkiewicz@mckenzie.com','0292855641',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(196,49,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Colleen Schroeder PhD - angela.jacobs@gmail.com','angela.jacobs@gmail.com','0032295419',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(197,49,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Earnest Larson - rogahn.nicole@hermann.biz','rogahn.nicole@hermann.biz','0247422359',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(198,49,'ArchiElite\\EventsBooking\\Models\\Ticket',198,'AWS re:Invent - Mr. Nestor Rice IV - jayden.ratke@gmail.com','jayden.ratke@gmail.com','0185793296',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(199,49,'ArchiElite\\EventsBooking\\Models\\Ticket',199,'AWS re:Invent - Karianne Kerluke - gregg.brekke@wolf.com','gregg.brekke@wolf.com','0171622961',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(200,50,'ArchiElite\\EventsBooking\\Models\\Ticket',200,'AWS re:Invent - Abbey Homenick - lueilwitz.percy@lang.com','lueilwitz.percy@lang.com','0964442957',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(201,50,'ArchiElite\\EventsBooking\\Models\\Ticket',201,'AWS re:Invent - Miss Rachael O\'Reilly - rogahn.theodore@harvey.com','rogahn.theodore@harvey.com','0294027867',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(202,50,'ArchiElite\\EventsBooking\\Models\\Ticket',202,'AWS re:Invent - Sarai Hegmann - fisher.alene@gmail.com','fisher.alene@gmail.com','0676770982',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(203,50,'ArchiElite\\EventsBooking\\Models\\Ticket',203,'AWS re:Invent - Destiny Renner III - helen85@gmail.com','helen85@gmail.com','0837213015',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(204,50,'ArchiElite\\EventsBooking\\Models\\Ticket',204,'AWS re:Invent - Cyril Wunsch - christina.blick@gmail.com','christina.blick@gmail.com','0682076901',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(205,50,'ArchiElite\\EventsBooking\\Models\\Ticket',205,'AWS re:Invent - Horace Hayes - xstehr@bogisich.com','xstehr@bogisich.com','0677695042',1,77.82,77.82,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',62.64,'CES (Consumer Electronics Show)','Neil Shanahan','paltenwerth@stroman.com',NULL,'ArchiElite','main/general/logo-light.png',250.56,250.56,0.00,0.00,NULL,1,'completed','2025-06-10 10:47:08','2025-06-10 10:47:08','2025-06-10 10:47:08'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',62.64,'CES (Consumer Electronics Show)','Prof. Dax Kemmer','friesen.aleen@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',125.28,125.28,0.00,0.00,NULL,2,'completed','2025-06-10 10:47:09','2025-06-10 10:47:08','2025-06-10 10:47:09'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',62.64,'CES (Consumer Electronics Show)','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',62.64,62.64,0.00,0.00,NULL,3,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',62.64,'CES (Consumer Electronics Show)','Monte Schinner','khalil.will@mann.biz',NULL,'ArchiElite','main/general/logo-light.png',250.56,250.56,0.00,0.00,NULL,4,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',62.64,'CES (Consumer Electronics Show)','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',62.64,62.64,0.00,0.00,NULL,5,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',62.64,'CES (Consumer Electronics Show)','Miss Antonia Rau PhD','shania.gislason@zulauf.com',NULL,'ArchiElite','main/general/logo-light.png',187.92,187.92,0.00,0.00,NULL,6,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',62.64,'CES (Consumer Electronics Show)','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',250.56,250.56,0.00,0.00,NULL,7,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',62.64,'CES (Consumer Electronics Show)','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',250.56,250.56,0.00,0.00,NULL,8,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',62.64,'CES (Consumer Electronics Show)','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',250.56,250.56,0.00,0.00,NULL,9,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',62.64,'CES (Consumer Electronics Show)','Miss Antonia Rau PhD','shania.gislason@zulauf.com',NULL,'ArchiElite','main/general/logo-light.png',250.56,250.56,0.00,0.00,NULL,10,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',65.95,'Mobile World Congress','Miss Antonia Rau PhD','shania.gislason@zulauf.com',NULL,'ArchiElite','main/general/logo-light.png',263.80,263.80,0.00,0.00,NULL,11,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',65.95,'Mobile World Congress','Gerry Nienow','beth.spinka@lueilwitz.com',NULL,'ArchiElite','main/general/logo-light.png',131.90,131.90,0.00,0.00,NULL,12,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',65.95,'Mobile World Congress','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',131.90,131.90,0.00,0.00,NULL,13,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',65.95,'Mobile World Congress','Neil Shanahan','paltenwerth@stroman.com',NULL,'ArchiElite','main/general/logo-light.png',131.90,131.90,0.00,0.00,NULL,14,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:09'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',65.95,'Mobile World Congress','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',263.80,263.80,0.00,0.00,NULL,15,'completed','2025-06-10 10:47:09','2025-06-10 10:47:09','2025-06-10 10:47:10'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',65.95,'Mobile World Congress','Prof. Dax Kemmer','friesen.aleen@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',65.95,65.95,0.00,0.00,NULL,16,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',65.95,'Mobile World Congress','Mr. Delmer Grant','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',263.80,263.80,0.00,0.00,NULL,17,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',65.95,'Mobile World Congress','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',329.75,329.75,0.00,0.00,NULL,18,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',65.95,'Mobile World Congress','Miss Antonia Rau PhD','shania.gislason@zulauf.com',NULL,'ArchiElite','main/general/logo-light.png',263.80,263.80,0.00,0.00,NULL,19,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',65.95,'Mobile World Congress','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',65.95,65.95,0.00,0.00,NULL,20,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',1.37,'Google I/O','Mr. Delmer Grant','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',6.85,6.85,0.00,0.00,NULL,21,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',1.37,'Google I/O','Monte Schinner','khalil.will@mann.biz',NULL,'ArchiElite','main/general/logo-light.png',4.11,4.11,0.00,0.00,NULL,22,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',1.37,'Google I/O','Prof. Dax Kemmer','friesen.aleen@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',6.85,6.85,0.00,0.00,NULL,23,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',1.37,'Google I/O','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',4.11,4.11,0.00,0.00,NULL,24,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',1.37,'Google I/O','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',2.74,2.74,0.00,0.00,NULL,25,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',1.37,'Google I/O','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',2.74,2.74,0.00,0.00,NULL,26,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',1.37,'Google I/O','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',1.37,1.37,0.00,0.00,NULL,27,'completed','2025-06-10 10:47:10','2025-06-10 10:47:10','2025-06-10 10:47:10'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',1.37,'Google I/O','Prof. Dax Kemmer','friesen.aleen@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',5.48,5.48,0.00,0.00,NULL,28,'completed','2025-06-10 10:47:11','2025-06-10 10:47:10','2025-06-10 10:47:11'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',1.37,'Google I/O','Mr. Ted Frami III','yturcotte@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',5.48,5.48,0.00,0.00,NULL,29,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',1.37,'Google I/O','Miss Antonia Rau PhD','shania.gislason@zulauf.com',NULL,'ArchiElite','main/general/logo-light.png',1.37,1.37,0.00,0.00,NULL,30,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',45.37,'Apple WWDC','Miss Antonia Rau PhD','shania.gislason@zulauf.com',NULL,'ArchiElite','main/general/logo-light.png',181.48,181.48,0.00,0.00,NULL,31,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',45.37,'Apple WWDC','Monte Schinner','khalil.will@mann.biz',NULL,'ArchiElite','main/general/logo-light.png',90.74,90.74,0.00,0.00,NULL,32,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',45.37,'Apple WWDC','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',181.48,181.48,0.00,0.00,NULL,33,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',45.37,'Apple WWDC','Prof. Dax Kemmer','friesen.aleen@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',226.85,226.85,0.00,0.00,NULL,34,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',45.37,'Apple WWDC','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',136.11,136.11,0.00,0.00,NULL,35,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',45.37,'Apple WWDC','Neil Shanahan','paltenwerth@stroman.com',NULL,'ArchiElite','main/general/logo-light.png',226.85,226.85,0.00,0.00,NULL,36,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',45.37,'Apple WWDC','Monte Schinner','khalil.will@mann.biz',NULL,'ArchiElite','main/general/logo-light.png',136.11,136.11,0.00,0.00,NULL,37,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',45.37,'Apple WWDC','Mr. Ted Frami III','yturcotte@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',45.37,45.37,0.00,0.00,NULL,38,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',45.37,'Apple WWDC','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',226.85,226.85,0.00,0.00,NULL,39,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',45.37,'Apple WWDC','Miss Antonia Rau PhD','shania.gislason@zulauf.com',NULL,'ArchiElite','main/general/logo-light.png',226.85,226.85,0.00,0.00,NULL,40,'completed','2025-06-10 10:47:11','2025-06-10 10:47:11','2025-06-10 10:47:11'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',77.82,'AWS re:Invent','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',77.82,77.82,0.00,0.00,NULL,41,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',77.82,'AWS re:Invent','Neil Shanahan','paltenwerth@stroman.com',NULL,'ArchiElite','main/general/logo-light.png',389.10,389.10,0.00,0.00,NULL,42,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',77.82,'AWS re:Invent','Mr. Ted Frami III','yturcotte@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',77.82,77.82,0.00,0.00,NULL,43,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',77.82,'AWS re:Invent','Monte Schinner','khalil.will@mann.biz',NULL,'ArchiElite','main/general/logo-light.png',311.28,311.28,0.00,0.00,NULL,44,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',77.82,'AWS re:Invent','Mr. Delmer Grant','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',233.46,233.46,0.00,0.00,NULL,45,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',77.82,'AWS re:Invent','Mr. Ted Frami III','yturcotte@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',155.64,155.64,0.00,0.00,NULL,46,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',77.82,'AWS re:Invent','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',155.64,155.64,0.00,0.00,NULL,47,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',77.82,'AWS re:Invent','Melany Greenfelder','keeley.mertz@bins.info',NULL,'ArchiElite','main/general/logo-light.png',155.64,155.64,0.00,0.00,NULL,48,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',77.82,'AWS re:Invent','Velva Bernhard','vschumm@green.com',NULL,'ArchiElite','main/general/logo-light.png',233.46,233.46,0.00,0.00,NULL,49,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',77.82,'AWS re:Invent','Monte Schinner','khalil.will@mann.biz',NULL,'ArchiElite','main/general/logo-light.png',389.10,389.10,0.00,0.00,NULL,50,'completed','2025-06-10 10:47:12','2025-06-10 10:47:12','2025-06-10 10:47:12');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'KTUAXUMBGQSQ','098d328c-2c08-44b5-8c06-e61d5e83a1ae',1,'CES (Consumer Electronics Show)',62.64,26,1,'Neil Shanahan','paltenwerth@stroman.com','In the very tones of the song, perhaps?\' \'I\'ve heard something like it,\' said Alice to herself.',NULL,'1',62.64,4,250.56,250.56,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08'),(2,'A52XCCFZYBZB','af1fa801-4341-424e-9b27-0308aee651c2',1,'CES (Consumer Electronics Show)',62.64,14,1,'Prof. Dax Kemmer','friesen.aleen@kilback.com','I don\'t think,\' Alice went on, \'you see, a dog growls when it\'s angry, and wags its tail when it\'s.',NULL,'2',62.64,2,125.28,125.28,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08'),(3,'VGXTIY33GVJV','828e84a0-7718-4953-bad4-e7f2aecd3353',1,'CES (Consumer Electronics Show)',62.64,5,1,'Melany Greenfelder','keeley.mertz@bins.info','King. Here one of the busy farm-yard--while the lowing of the tea--\' \'The twinkling of the tea--\'.',NULL,'3',62.64,1,62.64,62.64,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(4,'TE7UBSSJ4UCH','05a6a901-27f5-4d74-abd6-aa4d32f92e4d',1,'CES (Consumer Electronics Show)',62.64,28,1,'Monte Schinner','khalil.will@mann.biz','Hearts, carrying the King\'s crown on a crimson velvet cushion; and, last of all the jurymen are.',NULL,'4',62.64,4,250.56,250.56,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(5,'F0BI1NBGPPWR','b73a369c-bde0-414a-ac60-d840f043ae08',1,'CES (Consumer Electronics Show)',62.64,5,1,'Melany Greenfelder','keeley.mertz@bins.info','The Queen had ordered. They very soon came upon a low voice. \'Not at all,\' said the Gryphon.',NULL,'5',62.64,1,62.64,62.64,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(6,'EZKZCPFTQNCK','ccc4527d-15cb-4b0e-8fa8-eef453091cf4',1,'CES (Consumer Electronics Show)',62.64,15,1,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','Alice began telling them her adventures from the sky! Ugh, Serpent!\' \'But I\'m NOT a serpent, I.',NULL,'6',62.64,3,187.92,187.92,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(7,'G9R2C1L6RXIJ','913fb58c-f3d7-4b34-8715-dfef07cc3865',1,'CES (Consumer Electronics Show)',62.64,5,1,'Melany Greenfelder','keeley.mertz@bins.info','What would become of you? I gave her answer. \'They\'re done with a trumpet in one hand and a scroll.',NULL,'7',62.64,4,250.56,250.56,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(8,'M81XD5Q28VKX','ca091330-3caa-4bf2-b24a-25787f0c2e29',1,'CES (Consumer Electronics Show)',62.64,27,1,'Velva Bernhard','vschumm@green.com','Suddenly she came rather late, and the arm that was sitting on a crimson velvet cushion; and, last.',NULL,'8',62.64,4,250.56,250.56,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(9,'V5K8JMOQMCD4','371c3f4f-b330-4584-8a10-175939197b5d',1,'CES (Consumer Electronics Show)',62.64,5,1,'Melany Greenfelder','keeley.mertz@bins.info','Alice did not seem to come yet, please your Majesty,\' said the Mock Turtle is.\' \'It\'s the oldest.',NULL,'9',62.64,4,250.56,250.56,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(10,'9KE16IKC0QBZ','67659246-f5d6-4aa9-9a0c-46d37c037768',1,'CES (Consumer Electronics Show)',62.64,15,1,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','Hatter. He came in with the end of your flamingo. Shall I try the experiment?\' \'HE might bite,\'.',NULL,'10',62.64,4,250.56,250.56,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(11,'QT5DEMZ1PSQF','82adaee3-be0f-4cb1-b436-c7013ece0d1e',2,'Mobile World Congress',65.95,15,1,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','Adventures of hers would, in the same tone, exactly as if he wasn\'t going to leave it behind?\' She.',NULL,'11',65.95,4,263.80,263.80,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(12,'MNQAOCIMNUSE','34bfb5b8-68a4-49fd-8946-ffc3b82c37a7',2,'Mobile World Congress',65.95,23,1,'Gerry Nienow','beth.spinka@lueilwitz.com','I don\'t think,\' Alice went on, \'that they\'d let Dinah stop in the other. In the very tones of her.',NULL,'12',65.95,2,131.90,131.90,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(13,'BVQF2EDCBAGE','0c61ee77-86eb-44ca-8515-fbf096309045',2,'Mobile World Congress',65.95,27,1,'Velva Bernhard','vschumm@green.com','Alice: \'--where\'s the Duchess?\' \'Hush! Hush!\' said the King. \'It began with the Mouse only shook.',NULL,'13',65.95,2,131.90,131.90,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(14,'ZQU5SYSZSYZG','9620d66e-8152-47b9-bab8-58be274d05b4',2,'Mobile World Congress',65.95,26,1,'Neil Shanahan','paltenwerth@stroman.com','Shall I try the experiment?\' \'HE might bite,\' Alice cautiously replied: \'but I know I do!\' said.',NULL,'14',65.95,2,131.90,131.90,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(15,'JNE1JAXR3NI4','a6a06fff-dbd5-45d9-b63b-824211391cb6',2,'Mobile World Congress',65.95,27,1,'Velva Bernhard','vschumm@green.com','I might venture to go through next walking about at the cook, to see it written down: but I THINK.',NULL,'15',65.95,4,263.80,263.80,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09'),(16,'KIFX0JFOAESK','16bf11e5-28f9-4dc1-8735-16bb23d29c1c',2,'Mobile World Congress',65.95,14,1,'Prof. Dax Kemmer','friesen.aleen@kilback.com','Gryphon is, look at them--\'I wish they\'d get the trial one way of nursing it, (which was to get.',NULL,'16',65.95,1,65.95,65.95,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(17,'AO2AGMXIVOMF','09af13ea-9dad-4acd-890b-9ec1486eae4a',2,'Mobile World Congress',65.95,1,1,'Mr. Delmer Grant','customer@archielite.com','VERY remarkable in that; nor did Alice think it was,\' said the Hatter hurriedly left the court.',NULL,'17',65.95,4,263.80,263.80,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(18,'RWVVVNZAQLGT','175684ab-d489-4e66-95e4-d50fbd083e13',2,'Mobile World Congress',65.95,27,1,'Velva Bernhard','vschumm@green.com','Rabbit began. Alice gave a little of her sharp little chin into Alice\'s shoulder as he came, \'Oh!.',NULL,'18',65.95,5,329.75,329.75,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(19,'56TAGX8MPISC','d49a3b85-e0a0-42de-b094-c457540f595c',2,'Mobile World Congress',65.95,15,1,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','I wonder what you\'re doing!\' cried Alice, quite forgetting in the distance, screaming with.',NULL,'19',65.95,4,263.80,263.80,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(20,'F7M8JNBL4M5E','b9d9ac80-91c5-4ae7-a84f-4a7d19f4a29e',2,'Mobile World Congress',65.95,27,1,'Velva Bernhard','vschumm@green.com','I? Ah, THAT\'S the great wonder is, that there\'s any one of the wood for fear of their hearing her.',NULL,'20',65.95,1,65.95,65.95,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(21,'WFDRHW4RUNLB','be395cb9-fb41-4a12-9554-b7595b189e49',3,'Google I/O',1.37,1,1,'Mr. Delmer Grant','customer@archielite.com','She was a dead silence instantly, and neither of the cupboards as she ran; but the great concert.',NULL,'21',1.37,5,6.85,6.85,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(22,'SOADQRKHUDVR','6ac64d0d-f14a-4bff-a9e9-65fe78771ab1',3,'Google I/O',1.37,28,1,'Monte Schinner','khalil.will@mann.biz','But said I could show you our cat Dinah: I think I may as well as she went to school every day--\'.',NULL,'22',1.37,3,4.11,4.11,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(23,'NHFQDAI2UXGS','cb98646e-2344-43f9-be11-6777ce6fc05a',3,'Google I/O',1.37,14,1,'Prof. Dax Kemmer','friesen.aleen@kilback.com','How brave they\'ll all think me for asking! No, it\'ll never do to hold it. As soon as she could.',NULL,'23',1.37,5,6.85,6.85,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(24,'EXO91ADGF8SB','d7592b86-98af-4c8a-bdaa-9c5142b36c04',3,'Google I/O',1.37,27,1,'Velva Bernhard','vschumm@green.com','Dormouse! Turn that Dormouse out of court! Suppress him! Pinch him! Off with his whiskers!\' For.',NULL,'24',1.37,3,4.11,4.11,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(25,'HCPGLBAASOS8','432f8a8a-3153-41a8-8585-25e2448f6988',3,'Google I/O',1.37,5,1,'Melany Greenfelder','keeley.mertz@bins.info','Alice to herself, \'whenever I eat or drink something or other; but the Dormouse began in a rather.',NULL,'25',1.37,2,2.74,2.74,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(26,'VKQAZXOSXLML','74e7be29-bde6-4ecb-b77a-5e57673cdf71',3,'Google I/O',1.37,5,1,'Melany Greenfelder','keeley.mertz@bins.info','Indeed, she had grown in the long hall, and close to the waving of the birds hurried off at once.',NULL,'26',1.37,2,2.74,2.74,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(27,'Z7AFOJ3DVIX5','efed6cb3-5a75-46d6-bbe4-afbcf69425d4',3,'Google I/O',1.37,5,1,'Melany Greenfelder','keeley.mertz@bins.info','Duchess. \'I make you grow taller, and the second verse of the evening, beautiful Soup!.',NULL,'27',1.37,1,1.37,1.37,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(28,'LSPDYMAIMMYI','8d99eeae-c737-4b28-a2fa-19358b15630f',3,'Google I/O',1.37,14,1,'Prof. Dax Kemmer','friesen.aleen@kilback.com','Latitude was, or Longitude either, but thought they were playing the Queen merely remarking as it.',NULL,'28',1.37,4,5.48,5.48,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10'),(29,'IABP6O8KFSUP','282c06bc-89db-4e4a-8070-1cc5ab75991f',3,'Google I/O',1.37,31,1,'Mr. Ted Frami III','yturcotte@yahoo.com','Alice. \'Then it ought to have the experiment tried. \'Very true,\' said the White Rabbit blew three.',NULL,'29',1.37,4,5.48,5.48,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(30,'NLQXSG68ASJO','fa76b84e-ea3d-4a07-a4c2-597e0cfcf90d',3,'Google I/O',1.37,15,1,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','Like a tea-tray in the air. Even the Duchess began in a deep sigh, \'I was a bright brass plate.',NULL,'30',1.37,1,1.37,1.37,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(31,'IRJVZ6T11T69','ee79e835-9030-4f11-88f1-2608b94fd457',4,'Apple WWDC',45.37,15,1,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','Improve his shining tail, And pour the waters of the soldiers remaining behind to execute the.',NULL,'31',45.37,4,181.48,181.48,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(32,'HGCXCAG2TQRR','46c55a12-e08e-41a5-adb7-c4fc184d3d74',4,'Apple WWDC',45.37,28,1,'Monte Schinner','khalil.will@mann.biz','They are waiting on the door of which was lit up by a very short time the Queen say only yesterday.',NULL,'32',45.37,2,90.74,90.74,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(33,'ZSFYDJKCUL3J','e9efb1a7-7d3e-4ceb-a006-2abe82a64ce6',4,'Apple WWDC',45.37,27,1,'Velva Bernhard','vschumm@green.com','I grow at a reasonable pace,\' said the Hatter. \'Nor I,\' said the March Hare: she thought it had no.',NULL,'33',45.37,4,181.48,181.48,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(34,'EKSMHVRJG2AD','d2323087-36e1-4048-91e1-1ef3a045f9ff',4,'Apple WWDC',45.37,14,1,'Prof. Dax Kemmer','friesen.aleen@kilback.com','Dormouse go on till you come to the Queen. \'Well, I hardly know--No more, thank ye; I\'m better.',NULL,'34',45.37,5,226.85,226.85,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(35,'TNKVP6UXRTYX','f2ca8e54-96f0-496f-a0da-2d3d4a0f6f12',4,'Apple WWDC',45.37,5,1,'Melany Greenfelder','keeley.mertz@bins.info','Gryphon: \'I went to work very carefully, with one foot. \'Get up!\' said the Knave, \'I didn\'t know.',NULL,'35',45.37,3,136.11,136.11,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(36,'4YQIVAOR0MMX','9507a448-6843-428e-b6a5-96993fda636e',4,'Apple WWDC',45.37,26,1,'Neil Shanahan','paltenwerth@stroman.com','Queen. \'Never!\' said the Mock Turtle. \'Certainly not!\' said Alice indignantly. \'Let me alone!\'.',NULL,'36',45.37,5,226.85,226.85,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(37,'DUFAKXPYSXOX','83c7b8e1-012a-445f-8f6f-1e629f2ffc5a',4,'Apple WWDC',45.37,28,1,'Monte Schinner','khalil.will@mann.biz','Alice did not answer, so Alice ventured to say. \'What is his sorrow?\' she asked the Gryphon, and.',NULL,'37',45.37,3,136.11,136.11,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(38,'JIZ3JVJKU2EV','42d411f5-c47c-40a0-92bf-864c8491f213',4,'Apple WWDC',45.37,31,1,'Mr. Ted Frami III','yturcotte@yahoo.com','Alice cautiously replied: \'but I haven\'t been invited yet.\' \'You\'ll see me there,\' said the.',NULL,'38',45.37,1,45.37,45.37,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(39,'XMGBGWPNIWD3','17c67357-d7bd-4e7c-97a0-4e9c53e7779f',4,'Apple WWDC',45.37,27,1,'Velva Bernhard','vschumm@green.com','Alice: \'allow me to him: She gave me a good way off, panting, with its tongue hanging out of the.',NULL,'39',45.37,5,226.85,226.85,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(40,'HIXWI70FS11R','638eab36-0d24-48de-94a6-d3a9f4ccc3be',4,'Apple WWDC',45.37,15,1,'Miss Antonia Rau PhD','shania.gislason@zulauf.com','Duchess, digging her sharp little chin into Alice\'s shoulder as she went out, but it had entirely.',NULL,'40',45.37,5,226.85,226.85,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11'),(41,'B2HXQ9GKCGBL','108f352b-0164-40ca-a11c-2be98c2e814b',5,'AWS re:Invent',77.82,5,1,'Melany Greenfelder','keeley.mertz@bins.info','YOU do it!--That I won\'t, then!--Bill\'s to go near the entrance of the shepherd boy--and the.',NULL,'41',77.82,1,77.82,77.82,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(42,'EKCZXJ4YI0WO','8f9f880c-74c3-499f-b92c-5f9808ca90a8',5,'AWS re:Invent',77.82,26,1,'Neil Shanahan','paltenwerth@stroman.com','Rabbit say, \'A barrowful of WHAT?\' thought Alice \'without pictures or conversations in it, \'and.',NULL,'42',77.82,5,389.10,389.10,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(43,'FTL3BOJVBVPV','8d300f5e-7c3d-45a1-999d-59fe636055bf',5,'AWS re:Invent',77.82,31,1,'Mr. Ted Frami III','yturcotte@yahoo.com','Alice aloud, addressing nobody in particular. \'She\'d soon fetch it back!\' \'And who is to France.',NULL,'43',77.82,1,77.82,77.82,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(44,'I3EUBZJSIPYO','76decdbb-14d4-4999-bb89-6d6c133fca20',5,'AWS re:Invent',77.82,28,1,'Monte Schinner','khalil.will@mann.biz','Cheshire Cat, she was nine feet high, and was delighted to find herself still in sight, and no.',NULL,'44',77.82,4,311.28,311.28,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(45,'6QAOHBHCKH7T','c2217253-79df-459e-982a-a804e81d10f8',5,'AWS re:Invent',77.82,1,1,'Mr. Delmer Grant','customer@archielite.com','EVER happen in a tone of delight, and rushed at the door of which was lit up by two guinea-pigs.',NULL,'45',77.82,3,233.46,233.46,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(46,'FAKFQ1KGX34U','73a85f3b-f0c6-4603-98a0-2649ae3d2dc3',5,'AWS re:Invent',77.82,31,1,'Mr. Ted Frami III','yturcotte@yahoo.com','Mock Turtle to the other, and making quite a commotion in the shade: however, the moment she.',NULL,'46',77.82,2,155.64,155.64,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(47,'FS5AOCUICBAF','135b959c-c7eb-482a-a0be-2d89eca9dd5f',5,'AWS re:Invent',77.82,5,1,'Melany Greenfelder','keeley.mertz@bins.info','Alice, who felt very lonely and low-spirited. In a little of the leaves: \'I should like to be.',NULL,'47',77.82,2,155.64,155.64,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(48,'A1LNPZ1TXW0Q','b2a6706b-c737-4e2c-8d98-3aa42365cb87',5,'AWS re:Invent',77.82,5,1,'Melany Greenfelder','keeley.mertz@bins.info','Caterpillar, and the other birds tittered audibly. \'What I was going to leave it behind?\' She said.',NULL,'48',77.82,2,155.64,155.64,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(49,'DKLEXIO71FI5','00dbd111-caeb-48cd-a7f4-56d1cdbafcee',5,'AWS re:Invent',77.82,27,1,'Velva Bernhard','vschumm@green.com','See how eagerly the lobsters and the Panther received knife and fork with a large flower-pot that.',NULL,'49',77.82,3,233.46,233.46,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12'),(50,'JLJLZHUKV3WA','80aa0fd3-9e4b-41d9-adfa-e5dd885ed739',5,'AWS re:Invent',77.82,28,1,'Monte Schinner','khalil.will@mann.biz','King, looking round the court was a large canvas bag, which tied up at the Hatter, and here the.',NULL,'50',77.82,5,389.10,389.10,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'JWLKNDXJ67SA','Alivia Borer MD','ryan.jovani@gmail.com','0978677160','White Rabbit, trotting slowly back to the table, half hoping that they had to pinch it to be.',NULL,'refunded','2025-06-10 10:47:08','2025-06-10 10:47:08'),(2,1,'HT5HFGRR9LLI','Rachel Kunde','schaefer.gillian@gmail.com','0232305565','Do you think, at your age, it is all the things being alive; for instance, there\'s the arch I\'ve.',NULL,'reserved','2025-06-10 10:47:08','2025-06-10 10:47:08'),(3,1,'H1PJLTZGPM9U','Kavon Nikolaus','zpouros@okeefe.com','0793140465','The only things in the sun. (IF you don\'t explain it is you hate--C and D,\' she added in a hot.',NULL,'cancelled','2025-06-10 10:47:08','2025-06-10 10:47:08'),(4,1,'J8TCGMOAZDPW','Prof. Joshua Sauer','oheathcote@rodriguez.com','0878605886','I\'ve fallen by this time?\' she said to herself, in a solemn tone, only changing the order of the.',NULL,'refunded','2025-06-10 10:47:08','2025-06-10 10:47:08'),(5,1,'FTKXZCBQNNVV','Veronica Pfannerstill Sr.','gutkowski.elmer@hotmail.com','0592605453','I\'m pleased, and wag my tail when I\'m angry. Therefore I\'m mad.\' \'I call it purring, not.',NULL,'refunded','2025-06-10 10:47:08','2025-06-10 10:47:08'),(6,2,'HCTOH6YA2C1T','Ashly Ratke IV','jones.pinkie@hotmail.com','0426558504','Soup, so rich and green, Waiting in a frightened tone. \'The Queen of Hearts, and I shall fall.',NULL,'checked_in','2025-06-10 10:47:08','2025-06-10 10:47:08'),(7,2,'QIAXXKCAX406','Prof. Demarco Metz','frank14@gmail.com','0825338606','He says it kills all the jurors had a wink of sleep these three weeks!\' \'I\'m very sorry you\'ve.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(8,2,'YEGFCOQJFTAX','Prof. Fannie Wolf PhD','joana.roberts@yahoo.com','0481750413','So you see, because some of them didn\'t know how to get out of court! Suppress him! Pinch him! Off.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(9,3,'GDX7MRYGKHF9','Ibrahim VonRueden','mayer.sandy@jacobi.net','0454590949','Alice looked very uncomfortable. The moment Alice appeared, she was quite surprised to see a.',NULL,'refunded','2025-06-10 10:47:09','2025-06-10 10:47:09'),(10,3,'G6CHG81ENPKH','Dr. Rogers Bosco','mquitzon@russel.info','0678790501','It quite makes my forehead ache!\' Alice watched the Queen had ordered. They very soon had to do.',NULL,'purchased','2025-06-10 10:47:09','2025-06-10 10:47:09'),(11,4,'QAM8D4PMFE3Y','Prof. Christa Kovacek','magdalena89@wintheiser.com','0077807263','She was a good deal frightened at the stick, and tumbled head over heels in its sleep \'Twinkle.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(12,4,'PZ2EGTQH49T1','Dameon Koepp','lilla27@gmail.com','0216497335','MUST be more to come, so she went down on one knee as he could think of anything to put the hookah.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(13,4,'F9EKPXTSHO1G','Kristopher Leannon','kling.berenice@yahoo.com','0897012275','Mouse. \'--I proceed. \"Edwin and Morcar, the earls of Mercia and Northumbria, declared for him: and.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(14,4,'HSZFALNTOEZT','Rudy Spinka','ayana.mraz@morissette.com','0586415748','See how eagerly the lobsters and the Hatter added as an unusually large saucepan flew close by it.',NULL,'cancelled','2025-06-10 10:47:09','2025-06-10 10:47:09'),(15,4,'VCOTS7URS2MP','Alverta Wintheiser','kamron.carter@yahoo.com','0511081476','Alice asked. \'We called him a fish)--and rapped loudly at the great puzzle!\' And she kept tossing.',NULL,'purchased','2025-06-10 10:47:09','2025-06-10 10:47:09'),(16,5,'OI3YT1XXGTKF','Dr. Ricardo Leannon V','owhite@walker.com','0918331875','Alice hastily replied; \'at least--at least I know I have ordered\'; and she was near enough to try.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(17,5,'ZLKRLGQIRMY7','Mr. Dayton Nolan PhD','jschuster@yahoo.com','0714236624','Gryphon repeated impatiently: \'it begins \"I passed by his garden.\"\' Alice did not at all like the.',NULL,'cancelled','2025-06-10 10:47:09','2025-06-10 10:47:09'),(18,6,'AFJCGI5X3UV9','Irving Jakubowski','johnson.margarete@gmail.com','0661856998','Caterpillar. \'Not QUITE right, I\'m afraid,\' said Alice, a good thing!\' she said to the end of the.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(19,6,'YCFGX6BXXANK','Cara Streich','oswaldo70@hotmail.com','0400622821','I might venture to ask his neighbour to tell its age, there was mouth enough for it flashed across.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(20,6,'QAAJOH2WPV55','Norwood Senger','dvolkman@yahoo.com','0158461100','I was, I shouldn\'t like THAT!\' \'Oh, you foolish Alice!\' she answered herself. \'How can you learn.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(21,6,'YLVWKEAWLGK6','Mr. Merlin Mills','nluettgen@prosacco.com','0127281659','And she\'s such a new idea to Alice, \'Have you seen the Mock Turtle. So she called softly after it.',NULL,'cancelled','2025-06-10 10:47:09','2025-06-10 10:47:09'),(22,7,'LIJLARLHR1WL','Wilburn Barton Sr.','augustus53@yahoo.com','0440398150','Alice whispered to the shore. CHAPTER III. A Caucus-Race and a pair of the jurymen. \'No, they\'re.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(23,7,'YPYWNGKTC8I4','Arnulfo Reynolds PhD','ogusikowski@hotmail.com','0883724235','EVEN finish, if he would deny it too: but the Rabbit in a hot tureen! Who for such dainties would.',NULL,'purchased','2025-06-10 10:47:09','2025-06-10 10:47:09'),(24,7,'CQE5ULD8FL93','Keven Hamill','gregoria00@hotmail.com','0449022899','Dodo. Then they all stopped and looked anxiously at the time they had settled down again very.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(25,7,'X015GPCGJL1J','Mr. Colin Leannon','pouros.angus@gmail.com','0049385259','Alice thought decidedly uncivil. \'But perhaps he can\'t help it,\' said the Caterpillar. Here was.',NULL,'refunded','2025-06-10 10:47:09','2025-06-10 10:47:09'),(26,7,'OJ1DXRFQLH4Z','Finn Bradtke','damore.winston@auer.com','0625654049','Caterpillar decidedly, and there stood the Queen shouted at the great question certainly was.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(27,8,'BGZSOEMHKT8Y','Aiden Monahan','axel06@yahoo.com','0284459007','Cheshire Cat: now I shall be late!\' (when she thought it would feel with all her wonderful.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(28,8,'YBIJ2RLXP4ML','Marcella Kohler','goyette.loyce@gmail.com','0667232623','I should have croqueted the Queen\'s ears--\' the Rabbit was no \'One, two, three, and away,\' but.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(29,8,'W4H688WIJSKP','Bennie Marvin','vincent06@fritsch.com','0008120923','CHAPTER IX. The Mock Turtle Soup is made from,\' said the White Rabbit, trotting slowly back again.',NULL,'cancelled','2025-06-10 10:47:09','2025-06-10 10:47:09'),(30,8,'NSXKEDSQ7RGA','Aliyah Schiller','icremin@gmail.com','0446292870','Alice. \'You are,\' said the Mouse, who seemed to be two people! Why, there\'s hardly room for this.',NULL,'cancelled','2025-06-10 10:47:09','2025-06-10 10:47:09'),(31,8,'7VFWCKHSDTQH','Miss Estefania Rohan Jr.','vincenza.kuvalis@yahoo.com','0742910134','However, this bottle does. I do so like that curious song about the right size, that it might end.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(32,9,'BLFNQX43EFUB','Sven Stehr','ibeier@marquardt.com','0142605709','Alice\'s elbow was pressed so closely against her foot, that there ought! And when I find a thing,\'.',NULL,'refunded','2025-06-10 10:47:09','2025-06-10 10:47:09'),(33,9,'PORXUJOHJQXA','Marcos Murazik','jborer@marks.com','0980159910','Alice. \'And where HAVE my shoulders got to? And oh, I wish you wouldn\'t mind,\' said Alice: \'allow.',NULL,'cancelled','2025-06-10 10:47:09','2025-06-10 10:47:09'),(34,9,'KEMERP8OUOXK','Carol O\'Hara','ymarvin@durgan.info','0554119682','Mouse, in a bit.\' \'Perhaps it doesn\'t matter a bit,\' she thought there was nothing else to do, and.',NULL,'purchased','2025-06-10 10:47:09','2025-06-10 10:47:09'),(35,9,'9JUJDSDA21BT','Prof. Mossie Feil Jr.','mbaumbach@keeling.com','0654452503','YOU like cats if you please! \"William the Conqueror, whose cause was favoured by the Hatter, it.',NULL,'checked_in','2025-06-10 10:47:09','2025-06-10 10:47:09'),(36,9,'QCN6TPD31SE9','Mr. Jonas Turcotte PhD','ariel.adams@bins.com','0626715176','French lesson-book. The Mouse looked at it, busily painting them red. Alice thought she might find.',NULL,'refunded','2025-06-10 10:47:09','2025-06-10 10:47:09'),(37,10,'AJ4WYT5UR2NB','Prof. Maurice Hammes III','qryan@hotmail.com','0346928174','March Hare and the shrill voice of the month, and doesn\'t tell what o\'clock it is!\' \'Why should.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(38,10,'HHQH9UKVMYB4','Dr. Alice Gutkowski','cathy84@bruen.com','0247771962','Allow me to introduce some other subject of conversation. \'Are you--are you fond--of--of dogs?\'.',NULL,'checked_in','2025-06-10 10:47:09','2025-06-10 10:47:09'),(39,10,'PQ5G25CARWED','Karine Smith','huels.trey@gmail.com','0167085782','You see the Queen. \'You make me smaller, I can do without lobsters, you know. Come on!\' \'Everybody.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(40,10,'XTUEIAS5XDAH','Ernestine Pacocha','achristiansen@durgan.com','0513917790','I get SOMEWHERE,\' Alice added as an explanation; \'I\'ve none of my life.\' \'You are all dry, he is.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(41,10,'FRLFBLKESJQN','Johanna Watsica','jovan77@gmail.com','0401091771','Alice, jumping up and said, very gravely, \'I think, you ought to be listening, so she helped.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(42,11,'4KBLJMI3XJJO','Dessie Lowe','reva.feeney@gmail.com','0979542109','Gryphon, the squeaking of the what?\' said the Hatter went on, \'\"--found it advisable to go on.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(43,11,'YJJXIIQBL3QX','Hollis Kertzmann','nicklaus14@bashirian.com','0215545470','March Hare, who had got burnt, and eaten up by wild beasts and other unpleasant things, all.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(44,11,'ZO1JC2W3RUB6','Mr. Timothy Wiza MD','kulas.kiarra@wilkinson.com','0392016507','Mock Turtle. So she sat down again very sadly and quietly, and looked into its eyes by this time.).',NULL,'cancelled','2025-06-10 10:47:09','2025-06-10 10:47:09'),(45,11,'VHXHZGC9WPM0','Liza Moore','kub.margarete@hotmail.com','0687914138','She gave me a pair of gloves and the White Rabbit, who was passing at the bottom of a tree in.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(46,11,'CRYRSUT29ULY','Prof. Abigail Hagenes','lilyan.glover@corwin.biz','0755077082','Duchess! Oh! won\'t she be savage if I\'ve kept her waiting!\' Alice felt dreadfully puzzled. The.',NULL,'checked_in','2025-06-10 10:47:09','2025-06-10 10:47:09'),(47,12,'J913IJPYFJA8','Flavie Denesik','torrance68@schuster.com','0543834939','His voice has a timid and tremulous sound.] \'That\'s different from what I should say \"With what.',NULL,'checked_in','2025-06-10 10:47:09','2025-06-10 10:47:09'),(48,12,'PPB9RZIAA7RB','Nora Rohan','cary.stoltenberg@predovic.com','0464992555','I\'m quite tired and out of breath, and said \'What else had you to set them free, Exactly as we.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(49,12,'QNNAVSIYPEN8','Felipa Murazik I','jtremblay@kessler.com','0192496212','Caterpillar sternly. \'Explain yourself!\' \'I can\'t explain MYSELF, I\'m afraid, sir\' said Alice, in.',NULL,'refunded','2025-06-10 10:47:09','2025-06-10 10:47:09'),(50,13,'VRA5VCENUZ6R','Mr. Cameron Wuckert','herman.edgardo@rosenbaum.org','0546010994','PLEASE mind what you\'re talking about,\' said Alice. \'Anything you like,\' said the Eaglet. \'I don\'t.',NULL,'checked_in','2025-06-10 10:47:09','2025-06-10 10:47:09'),(51,13,'SUJCWSCDRHWM','Hershel Cummerata','ipurdy@yahoo.com','0144148671','Take your choice!\' The Duchess took her choice, and was just possible it had no pictures or.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(52,13,'ZAVL3JYATBKT','Carmine Hilpert','hand.beverly@christiansen.info','0993829877','March Hare. The Hatter was out of the wood--(she considered him to you, Though they were filled.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(53,14,'UOLHBH0D3DL9','Amina Huels V','nettie.rogahn@larson.info','0291773871','Bill had left off sneezing by this time, and was going to turn round on its axis--\' \'Talking of.',NULL,'checked_in','2025-06-10 10:47:09','2025-06-10 10:47:09'),(54,14,'NZULEWD5DP9O','Quinten Daniel','shemar76@kessler.net','0977185337','Alice could see, when she caught it, and found that her shoulders were nowhere to be a great deal.',NULL,'transferred','2025-06-10 10:47:09','2025-06-10 10:47:09'),(55,14,'JE8ZWNOQFSU0','Kathryn Stiedemann','walsh.jon@tillman.biz','0119017374','Then she went on in the distance, and she swam about, trying to put his shoes on. \'--and just take.',NULL,'purchased','2025-06-10 10:47:09','2025-06-10 10:47:09'),(56,15,'51GRDEV2WWHC','Muriel Heller','verda02@ondricka.com','0762095637','Dormouse denied nothing, being fast asleep. \'After that,\' continued the Gryphon. \'They can\'t have.',NULL,'purchased','2025-06-10 10:47:09','2025-06-10 10:47:09'),(57,15,'0SRNUVHZLSF5','Mario Rodriguez Jr.','champlin.jerel@hotmail.com','0860631404','Alice did not like to drop the jar for fear of killing somebody, so managed to put it right; \'not.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(58,15,'SAIAWFBSSSVD','Dr. Samantha Kozey Jr.','qglover@hotmail.com','0438558176','And she began thinking over all she could not stand, and she had but to open it; but, as the whole.',NULL,'pending','2025-06-10 10:47:09','2025-06-10 10:47:09'),(59,15,'D7ECKL2YIVCR','Magali Lehner','hettinger.vida@morar.com','0542975876','For instance, if you were never even spoke to Time!\' \'Perhaps not,\' Alice replied very gravely.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(60,15,'XFZ48XDGBDZJ','Raheem Blick','angus31@yahoo.com','0560854270','Hatter. \'You might just as I do,\' said Alice aloud, addressing nobody in particular. \'She\'d soon.',NULL,'reserved','2025-06-10 10:47:09','2025-06-10 10:47:09'),(61,16,'TDFRR1GZCVQU','Lazaro Trantow','edamore@hotmail.com','0458664936','I don\'t understand. Where did they draw the treacle from?\' \'You can draw water out of the.',NULL,'cancelled','2025-06-10 10:47:10','2025-06-10 10:47:10'),(62,16,'MW1XFO4IU2IJ','Mr. Jarrod Collins','nikolas76@yahoo.com','0026315220','THAT like?\' said Alice. \'Come on, then,\' said the King, the Queen, \'and he shall tell you my.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(63,17,'QOFJT4XZFDGF','Brooklyn Ullrich','fheidenreich@gmail.com','0130383861','The Queen smiled and passed on. \'Who ARE you doing out here? Run home this moment, I tell you!\'.',NULL,'cancelled','2025-06-10 10:47:10','2025-06-10 10:47:10'),(64,17,'9HZNHFKXFGFT','Dr. Toy Purdy','elaina.mitchell@lubowitz.com','0070194190','Gryphon, sighing in his note-book, cackled out \'Silence!\' and read out from his book, \'Rule.',NULL,'pending','2025-06-10 10:47:10','2025-06-10 10:47:10'),(65,17,'RYWZMQOJT57Y','Ray Fay','skylar39@quitzon.info','0175117570','Alice! Come here directly, and get in at the door--I do wish they WOULD put their heads down! I am.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(66,17,'DTKLXXPOIQFU','Mrs. Aurore Stiedemann','gretchen.pfannerstill@effertz.biz','0455915072','MORE than nothing.\' \'Nobody asked YOUR opinion,\' said Alice. \'Anything you like,\' said the.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(67,17,'UWSE21QSQ2JZ','Jayce Hermiston','trantow.mae@hotmail.com','0540968377','On various pretexts they all moved off, and had just succeeded in curving it down \'important,\' and.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(68,18,'VFC9C4HRJSD3','Norval Senger','birdie.keeling@hotmail.com','0527155197','Grief, they used to know. Let me see--how IS it to half-past one as long as you liked.\' \'Is that.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(69,18,'S5SVGPHRLWNA','Grayson Fisher','clark.becker@von.com','0101847964','Mock Turtle sighed deeply, and began, in a whisper.) \'That would be the right distance--but then I.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(70,18,'39GJSR90TXMM','Irma Christiansen','jamal20@yahoo.com','0276641726','Queen: so she turned the corner, but the cook had disappeared. \'Never mind!\' said the Mock Turtle.',NULL,'purchased','2025-06-10 10:47:10','2025-06-10 10:47:10'),(71,18,'YHI8KW2ADKZD','Elody Rice','vabbott@gmail.com','0148369263','I suppose.\' So she began thinking over all the rest of the conversation. Alice felt so desperate.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(72,18,'PEEBR0CXRRD7','Jaden Koss','flabadie@hotmail.com','0632084398','Alice\'s head. \'Is that the Mouse heard this, it turned round and swam slowly back to the cur.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(73,18,'WPRZYIEFAS1B','Jamar Marquardt','sporer.tanner@deckow.info','0114140886','Knave. The Knave did so, and were quite silent, and looked at the end of the cupboards as she.',NULL,'refunded','2025-06-10 10:47:10','2025-06-10 10:47:10'),(74,19,'6OFQOH5SKL6Q','Ruby Rolfson','stracke.heath@yahoo.com','0346090630','Alice very politely; but she did not venture to say it out to sea as you might do something better.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(75,19,'4KDXQGHZTFRL','Madie Hickle','christiansen.flo@hotmail.com','0522332677','By the time he had a wink of sleep these three weeks!\' \'I\'m very sorry you\'ve been annoyed,\' said.',NULL,'purchased','2025-06-10 10:47:10','2025-06-10 10:47:10'),(76,19,'RSPGOXCQFWQV','Savion Schumm','cronin.geraldine@toy.com','0874342768','Dormouse; \'VERY ill.\' Alice tried to speak, and no room at all like the right size to do THAT in a.',NULL,'purchased','2025-06-10 10:47:10','2025-06-10 10:47:10'),(77,19,'BXAEAKAHMCBA','Stewart Wilkinson','ocie.crona@denesik.com','0153270675','She had not gone much farther before she made some tarts, All on a crimson velvet cushion; and.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(78,19,'KWC1SRHRNLJC','Deion Cruickshank','nils.powlowski@yahoo.com','0204094740','I got up this morning? I almost wish I hadn\'t drunk quite so much!\' Alas! it was growing, and she.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(79,20,'297QUZVZRC0U','Kyra Rempel','vtremblay@ullrich.biz','0721269155','Gryphon never learnt it.\' \'Hadn\'t time,\' said the King, and he called the Queen, turning purple.',NULL,'refunded','2025-06-10 10:47:10','2025-06-10 10:47:10'),(80,20,'PZDKOJSGTWE4','Prof. Dedrick Fay','leffler.frederic@gibson.com','0711909634','I shan\'t grow any more--As it is, I can\'t get out again. The rabbit-hole went straight on like a.',NULL,'refunded','2025-06-10 10:47:10','2025-06-10 10:47:10'),(81,21,'0GNQYOERZ3BS','Lonzo Friesen','xwaters@nolan.info','0927362940','Hatter. He came in sight of the Rabbit\'s voice; and Alice guessed who it was, and, as she was now.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(82,21,'QD4GVSJ6CDTH','Dewayne Kshlerin II','eddie.upton@hotmail.com','0494340684','Alice, \'we learned French and music.\' \'And washing?\' said the King, \'that saves a world of.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(83,21,'NX6QKMLHGF18','Zion Rice','bspinka@gmail.com','0601369292','Duchess was VERY ugly; and secondly, because she was holding, and she did not dare to disobey.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(84,21,'9PDGOMR4U0EP','Myra Mayer','tiara.nikolaus@skiles.com','0847477279','Queen to play croquet.\' Then they both sat silent for a conversation. Alice replied, rather shyly.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(85,21,'5NFS2VS2HVGQ','Zora Gottlieb','wwilkinson@borer.com','0738784000','Just then she walked up towards it rather timidly, as she could for sneezing. There was a large.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(86,21,'AHP3YM1ET8I6','Jalen Torphy','rlebsack@gmail.com','0493523927','King, the Queen, who were all ornamented with hearts. Next came the royal children; there were ten.',NULL,'purchased','2025-06-10 10:47:10','2025-06-10 10:47:10'),(87,22,'MWSM4A73LIFK','Syble Hermann','cummings.della@gmail.com','0087921370','I think you\'d better finish the story for yourself.\' \'No, please go on!\' Alice said very politely.',NULL,'cancelled','2025-06-10 10:47:10','2025-06-10 10:47:10'),(88,22,'8JMCTTBHSQ9T','Eileen Dickinson','kaylee37@zulauf.com','0449559623','Good-bye, feet!\' (for when she looked up eagerly, half hoping she might as well as the doubled-up.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(89,22,'WILIXAC5OGYM','Margaretta Lesch','kiara19@gmail.com','0789376629','King had said that day. \'No, no!\' said the Duchess, \'and that\'s a fact.\' Alice did not like to.',NULL,'cancelled','2025-06-10 10:47:10','2025-06-10 10:47:10'),(90,22,'DUAH7J6OGW8E','Joe Goldner','emelie.rice@yahoo.com','0813604616','I got up in her hands, and she walked up towards it rather timidly, saying to herself, \'Now, what.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(91,23,'DDB0TEZ3IOSA','Talon Mraz Jr.','qcorwin@wisoky.info','0054368969','Soup, so rich and green, Waiting in a great many more than nine feet high. \'I wish you were or.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(92,23,'N6ZGNIJFA9GH','Michel Emmerich','magnolia.hauck@yahoo.com','0550527974','That your eye was as long as you are; secondly, because they\'re making such a fall as this, I.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(93,23,'9YVKNJECZQFM','Kristian Wiegand','dkunze@hansen.net','0982605459','Pigeon. \'I can hardly breathe.\' \'I can\'t go no lower,\' said the Caterpillar. \'I\'m afraid I can\'t.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(94,23,'1MNC8G9SMFLA','Jan Walker','mandy.keeling@ratke.com','0151811063','ALL RETURNED FROM HIM TO YOU,\"\' said Alice. \'Why, you don\'t like it, yer honour, at all, as the.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(95,23,'E3BOKAQT9QPZ','Letitia Bruen V','coconner@yahoo.com','0907226990','And I declare it\'s too bad, that it ought to be a footman in livery came running out of the.',NULL,'pending','2025-06-10 10:47:10','2025-06-10 10:47:10'),(96,23,'JNLPPUCLZDTG','Dr. Lavina Koepp Sr.','natalia51@hotmail.com','0670326624','It\'s the most confusing thing I know. Silence all round, if you don\'t know what a dear quiet.',NULL,'cancelled','2025-06-10 10:47:10','2025-06-10 10:47:10'),(97,24,'MP3HYM5CD1RO','Mrs. Fabiola Krajcik V','ervin.runolfsdottir@yahoo.com','0674757887','For some minutes it seemed quite natural to Alice a little while, however, she again heard a.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(98,24,'MOUE6VGJNZ2Y','Tre Skiles Sr.','winfield.lang@gmail.com','0141138199','The Queen turned crimson with fury, and, after waiting till she had known them all her riper.',NULL,'checked_in','2025-06-10 10:47:10','2025-06-10 10:47:10'),(99,24,'4WC3R1ZMXLGV','Manuel Pagac DDS','agoyette@renner.com','0857368897','But she did not quite like the look of the e--e--evening, Beautiful, beautiful Soup! Beau--ootiful.',NULL,'pending','2025-06-10 10:47:10','2025-06-10 10:47:10'),(100,24,'XACS9RZ8IJI2','Dr. Jalon Bernier','neil02@hotmail.com','0924928921','IV. The Rabbit Sends in a melancholy air, and, after glaring at her rather inquisitively, and.',NULL,'cancelled','2025-06-10 10:47:10','2025-06-10 10:47:10'),(101,25,'CFY1MTFCIHCY','Prof. Charley Jacobson','veronica81@gmail.com','0634148855','Paris, and Paris is the reason is--\' here the conversation dropped, and the reason of that?\' \'In.',NULL,'purchased','2025-06-10 10:47:10','2025-06-10 10:47:10'),(102,25,'DQTL7SAW4XAQ','Emmalee Bode','friesen.domenick@damore.org','0099002883','I\'d only been the right house, because the Duchess was VERY ugly; and secondly, because they\'re.',NULL,'pending','2025-06-10 10:47:10','2025-06-10 10:47:10'),(103,25,'IEZSG70O3I4R','Wyatt O\'Conner II','ffranecki@yost.net','0197472988','Rabbit in a long, low hall, which was a child,\' said the Caterpillar. Alice said with a trumpet in.',NULL,'purchased','2025-06-10 10:47:10','2025-06-10 10:47:10'),(104,26,'YC83KJQ81MNN','Gerhard Rath','ressie20@hotmail.com','0967681237','Hatter, and here the Mock Turtle said: \'advance twice, set to work nibbling at the Queen, and in a.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(105,26,'LQVBXJYM9OMB','Mr. Christian Denesik','miracle26@strosin.com','0658297713','Queen\'s shrill cries to the beginning again?\' Alice ventured to remark. \'Tut, tut, child!\' said.',NULL,'refunded','2025-06-10 10:47:10','2025-06-10 10:47:10'),(106,26,'JEPYLGMDEL7P','Christopher Witting MD','mkoelpin@gmail.com','0744171668','Caterpillar. Alice said very politely, \'if I had it written down: but I hadn\'t cried so much!\'.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(107,27,'FZA2ERKWNEIF','Marcel Zieme IV','crooks.sid@mcclure.com','0567121225','YOUR adventures.\' \'I could tell you my adventures--beginning from this side of WHAT? The other.',NULL,'transferred','2025-06-10 10:47:10','2025-06-10 10:47:10'),(108,27,'OHZG3BBBNEZJ','Alba Kuvalis','yschinner@yahoo.com','0886223213','When the Mouse only shook its head impatiently, and said, \'That\'s right, Five! Always lay the.',NULL,'refunded','2025-06-10 10:47:10','2025-06-10 10:47:10'),(109,28,'3ZQQR6WXM4UT','Monica Schmidt','rath.bradford@gmail.com','0092894032','THAT like?\' said Alice. \'Then you shouldn\'t talk,\' said the King added in an offended tone, \'Hm!.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(110,28,'HJPMTOIU1F19','Ryder Moore','legros.alvina@block.com','0730138664','I was a general clapping of hands at this: it was her turn or not. \'Oh, PLEASE mind what you\'re.',NULL,'refunded','2025-06-10 10:47:10','2025-06-10 10:47:10'),(111,28,'UFFWAIKEABR9','Elsie Shields','crystal90@lynch.org','0422339099','The Duchess took no notice of them can explain it,\' said the King. \'It began with the day of the.',NULL,'reserved','2025-06-10 10:47:10','2025-06-10 10:47:10'),(112,28,'2IKDF9ZUPDRU','Mrs. Danielle Howe II','imurphy@watsica.com','0510265699','So they couldn\'t see it?\' So she set to work nibbling at the thought that SOMEBODY ought to be a.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(113,28,'WQ9S9FW0HKUG','Yolanda Stokes','frederique.wolff@king.org','0529659630','Alice, who was peeping anxiously into its nest. Alice crouched down among the leaves, which she.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(114,29,'N52JMEWMNWN5','Dr. Conrad McCullough','grant96@sauer.com','0455254111','So they began running about in the window?\' \'Sure, it\'s an arm for all that.\' \'Well, it\'s got no.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(115,29,'IP4UKGHPWUEV','Kayden Heller','bauch.dedrick@hotmail.com','0627807370','Dormouse shook itself, and was immediately suppressed by the carrier,\' she thought; \'and how funny.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(116,29,'J7DBYUMQZYR8','Cordie Ankunding','devan.larkin@gmail.com','0397007043','Duchess asked, with another dig of her favourite word \'moral,\' and the sounds will take care of.',NULL,'reserved','2025-06-10 10:47:11','2025-06-10 10:47:11'),(117,29,'TI5ERDHSJNFN','Arne Stroman','kiarra.murray@padberg.com','0197784094','Queen had only one way up as the White Rabbit put on your head-- Do you think you might like to.',NULL,'purchased','2025-06-10 10:47:11','2025-06-10 10:47:11'),(118,29,'JNYBDMSB1WQO','Juwan Gorczany','rath.emilie@yahoo.com','0917857097','Only I don\'t remember where.\' \'Well, it must make me larger, it must be getting home; the.',NULL,'reserved','2025-06-10 10:47:11','2025-06-10 10:47:11'),(119,30,'7SIAH8YBARSJ','Arnulfo O\'Keefe','vidal24@kutch.com','0545937443','Alice. \'Now we shall get on better.\' \'I\'d rather not,\' the Cat again, sitting on a summer day: The.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(120,30,'UDIBP0H7TG7O','Prof. Drake Kovacek Sr.','roy17@cremin.com','0858200017','Queen jumped up in a twinkling! Half-past one, time for dinner!\' (\'I only wish they WOULD go with.',NULL,'pending','2025-06-10 10:47:11','2025-06-10 10:47:11'),(121,31,'TFRXRELTYU9Q','Amina Marquardt','thea.grady@gmail.com','0391173843','Alice. \'Nothing,\' said Alice. \'I\'m a--I\'m a--\' \'Well! WHAT are you?\' And then a row of lodging.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(122,31,'X23A6GLTSFGY','Cleta Grimes DDS','jacobs.holly@yahoo.com','0469887736','I can go back by railway,\' she said this, she came rather late, and the other players, and.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(123,31,'HJZMULVEEQMO','Prof. Wava Kihn','ben.mraz@yahoo.com','0288309333','BEE,\" but it was the Hatter. This piece of it at all; and I\'m I, and--oh dear, how puzzling it all.',NULL,'reserved','2025-06-10 10:47:11','2025-06-10 10:47:11'),(124,31,'UJMRZ66SADMU','Prof. Gus Monahan','ryan.carole@hotmail.com','0016831812','Hatter. \'Does YOUR watch tell you more than Alice could see it trying in a natural way. \'I thought.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(125,31,'NSQXHMHFR9VF','Royce Daniel','yjakubowski@yahoo.com','0325031710','Alice was just going to leave off this minute!\' She generally gave herself very good advice.',NULL,'checked_in','2025-06-10 10:47:11','2025-06-10 10:47:11'),(126,32,'OI1FQISBXOU2','Lavon Heller','helmer72@gmail.com','0453554930','But said I didn\'t!\' interrupted Alice. \'You are,\' said the Mouse to tell its age, there was a.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(127,32,'NJNVC9BJZU18','Sunny Auer','rhickle@hintz.net','0325969062','So she began: \'O Mouse, do you mean by that?\' said the Hatter, \'or you\'ll be telling me next that.',NULL,'purchased','2025-06-10 10:47:11','2025-06-10 10:47:11'),(128,32,'5MUY54SSXABI','Prof. Crawford Dach','caesar13@yahoo.com','0528629191','An obstacle that came between Him, and ourselves, and it. Don\'t let me help to undo it!\' \'I shall.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(129,33,'K5KTA7EXIM7K','Clyde Pollich Sr.','heller.gudrun@wiza.info','0630696882','WHAT are you?\' said the Mock Turtle interrupted, \'if you don\'t even know what a Mock Turtle sighed.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(130,33,'1O8J6QOKPMOG','Mrs. Edythe Medhurst Jr.','fwintheiser@boehm.com','0930127937','Don\'t let me help to undo it!\' \'I shall do nothing of tumbling down stairs! How brave they\'ll all.',NULL,'pending','2025-06-10 10:47:11','2025-06-10 10:47:11'),(131,33,'HZHK1EOL2OXF','Juanita Hirthe I','isaac05@schroeder.com','0834952296','I am very tired of being upset, and their curls got entangled together. Alice was thoroughly.',NULL,'checked_in','2025-06-10 10:47:11','2025-06-10 10:47:11'),(132,33,'QRFURSILVZCG','Mrs. Eliane Reinger I','jaleel.lowe@hotmail.com','0456830184','No, no! You\'re a serpent; and there\'s no use in waiting by the prisoner to--to somebody.\' \'It must.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(133,33,'C3ZKMCPEXWRA','Eino Swift','farrell.lacey@yahoo.com','0631520908','Alice coming. \'There\'s PLENTY of room!\' said Alice very meekly: \'I\'m growing.\' \'You\'ve no right to.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(134,34,'Y0RI0SED0WIW','Mauricio West','mraz.graham@mcglynn.net','0455264447','King put on one knee as he fumbled over the wig, (look at the Queen, \'and take this child away.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(135,34,'QMGEZ2MUEIME','Osvaldo Grant','geraldine11@ebert.com','0284965902','Alice had not as yet had any sense, they\'d take the hint; but the Hatter was the cat.) \'I hope.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(136,34,'4LCZV41XTUJO','Kaitlin Runolfsson','woodrow94@hotmail.com','0944221141','Duchess: \'what a clear way you have to fly; and the baby at her hands, and began:-- \'You are all.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(137,34,'ZVXEFRA0KOUU','Vergie Cassin','qlegros@lockman.biz','0833223189','However, she soon found out a race-course, in a minute, while Alice thought she had made out that.',NULL,'reserved','2025-06-10 10:47:11','2025-06-10 10:47:11'),(138,34,'XIHWVTMHEBYZ','Alexys Marks','okrajcik@ohara.org','0718002204','IS his business!\' said Five, in a tone of the Queen\'s hedgehog just now, only it ran away when it.',NULL,'purchased','2025-06-10 10:47:11','2025-06-10 10:47:11'),(139,34,'P8HDVUEYIYJH','Ruthie Konopelski','bridgette.von@beatty.biz','0180106500','Therefore I\'m mad.\' \'I call it sad?\' And she went to school in the after-time, be herself a grown.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(140,35,'7BZEHQQBNNXE','Arch Bailey','sage17@mertz.com','0718650524','Forty-two. ALL PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at Two. Two.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(141,35,'2Q0KZBVVETA5','Prof. Maribel Bednar Jr.','sgoldner@hotmail.com','0269027030','I say again!\' repeated the Pigeon, raising its voice to a day-school, too,\' said Alice; \'I can\'t.',NULL,'reserved','2025-06-10 10:47:11','2025-06-10 10:47:11'),(142,35,'OQR1GHSVXPYR','Andres Borer','hdickens@smitham.com','0458159231','Soup! Beau--ootiful Soo--oop! Soo--oop of the Queen to-day?\' \'I should like it very nice, (it had.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(143,35,'04IGXEB94JUC','Brooke Schroeder','myrl36@hotmail.com','0902461736','Alice like the tone of delight, and rushed at the picture.) \'Up, lazy thing!\' said Alice.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(144,36,'TJKTRY9FSJXO','Birdie Cruickshank DDS','sgutkowski@gmail.com','0513313720','I will tell you my adventures--beginning from this morning,\' said Alice very politely; but she got.',NULL,'reserved','2025-06-10 10:47:11','2025-06-10 10:47:11'),(145,36,'T9M0GJTPXJB3','Dr. Erica Keebler','vcruickshank@hotmail.com','0762079913','Queen of Hearts, he stole those tarts, And took them quite away!\' \'Consider your verdict,\' he said.',NULL,'pending','2025-06-10 10:47:11','2025-06-10 10:47:11'),(146,36,'TK9RY3DTNRZV','Dagmar Pagac','bette.beatty@gmail.com','0247726169','Alice thought she might as well as she came rather late, and the poor child, \'for I can\'t take.',NULL,'checked_in','2025-06-10 10:47:11','2025-06-10 10:47:11'),(147,36,'ROBJZ1YKV2BC','Jean Douglas','jking@hoppe.com','0360245144','Alice did not quite sure whether it was empty: she did not like to drop the jar for fear of their.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(148,36,'IMA80KZR13TD','Jaylon Schimmel DVM','sam.padberg@bergstrom.biz','0561983128','Yet you balanced an eel on the slate. \'Herald, read the accusation!\' said the King said, with a.',NULL,'purchased','2025-06-10 10:47:11','2025-06-10 10:47:11'),(149,36,'6TGLF7KPE97E','Dr. Saige Orn','cummerata.kenny@schmitt.com','0564948330','Dormouse followed him: the March Hare. \'He denies it,\' said Alice, seriously, \'I\'ll have nothing.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(150,37,'CNECXF74LY6F','Prof. Phoebe Reinger Jr.','ryan.nelle@quigley.com','0708820610','CAN all that green stuff be?\' said Alice. \'Oh, don\'t talk about wasting IT. It\'s HIM.\' \'I don\'t.',NULL,'purchased','2025-06-10 10:47:11','2025-06-10 10:47:11'),(151,37,'1JBC9XPWQYRQ','Dejon Farrell','therzog@emard.biz','0357438163','And how odd the directions will look! ALICE\'S RIGHT FOOT, ESQ. HEARTHRUG, NEAR THE FENDER, (WITH.',NULL,'reserved','2025-06-10 10:47:11','2025-06-10 10:47:11'),(152,37,'GWZSHQUG5VNM','Prof. Brody Kiehn','vivien.jacobs@kovacek.com','0170432780','Dormouse began in a whisper.) \'That would be very likely it can be,\' said the cook. The King.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(153,37,'VW8RGEJW8ZFN','Lorena Schneider MD','tiffany47@moore.com','0181163546','I\'m perfectly sure I don\'t believe there\'s an atom of meaning in it,\' but none of my own. I\'m a.',NULL,'pending','2025-06-10 10:47:11','2025-06-10 10:47:11'),(154,38,'KUXWCMTDCV7I','Mrs. Grace Rau','zcummings@murray.com','0546696477','Once more she found a little timidly, for she had somehow fallen into the teapot. \'At any rate he.',NULL,'purchased','2025-06-10 10:47:11','2025-06-10 10:47:11'),(155,38,'HCNF4L2ELDKH','Lamar Frami','zmcdermott@gmail.com','0182135530','Caterpillar took the hookah into its face to see if she was considering in her lessons in here?.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(156,39,'XTTR0LJGMSLM','Alayna Towne','amina09@block.com','0030865964','YOUR temper!\' \'Hold your tongue!\' added the Dormouse. \'Fourteenth of March, I think I can say.\'.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(157,39,'IRZSFA7TEINY','Antonio Kertzmann','buster.hickle@gmail.com','0941972772','Alice, \'as all the jurymen on to himself as he came, \'Oh! the Duchess, who seemed ready to make.',NULL,'transferred','2025-06-10 10:47:11','2025-06-10 10:47:11'),(158,39,'EM4RFSAWJNN2','Deontae Bernhard','elva.stamm@hotmail.com','0157213356','I think.\' And she went on talking: \'Dear, dear! How queer everything is queer to-day.\' Just then.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(159,39,'WOTR0CO11ENQ','Royce Haley','quinten37@jacobi.info','0031863274','I\'ll manage better this time,\' she said these words her foot slipped, and in another moment down.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(160,39,'M0IPJ5XFFUQ9','Prof. Lourdes Dickens','mlegros@hyatt.com','0946453147','Alice gently remarked; \'they\'d have been a RED rose-tree, and we won\'t talk about trouble!\' said.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(161,39,'SAFINYVTDANX','Odessa Durgan','darrick47@yahoo.com','0668904015','Alice said very politely, \'for I can\'t see you?\' She was looking about for a moment like a wild.',NULL,'purchased','2025-06-10 10:47:11','2025-06-10 10:47:11'),(162,40,'G60FQY9MBYGQ','Cleveland Howell','queen.witting@hotmail.com','0824811837','By the use of repeating all that stuff,\' the Mock Turtle. \'Hold your tongue, Ma!\' said the Queen.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(163,40,'KJ9W4ZCEIBJC','Mr. Ali Feil IV','rodriguez.colby@gmail.com','0754577897','Gryphon went on without attending to her; \'but those serpents! There\'s no pleasing them!\' Alice.',NULL,'refunded','2025-06-10 10:47:11','2025-06-10 10:47:11'),(164,40,'MPEIUQV2ZPHC','Dawn Quigley','okuneva.quinten@yahoo.com','0439340285','Majesty,\' the Hatter went on for some time after the birds! Why, she\'ll eat a bat?\' when suddenly.',NULL,'cancelled','2025-06-10 10:47:11','2025-06-10 10:47:11'),(165,40,'AJNAXBQE2XUW','Rodrigo Ratke','rickie61@yahoo.com','0165185643','They all made of solid glass; there was a dead silence. \'It\'s a Cheshire cat,\' said the Mock.',NULL,'checked_in','2025-06-10 10:47:11','2025-06-10 10:47:11'),(166,40,'LMEGL6LCHDUH','Dr. Twila Hudson Jr.','victoria.effertz@hotmail.com','0037605959','I only wish they WOULD go with the clock. For instance, suppose it doesn\'t matter a bit,\' she.',NULL,'checked_in','2025-06-10 10:47:11','2025-06-10 10:47:11'),(167,40,'U6JALU42MVSK','Rey Bernier','pacocha.antoinette@hartmann.com','0745735870','Duchess; \'and that\'s why. Pig!\' She said the King said gravely, \'and go on till you come and join.',NULL,'pending','2025-06-10 10:47:11','2025-06-10 10:47:11'),(168,41,'JAJVTCCRR3SX','Blair Fadel DVM','hklocko@hermiston.com','0105789143','Quick, now!\' And Alice was soon submitted to by the prisoner to--to somebody.\' \'It must be on the.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12'),(169,41,'PQXQQTSQQFNT','Joany Blanda','jenkins.idell@connelly.info','0695339486','I\'ll look first,\' she said, \'than waste it in a few minutes it seemed quite dull and stupid for.',NULL,'purchased','2025-06-10 10:47:12','2025-06-10 10:47:12'),(170,42,'I6DRDAGGNAYR','Blaise Toy','xavier48@yahoo.com','0238017401','I suppose, by being drowned in my life!\' She had not as yet had any sense, they\'d take the place.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(171,42,'ATYF6VWBZY8K','Verner Veum','ettie.feil@hotmail.com','0841721262','Eaglet. \'I don\'t know one,\' said Alice, quite forgetting that she was losing her temper. \'Are you.',NULL,'transferred','2025-06-10 10:47:12','2025-06-10 10:47:12'),(172,42,'JFMWLA38MCY6','Hope Bosco II','clint54@hotmail.com','0327110032','English!\' said the Hatter. This piece of it appeared. \'I don\'t much care where--\' said Alice. \'I.',NULL,'reserved','2025-06-10 10:47:12','2025-06-10 10:47:12'),(173,42,'XIOVBALUAO4Y','Kevon Armstrong','rhuel@yahoo.com','0317590507','So she called softly after it, and fortunately was just in time to avoid shrinking away.',NULL,'transferred','2025-06-10 10:47:12','2025-06-10 10:47:12'),(174,42,'R9ZYZSZPYPTG','Prof. Madyson Bode','monahan.concepcion@hickle.com','0413259956','And so she set to work at once set to work, and very neatly and simply arranged; the only one way.',NULL,'reserved','2025-06-10 10:47:12','2025-06-10 10:47:12'),(175,42,'GWMPKUT0UWTC','Prof. Javonte Heller','lilliana37@yahoo.com','0141701525','Alice considered a little irritated at the end of the room again, no wonder she felt that it is!\'.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(176,43,'OPO63YL4VI97','Ms. Esmeralda Hagenes PhD','george.koss@toy.com','0473546155','White Rabbit, \'and that\'s why. Pig!\' She said this she looked down at her feet as the jury.',NULL,'purchased','2025-06-10 10:47:12','2025-06-10 10:47:12'),(177,43,'UQ49T3UIHZXU','Amanda Greenholt','mertz.sydnie@kub.org','0656099123','No, no! You\'re a serpent; and there\'s no room to grow larger again, and we won\'t talk about.',NULL,'checked_in','2025-06-10 10:47:12','2025-06-10 10:47:12'),(178,44,'H6P7ZHGMALMO','Alize Heller','khessel@okeefe.com','0220306631','I know is, it would be QUITE as much use in knocking,\' said the King. The next witness would be.',NULL,'transferred','2025-06-10 10:47:12','2025-06-10 10:47:12'),(179,44,'KFRURON4HTH4','Dr. Darion VonRueden','jerde.kennith@hotmail.com','0026988746','The Mouse only growled in reply. \'Idiot!\' said the Queen, and in another moment, splash! she was.',NULL,'pending','2025-06-10 10:47:12','2025-06-10 10:47:12'),(180,44,'FBZ16FBO3C2F','Vella Treutel I','qswaniawski@hessel.net','0639478110','Alice was only a child!\' The Queen had never heard of one,\' said Alice. \'I don\'t quite understand.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12'),(181,44,'V7CDYLPULIBH','Gilda Fadel','rath.karlee@hotmail.com','0432444523','Alice\'s elbow was pressed hard against it, that attempt proved a failure. Alice heard the Queen in.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12'),(182,44,'SCTIVI057BDB','Kellie Kautzer Jr.','murray.wilfredo@gmail.com','0217594647','Alice, and, after glaring at her rather inquisitively, and seemed to be in Bill\'s place for a.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(183,45,'ELLBY9M4ACYJ','Nicholas Conroy','vhansen@yahoo.com','0606025946','Alice sadly. \'Hand it over a little girl or a worm. The question is, what?\' The great question.',NULL,'reserved','2025-06-10 10:47:12','2025-06-10 10:47:12'),(184,45,'VBYMXF5FMXGE','Concepcion Mraz I','andrew.larkin@hotmail.com','0397041336','He was looking at the time she found herself in a minute. Alice began to repeat it, when a sharp.',NULL,'pending','2025-06-10 10:47:12','2025-06-10 10:47:12'),(185,45,'HMYQXMFKN3O3','Eli Heidenreich','bruce75@hoeger.com','0873718537','Alice\'s shoulder as she had drunk half the bottle, she found that it would be so easily offended.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(186,45,'BIYPWVIDZQZK','Pascale Torphy','kihn.devonte@gmail.com','0046593883','Alice to herself. Imagine her surprise, when the race was over. However, when they met in the.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(187,46,'5URRF7RLCGKQ','Dr. Kenya Gottlieb','efren.kovacek@gmail.com','0192812278','When they take us up and said, \'So you think you\'re changed, do you?\' \'I\'m afraid I\'ve offended it.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12'),(188,46,'GQTJIYCXHK5V','Ms. Elva Ryan V','phayes@jacobson.com','0846069275','Queen had only one way up as the other.\' As soon as look at the corners: next the ten courtiers.',NULL,'pending','2025-06-10 10:47:12','2025-06-10 10:47:12'),(189,46,'QG6QC6UCY3R0','Elena McLaughlin','pkertzmann@gmail.com','0763152821','Dinah, and saying to herself, \'it would be QUITE as much right,\' said the Mock Turtle, capering.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12'),(190,47,'MLQFT67EBINS','Alphonso Cassin','ischaden@hotmail.com','0468290000','There were doors all round her once more, while the Dodo suddenly called out to be beheaded!\'.',NULL,'reserved','2025-06-10 10:47:12','2025-06-10 10:47:12'),(191,47,'XIVOYB9T83EP','Mr. Tomas Schiller','victor.toy@rodriguez.com','0297464885','Gryphon, before Alice could not possibly reach it: she could do, lying down with wonder at the.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12'),(192,47,'H3FAK6SUCVCO','Mavis Hamill II','bernice.pfeffer@yahoo.com','0087572793','After a while she was not a mile high,\' said Alice. \'Then it doesn\'t mind.\' The table was a.',NULL,'transferred','2025-06-10 10:47:12','2025-06-10 10:47:12'),(193,48,'O7MVHHH85ZL3','Ms. Hanna Mraz','wwiegand@gmail.com','0391289984','At last the Mock Turtle said with a teacup in one hand and a Dodo, a Lory and an Eaglet, and.',NULL,'checked_in','2025-06-10 10:47:12','2025-06-10 10:47:12'),(194,48,'RARA9W7I5CKX','Kara Welch','qmorissette@gleason.com','0103986113','Alice, that she hardly knew what she was coming back to finish his story. CHAPTER IV. The Rabbit.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12'),(195,48,'MWJSONXFCHSJ','Dr. Scot Kiehn','murphy.hodkiewicz@mckenzie.com','0292855641','Hatter, and here the Mock Turtle persisted. \'How COULD he turn them out of the way--\' \'THAT.',NULL,'purchased','2025-06-10 10:47:12','2025-06-10 10:47:12'),(196,49,'APC9ZOYYPY9H','Colleen Schroeder PhD','angela.jacobs@gmail.com','0032295419','I didn\'t!\' interrupted Alice. \'You must be,\' said the Duchess; \'and the moral of THAT is--\"Take.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(197,49,'KMAULHTUQDGC','Earnest Larson','rogahn.nicole@hermann.biz','0247422359','NOT be an old crab, HE was.\' \'I never was so much already, that it might end, you know,\' said the.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(198,49,'UQIWFNVP2ZYV','Mr. Nestor Rice IV','jayden.ratke@gmail.com','0185793296','Duchess! The Duchess! Oh my fur and whiskers! She\'ll get me executed, as sure as ferrets are.',NULL,'checked_in','2025-06-10 10:47:12','2025-06-10 10:47:12'),(199,49,'M6XYTFIHHLSS','Karianne Kerluke','gregg.brekke@wolf.com','0171622961','Duchess: \'what a clear way you can;--but I must be shutting up like a snout than a rat-hole: she.',NULL,'purchased','2025-06-10 10:47:12','2025-06-10 10:47:12'),(200,50,'EAUNPN2IWZ3J','Abbey Homenick','lueilwitz.percy@lang.com','0964442957','I beg your pardon,\' said Alice indignantly. \'Ah! then yours wasn\'t a bit hurt, and she thought it.',NULL,'reserved','2025-06-10 10:47:12','2025-06-10 10:47:12'),(201,50,'LEZEAKYMONYF','Miss Rachael O\'Reilly','rogahn.theodore@harvey.com','0294027867','There could be beheaded, and that makes you forget to talk. I can\'t get out at the Cat\'s head with.',NULL,'refunded','2025-06-10 10:47:12','2025-06-10 10:47:12'),(202,50,'DTCIOJMTKJWF','Sarai Hegmann','fisher.alene@gmail.com','0676770982','I\'d been the right distance--but then I wonder what I say--that\'s the same year for such a.',NULL,'checked_in','2025-06-10 10:47:12','2025-06-10 10:47:12'),(203,50,'MI33NFI0ANPP','Destiny Renner III','helen85@gmail.com','0837213015','Pigeon had finished. \'As if it makes me grow smaller, I suppose.\' So she stood still where she was.',NULL,'purchased','2025-06-10 10:47:12','2025-06-10 10:47:12'),(204,50,'49HN5OZGMOMQ','Cyril Wunsch','christina.blick@gmail.com','0682076901','Which shall sing?\' \'Oh, YOU sing,\' said the Hatter. This piece of bread-and-butter in the flurry.',NULL,'checked_in','2025-06-10 10:47:12','2025-06-10 10:47:12'),(205,50,'XJHMZJPQFV3I','Horace Hayes','xstehr@bogisich.com','0677695042','March Hare. \'He denies it,\' said Alice. \'Did you say it.\' \'That\'s nothing to do.\" Said the mouse.',NULL,'cancelled','2025-06-10 10:47:12','2025-06-10 10:47:12');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:46:51','2025-06-10 10:46:51','Minima omnis ut maxime est. Possimus in itaque quam et cum nulla error.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:46:51','2025-06-10 10:46:51','Et odit consequuntur praesentium. Et nihil quis qui vel. Aut aut tempora aut dolorum inventore.'),(3,'Event Experience',0,'published','2025-06-10 10:46:52','2025-06-10 10:46:52','Velit quo recusandae aliquid. Et qui repellendus eum quasi vel.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:46:52','2025-06-10 10:46:52','Nam fugiat minus iste. Neque sint nostrum alias atque officiis. Vitae quis sed quos.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Dolores voluptatibus aliquid veritatis.','Ab perspiciatis est dolores animi ut sunt illum eum vitae ipsum facilis voluptatum aut nobis deserunt eaque voluptatibus totam eaque aut odio iste tempora maxime quos mollitia possimus sunt libero voluptatem qui.',2,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(2,'Blanditiis molestiae quo quae placeat modi.','Debitis eveniet tenetur voluptas ab explicabo facere ab voluptatum tempore dicta nihil fugiat dolor voluptas ad rem aut quo voluptate ex sit et molestiae commodi qui nisi enim quia veritatis cumque consequuntur amet cum aspernatur labore rem vitae suscipit nesciunt.',2,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(3,'Ea saepe accusantium animi.','Delectus soluta autem in at explicabo ut magnam quibusdam sint quia nulla et nisi quae et atque sapiente commodi ut aut numquam.',3,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(4,'Ipsam consequatur veniam sed quia.','Nobis ipsam nam temporibus aut reprehenderit rerum et cumque iure eum necessitatibus facilis voluptatum et dolor eligendi omnis itaque sed architecto dolorum delectus dolor ad ex ut et.',3,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(5,'Autem corrupti aspernatur hic asperiores et.','Est hic voluptates non iste nesciunt magni impedit odio est illum sint corrupti aut perspiciatis delectus et accusantium eum veniam aperiam esse perspiciatis nam error laborum.',3,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(6,'Voluptas et sunt rerum delectus commodi.','Esse omnis error est ut molestiae quidem error labore molestiae id distinctio perferendis in consequatur aut iure numquam similique sint dignissimos aut ut totam officia maxime corporis eum assumenda est dignissimos rerum ullam provident.',4,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(7,'Asperiores voluptas id quaerat eveniet magni ipsam.','Qui quidem distinctio illo id et beatae ut est voluptatem non sed maxime magni porro maxime occaecati minus inventore unde quia.',2,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(8,'Sit eos ratione unde.','Earum tempora sit enim numquam eveniet et nostrum esse in fugit et illo necessitatibus dolor veniam nihil doloribus ab sapiente voluptatem vero amet vero consequuntur reiciendis est dolor illo deserunt voluptates impedit quasi eveniet suscipit eius architecto fugit est eos laudantium omnis.',2,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(9,'Qui sed ipsam sit quidem reiciendis.','Deserunt et omnis aut voluptas eum voluptatem maiores accusamus nulla et et et et fugit modi et qui maxime dolor sint iusto.',4,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(10,'Culpa tenetur quia aut sequi ut.','Iusto similique iste unde rerum similique sunt porro tenetur dolorem culpa quod debitis quia quo placeat ut omnis ut dolores molestias ut ad quis quibusdam pariatur dolor veniam odio incidunt exercitationem nemo impedit.',4,'published','2025-06-10 10:46:52','2025-06-10 10:46:52'),(11,'Provident mollitia accusamus aliquid aliquid est.','Doloremque ipsum facere cupiditate ab ullam nemo ut et voluptas suscipit praesentium nesciunt in maiores et quasi cupiditate omnis animi est eos.',1,'published','2025-06-10 10:46:52','2025-06-10 10:46:52');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Fuga officiis assumenda saepe accusamus fuga sequi veniam. Recusandae perferendis et aut.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(2,'Ocean Views','Placeat dolores dolores debitis fugiat a et voluptatum. Cupiditate quidem reiciendis qui maiores. Placeat eum magni aut ut dignissimos et.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(3,'Adventure Time','Ullam nisi corporis fugit et non veritatis assumenda. Aut et fugit recusandae cupiditate. Doloremque mollitia eum et ratione sapiente quae veritatis.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(4,'City Lights','Sint minima quia quisquam dolores praesentium quod. Porro dolorem ea perspiciatis velit quibusdam.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(5,'Dreamscape','Consequatur molestiae magni quos id ad omnis harum quo. Impedit eum nam ut qui error quis alias.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(6,'Enchanted Forest','Temporibus magni totam natus voluptas. Hic enim consectetur facilis velit nulla. Et eum est eius. Est minus odit officia dolore maiores.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(7,'Golden Hour','Provident aut rem magnam nisi. Optio iste quaerat rerum repudiandae. Aliquam voluptatem autem quia ea tempora ipsam omnis.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(8,'Serenity','Et aut iure ut aspernatur rerum. Voluptates expedita maiores iusto voluptates earum. Veritatis laudantium earum tenetur omnis.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(9,'Eternal Beauty','Aut soluta architecto tempore saepe eaque debitis consequuntur itaque. Similique non eos doloribus fugiat suscipit quam.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(10,'Moonlight Magic','Earum nobis iste atque porro. Autem in error ducimus qui harum nostrum cupiditate nihil. Qui sapiente odio voluptates et provident nihil eaque qui.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(11,'Starry Night','Labore velit explicabo molestiae porro est ea et. Enim voluptas atque voluptatum impedit. Tempora repudiandae et ut ut.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(12,'Hidden Gems','Ad voluptate rerum a quia. Rerum excepturi in autem eum corporis aliquid aliquid.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(13,'Tranquil Waters','Ut ipsum rerum blanditiis laudantium amet. Laboriosam eum non numquam et ea. Nostrum illo dolor officiis.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(14,'Urban Escape','Amet consequatur optio omnis officia aut itaque. Praesentium nisi alias quis quo cupiditate aliquid. Quo cupiditate aut non nam ut.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29'),(15,'Twilight Zone','Eligendi quod et saepe suscipit rerum id. Perspiciatis ab voluptatem et vitae. Ad qui magni illo dolorum facere.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:46:29','2025-06-10 10:46:29');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Sint enim repellendus eius est. Hic nihil odit qui consequatur tempore voluptatibus. Beatae quasi ipsam ipsum vero eum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Dicta officia cumque quo aut. Dolorem quia fuga in dignissimos qui. Saepe inventore omnis rerum illo consequuntur doloremque quo blanditiis.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Quis vero dolores ut dolorum. Sed voluptatem consequuntur sit. Et nulla quis omnis officiis ducimus.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Nam qui impedit dolores quia nam et. Eum deserunt laboriosam quod eum. Dolores tempore consequatur est aperiam qui qui.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Optio iste fugiat omnis. Inventore ab quae alias voluptatem aperiam in. Eos inventore qui sit sunt ipsam assumenda. Ad in delectus sapiente id.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eaque maxime et labore sit. Sunt sed saepe et. Fugit qui architecto sint quas.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Repellat possimus praesentium et soluta. Et earum dolorem excepturi reprehenderit et aliquam. Ullam ut in possimus laborum accusamus sunt delectus.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Est vitae aut consequatur porro. Ut eveniet minima enim. Voluptas dolorem sint magnam ratione.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Magni qui incidunt quas provident ea eum nihil. In eum quidem praesentium quo nobis excepturi. Aliquam omnis cum alias ut voluptates provident.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Ullam cum sunt cupiditate voluptas eaque. Vero vitae non qui commodi voluptas rem. Deserunt dignissimos qui dicta iusto esse.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Nisi ipsam beatae laudantium sunt vel doloribus. Odit omnis quod omnis occaecati in. Magnam eum nisi veniam.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Nobis assumenda reprehenderit tenetur. Et doloremque voluptatem expedita harum labore. Voluptas sed a omnis dignissimos natus.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Vel itaque ex distinctio fuga. Eos quam debitis fugiat ut in beatae maiores pariatur.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Voluptas expedita eum enim ipsam. Aspernatur aut dolore dolores consequatur.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Et velit rerum ratione tempora dolorum. Fuga possimus voluptatem enim eum vel nisi quisquam optio.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Quaerat aut iure ducimus et ducimus ratione aut. Corrupti quisquam possimus error impedit saepe. Molestias placeat dolorem ipsam ut quis.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Earum harum earum aperiam qui non delectus. Cupiditate possimus repellendus impedit provident totam dolores.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Consequuntur quos cumque non velit ut. Blanditiis quibusdam voluptas aut et aperiam quas repellendus. Sunt deleniti temporibus iste rerum.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Magni esse recusandae eum dolorem animi error modi. Nihil quia debitis delectus ad ut quasi incidunt. Ut optio iure officia laudantium.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Autem occaecati vero in maxime qui recusandae natus. Iusto fugit nostrum assumenda ratione possimus et. Incidunt nobis est perspiciatis error.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:46:29','2025-06-10 10:46:29');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','e63c0b9ece41d7743a96292e034cba5c',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','058ac03622e5b4c972ae5a0edc628de8',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','23ee0b7555dd9fe14336c19e6ea0b799',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=164 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:46:29','2025-06-10 10:46:29',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:46:30','2025-06-10 10:46:30',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:46:30','2025-06-10 10:46:30',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:46:30','2025-06-10 10:46:30',NULL,'public'),(36,0,'hero-banner-img','hero-banner-img',6,'image/webp',9643,'homepage09/general/hero-banner-img.webp','[]','2025-06-10 10:46:30','2025-06-10 10:46:30',NULL,'public'),(37,0,'sub-logo','sub-logo',6,'image/png',238,'homepage09/general/sub-logo.png','[]','2025-06-10 10:46:30','2025-06-10 10:46:30',NULL,'public'),(38,0,'hero-banner-bg','hero-banner-bg',7,'image/webp',20220,'homepage09/backgrounds/hero-banner-bg.webp','[]','2025-06-10 10:46:30','2025-06-10 10:46:30',NULL,'public'),(39,0,'brand-img1','brand-img1',8,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:46:31','2025-06-10 10:46:31',NULL,'public'),(40,0,'brand-img2','brand-img2',8,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:46:31','2025-06-10 10:46:31',NULL,'public'),(41,0,'brand-img3','brand-img3',8,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:46:31','2025-06-10 10:46:31',NULL,'public'),(42,0,'brand-img4','brand-img4',8,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:46:31','2025-06-10 10:46:31',NULL,'public'),(43,0,'brand-img5','brand-img5',8,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:46:31','2025-06-10 10:46:31',NULL,'public'),(44,0,'brand-img6','brand-img6',8,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:46:31','2025-06-10 10:46:31',NULL,'public'),(45,0,'brand-img7','brand-img7',8,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:46:31','2025-06-10 10:46:31',NULL,'public'),(46,0,'brand-img8','brand-img8',8,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:46:32','2025-06-10 10:46:32',NULL,'public'),(47,0,'1','1',9,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:46:32','2025-06-10 10:46:32',NULL,'public'),(48,0,'2','2',9,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:46:32','2025-06-10 10:46:32',NULL,'public'),(49,0,'header-bg4','header-bg4',9,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:46:32','2025-06-10 10:46:32',NULL,'public'),(50,0,'hero-banner-bg','hero-banner-bg',9,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:46:33','2025-06-10 10:46:33',NULL,'public'),(51,0,'image-1','image-1',9,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:46:34','2025-06-10 10:46:34',NULL,'public'),(52,0,'newsletter-bg','newsletter-bg',9,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:46:35','2025-06-10 10:46:35',NULL,'public'),(53,0,'pricing-name','pricing-name',9,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:46:35','2025-06-10 10:46:35',NULL,'public'),(54,0,'speakers-bg','speakers-bg',9,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:46:35','2025-06-10 10:46:35',NULL,'public'),(55,0,'balloons','balloons',10,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:46:35','2025-06-10 10:46:35',NULL,'public'),(56,0,'calendar','calendar',10,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:46:36','2025-06-10 10:46:36',NULL,'public'),(57,0,'clock','clock',10,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:46:36','2025-06-10 10:46:36',NULL,'public'),(58,0,'coding','coding',10,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:46:36','2025-06-10 10:46:36',NULL,'public'),(59,0,'idea','idea',10,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:46:36','2025-06-10 10:46:36',NULL,'public'),(60,0,'instagram-icon','instagram-icon',10,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:46:36','2025-06-10 10:46:36',NULL,'public'),(61,0,'location-icon','location-icon',10,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:46:36','2025-06-10 10:46:36',NULL,'public'),(62,0,'location','location',10,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:46:37','2025-06-10 10:46:37',NULL,'public'),(63,0,'mail-icon','mail-icon',10,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:46:37','2025-06-10 10:46:37',NULL,'public'),(64,0,'menu','menu',10,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:46:37','2025-06-10 10:46:37',NULL,'public'),(65,0,'microphone','microphone',10,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:46:37','2025-06-10 10:46:37',NULL,'public'),(66,0,'phone-icon','phone-icon',10,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:46:37','2025-06-10 10:46:37',NULL,'public'),(67,0,'search','search',10,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:46:37','2025-06-10 10:46:37',NULL,'public'),(68,0,'speaker','speaker',10,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:46:37','2025-06-10 10:46:37',NULL,'public'),(69,0,'ticket','ticket',10,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:46:38','2025-06-10 10:46:38',NULL,'public'),(70,0,'user','user',10,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:46:38','2025-06-10 10:46:38',NULL,'public'),(71,0,'view','view',10,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:46:38','2025-06-10 10:46:38',NULL,'public'),(72,0,'workshop','workshop',10,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:46:38','2025-06-10 10:46:38',NULL,'public'),(73,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:46:38','2025-06-10 10:46:38',NULL,'public'),(74,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:46:39','2025-06-10 10:46:39',NULL,'public'),(75,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:46:39','2025-06-10 10:46:39',NULL,'public'),(76,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:46:39','2025-06-10 10:46:39',NULL,'public'),(77,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:46:40','2025-06-10 10:46:40',NULL,'public'),(78,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:46:40','2025-06-10 10:46:40',NULL,'public'),(79,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:46:40','2025-06-10 10:46:40',NULL,'public'),(80,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:46:41','2025-06-10 10:46:41',NULL,'public'),(81,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:46:41','2025-06-10 10:46:41',NULL,'public'),(82,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:46:41','2025-06-10 10:46:41',NULL,'public'),(83,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:46:41','2025-06-10 10:46:41',NULL,'public'),(84,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:46:42','2025-06-10 10:46:42',NULL,'public'),(85,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:46:42','2025-06-10 10:46:42',NULL,'public'),(86,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:46:42','2025-06-10 10:46:42',NULL,'public'),(87,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:46:43','2025-06-10 10:46:43',NULL,'public'),(88,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:46:43','2025-06-10 10:46:43',NULL,'public'),(89,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:46:43','2025-06-10 10:46:43',NULL,'public'),(90,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:46:44','2025-06-10 10:46:44',NULL,'public'),(91,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:46:44','2025-06-10 10:46:44',NULL,'public'),(92,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:46:44','2025-06-10 10:46:44',NULL,'public'),(93,0,'1','1',11,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:46:45','2025-06-10 10:46:45',NULL,'public'),(94,0,'10','10',11,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:46:45','2025-06-10 10:46:45',NULL,'public'),(95,0,'11','11',11,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:46:45','2025-06-10 10:46:45',NULL,'public'),(96,0,'12','12',11,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:46:46','2025-06-10 10:46:46',NULL,'public'),(97,0,'13','13',11,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:46:46','2025-06-10 10:46:46',NULL,'public'),(98,0,'14','14',11,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:46:46','2025-06-10 10:46:46',NULL,'public'),(99,0,'15','15',11,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:46:47','2025-06-10 10:46:47',NULL,'public'),(100,0,'16','16',11,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:46:47','2025-06-10 10:46:47',NULL,'public'),(101,0,'17','17',11,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:46:47','2025-06-10 10:46:47',NULL,'public'),(102,0,'18','18',11,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:46:48','2025-06-10 10:46:48',NULL,'public'),(103,0,'19','19',11,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:46:48','2025-06-10 10:46:48',NULL,'public'),(104,0,'2','2',11,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:46:48','2025-06-10 10:46:48',NULL,'public'),(105,0,'20','20',11,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:46:48','2025-06-10 10:46:48',NULL,'public'),(106,0,'3','3',11,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:46:49','2025-06-10 10:46:49',NULL,'public'),(107,0,'4','4',11,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:46:49','2025-06-10 10:46:49',NULL,'public'),(108,0,'5','5',11,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:46:49','2025-06-10 10:46:49',NULL,'public'),(109,0,'6','6',11,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:46:50','2025-06-10 10:46:50',NULL,'public'),(110,0,'7','7',11,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:46:50','2025-06-10 10:46:50',NULL,'public'),(111,0,'8','8',11,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:46:50','2025-06-10 10:46:50',NULL,'public'),(112,0,'9','9',11,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:46:51','2025-06-10 10:46:51',NULL,'public'),(113,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:46:52','2025-06-10 10:46:52',NULL,'public'),(114,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:46:52','2025-06-10 10:46:52',NULL,'public'),(115,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:46:52','2025-06-10 10:46:52',NULL,'public'),(116,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:46:52','2025-06-10 10:46:52',NULL,'public'),(117,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:46:52','2025-06-10 10:46:52',NULL,'public'),(118,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:46:52','2025-06-10 10:46:52',NULL,'public'),(119,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:46:53','2025-06-10 10:46:53',NULL,'public'),(120,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:46:53','2025-06-10 10:46:53',NULL,'public'),(121,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:46:53','2025-06-10 10:46:53',NULL,'public'),(122,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:46:53','2025-06-10 10:46:53',NULL,'public'),(123,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:46:53','2025-06-10 10:46:53',NULL,'public'),(124,0,'1','1',12,'image/png',5563,'homepage09/speakers/1.png','[]','2025-06-10 10:46:53','2025-06-10 10:46:53',NULL,'public'),(125,0,'2','2',12,'image/png',5563,'homepage09/speakers/2.png','[]','2025-06-10 10:46:54','2025-06-10 10:46:54',NULL,'public'),(126,0,'3','3',12,'image/png',5563,'homepage09/speakers/3.png','[]','2025-06-10 10:46:54','2025-06-10 10:46:54',NULL,'public'),(127,0,'4','4',12,'image/png',5563,'homepage09/speakers/4.png','[]','2025-06-10 10:46:54','2025-06-10 10:46:54',NULL,'public'),(128,0,'5','5',12,'image/png',5563,'homepage09/speakers/5.png','[]','2025-06-10 10:46:54','2025-06-10 10:46:54',NULL,'public'),(129,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:46:54','2025-06-10 10:46:54',NULL,'public'),(130,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:46:54','2025-06-10 10:46:54',NULL,'public'),(131,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:46:54','2025-06-10 10:46:54',NULL,'public'),(132,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:46:55','2025-06-10 10:46:55',NULL,'public'),(133,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:46:55','2025-06-10 10:46:55',NULL,'public'),(134,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:46:55','2025-06-10 10:46:55',NULL,'public'),(135,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:46:55','2025-06-10 10:46:55',NULL,'public'),(136,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:46:55','2025-06-10 10:46:55',NULL,'public'),(137,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:46:55','2025-06-10 10:46:55',NULL,'public'),(138,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:46:56','2025-06-10 10:46:56',NULL,'public'),(139,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:46:56','2025-06-10 10:46:56',NULL,'public'),(140,0,'0','0',14,'image/webp',33268,'main/events/0-1749552422.webp','[]','2025-06-10 10:47:02','2025-06-10 10:47:02',NULL,'public'),(141,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:47:02','2025-06-10 10:47:02',NULL,'public'),(142,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:47:02','2025-06-10 10:47:02',NULL,'public'),(143,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:47:03','2025-06-10 10:47:03',NULL,'public'),(144,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:47:03','2025-06-10 10:47:03',NULL,'public'),(145,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:47:03','2025-06-10 10:47:03',NULL,'public'),(146,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:47:04','2025-06-10 10:47:04',NULL,'public'),(147,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:47:04','2025-06-10 10:47:04',NULL,'public'),(148,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:47:04','2025-06-10 10:47:04',NULL,'public'),(149,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:47:04','2025-06-10 10:47:04',NULL,'public'),(150,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:47:05','2025-06-10 10:47:05',NULL,'public'),(151,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:47:05','2025-06-10 10:47:05',NULL,'public'),(152,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:47:05','2025-06-10 10:47:05',NULL,'public'),(153,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:47:06','2025-06-10 10:47:06',NULL,'public'),(154,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:47:06','2025-06-10 10:47:06',NULL,'public'),(155,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:47:06','2025-06-10 10:47:06',NULL,'public'),(156,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:47:07','2025-06-10 10:47:07',NULL,'public'),(157,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:47:07','2025-06-10 10:47:07',NULL,'public'),(158,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:47:07','2025-06-10 10:47:07',NULL,'public'),(159,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:47:08','2025-06-10 10:47:08',NULL,'public'),(160,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:47:08','2025-06-10 10:47:08',NULL,'public'),(161,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:47:20','2025-06-10 10:47:20',NULL,'public'),(162,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:47:20','2025-06-10 10:47:20',NULL,'public'),(163,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:47:21','2025-06-10 10:47:21',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:46:21','2025-06-10 10:46:21',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:46:21','2025-06-10 10:46:21',NULL),(3,0,'news',NULL,'news',1,'2025-06-10 10:46:23','2025-06-10 10:46:23',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:46:29','2025-06-10 10:46:29',NULL),(5,0,'homepage09',NULL,'homepage09',0,'2025-06-10 10:46:30','2025-06-10 10:46:30',NULL),(6,0,'general',NULL,'general',5,'2025-06-10 10:46:30','2025-06-10 10:46:30',NULL),(7,0,'backgrounds',NULL,'backgrounds',5,'2025-06-10 10:46:30','2025-06-10 10:46:30',NULL),(8,0,'brands',NULL,'brands',1,'2025-06-10 10:46:31','2025-06-10 10:46:31',NULL),(9,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:46:32','2025-06-10 10:46:32',NULL),(10,0,'icons',NULL,'icons',1,'2025-06-10 10:46:35','2025-06-10 10:46:35',NULL),(11,0,'blogs',NULL,'blogs',1,'2025-06-10 10:46:45','2025-06-10 10:46:45',NULL),(12,0,'speakers',NULL,'speakers',5,'2025-06-10 10:46:53','2025-06-10 10:46:53',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:46:54','2025-06-10 10:46:54',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:47:02','2025-06-10 10:47:02',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:47:20','2025-06-10 10:47:20',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:47:20','2025-06-10 10:47:20');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:47:20','2025-06-10 10:47:20');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:47:20','2025-06-10 10:47:20');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:46:30','2025-06-10 10:46:30'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:46:30','2025-06-10 10:46:30'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:46:30','2025-06-10 10:46:30'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:46:30','2025-06-10 10:46:30'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:46:44','2025-06-10 10:46:44'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:46:45','2025-06-10 10:46:45'),(7,'title','[\"Fullstack Developer\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(8,'description','[\"Cat, and vanished. Alice was too small, but at any rate a book written about me, that there was hardly room for her. \'Yes!\' shouted Alice. \'Come on, then!\' roared the Queen, turning purple. \'I.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(9,'address','[\"38443 Hickle Pines Apt. 598\\nNew Dwight, AZ 06173-7048\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(11,'title','[\"Project Manager\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(12,'description','[\"Alice, \'it\'s very rude.\' The Hatter opened his eyes very wide on hearing this; but all he SAID was, \'Why is a very small cake, on which the March Hare. Alice sighed wearily. \'I think you might like.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(13,'address','[\"681 Jedidiah Estate Suite 983\\nPort Onaborough, DC 90586\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(15,'title','[\"UX\\/UI Designer\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(16,'description','[\"But here, to Alice\'s great surprise, the Duchess\'s cook. She carried the pepper-box in her brother\'s Latin Grammar, \'A mouse--of a mouse--to a mouse--a mouse--O mouse!\') The Mouse gave a look.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(17,'address','[\"17993 Gleichner Cliffs Suite 609\\nLake Jadaborough, MT 46278-9898\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:56','2025-06-10 10:46:56'),(19,'title','[\"DevOps Engineer\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(20,'description','[\"Alice replied eagerly, for she had someone to listen to her. The Cat only grinned when it had been, it suddenly appeared again. \'By-the-bye, what became of the house before she had never forgotten.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(21,'address','[\"185 Samir Summit Apt. 239\\nLake Elainatown, MA 07280-3713\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(23,'title','[\"UX\\/UI Designer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(24,'description','[\"White Rabbit read out, at the righthand bit again, and put it to half-past one as long as it happens; and if the Queen shouted at the White Rabbit, \'but it seems to suit them!\' \'I haven\'t the.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(25,'address','[\"9713 Wilderman Squares\\nRyanville, VA 27600-3123\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(27,'title','[\"Fullstack Developer\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(28,'description','[\"Mock Turtle in a hoarse, feeble voice: \'I heard every word you fellows were saying.\' \'Tell us a story!\' said the Queen, but she could remember about ravens and writing-desks, which wasn\'t much. The.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(29,'address','[\"911 Burnice Turnpike\\nHillberg, HI 18127-4536\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(31,'title','[\"Backend Developer\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(32,'description','[\"Tell her to carry it further. So she began: \'O Mouse, do you know what \\\"it\\\" means well enough, when I got up and to hear her try and say \\\"Who am I to get dry very soon. \'Ahem!\' said the cook. The.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(33,'address','[\"5006 Arvel Ridges\\nNorvalhaven, MA 38578-8110\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(35,'title','[\"DevOps Engineer\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(36,'description','[\"By the time he was going to dive in among the branches, and every now and then, if I know is, it would be quite absurd for her to wink with one eye; but to her full size by this time.) \'You\'re.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(37,'address','[\"6147 Dwight Shoal Apt. 408\\nEstelleberg, VT 07860-3408\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(39,'title','[\"Quality Assurance\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(40,'description','[\"However, she did so, and giving it a bit, if you drink much from a Caterpillar The Caterpillar and Alice looked very anxiously into its mouth and began bowing to the company generally, \'You are all.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:57','2025-06-10 10:46:57'),(41,'address','[\"35880 Marquardt Points Apt. 798\\nNew Feltonton, SC 90430\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(43,'title','[\"Quality Assurance\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(44,'description','[\"Caterpillar. \'Well, I\'ve tried to look for her, and the constant heavy sobbing of the cattle in the face. \'I\'ll put a stop to this,\' she said to the jury. \'Not yet, not yet!\' the Rabbit noticed.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(45,'address','[\"88312 Zboncak Field\\nNew Chadrick, TX 85747-7345\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(47,'title','[\"Product Manager\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(48,'description','[\"The first thing I\'ve got to do,\' said Alice in a great many teeth, so she went out, but it was out of his great wig.\' The judge, by the little door: but, alas! the little dears came jumping merrily.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(49,'address','[\"847 Karlee Stream Apt. 620\\nLueilwitzmouth, LA 11766-2806\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(51,'title','[\"Frontend Developer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(52,'description','[\"The Hatter shook his grey locks, \'I kept all my life!\' She had just begun to repeat it, when a cry of \'The trial\'s beginning!\' was heard in the sea, some children digging in the prisoner\'s.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(53,'address','[\"938 Stracke Fort\\nNew Milo, SC 68827\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(55,'title','[\"Product Manager\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(56,'description','[\"Knave \'Turn them over!\' The Knave did so, very carefully, nibbling first at one corner of it: \'No room! No room!\' they cried out when they liked, so that by the English, who wanted leaders, and had.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(57,'address','[\"490 Elliot Locks\\nNew Alyson, OK 43564-7236\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(59,'title','[\"DevOps Engineer\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(60,'description','[\"Mock Turtle to the part about her repeating \'YOU ARE OLD, FATHER WILLIAM,\\\"\' said the King, \'or I\'ll have you got in your knocking,\' the Footman remarked, \'till tomorrow--\' At this the White Rabbit.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(61,'address','[\"950 Mathilde Parkway\\nHettieton, GA 05409\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:58','2025-06-10 10:46:58'),(63,'title','[\"UX\\/UI Designer\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(64,'description','[\"She hastily put down yet, before the trial\'s over!\' thought Alice. The King looked anxiously at the mouth with strings: into this they slipped the guinea-pig, head first, and then treading on my.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(65,'address','[\"647 Rath Cove\\nWizaburgh, RI 53840\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(67,'title','[\"Product Manager\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(68,'description','[\"Mock Turtle, \'they--you\'ve seen them, of course?\' \'Yes,\' said Alice, as she picked her way into a line along the sea-shore--\' \'Two lines!\' cried the Gryphon. \'It\'s all his fancy, that: they never.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(69,'address','[\"9069 Hane Circle Apt. 995\\nLake Keenanfort, WA 32089-7875\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(71,'title','[\"Project Manager\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(72,'description','[\"There was a large cauldron which seemed to be true): If she should meet the real Mary Ann, and be turned out of the sea.\' \'I couldn\'t help it,\' she thought, and it was neither more nor less than a.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(73,'address','[\"3980 Runolfsdottir Well\\nFriedaberg, HI 38479-8886\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(75,'title','[\"UX\\/UI Designer\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(76,'description','[\"Forty-two. ALL PERSONS MORE THAN A MILE HIGH TO LEAVE THE COURT.\' Everybody looked at Alice. \'It goes on, you know,\' said Alice thoughtfully: \'but then--I shouldn\'t be hungry for it, she found to be.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(77,'address','[\"312 Lind Points\\nKiehnburgh, NJ 41585\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(79,'title','[\"Frontend Developer\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(80,'description','[\"Mock Turtle recovered his voice, and, with tears running down his cheeks, he went on, \'\\\"--found it advisable to go and get ready for your interesting story,\' but she ran off as hard as it spoke. \'As.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(81,'address','[\"4258 Cleveland Gardens Apt. 267\\nKohlerborough, OK 58423\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(83,'title','[\"Quality Assurance\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(84,'description','[\"SOME change in my time, but never ONE with such sudden violence that Alice could think of nothing better to say \'I once tasted--\' but checked herself hastily, and said to herself, in a tone of great.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(85,'address','[\"579 Triston Fort Suite 030\\nMarcellaton, CT 37864\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:46:59','2025-06-10 10:46:59'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(87,'title','[\"Backend Developer\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(88,'description','[\"The other guests had taken advantage of the accident, all except the King, going up to her feet, they seemed to be no chance of her voice, and see how the Dodo solemnly, rising to its feet, ran.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(89,'address','[\"970 Johnson Shore\\nLake Carter, MT 85014\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(91,'title','[\"Frontend Developer\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(92,'description','[\"March Hare went \'Sh! sh!\' and the Queen left off, quite out of court! Suppress him! Pinch him! Off with his head!\' or \'Off with her head!\' Alice glanced rather anxiously at the great question.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(93,'address','[\"9698 Hayes Terrace Suite 502\\nSouth Theaborough, CT 99447\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(95,'title','[\"DevOps Engineer\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(96,'description','[\"Hatter, with an important air, \'are you all ready? This is the same thing a bit!\' said the Hatter. He came in with a yelp of delight, which changed into alarm in another moment it was sneezing on.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(97,'address','[\"996 Mann Falls\\nNorth Gersonfort, AL 67177\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(99,'title','[\"Fullstack Developer\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(100,'description','[\"The question is, what did the archbishop find?\' The Mouse gave a little different. But if I\'m not used to know. Let me see: I\'ll give them a railway station.) However, she did not dare to laugh.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(101,'address','[\"5875 Homenick Place Apt. 475\\nWest Isaac, WY 33203-7549\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(103,'title','[\"Frontend Developer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(104,'description','[\"I don\'t believe you do lessons?\' said Alice, \'we learned French and music.\' \'And washing?\' said the Queen, stamping on the shingle--will you come to the door, staring stupidly up into a doze; but.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(105,'address','[\"5613 Bauch Manors Apt. 968\\nNorth Marina, IA 34876\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:00','2025-06-10 10:47:00'),(107,'title','[\"Backend Developer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(108,'description','[\"Never heard of \\\"Uglification,\\\"\' Alice ventured to say. \'What is it?\' Alice panted as she spoke. (The unfortunate little Bill had left off quarrelling with the end of every line: \'Speak roughly to.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(109,'address','[\"861 Bosco Greens Apt. 368\\nLakinfort, TN 52233\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(111,'title','[\"DevOps Engineer\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(112,'description','[\"Do come back again, and all that,\' said the Caterpillar sternly. \'Explain yourself!\' \'I can\'t remember things as I do,\' said Alice timidly. \'Would you tell me,\' said Alice, \'and if it wasn\'t trouble.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(113,'address','[\"3859 Blanda Drive\\nCummerataland, AR 43495-9685\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(115,'title','[\"Frontend Developer\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(116,'description','[\"D,\' she added in a sorrowful tone; \'at least there\'s no harm in trying.\' So she went down to look over their shoulders, that all the time she saw them, they were getting so used to it in less than a.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(117,'address','[\"5879 Jayce Glens Apt. 680\\nMcKenziefurt, GA 14839-1674\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(119,'title','[\"Backend Developer\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(120,'description','[\"Queen say only yesterday you deserved to be sure, this generally happens when one eats cake, but Alice had been looking at the moment, \'My dear! I wish you wouldn\'t have come here.\' Alice didn\'t.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(121,'address','[\"80188 Pollich Road\\nJarrettburgh, RI 23828-9678\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(123,'title','[\"DevOps Engineer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(124,'description','[\"I hadn\'t gone down that rabbit-hole--and yet--and yet--it\'s rather curious, you know, as we needn\'t try to find that she was always ready to agree to everything that Alice quite jumped; but she.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(125,'address','[\"607 Unique Via Apt. 136\\nDillonbury, NH 19186\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(127,'title','[\"Backend Developer\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(128,'description','[\"The Cat\'s head with great emphasis, looking hard at Alice the moment how large she had tired herself out with his nose, and broke off a bit of stick, and tumbled head over heels in its sleep.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(129,'address','[\"76571 Delphia Road Suite 721\\nWest Carlottaland, OH 98755\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:47:01','2025-06-10 10:47:01'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(134,'event_id','[6]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(138,'event_id','[7]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21'),(142,'event_id','[7]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:47:21','2025-06-10 10:47:21');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner style=&quot;8&quot; title=&quot;World Music &lt;br&gt; Events 2025&quot; subtitle=&quot;WE ARE COMING FOR&quot; image=&quot;homepage09/general/hero-banner-img.webp&quot; button_primary_label=&quot;Buy Tickets Now!&quot; button_primary_url=&quot;/events&quot; button_secondary_url=&quot;/events&quot; button_secondary_label=&quot;Schedule&quot; background_image=&quot;homepage09/backgrounds/hero-banner-bg.webp&quot;][/hero-banner]\n[speakers style=&quot;8&quot; title=&quot;Extraordinary Artists&quot; subtitle=&quot;15+ Event Speakers&quot; limit=&quot;8&quot; text_color=&quot;rgb(0, 0, 0)&quot;][/speakers]\n[events-schedule title=&quot;Our Events Schedule Plan&quot; subtitle=&quot;Event Schedule&quot; number_days=&quot;5&quot; style=&quot;2&quot; background_color=&quot;#F7F5FB&quot;][/events-schedule]\n[pricing style=&quot;4&quot; title=&quot;Event Passes and Pricing&quot; subtitle=&quot;our event Pricing Plan&quot; quantity=&quot;3&quot; name_1=&quot;One Day Festival Pass&quot; price_1=&quot;$49.89&quot; unit_1=&quot;Day&quot; description_1=&quot;Free 7 day trial, No credit card required, Cancel Anytime&quot; features_1=&quot;+ Ticket for one day \\n + Chance to win door prize  \\n - Free-official merchandise \\n - Free artist photo + signature \\n - Hotel Voucher&quot; button_url_1=&quot;/contact-us&quot; button_label_1=&quot;Buy Ticket Now&quot; name_2=&quot;Full Festival Pass&quot; price_2=&quot;$69.89&quot; unit_2=&quot;Day&quot; description_2=&quot;Free 7 day trial, No credit card required, Cancel Anytime&quot; features_2=&quot;+ Ticket for one day \\n + Chance to win door prize  \\n + Free-official merchandise \\n - Free artist photo &amp; signature \\n - Hotel Voucher&quot; button_url_2=&quot;/contact-us&quot; button_label_2=&quot;Buy Ticket Now&quot; is_featured_2=&quot;yes&quot; name_3=&quot;Couple Pass&quot; price_3=&quot;$89.89&quot; unit_3=&quot;Day&quot; description_3=&quot;Free 7 day trial, No credit card required, Cancel Anytime&quot; features_3=&quot;+ Ticket for one day \\n + Chance to win door prize  \\n + Free-official merchandise \\n + Free artist photo &amp; signature \\n + Hotel Voucher&quot; button_url_3=&quot;/contact-us&quot; button_label_3=&quot;Buy Ticket Now&quot;][/pricing]\n[google-map]New York, USA[/google-map]\n[brands style=&quot;2&quot; text_color=&quot;#000000&quot; subtitle=&quot;general sponsors&quot; title=&quot;Our Official Sponsors&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot;][/brands]',1,NULL,'homepage',NULL,'published','2025-06-10 10:46:44','2025-06-10 10:46:45'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:46:44','2025-06-10 10:46:44'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:46:44','2025-06-10 10:46:44'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:46:45','2025-06-10 10:46:45'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:46:45','2025-06-10 10:46:45'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:46:45','2025-06-10 10:46:45'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:46:45','2025-06-10 10:46:45'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:46:45','2025-06-10 10:46:45'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:46:45','2025-06-10 10:46:45');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'FKJUNL9JNSYO','bank_transfer',NULL,250.56,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08',NULL,NULL),(2,'1',0,'RUZ0P3032RE0','bank_transfer',NULL,125.28,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:08','2025-06-10 10:47:08',NULL,NULL),(3,'1',0,'CPXFAYQVCXZQ','bank_transfer',NULL,62.64,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(4,'1',0,'NTLSOLH4P3FW','bank_transfer',NULL,250.56,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(5,'1',0,'TMPDJIHE6BRG','bank_transfer',NULL,62.64,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(6,'1',0,'XP1P2UVOWCET','bank_transfer',NULL,187.92,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(7,'1',0,'ZZUYBFTVDPVB','bank_transfer',NULL,250.56,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(8,'1',0,'OTZAH7C7YPDW','bank_transfer',NULL,250.56,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(9,'1',0,'NFVIW7465DEH','bank_transfer',NULL,250.56,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(10,'1',0,'QPPMUR3F5UUG','bank_transfer',NULL,250.56,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(11,'1',0,'DPAONUTPN0UF','bank_transfer',NULL,263.80,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(12,'1',0,'DUNDUSXXO0EE','bank_transfer',NULL,131.90,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(13,'1',0,'6CQLRK2VVHFG','bank_transfer',NULL,131.90,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(14,'1',0,'WQU212XTMZRI','bank_transfer',NULL,131.90,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(15,'1',0,'GBDP2JPJPNVX','bank_transfer',NULL,263.80,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:09','2025-06-10 10:47:09',NULL,NULL),(16,'1',0,'S0VXEIA1MO92','bank_transfer',NULL,65.95,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(17,'1',0,'LL6P0XFLTPCN','bank_transfer',NULL,263.80,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(18,'1',0,'CY6MCCG7J6ZL','bank_transfer',NULL,329.75,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(19,'1',0,'M5K27C2KDUID','bank_transfer',NULL,263.80,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(20,'1',0,'WBBQHJYOQPFJ','bank_transfer',NULL,65.95,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(21,'1',0,'DJ0M4AN34QJ2','bank_transfer',NULL,6.85,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(22,'1',0,'81XDEDQ0PUCX','bank_transfer',NULL,4.11,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(23,'1',0,'6DVOUCISIIXI','bank_transfer',NULL,6.85,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(24,'1',0,'ZJ9TYE3PQO3H','bank_transfer',NULL,4.11,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(25,'1',0,'6I8QWEXGKJIX','bank_transfer',NULL,2.74,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(26,'1',0,'ZNNEYTRM8HOD','bank_transfer',NULL,2.74,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(27,'1',0,'QOK8EYDKZW7Q','bank_transfer',NULL,1.37,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(28,'1',0,'ATNDRKHRQAJ3','bank_transfer',NULL,5.48,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:10','2025-06-10 10:47:10',NULL,NULL),(29,'1',0,'EJFQKK0RKQZY','bank_transfer',NULL,5.48,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(30,'1',0,'LBSNY8OHMH5W','bank_transfer',NULL,1.37,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(31,'1',0,'8B1FGB5A2ATR','bank_transfer',NULL,181.48,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(32,'1',0,'DBQ2UQQA8PKI','bank_transfer',NULL,90.74,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(33,'1',0,'QCKUA7ICWG1J','bank_transfer',NULL,181.48,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(34,'1',0,'ZLK7XKWXP56U','bank_transfer',NULL,226.85,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(35,'1',0,'NT6DQGCXMBEH','bank_transfer',NULL,136.11,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(36,'1',0,'G3TCYQMLGFUH','bank_transfer',NULL,226.85,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(37,'1',0,'APBDPJDQUZXN','bank_transfer',NULL,136.11,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(38,'1',0,'LXKPHDQA5ZND','bank_transfer',NULL,45.37,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(39,'1',0,'TZVJNCSBEWQI','bank_transfer',NULL,226.85,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(40,'1',0,'F8MMEDEIFDHE','bank_transfer',NULL,226.85,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:11','2025-06-10 10:47:11',NULL,NULL),(41,'1',0,'I79AQ2AB1JDO','bank_transfer',NULL,77.82,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(42,'1',0,'ITVGLNHWAY1Z','bank_transfer',NULL,389.10,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(43,'1',0,'5L0Q69QTXFS4','bank_transfer',NULL,77.82,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(44,'1',0,'NNP1K5SYMERB','bank_transfer',NULL,311.28,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(45,'1',0,'IK3UTTGR9SSX','bank_transfer',NULL,233.46,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(46,'1',0,'ECBTGPNLKLWZ','bank_transfer',NULL,155.64,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(47,'1',0,'TS3FFULSPOYL','bank_transfer',NULL,155.64,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(48,'1',0,'H3AQAMGARZYP','bank_transfer',NULL,155.64,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(49,'1',0,'PROUOKNEJKXW','bank_transfer',NULL,233.46,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL),(50,'1',0,'WB9J5I6G0DTG','bank_transfer',NULL,389.10,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:47:12','2025-06-10 10:47:12',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (6,1),(1,1),(5,2),(6,2),(2,3),(1,4),(2,4),(1,5),(5,5),(1,6),(5,6),(3,7),(1,7),(6,8),(3,9),(6,9),(4,10),(6,10),(6,11),(4,11),(1,12),(2,12),(3,13),(5,13),(6,14),(1,14),(5,15),(2,15),(2,16),(2,17),(4,17),(3,18),(1,18),(4,19),(1,19),(5,20),(1,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (1,1),(4,1),(2,2),(3,2),(7,2),(5,3),(1,3),(3,3),(6,4),(5,4),(4,4),(2,5),(4,5),(3,5),(4,6),(1,6),(7,6),(7,7),(5,7),(3,8),(4,8),(5,8),(3,9),(5,9),(2,10),(4,10),(6,11),(7,11),(1,11),(4,12),(5,12),(2,12),(3,13),(6,13),(7,13),(1,14),(7,14),(3,14),(3,15),(2,15),(5,15),(7,16),(5,16),(2,16),(4,17),(7,17),(3,18),(5,18),(2,18),(4,19),(2,19),(4,20),(3,20),(1,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',1289,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',1597,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',742,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',1414,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',664,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',859,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',169,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',1377,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',2299,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',463,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',2372,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',1370,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',1870,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',1192,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',815,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',2183,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',2434,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',167,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',2305,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/8.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',1119,NULL,'2025-06-10 10:46:51','2025-06-10 10:46:51');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:46:29','2025-06-10 10:46:29');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:47:21'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:47:21'),(6,'language_hide_default','1',NULL,'2025-06-10 10:47:21'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:47:21'),(8,'language_display','all',NULL,'2025-06-10 10:47:21'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:47:21'),(10,'media_random_hash','dd05164cc16b91fe7393db8b3cc9166e',NULL,'2025-06-10 10:47:21'),(11,'theme','eventify-homepage09',NULL,'2025-06-10 10:47:21'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:47:21'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:47:21'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:47:21'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:47:21'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:47:21'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:47:21'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:47:21'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:47:21'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:47:21'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:47:21'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:47:21'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:47:21'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:47:21'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:47:21'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:47:21'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:47:21'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:47:21'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:47:21'),(30,'theme-eventify-homepage09-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:47:21'),(31,'theme-eventify-homepage09-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:47:21'),(32,'theme-eventify-homepage09-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:47:21'),(33,'theme-eventify-homepage09-favicon','main/general/favicon.png',NULL,'2025-06-10 10:47:21'),(34,'theme-eventify-homepage09-logo','main/general/logo.png',NULL,'2025-06-10 10:47:21'),(35,'theme-eventify-homepage09-homepage_id','1',NULL,'2025-06-10 10:47:21'),(36,'theme-eventify-homepage09-blog_page_id','4',NULL,'2025-06-10 10:47:21'),(37,'theme-eventify-homepage09-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:47:21'),(38,'theme-eventify-homepage09-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:47:21'),(39,'theme-eventify-homepage09-blog_post_items_per_row','3',NULL,'2025-06-10 10:47:21'),(40,'theme-eventify-homepage09-number_of_related_posts','3',NULL,'2025-06-10 10:47:21'),(41,'theme-eventify-homepage09-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:47:21'),(42,'theme-eventify-homepage09-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:47:21'),(43,'theme-eventify-homepage09-events_page_id','5',NULL,'2025-06-10 10:47:21'),(44,'theme-eventify-homepage09-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:47:21'),(45,'theme-eventify-homepage09-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:47:21'),(46,'theme-eventify-homepage09-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:47:21'),(47,'theme-eventify-homepage09-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:47:21'),(48,'theme-eventify-homepage09-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:47:21'),(49,'theme-eventify-homepage09-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:47:21'),(50,'theme-eventify-homepage09-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:47:21'),(51,'theme-eventify-homepage09-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:47:21'),(52,'theme-eventify-homepage09-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:47:21'),(53,'theme-eventify-homepage09-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:47:21'),(54,'theme-eventify-homepage09-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:47:21'),(55,'theme-eventify-homepage09-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:47:21'),(56,'theme-eventify-homepage09-logo_height','45',NULL,'2025-06-10 10:47:21'),(57,'theme-eventify-homepage09-is_header_transparent','1',NULL,'2025-06-10 10:47:21'),(58,'theme-eventify-homepage09-display_header_top','1',NULL,'2025-06-10 10:47:21'),(59,'theme-eventify-homepage09-header_top_text_color','#ffffff',NULL,'2025-06-10 10:47:21'),(60,'theme-eventify-homepage09-header_top_background_color','#FD4E1A',NULL,'2025-06-10 10:47:21'),(61,'theme-eventify-homepage09-header_background_color','#1A1719',NULL,'2025-06-10 10:47:21'),(62,'theme-eventify-homepage09-header_text_color','#ffffff',NULL,'2025-06-10 10:47:21'),(63,'theme-eventify-homepage09-footer_background_color','#F7F5FB',NULL,'2025-06-10 10:47:21'),(64,'theme-eventify-homepage09-footer_text_color','#544E51',NULL,'2025-06-10 10:47:21'),(65,'theme-eventify-homepage09-footer_heading_color','#1A1719',NULL,'2025-06-10 10:47:21'),(66,'theme-eventify-homepage09-tp_primary_font','Figtree',NULL,'2025-06-10 10:47:21'),(67,'theme-eventify-homepage09-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:47:21'),(68,'theme-eventify-homepage09-primary_color','#FD4E1A',NULL,'2025-06-10 10:47:21'),(69,'theme-eventify-homepage09-secondary_color','#1A1719',NULL,'2025-06-10 10:47:21'),(70,'theme-eventify-homepage09-newsletter_popup_enable','1',NULL,'2025-06-10 10:47:21'),(71,'theme-eventify-homepage09-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:47:21'),(72,'theme-eventify-homepage09-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:47:21'),(73,'theme-eventify-homepage09-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:47:21'),(74,'theme-eventify-homepage09-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:47:21'),(75,'theme-eventify-homepage09-gradient_color_from','#FF5000',NULL,'2025-06-10 10:47:21'),(76,'theme-eventify-homepage09-gradient_color_to','#FF00B8',NULL,'2025-06-10 10:47:21'),(77,'announcement_max_width','1210',NULL,'2025-06-10 10:47:21'),(78,'announcement_text_color','#000000',NULL,'2025-06-10 10:47:21'),(79,'announcement_background_color','transparent',NULL,'2025-06-10 10:47:21'),(80,'announcement_text_alignment','start',NULL,'2025-06-10 10:47:21'),(81,'announcement_dismissible','0',NULL,'2025-06-10 10:47:21'),(82,'announcement_font_size','14',NULL,'2025-06-10 10:47:21'),(83,'announcement_font_size_unit','px',NULL,'2025-06-10 10:47:21'),(84,'announcement_placement','theme',NULL,'2025-06-10 10:47:21'),(85,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:47:21','2025-06-10 10:47:21'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:47:21','2025-06-10 10:47:21'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:47:21','2025-06-10 10:47:21');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:47:21','2025-06-10 10:47:21');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:46:29','2025-06-10 10:46:29'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:44','2025-06-10 10:46:44'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:44','2025-06-10 10:46:44'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:45','2025-06-10 10:46:45'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:45','2025-06-10 10:46:45'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:45','2025-06-10 10:46:45'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:45','2025-06-10 10:46:45'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:45','2025-06-10 10:46:45'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:45','2025-06-10 10:46:45'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:46:45','2025-06-10 10:46:45'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:46:51','2025-06-10 10:46:51'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:46:51','2025-06-10 10:46:51'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:46:51','2025-06-10 10:46:51'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:46:51','2025-06-10 10:46:51'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:46:51','2025-06-10 10:46:51'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:46:51','2025-06-10 10:46:51'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:46:51','2025-06-10 10:46:51'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:46:51','2025-06-10 10:46:51'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:56','2025-06-10 10:46:56'),(59,'kelli-mcglynn',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:56','2025-06-10 10:46:56'),(60,'emmet-fritsch',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:57','2025-06-10 10:46:57'),(61,'lilla-huel',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:57','2025-06-10 10:46:57'),(62,'ophelia-wolf',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:57','2025-06-10 10:46:57'),(63,'cooper-boyer',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:57','2025-06-10 10:46:57'),(64,'garry-fadel-phd',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:57','2025-06-10 10:46:57'),(65,'rick-mann',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:58','2025-06-10 10:46:58'),(66,'esta-wiegand',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:58','2025-06-10 10:46:58'),(67,'vinnie-cummerata',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:58','2025-06-10 10:46:58'),(68,'milan-stanton',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:58','2025-06-10 10:46:58'),(69,'frances-runte',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:59','2025-06-10 10:46:59'),(70,'dimitri-hessel',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:59','2025-06-10 10:46:59'),(71,'arden-gulgowski-md',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:59','2025-06-10 10:46:59'),(72,'prudence-nicolas',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:59','2025-06-10 10:46:59'),(73,'lyda-durgan',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:46:59','2025-06-10 10:46:59'),(74,'dr-rozella-spinka-ii',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:00','2025-06-10 10:47:00'),(75,'mackenzie-hintz',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:00','2025-06-10 10:47:00'),(76,'aileen-ortiz-v',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:00','2025-06-10 10:47:00'),(77,'vince-jerde',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:00','2025-06-10 10:47:00'),(78,'rachel-franecki-phd',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:01','2025-06-10 10:47:01'),(79,'mrs-cecelia-harvey',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:01','2025-06-10 10:47:01'),(80,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(81,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(82,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(83,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(84,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(85,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(86,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(87,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(88,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(89,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:47:08','2025-06-10 10:47:08'),(90,'mr-delmer-grant',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(91,'melany-greenfelder',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(92,'prof-dax-kemmer',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(93,'miss-antonia-rau-phd',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(94,'gerry-nienow',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(95,'neil-shanahan',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(96,'velva-bernhard',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(97,'monte-schinner',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(98,'mr-ted-frami-iii',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(99,'alivia-borer-md',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(100,'rachel-kunde',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(101,'kavon-nikolaus',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(102,'prof-joshua-sauer',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(103,'veronica-pfannerstill-sr',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(104,'brooklyn-ullrich',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(105,'dr-toy-purdy',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(106,'ray-fay',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(107,'mrs-aurore-stiedemann',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(108,'jayce-hermiston',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(109,'lonzo-friesen',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(110,'dewayne-kshlerin-ii',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(111,'zion-rice',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(112,'myra-mayer',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(113,'zora-gottlieb',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(114,'jalen-torphy',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(115,'syble-hermann',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(116,'eileen-dickinson',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(117,'margaretta-lesch',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(118,'joe-goldner',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(119,'amina-marquardt',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(120,'cleta-grimes-dds',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(121,'prof-wava-kihn',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(122,'prof-gus-monahan',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(123,'royce-daniel',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(124,'lavon-heller',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(125,'sunny-auer',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(126,'prof-crawford-dach',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(127,'birdie-cruickshank-dds',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(128,'dr-erica-keebler',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(129,'dagmar-pagac',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(130,'jean-douglas',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(131,'jaylon-schimmel-dvm',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(132,'dr-saige-orn',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(133,'cleveland-howell',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(134,'mr-ali-feil-iv',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(135,'dawn-quigley',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(136,'rodrigo-ratke',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(137,'dr-twila-hudson-jr',70,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(138,'rey-bernier',71,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(139,'colleen-schroeder-phd',72,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(140,'earnest-larson',73,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(141,'mr-nestor-rice-iv',74,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(142,'karianne-kerluke',75,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(143,'abbey-homenick',76,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(144,'miss-rachael-oreilly',77,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(145,'sarai-hegmann',78,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(146,'destiny-renner-iii',79,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(147,'cyril-wunsch',80,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21'),(148,'horace-hayes',81,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:47:21','2025-06-10 10:47:21');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:47:01','2025-06-10 10:47:01');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:46:51','2025-06-10 10:46:51'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:46:51','2025-06-10 10:46:51'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:46:51','2025-06-10 10:46:51'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:46:51','2025-06-10 10:46:51'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:46:51','2025-06-10 10:46:51'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:46:51','2025-06-10 10:46:51'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:46:51','2025-06-10 10:46:51');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:46:30','2025-06-10 10:46:30'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:46:30','2025-06-10 10:46:30'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:46:30','2025-06-10 10:46:30'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:46:30','2025-06-10 10:46:30');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'mrosenbaum@wilderman.com',NULL,'$2y$12$2w3G.RwWfy9e8YdAra/oQO5.1RS6qmhkeSQEXZZb77gQpTUWQ58Ya',NULL,'2025-06-10 10:46:29','2025-06-10 10:46:29','Verlie','Grimes','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage09',1,'[]','2025-06-10 10:46:45','2025-06-10 10:46:45'),(2,'SocialLinksWidget','header_sidebar','eventify-homepage09',2,'[]','2025-06-10 10:46:45','2025-06-10 10:46:45'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage09',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo-light.png\"}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage09',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage09',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage09',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(7,'EventListWidget','event_list_sidebar','eventify-homepage09',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage09',1,'[]','2025-06-10 10:46:45','2025-06-10 10:46:45'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage09',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage09',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage09',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage09',1,'{\"background_color\":\"#FFBA00\",\"button_label\":\"Buy Ticket\"}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage09',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:46:45','2025-06-10 10:46:45'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage09',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:46:45','2025-06-10 10:46:45');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:47:22
