-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'7Z9CIEoMRxfkYOBo1kSJdDSiFoilRVlF',1,'2025-06-10 10:47:35','2025-06-10 10:47:35','2025-06-10 10:47:35');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:48:24',NULL,1,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:48:24',NULL,1,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:48:24',NULL,1,'2025-06-10 10:48:24','2025-06-10 10:48:24');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Maxime expedita minus magni non beatae. Et velit et consectetur beatae non voluptatibus doloremque. Alias recusandae sint eum in molestias. Dicta voluptas modi dignissimos.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(2,'Leadership &amp; Strategy',0,'Aspernatur repellendus enim repudiandae qui id labore ut. Saepe adipisci odit et. Unde ex suscipit quos.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(3,'Networking &amp; Collaboration',0,'Omnis expedita laudantium est facere repellat dolor sunt. Facilis eius quis eos ipsam. Sint nulla sint enim et nam eos.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(4,'Entrepreneurship Startups',0,'Vel iure ea omnis saepe ea. Eligendi quis est sit est delectus harum voluptatum enim. Nemo iste aut quod vel ut tempora reprehenderit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(5,'Marketing &amp; Branding',0,'Quas asperiores fugit qui repudiandae. Ut eum ratione asperiores illum ea. Dolores aut sint possimus totam exercitationem sequi blanditiis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(6,'Event Highlights &amp; Recaps',0,'Cupiditate autem repellat beatae. Consequuntur occaecati deleniti ea possimus quam omnis voluptas. Veniam nemo quas ullam praesentium excepturi non aspernatur.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:47:57','2025-06-10 10:47:57');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Aurelie Connelly','hoppe.rosalind@example.net','+1-430-812-8070','1293 Mozelle Spurs\nPfefferview, MI 41107-3375','Velit quia nobis placeat repellendus.','Adipisci enim voluptatem voluptates aspernatur. Sint qui quia aut accusamus omnis rem. Et illo commodi aperiam nemo maiores vel molestiae. Qui voluptas quia quia eum ratione temporibus qui quia. Sit quod nemo deserunt laudantium ullam nostrum. Necessitatibus sed voluptas ut et explicabo consequatur harum. Blanditiis maxime consequatur hic qui placeat. Repellat quo ad ea saepe id ex autem pariatur.',NULL,'read','2025-06-10 10:47:35','2025-06-10 10:47:35'),(2,'Mrs. Hertha Lang Sr.','destany26@example.org','1-330-838-1150','7819 Collins Orchard\nBreitenbergside, TN 46017-8155','Quisquam vel culpa non inventore et quo.','Accusamus excepturi aut mollitia ut commodi quo. Iure nesciunt temporibus sunt. Debitis cumque minima consectetur quis culpa illo hic. Occaecati est totam quo itaque vel. Impedit et sequi accusantium. Repellat aspernatur molestiae distinctio impedit laborum voluptatibus minima. Repudiandae minima alias voluptatem incidunt. Itaque tempore autem qui et repellat facilis facere. Velit maiores aspernatur commodi sit. Culpa temporibus ea et sunt. Dolores est soluta pariatur et blanditiis ex nobis.',NULL,'read','2025-06-10 10:47:35','2025-06-10 10:47:35'),(3,'Austin Conroy','julie28@example.com','+1.515.645.4055','719 Jayson Stravenue Suite 575\nUptonburgh, WY 38251','Qui rerum dolores voluptatem natus.','Atque enim id minus quasi facere et laboriosam. Commodi tempore quia quaerat tenetur porro. Qui molestias sint praesentium aut quo. Qui accusamus fugit similique eos optio repudiandae cum. Blanditiis illo illum et eius. Cumque hic alias dolores veritatis expedita. Temporibus voluptas occaecati quidem quia maxime sint. Odio consectetur id ea aut sed.',NULL,'read','2025-06-10 10:47:35','2025-06-10 10:47:35'),(4,'Prof. Christopher O\'Kon','gilbert.mueller@example.net','+19897045616','65495 Lesch Brooks Suite 804\nAshashire, SC 71599','Doloribus aperiam et ea praesentium sint quis.','Ad quam eveniet illo dolorem. Magnam et vel dolorem et laborum rerum dolorem. In ad excepturi aliquam quae sint quae voluptatem quia. Deserunt quo hic totam dicta. Incidunt at voluptatem quibusdam pariatur porro. Quia aut doloribus quidem velit omnis quasi. Enim et nostrum quasi sit optio saepe eaque. Atque magni iure saepe in vero. Et similique laudantium omnis voluptas sint vel. Optio non sint odit voluptas quod eligendi. Officia quod quia amet ea.',NULL,'read','2025-06-10 10:47:35','2025-06-10 10:47:35'),(5,'Fermin Lemke','jauer@example.com','+1-847-940-4004','4748 Christiansen Ridges Suite 341\nPedroberg, CT 92936-5536','Non sed cupiditate aut est.','Quibusdam voluptatem voluptatem rerum id. Ut fuga iusto delectus recusandae facilis eaque. Cupiditate non laboriosam facilis nemo voluptatum iure enim. Voluptatem animi similique ut ab voluptatem qui delectus. Ab ut veniam consequatur. Animi asperiores sit optio sint. Laboriosam deserunt recusandae molestiae dolor tenetur dolor. Aperiam et repudiandae totam quos natus nihil quia. Fugit rerum repudiandae vel ea ut soluta. Nihil velit quia cum consequatur qui autem necessitatibus est.',NULL,'read','2025-06-10 10:47:35','2025-06-10 10:47:35'),(6,'Salvatore Rau','ugrant@example.net','+1-401-278-4259','2960 Towne Mountain\nWest Monastad, NV 77329-3032','Quis qui eos excepturi ipsam consectetur sint et.','Incidunt ut pariatur nihil dolor similique reiciendis. Quis quis saepe voluptatem cumque voluptas odio. Accusamus esse aut ut laboriosam sint. Voluptas quam iste quo vero eius. Tempore a nostrum ducimus. Possimus dolore nostrum itaque sint est. Et sit cum saepe consequatur labore et atque est. Accusantium ut sed labore. Et quo voluptatem consequatur et.',NULL,'unread','2025-06-10 10:47:35','2025-06-10 10:47:35'),(7,'Dr. Emmett Parisian','maia80@example.net','949-588-4323','9428 Shanny Orchard Suite 299\nDavisland, NY 03906','Earum libero magnam aspernatur repudiandae.','Esse occaecati labore sit ut reiciendis qui. Molestias corrupti voluptas molestiae odio recusandae earum esse quaerat. Quia placeat quo molestias possimus neque eveniet tempora non. Nulla dolores voluptatem molestiae qui laborum ut. Ut assumenda et facilis occaecati consequatur accusamus. Sed ea laborum autem debitis distinctio. Quia est doloribus eaque quis qui pariatur exercitationem. Repellat exercitationem accusamus sunt nihil aliquam in. Nisi eos iste magni aut ea sed.',NULL,'unread','2025-06-10 10:47:35','2025-06-10 10:47:35'),(8,'Germaine Bednar','nestor81@example.com','(339) 310-9262','419 Stanton Isle\nArmstrongmouth, ID 78380-5103','Unde qui vitae ipsum rem.','Quia sunt ullam corporis iusto sit necessitatibus quas. Accusantium alias qui et et sit est et. Aut eius repellat rerum ducimus. Expedita cupiditate sit nulla officia neque vel necessitatibus amet. Et praesentium dolores beatae rerum. Debitis laboriosam iure et aperiam laborum quaerat. Id labore quas in fugit repellat. Quibusdam est ullam esse voluptatibus quia delectus quidem. Laboriosam sed exercitationem ut eligendi est accusantium.',NULL,'unread','2025-06-10 10:47:35','2025-06-10 10:47:35'),(9,'Rozella Volkman','wjohnson@example.com','+12242146186','56252 Jones Manor\nSalvatoremouth, FL 76916-3395','Sequi quo quia dolores.','Ut consectetur consequatur cumque voluptas voluptatem quia. Sapiente voluptatem dolor molestias vero tempora. Quo aut qui sit. Nemo quidem ipsam voluptates voluptatibus. Pariatur similique qui temporibus aut rerum placeat. Sit perferendis ea voluptate modi vel. Explicabo minus voluptatibus temporibus vel assumenda quis voluptas consectetur. Unde neque quo molestiae delectus molestiae rerum. Ut quisquam minus quia. Ut amet omnis velit atque nihil eum molestiae.',NULL,'unread','2025-06-10 10:47:35','2025-06-10 10:47:35'),(10,'Meghan Thiel','alexandro.spencer@example.net','1-928-428-3586','188 Theodora Summit\nNew Josefort, HI 82629','Dicta non sapiente quae et.','Quam in et voluptate sunt recusandae at. Deleniti omnis ipsa unde dolores. Doloribus totam vero voluptas ipsum molestiae numquam inventore architecto. Temporibus aliquid alias reprehenderit asperiores eligendi ut tenetur. Autem laboriosam labore hic voluptatem facere nisi similique nostrum. Excepturi recusandae dolorum incidunt unde quis. Ut vel quia sunt totam quo eum alias. Illum dolores perspiciatis quidem quae. Est et quia sunt amet veniam maiores possimus aspernatur.',NULL,'read','2025-06-10 10:47:35','2025-06-10 10:47:35');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:48:07',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:48:07',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:48:07',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:48:07',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:48:07',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:48:07',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Carmela Mante','customer@archielite.com','$2y$12$a5V.jRXUtoHX0e1hju7Vj.eG7zuOHsz3fsBrBiqY0jdT/h5jQbWra',NULL,'0782196448','2020-10-19','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:02','2025-06-10 10:48:02'),(2,'Michael Smith','maggie.ratke@zulauf.org','$2y$12$b2h4VlGN/gA.JZbZPpPFSegSB7/exW9vOiWysA7dWFvCyAu6qpHJC','main/speakers/10.png','0640910399','1995-11-15','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:02','2025-06-10 10:48:02'),(3,'Joanne Cormier','cale23@hills.com','$2y$12$mM7NTMCp.svsbDh6C2e/w.IuZ1YukcRXokdt/LMCNqlGeOw7efoSe',NULL,'0058539905','2024-09-01','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:02','2025-06-10 10:48:02'),(4,'Adele Klocko','austyn.lubowitz@yahoo.com','$2y$12$wD6XzD0w.88WQou/eToQJumougURxFq/8EnXuZJH7PPZ/kDCKKl9e',NULL,'0749154879','2014-09-04','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:02','2025-06-10 10:48:02'),(5,'Dr. Christine Kautzer Sr.','brando93@goyette.biz','$2y$12$0iQUq.SDw.7QcDvh7oal8e7U8aZ0/yvpKej0iaCSp5vgbG8i9KTJK','main/speakers/5.png','0958936625','2008-03-31','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:02','2025-06-10 10:48:02'),(6,'Orie Cartwright Jr.','demetrius73@hotmail.com','$2y$12$6dhGWzQDtFlh5.tbxosoUuno.7LXSD0KOb12b40YoTHBG.661oLnm','main/speakers/4.png','0708144504','1998-01-26','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:03','2025-06-10 10:48:03'),(7,'Prof. Rebeca Fisher','declan.stamm@yahoo.com','$2y$12$ri7dkTCGS4qcVNr2mnXzaeox6yaZlWAmd2nR0HFOr9g2.WPKvLpAK','main/speakers/9.png','0679593313','2011-05-22','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:03','2025-06-10 10:48:03'),(8,'Prof. Frederic Farrell','grimes.damian@purdy.com','$2y$12$i.6x2WXoVOdveCSUprRqoeneJvZhOPA005xxarwMhUeSkWyKbSPY2','main/speakers/10.png','0517348503','2022-12-01','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:03','2025-06-10 10:48:03'),(9,'Dr. Pansy Schimmel','casimer25@hoppe.com','$2y$12$7Ljz0LYBohWCYhsOWmBPKe1paJeLv9y7VcHvlEacW9kXA9Z6nkMCe',NULL,'0134981641','2014-07-15','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:03','2025-06-10 10:48:03'),(10,'Orpha Ziemann','vbeer@gmail.com','$2y$12$aaGjbGoXh.CarxyrxhQKV.cJiNae1B2DgTMk4b4KBy7JTYy/00kSi','main/speakers/8.png','0319813563','2022-08-24','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:03','2025-06-10 10:48:03'),(11,'Mrs. Jade Jerde','xgutmann@johnson.com','$2y$12$B05UJ2S.bG/qGr7An6Mo/.0zpQ2oAFpW/xsO1y6T8XuDTh6NpUgyO',NULL,'0335934252','1996-05-04','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:03','2025-06-10 10:48:03'),(12,'Lesley Beer','torp.natalia@yahoo.com','$2y$12$olycEbrAYnDASkclfda7Nu7J0XQx2lhcod6iTIlbzXX/QDJY6.pa6','main/speakers/4.png','0603929007','2006-12-15','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:04','2025-06-10 10:48:04'),(13,'Kelsie Strosin','rachael78@yahoo.com','$2y$12$x3AHzUMK.iyakqexxSgUfOxqQaYCs9ORnfssiAqnu3zqbdktpECAu','main/speakers/10.png','0914133300','2022-11-06','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:04','2025-06-10 10:48:04'),(14,'Leanne Anderson PhD','morar.lora@rempel.com','$2y$12$7hzmCAoqZ4gCQJQGvqI1xOfh6J2D.Fb7ygpAN3.dSzW4CdQjP9eEe','main/speakers/4.png','0412585855','2016-03-28','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:04','2025-06-10 10:48:04'),(15,'Dr. Modesta Tromp','rmurray@hotmail.com','$2y$12$ss3RucCLKrtdsNRT1apQ0OAGIal9rZ7ZbMUtvkmOsC.xUOIOANmrC','main/speakers/8.png','0169036182','1997-12-13','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:04','2025-06-10 10:48:04'),(16,'Greta Toy','lpagac@labadie.org','$2y$12$efKMAjg1jeJtd3jjsEbRPu/AzghSl/yLraE6NP9XnSauHCsWd3KhO','main/speakers/3.png','0946298394','2007-04-15','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:04','2025-06-10 10:48:04'),(17,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','$2y$12$zTurvrGFnoIDvNyxEZNZ4O5O35OqkTBZIIaQ.89mOT5TOMLGKlWPi',NULL,'0893355958','2020-10-06','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:04','2025-06-10 10:48:04'),(18,'Prof. Garrett Dooley V','claire21@gmail.com','$2y$12$Xsh7hXqeGmgbHe.GFcMZH.ikpwrdmZ1elC0/14KXq13v6slXH7CjS',NULL,'0021041111','2024-12-30','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:05','2025-06-10 10:48:05'),(19,'Dwight Rath','smith.kasey@hotmail.com','$2y$12$kr3JbRjG46mxcXtime77BecpKvboduFGg1WeB/F4oNworGOzcqjM.',NULL,'0330377072','1999-04-21','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:05','2025-06-10 10:48:05'),(20,'Ella Kilback DDS','jaylan.haley@gmail.com','$2y$12$/q5SfzZwM67LO0/3gKNVCun4aOgL1WcDE7YW37qS0tvNsIKofSJ5i','main/speakers/5.png','0216138694','2008-09-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:05','2025-06-10 10:48:05'),(21,'Prof. Brock Lehner IV','elinor96@boehm.com','$2y$12$.g8sPSP9FqIIiHr21Zy5R.TJaRnmkeqqakH/8Tr3g50xzxqKzCaE2','main/speakers/2.png','0300394414','2001-12-30','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:05','2025-06-10 10:48:05'),(22,'Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info','$2y$12$.OrIrlLtBxC9res367IxtOEDm/ihn2vdphDWciJ48CbMO5xlUYS3S',NULL,'0406367329','1996-04-25','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:05','2025-06-10 10:48:05'),(23,'Marlee Jenkins DDS','thad.gusikowski@heller.org','$2y$12$2LjNHD5rIuKl45rdohLapOnP6CvSYm6EDyL3FqGiJpdBUfQX4B1qe','main/speakers/6.png','0297693601','1996-12-22','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:06','2025-06-10 10:48:06'),(24,'Prof. Jamar Deckow','beatty.claude@prosacco.com','$2y$12$pxs/xGX9j5IbOws2X0CMp.KF2kWsICgHVz1MLoWRLNilJkhK.J1Si','main/speakers/2.png','0746235533','1998-06-15','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:06','2025-06-10 10:48:06'),(25,'Shea Vandervort','konopelski.judge@hotmail.com','$2y$12$EJ60W2sv8XgLI/uKmmspRe7CsccS1rgf067VASGlEu7cEweRItyOS',NULL,'0832220635','2016-01-02','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:06','2025-06-10 10:48:06'),(26,'Miss Nikki DuBuque','merl.harvey@hill.org','$2y$12$3GULRdVlK2DxgGtpndwGnuh50lAVj5Do2V8FjiqEP9bUcL0oxFWzu','main/speakers/3.png','0521069771','2006-04-02','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:06','2025-06-10 10:48:06'),(27,'Caroline O\'Keefe','lela44@stanton.org','$2y$12$krNj89aFIGr/gkWwxYApaOpsHQlOQzK8PX3A02sx8IkfHAgdqGNxy',NULL,'0024798282','2020-05-08','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:06','2025-06-10 10:48:06'),(28,'Alize Stark','streich.jaylan@lindgren.biz','$2y$12$VI2iBk3eYbydZD.b5/tcwOmQRyEHf1IWunXaElqRWaHhjets3QVdG','main/speakers/2.png','0655727336','2022-02-15','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:06','2025-06-10 10:48:06'),(29,'Allan Conroy','spollich@gmail.com','$2y$12$9D0YW3t1gnDGGSRUBc13Q.KWhIlquIWP8BDTWBxiDEn7sTuQuvuLK','main/speakers/7.png','0594532410','2020-09-12','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:48:07','2025-06-10 10:48:07'),(30,'Candace Bashirian','orrin74@hotmail.com','$2y$12$ArDkPkvBeaAXCYQv3IKFiuySDmHRaJnZzHBx2zMCUo3AJLBNjy7Iq','main/speakers/4.png','0126415625','2023-10-08','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:48:07','2025-06-10 10:48:07'),(31,'Dr. Chet Feil','bode.theodore@medhurst.com','$2y$12$63Qx9SxrTSOV/ANtJTf0HOIMYzsvmKdVmD3bCkXkmfHCQNu0d..TK',NULL,'0331579518','2017-12-19','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:07','2025-06-10 10:48:07'),(32,'Felicia Becker','corwin.art@yahoo.com','$2y$12$XKtdMmjoxT/LYaTdYs15pehJaA382MANYf.PLOw4NrUT32XFLjNgC',NULL,'0695134477',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(33,'Leopold Cole','charlotte.veum@yahoo.com','$2y$12$vtcGzvKGRJyl56i6FnHSbeiUVvV28jLEdfVkA8k/xpYuihCS2BkMu',NULL,'0166882562',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(34,'Dr. Tessie Heller Jr.','pfannerstill.julio@hilpert.info','$2y$12$pSeqL6P7q0seYpB6LnCWFO9kNI2W6dZdEP6aGwxNIKsfc3kCnIqSm',NULL,'0047666738',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(35,'Abdul Hamill','darron.batz@ullrich.org','$2y$12$n9BvawKdxcO963ZmQYN7x.tFPLHGdNiKomUVjpI7GunZ9AYNJmj/i',NULL,'0134930331',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(36,'Laury Erdman','wilkinson.verna@hauck.com','$2y$12$5mi85gCl9or9in/AW7NfDeUbXt5D0Ad6edXJzaqH8Le3yvlnndUie',NULL,'0918204787',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:19','2025-06-10 10:48:19'),(37,'Peyton Borer DDS','audie.strosin@yahoo.com','$2y$12$rMAqy7PUJlM.4idmBRajPeUPE9pG29usnugE2rGnfxZLZvkmhvpma',NULL,'0128348133',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:19','2025-06-10 10:48:19'),(38,'Nicolas Hoeger','noble85@sporer.org','$2y$12$rmMR1Cup5Enc4IjDwrooV.L0lL5lB5lH870kvQEswCER7CjZiM192',NULL,'0841918506',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:19','2025-06-10 10:48:19'),(39,'Cindy Macejkovic','ukozey@wilderman.biz','$2y$12$wv.RhB220O5wNdsTCtq1mOW0uCIo6hOhi5Oe85HS3VCFs6cOlIS1G',NULL,'0916119580',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:19','2025-06-10 10:48:19'),(40,'Wyatt Kulas','qsimonis@daugherty.com','$2y$12$mIVISHT9Igz7DkuAl7j09uuGMaD7ZsUwQHPwhB8Iweu3xf75B/VmG',NULL,'0215216045',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:19','2025-06-10 10:48:19'),(41,'Mr. Trace Williamson','hudson.camryn@schowalter.org','$2y$12$S0caJXF4.TBDhFjw.hfkH.0e6uOSu.7IxRYh5iSQZzDmcWnVXsU4y',NULL,'0019665355',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:19','2025-06-10 10:48:19'),(42,'Austyn Hermiston','henriette.ward@jacobson.org','$2y$12$3bkRQO79UCWbWZJwkqt4aeQJY1qtf2BXVegqvNXmzss6utG1amWqK',NULL,'0679389723',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:19','2025-06-10 10:48:19'),(43,'Melyssa Boehm','luella62@hettinger.com','$2y$12$7wrwSwzpzOePzwDpQJoujudgIcYYPO3a6Ns9X0qbQ0EH.3Sd4uVNK',NULL,'0960800118',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:20','2025-06-10 10:48:20'),(44,'Rhoda Ankunding','meta.wolf@hotmail.com','$2y$12$QUg4fhULVFn4gCeTywUpL.F1gd0zUUFVhU9poRwvtQlZ1G.c3AAlW',NULL,'0581840581',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:20','2025-06-10 10:48:20'),(45,'Mrs. Domenica Ruecker','nolan.geo@hegmann.biz','$2y$12$Ji4ZU.650fjPZNiH1JX4z.6bj55HKSFWXpiSgl4Vzc5BbI9KEHj8y',NULL,'0351236838',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:20','2025-06-10 10:48:20'),(46,'Misty Hermann','name.wintheiser@funk.com','$2y$12$e8zmknMIeXOHjNWeHp/l8.D7uCk8bH16HDfgDOT2qT14AoJlrZfhK',NULL,'0488995241',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:20','2025-06-10 10:48:20'),(47,'Cooper Douglas','ewald88@yahoo.com','$2y$12$MinBv5LtCy5v/zV1xylXVOexUvD5.ZWi2dByxae6ctboknOBpUKue',NULL,'0794678888',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:20','2025-06-10 10:48:20'),(48,'Dr. Maude Frami MD','lysanne55@hotmail.com','$2y$12$m17swi3kcK/Cb8Fk2txyy.xntyr5VqvdHqHNtThzSqrsapp2RUDZ6',NULL,'0302825044',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:20','2025-06-10 10:48:20'),(49,'Sarah Schuster','mervin.fahey@yahoo.com','$2y$12$UEV35HbenrUUE4PDLUgdLe926zzo49ZdS8.1umYF/1ckqsRJUqiE.',NULL,'0085227727',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:21','2025-06-10 10:48:21'),(50,'Treva Wyman Jr.','weber.sherman@rau.com','$2y$12$mCTbvLrmXzodsxnPMpyyQufFa3qCyKnPGdqeerogCa3ReVJunq5vy',NULL,'0947562128',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:21','2025-06-10 10:48:21'),(51,'Carolina Gusikowski','laisha53@kling.com','$2y$12$dKdt6Q2KRZ4mL2usGH/m7uUMZqS2dTiU0.1PZiMYBlZFPK.Io2mgO',NULL,'0245828712',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:21','2025-06-10 10:48:21'),(52,'Prof. Oda Morissette','harmon.friesen@gorczany.com','$2y$12$4ykA6cQO13nqNh04ae6osOTcf3WLl9jRGq.YZC5ugiLn3a8PhWjKC',NULL,'0180453644',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:21','2025-06-10 10:48:21'),(53,'Daphnee Schaden','langworth.tiara@hotmail.com','$2y$12$P0n34tSzXNRssQ/lMheSnO62qM4BFRFSfEK6sCoIqfyB/w1LOuaRC',NULL,'0182876477',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:21','2025-06-10 10:48:21'),(54,'Mr. Judah Wolff','lindsay65@hammes.com','$2y$12$z8iIeSwhR9CP3OJkAS7YkeVbuNVRtUl0CqdOacAkWu0PET16I1GNu',NULL,'0244050481',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:21','2025-06-10 10:48:21'),(55,'Jamil Altenwerth II','ybrekke@gmail.com','$2y$12$aKZxazI.ltUzlw39dzgCN.2GKbqbmnBtM0tlAC/noCvGbiH/./Ria',NULL,'0606920190',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:21','2025-06-10 10:48:21'),(56,'Susana Barton','considine.nellie@gmail.com','$2y$12$M6dbl3jBNzpTG2hRPHt8ZuHdO8zGij6390GuIF5ttUC1ccBMbiLMe',NULL,'0650427902',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:22','2025-06-10 10:48:22'),(57,'Adriana Ratke','arno.bednar@kreiger.org','$2y$12$x.fPtVPaJktJ7dCD/YmBpOg3M/TXYhGbvD3bvyDaHJrAR5JZ0LLee',NULL,'0261967983',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:22','2025-06-10 10:48:22'),(58,'Andreane Halvorson','jaeden.prohaska@hotmail.com','$2y$12$xj0pyPEmXNSEZYcnFA9cYuErV2WcGGr0qKkRC5uHHxC/Lo9xJGRU2',NULL,'0394302515',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:22','2025-06-10 10:48:22'),(59,'Lucious Braun','johnston.stanton@gmail.com','$2y$12$/5S.nE9GH9lpXv.RksCRse3ZOEnH5Z9kbsfmDjoGtFz735kOuM8se',NULL,'0457976131',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:22','2025-06-10 10:48:22'),(60,'Brannon Kuvalis Sr.','uschamberger@gmail.com','$2y$12$9S/CGuRHEeITyFA02xCs1.h.LBXBgPl8N3t0o0royiD95zMcWxX7S',NULL,'0913639470',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:22','2025-06-10 10:48:22'),(61,'Larue Kessler','clotilde.jacobi@donnelly.biz','$2y$12$rh.Cti7SKhjTGE52lvBsGOI1Cuo0q287jZl5cBGvXttvdngAYCNyy',NULL,'0576436541',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:22','2025-06-10 10:48:22'),(62,'Sammie Hagenes','laurie.gerhold@yahoo.com','$2y$12$HLbS19yYSI.dURfj3xw.iuWm7t5cR0CK/ivovUmXjN5My6V.VAWlW',NULL,'0368312281',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:22','2025-06-10 10:48:22'),(63,'Mr. Edward Bins','susie34@yahoo.com','$2y$12$NjBd4IablbPI/UeJqAPN6u0LIqudWUVyJ1hfryNFEOho9zMES292S',NULL,'0869812785',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:23','2025-06-10 10:48:23'),(64,'Drew Gibson DDS','eduardo.thompson@gmail.com','$2y$12$AWra7cNU.fQay858gmoW.ei7wLRFdTopul6onnOHtcw3scCR8bAoO',NULL,'0651305246',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:23','2025-06-10 10:48:23'),(65,'Madge Lebsack','tara.marks@shields.net','$2y$12$AU3Q/GuX0rfbEZmQ9juQZuKOll5BAbC2wMWtYr46zpYrkvlXJ4jPy',NULL,'0335245415',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:23','2025-06-10 10:48:23'),(66,'Timothy Mraz','christa.spencer@yahoo.com','$2y$12$Eq1x4YB2YNxaOvL4/ZOLLOhsxywEIlM2C7EfAcszxKPazwyNwsS5m',NULL,'0686988210',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:23','2025-06-10 10:48:23'),(67,'Syble O\'Conner','shields.alessandra@yahoo.com','$2y$12$zRNmssQEdlGc8OHHTQl3te/UwUti2T4huUuD8dNxGDs/3QE.FxwQu',NULL,'0792796861',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:23','2025-06-10 10:48:23'),(68,'Lloyd Beatty DDS','moen.domenick@gmail.com','$2y$12$tNu.uBIBX7fQM2hC41YyNuNcrgAOZu8l9Dx5WH1XdrNcck7pQGI5y',NULL,'0511417106',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:23','2025-06-10 10:48:23'),(69,'Ms. Rachelle Lubowitz II','dkirlin@gmail.com','$2y$12$szUnV6ZkrWk0Sl5m78VrJ.T92tRQvq4AZ3QL/LAM1.yvh.kpv45t2',NULL,'0243016974',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:23','2025-06-10 10:48:23'),(70,'Troy Hoppe','maximillia.klein@hotmail.com','$2y$12$oNqUAgCY/smUBlwvhyCLTuzkV8x/UD9txsog4p7iHXch6m8mKlUUK',NULL,'0481744725',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(71,'Westley Pollich','kirk.champlin@bauch.com','$2y$12$wGjZ9Coo.Mq4OVsDkKVUYue4OFXlMyx5vzf/dNISOvPgsq7KjLtfS',NULL,'0346125135',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:48:24','2025-06-10 10:48:24');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:47:28','2025-06-10 10:47:28'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:47:28','2025-06-10 10:47:28'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:47:28','2025-06-10 10:47:28');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (3,46,'1APCGYEUVM69',NULL),(1,35,'1UNAB9TCOGUU',NULL),(5,68,'1ZYTQAUG4QM4',NULL),(5,70,'8XLYZG3O2IMV',NULL),(1,37,'97EL3BKDDHVV',NULL),(4,59,'ADXM51S1X2KH',NULL),(3,51,'AKV058AFRE7Y',NULL),(5,69,'BITGHRWRZ992',NULL),(1,33,'BNUDYVKML7P7',NULL),(3,43,'CNC5PFPHMTCO',NULL),(2,41,'D54YGZ9K6TOE',NULL),(3,47,'ESQOFQBW5VSC',NULL),(5,64,'FEVYORTLWIWY',NULL),(5,62,'HO46GV4MLWKO',NULL),(3,55,'JCECNFYGJYQG',NULL),(3,45,'K8LOLI3ZJK6V',NULL),(1,39,'KG5NGV9LNKXU',NULL),(5,63,'LPZC4MGJGI4X',NULL),(2,40,'LVYUYVLFJ9KQ',NULL),(1,32,'NVAAYLJNXE3J',NULL),(4,56,'O3ZWHFJZ1OVC',NULL),(5,67,'OUOKUUCAPTWE',NULL),(5,71,'Q43P5DX1NNAE',NULL),(1,36,'Q8UVDRY2TCZQ',NULL),(4,57,'QI8ZHAWFWRCU',NULL),(3,53,'SDDEYAKUUH49',NULL),(2,42,'SDLPFBC7VYBY',NULL),(1,34,'SI6IMJE2FPKZ',NULL),(4,61,'SKZADJSIALKW',NULL),(3,44,'T8KRHCSAQSR4',NULL),(4,58,'TG9E25ASENXM',NULL),(3,52,'TMRG4PBA4P5J',NULL),(3,50,'TP8NPRWSS1OF',NULL),(3,49,'TYEH7S8I4KJI',NULL),(1,38,'UN4H1NJPOE5U',NULL),(3,54,'VASKOO87PD1T',NULL),(3,48,'VDVO1JWCGFMF',NULL),(5,66,'WE8NJYJXE06S',NULL),(4,60,'XTCQXNT30EI9',NULL),(5,65,'ZU4ARADSMU8H',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,12,'Voluptatem minima nemo quaerat debitis ut doloribus esse. Deleniti dolorem illo non qui fugiat et.',NULL,0,NULL,NULL),(1,7,'Provident consequatur et a. Iusto ut voluptas unde impedit distinctio.',NULL,1,NULL,NULL),(2,7,'Veritatis aliquam voluptates fuga. Officia blanditiis ut deserunt modi ea rem.',NULL,0,NULL,NULL),(2,10,'Aspernatur a quia iusto sed iste et. Similique non hic enim.',NULL,1,NULL,NULL),(2,28,'Voluptas qui minima quaerat. Delectus adipisci aut deserunt voluptatum ut deserunt nulla.',NULL,2,NULL,NULL),(2,30,'Quod aut velit natus est. Dolorum non quod dolore maxime. Debitis facere ratione aut ea alias sit.',NULL,3,NULL,NULL),(3,5,'Labore rem accusantium officia nihil similique fugit ea. Molestiae distinctio fugiat voluptatem.',NULL,0,NULL,NULL),(3,10,'Sit odio necessitatibus sint illum. Voluptas qui voluptates nihil.',NULL,1,NULL,NULL),(3,30,'Nihil aut non et. Eligendi nobis dignissimos magnam.',NULL,2,NULL,NULL),(3,12,'Quae natus repellendus ut. Libero odio doloribus voluptatem nihil quo.',NULL,3,NULL,NULL),(4,12,'Provident dicta modi eveniet. Ut fugiat impedit nostrum numquam. Enim impedit quasi odit vitae.',NULL,0,NULL,NULL),(4,7,'Ut quas eaque vitae asperiores et quia eum. Tenetur ab in magnam amet fugiat iusto soluta.',NULL,1,NULL,NULL),(4,5,'Delectus hic itaque qui aut voluptatem dolores. Itaque nobis consequuntur sunt molestias saepe.',NULL,2,NULL,NULL),(4,10,'Aut commodi aut aut beatae. Ut sequi voluptas cum sunt at voluptas.',NULL,3,NULL,NULL),(5,20,'Minus cum quod consequatur modi enim excepturi. Voluptatem magnam quam enim voluptatem rerum et.',NULL,0,NULL,NULL),(5,28,'Fugiat deleniti expedita facere est vel. Ullam totam commodi illo omnis adipisci necessitatibus.',NULL,1,NULL,NULL),(6,28,'Aliquam ducimus ut rerum. Ut aut qui aperiam aperiam quod id praesentium nam.',NULL,0,NULL,NULL),(6,12,'Rem cumque ut dolores quasi illo modi. Enim natus deserunt doloribus ex corporis.',NULL,1,NULL,NULL),(6,7,'Quia iusto deserunt ipsa odio. Animi ea voluptatum aut occaecati asperiores. Et sed iusto facere.',NULL,2,NULL,NULL),(6,5,'Qui id officiis quisquam beatae. Dolorum sint repudiandae illo numquam voluptas reiciendis.',NULL,3,NULL,NULL),(7,30,'Aut fuga quia labore sunt sit ipsam qui atque. Earum ut eveniet et occaecati corrupti.',NULL,0,NULL,NULL),(7,20,'Nemo voluptas sint maxime ipsa. Hic architecto necessitatibus reprehenderit id dolore.',NULL,1,NULL,NULL),(7,28,'Dolores sunt eos iusto reprehenderit. Numquam sed sed expedita facere et. Iure quia dolores cum.',NULL,2,NULL,NULL),(8,5,'Fugiat rerum sit ut esse libero. Reprehenderit eos quia et. Culpa illum qui aut placeat aut et.',NULL,0,NULL,NULL),(8,28,'Debitis ex quia recusandae at. Dignissimos non aliquam autem.',NULL,1,NULL,NULL),(8,12,'Ab fugiat sunt velit quaerat esse beatae. Id amet ad fuga laboriosam aut soluta.',NULL,2,NULL,NULL),(8,10,'Quia quo possimus voluptates vitae. Distinctio quis ea sed occaecati nemo non omnis saepe.',NULL,3,NULL,NULL),(9,7,'Tempora labore consequuntur nihil quaerat in. Omnis itaque error aut expedita ipsum pariatur.',NULL,0,NULL,NULL),(9,12,'Ex aut rerum ut voluptas vitae architecto non. Sed at et exercitationem atque sapiente sunt.',NULL,1,NULL,NULL),(9,28,'Et expedita sunt inventore maiores. Voluptate architecto iste sunt exercitationem quis quia.',NULL,3,NULL,NULL),(10,10,'Sit eius magnam harum. Placeat at voluptates consequatur occaecati perspiciatis magnam.',NULL,0,NULL,NULL),(10,30,'Sed quidem reiciendis eum adipisci autem et. Et suscipit harum ipsum deserunt possimus aut.',NULL,1,NULL,NULL),(10,6,'Illo velit harum et expedita dolor omnis quos sequi. Alias ipsam sed veniam velit quo vero ut quia.',NULL,2,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',14,'Non illum consequatur et non quidem ab inventore.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','7ff687ff-66f4-3c5c-a981-588885749550','main/events/1.webp',81.26,'5332 Carter Haven Suite 171\nSamantaport, IL 54274-8655',4,4,4,'13.846156','109.495835',87,0,'2025-06-10 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(2,'Mobile World Congress',21,'Sapiente quam illum aut quae placeat ipsam.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','28e7348f-5eb0-373b-b0e5-3bbe2904f0cc','main/events/2.webp',94.00,'889 Mohr Course\nSouth Domenickshire, MA 68308',2,2,2,'58.449466','90.718655',100,0,'2025-06-10 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(3,'Google I/O',15,'Unde est facilis omnis.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','dc493304-c2ed-3204-8de9-39097fdb1981','main/events/3.webp',68.71,'533 Greta Harbors\nSouth Amos, OR 46570-1389',4,4,4,'-71.226517','-135.471856',77,0,'2025-06-10 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(4,'Apple WWDC',29,'Corporis earum aut dolores quidem quo consectetur maiores.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','fce0ad02-fed6-34e2-b606-81d2d93fb3d3','main/events/4.webp',29.68,'670 Hackett Rapid Apt. 008\nNorth Dee, UT 95831-1606',3,NULL,NULL,'31.19791','66.376967',90,0,'2025-06-10 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(5,'AWS re:Invent',16,'Quisquam nihil corporis tempora ut.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','49a906e2-bf2d-3591-aee3-92c3b8fd62e2','main/events/5.webp',34.67,'70097 Aubree Hollow\nNew Adriennechester, MS 66683',2,2,2,'56.910889','-63.484442',58,0,'2025-06-11 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(6,'Microsoft Build',14,'Accusantium exercitationem laborum autem et aut.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','9a42c978-e86c-3107-b242-84318565c0f6','main/events/6.webp',63.80,'4548 Green Shoals Suite 683\nWest Kian, AR 97217',2,2,2,'39.05165','105.126334',73,0,'2025-06-11 09:00:00','2025-06-30 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(7,'Facebook F8',15,'Quae non id incidunt tempora non.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','19a70516-168d-3792-a658-a26a358d6883','main/events/7.webp',3.83,'5069 Marilou Forest Suite 790\nWest Vidafurt, PA 93538',3,NULL,NULL,'-87.076273','-164.675918',93,0,'2025-06-11 09:00:00','2025-06-25 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(8,'GitHub Universe',21,'Ut at non sequi perferendis voluptas.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','fc2880a2-2045-3bc5-869d-c9756f4d88c4','main/events/8.webp',12.46,'83308 Bradtke Squares\nMcGlynnberg, MA 28194-5747',3,NULL,NULL,'-24.093399','-179.792679',95,0,'2025-06-11 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(9,'Game Developers Conference',21,'Quibusdam blanditiis vel vero animi at et.','The largest conference in the gaming industry, focusing on game development and gaming technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','28d8ca2c-a87a-35fc-9233-a8049b313b28','main/events/9.webp',73.56,'7655 Medhurst Course\nGerdaview, MT 91026-4081',5,5,5,'70.432324','-94.991716',53,0,'2025-06-12 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(10,'Web Summit',23,'Suscipit quia in eveniet quia molestiae.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','71d0421d-07d5-34d3-8f34-3e73080708d4','main/events/10.webp',19.95,'3476 Abdul Mount\nLake Antonia, TN 52386-9714',2,2,2,'73.281913','24.433741',95,0,'2025-06-12 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:48:14','2025-06-10 10:48:14');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Drew Schamberger - blick.leland@gmail.com','blick.leland@gmail.com','0130897777',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Mr. Roger Maggio Jr. - wdavis@hotmail.com','wdavis@hotmail.com','0162499453',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Osvaldo Little - dwitting@fisher.org','dwitting@fisher.org','0358301499',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Aaliyah Bahringer - koss.cassidy@collier.org','koss.cassidy@collier.org','0939500012',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(5,1,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Prof. Jacinto Huels I - thora.satterfield@gmail.com','thora.satterfield@gmail.com','0366371304',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Russell Gutmann - ebeier@feil.info','ebeier@feil.info','0585356174',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Mrs. Fae Bayer III - trunolfsdottir@rau.net','trunolfsdottir@rau.net','0053318982',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(8,3,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Angie Block - orville14@gmail.com','orville14@gmail.com','0209164452',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(9,3,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Jody Schmeler - kyra51@larkin.com','kyra51@larkin.com','0433114033',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Jaleel Leuschke - ngerlach@yahoo.com','ngerlach@yahoo.com','0491256238',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Imelda Kertzmann - mona.corkery@gutkowski.com','mona.corkery@gutkowski.com','0825667115',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(12,3,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Makayla Reilly - skutch@pfannerstill.net','skutch@pfannerstill.net','0361700160',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Felicia Becker - corwin.art@yahoo.com','corwin.art@yahoo.com','0695134477',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(14,4,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Leopold Cole - charlotte.veum@yahoo.com','charlotte.veum@yahoo.com','0166882562',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Dr. Tessie Heller Jr. - pfannerstill.julio@hilpert.info','pfannerstill.julio@hilpert.info','0047666738',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Abdul Hamill - darron.batz@ullrich.org','darron.batz@ullrich.org','0134930331',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(17,4,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Laury Erdman - wilkinson.verna@hauck.com','wilkinson.verna@hauck.com','0918204787',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(18,5,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Ms. Piper Robel - karina85@schaden.info','karina85@schaden.info','0907373344',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(19,5,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Prof. Jayce Willms - emmanuelle65@yahoo.com','emmanuelle65@yahoo.com','0346409840',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(20,5,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Candelario Stroman - konopelski.elian@pfeffer.com','konopelski.elian@pfeffer.com','0194729789',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(21,6,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Prof. Millie Wuckert - lmayer@yahoo.com','lmayer@yahoo.com','0066572787',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(22,6,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Dr. Weldon West IV - turcotte.alene@altenwerth.com','turcotte.alene@altenwerth.com','0757926306',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(23,6,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Elda Windler III - egutmann@grimes.com','egutmann@grimes.com','0855636607',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(24,6,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Mr. Jeffrey Koch I - estelle08@yahoo.com','estelle08@yahoo.com','0676932249',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(25,6,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Dr. Taryn Zemlak Sr. - macejkovic.addison@yahoo.com','macejkovic.addison@yahoo.com','0066176851',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(26,7,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Makayla Hills - amira.koss@hotmail.com','amira.koss@hotmail.com','0819323413',1,81.26,81.26,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(27,7,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Gunner Prosacco - zschowalter@legros.net','zschowalter@legros.net','0402525839',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(28,7,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Faye Monahan - august.hegmann@gmail.com','august.hegmann@gmail.com','0667458228',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(29,7,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Ms. Kaylah Lueilwitz II - clementina97@yahoo.com','clementina97@yahoo.com','0622415127',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(30,7,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Dariana Koss - rheidenreich@yahoo.com','rheidenreich@yahoo.com','0402482190',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(31,8,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Israel Blanda - jnikolaus@yahoo.com','jnikolaus@yahoo.com','0112394350',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(32,8,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Lexi Sporer - sammy.flatley@yahoo.com','sammy.flatley@yahoo.com','0484330975',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(33,8,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Akeem Brekke - arlo.kreiger@hotmail.com','arlo.kreiger@hotmail.com','0241247121',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(34,8,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Uriah Hessel IV - ansley.ullrich@feest.biz','ansley.ullrich@feest.biz','0235127178',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(35,8,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Pierce Harvey - dicki.justen@gmail.com','dicki.justen@gmail.com','0178692749',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(36,9,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Peyton Borer DDS - audie.strosin@yahoo.com','audie.strosin@yahoo.com','0128348133',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(37,9,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Nicolas Hoeger - noble85@sporer.org','noble85@sporer.org','0841918506',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(38,9,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Cindy Macejkovic - ukozey@wilderman.biz','ukozey@wilderman.biz','0916119580',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(39,10,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Noemie Schmitt - maximillia60@hotmail.com','maximillia60@hotmail.com','0667606299',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(40,10,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'CES (Consumer Electronics Show) - Bell Moore - kozey.ronaldo@hotmail.com','kozey.ronaldo@hotmail.com','0542540555',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(41,10,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'CES (Consumer Electronics Show) - Tessie Stokes DVM - vida18@hotmail.com','vida18@hotmail.com','0935362235',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(42,10,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'CES (Consumer Electronics Show) - Betty Gleason - block.lavon@gmail.com','block.lavon@gmail.com','0387789289',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(43,10,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'CES (Consumer Electronics Show) - Mrs. Danika Sanford Jr. - fgreenfelder@gmail.com','fgreenfelder@gmail.com','0589576449',1,81.26,81.26,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(44,11,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Dr. Fermin Hamill - bvonrueden@yahoo.com','bvonrueden@yahoo.com','0608976516',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(45,11,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Prof. Zola Watsica Sr. - twill@hotmail.com','twill@hotmail.com','0343092744',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(46,12,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Icie Collins - west.trinity@jacobson.com','west.trinity@jacobson.com','0048705116',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(47,12,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Ardella Wisozk - mertz.jermaine@hilpert.com','mertz.jermaine@hilpert.com','0561387621',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(48,12,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Hillard Simonis III - thea.lehner@mcdermott.com','thea.lehner@mcdermott.com','0548138845',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(49,12,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Cathrine Morar - ledner.murray@yahoo.com','ledner.murray@yahoo.com','0191942017',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(50,12,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Edythe Gusikowski Sr. - antonia.hauck@rippin.net','antonia.hauck@rippin.net','0264254942',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(51,12,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Waino Balistreri - shyanne.bernier@gmail.com','shyanne.bernier@gmail.com','0889910773',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(52,13,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Prof. Angel Blanda - jreichel@hotmail.com','jreichel@hotmail.com','0182859289',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(53,13,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Miss Kariane Koss - scremin@yahoo.com','scremin@yahoo.com','0717750715',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(54,13,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Prof. Isobel Collier - hailey81@gmail.com','hailey81@gmail.com','0942265049',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(55,13,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Aubree Olson - mrohan@gmail.com','mrohan@gmail.com','0154853418',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(56,14,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Prof. Mariana Trantow - kyleigh11@hirthe.biz','kyleigh11@hirthe.biz','0585441107',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(57,14,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Lavonne Dooley - kpfannerstill@gmail.com','kpfannerstill@gmail.com','0673585750',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(58,15,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Dorthy Walsh - pbalistreri@macejkovic.com','pbalistreri@macejkovic.com','0485093795',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(59,15,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Rosa Rempel - brielle89@gmail.com','brielle89@gmail.com','0880157607',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(60,15,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Sam Kassulke - cedrick.bailey@kunze.info','cedrick.bailey@kunze.info','0436212689',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(61,15,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Kamron Hermann III - brody.bartell@gmail.com','brody.bartell@gmail.com','0221352442',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(62,16,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Wyatt Kulas - qsimonis@daugherty.com','qsimonis@daugherty.com','0215216045',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(63,16,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Mr. Trace Williamson - hudson.camryn@schowalter.org','hudson.camryn@schowalter.org','0019665355',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(64,16,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Austyn Hermiston - henriette.ward@jacobson.org','henriette.ward@jacobson.org','0679389723',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(65,17,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Jamison Ratke - brekke.felipa@green.info','brekke.felipa@green.info','0103700454',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(66,17,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Marcos Smith DDS - pete08@wilkinson.com','pete08@wilkinson.com','0404862310',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(67,18,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Lenore Upton - yasmeen26@gmail.com','yasmeen26@gmail.com','0452275679',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(68,18,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Allan Padberg - dicki.haven@gmail.com','dicki.haven@gmail.com','0754021492',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(69,18,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Ilene Braun DVM - nichole80@gmail.com','nichole80@gmail.com','0191523218',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(70,18,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Trinity Dietrich - lura01@hauck.com','lura01@hauck.com','0346452743',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(71,18,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Reuben Beahan - uwitting@conn.com','uwitting@conn.com','0805880561',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(72,19,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Ivory Dickinson - richmond46@weber.com','richmond46@weber.com','0288446838',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(73,19,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Tillman Muller - brett55@jerde.com','brett55@jerde.com','0621674722',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(74,19,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Jovani Jast - bartell.kenna@langworth.com','bartell.kenna@langworth.com','0900318553',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(75,20,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Neal Jenkins - lambert.larkin@upton.info','lambert.larkin@upton.info','0057099644',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(76,20,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Jules Kshlerin DVM - sage72@zboncak.com','sage72@zboncak.com','0389051270',1,94.00,94.00,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(77,20,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Nelle Schultz V - ejones@hintz.org','ejones@hintz.org','0928315851',1,94.00,94.00,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(78,21,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Google I/O - Ilene Rohan - yspinka@strosin.com','yspinka@strosin.com','0336901186',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(79,21,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Google I/O - Peyton Mann - olson.trace@heathcote.com','olson.trace@heathcote.com','0847054250',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(80,22,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Google I/O - Melyssa Boehm - luella62@hettinger.com','luella62@hettinger.com','0960800118',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(81,22,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Google I/O - Rhoda Ankunding - meta.wolf@hotmail.com','meta.wolf@hotmail.com','0581840581',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(82,23,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Google I/O - Alexzander Ziemann - sdeckow@schmitt.org','sdeckow@schmitt.org','0565428745',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(83,23,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Google I/O - Dr. Osbaldo Rodriguez I - dubuque.jarrell@yahoo.com','dubuque.jarrell@yahoo.com','0259575514',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(84,23,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Google I/O - Kaia Stokes - keeling.leola@baumbach.com','keeling.leola@baumbach.com','0863039495',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(85,23,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Prof. Camylle Waelchi - susana26@gislason.com','susana26@gislason.com','0111858911',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(86,24,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Mrs. Domenica Ruecker - nolan.geo@hegmann.biz','nolan.geo@hegmann.biz','0351236838',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(87,24,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Misty Hermann - name.wintheiser@funk.com','name.wintheiser@funk.com','0488995241',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(88,24,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Cooper Douglas - ewald88@yahoo.com','ewald88@yahoo.com','0794678888',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(89,24,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Dr. Maude Frami MD - lysanne55@hotmail.com','lysanne55@hotmail.com','0302825044',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(90,24,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Sarah Schuster - mervin.fahey@yahoo.com','mervin.fahey@yahoo.com','0085227727',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(91,24,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Treva Wyman Jr. - weber.sherman@rau.com','weber.sherman@rau.com','0947562128',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(92,25,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Leo Skiles II - sigmund08@yahoo.com','sigmund08@yahoo.com','0967331385',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(93,25,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Kolby Schaden - clinton10@yahoo.com','clinton10@yahoo.com','0017826422',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(94,25,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Mr. Kamryn Adams - arnold56@parisian.com','arnold56@parisian.com','0944945493',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(95,25,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Mr. Moriah Hills - grimes.francesca@gmail.com','grimes.francesca@gmail.com','0468167630',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(96,26,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Carolina Gusikowski - laisha53@kling.com','laisha53@kling.com','0245828712',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(97,26,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Prof. Oda Morissette - harmon.friesen@gorczany.com','harmon.friesen@gorczany.com','0180453644',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(98,26,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Daphnee Schaden - langworth.tiara@hotmail.com','langworth.tiara@hotmail.com','0182876477',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(99,26,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Mr. Judah Wolff - lindsay65@hammes.com','lindsay65@hammes.com','0244050481',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(100,26,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Jamil Altenwerth II - ybrekke@gmail.com','ybrekke@gmail.com','0606920190',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(101,27,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Dr. Paolo Schaden III - simonis.eli@hudson.com','simonis.eli@hudson.com','0362557614',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(102,27,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Kody Nitzsche - stark.ardella@witting.com','stark.ardella@witting.com','0906454251',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(103,27,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Lauretta Halvorson - orn.bradford@hintz.net','orn.bradford@hintz.net','0689036897',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(104,27,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Alessandra Stanton - hilma51@gmail.com','hilma51@gmail.com','0181426318',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(105,27,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Emanuel Barton - nathen.leffler@yahoo.com','nathen.leffler@yahoo.com','0182372745',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(106,28,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Brandon Hackett - susana04@yahoo.com','susana04@yahoo.com','0668770337',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(107,28,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Annetta Romaguera - gleichner.francisca@klein.com','gleichner.francisca@klein.com','0238442210',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(108,29,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Prince Marks - astrosin@swaniawski.info','astrosin@swaniawski.info','0590021762',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(109,29,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Toby Haley PhD - aufderhar.jacinthe@gmail.com','aufderhar.jacinthe@gmail.com','0532635958',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(110,29,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Prof. Luigi Stoltenberg - rubie.lindgren@hotmail.com','rubie.lindgren@hotmail.com','0574640182',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(111,29,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Clifton Rath - ruth20@schimmel.com','ruth20@schimmel.com','0024263977',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(112,29,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Eleanore Huels - padberg.prudence@gmail.com','padberg.prudence@gmail.com','0889907130',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(113,29,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Prof. Magdalena Anderson DDS - nya.kreiger@hane.biz','nya.kreiger@hane.biz','0950089146',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(114,30,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Nelson Spencer - whettinger@yahoo.com','whettinger@yahoo.com','0805151466',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(115,30,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Mrs. Odessa Stokes IV - cristina.bashirian@ratke.net','cristina.bashirian@ratke.net','0816175987',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(116,30,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Alec Rath - brunte@hotmail.com','brunte@hotmail.com','0266443617',1,68.71,68.71,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(117,31,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Apple WWDC - Melba Jakubowski - krodriguez@hotmail.com','krodriguez@hotmail.com','0897468180',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(118,31,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Apple WWDC - Prof. Conor Schinner - maeve25@hotmail.com','maeve25@hotmail.com','0591582335',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(119,31,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Apple WWDC - Dasia Hayes II - gregg45@gmail.com','gregg45@gmail.com','0396755570',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(120,31,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Apple WWDC - Estella Hegmann - white.kaya@gmail.com','white.kaya@gmail.com','0883719486',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(121,31,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Apple WWDC - Maxine Cormier - batz.agustina@lindgren.com','batz.agustina@lindgren.com','0658757498',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(122,32,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Apple WWDC - Elmo Kirlin - rpfeffer@yahoo.com','rpfeffer@yahoo.com','0697250494',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(123,32,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Apple WWDC - Prof. Kendrick Robel - caroline04@langosh.biz','caroline04@langosh.biz','0545368314',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(124,33,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Apple WWDC - Arch Schuppe - idicki@gmail.com','idicki@gmail.com','0734359125',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(125,33,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Tyreek Monahan - marcella83@kessler.com','marcella83@kessler.com','0942099547',1,29.68,29.68,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(126,34,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Susana Barton - considine.nellie@gmail.com','considine.nellie@gmail.com','0650427902',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(127,34,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Adriana Ratke - arno.bednar@kreiger.org','arno.bednar@kreiger.org','0261967983',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(128,34,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Andreane Halvorson - jaeden.prohaska@hotmail.com','jaeden.prohaska@hotmail.com','0394302515',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(129,34,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Lucious Braun - johnston.stanton@gmail.com','johnston.stanton@gmail.com','0457976131',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(130,35,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Una Boyle - marcus.rowe@gmail.com','marcus.rowe@gmail.com','0958735593',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(131,35,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Kiley Blick Sr. - yost.rhiannon@hotmail.com','yost.rhiannon@hotmail.com','0356923677',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(132,35,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Terence Stroman - whitney.wunsch@reilly.com','whitney.wunsch@reilly.com','0458369023',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(133,35,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Prof. Hilda Yost - maritza.ullrich@hermiston.com','maritza.ullrich@hermiston.com','0705023336',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(134,35,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Enid Sanford - german12@flatley.com','german12@flatley.com','0788504747',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(135,36,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Ms. Vilma Ward - ddicki@gmail.com','ddicki@gmail.com','0384669355',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(136,36,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Kaycee Frami - alice.champlin@hotmail.com','alice.champlin@hotmail.com','0844448715',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(137,36,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Prof. Earlene Considine - alexandra.schneider@yahoo.com','alexandra.schneider@yahoo.com','0895638142',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(138,36,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Freeda Hickle - marjorie.abernathy@bednar.com','marjorie.abernathy@bednar.com','0307514051',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(139,36,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Elda D\'Amore - lindgren.lexi@doyle.com','lindgren.lexi@doyle.com','0566485955',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(140,36,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Lenna Goldner - donavon.anderson@zboncak.net','donavon.anderson@zboncak.net','0706891608',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(141,37,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Brannon Kuvalis Sr. - uschamberger@gmail.com','uschamberger@gmail.com','0913639470',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(142,37,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Larue Kessler - clotilde.jacobi@donnelly.biz','clotilde.jacobi@donnelly.biz','0576436541',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(143,38,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Zita Smith - bode.okey@wuckert.org','bode.okey@wuckert.org','0950820626',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(144,38,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Ruben Waelchi - bergnaum.bettye@murray.com','bergnaum.bettye@murray.com','0666855031',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(145,38,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Alexandra Beahan - hfunk@gmail.com','hfunk@gmail.com','0637608140',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(146,38,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Piper Walsh - spencer00@klein.com','spencer00@klein.com','0564413958',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(147,39,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Miss Assunta Corkery - msauer@koch.org','msauer@koch.org','0490318253',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(148,39,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Dale Jones V - brian60@okuneva.com','brian60@okuneva.com','0302797844',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(149,39,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Jaquelin Morissette DDS - catalina12@yahoo.com','catalina12@yahoo.com','0393218829',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(150,39,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Ms. Janae Wintheiser - sprosacco@yahoo.com','sprosacco@yahoo.com','0865295272',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(151,39,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Isabella Mann - ehayes@littel.biz','ehayes@littel.biz','0056053061',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(152,39,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Roman Ward - vcollier@bartell.info','vcollier@bartell.info','0112024499',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(153,40,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Hannah Swaniawski - sanford.buckridge@gmail.com','sanford.buckridge@gmail.com','0657063925',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(154,40,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Wilton Bosco - kuhic.ryley@hotmail.com','kuhic.ryley@hotmail.com','0110627406',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(155,40,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Cecil Bergnaum MD - hoppe.ali@hettinger.biz','hoppe.ali@hettinger.biz','0341730026',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(156,40,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Dorian Rutherford - summer60@vandervort.org','summer60@vandervort.org','0244695680',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(157,40,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Pink Mante - doug.dibbert@hotmail.com','doug.dibbert@hotmail.com','0941920013',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(158,40,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Eileen Grady - ike.halvorson@dibbert.com','ike.halvorson@dibbert.com','0285919198',1,29.68,29.68,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(159,41,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'AWS re:Invent - Sammie Hagenes - laurie.gerhold@yahoo.com','laurie.gerhold@yahoo.com','0368312281',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(160,41,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'AWS re:Invent - Mr. Edward Bins - susie34@yahoo.com','susie34@yahoo.com','0869812785',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(161,42,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'AWS re:Invent - Gudrun Collins - kathryn68@hotmail.com','kathryn68@hotmail.com','0196009799',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(162,42,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'AWS re:Invent - Alessia Rippin PhD - micheal.purdy@yahoo.com','micheal.purdy@yahoo.com','0972168441',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(163,43,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'AWS re:Invent - Dr. Maybell Schaefer I - cleta40@pagac.net','cleta40@pagac.net','0471410291',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(164,43,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'AWS re:Invent - Mr. Timmy Hegmann IV - zena.kuphal@gmail.com','zena.kuphal@gmail.com','0817734761',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(165,43,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'AWS re:Invent - Emmanuel Towne - adelbert33@ferry.com','adelbert33@ferry.com','0892645800',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(166,43,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'AWS re:Invent - Prof. Katherine Dibbert - kris.jacky@hotmail.com','kris.jacky@hotmail.com','0396780058',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(167,43,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Destany Littel - brook.muller@kling.info','brook.muller@kling.info','0649233606',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(168,44,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Drew Gibson DDS - eduardo.thompson@gmail.com','eduardo.thompson@gmail.com','0651305246',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(169,44,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Madge Lebsack - tara.marks@shields.net','tara.marks@shields.net','0335245415',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(170,45,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Javier Reynolds Jr. - rosanna60@wisoky.biz','rosanna60@wisoky.biz','0450379578',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(171,45,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Dr. Wellington Dickens - pollich.pedro@keeling.biz','pollich.pedro@keeling.biz','0710702076',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(172,45,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Raphaelle VonRueden - nedra.klocko@bednar.info','nedra.klocko@bednar.info','0899517501',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(173,45,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Keyon Feeney - modesto.lockman@tremblay.com','modesto.lockman@tremblay.com','0753244121',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(174,45,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Dan Green - regan45@runolfsdottir.net','regan45@runolfsdottir.net','0061238927',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(175,45,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Dr. Jovanny Prohaska V - ametz@hotmail.com','ametz@hotmail.com','0324951571',1,34.67,34.67,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(176,46,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Timothy Mraz - christa.spencer@yahoo.com','christa.spencer@yahoo.com','0686988210',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(177,46,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Syble O\'Conner - shields.alessandra@yahoo.com','shields.alessandra@yahoo.com','0792796861',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(178,46,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Lloyd Beatty DDS - moen.domenick@gmail.com','moen.domenick@gmail.com','0511417106',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(179,46,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Ms. Rachelle Lubowitz II - dkirlin@gmail.com','dkirlin@gmail.com','0243016974',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(180,46,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Troy Hoppe - maximillia.klein@hotmail.com','maximillia.klein@hotmail.com','0481744725',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(181,46,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Westley Pollich - kirk.champlin@bauch.com','kirk.champlin@bauch.com','0346125135',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(182,47,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Hollis Ernser - veda19@yahoo.com','veda19@yahoo.com','0889239361',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(183,47,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Cameron Dicki II - reinger.lamont@gmail.com','reinger.lamont@gmail.com','0222163944',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(184,48,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Myrna Carroll - terry.lavina@borer.com','terry.lavina@borer.com','0762158137',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(185,48,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Mr. Dagmar Keebler IV - gaylord.schmeler@williamson.com','gaylord.schmeler@williamson.com','0862086297',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(186,48,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Ephraim Bogan - leopold92@hotmail.com','leopold92@hotmail.com','0209304456',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(187,48,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Mrs. Willow Batz - bpacocha@hotmail.com','bpacocha@hotmail.com','0944316878',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(188,49,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Lilly McKenzie I - ottis.morissette@hotmail.com','ottis.morissette@hotmail.com','0821843005',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(189,49,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Zackary Kris - wyman.kale@crona.com','wyman.kale@crona.com','0874429868',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(190,49,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Prof. Vickie Renner - funk.curtis@gmail.com','funk.curtis@gmail.com','0352290483',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(191,49,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Alexa Brown - ghansen@yahoo.com','ghansen@yahoo.com','0323317263',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(192,49,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Will Robel V - antwan.connelly@gutmann.biz','antwan.connelly@gutmann.biz','0140911944',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(193,50,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Mariana Kohler - flatley.isabella@hotmail.com','flatley.isabella@hotmail.com','0513198322',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(194,50,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Sonya Little Sr. - hoeger.emely@yahoo.com','hoeger.emely@yahoo.com','0776409274',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(195,50,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Dr. Coleman Dicki III - jaskolski.rhoda@collins.biz','jaskolski.rhoda@collins.biz','0566356468',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(196,50,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Dr. Joey Beier - shanahan.kiley@wiegand.com','shanahan.kiley@wiegand.com','0627828587',1,34.67,34.67,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',81.26,'CES (Consumer Electronics Show)','Prof. Garrett Dooley V','claire21@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',325.04,325.04,0.00,0.00,NULL,1,'completed','2025-06-10 10:48:14','2025-06-10 10:48:14','2025-06-10 10:48:14'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',81.26,'CES (Consumer Electronics Show)','Adele Klocko','austyn.lubowitz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',81.26,81.26,0.00,0.00,NULL,2,'completed','2025-06-10 10:48:14','2025-06-10 10:48:14','2025-06-10 10:48:14'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',81.26,'CES (Consumer Electronics Show)','Dwight Rath','smith.kasey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',325.04,325.04,0.00,0.00,NULL,3,'completed','2025-06-10 10:48:14','2025-06-10 10:48:14','2025-06-10 10:48:14'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',81.26,'CES (Consumer Electronics Show)','Dwight Rath','smith.kasey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',325.04,325.04,0.00,0.00,NULL,4,'completed','2025-06-10 10:48:14','2025-06-10 10:48:14','2025-06-10 10:48:14'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',81.26,'CES (Consumer Electronics Show)','Prof. Garrett Dooley V','claire21@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',162.52,162.52,0.00,0.00,NULL,5,'completed','2025-06-10 10:48:14','2025-06-10 10:48:14','2025-06-10 10:48:14'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',81.26,'CES (Consumer Electronics Show)','Prof. Garrett Dooley V','claire21@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',325.04,325.04,0.00,0.00,NULL,6,'completed','2025-06-10 10:48:14','2025-06-10 10:48:14','2025-06-10 10:48:14'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',81.26,'CES (Consumer Electronics Show)','Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info',NULL,'ArchiElite','main/general/logo-light.png',325.04,325.04,0.00,0.00,NULL,7,'completed','2025-06-10 10:48:14','2025-06-10 10:48:14','2025-06-10 10:48:14'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',81.26,'CES (Consumer Electronics Show)','Caroline O\'Keefe','lela44@stanton.org',NULL,'ArchiElite','main/general/logo-light.png',325.04,325.04,0.00,0.00,NULL,8,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',81.26,'CES (Consumer Electronics Show)','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',162.52,162.52,0.00,0.00,NULL,9,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',81.26,'CES (Consumer Electronics Show)','Dwight Rath','smith.kasey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',325.04,325.04,0.00,0.00,NULL,10,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',94.00,'Mobile World Congress','Dr. Chet Feil','bode.theodore@medhurst.com',NULL,'ArchiElite','main/general/logo-light.png',94.00,94.00,0.00,0.00,NULL,11,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',94.00,'Mobile World Congress','Caroline O\'Keefe','lela44@stanton.org',NULL,'ArchiElite','main/general/logo-light.png',470.00,470.00,0.00,0.00,NULL,12,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',94.00,'Mobile World Congress','Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info',NULL,'ArchiElite','main/general/logo-light.png',282.00,282.00,0.00,0.00,NULL,13,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',94.00,'Mobile World Congress','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',94.00,94.00,0.00,0.00,NULL,14,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',94.00,'Mobile World Congress','Dr. Pansy Schimmel','casimer25@hoppe.com',NULL,'ArchiElite','main/general/logo-light.png',282.00,282.00,0.00,0.00,NULL,15,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',94.00,'Mobile World Congress','Adele Klocko','austyn.lubowitz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',188.00,188.00,0.00,0.00,NULL,16,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',94.00,'Mobile World Congress','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',94.00,94.00,0.00,0.00,NULL,17,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',94.00,'Mobile World Congress','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',376.00,376.00,0.00,0.00,NULL,18,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',94.00,'Mobile World Congress','Adele Klocko','austyn.lubowitz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',188.00,188.00,0.00,0.00,NULL,19,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',94.00,'Mobile World Congress','Joanne Cormier','cale23@hills.com',NULL,'ArchiElite','main/general/logo-light.png',188.00,188.00,0.00,0.00,NULL,20,'completed','2025-06-10 10:48:15','2025-06-10 10:48:15','2025-06-10 10:48:15'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',68.71,'Google I/O','Dr. Pansy Schimmel','casimer25@hoppe.com',NULL,'ArchiElite','main/general/logo-light.png',68.71,68.71,0.00,0.00,NULL,21,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',68.71,'Google I/O','Mrs. Jade Jerde','xgutmann@johnson.com',NULL,'ArchiElite','main/general/logo-light.png',68.71,68.71,0.00,0.00,NULL,22,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',68.71,'Google I/O','Dr. Chet Feil','bode.theodore@medhurst.com',NULL,'ArchiElite','main/general/logo-light.png',206.13,206.13,0.00,0.00,NULL,23,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',68.71,'Google I/O','Dr. Chet Feil','bode.theodore@medhurst.com',NULL,'ArchiElite','main/general/logo-light.png',343.55,343.55,0.00,0.00,NULL,24,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',68.71,'Google I/O','Prof. Garrett Dooley V','claire21@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',206.13,206.13,0.00,0.00,NULL,25,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',68.71,'Google I/O','Dr. Chet Feil','bode.theodore@medhurst.com',NULL,'ArchiElite','main/general/logo-light.png',274.84,274.84,0.00,0.00,NULL,26,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',68.71,'Google I/O','Prof. Garrett Dooley V','claire21@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',274.84,274.84,0.00,0.00,NULL,27,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',68.71,'Google I/O','Mrs. Jade Jerde','xgutmann@johnson.com',NULL,'ArchiElite','main/general/logo-light.png',68.71,68.71,0.00,0.00,NULL,28,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',68.71,'Google I/O','Adele Klocko','austyn.lubowitz@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',343.55,343.55,0.00,0.00,NULL,29,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',68.71,'Google I/O','Dr. Pansy Schimmel','casimer25@hoppe.com',NULL,'ArchiElite','main/general/logo-light.png',137.42,137.42,0.00,0.00,NULL,30,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',29.68,'Apple WWDC','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',118.72,118.72,0.00,0.00,NULL,31,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',29.68,'Apple WWDC','Mrs. Jade Jerde','xgutmann@johnson.com',NULL,'ArchiElite','main/general/logo-light.png',29.68,29.68,0.00,0.00,NULL,32,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',29.68,'Apple WWDC','Joanne Cormier','cale23@hills.com',NULL,'ArchiElite','main/general/logo-light.png',29.68,29.68,0.00,0.00,NULL,33,'completed','2025-06-10 10:48:16','2025-06-10 10:48:16','2025-06-10 10:48:16'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',29.68,'Apple WWDC','Dwight Rath','smith.kasey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',89.04,89.04,0.00,0.00,NULL,34,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',29.68,'Apple WWDC','Dr. Chet Feil','bode.theodore@medhurst.com',NULL,'ArchiElite','main/general/logo-light.png',118.72,118.72,0.00,0.00,NULL,35,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',29.68,'Apple WWDC','Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info',NULL,'ArchiElite','main/general/logo-light.png',148.40,148.40,0.00,0.00,NULL,36,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',29.68,'Apple WWDC','Dwight Rath','smith.kasey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',29.68,29.68,0.00,0.00,NULL,37,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',29.68,'Apple WWDC','Shea Vandervort','konopelski.judge@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',89.04,89.04,0.00,0.00,NULL,38,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',29.68,'Apple WWDC','Prof. Garrett Dooley V','claire21@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',148.40,148.40,0.00,0.00,NULL,39,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',29.68,'Apple WWDC','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',148.40,148.40,0.00,0.00,NULL,40,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',34.67,'AWS re:Invent','Mrs. Jade Jerde','xgutmann@johnson.com',NULL,'ArchiElite','main/general/logo-light.png',34.67,34.67,0.00,0.00,NULL,41,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',34.67,'AWS re:Invent','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',34.67,34.67,0.00,0.00,NULL,42,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',34.67,'AWS re:Invent','Dr. Chet Feil','bode.theodore@medhurst.com',NULL,'ArchiElite','main/general/logo-light.png',138.68,138.68,0.00,0.00,NULL,43,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',34.67,'AWS re:Invent','Carmela Mante','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',34.67,34.67,0.00,0.00,NULL,44,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',34.67,'AWS re:Invent','Ms. Carissa Gutmann','boyer.levi@wisoky.com',NULL,'ArchiElite','main/general/logo-light.png',173.35,173.35,0.00,0.00,NULL,45,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:17'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',34.67,'AWS re:Invent','Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info',NULL,'ArchiElite','main/general/logo-light.png',173.35,173.35,0.00,0.00,NULL,46,'completed','2025-06-10 10:48:17','2025-06-10 10:48:17','2025-06-10 10:48:18'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',34.67,'AWS re:Invent','Dr. Pansy Schimmel','casimer25@hoppe.com',NULL,'ArchiElite','main/general/logo-light.png',34.67,34.67,0.00,0.00,NULL,47,'completed','2025-06-10 10:48:18','2025-06-10 10:48:18','2025-06-10 10:48:18'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',34.67,'AWS re:Invent','Mrs. Jade Jerde','xgutmann@johnson.com',NULL,'ArchiElite','main/general/logo-light.png',104.01,104.01,0.00,0.00,NULL,48,'completed','2025-06-10 10:48:18','2025-06-10 10:48:18','2025-06-10 10:48:18'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',34.67,'AWS re:Invent','Dwight Rath','smith.kasey@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',138.68,138.68,0.00,0.00,NULL,49,'completed','2025-06-10 10:48:18','2025-06-10 10:48:18','2025-06-10 10:48:18'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',34.67,'AWS re:Invent','Caroline O\'Keefe','lela44@stanton.org',NULL,'ArchiElite','main/general/logo-light.png',104.01,104.01,0.00,0.00,NULL,50,'completed','2025-06-10 10:48:18','2025-06-10 10:48:18','2025-06-10 10:48:18');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'BQVJ4S9UUBTG','5f66de0b-9b34-4233-a4f9-a84df5a96301',1,'CES (Consumer Electronics Show)',81.26,18,1,'Prof. Garrett Dooley V','claire21@gmail.com','I ought to tell its age, there was no time to avoid shrinking away altogether. \'That WAS a curious.',NULL,'1',81.26,4,325.04,325.04,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(2,'TUXEGCSYFRFD','c01b7695-1151-470e-a429-b2f70aadca31',1,'CES (Consumer Electronics Show)',81.26,4,1,'Adele Klocko','austyn.lubowitz@yahoo.com','Alice hastily replied; \'at least--at least I know all the right way of keeping up the fan she was.',NULL,'2',81.26,1,81.26,81.26,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(3,'UGPQCV9CYJHP','51bfab27-d39b-46bb-b0b5-cbd7b07a8829',1,'CES (Consumer Electronics Show)',81.26,19,1,'Dwight Rath','smith.kasey@hotmail.com','IS that to be full of smoke from one foot to the law, And argued each case with my wife; And the.',NULL,'3',81.26,4,325.04,325.04,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(4,'C9KBPJRGHUPG','7d815798-5044-44f8-8a8f-2902c7051211',1,'CES (Consumer Electronics Show)',81.26,19,1,'Dwight Rath','smith.kasey@hotmail.com','There was exactly the right distance--but then I wonder what they said. The executioner\'s argument.',NULL,'4',81.26,4,325.04,325.04,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(5,'EJD8GIPLSTYF','98589656-f3e7-4c52-b8f4-306b188326ad',1,'CES (Consumer Electronics Show)',81.26,18,1,'Prof. Garrett Dooley V','claire21@gmail.com','I suppose Dinah\'ll be sending me on messages next!\' And she began nibbling at the flowers and the.',NULL,'5',81.26,2,162.52,162.52,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(6,'2RNXTXNZPEIK','30530f56-f8c1-47a1-a748-7b552872aa08',1,'CES (Consumer Electronics Show)',81.26,18,1,'Prof. Garrett Dooley V','claire21@gmail.com','Run home this moment, I tell you!\' said Alice. \'I\'ve read that in the beautiful garden, among the.',NULL,'6',81.26,4,325.04,325.04,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(7,'IQW35UVNY3FH','9776a978-e033-48df-80a7-39c260298be5',1,'CES (Consumer Electronics Show)',81.26,22,1,'Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info','Dormouse. \'Don\'t talk nonsense,\' said Alice doubtfully: \'it means--to--make--anything--prettier.\'.',NULL,'7',81.26,4,325.04,325.04,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14'),(8,'03PD5OHJ1II9','ee3e611a-1ecf-4d2a-b781-a56c1130ebb6',1,'CES (Consumer Electronics Show)',81.26,27,1,'Caroline O\'Keefe','lela44@stanton.org','March Hare went \'Sh! sh!\' and the poor little thing sobbed again (or grunted, it was quite tired.',NULL,'8',81.26,4,325.04,325.04,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(9,'NOTTHJWUP070','f363c0df-fb59-4d4f-b8c8-a60d0dcdd943',1,'CES (Consumer Electronics Show)',81.26,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','I\'ll manage better this time,\' she said, without even looking round. \'I\'ll fetch the executioner.',NULL,'9',81.26,2,162.52,162.52,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(10,'NYV9LSJIDQPT','7c489021-bcca-49b4-b737-d8a49c5218e0',1,'CES (Consumer Electronics Show)',81.26,19,1,'Dwight Rath','smith.kasey@hotmail.com','King, \'unless it was talking in a Little Bill It was the first sentence in her own courage. \'It\'s.',NULL,'10',81.26,4,325.04,325.04,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(11,'D0RZOV9TWUTL','f600af5b-28f6-4834-96ec-a12346e6a81c',2,'Mobile World Congress',94.00,31,1,'Dr. Chet Feil','bode.theodore@medhurst.com','Alice ventured to ask. \'Suppose we change the subject. \'Go on with the game,\' the Queen had.',NULL,'11',94.00,1,94.00,94.00,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(12,'0WZKHB0CA7BO','a7ad9e83-14f8-4638-924c-2e51852ee224',2,'Mobile World Congress',94.00,27,1,'Caroline O\'Keefe','lela44@stanton.org','March Hare said--\' \'I didn\'t!\' the March Hare moved into the air, I\'m afraid, sir\' said Alice, in.',NULL,'12',94.00,5,470.00,470.00,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(13,'8N2WPLAWN2ZB','24739dd2-5f70-4f95-b5e0-6c962bf2e0e5',2,'Mobile World Congress',94.00,22,1,'Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info','I beg your pardon,\' said Alice doubtfully: \'it means--to--make--anything--prettier.\' \'Well, then,\'.',NULL,'13',94.00,3,282.00,282.00,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(14,'NCPTQYUVPCT5','e2954ee6-9e9a-49e4-a5e7-63b0099a70fc',2,'Mobile World Congress',94.00,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','Gryphon: \'I went to school every day--\' \'I\'VE been to a mouse, you know. Come on!\' So they got.',NULL,'14',94.00,1,94.00,94.00,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(15,'2DOXSV2BJJU0','a1e5435a-ef8d-4375-9492-9a6e957e767e',2,'Mobile World Congress',94.00,9,1,'Dr. Pansy Schimmel','casimer25@hoppe.com','I\'m I, and--oh dear, how puzzling it all came different!\' the Mock Turtle persisted. \'How COULD he.',NULL,'15',94.00,3,282.00,282.00,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(16,'FR5NRBYH4TZ7','6144e5d8-1a21-41d3-8437-7d37cf951bcb',2,'Mobile World Congress',94.00,4,1,'Adele Klocko','austyn.lubowitz@yahoo.com','I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go down the little golden key, and when she.',NULL,'16',94.00,2,188.00,188.00,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(17,'XKOMIVKUUBOM','bf4d6448-0665-492c-972b-ef3c07f1f0b9',2,'Mobile World Congress',94.00,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','The Dormouse shook its head impatiently, and walked two and two, as the Caterpillar decidedly, and.',NULL,'17',94.00,1,94.00,94.00,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(18,'AND8HP3FC2RS','b32fe183-0a3f-4162-a099-e142e2fdaa24',2,'Mobile World Congress',94.00,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','I think I can guess that,\' she added aloud. \'Do you take me for his housemaid,\' she said to.',NULL,'18',94.00,4,376.00,376.00,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(19,'IPJCG7SZQC06','3e0131f5-ad24-4898-ac28-40c4db8210ac',2,'Mobile World Congress',94.00,4,1,'Adele Klocko','austyn.lubowitz@yahoo.com','How queer everything is to-day! And yesterday things went on so long since she had been would have.',NULL,'19',94.00,2,188.00,188.00,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(20,'GFBYQTRFQPIM','8c0ac22f-d06d-4b2a-af05-8fcd54aa3816',2,'Mobile World Congress',94.00,3,1,'Joanne Cormier','cale23@hills.com','Bill, the Lizard) could not think of anything else. CHAPTER V. Advice from a Caterpillar The.',NULL,'20',94.00,2,188.00,188.00,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15'),(21,'65V7DNPZIBGX','129c62a9-a29f-4f66-bf29-3dac6db86244',3,'Google I/O',68.71,9,1,'Dr. Pansy Schimmel','casimer25@hoppe.com','I get SOMEWHERE,\' Alice added as an explanation. \'Oh, you\'re sure to kill it in a pleased tone.',NULL,'21',68.71,1,68.71,68.71,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(22,'G8CTBFFQWNZK','c54c306d-ee39-480f-9e1b-5543bce9b9ba',3,'Google I/O',68.71,11,1,'Mrs. Jade Jerde','xgutmann@johnson.com','Footman remarked, \'till tomorrow--\' At this the whole thing very absurd, but they were getting so.',NULL,'22',68.71,1,68.71,68.71,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(23,'KRPCYGEBX5SR','b0b1984f-740f-4edb-b995-da0ba975911c',3,'Google I/O',68.71,31,1,'Dr. Chet Feil','bode.theodore@medhurst.com','CHAPTER X. The Lobster Quadrille The Mock Turtle in a great letter, nearly as large as the other.\'.',NULL,'23',68.71,3,206.13,206.13,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(24,'HE8GEBN1DFIR','507ca9d6-db98-426e-9b92-70feabe85758',3,'Google I/O',68.71,31,1,'Dr. Chet Feil','bode.theodore@medhurst.com','Caterpillar took the thimble, looking as solemn as she had felt quite unhappy at the bottom of a.',NULL,'24',68.71,5,343.55,343.55,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(25,'RZTLR2JYIJI1','e9c04c74-7bb4-45ca-b996-9c8b9d1a320b',3,'Google I/O',68.71,18,1,'Prof. Garrett Dooley V','claire21@gmail.com','Who ever saw one that size? Why, it fills the whole head appeared, and then treading on her toes.',NULL,'25',68.71,3,206.13,206.13,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(26,'7ARFEJFF9FW9','c48173b9-ccd3-4cf8-9f79-87b137436c08',3,'Google I/O',68.71,31,1,'Dr. Chet Feil','bode.theodore@medhurst.com','I know!\' exclaimed Alice, who felt ready to ask help of any use, now,\' thought Alice, \'it\'ll never.',NULL,'26',68.71,4,274.84,274.84,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(27,'885AC0LJOI6I','0030e57a-e71b-4fe9-9a0f-58b951113b49',3,'Google I/O',68.71,18,1,'Prof. Garrett Dooley V','claire21@gmail.com','For he can EVEN finish, if he thought it would feel with all speed back to the Hatter. \'You might.',NULL,'27',68.71,4,274.84,274.84,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(28,'QFLNSRHF9WLG','20af6e27-9cab-4b1a-933c-ac07745adcdb',3,'Google I/O',68.71,11,1,'Mrs. Jade Jerde','xgutmann@johnson.com','Allow me to him: She gave me a good deal to ME,\' said Alice aloud, addressing nobody in.',NULL,'28',68.71,1,68.71,68.71,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(29,'WKWIEO0VA0RK','8566f87f-c7be-4a10-9a7d-acfec2f87fcb',3,'Google I/O',68.71,4,1,'Adele Klocko','austyn.lubowitz@yahoo.com','Queen to-day?\' \'I should like it very nice, (it had, in fact, a sort of use in waiting by the.',NULL,'29',68.71,5,343.55,343.55,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(30,'BNLIZF5MSR6L','e4649713-8a2e-40d0-ba54-9aba2e5aaebf',3,'Google I/O',68.71,9,1,'Dr. Pansy Schimmel','casimer25@hoppe.com','Pigeon in a very short time the Queen shouted at the March Hare will be When they take us up and.',NULL,'30',68.71,2,137.42,137.42,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(31,'PHCZNJJCLC2I','f7e33c26-7109-451b-8a70-df829d223cc1',4,'Apple WWDC',29.68,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','Dormouse crossed the court, by the Queen till she was talking. Alice could see this, as she could.',NULL,'31',29.68,4,118.72,118.72,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(32,'SBKWZEJO3FDP','25288781-6551-47a9-a9b5-9cf0b5a395ef',4,'Apple WWDC',29.68,11,1,'Mrs. Jade Jerde','xgutmann@johnson.com','Alice, so please your Majesty,\' said Two, in a deep sigh, \'I was a little way out of breath, and.',NULL,'32',29.68,1,29.68,29.68,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(33,'DHB90N48L2RP','0f005b3e-d1d9-47e8-96e8-4a39d5693804',4,'Apple WWDC',29.68,3,1,'Joanne Cormier','cale23@hills.com','Alice was just beginning to see if there were three gardeners at it, and they repeated their.',NULL,'33',29.68,1,29.68,29.68,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16'),(34,'F2BKJWC8CFAU','670623be-9ac3-4774-9061-23b3cbd80146',4,'Apple WWDC',29.68,19,1,'Dwight Rath','smith.kasey@hotmail.com','Beautiful, beautiful Soup!\' CHAPTER XI. Who Stole the Tarts? The King laid his hand upon her arm.',NULL,'34',29.68,3,89.04,89.04,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(35,'UN10Q8OAHDRJ','5e7ece3e-4bd4-491e-8dfb-1b44a6d3834d',4,'Apple WWDC',29.68,31,1,'Dr. Chet Feil','bode.theodore@medhurst.com','I\'d hardly finished the guinea-pigs!\' thought Alice. \'I\'m glad they don\'t seem to be\"--or if you\'d.',NULL,'35',29.68,4,118.72,118.72,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(36,'3TCXL3GH8O0I','bd5feb40-9d87-4e23-88be-c51896e8e42f',4,'Apple WWDC',29.68,22,1,'Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info','Gryphon, the squeaking of the cakes, and was a dead silence instantly, and Alice guessed in a low.',NULL,'36',29.68,5,148.40,148.40,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(37,'P1JSDJO1NZNI','b4857408-8e62-4a4e-8327-8173a8092e3b',4,'Apple WWDC',29.68,19,1,'Dwight Rath','smith.kasey@hotmail.com','I know I have dropped them, I wonder?\' Alice guessed in a whisper, half afraid that it seemed.',NULL,'37',29.68,1,29.68,29.68,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(38,'KB3CHKZVVI8R','a1c817df-fab8-4d32-9f96-b1281e31b541',4,'Apple WWDC',29.68,25,1,'Shea Vandervort','konopelski.judge@hotmail.com','Said his father; \'don\'t give yourself airs! Do you think, at your age, it is I hate cats and.',NULL,'38',29.68,3,89.04,89.04,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(39,'RWOUOQCXIHSG','2e088776-9f62-42b2-a53b-e4f45f89a31f',4,'Apple WWDC',29.68,18,1,'Prof. Garrett Dooley V','claire21@gmail.com','I ever heard!\' \'Yes, I think I must sugar my hair.\" As a duck with its eyelids, so he did,\' said.',NULL,'39',29.68,5,148.40,148.40,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(40,'8HLUMFUY3QCQ','c4f17785-ead6-4265-a44e-59aa2c67a664',4,'Apple WWDC',29.68,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','Alice called out in a day did you call him Tortoise--\' \'Why did they draw?\' said Alice, a good.',NULL,'40',29.68,5,148.40,148.40,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(41,'TTCV0YK0MF6T','e3a4e62a-c5a5-47d3-b399-11dece5ce10f',5,'AWS re:Invent',34.67,11,1,'Mrs. Jade Jerde','xgutmann@johnson.com','There was a sound of many footsteps, and Alice was very like a telescope! I think it so yet,\' said.',NULL,'41',34.67,1,34.67,34.67,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(42,'JYQA1T4VV85E','f7589345-4078-4bd7-8532-e2176f7d49a6',5,'AWS re:Invent',34.67,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','VERY remarkable in that; nor did Alice think it so yet,\' said the Caterpillar. \'Well, perhaps you.',NULL,'42',34.67,1,34.67,34.67,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(43,'QPQ517W2YL9D','eb455c29-c490-4f09-9833-c54fcfbddd07',5,'AWS re:Invent',34.67,31,1,'Dr. Chet Feil','bode.theodore@medhurst.com','Do come back again, and that\'s very like having a game of croquet she was dozing off, and Alice.',NULL,'43',34.67,4,138.68,138.68,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(44,'LZ8KGCBLKHB2','2339ef92-d2d2-4491-9482-bc027f8a017d',5,'AWS re:Invent',34.67,1,1,'Carmela Mante','customer@archielite.com','Gryphon: and it set to work, and very soon finished off the cake. * * * * * * * * * * * * * * * *.',NULL,'44',34.67,1,34.67,34.67,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(45,'UCACGQMHRV9H','6d186d9c-1ce0-4573-9572-816ddcaf7f54',5,'AWS re:Invent',34.67,17,1,'Ms. Carissa Gutmann','boyer.levi@wisoky.com','Mind now!\' The poor little thing sobbed again (or grunted, it was sneezing and howling alternately.',NULL,'45',34.67,5,173.35,173.35,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(46,'EKOREW5OPKLY','b105f454-5d13-4a54-b8bb-fea3cd6254c6',5,'AWS re:Invent',34.67,22,1,'Prof. Alexzander Greenfelder Jr.','mayer.alexis@gleason.info','Half-past one, time for dinner!\' (\'I only wish people knew that: then they both cried. \'Wake up.',NULL,'46',34.67,5,173.35,173.35,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17'),(47,'JH1W0ZLOHFNT','ac261617-1b8b-480c-961d-f008377be4d0',5,'AWS re:Invent',34.67,9,1,'Dr. Pansy Schimmel','casimer25@hoppe.com','YOUR temper!\' \'Hold your tongue!\' said the cook. The King laid his hand upon her knee, and looking.',NULL,'47',34.67,1,34.67,34.67,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(48,'YQC8J91WCAJG','27911c4b-532c-4381-9b0f-6ba977fc2e65',5,'AWS re:Invent',34.67,11,1,'Mrs. Jade Jerde','xgutmann@johnson.com','Alice could bear: she got up this morning? I almost think I can guess that,\' she added aloud. \'Do.',NULL,'48',34.67,3,104.01,104.01,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(49,'UCP0NBQVKKED','b05f0a71-1130-4873-9eee-91e4cfaae917',5,'AWS re:Invent',34.67,19,1,'Dwight Rath','smith.kasey@hotmail.com','Alice replied, rather shyly, \'I--I hardly know, sir, just at present--at least I mean what I was.',NULL,'49',34.67,4,138.68,138.68,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18'),(50,'GOCDTUDNCBYB','f87966a4-4b07-4b8c-81bd-54ed5e06618c',5,'AWS re:Invent',34.67,27,1,'Caroline O\'Keefe','lela44@stanton.org','AND WASHING--extra.\"\' \'You couldn\'t have done that?\' she thought. \'I must be a comfort, one.',NULL,'50',34.67,3,104.01,104.01,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'VWLB5FMHCZ2Q','Drew Schamberger','blick.leland@gmail.com','0130897777','There was a large rabbit-hole under the hedge. In another moment it was certainly English. \'I.',NULL,'refunded','2025-06-10 10:48:14','2025-06-10 10:48:14'),(2,1,'42XKOMXH4D6F','Mr. Roger Maggio Jr.','wdavis@hotmail.com','0162499453','I can remember feeling a little of her ever getting out of that is--\"Oh, \'tis love, that makes.',NULL,'cancelled','2025-06-10 10:48:14','2025-06-10 10:48:14'),(3,1,'FCTS2FQWMHI3','Osvaldo Little','dwitting@fisher.org','0358301499','Alice, and she jumped up in her hands, wondering if anything would EVER happen in a very difficult.',NULL,'reserved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(4,1,'ZIWTYZLZ2MCR','Aaliyah Bahringer','koss.cassidy@collier.org','0939500012','WHAT things?\' said the March Hare, who had been found and handed them round as prizes. There was a.',NULL,'refunded','2025-06-10 10:48:14','2025-06-10 10:48:14'),(5,1,'2PDA1OJY3FSC','Prof. Jacinto Huels I','thora.satterfield@gmail.com','0366371304','Hatter were having tea at it: a Dormouse was sitting on the top of it. She went in search of her.',NULL,'pending','2025-06-10 10:48:14','2025-06-10 10:48:14'),(6,2,'XBXOLTYRWZA4','Russell Gutmann','ebeier@feil.info','0585356174','For really this morning I\'ve nothing to do: once or twice she had been looking over his shoulder.',NULL,'cancelled','2025-06-10 10:48:14','2025-06-10 10:48:14'),(7,2,'VNTGHYJEHZMO','Mrs. Fae Bayer III','trunolfsdottir@rau.net','0053318982','Alice in a large plate came skimming out, straight at the righthand bit again, and did not like to.',NULL,'transferred','2025-06-10 10:48:14','2025-06-10 10:48:14'),(8,3,'ZWVBUEGI6SOR','Angie Block','orville14@gmail.com','0209164452','Alice, as the game was going on shrinking rapidly: she soon made out the verses the White Rabbit.',NULL,'transferred','2025-06-10 10:48:14','2025-06-10 10:48:14'),(9,3,'4TGANGMO50SF','Jody Schmeler','kyra51@larkin.com','0433114033','SAID was, \'Why is a very difficult question. However, at last the Gryphon went on, \'that they\'d.',NULL,'pending','2025-06-10 10:48:14','2025-06-10 10:48:14'),(10,3,'CX9M4CGYV1B4','Jaleel Leuschke','ngerlach@yahoo.com','0491256238','Magpie began wrapping itself up very sulkily and crossed over to the Hatter. Alice felt dreadfully.',NULL,'pending','2025-06-10 10:48:14','2025-06-10 10:48:14'),(11,3,'U9Q4WKYOJBWZ','Imelda Kertzmann','mona.corkery@gutkowski.com','0825667115','EVEN finish, if he were trying to put everything upon Bill! I wouldn\'t be in a hurried nervous.',NULL,'refunded','2025-06-10 10:48:14','2025-06-10 10:48:14'),(12,3,'U2FSD6JJ8NRM','Makayla Reilly','skutch@pfannerstill.net','0361700160','Dormouse say?\' one of them say, \'Look out now, Five! Don\'t go splashing paint over me like a.',NULL,'transferred','2025-06-10 10:48:14','2025-06-10 10:48:14'),(13,4,'NVAAYLJNXE3J','Felicia Becker','corwin.art@yahoo.com','0695134477','When she got used to queer things happening. While she was now only ten inches high, and was.',NULL,'purchased','2025-06-10 10:48:14','2025-06-10 10:48:14'),(14,4,'BNUDYVKML7P7','Leopold Cole','charlotte.veum@yahoo.com','0166882562','Mary Ann, what ARE you doing out here? Run home this moment, and fetch me a good deal frightened.',NULL,'refunded','2025-06-10 10:48:14','2025-06-10 10:48:14'),(15,4,'SI6IMJE2FPKZ','Dr. Tessie Heller Jr.','pfannerstill.julio@hilpert.info','0047666738','Why, she\'ll eat a bat?\' when suddenly, thump! thump! down she came in with a bound into the court.',NULL,'checked_in','2025-06-10 10:48:14','2025-06-10 10:48:14'),(16,4,'1UNAB9TCOGUU','Abdul Hamill','darron.batz@ullrich.org','0134930331','Mock Turtle. So she began thinking over all the time they had to run back into the air off all its.',NULL,'transferred','2025-06-10 10:48:14','2025-06-10 10:48:14'),(17,4,'Q8UVDRY2TCZQ','Laury Erdman','wilkinson.verna@hauck.com','0918204787','Puss,\' she began, in a voice sometimes choked with sobs, to sing you a present of everything I\'ve.',NULL,'pending','2025-06-10 10:48:14','2025-06-10 10:48:14'),(18,5,'KAJZDDJQIHC1','Ms. Piper Robel','karina85@schaden.info','0907373344','The Queen turned angrily away from him, and very nearly in the court!\' and the Dormouse say?\' one.',NULL,'transferred','2025-06-10 10:48:14','2025-06-10 10:48:14'),(19,5,'KNYY4BJSXA4W','Prof. Jayce Willms','emmanuelle65@yahoo.com','0346409840','Queen said to herself. At this moment Alice felt a little queer, won\'t you?\' \'Not a bit,\' said the.',NULL,'purchased','2025-06-10 10:48:14','2025-06-10 10:48:14'),(20,5,'A5OSKMDSSYHZ','Candelario Stroman','konopelski.elian@pfeffer.com','0194729789','Duchess sang the second thing is to find herself talking familiarly with them, as if she meant to.',NULL,'reserved','2025-06-10 10:48:14','2025-06-10 10:48:14'),(21,6,'916K8QKAEM8I','Prof. Millie Wuckert','lmayer@yahoo.com','0066572787','I will prosecute YOU.--Come, I\'ll take no denial; We must have been changed for any lesson-books!\'.',NULL,'refunded','2025-06-10 10:48:14','2025-06-10 10:48:14'),(22,6,'ZQVO2VM9JHHT','Dr. Weldon West IV','turcotte.alene@altenwerth.com','0757926306','Hatter. \'I deny it!\' said the cook. The King laid his hand upon her arm, with its legs hanging.',NULL,'refunded','2025-06-10 10:48:14','2025-06-10 10:48:14'),(23,6,'DCATRPEBX81P','Elda Windler III','egutmann@grimes.com','0855636607','THAT. Then again--\"BEFORE SHE HAD THIS FIT--\" you never tasted an egg!\' \'I HAVE tasted eggs.',NULL,'refunded','2025-06-10 10:48:14','2025-06-10 10:48:14'),(24,6,'XXSSQLSGYKAD','Mr. Jeffrey Koch I','estelle08@yahoo.com','0676932249','But the snail replied \"Too far, too far!\" and gave a little bit of the court. (As that is enough,\'.',NULL,'pending','2025-06-10 10:48:14','2025-06-10 10:48:14'),(25,6,'FWBBZVQG52ET','Dr. Taryn Zemlak Sr.','macejkovic.addison@yahoo.com','0066176851','Cat. \'I don\'t know where Dinn may be,\' said the sage, as he fumbled over the fire, stirring a.',NULL,'pending','2025-06-10 10:48:14','2025-06-10 10:48:14'),(26,7,'P10QC6HAIXOQ','Makayla Hills','amira.koss@hotmail.com','0819323413','Footman\'s head: it just missed her. Alice caught the flamingo and brought it back, the fight was.',NULL,'checked_in','2025-06-10 10:48:14','2025-06-10 10:48:14'),(27,7,'V6TP5WKA5YNC','Gunner Prosacco','zschowalter@legros.net','0402525839','As there seemed to quiver all over crumbs.\' \'You\'re wrong about the same thing as \"I eat what I.',NULL,'cancelled','2025-06-10 10:48:14','2025-06-10 10:48:14'),(28,7,'UTZXEDUXMRX2','Faye Monahan','august.hegmann@gmail.com','0667458228','Alice waited patiently until it chose to speak again. In a minute or two, they began solemnly.',NULL,'checked_in','2025-06-10 10:48:14','2025-06-10 10:48:14'),(29,7,'M0JI6GGWV1JZ','Ms. Kaylah Lueilwitz II','clementina97@yahoo.com','0622415127','I am now? That\'ll be a letter, after all: it\'s a set of verses.\' \'Are they in the distance would.',NULL,'purchased','2025-06-10 10:48:14','2025-06-10 10:48:14'),(30,7,'IPFHXQYU9OAU','Dariana Koss','rheidenreich@yahoo.com','0402482190','Caterpillar angrily, rearing itself upright as it could go, and making faces at him as he said to.',NULL,'transferred','2025-06-10 10:48:14','2025-06-10 10:48:14'),(31,8,'JRFZDQWAGLPU','Israel Blanda','jnikolaus@yahoo.com','0112394350','Alice! Come here directly, and get in at the bottom of a large crowd collected round it: there was.',NULL,'pending','2025-06-10 10:48:15','2025-06-10 10:48:15'),(32,8,'UWERTGPO4OR9','Lexi Sporer','sammy.flatley@yahoo.com','0484330975','Come on!\' So they went on eagerly. \'That\'s enough about lessons,\' the Gryphon added \'Come, let\'s.',NULL,'purchased','2025-06-10 10:48:15','2025-06-10 10:48:15'),(33,8,'SCVROJSGXHBX','Akeem Brekke','arlo.kreiger@hotmail.com','0241247121','And I declare it\'s too bad, that it felt quite unhappy at the beginning,\' the King sharply. \'Do.',NULL,'purchased','2025-06-10 10:48:15','2025-06-10 10:48:15'),(34,8,'X7SUOM8UYKHK','Uriah Hessel IV','ansley.ullrich@feest.biz','0235127178','Duchess\'s cook. She carried the pepper-box in her lessons in here? Why, there\'s hardly enough of.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(35,8,'HYOV9IVIKLEW','Pierce Harvey','dicki.justen@gmail.com','0178692749','White Rabbit read out, at the end of the well, and noticed that one of the Lizard\'s slate-pencil.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(36,9,'97EL3BKDDHVV','Peyton Borer DDS','audie.strosin@yahoo.com','0128348133','Alice. \'I don\'t believe there\'s an atom of meaning in it, \'and what is the same as the question.',NULL,'transferred','2025-06-10 10:48:15','2025-06-10 10:48:15'),(37,9,'UN4H1NJPOE5U','Nicolas Hoeger','noble85@sporer.org','0841918506','Suppress him! Pinch him! Off with his nose, you know?\' \'It\'s the Cheshire Cat: now I shall never.',NULL,'pending','2025-06-10 10:48:15','2025-06-10 10:48:15'),(38,9,'KG5NGV9LNKXU','Cindy Macejkovic','ukozey@wilderman.biz','0916119580','Then they all quarrel so dreadfully one can\'t hear oneself speak--and they don\'t seem to come once.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(39,10,'5EFDS7I1IMED','Noemie Schmitt','maximillia60@hotmail.com','0667606299','But the insolence of his head. But at any rate, the Dormouse fell asleep instantly, and neither of.',NULL,'checked_in','2025-06-10 10:48:15','2025-06-10 10:48:15'),(40,10,'MGIFWSOSYY6M','Bell Moore','kozey.ronaldo@hotmail.com','0542540555','So they went up to her great disappointment it was talking in a voice of thunder, and people began.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(41,10,'RGEDGJZETGL6','Tessie Stokes DVM','vida18@hotmail.com','0935362235','HIS time of life. The King\'s argument was, that you couldn\'t cut off a head unless there was the.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(42,10,'6GHAWZBS4SOJ','Betty Gleason','block.lavon@gmail.com','0387789289','Hatter, \'when the Queen added to one of the bottle was a little shriek, and went on again.',NULL,'checked_in','2025-06-10 10:48:15','2025-06-10 10:48:15'),(43,10,'MY0NRIETSMQO','Mrs. Danika Sanford Jr.','fgreenfelder@gmail.com','0589576449','And the moral of that is--\"Birds of a candle is blown out, for she was small enough to get in?\'.',NULL,'refunded','2025-06-10 10:48:15','2025-06-10 10:48:15'),(44,11,'FZUNPYUWUK5J','Dr. Fermin Hamill','bvonrueden@yahoo.com','0608976516','I suppose it were white, but there were ten of them, and just as if he doesn\'t begin.\' But she did.',NULL,'pending','2025-06-10 10:48:15','2025-06-10 10:48:15'),(45,11,'3WECCRSSP4QH','Prof. Zola Watsica Sr.','twill@hotmail.com','0343092744','CHAPTER V. Advice from a bottle marked \'poison,\' it is all the right thing to get in?\' she.',NULL,'transferred','2025-06-10 10:48:15','2025-06-10 10:48:15'),(46,12,'412HSJBT3OWU','Icie Collins','west.trinity@jacobson.com','0048705116','Majesty,\' said the Queen. \'You make me giddy.\' And then, turning to the puppy; whereupon the puppy.',NULL,'pending','2025-06-10 10:48:15','2025-06-10 10:48:15'),(47,12,'FJEVFUVCFSOU','Ardella Wisozk','mertz.jermaine@hilpert.com','0561387621','There was a sound of many footsteps, and Alice was thoroughly puzzled. \'Does the boots and shoes!\'.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(48,12,'U6QUEBDRMFRX','Hillard Simonis III','thea.lehner@mcdermott.com','0548138845','Alice panted as she spoke--fancy CURTSEYING as you\'re falling through the neighbouring pool--she.',NULL,'transferred','2025-06-10 10:48:15','2025-06-10 10:48:15'),(49,12,'FADGYLUOJZ61','Cathrine Morar','ledner.murray@yahoo.com','0191942017','MILE HIGH TO LEAVE THE COURT.\' Everybody looked at Two. Two began in a thick wood. \'The first.',NULL,'refunded','2025-06-10 10:48:15','2025-06-10 10:48:15'),(50,12,'MUBKHSLEMFLO','Edythe Gusikowski Sr.','antonia.hauck@rippin.net','0264254942','Some of the other players, and shouting \'Off with his tea spoon at the stick, and made believe to.',NULL,'checked_in','2025-06-10 10:48:15','2025-06-10 10:48:15'),(51,12,'QFPYIAF4KKLH','Waino Balistreri','shyanne.bernier@gmail.com','0889910773','Knave was standing before them, in chains, with a growl, And concluded the banquet--] \'What IS a.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(52,13,'H8NVBQVQ1HVF','Prof. Angel Blanda','jreichel@hotmail.com','0182859289','The executioner\'s argument was, that anything that had fluttered down from the roof. There were.',NULL,'refunded','2025-06-10 10:48:15','2025-06-10 10:48:15'),(53,13,'4KL5CPCLEM0B','Miss Kariane Koss','scremin@yahoo.com','0717750715','I\'m angry. Therefore I\'m mad.\' \'I call it purring, not growling,\' said Alice. The King laid his.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(54,13,'6X809TGLTGSF','Prof. Isobel Collier','hailey81@gmail.com','0942265049','However, she did not wish to offend the Dormouse shall!\' they both sat silent for a conversation.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(55,13,'PBZT2E68MSNT','Aubree Olson','mrohan@gmail.com','0154853418','And she\'s such a very good height indeed!\' said the King; \'and don\'t look at it!\' This speech.',NULL,'refunded','2025-06-10 10:48:15','2025-06-10 10:48:15'),(56,14,'4W5DX2XMH3ZF','Prof. Mariana Trantow','kyleigh11@hirthe.biz','0585441107','Dormouse denied nothing, being fast asleep. \'After that,\' continued the Pigeon, raising its voice.',NULL,'purchased','2025-06-10 10:48:15','2025-06-10 10:48:15'),(57,14,'QBQBDGVCDELS','Lavonne Dooley','kpfannerstill@gmail.com','0673585750','Alice. \'It goes on, you know,\' the Mock Turtle to sing you a couple?\' \'You are not the smallest.',NULL,'pending','2025-06-10 10:48:15','2025-06-10 10:48:15'),(58,15,'UEQNFRDDIXVT','Dorthy Walsh','pbalistreri@macejkovic.com','0485093795','So they couldn\'t see it?\' So she set to work, and very nearly in the schoolroom, and though this.',NULL,'refunded','2025-06-10 10:48:15','2025-06-10 10:48:15'),(59,15,'EOEVC5RCBQXU','Rosa Rempel','brielle89@gmail.com','0880157607','For instance, if you don\'t like them!\' When the procession came opposite to Alice, \'Have you seen.',NULL,'checked_in','2025-06-10 10:48:15','2025-06-10 10:48:15'),(60,15,'JB8SMLOPZ57H','Sam Kassulke','cedrick.bailey@kunze.info','0436212689','Hatter was the BEST butter, you know.\' \'Not at all,\' said Alice: \'three inches is such a nice soft.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(61,15,'SGYKWBQZV6NZ','Kamron Hermann III','brody.bartell@gmail.com','0221352442','But the insolence of his pocket, and pulled out a race-course, in a minute. Alice began to get.',NULL,'transferred','2025-06-10 10:48:15','2025-06-10 10:48:15'),(62,16,'LVYUYVLFJ9KQ','Wyatt Kulas','qsimonis@daugherty.com','0215216045','Very soon the Rabbit hastily interrupted. \'There\'s a great deal to ME,\' said Alice to herself, \'if.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(63,16,'D54YGZ9K6TOE','Mr. Trace Williamson','hudson.camryn@schowalter.org','0019665355','Mock Turtle: \'crumbs would all come wrong, and she swam lazily about in the air, and came back.',NULL,'purchased','2025-06-10 10:48:15','2025-06-10 10:48:15'),(64,16,'SDLPFBC7VYBY','Austyn Hermiston','henriette.ward@jacobson.org','0679389723','King, \'and don\'t look at me like that!\' He got behind him, and very angrily. \'A knot!\' said Alice.',NULL,'pending','2025-06-10 10:48:15','2025-06-10 10:48:15'),(65,17,'VMF6BG8I5YZH','Jamison Ratke','brekke.felipa@green.info','0103700454','Alice said very politely, \'for I can\'t take more.\' \'You mean you can\'t take LESS,\' said the Mock.',NULL,'transferred','2025-06-10 10:48:15','2025-06-10 10:48:15'),(66,17,'W76KERGDYJFC','Marcos Smith DDS','pete08@wilkinson.com','0404862310','As for pulling me out of this ointment--one shilling the box-- Allow me to sell you a present of.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(67,18,'PV29GMK6MGTB','Lenore Upton','yasmeen26@gmail.com','0452275679','WAS no one else seemed inclined to say \"HOW DOTH THE LITTLE BUSY BEE,\" but it just missed her.',NULL,'reserved','2025-06-10 10:48:15','2025-06-10 10:48:15'),(68,18,'LMMXR4DMGOJ9','Allan Padberg','dicki.haven@gmail.com','0754021492','And with that she did not get hold of it; then Alice put down yet, before the officer could get to.',NULL,'pending','2025-06-10 10:48:15','2025-06-10 10:48:15'),(69,18,'KGVVPXO1OUD4','Ilene Braun DVM','nichole80@gmail.com','0191523218','Gryphon, \'you first form into a pig, my dear,\' said Alice, seriously, \'I\'ll have nothing more to.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(70,18,'MRBUESKLLJI2','Trinity Dietrich','lura01@hauck.com','0346452743','White Rabbit: it was good manners for her neck from being broken. She hastily put down the little.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(71,18,'HI7FTE8AZ0DF','Reuben Beahan','uwitting@conn.com','0805880561','King very decidedly, and there was no more of the crowd below, and there stood the Queen till she.',NULL,'transferred','2025-06-10 10:48:15','2025-06-10 10:48:15'),(72,19,'MIIBYRFYBIZX','Ivory Dickinson','richmond46@weber.com','0288446838','Hatter: \'let\'s all move one place on.\' He moved on as he came, \'Oh! the Duchess, the Duchess! Oh!.',NULL,'cancelled','2025-06-10 10:48:15','2025-06-10 10:48:15'),(73,19,'H2X5SWF21V9H','Tillman Muller','brett55@jerde.com','0621674722','Caterpillar. \'Well, perhaps you were all in bed!\' On various pretexts they all crowded together at.',NULL,'purchased','2025-06-10 10:48:15','2025-06-10 10:48:15'),(74,19,'AU922I1QR5N1','Jovani Jast','bartell.kenna@langworth.com','0900318553','And then a great many more than nine feet high, and was surprised to see its meaning. \'And just as.',NULL,'checked_in','2025-06-10 10:48:15','2025-06-10 10:48:15'),(75,20,'V53TJYOSU8CU','Neal Jenkins','lambert.larkin@upton.info','0057099644','I should be free of them were animals, and some of them were animals, and some \'unimportant.\'.',NULL,'checked_in','2025-06-10 10:48:15','2025-06-10 10:48:15'),(76,20,'GLWKIVFADJ1G','Jules Kshlerin DVM','sage72@zboncak.com','0389051270','Alice, that she was coming to, but it just at present--at least I mean what I say--that\'s the same.',NULL,'refunded','2025-06-10 10:48:15','2025-06-10 10:48:15'),(77,20,'NGUUALCBVEOU','Nelle Schultz V','ejones@hintz.org','0928315851','I mean what I say,\' the Mock Turtle said: \'I\'m too stiff. And the executioner myself,\' said the.',NULL,'transferred','2025-06-10 10:48:15','2025-06-10 10:48:15'),(78,21,'X7USAG5MJPZZ','Ilene Rohan','yspinka@strosin.com','0336901186','I hate cats and dogs.\' It was opened by another footman in livery, with a sigh: \'he taught.',NULL,'purchased','2025-06-10 10:48:16','2025-06-10 10:48:16'),(79,21,'U0GNBEVB7JBO','Peyton Mann','olson.trace@heathcote.com','0847054250','WOULD twist itself round and get ready to agree to everything that was lying on their backs was.',NULL,'purchased','2025-06-10 10:48:16','2025-06-10 10:48:16'),(80,22,'CNC5PFPHMTCO','Melyssa Boehm','luella62@hettinger.com','0960800118','Alice, always ready to make the arches. The chief difficulty Alice found at first was moderate.',NULL,'checked_in','2025-06-10 10:48:16','2025-06-10 10:48:16'),(81,22,'T8KRHCSAQSR4','Rhoda Ankunding','meta.wolf@hotmail.com','0581840581','She had just begun \'Well, of all the players, except the Lizard, who seemed ready to make the.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(82,23,'CQG3WYE37WYW','Alexzander Ziemann','sdeckow@schmitt.org','0565428745','By the use of repeating all that stuff,\' the Mock Turtle\'s Story \'You can\'t think how glad I am.',NULL,'checked_in','2025-06-10 10:48:16','2025-06-10 10:48:16'),(83,23,'VGXT0PCYL9OG','Dr. Osbaldo Rodriguez I','dubuque.jarrell@yahoo.com','0259575514','Hatter were having tea at it: a Dormouse was sitting on the other was sitting on the bank--the.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(84,23,'L8CCRGXFUCHC','Kaia Stokes','keeling.leola@baumbach.com','0863039495','Mock Turtle. So she began thinking over other children she knew, who might do very well as I do,\'.',NULL,'checked_in','2025-06-10 10:48:16','2025-06-10 10:48:16'),(85,23,'A7FYOITGJHXP','Prof. Camylle Waelchi','susana26@gislason.com','0111858911','Do you think you might knock, and I could say if I like being that person, I\'ll come up: if not.',NULL,'refunded','2025-06-10 10:48:16','2025-06-10 10:48:16'),(86,24,'K8LOLI3ZJK6V','Mrs. Domenica Ruecker','nolan.geo@hegmann.biz','0351236838','Caucus-Race and a Long Tale They were just beginning to see what this bottle was a little while.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(87,24,'1APCGYEUVM69','Misty Hermann','name.wintheiser@funk.com','0488995241','PROVES his guilt,\' said the White Rabbit read:-- \'They told me you had been wandering, when a.',NULL,'checked_in','2025-06-10 10:48:16','2025-06-10 10:48:16'),(88,24,'ESQOFQBW5VSC','Cooper Douglas','ewald88@yahoo.com','0794678888','Mock Turtle, and said to the other birds tittered audibly. \'What I was thinking I should frighten.',NULL,'reserved','2025-06-10 10:48:16','2025-06-10 10:48:16'),(89,24,'VDVO1JWCGFMF','Dr. Maude Frami MD','lysanne55@hotmail.com','0302825044','Gryphon repeated impatiently: \'it begins \"I passed by his garden.\"\' Alice did not at all like the.',NULL,'purchased','2025-06-10 10:48:16','2025-06-10 10:48:16'),(90,24,'TYEH7S8I4KJI','Sarah Schuster','mervin.fahey@yahoo.com','0085227727','I\'m angry. Therefore I\'m mad.\' \'I call it sad?\' And she went on at last, they must be the right.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(91,24,'TP8NPRWSS1OF','Treva Wyman Jr.','weber.sherman@rau.com','0947562128','I like being that person, I\'ll come up: if not, I\'ll stay down here! It\'ll be no doubt that it.',NULL,'purchased','2025-06-10 10:48:16','2025-06-10 10:48:16'),(92,25,'VO85LXFKJODT','Leo Skiles II','sigmund08@yahoo.com','0967331385','Pigeon in a game of play with a shiver. \'I beg pardon, your Majesty,\' said the Rabbit\'s voice.',NULL,'pending','2025-06-10 10:48:16','2025-06-10 10:48:16'),(93,25,'BNPSPZGPQ84X','Kolby Schaden','clinton10@yahoo.com','0017826422','I fancied that kind of rule, \'and vinegar that makes them so shiny?\' Alice looked very.',NULL,'reserved','2025-06-10 10:48:16','2025-06-10 10:48:16'),(94,25,'BLBIYRT8WAGT','Mr. Kamryn Adams','arnold56@parisian.com','0944945493','Some of the window, and some were birds,) \'I suppose they are the jurors.\' She said this she.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(95,25,'6ZBEPFLIX2EO','Mr. Moriah Hills','grimes.francesca@gmail.com','0468167630','The first witness was the Duchess\'s voice died away, even in the pool rippling to the rose-tree.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(96,26,'AKV058AFRE7Y','Carolina Gusikowski','laisha53@kling.com','0245828712','I don\'t remember where.\' \'Well, it must be removed,\' said the King; and the Dormouse said--\' the.',NULL,'pending','2025-06-10 10:48:16','2025-06-10 10:48:16'),(97,26,'TMRG4PBA4P5J','Prof. Oda Morissette','harmon.friesen@gorczany.com','0180453644','I ask! It\'s always six o\'clock now.\' A bright idea came into Alice\'s head. \'Is that the cause of.',NULL,'purchased','2025-06-10 10:48:16','2025-06-10 10:48:16'),(98,26,'SDDEYAKUUH49','Daphnee Schaden','langworth.tiara@hotmail.com','0182876477','Mouse was bristling all over, and she drew herself up on to her that she had nothing else to do.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(99,26,'VASKOO87PD1T','Mr. Judah Wolff','lindsay65@hammes.com','0244050481','Queen. \'It proves nothing of the hall: in fact she was terribly frightened all the right size for.',NULL,'reserved','2025-06-10 10:48:16','2025-06-10 10:48:16'),(100,26,'JCECNFYGJYQG','Jamil Altenwerth II','ybrekke@gmail.com','0606920190','Alice for some time after the birds! Why, she\'ll eat a little of the cakes, and was coming to, but.',NULL,'pending','2025-06-10 10:48:16','2025-06-10 10:48:16'),(101,27,'NSSCF5RPRZZI','Dr. Paolo Schaden III','simonis.eli@hudson.com','0362557614','Soup? Beau--ootiful Soo--oop! Soo--oop of the birds and beasts, as well say that \"I see what I.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(102,27,'RLIIFZOKQDXL','Kody Nitzsche','stark.ardella@witting.com','0906454251','She went on just as the doubled-up soldiers were silent, and looked at it, busily painting them.',NULL,'purchased','2025-06-10 10:48:16','2025-06-10 10:48:16'),(103,27,'PI7J6CLZAFNM','Lauretta Halvorson','orn.bradford@hintz.net','0689036897','Mock Turtle. Alice was beginning to get dry very soon. \'Ahem!\' said the Mouse, sharply and very.',NULL,'pending','2025-06-10 10:48:16','2025-06-10 10:48:16'),(104,27,'0H2JPQL2UDJN','Alessandra Stanton','hilma51@gmail.com','0181426318','And oh, my poor little feet, I wonder what I should say \"With what porpoise?\"\' \'Don\'t you mean.',NULL,'refunded','2025-06-10 10:48:16','2025-06-10 10:48:16'),(105,27,'RE2AQ6AWOMGD','Emanuel Barton','nathen.leffler@yahoo.com','0182372745','The Queen\'s argument was, that she ought to have finished,\' said the Footman, and began smoking.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(106,28,'X9SRATLFAC51','Brandon Hackett','susana04@yahoo.com','0668770337','King added in a moment: she looked up and leave the room, when her eye fell upon a time she went.',NULL,'checked_in','2025-06-10 10:48:16','2025-06-10 10:48:16'),(107,28,'ZT7ZSED9EJXT','Annetta Romaguera','gleichner.francisca@klein.com','0238442210','Some of the shepherd boy--and the sneeze of the evening, beautiful Soup! Soup of the house before.',NULL,'pending','2025-06-10 10:48:16','2025-06-10 10:48:16'),(108,29,'HRBIPXE5XEAM','Prince Marks','astrosin@swaniawski.info','0590021762','Duchess, as she went in without knocking, and hurried upstairs, in great disgust, and walked a.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(109,29,'HYQJL6RWXWUY','Toby Haley PhD','aufderhar.jacinthe@gmail.com','0532635958','White Rabbit read:-- \'They told me you had been of late much accustomed to usurpation and.',NULL,'refunded','2025-06-10 10:48:16','2025-06-10 10:48:16'),(110,29,'PA86GGTNAGTH','Prof. Luigi Stoltenberg','rubie.lindgren@hotmail.com','0574640182','Queen,\' and she soon made out the words: \'Where\'s the other birds tittered audibly. \'What I was.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(111,29,'ZD2LURKCE55T','Clifton Rath','ruth20@schimmel.com','0024263977','THAT\'S a good deal frightened at the sudden change, but she could not think of nothing else to do.',NULL,'refunded','2025-06-10 10:48:16','2025-06-10 10:48:16'),(112,29,'OUQ4VVUER0CB','Eleanore Huels','padberg.prudence@gmail.com','0889907130','OURS they had any dispute with the grin, which remained some time after the candle is blown out.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(113,29,'HLASSKPCWRPB','Prof. Magdalena Anderson DDS','nya.kreiger@hane.biz','0950089146','There was a paper label, with the name of nearly everything there. \'That\'s the first to break the.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(114,30,'TGFMO62YWDNS','Nelson Spencer','whettinger@yahoo.com','0805151466','YOU with us!\"\' \'They were obliged to say \'creatures,\' you see, Miss, this here ought to be sure!.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(115,30,'VRM928CXKQ7K','Mrs. Odessa Stokes IV','cristina.bashirian@ratke.net','0816175987','I\'m afraid, sir\' said Alice, a little of the Queen to play croquet with the Queen, pointing to.',NULL,'reserved','2025-06-10 10:48:16','2025-06-10 10:48:16'),(116,30,'SAEPQK0RGIXN','Alec Rath','brunte@hotmail.com','0266443617','Queen,\' and she dropped it hastily, just in time to be otherwise.\"\' \'I think I can go back and see.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(117,31,'1ZWFGZF5X1XU','Melba Jakubowski','krodriguez@hotmail.com','0897468180','March Hare said to herself, and fanned herself with one of the fact. \'I keep them to be a LITTLE.',NULL,'checked_in','2025-06-10 10:48:16','2025-06-10 10:48:16'),(118,31,'Z0PPQ3VU0XPG','Prof. Conor Schinner','maeve25@hotmail.com','0591582335','ARE a simpleton.\' Alice did not like to be otherwise.\"\' \'I think I can reach the key; and if I.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(119,31,'TQGCC2XIROZL','Dasia Hayes II','gregg45@gmail.com','0396755570','Duchess. \'I make you dry enough!\' They all returned from him to be rude, so she felt sure she.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(120,31,'A0RAHAUQNFYL','Estella Hegmann','white.kaya@gmail.com','0883719486','Alice soon came to ME, and told me you had been found and handed back to the little golden key and.',NULL,'purchased','2025-06-10 10:48:16','2025-06-10 10:48:16'),(121,31,'7MYEPSJZQNVS','Maxine Cormier','batz.agustina@lindgren.com','0658757498','Her chin was pressed so closely against her foot, that there ought! And when I got up and bawled.',NULL,'pending','2025-06-10 10:48:16','2025-06-10 10:48:16'),(122,32,'CRCY9VTG2YSC','Elmo Kirlin','rpfeffer@yahoo.com','0697250494','Duchess\'s knee, while plates and dishes crashed around it--once more the pig-baby was sneezing and.',NULL,'pending','2025-06-10 10:48:16','2025-06-10 10:48:16'),(123,32,'CSQFPYLNETJU','Prof. Kendrick Robel','caroline04@langosh.biz','0545368314','Mock Turtle. \'No, no! The adventures first,\' said the Pigeon the opportunity of adding, \'You\'re.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(124,33,'88AFTKCUTUWS','Arch Schuppe','idicki@gmail.com','0734359125','Alice as he could go. Alice took up the conversation dropped, and the Gryphon at the frontispiece.',NULL,'transferred','2025-06-10 10:48:16','2025-06-10 10:48:16'),(125,33,'CG5LGFWP3PLD','Tyreek Monahan','marcella83@kessler.com','0942099547','HE taught us Drawling, Stretching, and Fainting in Coils.\' \'What was THAT like?\' said Alice.',NULL,'cancelled','2025-06-10 10:48:16','2025-06-10 10:48:16'),(126,34,'O3ZWHFJZ1OVC','Susana Barton','considine.nellie@gmail.com','0650427902','This is the same year for such dainties would not give all else for two Pennyworth only of.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(127,34,'QI8ZHAWFWRCU','Adriana Ratke','arno.bednar@kreiger.org','0261967983','The March Hare went \'Sh! sh!\' and the poor little thing was snorting like a stalk out of sight.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(128,34,'TG9E25ASENXM','Andreane Halvorson','jaeden.prohaska@hotmail.com','0394302515','YOUR table,\' said Alice; \'it\'s laid for a great hurry. An enormous puppy was looking for them, but.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(129,34,'ADXM51S1X2KH','Lucious Braun','johnston.stanton@gmail.com','0457976131','I\'m mad?\' said Alice. The King laid his hand upon her arm, with its legs hanging down, but.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(130,35,'XXHSWV1Z5Y8E','Una Boyle','marcus.rowe@gmail.com','0958735593','Then she went round the court with a knife, it usually bleeds; and she very soon came upon a time.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(131,35,'AJFGJTHYZM9Z','Kiley Blick Sr.','yost.rhiannon@hotmail.com','0356923677','Knave \'Turn them over!\' The Knave did so, very carefully, nibbling first at one and then sat upon.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(132,35,'FIPBMTAIUPY2','Terence Stroman','whitney.wunsch@reilly.com','0458369023','I suppose Dinah\'ll be sending me on messages next!\' And she kept tossing the baby with some.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(133,35,'W4QNROMNAQPU','Prof. Hilda Yost','maritza.ullrich@hermiston.com','0705023336','Queen. \'Never!\' said the Hatter. \'He won\'t stand beating. Now, if you wouldn\'t mind,\' said Alice.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(134,35,'LKFG6PXWQNHK','Enid Sanford','german12@flatley.com','0788504747','These were the two creatures got so close to her lips. \'I know SOMETHING interesting is sure to.',NULL,'transferred','2025-06-10 10:48:17','2025-06-10 10:48:17'),(135,36,'94H9E7I9CR7E','Ms. Vilma Ward','ddicki@gmail.com','0384669355','Dodo. Then they all spoke at once, and ran till she shook the house, \"Let us both go to law: I.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(136,36,'2VUZVSJGWTYA','Kaycee Frami','alice.champlin@hotmail.com','0844448715','Alice. \'Anything you like,\' said the Caterpillar. Alice thought to herself \'That\'s quite enough--I.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(137,36,'LELOIOH6HXSF','Prof. Earlene Considine','alexandra.schneider@yahoo.com','0895638142','Knave \'Turn them over!\' The Knave of Hearts, and I shall see it trying in a sulky tone; \'Seven.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(138,36,'MQBBMD5SN357','Freeda Hickle','marjorie.abernathy@bednar.com','0307514051','This speech caused a remarkable sensation among the party. Some of the right-hand bit to try the.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(139,36,'Q2U2QLHEIYXY','Elda D\'Amore','lindgren.lexi@doyle.com','0566485955','Alice; \'you needn\'t be so stingy about it, you know--\' She had not gone (We know it to her ear.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(140,36,'TF8EOSHJU15E','Lenna Goldner','donavon.anderson@zboncak.net','0706891608','Gryphon said, in a piteous tone. And the executioner myself,\' said the Mock Turtle had just begun.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(141,37,'XTCQXNT30EI9','Brannon Kuvalis Sr.','uschamberger@gmail.com','0913639470','White Rabbit blew three blasts on the OUTSIDE.\' He unfolded the paper as he said do. Alice looked.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(142,37,'SKZADJSIALKW','Larue Kessler','clotilde.jacobi@donnelly.biz','0576436541','Alice. \'But you\'re so easily offended, you know!\' The Mouse only growled in reply. \'That\'s right!\'.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(143,38,'K0HZXL28QIZP','Zita Smith','bode.okey@wuckert.org','0950820626','Dormouse sulkily remarked, \'If you do. I\'ll set Dinah at you!\' There was no more to do so. \'Shall.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(144,38,'E9VZFNXFEXDA','Ruben Waelchi','bergnaum.bettye@murray.com','0666855031','I vote the young Crab, a little different. But if I\'m Mabel, I\'ll stay down here with me! There.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(145,38,'H2I75FCKWD2G','Alexandra Beahan','hfunk@gmail.com','0637608140','Alice guessed who it was, even before she had accidentally upset the week before. \'Oh, I know!\'.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(146,38,'HMUSDP2FPCMX','Piper Walsh','spencer00@klein.com','0564413958','But at any rate, the Dormouse fell asleep instantly, and neither of the sort. Next came the royal.',NULL,'transferred','2025-06-10 10:48:17','2025-06-10 10:48:17'),(147,39,'YECMAQSW4EE3','Miss Assunta Corkery','msauer@koch.org','0490318253','Alice thought the whole court was in managing her flamingo: she succeeded in getting its body.',NULL,'transferred','2025-06-10 10:48:17','2025-06-10 10:48:17'),(148,39,'F8OCDZSZM0K8','Dale Jones V','brian60@okuneva.com','0302797844','Soup! \'Beautiful Soup! Who cares for fish, Game, or any other dish? Who would not join the dance.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(149,39,'AFXUNCJ9VWOY','Jaquelin Morissette DDS','catalina12@yahoo.com','0393218829','Alice replied thoughtfully. \'They have their tails in their mouths--and they\'re all over their.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(150,39,'UX2WEZTLW7OB','Ms. Janae Wintheiser','sprosacco@yahoo.com','0865295272','Alice to herself. \'Of the mushroom,\' said the King. The White Rabbit hurried by--the frightened.',NULL,'transferred','2025-06-10 10:48:17','2025-06-10 10:48:17'),(151,39,'DCMZ925INMHY','Isabella Mann','ehayes@littel.biz','0056053061','ONE with such a long breath, and till the puppy\'s bark sounded quite faint in the distance. \'And.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(152,39,'EOWRJRUXNSQF','Roman Ward','vcollier@bartell.info','0112024499','Alice, that she began nursing her child again, singing a sort of lullaby to it as far down the.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(153,40,'ZUYBLJALTVYC','Hannah Swaniawski','sanford.buckridge@gmail.com','0657063925','CHAPTER XI. Who Stole the Tarts? The King and Queen of Hearts, carrying the King\'s crown on a.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(154,40,'BF924XIIW8RA','Wilton Bosco','kuhic.ryley@hotmail.com','0110627406','This time there could be NO mistake about it: it was a large kitchen, which was immediately.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(155,40,'E8UOK6TW9COX','Cecil Bergnaum MD','hoppe.ali@hettinger.biz','0341730026','It doesn\'t look like one, but the three were all writing very busily on slates. \'What are you.',NULL,'transferred','2025-06-10 10:48:17','2025-06-10 10:48:17'),(156,40,'LQP0KTIY8JA2','Dorian Rutherford','summer60@vandervort.org','0244695680','There was not much like keeping so close to the fifth bend, I think?\' he said in an encouraging.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(157,40,'L4KB4ZVH7MCH','Pink Mante','doug.dibbert@hotmail.com','0941920013','Alice. \'Why not?\' said the Dormouse. \'Fourteenth of March, I think I should say \"With what.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(158,40,'DSTLWJ88JRTJ','Eileen Grady','ike.halvorson@dibbert.com','0285919198','MARMALADE\', but to get out of its mouth again, and we put a stop to this,\' she said these words.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(159,41,'HO46GV4MLWKO','Sammie Hagenes','laurie.gerhold@yahoo.com','0368312281','I\'m afraid, but you might like to be seen--everything seemed to rise like a stalk out of the.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(160,41,'LPZC4MGJGI4X','Mr. Edward Bins','susie34@yahoo.com','0869812785','Fish-Footman was gone, and the small ones choked and had just upset the week before. \'Oh, I beg.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(161,42,'EADGYYHMO80F','Gudrun Collins','kathryn68@hotmail.com','0196009799','Rabbit say, \'A barrowful will do, to begin at HIS time of life. The King\'s argument was, that she.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(162,42,'C1SYPYVBIXNB','Alessia Rippin PhD','micheal.purdy@yahoo.com','0972168441','I do,\' said Alice indignantly, and she felt a little door about fifteen inches high: she tried to.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(163,43,'YKY0E1BMS8HY','Dr. Maybell Schaefer I','cleta40@pagac.net','0471410291','Queen, and in another moment that it is!\' As she said this, she looked back once or twice she had.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(164,43,'AGJVZ3AIRXX2','Mr. Timmy Hegmann IV','zena.kuphal@gmail.com','0817734761','Dinah, tell me the truth: did you begin?\' The Hatter was the first to speak. \'What size do you.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(165,43,'09OXV9PGPU2D','Emmanuel Towne','adelbert33@ferry.com','0892645800','And I declare it\'s too bad, that it was an old Turtle--we used to say.\' \'So he did, so he with his.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(166,43,'ZYMYFMX5XDWD','Prof. Katherine Dibbert','kris.jacky@hotmail.com','0396780058','Presently the Rabbit noticed Alice, as she could have told you butter wouldn\'t suit the works!\' he.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(167,43,'62UNHTFDDFCD','Destany Littel','brook.muller@kling.info','0649233606','Mock Turtle: \'crumbs would all come wrong, and she ran across the garden, called out as loud as.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(168,44,'FEVYORTLWIWY','Drew Gibson DDS','eduardo.thompson@gmail.com','0651305246','I don\'t like them!\' When the Mouse was speaking, and this time she had but to her daughter \'Ah, my.',NULL,'pending','2025-06-10 10:48:17','2025-06-10 10:48:17'),(169,44,'ZU4ARADSMU8H','Madge Lebsack','tara.marks@shields.net','0335245415','I was going to dive in among the leaves, which she had peeped into the Dormouse\'s place, and Alice.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(170,45,'3OTMGKL8OC1A','Javier Reynolds Jr.','rosanna60@wisoky.biz','0450379578','Mock Turtle with a lobster as a boon, Was kindly permitted to pocket the spoon: While the Duchess.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(171,45,'RTWH3FFBFSPY','Dr. Wellington Dickens','pollich.pedro@keeling.biz','0710702076','What happened to me! I\'LL soon make you dry enough!\' They all made of solid glass; there was no.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(172,45,'PWCCYAGW0JKC','Raphaelle VonRueden','nedra.klocko@bednar.info','0899517501','I should think you\'ll feel it a minute or two, it was a dead silence instantly, and neither of the.',NULL,'checked_in','2025-06-10 10:48:17','2025-06-10 10:48:17'),(173,45,'E2JT8G94WF0D','Keyon Feeney','modesto.lockman@tremblay.com','0753244121','Rabbit was no more to do it?\' \'In my youth,\' Father William replied to his son, \'I feared it might.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(174,45,'RNQC6NTYJXPF','Dan Green','regan45@runolfsdottir.net','0061238927','ME, and told me he was obliged to have no idea what to do such a dear quiet thing,\' Alice went on.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(175,45,'BHRPCZRBSDQL','Dr. Jovanny Prohaska V','ametz@hotmail.com','0324951571','Alice. The King laid his hand upon her knee, and looking anxiously round to see that the meeting.',NULL,'reserved','2025-06-10 10:48:17','2025-06-10 10:48:17'),(176,46,'WE8NJYJXE06S','Timothy Mraz','christa.spencer@yahoo.com','0686988210','He looked at the March Hare. \'Exactly so,\' said Alice. The poor little thing howled so, that Alice.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(177,46,'OUOKUUCAPTWE','Syble O\'Conner','shields.alessandra@yahoo.com','0792796861','And argued each case with my wife; And the muscular strength, which it gave to my right size to do.',NULL,'refunded','2025-06-10 10:48:17','2025-06-10 10:48:17'),(178,46,'1ZYTQAUG4QM4','Lloyd Beatty DDS','moen.domenick@gmail.com','0511417106','So she swallowed one of the lefthand bit. * * * * * * * * * * * * * * * * * * * * * * * * * * * *.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(179,46,'BITGHRWRZ992','Ms. Rachelle Lubowitz II','dkirlin@gmail.com','0243016974','Alice. \'It must be growing small again.\' She got up this morning, but I hadn\'t cried so much!\'.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(180,46,'8XLYZG3O2IMV','Troy Hoppe','maximillia.klein@hotmail.com','0481744725','Gryphon whispered in reply, \'for fear they should forget them before the trial\'s over!\' thought.',NULL,'cancelled','2025-06-10 10:48:17','2025-06-10 10:48:17'),(181,46,'Q43P5DX1NNAE','Westley Pollich','kirk.champlin@bauch.com','0346125135','Hatter hurriedly left the court, \'Bring me the truth: did you call him Tortoise, if he had to.',NULL,'purchased','2025-06-10 10:48:17','2025-06-10 10:48:17'),(182,47,'WGMSLWP1KML9','Hollis Ernser','veda19@yahoo.com','0889239361','THEIR eyes bright and eager with many a strange tale, perhaps even with the strange creatures of.',NULL,'cancelled','2025-06-10 10:48:18','2025-06-10 10:48:18'),(183,47,'U5UL369KYVPP','Cameron Dicki II','reinger.lamont@gmail.com','0222163944','And I declare it\'s too bad, that it would like the look of it appeared. \'I don\'t like the look of.',NULL,'transferred','2025-06-10 10:48:18','2025-06-10 10:48:18'),(184,48,'PKC8YWO66TU7','Myrna Carroll','terry.lavina@borer.com','0762158137','Alice said nothing; she had finished, her sister on the floor: in another moment that it might.',NULL,'pending','2025-06-10 10:48:18','2025-06-10 10:48:18'),(185,48,'BW9NRNYGPJHM','Mr. Dagmar Keebler IV','gaylord.schmeler@williamson.com','0862086297','The only things in the shade: however, the moment he was gone, and, by the hedge!\' then silence.',NULL,'checked_in','2025-06-10 10:48:18','2025-06-10 10:48:18'),(186,48,'BDSME1YMNER1','Ephraim Bogan','leopold92@hotmail.com','0209304456','Alice. \'Now we shall get on better.\' \'I\'d rather finish my tea,\' said the Cat. \'I\'d nearly.',NULL,'checked_in','2025-06-10 10:48:18','2025-06-10 10:48:18'),(187,48,'PQAS09JF5JUV','Mrs. Willow Batz','bpacocha@hotmail.com','0944316878','And certainly there was room for this, and Alice looked very uncomfortable. The moment Alice felt.',NULL,'checked_in','2025-06-10 10:48:18','2025-06-10 10:48:18'),(188,49,'75TKSKKFMTXA','Lilly McKenzie I','ottis.morissette@hotmail.com','0821843005','PLENTY of room!\' said Alice as he could think of what work it would be four thousand miles down, I.',NULL,'reserved','2025-06-10 10:48:18','2025-06-10 10:48:18'),(189,49,'QNYHVLWSZLUX','Zackary Kris','wyman.kale@crona.com','0874429868','And how odd the directions will look! ALICE\'S RIGHT FOOT, ESQ. HEARTHRUG, NEAR THE FENDER, (WITH.',NULL,'pending','2025-06-10 10:48:18','2025-06-10 10:48:18'),(190,49,'ZVNNH5EFC69R','Prof. Vickie Renner','funk.curtis@gmail.com','0352290483','This time there could be beheaded, and that is rather a handsome pig, I think.\' And she went on.',NULL,'purchased','2025-06-10 10:48:18','2025-06-10 10:48:18'),(191,49,'HWZPNNTD2BYM','Alexa Brown','ghansen@yahoo.com','0323317263','Gryphon: and it was YOUR table,\' said Alice; \'I might as well to say but \'It belongs to the.',NULL,'refunded','2025-06-10 10:48:18','2025-06-10 10:48:18'),(192,49,'TRRGE86APPZY','Will Robel V','antwan.connelly@gutmann.biz','0140911944','Footman. \'That\'s the first figure!\' said the King. \'It began with the glass table and the three.',NULL,'purchased','2025-06-10 10:48:18','2025-06-10 10:48:18'),(193,50,'SUW3ARJS1UMD','Mariana Kohler','flatley.isabella@hotmail.com','0513198322','Mouse in the other: he came trotting along in a Little Bill It was the White Rabbit read out, at.',NULL,'pending','2025-06-10 10:48:18','2025-06-10 10:48:18'),(194,50,'APS0LNSCVA9K','Sonya Little Sr.','hoeger.emely@yahoo.com','0776409274','Hatter; \'so I can\'t see you?\' She was a large flower-pot that stood near the door, and knocked.',NULL,'reserved','2025-06-10 10:48:18','2025-06-10 10:48:18'),(195,50,'6WTRZWZ3V0AA','Dr. Coleman Dicki III','jaskolski.rhoda@collins.biz','0566356468','Let me see: I\'ll give them a new idea to Alice, she went to school every day--\' \'I\'VE been to her.',NULL,'checked_in','2025-06-10 10:48:18','2025-06-10 10:48:18'),(196,50,'NHSQQD5Z9B5P','Dr. Joey Beier','shanahan.kiley@wiegand.com','0627828587','The three soldiers wandered about for some way, and nothing seems to be two people! Why, there\'s.',NULL,'pending','2025-06-10 10:48:18','2025-06-10 10:48:18');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:47:58','2025-06-10 10:47:58','Saepe debitis modi illo suscipit. Vitae et dolor iste. Veniam sapiente dicta qui enim dolor.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:47:58','2025-06-10 10:47:58','Alias est facilis repellat deserunt amet nam repellendus. Sint illum vero id est et tempora qui.'),(3,'Event Experience',0,'published','2025-06-10 10:47:58','2025-06-10 10:47:58','Fuga sed sapiente dolorem soluta. Repellendus sed pariatur qui et consequatur.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:47:58','2025-06-10 10:47:58','Cumque asperiores non odit dolores. Voluptates provident ut rerum illo odit.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Beatae deserunt exercitationem quia qui a.','Aut quia ipsa velit non veniam asperiores ratione consectetur ea error maxime voluptatem quia iste quibusdam ut fugiat et ut praesentium consequuntur.',2,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(2,'Cum nihil non fuga corrupti.','Fugiat aut dolorem inventore vitae perspiciatis et consequuntur rem exercitationem sequi commodi et quae sed impedit et aut aut nihil libero sapiente reprehenderit mollitia et natus eius esse dolorum perferendis ut nostrum voluptatem.',2,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(3,'Atque velit exercitationem aut aut.','Temporibus cum qui voluptas et voluptates commodi nostrum iure maiores voluptatibus necessitatibus odio odit corporis aut sint nulla doloribus asperiores officia veritatis ad reprehenderit.',4,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(4,'In porro tenetur qui quisquam deleniti.','Quidem sed quibusdam culpa non repellat dolor minus qui sit consequatur omnis accusantium perspiciatis fugiat repellat voluptatibus sit id quod ea eum et sunt eum nobis voluptas dolores unde vel id minus inventore.',1,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(5,'Qui molestiae aperiam quidem temporibus aliquam perferendis.','Aliquam magnam eligendi commodi nam voluptatibus ullam quibusdam molestiae placeat nesciunt recusandae quam aspernatur provident in eum ut voluptate ab possimus quibusdam unde magni aspernatur.',4,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(6,'Illum nihil nisi quos.','Porro doloremque id quasi ipsum et maiores facilis quia nemo veniam ea quos est et nesciunt ipsum magnam sed voluptate quos officiis aut quae aut harum sapiente animi impedit perferendis unde non ea qui sit sed rerum quibusdam sunt qui minima.',4,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(7,'Delectus consectetur voluptatum temporibus.','Sit error odio nulla cupiditate illum soluta ipsam voluptas est totam recusandae voluptas minima voluptatum dolorum quam dolore fugiat dolor id.',3,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(8,'Non nemo maiores temporibus.','Delectus et cum dolorum suscipit sunt aliquid minima esse beatae ut velit minus soluta occaecati esse aut explicabo veniam sequi rem vel ratione dolorum laborum quia quis vitae et ipsam sed earum expedita quisquam non tempore ipsa.',4,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(9,'Autem ut ut porro.','Voluptate nemo ut adipisci alias totam iste nobis consectetur eaque incidunt qui possimus sint qui esse dolorem sit at commodi maiores enim quibusdam possimus omnis delectus aut beatae quasi.',1,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(10,'Sunt ut consequuntur tenetur.','Praesentium quod aut dolores distinctio ut adipisci aspernatur laborum quod occaecati ullam minus sunt autem eius aut voluptas optio deleniti quod veniam.',4,'published','2025-06-10 10:47:58','2025-06-10 10:47:58'),(11,'Eveniet aliquid voluptate et ipsum.','Corrupti molestiae dolorum aut veniam amet aperiam in est facilis similique dolore sit ut error cumque illum consequatur consequatur illo voluptatem qui quas dolor aliquid impedit et aut.',1,'published','2025-06-10 10:47:58','2025-06-10 10:47:58');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Laboriosam quis aliquid quia praesentium qui. Consectetur maxime sit qui. Amet qui dicta molestiae inventore unde labore.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:47:34','2025-06-10 10:47:34'),(2,'Ocean Views','Id molestiae ut velit vel ut nisi autem. Assumenda placeat quo eaque adipisci culpa et.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:47:34','2025-06-10 10:47:34'),(3,'Adventure Time','Culpa quod perspiciatis placeat explicabo. Voluptatem aut amet vitae consequatur nobis. Occaecati quis est sunt aperiam.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(4,'City Lights','Et nam perspiciatis explicabo repellendus dolores. Ut esse est eos harum quia unde amet deleniti. Error sit eligendi cumque.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(5,'Dreamscape','Sint dolorem commodi vel eius voluptatibus. Vitae debitis placeat molestiae vitae labore. Rem sint eum asperiores asperiores.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(6,'Enchanted Forest','Nisi laboriosam quisquam qui nulla. Est adipisci qui omnis est dolor ipsum.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(7,'Golden Hour','Iusto ut illo non et dolorem in. Perferendis pariatur blanditiis earum quas quis ut. Voluptatem repellendus velit dolorem atque sed.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(8,'Serenity','Nihil eligendi est architecto numquam rerum. Nesciunt ea expedita voluptates id. Error eos eius ab numquam.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(9,'Eternal Beauty','Corrupti eius et vel omnis voluptas nihil eos. Nisi vero occaecati ut iure amet nobis maiores. Quasi pariatur ut praesentium fugit.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(10,'Moonlight Magic','Dolores maxime qui modi inventore aut est. Alias nobis eligendi officia fuga cumque nobis.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(11,'Starry Night','Dolorum eum et fugiat ab porro et dolorem ad. Accusantium minus enim nostrum. Et in et sed ut.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(12,'Hidden Gems','Expedita perspiciatis ut nobis iste corrupti esse. Fugiat error magnam autem quo velit. Qui sint amet ut ea.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(13,'Tranquil Waters','Dicta mollitia error quas magnam. Reprehenderit nihil dolore voluptatem eaque reprehenderit. Est id commodi provident asperiores quis qui vero omnis.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(14,'Urban Escape','Dicta et aperiam minima voluptate inventore ut officia. Incidunt nam ut explicabo maxime quo aut. Quis quae quia earum autem unde excepturi et.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35'),(15,'Twilight Zone','Rem vitae tempore et impedit autem. Tempore non in perspiciatis labore ipsum ut. Amet in quia vel assumenda commodi in nostrum.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:47:35','2025-06-10 10:47:35');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:34','2025-06-10 10:47:34'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Qui rerum aut temporibus rerum autem. Voluptas voluptatem sint voluptatum nisi dignissimos asperiores qui. Minus placeat reiciendis nostrum.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ex non ut enim similique voluptas. Quidem mollitia minima neque quaerat est minus. Aut tenetur laboriosam sint labore.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Enim dolor sed dolores velit voluptatibus temporibus. Enim nobis qui quasi iure est officiis. Excepturi quam repellat adipisci iure et praesentium.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Consequatur nihil ea in eos minus temporibus. Voluptate et iusto sunt molestias corrupti. Quaerat et et nesciunt aut quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Qui necessitatibus nulla et nulla quis ipsam. Quo laudantium eaque vel nesciunt. Dolor quae provident consequatur sint quo dolorem.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Consequatur aut necessitatibus aliquid ipsam eos. Ea temporibus accusantium sapiente ut. Qui laudantium corrupti corporis sint.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Architecto qui soluta ipsum perspiciatis eius quam. Est fugiat deserunt ratione in. Voluptatum dolores rem voluptatem cupiditate sed.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Quam magni asperiores exercitationem quisquam ipsam. Adipisci molestiae aliquid qui porro qui iure earum. Modi voluptas quo dicta sit alias ullam.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Est tenetur perferendis nesciunt ducimus. Non voluptates mollitia animi doloribus. Fuga qui adipisci maxime. Et impedit sequi repellendus vel aut.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Rerum rerum vitae assumenda qui perferendis non est. Pariatur consequuntur quos velit sit dolore. Vitae velit inventore odio.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Exercitationem distinctio doloribus explicabo quia. Nemo eaque et et. Nihil soluta blanditiis modi tenetur ducimus.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Quidem quaerat doloremque fugiat quod. Ipsa expedita velit ad laudantium sed. Ut aut dolorem consequuntur molestiae.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Cumque hic dolores architecto voluptatem reprehenderit. Et omnis amet sed. Optio impedit debitis dolorem id.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Nesciunt est aut rem esse non ad excepturi. Qui illo voluptates nihil iure. Ipsam deleniti ipsa nam dignissimos molestiae quis nostrum.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Mollitia vel maxime ipsa dolore dolor quia. Omnis mollitia dolor sunt sequi nam sed. Ducimus incidunt voluptas inventore et.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Consequuntur quisquam tempore quos qui. Ducimus cumque nobis hic dolorum incidunt omnis est ipsa.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Doloremque ratione qui odit fugit culpa quis amet. Quam harum omnis nam sint rerum culpa non. Id provident et labore quo.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Porro nobis dicta libero aut. Vel esse reprehenderit rerum qui. Fuga eos velit voluptatibus ex architecto. Rerum provident et distinctio rerum sunt.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Fugit libero quis corrupti quo voluptatibus nobis. Delectus explicabo quas libero. Laborum doloribus vero sit. Eligendi quia quia laborum animi quos.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Quas beatae suscipit voluptate cumque amet ut nam. Libero harum saepe fuga minima enim. Reprehenderit et officiis voluptas vitae.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:47:35','2025-06-10 10:47:35');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','1cda706f6ab25d07e5d8f7e7f1eeb55c',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','b9fa40e2918bc336006db705c5c5b2c9',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','dae703e1f0253eb5301ad71c2bbb03ba',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (12,0,'15-date','15-date',4,'image/webp',3582,'homepage10/general/15-date.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(13,0,'about-us-information-1','about-us-information-1',4,'image/webp',6939,'homepage10/general/about-us-information-1.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(14,0,'about-us-information-2','about-us-information-2',4,'image/webp',2537,'homepage10/general/about-us-information-2.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(15,0,'about-us-information-3','about-us-information-3',4,'image/webp',3508,'homepage10/general/about-us-information-3.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(16,0,'about-us-information-4','about-us-information-4',4,'image/webp',3217,'homepage10/general/about-us-information-4.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(17,0,'feature-img1','feature-img1',4,'image/webp',9801,'homepage10/general/feature-img1.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(18,0,'hero-img1','hero-img1',4,'image/webp',1221,'homepage10/general/hero-img1.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(19,0,'hero-img2','hero-img2',4,'image/webp',1221,'homepage10/general/hero-img2.webp','[]','2025-06-10 10:47:27','2025-06-10 10:47:27',NULL,'public'),(20,0,'hero-img3','hero-img3',4,'image/webp',1221,'homepage10/general/hero-img3.webp','[]','2025-06-10 10:47:28','2025-06-10 10:47:28',NULL,'public'),(21,0,'logo2','logo2',4,'image/png',238,'homepage10/general/logo2.png','[]','2025-06-10 10:47:28','2025-06-10 10:47:28',NULL,'public'),(22,0,'hero-bg','hero-bg',5,'image/png',25342,'homepage10/backgrounds/hero-bg.png','[]','2025-06-10 10:47:28','2025-06-10 10:47:28',NULL,'public'),(23,0,'ticket-img','ticket-img',6,'image/png',3669,'homepage10/icons/ticket-img.png','[]','2025-06-10 10:47:28','2025-06-10 10:47:28',NULL,'public'),(24,0,'user-img','user-img',6,'image/png',5229,'homepage10/icons/user-img.png','[]','2025-06-10 10:47:28','2025-06-10 10:47:28',NULL,'public'),(45,0,'1','1',8,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:47:35','2025-06-10 10:47:35',NULL,'public'),(46,0,'2','2',8,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:47:35','2025-06-10 10:47:35',NULL,'public'),(47,0,'3','3',8,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:47:35','2025-06-10 10:47:35',NULL,'public'),(48,0,'4','4',8,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:47:36','2025-06-10 10:47:36',NULL,'public'),(49,0,'brand-img1','brand-img1',9,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:47:36','2025-06-10 10:47:36',NULL,'public'),(50,0,'brand-img2','brand-img2',9,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:47:36','2025-06-10 10:47:36',NULL,'public'),(51,0,'brand-img3','brand-img3',9,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:47:36','2025-06-10 10:47:36',NULL,'public'),(52,0,'brand-img4','brand-img4',9,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:47:36','2025-06-10 10:47:36',NULL,'public'),(53,0,'brand-img5','brand-img5',9,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:47:36','2025-06-10 10:47:36',NULL,'public'),(54,0,'brand-img6','brand-img6',9,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:47:36','2025-06-10 10:47:36',NULL,'public'),(55,0,'brand-img7','brand-img7',9,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:47:37','2025-06-10 10:47:37',NULL,'public'),(56,0,'brand-img8','brand-img8',9,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:47:37','2025-06-10 10:47:37',NULL,'public'),(57,0,'1','1',10,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:47:37','2025-06-10 10:47:37',NULL,'public'),(58,0,'2','2',10,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:47:37','2025-06-10 10:47:37',NULL,'public'),(59,0,'header-bg4','header-bg4',10,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:47:37','2025-06-10 10:47:37',NULL,'public'),(60,0,'hero-banner-bg','hero-banner-bg',10,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:47:38','2025-06-10 10:47:38',NULL,'public'),(61,0,'image-1','image-1',10,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:47:39','2025-06-10 10:47:39',NULL,'public'),(62,0,'newsletter-bg','newsletter-bg',10,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:47:40','2025-06-10 10:47:40',NULL,'public'),(63,0,'pricing-name','pricing-name',10,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:47:40','2025-06-10 10:47:40',NULL,'public'),(64,0,'speakers-bg','speakers-bg',10,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:47:41','2025-06-10 10:47:41',NULL,'public'),(65,0,'balloons','balloons',11,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:47:41','2025-06-10 10:47:41',NULL,'public'),(66,0,'calendar','calendar',11,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:47:41','2025-06-10 10:47:41',NULL,'public'),(67,0,'clock','clock',11,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:47:42','2025-06-10 10:47:42',NULL,'public'),(68,0,'coding','coding',11,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:47:42','2025-06-10 10:47:42',NULL,'public'),(69,0,'idea','idea',11,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:47:42','2025-06-10 10:47:42',NULL,'public'),(70,0,'instagram-icon','instagram-icon',11,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:47:42','2025-06-10 10:47:42',NULL,'public'),(71,0,'location-icon','location-icon',11,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:47:42','2025-06-10 10:47:42',NULL,'public'),(72,0,'location','location',11,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:47:42','2025-06-10 10:47:42',NULL,'public'),(73,0,'mail-icon','mail-icon',11,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:47:43','2025-06-10 10:47:43',NULL,'public'),(74,0,'menu','menu',11,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:47:43','2025-06-10 10:47:43',NULL,'public'),(75,0,'microphone','microphone',11,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:47:43','2025-06-10 10:47:43',NULL,'public'),(76,0,'phone-icon','phone-icon',11,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:47:43','2025-06-10 10:47:43',NULL,'public'),(77,0,'search','search',11,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:47:43','2025-06-10 10:47:43',NULL,'public'),(78,0,'speaker','speaker',11,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:47:43','2025-06-10 10:47:43',NULL,'public'),(79,0,'ticket','ticket',11,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:47:43','2025-06-10 10:47:43',NULL,'public'),(80,0,'user','user',11,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:47:44','2025-06-10 10:47:44',NULL,'public'),(81,0,'view','view',11,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:47:44','2025-06-10 10:47:44',NULL,'public'),(82,0,'workshop','workshop',11,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:47:44','2025-06-10 10:47:44',NULL,'public'),(83,0,'1','1',7,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:47:44','2025-06-10 10:47:44',NULL,'public'),(84,0,'10','10',7,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:47:44','2025-06-10 10:47:44',NULL,'public'),(85,0,'11','11',7,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:47:45','2025-06-10 10:47:45',NULL,'public'),(86,0,'12','12',7,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:47:45','2025-06-10 10:47:45',NULL,'public'),(87,0,'13','13',7,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:47:45','2025-06-10 10:47:45',NULL,'public'),(88,0,'14','14',7,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:47:46','2025-06-10 10:47:46',NULL,'public'),(89,0,'15','15',7,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:47:46','2025-06-10 10:47:46',NULL,'public'),(90,0,'16','16',7,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:47:46','2025-06-10 10:47:46',NULL,'public'),(91,0,'17','17',7,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:47:47','2025-06-10 10:47:47',NULL,'public'),(92,0,'18','18',7,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:47:47','2025-06-10 10:47:47',NULL,'public'),(93,0,'19','19',7,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:47:47','2025-06-10 10:47:47',NULL,'public'),(94,0,'2','2',7,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:47:48','2025-06-10 10:47:48',NULL,'public'),(95,0,'20','20',7,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:47:48','2025-06-10 10:47:48',NULL,'public'),(96,0,'3','3',7,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:47:48','2025-06-10 10:47:48',NULL,'public'),(97,0,'4','4',7,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:47:49','2025-06-10 10:47:49',NULL,'public'),(98,0,'5','5',7,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:47:49','2025-06-10 10:47:49',NULL,'public'),(99,0,'6','6',7,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:47:49','2025-06-10 10:47:49',NULL,'public'),(100,0,'7','7',7,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:47:50','2025-06-10 10:47:50',NULL,'public'),(101,0,'8','8',7,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:47:50','2025-06-10 10:47:50',NULL,'public'),(102,0,'9','9',7,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:47:50','2025-06-10 10:47:50',NULL,'public'),(103,0,'1','1',12,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:47:51','2025-06-10 10:47:51',NULL,'public'),(104,0,'10','10',12,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:47:51','2025-06-10 10:47:51',NULL,'public'),(105,0,'11','11',12,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:47:51','2025-06-10 10:47:51',NULL,'public'),(106,0,'12','12',12,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:47:52','2025-06-10 10:47:52',NULL,'public'),(107,0,'13','13',12,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:47:52','2025-06-10 10:47:52',NULL,'public'),(108,0,'14','14',12,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:47:52','2025-06-10 10:47:52',NULL,'public'),(109,0,'15','15',12,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:47:53','2025-06-10 10:47:53',NULL,'public'),(110,0,'16','16',12,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:47:53','2025-06-10 10:47:53',NULL,'public'),(111,0,'17','17',12,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:47:53','2025-06-10 10:47:53',NULL,'public'),(112,0,'18','18',12,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:47:54','2025-06-10 10:47:54',NULL,'public'),(113,0,'19','19',12,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:47:54','2025-06-10 10:47:54',NULL,'public'),(114,0,'2','2',12,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:47:54','2025-06-10 10:47:54',NULL,'public'),(115,0,'20','20',12,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:47:55','2025-06-10 10:47:55',NULL,'public'),(116,0,'3','3',12,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:47:55','2025-06-10 10:47:55',NULL,'public'),(117,0,'4','4',12,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:47:55','2025-06-10 10:47:55',NULL,'public'),(118,0,'5','5',12,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:47:56','2025-06-10 10:47:56',NULL,'public'),(119,0,'6','6',12,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:47:56','2025-06-10 10:47:56',NULL,'public'),(120,0,'7','7',12,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:47:56','2025-06-10 10:47:56',NULL,'public'),(121,0,'8','8',12,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:47:57','2025-06-10 10:47:57',NULL,'public'),(122,0,'9','9',12,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:47:57','2025-06-10 10:47:57',NULL,'public'),(123,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:47:58','2025-06-10 10:47:58',NULL,'public'),(124,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:47:58','2025-06-10 10:47:58',NULL,'public'),(125,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:47:58','2025-06-10 10:47:58',NULL,'public'),(126,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:47:58','2025-06-10 10:47:58',NULL,'public'),(127,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:47:58','2025-06-10 10:47:58',NULL,'public'),(128,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:47:59','2025-06-10 10:47:59',NULL,'public'),(129,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:47:59','2025-06-10 10:47:59',NULL,'public'),(130,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:47:59','2025-06-10 10:47:59',NULL,'public'),(131,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:47:59','2025-06-10 10:47:59',NULL,'public'),(132,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:47:59','2025-06-10 10:47:59',NULL,'public'),(133,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:47:59','2025-06-10 10:47:59',NULL,'public'),(134,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:48:00','2025-06-10 10:48:00',NULL,'public'),(135,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:48:00','2025-06-10 10:48:00',NULL,'public'),(136,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:48:00','2025-06-10 10:48:00',NULL,'public'),(137,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:48:00','2025-06-10 10:48:00',NULL,'public'),(138,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:48:00','2025-06-10 10:48:00',NULL,'public'),(139,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:48:00','2025-06-10 10:48:00',NULL,'public'),(140,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:48:01','2025-06-10 10:48:01',NULL,'public'),(141,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:48:01','2025-06-10 10:48:01',NULL,'public'),(142,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:48:01','2025-06-10 10:48:01',NULL,'public'),(143,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:48:01','2025-06-10 10:48:01',NULL,'public'),(144,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:48:01','2025-06-10 10:48:01',NULL,'public'),(145,0,'0','0',14,'image/webp',33268,'main/events/0-1749552487.webp','[]','2025-06-10 10:48:07','2025-06-10 10:48:07',NULL,'public'),(146,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:48:08','2025-06-10 10:48:08',NULL,'public'),(147,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:48:08','2025-06-10 10:48:08',NULL,'public'),(148,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:48:08','2025-06-10 10:48:08',NULL,'public'),(149,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:48:08','2025-06-10 10:48:08',NULL,'public'),(150,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:48:09','2025-06-10 10:48:09',NULL,'public'),(151,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:48:09','2025-06-10 10:48:09',NULL,'public'),(152,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:48:09','2025-06-10 10:48:09',NULL,'public'),(153,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:48:10','2025-06-10 10:48:10',NULL,'public'),(154,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:48:10','2025-06-10 10:48:10',NULL,'public'),(155,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:48:10','2025-06-10 10:48:10',NULL,'public'),(156,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:48:11','2025-06-10 10:48:11',NULL,'public'),(157,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:48:11','2025-06-10 10:48:11',NULL,'public'),(158,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:48:11','2025-06-10 10:48:11',NULL,'public'),(159,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:48:12','2025-06-10 10:48:12',NULL,'public'),(160,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:48:12','2025-06-10 10:48:12',NULL,'public'),(161,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:48:12','2025-06-10 10:48:12',NULL,'public'),(162,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:48:13','2025-06-10 10:48:13',NULL,'public'),(163,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:48:13','2025-06-10 10:48:13',NULL,'public'),(164,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:48:13','2025-06-10 10:48:13',NULL,'public'),(165,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:48:13','2025-06-10 10:48:13',NULL,'public'),(166,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:48:24','2025-06-10 10:48:24',NULL,'public'),(167,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:48:24','2025-06-10 10:48:24',NULL,'public'),(168,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:48:25','2025-06-10 10:48:25',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:47:25','2025-06-10 10:47:25',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:47:25','2025-06-10 10:47:25',NULL),(3,0,'homepage10',NULL,'homepage10',0,'2025-06-10 10:47:26','2025-06-10 10:47:26',NULL),(4,0,'general',NULL,'general',3,'2025-06-10 10:47:26','2025-06-10 10:47:26',NULL),(5,0,'backgrounds',NULL,'backgrounds',3,'2025-06-10 10:47:28','2025-06-10 10:47:28',NULL),(6,0,'icons',NULL,'icons',3,'2025-06-10 10:47:28','2025-06-10 10:47:28',NULL),(7,0,'news',NULL,'news',1,'2025-06-10 10:47:28','2025-06-10 10:47:28',NULL),(8,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:47:35','2025-06-10 10:47:35',NULL),(9,0,'brands',NULL,'brands',1,'2025-06-10 10:47:36','2025-06-10 10:47:36',NULL),(10,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:47:37','2025-06-10 10:47:37',NULL),(11,0,'icons',NULL,'icons',1,'2025-06-10 10:47:41','2025-06-10 10:47:41',NULL),(12,0,'blogs',NULL,'blogs',1,'2025-06-10 10:47:51','2025-06-10 10:47:51',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:48:00','2025-06-10 10:48:00',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:48:07','2025-06-10 10:48:07',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:48:24','2025-06-10 10:48:24',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:48:24','2025-06-10 10:48:24');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:48:24','2025-06-10 10:48:24');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:48:24','2025-06-10 10:48:24');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:47:36','2025-06-10 10:47:36'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:47:36','2025-06-10 10:47:36'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:47:36','2025-06-10 10:47:36'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:47:36','2025-06-10 10:47:36'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:47:51','2025-06-10 10:47:51'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:47:51','2025-06-10 10:47:51'),(7,'title','[\"Product Manager\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(8,'description','[\"Alice started to her great delight it fitted! Alice opened the door and went on in a great many more than three.\' \'Your hair wants cutting,\' said the Cat. \'I said pig,\' replied Alice; \'and I do.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(9,'address','[\"212 Arch Station\\nNorth Pierceborough, LA 37835\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(11,'title','[\"Frontend Developer\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(12,'description','[\"Bill! I wouldn\'t say anything about it, even if I would talk on such a thing. After a while, finding that nothing more happened, she decided to remain where she was, and waited. When the pie was all.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(13,'address','[\"75083 Davonte Streets\\nPearlmouth, NH 60135-5773\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(15,'title','[\"Backend Developer\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(16,'description','[\"Alice said; \'there\'s a large dish of tarts upon it: they looked so good, that it would make with the other: the only difficulty was, that if you please! \\\"William the Conqueror, whose cause was.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(17,'address','[\"61132 Lesch Drive Apt. 338\\nNew Marcia, CT 47870\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(19,'title','[\"System Administrator\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(20,'description','[\"So they went up to Alice, flinging the baby joined):-- \'Wow! wow! wow!\' \'Here! you may nurse it a very short time the Queen said to the Knave. The Knave shook his head mournfully. \'Not I!\' he.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(21,'address','[\"7006 Ella Haven Apt. 536\\nLake Mayborough, IN 98354-1566\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(23,'title','[\"Fullstack Developer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(24,'description','[\"Caterpillar. \'Is that all?\' said the Hatter, \'I cut some more tea,\' the March Hare took the thimble, looking as solemn as she spoke. (The unfortunate little Bill had left off staring at the top of.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(25,'address','[\"3439 McClure Corners\\nSouth Maximilianchester, FL 99725-1059\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:02','2025-06-10 10:48:02'),(27,'title','[\"Frontend Developer\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(28,'description','[\"YOUR business, Two!\' said Seven. \'Yes, it IS his business!\' said Five, \'and I\'ll tell you just now what the flame of a treacle-well--eh, stupid?\' \'But they were nowhere to be no chance of this, so.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(29,'address','[\"8017 Haskell Plains Apt. 768\\nKrisfurt, NM 06063-5843\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(31,'title','[\"Frontend Developer\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(32,'description','[\"The March Hare said to the other: he came trotting along in a low, trembling voice. \'There\'s more evidence to come out among the people near the centre of the court was in the newspapers, at the.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(33,'address','[\"9113 Josiah Meadow Apt. 164\\nRempelview, RI 44375\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(35,'title','[\"Backend Developer\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(36,'description','[\"Mary Ann, and be turned out of a well?\' \'Take some more bread-and-butter--\' \'But what happens when one eats cake, but Alice had learnt several things of this elegant thimble\'; and, when it saw.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(37,'address','[\"6519 Hahn Squares\\nProsaccoview, MI 37491\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(39,'title','[\"DevOps Engineer\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(40,'description','[\"Trims his belt and his buttons, and turns out his toes.\' [later editions continued as follows The Panther took pie-crust, and gravy, and meat, While the Owl had the door and went stamping about, and.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(41,'address','[\"394 Adalberto Crest\\nNew Antonia, CT 23021\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(43,'title','[\"Project Manager\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(44,'description','[\"I beg your pardon!\' said the Hatter: \'it\'s very interesting. I never understood what it was: she was surprised to find that she had gone through that day. \'No, no!\' said the Mouse. \'Of course,\' the.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(45,'address','[\"2512 Mellie Corners\\nKaelynbury, MN 08000\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(47,'title','[\"Frontend Developer\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(48,'description','[\"Alice said very humbly; \'I won\'t have any rules in particular; at least, if there are, nobody attends to them--and you\'ve no idea what to uglify is, you see, so many different sizes in a low, weak.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(49,'address','[\"190 Hyatt Well\\nMarlentown, MN 93919-0172\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:03','2025-06-10 10:48:03'),(51,'title','[\"Fullstack Developer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(52,'description','[\"Alice, as she was exactly one a-piece all round. \'But she must have a trial: For really this morning I\'ve nothing to do.\\\" Said the mouse doesn\'t get out.\\\" Only I don\'t think,\' Alice went on.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(53,'address','[\"1904 Senger Unions Apt. 539\\nWest Tayahaven, PA 54474-6860\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(55,'title','[\"Frontend Developer\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(56,'description','[\"YOU?\' said the King: \'leave out that one of the sort. Next came an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' said the one who had been would have appeared to them she heard it muttering.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(57,'address','[\"99811 Eda Squares Apt. 992\\nWest Alessandro, MA 72912\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(59,'title','[\"System Administrator\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(60,'description','[\"So they sat down, and nobody spoke for some time busily writing in his sleep, \'that \\\"I breathe when I learn music.\' \'Ah! that accounts for it,\' said the cook. \'Treacle,\' said a timid and tremulous.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(61,'address','[\"6614 Clemens Radial Apt. 948\\nNew Isom, DC 49391\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(63,'title','[\"Project Manager\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(64,'description','[\"Lory. Alice replied thoughtfully. \'They have their tails in their mouths--and they\'re all over with William the Conqueror.\' (For, with all speed back to my right size: the next witness.\' And he got.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(65,'address','[\"124 Breanna Fort Suite 948\\nMannmouth, HI 07733-7216\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(67,'title','[\"Frontend Developer\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(68,'description','[\"I don\'t believe there\'s an atom of meaning in it.\' The jury all wrote down all three dates on their faces, so that it might be some sense in your pocket?\' he went on at last, and they can\'t prove I.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(69,'address','[\"7827 Gerhard Plain\\nBlockview, TN 65001\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:04','2025-06-10 10:48:04'),(71,'title','[\"DevOps Engineer\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(72,'description','[\"March Hare had just begun to repeat it, when a sharp hiss made her so savage when they had settled down again, the cook was busily stirring the soup, and seemed to think this a very respectful tone.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(73,'address','[\"480 D\'Amore Inlet Apt. 317\\nSouth Eleazarhaven, ME 69585-6780\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(75,'title','[\"System Administrator\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(76,'description','[\"Alice heard the King replied. Here the Queen put on one knee as he fumbled over the fire, and at once crowded round her, calling out in a tone of great dismay, and began picking them up again with a.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(77,'address','[\"15403 Maryam Village Suite 105\\nLarkinmouth, TN 20628\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(79,'title','[\"Frontend Developer\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(80,'description','[\"She said the Dormouse, without considering at all comfortable, and it set to work throwing everything within her reach at the flowers and the two creatures, who had not the smallest idea how to.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(81,'address','[\"11611 Donald Crossing\\nNew Alyson, NE 78622\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(83,'title','[\"Frontend Developer\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(84,'description','[\"Where CAN I have dropped them, I wonder?\' And here poor Alice in a trembling voice:-- \'I passed by his garden, and I had to double themselves up and rubbed its eyes: then it chuckled. \'What fun!\'.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(85,'address','[\"63034 Gutmann Passage\\nWalkerhaven, CT 59067\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(87,'title','[\"UX\\/UI Designer\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(88,'description','[\"Queen shrieked out. \'Behead that Dormouse! Turn that Dormouse out of the sea.\' \'I couldn\'t afford to learn it.\' said the King. \'Nothing whatever,\' said Alice. \'Anything you like,\' said the Pigeon.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(89,'address','[\"11371 Marcel Roads\\nNathanaelmouth, OH 15145-7411\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(91,'title','[\"Project Manager\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(92,'description','[\"Yet you turned a corner, \'Oh my ears and whiskers, how late it\'s getting!\' She was looking for the baby, it was very deep, or she should chance to be no chance of this, so that her neck kept getting.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(93,'address','[\"63479 Timmothy Hollow\\nJakubowskimouth, IN 65073\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:05','2025-06-10 10:48:05'),(95,'title','[\"System Administrator\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(96,'description','[\"They all made a memorandum of the jury wrote it down \'important,\' and some were birds,) \'I suppose they are the jurors.\' She said it to be found: all she could see, when she looked down at them, and.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(97,'address','[\"293 Gilbert Harbor Suite 949\\nWest Ernestineside, CT 00171\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(99,'title','[\"System Administrator\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(100,'description','[\"Queen. \'Well, I shan\'t grow any more--As it is, I suppose?\' \'Yes,\' said Alice in a hoarse, feeble voice: \'I heard the Rabbit coming to look through into the teapot. \'At any rate a book written about.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(101,'address','[\"446 Melba Overpass Suite 097\\nPort Lizaport, MT 44543-6865\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(103,'title','[\"UX\\/UI Designer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(104,'description','[\"Alice. \'It must have imitated somebody else\'s hand,\' said the Mock Turtle said: \'advance twice, set to work shaking him and punching him in the world she was always ready to talk nonsense. The.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(105,'address','[\"1146 Nickolas Freeway Apt. 703\\nPort Danial, AL 31702-7781\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(107,'title','[\"Product Manager\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(108,'description','[\"Caterpillar called after it; and while she ran, as well to introduce it.\' \'I don\'t know where Dinn may be,\' said the Rabbit say, \'A barrowful will do, to begin with.\' \'A barrowful will do, to begin.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(109,'address','[\"921 Morissette Locks Suite 778\\nSouth Kenna, UT 59997\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(111,'title','[\"Fullstack Developer\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(112,'description','[\"KING AND QUEEN OF HEARTS. Alice was only too glad to find her in an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' And then a row of lamps hanging from the shock of being upset, and their.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(113,'address','[\"86757 Marks Throughway\\nHartmannville, IA 92503-5528\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(115,'title','[\"Quality Assurance\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(116,'description','[\"March.\' As she said to the Queen, and Alice heard the Queen\'s shrill cries to the waving of the jurymen. \'It isn\'t mine,\' said the Dormouse, and repeated her question. \'Why did they draw?\' said.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(117,'address','[\"4987 Bauch Parkway Apt. 533\\nFarrellberg, CA 74296-6613\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:06','2025-06-10 10:48:06'),(119,'title','[\"Frontend Developer\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(120,'description','[\"No room!\' they cried out when they liked, so that it might appear to others that what you mean,\' the March Hare took the hookah out of breath, and said \'No, never\') \'--so you can find it.\' And she.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(121,'address','[\"131 Christiansen Village Apt. 219\\nNorth Hallietown, CO 62619-3513\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(123,'title','[\"UX\\/UI Designer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(124,'description','[\"The first question of course you know the way to fly up into a chrysalis--you will some day, you know--and then after that into a small passage, not much like keeping so close to her, so she began.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(125,'address','[\"40525 Elvie Pass\\nPort Jessyhaven, IL 36874-7675\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(127,'title','[\"UX\\/UI Designer\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(128,'description','[\"Alice said very politely, \'if I had to run back into the sky. Alice went timidly up to her very earnestly, \'Now, Dinah, tell me who YOU are, first.\' \'Why?\' said the others. \'Are their heads.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(129,'address','[\"183 Aileen Garden Suite 991\\nZachariahberg, NM 43447-3989\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:48:07','2025-06-10 10:48:07'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(134,'event_id','[7]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(138,'event_id','[10]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25'),(142,'event_id','[5]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:48:25','2025-06-10 10:48:25');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner subtitle=&quot;12th Technology Forum Conference&quot; button_primary_label=&quot;Register now&quot; subtitle_image=&quot;homepage10/general/logo2.png&quot; background_image=&quot;homepage10/backgrounds/hero-bg.png&quot; style=&quot;9&quot; description=&quot;Explore cutting-edge innovations, network with industry leaders and gain insight.&quot; circle_text=&quot;Build Success Brand .&quot; quantity=&quot;3&quot; image_1=&quot;homepage10/general/hero-img1.webp&quot; image_2=&quot;homepage10/general/hero-img2.webp&quot; image_3=&quot;homepage10/general/hero-img3.webp&quot;][/hero-banner][countdown start_date=&quot;2026-12-12&quot; style=&quot;3&quot; title=&quot;Event Countdown&quot; subtitle=&quot;countdown&quot; primary_button_label=&quot;purchase Ticket Now&quot; primary_button_url=&quot;/&quot;][/countdown][about-us-information style=&quot;4&quot; title=&quot;Explore Future Of Design At Our Yearly Conference&quot; subtitle=&quot;about our Designer conferences&quot; description=&quot;The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design.&quot; button_label=&quot;Reserve premium Seat&quot; button_url=&quot;/events&quot; quantity=&quot;3&quot; title_1=&quot;Our Journalist&quot; figure_1=&quot;250&quot; title_2=&quot;Our Speaker&quot; figure_2=&quot;15&quot; title_3=&quot;Attendees&quot; figure_3=&quot;7000&quot; image=&quot;homepage10/general/about-us-information-1.webp&quot; image_1=&quot;homepage10/general/about-us-information-2.webp&quot; image_2=&quot;homepage10/general/about-us-information-3.webp&quot; image_3=&quot;homepage10/general/about-us-information-4.webp&quot; text_color=&quot;#ffffff&quot;][/about-us-information][featured-block subtitle=&quot;WHY ATTEND&quot; title=&quot;Why You Shouldn&rsquo;t Miss This Event&quot; style=&quot;3&quot; quantity=&quot;4&quot; title_1=&quot;&ldquo;The Technology Forum Summit 2025 will be hosted at the iconic Grand Convention Center.&rdquo;&quot; description_1=&quot;Hear from top industry experts and get exclusive insights into emerging technologies. Participate in workshops that offer real-world applications of today&rsquo;s technology. Connect with peers, investors, and tech pioneers to expand your professional network.&quot; url_1=&quot;/events&quot; icon_image_1=&quot;homepage10/general/feature-img1.webp&quot; title_2=&quot;15 - 17 January&quot; icon_image_2=&quot;homepage10/general/15-date.webp&quot; title_3=&quot;20 Speakers&quot; icon_image_3=&quot;homepage10/icons/user-img.png&quot; title_4=&quot;550 Tickets&quot; icon_image_4=&quot;homepage10/icons/ticket-img.png&quot;][/featured-block][events-schedule title=&quot;Event Location &amp; How to Get There&quot; subtitle=&quot;Event Schedule&quot; number_days=&quot;3&quot; number_each_days=&quot;3&quot; style=&quot;6&quot;][/events-schedule][speakers title=&quot;Meet Our 2025 Speakers&quot; subtitle=&quot;our speakers&quot; limit=&quot;7&quot; style=&quot;9&quot;][/speakers][brands style=&quot;1&quot; title=&quot;Join 4,000+ companies already growing&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot; text_color=&quot;#ffffff&quot;][/brands][contact-information style=&quot;5&quot; address=&quot;Viet Nam&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,'homepage',NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:47:51','2025-06-10 10:47:51');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'KSUDGP4PFP6M','bank_transfer',NULL,325.04,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14',NULL,NULL),(2,'1',0,'NKXLHOHNAVVI','bank_transfer',NULL,81.26,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14',NULL,NULL),(3,'1',0,'AV21CSC41ISY','bank_transfer',NULL,325.04,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14',NULL,NULL),(4,'1',0,'RCYFNMEUQUER','bank_transfer',NULL,325.04,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14',NULL,NULL),(5,'1',0,'ZDMRTV84TU7Q','bank_transfer',NULL,162.52,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14',NULL,NULL),(6,'1',0,'RYVV2X6CY74I','bank_transfer',NULL,325.04,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14',NULL,NULL),(7,'1',0,'4VPNSTWCLLWP','bank_transfer',NULL,325.04,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:14','2025-06-10 10:48:14',NULL,NULL),(8,'1',0,'HG6HHCTKNAKY','bank_transfer',NULL,325.04,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(9,'1',0,'QV9FO2ZHJUQ5','bank_transfer',NULL,162.52,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(10,'1',0,'UFL1TH3PSRWR','bank_transfer',NULL,325.04,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(11,'1',0,'I8JXSV6PTYKI','bank_transfer',NULL,94.00,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(12,'1',0,'353QDJN9SJQV','bank_transfer',NULL,470.00,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(13,'1',0,'G12US5X88A2A','bank_transfer',NULL,282.00,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(14,'1',0,'USKIXRPL1BNX','bank_transfer',NULL,94.00,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(15,'1',0,'CIIIYQ1MIQWA','bank_transfer',NULL,282.00,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(16,'1',0,'SAZQS8IQKERG','bank_transfer',NULL,188.00,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(17,'1',0,'HKKI3OPDECAI','bank_transfer',NULL,94.00,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(18,'1',0,'GJRUSCHEY2ES','bank_transfer',NULL,376.00,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(19,'1',0,'SWG9R4IZTXLM','bank_transfer',NULL,188.00,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(20,'1',0,'Y3TK72QPTTSX','bank_transfer',NULL,188.00,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:15','2025-06-10 10:48:15',NULL,NULL),(21,'1',0,'XTUDZYXTWWIC','bank_transfer',NULL,68.71,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(22,'1',0,'4QCSYY4BCKWG','bank_transfer',NULL,68.71,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(23,'1',0,'UZ9I9DDLTU0I','bank_transfer',NULL,206.13,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(24,'1',0,'AFG4XNFAK3VX','bank_transfer',NULL,343.55,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(25,'1',0,'GXO4QOVYBPXX','bank_transfer',NULL,206.13,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(26,'1',0,'PTGNBNVAMMAA','bank_transfer',NULL,274.84,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(27,'1',0,'S1OEISMIIUJZ','bank_transfer',NULL,274.84,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(28,'1',0,'MHXDOO2VFPNY','bank_transfer',NULL,68.71,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(29,'1',0,'IVADXCD44BRH','bank_transfer',NULL,343.55,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(30,'1',0,'XSFWBXW6T4QG','bank_transfer',NULL,137.42,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(31,'1',0,'SRW97MINBB9T','bank_transfer',NULL,118.72,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(32,'1',0,'NKVHVWGCQJMH','bank_transfer',NULL,29.68,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(33,'1',0,'KFCAOIW2DRCQ','bank_transfer',NULL,29.68,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:16','2025-06-10 10:48:16',NULL,NULL),(34,'1',0,'J3VZAALRPBUH','bank_transfer',NULL,89.04,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(35,'1',0,'UALPM5QCEFMF','bank_transfer',NULL,118.72,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(36,'1',0,'INOOHLVBN88E','bank_transfer',NULL,148.40,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(37,'1',0,'ZHCUOCIEKABV','bank_transfer',NULL,29.68,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(38,'1',0,'O79KEIQFPVM7','bank_transfer',NULL,89.04,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(39,'1',0,'KGE73WLFYCFL','bank_transfer',NULL,148.40,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(40,'1',0,'BEA9Z6X0HJQW','bank_transfer',NULL,148.40,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(41,'1',0,'KAWOE04OOEPY','bank_transfer',NULL,34.67,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(42,'1',0,'ALMYNN64CDVT','bank_transfer',NULL,34.67,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(43,'1',0,'UYWM6EUI5ZIZ','bank_transfer',NULL,138.68,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(44,'1',0,'CPCLTF7FBDJA','bank_transfer',NULL,34.67,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(45,'1',0,'BHVU4E8LCHAY','bank_transfer',NULL,173.35,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(46,'1',0,'4SOJR2RFLCKV','bank_transfer',NULL,173.35,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:17','2025-06-10 10:48:17',NULL,NULL),(47,'1',0,'4VPUWXUN81GM','bank_transfer',NULL,34.67,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18',NULL,NULL),(48,'1',0,'CK8UDVBUYWLU','bank_transfer',NULL,104.01,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18',NULL,NULL),(49,'1',0,'GMEI0JIHGIL6','bank_transfer',NULL,138.68,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18',NULL,NULL),(50,'1',0,'LVT6E2ZIULYF','bank_transfer',NULL,104.01,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:48:18','2025-06-10 10:48:18',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (5,1),(6,1),(4,2),(6,2),(5,3),(2,3),(4,4),(5,4),(2,5),(1,5),(4,6),(4,7),(5,7),(6,8),(5,8),(1,9),(1,10),(2,11),(6,11),(2,12),(1,12),(2,13),(5,13),(2,14),(1,14),(2,15),(6,15),(5,16),(3,16),(5,17),(2,18),(6,19),(2,19),(3,20),(6,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (2,1),(6,1),(4,1),(7,2),(2,2),(5,2),(4,3),(7,3),(6,4),(7,4),(3,5),(1,5),(2,5),(4,6),(5,6),(7,7),(1,7),(6,7),(2,8),(4,8),(2,9),(4,9),(6,9),(5,10),(1,10),(7,10),(5,11),(1,11),(3,11),(2,12),(5,12),(7,12),(4,13),(7,13),(6,14),(1,14),(5,14),(5,15),(4,15),(2,15),(2,16),(4,16),(3,16),(5,17),(2,17),(4,17),(1,18),(7,18),(3,19),(4,19),(3,20),(5,20),(2,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',1370,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',1606,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',943,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',2067,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',1298,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',483,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',1158,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',175,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',2294,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',1132,NULL,'2025-06-10 10:47:57','2025-06-10 10:47:57'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',846,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',1669,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',1509,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',2464,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',1264,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',1673,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',1478,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',2090,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',1272,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/6.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',2486,NULL,'2025-06-10 10:47:58','2025-06-10 10:47:58');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:47:35','2025-06-10 10:47:35');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:48:25'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:48:25'),(6,'language_hide_default','1',NULL,'2025-06-10 10:48:25'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:48:25'),(8,'language_display','all',NULL,'2025-06-10 10:48:25'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:48:25'),(10,'media_random_hash','aba854464ee1e07705b35cc73651f250',NULL,'2025-06-10 10:48:25'),(11,'theme','eventify-homepage10',NULL,'2025-06-10 10:48:25'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:48:25'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:48:25'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:48:25'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:48:25'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:48:25'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:48:25'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:48:25'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:48:25'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:48:25'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:48:25'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:48:25'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:48:25'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:48:25'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:48:25'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:48:25'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:48:25'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:48:25'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:48:25'),(30,'theme-eventify-homepage10-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:48:25'),(31,'theme-eventify-homepage10-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:48:25'),(32,'theme-eventify-homepage10-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:48:25'),(33,'theme-eventify-homepage10-favicon','main/general/favicon.png',NULL,'2025-06-10 10:48:25'),(34,'theme-eventify-homepage10-logo','main/general/logo.png',NULL,'2025-06-10 10:48:25'),(35,'theme-eventify-homepage10-homepage_id','1',NULL,'2025-06-10 10:48:25'),(36,'theme-eventify-homepage10-blog_page_id','4',NULL,'2025-06-10 10:48:25'),(37,'theme-eventify-homepage10-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:48:25'),(38,'theme-eventify-homepage10-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:48:25'),(39,'theme-eventify-homepage10-blog_post_items_per_row','3',NULL,'2025-06-10 10:48:25'),(40,'theme-eventify-homepage10-number_of_related_posts','3',NULL,'2025-06-10 10:48:25'),(41,'theme-eventify-homepage10-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:48:25'),(42,'theme-eventify-homepage10-breadcrumb_text_color','#000000',NULL,'2025-06-10 10:48:25'),(43,'theme-eventify-homepage10-events_page_id','5',NULL,'2025-06-10 10:48:25'),(44,'theme-eventify-homepage10-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:48:25'),(45,'theme-eventify-homepage10-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:48:25'),(46,'theme-eventify-homepage10-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:48:25'),(47,'theme-eventify-homepage10-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:48:25'),(48,'theme-eventify-homepage10-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:48:25'),(49,'theme-eventify-homepage10-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:48:25'),(50,'theme-eventify-homepage10-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:48:25'),(51,'theme-eventify-homepage10-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:48:25'),(52,'theme-eventify-homepage10-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:48:25'),(53,'theme-eventify-homepage10-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:48:25'),(54,'theme-eventify-homepage10-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:48:25'),(55,'theme-eventify-homepage10-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:48:25'),(56,'theme-eventify-homepage10-logo_height','45px',NULL,'2025-06-10 10:48:25'),(57,'theme-eventify-homepage10-is_header_transparent','1',NULL,'2025-06-10 10:48:25'),(58,'theme-eventify-homepage10-display_header_top','0',NULL,'2025-06-10 10:48:25'),(59,'theme-eventify-homepage10-header_top_text_color','#000000',NULL,'2025-06-10 10:48:25'),(60,'theme-eventify-homepage10-header_top_background_color','#FFBA00',NULL,'2025-06-10 10:48:25'),(61,'theme-eventify-homepage10-header_background_color','#000000',NULL,'2025-06-10 10:48:25'),(62,'theme-eventify-homepage10-header_text_color','#ffffff',NULL,'2025-06-10 10:48:25'),(63,'theme-eventify-homepage10-footer_background_color','#212529',NULL,'2025-06-10 10:48:25'),(64,'theme-eventify-homepage10-footer_text_color','#fff',NULL,'2025-06-10 10:48:25'),(65,'theme-eventify-homepage10-footer_heading_color','#fff',NULL,'2025-06-10 10:48:25'),(66,'theme-eventify-homepage10-tp_primary_font','Figtree',NULL,'2025-06-10 10:48:25'),(67,'theme-eventify-homepage10-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:48:25'),(68,'theme-eventify-homepage10-primary_color','#4af8ba',NULL,'2025-06-10 10:48:25'),(69,'theme-eventify-homepage10-secondary_color','#1a1719',NULL,'2025-06-10 10:48:25'),(70,'theme-eventify-homepage10-newsletter_popup_enable','1',NULL,'2025-06-10 10:48:25'),(71,'theme-eventify-homepage10-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:48:25'),(72,'theme-eventify-homepage10-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:48:25'),(73,'theme-eventify-homepage10-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:48:25'),(74,'theme-eventify-homepage10-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:48:25'),(75,'theme-eventify-homepage10-primary_font','Space Grotesk',NULL,'2025-06-10 10:48:25'),(76,'theme-eventify-homepage10-event_location_image','main/icons/location.png',NULL,'2025-06-10 10:48:25'),(77,'theme-eventify-homepage10-breadcrumb_background_color','#4af8ba',NULL,'2025-06-10 10:48:25'),(78,'theme-eventify-homepage10-gradient_color_from','#FF5000',NULL,'2025-06-10 10:48:25'),(79,'theme-eventify-homepage10-gradient_color_to','#FF00B8',NULL,'2025-06-10 10:48:25'),(80,'announcement_max_width','1210',NULL,'2025-06-10 10:48:25'),(81,'announcement_text_color','#000000',NULL,'2025-06-10 10:48:25'),(82,'announcement_background_color','transparent',NULL,'2025-06-10 10:48:25'),(83,'announcement_text_alignment','start',NULL,'2025-06-10 10:48:25'),(84,'announcement_dismissible','0',NULL,'2025-06-10 10:48:25'),(85,'announcement_font_size','14',NULL,'2025-06-10 10:48:25'),(86,'announcement_font_size_unit','px',NULL,'2025-06-10 10:48:25'),(87,'announcement_placement','theme',NULL,'2025-06-10 10:48:25'),(88,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:48:25','2025-06-10 10:48:25'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:48:25','2025-06-10 10:48:25'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:48:25','2025-06-10 10:48:25');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:48:25','2025-06-10 10:48:25');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:34','2025-06-10 10:47:34'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:34','2025-06-10 10:47:34'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:47:35','2025-06-10 10:47:35'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:47:51','2025-06-10 10:47:51'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:47:57','2025-06-10 10:47:57'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:47:57','2025-06-10 10:47:57'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:47:57','2025-06-10 10:47:57'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:47:57','2025-06-10 10:47:57'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:47:57','2025-06-10 10:47:57'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:47:57','2025-06-10 10:47:57'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:47:57','2025-06-10 10:47:57'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:57','2025-06-10 10:47:57'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:47:58','2025-06-10 10:47:58'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:02','2025-06-10 10:48:02'),(59,'dr-christine-kautzer-sr',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:02','2025-06-10 10:48:02'),(60,'orie-cartwright-jr',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:03','2025-06-10 10:48:03'),(61,'prof-rebeca-fisher',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:03','2025-06-10 10:48:03'),(62,'prof-frederic-farrell',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:03','2025-06-10 10:48:03'),(63,'orpha-ziemann',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:03','2025-06-10 10:48:03'),(64,'lesley-beer',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:04','2025-06-10 10:48:04'),(65,'kelsie-strosin',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:04','2025-06-10 10:48:04'),(66,'leanne-anderson-phd',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:04','2025-06-10 10:48:04'),(67,'dr-modesta-tromp',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:04','2025-06-10 10:48:04'),(68,'greta-toy',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:04','2025-06-10 10:48:04'),(69,'ella-kilback-dds',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:05','2025-06-10 10:48:05'),(70,'prof-brock-lehner-iv',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:05','2025-06-10 10:48:05'),(71,'marlee-jenkins-dds',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:06','2025-06-10 10:48:06'),(72,'prof-jamar-deckow',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:06','2025-06-10 10:48:06'),(73,'miss-nikki-dubuque',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:06','2025-06-10 10:48:06'),(74,'alize-stark',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:06','2025-06-10 10:48:06'),(75,'allan-conroy',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:07','2025-06-10 10:48:07'),(76,'candace-bashirian',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:07','2025-06-10 10:48:07'),(77,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(78,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(79,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(80,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(81,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(82,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(83,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(84,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(85,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(86,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:48:14','2025-06-10 10:48:14'),(87,'carmela-mante',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(88,'joanne-cormier',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(89,'adele-klocko',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(90,'dr-pansy-schimmel',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(91,'mrs-jade-jerde',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(92,'ms-carissa-gutmann',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(93,'prof-garrett-dooley-v',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(94,'dwight-rath',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(95,'prof-alexzander-greenfelder-jr',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(96,'shea-vandervort',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(97,'caroline-okeefe',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(98,'dr-chet-feil',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(99,'felicia-becker',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(100,'leopold-cole',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(101,'dr-tessie-heller-jr',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(102,'abdul-hamill',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(103,'laury-erdman',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(104,'peyton-borer-dds',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(105,'nicolas-hoeger',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(106,'cindy-macejkovic',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(107,'wyatt-kulas',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(108,'mr-trace-williamson',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(109,'austyn-hermiston',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(110,'melyssa-boehm',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(111,'rhoda-ankunding',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(112,'mrs-domenica-ruecker',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(113,'misty-hermann',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(114,'cooper-douglas',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(115,'dr-maude-frami-md',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(116,'sarah-schuster',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(117,'treva-wyman-jr',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(118,'carolina-gusikowski',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(119,'prof-oda-morissette',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(120,'daphnee-schaden',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(121,'mr-judah-wolff',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(122,'jamil-altenwerth-ii',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(123,'susana-barton',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(124,'adriana-ratke',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(125,'andreane-halvorson',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(126,'lucious-braun',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(127,'brannon-kuvalis-sr',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(128,'larue-kessler',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(129,'sammie-hagenes',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(130,'mr-edward-bins',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(131,'drew-gibson-dds',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(132,'madge-lebsack',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(133,'timothy-mraz',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(134,'syble-oconner',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(135,'lloyd-beatty-dds',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(136,'ms-rachelle-lubowitz-ii',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(137,'troy-hoppe',70,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25'),(138,'westley-pollich',71,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:48:25','2025-06-10 10:48:25');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:48:07','2025-06-10 10:48:07');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:47:57','2025-06-10 10:47:57'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:47:57','2025-06-10 10:47:57'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:47:57','2025-06-10 10:47:57'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:47:57','2025-06-10 10:47:57'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:47:57','2025-06-10 10:47:57'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:47:57','2025-06-10 10:47:57'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:47:57','2025-06-10 10:47:57');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:47:36','2025-06-10 10:47:36'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:47:36','2025-06-10 10:47:36'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:47:36','2025-06-10 10:47:36'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:47:36','2025-06-10 10:47:36');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'brad41@bernier.com',NULL,'$2y$12$NPyNHCsV3x3ev5oLIIUtuO4Mn.e1B9UM1PhMPUcCUXdMGhge.bOZS',NULL,'2025-06-10 10:47:35','2025-06-10 10:47:35','Dane','Metz','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage10',1,'[]','2025-06-10 10:47:51','2025-06-10 10:47:51'),(2,'SocialLinksWidget','header_sidebar','eventify-homepage10',2,'[]','2025-06-10 10:47:51','2025-06-10 10:47:51'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage10',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo.png\"}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage10',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage10',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage10',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(7,'EventListWidget','event_list_sidebar','eventify-homepage10',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage10',1,'[]','2025-06-10 10:47:51','2025-06-10 10:47:51'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage10',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage10',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage10',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage10',1,'{\"background_color\":\"#4af8ba\",\"button_label\":\"Buy Ticket\"}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage10',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:47:51','2025-06-10 10:47:51'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage10',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:47:51','2025-06-10 10:47:51');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:48:26
