<?php

namespace Database\Seeders\Themes\Homepage03;

use Botble\Page\Models\Page;
use Botble\Shortcode\Facades\Shortcode;
use Database\Seeders\Themes\Main\PageSeeder as BasePageSeeder;

class PageSeeder extends BasePageSeeder
{
    public function run(): void
    {
        parent::run();

        $this->uploadFiles('general', 'homepage03');
        $this->uploadFiles('backgrounds', 'homepage03');

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => htmlentities(
                Shortcode::generateShortcode('hero-banner', [
                    'subtitle' => 'Join the the Future of Design',
                    'title' => 'Yearly designer <br> Conferences ‘25',
                    'button_primary_label' => 'Reserve premium Seat',
                    'button_primary_url' => '/',
                    'background_image' => $this->filePath('backgrounds/header-bg.webp', 'homepage03'),
                    'style' => '2',
                    'circle_text' => 'Build Success Brand .',
                ]) .
                Shortcode::generateShortcode('about-us-information', [
                    'style' => '4',
                    'title' => 'Explore Future Of Design At Our Yearly Conference',
                    'subtitle' => 'about our Designer conferences',
                    'description' => 'The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design.',
                    'button_label' => 'Reserve premium Seat',
                    'button_url' => '/events',
                    'quantity' => '3',
                    'title_1' => 'Our Journalist',
                    'figure_1' => '250',
                    'title_2' => 'Our Speaker',
                    'figure_2' => '15',
                    'title_3' => 'Attendees',
                    'figure_3' => '7000',
                    'image' => $this->filePath('general/about-us-information-1.webp', 'homepage03'),
                    'image_1' => $this->filePath('general/about-us-information-2.webp', 'homepage03'),
                    'image_2' => $this->filePath('general/about-us-information-3.webp', 'homepage03'),
                    'image_3' => $this->filePath('general/about-us-information-4.webp', 'homepage03'),
                ]) .
                Shortcode::generateShortcode('brands', [
                    'style' => '1',
                    'subtitle' => 'general sponsors',
                    'title' => 'Our Official Sponsors',
                    'quantity' => 8,
                    'alt_1' => 'Boltshift',
                    'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                    'link_1' => 'https://paulmbingu.com/boltshiftui',
                    'alt_2' => 'Lightbox',
                    'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                    'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                    'alt_3' => 'GlobalBank',
                    'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                    'link_3' => 'https://www.globalbank.com.pa/',
                    'alt_4' => 'FeatherDev',
                    'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                    'link_4' => 'https://featherdev.com/',
                    'alt_5' => 'Acme Corp',
                    'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                    'link_5' => 'https://www.acmecorp.com/',
                    'alt_6' => 'Polymath',
                    'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                    'link_6' => 'https://polymath.network/',
                    'alt_7' => 'Nietzche',
                    'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                    'link_7' => 'https://redsvn.net/',
                    'alt_8' => 'Epicurious',
                    'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                    'link_8' => 'https://www.epicurious.com',
                    'text_color' => '#000000',
                    'background_color' => '#F5F5F5',
                ]) .
                Shortcode::generateShortcode('speakers', [
                    'style' => '3',
                    'title' => 'Our Event Speakers',
                    'subtitle' => 'our 10+ event speakers',
                    'limit' => '8',
                    'text_color' => 'rgb(0, 0, 0)',
                ]) .
                Shortcode::generateShortcode('countdown', [
                    'start_date' => '2025-12-31',
                    'background_image' => $this->filePath('backgrounds/header-bg4.png', 'main'),
                ]) .
                Shortcode::generateShortcode('events-schedule', [
                    'title' => 'Our Events Schedule Plan',
                    'subtitle' => 'Event Schedule',
                    'number_days' => 5,
                    'style' => '2',
                ]) .
                Shortcode::generateShortcode('contact-information', [
                    'address' => 'Ho Chi Minh City, Viet Nam',
                    'title' => 'Direction To The Venue',
                    'subtitle' => 'How to reach',
                    'image' => $this->filePath('general/contact-img-2.png', 'main'),
                    'background_image' => $this->filePath('backgrounds/contact-information-bg.png', 'homepage03'),
                    'icon_bg_image' => $this->filePath('backgrounds/contact-information-icon-bg.png', 'homepage03'),
                    'quantity' => '4',
                    'title_1' => 'Our Email',
                    'description_1' => 'eventify@gmail.com',
                    'url_1' => 'maito:eventify@gmail.com',
                    'icon_image_1' => $this->filePath('icons/mail-icon.png', 'main'),
                    'title_2' => 'our location',
                    'description_2' => 'Viet Nam',
                    'url_2' => '/contact-us',
                    'icon_image_2' => $this->filePath('icons/location-icon.png', 'main'),
                    'title_3' => 'Call/Message',
                    'description_3' => '+11234567890',
                    'url_3' => 'tel:+11234567890',
                    'icon_image_3' => $this->filePath('icons/phone-icon.png', 'main'),
                    'title_4' => 'Instagram',
                    'description_4' => '@eventify',
                    'url_4' => '/contact-us',
                    'icon_image_4' => $this->filePath('icons/instagram-icon.png', 'main'),
                ]) .
                Shortcode::generateShortcode('events', [
                    'title' => 'Recent Memories 2024',
                    'subtitle' => 'Last year memory',
                    'limit' => '5',
                    'logo' => $this->filePath('general/logo-yellow.png', 'main'),
                ])
            ),
        ]);

        $speaker = Page::query()->where('name', 'Speakers')->firstOrFail();

        $speaker->update([
            'content' => htmlentities(
                Shortcode::generateShortcode('speakers', [
                    'limit' => 8,
                ])
            ),
        ]);

        $this->createMetadata($speaker, [
            'metadata' => [
                'breadcrumb_background_image' => '',
                'breadcrumb_text_color' => '',
            ],
        ]);

        $aboutUs = Page::query()->where('name', 'About Us')->firstOrFail();

        $aboutUs->update([
            'content' => Shortcode::generateShortcode('about-us-information', [
                    'style' => '4',
                    'title' => 'Explore Future Of Design At Our Yearly Conference',
                    'subtitle' => 'about our Designer conferences',
                    'description' => 'The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design.',
                    'button_label' => 'Reserve premium Seat',
                    'button_url' => '/events',
                    'quantity' => '3',
                    'title_1' => 'Our Journalist',
                    'figure_1' => '250',
                    'title_2' => 'Our Speaker',
                    'figure_2' => '15',
                    'title_3' => 'Attendees',
                    'figure_3' => '7000',
                    'image' => $this->filePath('general/about-us-information-1.webp', 'homepage03'),
                    'image_1' => $this->filePath('general/about-us-information-2.webp', 'homepage03'),
                    'image_2' => $this->filePath('general/about-us-information-3.webp', 'homepage03'),
                    'image_3' => $this->filePath('general/about-us-information-4.webp', 'homepage03'),
                ]) . Shortcode::generateShortcode(
                    'brands',
                    [
                        'style' => '1',
                        'title' => 'Join 4,000+ companies already growing',
                        'quantity' => 8,
                        'alt_1' => 'Boltshift',
                        'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                        'link_1' => 'https://paulmbingu.com/boltshiftui',
                        'alt_2' => 'Lightbox',
                        'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                        'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                        'alt_3' => 'GlobalBank',
                        'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                        'link_3' => 'https://www.globalbank.com.pa/',
                        'alt_4' => 'FeatherDev',
                        'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                        'link_4' => 'https://featherdev.com/',
                        'alt_5' => 'Acme Corp',
                        'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                        'link_5' => 'https://www.acmecorp.com/',
                        'alt_6' => 'Polymath',
                        'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                        'link_6' => 'https://polymath.network/',
                        'alt_7' => 'Nietzche',
                        'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                        'link_7' => 'https://redsvn.net/',
                        'alt_8' => 'Epicurious',
                        'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                        'link_8' => 'https://www.epicurious.com',
                    ]
                ) . Shortcode::generateShortcode(
                    'featured-block',
                    [
                        'subtitle' => 'why choose us',
                        'title' => 'Why Attend Event?',
                        'quantity' => 6,
                        'title_1' => 'Make Ideas Happen',
                        'description_1' => 'Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.',
                        'url_1' => '/events',
                        'icon_image_1' => $this->filePath('icons/idea.png', 'main'),
                        'title_2' => 'Great Speakers',
                        'description_2' => 'Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.',
                        'url_2' => '/events',
                        'icon_image_2' => $this->filePath('icons/speaker.png', 'main'),
                        'title_3' => 'One Day Ticket',
                        'description_3' => 'We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.',
                        'url_3' => '/events',
                        'icon_image_3' => $this->filePath('icons/ticket.png', 'main'),
                        'title_4' => 'Develop Your Skills',
                        'description_4' => 'Eventify is your gateway to future of business. By bringing together best experts from various sectors.',
                        'url_4' => '/events',
                        'icon_image_4' => $this->filePath('icons/coding.png', 'main'),
                        'title_5' => 'Entry Verification',
                        'description_5' => 'You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.',
                        'url_5' => '/events',
                        'icon_image_5' => $this->filePath('icons/search.png', 'main'),
                        'title_6' => 'Workshops Offer',
                        'description_6' => 'Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.',
                        'url_6' => '/events',
                        'icon_image_6' => $this->filePath('icons/workshop.png', 'main'),
                    ]
                ),
        ]);

        $pricing = Page::query()->where('name', 'Pricing Plan')->firstOrFail();

        $pricing->update([
            'content' => Shortcode::generateShortcode('pricing', [
                'title' => 'Event Pass & Tickets',
                'subtitle' => 'Ticket Pricing',
                'quantity' => 3,
                'name_1' => 'Basic Packages',
                'price_1' => '$29',
                'unit_1' => 'One Person',
                'features_1' => '+ Regular Seating \n + Comfortable Sleeping \n + Afternoon Snacks \n + Afternoon Entrance \n + Idea sharing',
                'button_url_1' => '/contact-us',
                'button_label_1' => 'Buy A Ticket',
                'name_2' => 'Standard Packages',
                'price_2' => '$49',
                'unit_2' => 'One Person',
                'features_2' => '+ Venue rental \n + Premium seating and tables \n + Full event planning service \n + Entertainment services \n + Luxury transportation',
                'button_url_2' => '/contact-us',
                'button_label_2' => 'Buy A Ticket',
                'name_3' => 'Premium Packages',
                'price_3' => '$69',
                'unit_3' => 'One Person',
                'features_3' => '+ Customized decor \n + Top-tier catering \n + Top-shelf beverage package \n + Full event production \n + Luxury accommodations',
                'button_url_3' => '/contact-us',
                'button_label_3' => 'Buy A Ticket',
                'background_image_name' => $this->filePath('backgrounds/contact-information-bg.png', 'homepage03'),
            ]),
        ]);

        $contact = Page::query()->where('name', 'Contact Us')->firstOrFail();

        $contact->update([
            'content' => htmlentities(
                Shortcode::generateShortcode('contact-form', [
                    'title' => 'Get In Touch Now',
                    'display_fields' => 'phone,email,subject,address',
                    'mandatory_fields' => 'email',
                    'image' => $this->filePath('general/contact-img-1.png', 'main'),
                ]) .
                Shortcode::generateShortcode('contact-information', [
                    'address' => 'Ho Chi Minh City, Viet Nam',
                    'title' => 'Direction To The Venue',
                    'subtitle' => 'How to reach',
                    'image' => $this->filePath('general/contact-img-2.png', 'main'),
                    'background_image' => $this->filePath('backgrounds/contact-information-bg.png', 'homepage03'),
                    'icon_bg_image' => $this->filePath('backgrounds/contact-information-icon-bg.png', 'homepage03'),
                    'quantity' => '4',
                    'title_1' => 'Our Email',
                    'description_1' => 'eventify@gmail.com',
                    'url_1' => 'maito:eventify@gmail.com',
                    'icon_image_1' => $this->filePath('icons/mail-icon.png', 'main'),
                    'title_2' => 'our location',
                    'description_2' => 'Viet Nam',
                    'url_2' => '/contact-us',
                    'icon_image_2' => $this->filePath('icons/location-icon.png', 'main'),
                    'title_3' => 'Call/Message',
                    'description_3' => '+11234567890',
                    'url_3' => 'tel:+11234567890',
                    'icon_image_3' => $this->filePath('icons/phone-icon.png', 'main'),
                    'title_4' => 'Instagram',
                    'description_4' => '@eventify',
                    'url_4' => '/contact-us',
                    'icon_image_4' => $this->filePath('icons/instagram-icon.png', 'main'),
                ])
            ),
        ]);
    }
}
