<?php

namespace Database\Seeders\Themes\Homepage03;

use Database\Seeders\Themes\Main\ThemeOptionSeeder as MainThemeOptionSeeder;

class ThemeOptionSeeder extends MainThemeOptionSeeder
{
    public function getData(): array
    {
        return [
            ...parent::getData(),
            'primary_color' => '#FF3639',
            'secondary_color' => '#1A1719',
            'logo' => $this->filePath('general/logo.png', 'homepage03'),
            'header_background_color' => '#ffffff',
            'header_text_color' => '#000000',
            'is_header_transparent' => true,
            'display_header_top' => true,
            'footer_background_color' => '#131E20',
            'footer_text_color' => '#ffffff',
            'footer_heading_color' => '#ffffff',
            'breadcrumb_text_color' => '#ffffff',
            'breadcrumb_background_color' => '#FF3639',
            'breadcrumb_background_image' => $this->filePath('backgrounds/contact-information-bg.png', 'homepage03'),
            'gradient_color_from' => '#FF5000',
            'gradient_color_to' => '#FF00B8',
            'header_top_background_color' => '#FFFFFF',
        ];
    }
}
