<?php

namespace Database\Seeders\Themes\Homepage04;

use Database\Seeders\Themes\Main\ThemeOptionSeeder as MainThemeOptionSeeder;

class ThemeOptionSeeder extends MainThemeOptionSeeder
{
    public function getData(): array
    {
        return [
            ...parent::getData(),
            'primary_color' => '#2e4dfd',
            'secondary_color' => '#002466',
            'primary_font' => 'Space Grotesk',
            'logo' => $this->filePath('general/logo.png', 'homepage04'),
            'event_location_image' => $this->filePath('icons/location.png', 'homepage04'),
            'logo_height' => '45px',
            'header_background_color' => '#F8F7F3',
            'header_top_background_color' => '#ffffff',
            'header_text_color' => '#002466',
            'is_header_transparent' => true,
            'display_header_top' => true,
            'footer_background_color' => '#F8F7F3',
            'footer_text_color' => '#363D4A',
            'footer_heading_color' => '#002466',
            'breadcrumb_text_color' => '#ffffff',
            'breadcrumb_background_color' => '#2e4dfd',
            'gradient_color_from' => '#FF5000',
            'gradient_color_to' => '#FF00B8',

        ];
    }
}
