<?php

namespace Database\Seeders\Themes\Homepage05;

use Database\Seeders\Themes\Main\ThemeOptionSeeder as MainThemeOptionSeeder;

class ThemeOptionSeeder extends MainThemeOptionSeeder
{
    public function getData(): array
    {
        $this->uploadFiles('backgrounds', 'homepage05');

        return [
            ...parent::getData(),
            'gradient_color_from' => '#FF7A00',
            'gradient_color_to' => '#F00',
            'display_header_top' => false,
            'body_background_image' => $this->filePath('backgrounds/body-bg.webp', 'homepage05'),
            'footer_background_image' => null,
            'footer_background_color' => '#5177FA',
            'footer_text_color' => '#ffffff',
            'footer_heading_color' => '#ffffff',
            'primary_color' => '#ff7a00',
        ];
    }
}
