<?php

namespace Database\Seeders\Themes\Homepage07;

use Botble\Page\Models\Page;

class PageSeeder extends \Database\Seeders\Themes\Main\PageSeeder
{
    public function run(): void
    {
        $this->uploadFiles('general', 'homepage07');
        $this->uploadFiles('backgrounds', 'homepage07');

        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => $this->generateShortcodeContent([
                [
                    'name' => 'hero-banner',
                    'attributes' => [
                        'style' => '6',
                        'title' => ' Digital World <br> Conference',
                        'description' => 'From cutting-edge technology and digital transformation to leadership strategies and sustainable growth, Innovate 2024 provide.',
                        'circle_text' => 'Build Success Brand .',
                        'image' => $this->filePath('general/hero-banner-img-1.webp', 'homepage07'),
                        'image_1' => $this->filePath('general/hero-banner-img-2.webp', 'homepage07'),
                        'button_primary_label' => 'Reserve My Seat ',
                        'button_primary_url' => '/',
                        'background_image' => $this->filePath('backgrounds/hero-banner-bg.webp', 'homepage07'),
                    ],
                ],
                [
                    'name' => 'about-us-information',
                    'attributes' => [
                        'style' => '7',
                        'title' => 'Transforming the of Global <br> Economic Landscape',
                        'circle_text' => 'Build Success Brand .',
                        'description' => 'Our mission at Economy Event to drive meaningful dialogue, foster collaboration, spark innovative solutions for sustainable economic.',
                        'button_label' => 'Become an Attendee ',
                        'button_url' => '/',
                        'quantity' => '2',
                        'title_1' => 'ECollaborating for Economic Impact',
                        'description_1' => 'This event brings together economists business leaders policymakers, and innovators from around the globe.',
                        'url_1' => '/',
                        'icon_1' => 'ti ti-microphone-2',
                        'title_2' => 'Where Ideas Shape the Economy',
                        'description_2' => 'With a focus on topics such as global trade, financial technology, sustainable development, and policy.',
                        'url_2' => '/',
                        'icon_2' => 'ti ti-bubble-text',
                        'image' => $this->filePath('general/about-us-information-img-1.webp', 'homepage07'),
                        'image_1' => $this->filePath('general/about-us-information-img-2.webp', 'homepage07'),
                        'shape_image' => $this->filePath('general/about-us-information-shape-img.webp', 'homepage07'),
                    ],
                ],
                [
                    'name' => 'locations',
                    'attributes' => [
                        'title' => 'Explore Our 4 Venues',
                        'quantity' => '4',
                        'name_1' => 'Marine City Michigan',
                        'subtitle_1' => 'Venue 01',
                        'address_1' => 'New York, USA',
                        'image_1' => $this->filePath('general/location-1.webp', 'homepage07'),
                        'button_label_1' => 'Virtual Tour ',
                        'button_url_1' => '/contact-us',
                        'name_2' => 'Kansas City Omaha',
                        'subtitle_2' => 'Venue 02',
                        'address_2' => 'New York, USA',
                        'image_2' => $this->filePath('general/location-2.webp', 'homepage07'),
                        'button_label_2' => 'Virtual Tour ',
                        'button_url_2' => '/contact-us',
                        'name_3' => 'New Hampshire City',
                        'subtitle_3' => 'Venue 03',
                        'address_3' => 'New York, USA',
                        'image_3' => $this->filePath('general/location-3.webp', 'homepage07'),
                        'button_label_3' => 'Virtual Tour ',
                        'button_url_3' => '/contact-us',
                        'name_4' => 'Marine City Michigan',
                        'subtitle_4' => 'Venue 04',
                        'address_4' => 'New York, USA',
                        'image_4' => $this->filePath('general/location-4.webp', 'homepage07'),
                        'button_label_4' => 'Virtual Tour ',
                        'button_url_4' => '/contact-us',
                        'text_color' => 'rgb(0, 0, 0)',
                        'background_color' => 'rgb(255, 243, 246)',
                    ],
                ],
                [
                    'name' => 'speakers',
                    'attributes' => [
                        'style' => '7',
                        'title' => 'Our Esteemed Speakers',
                        'limit' => '8',
                    ],
                ],
                [
                    'name' => 'events-schedule',
                    'attributes' => [
                        'style' => '4',
                        'title' => 'Our Events Schedule Plan',
                        'number_days' => '5',
                        'number_each_days' => '4',
                        'text_color' => 'rgb(255, 255, 255)',
                        'background_color' => 'rgb(0, 0, 0)',
                    ],
                ],
                [
                    'name' => 'testimonials',
                    'attributes' => [
                        'style' => '4',
                        'title' => 'In Their Words Feedback <br> That Drives Change',
                        'testimonial_ids' => '1,2,3,4',
                    ],
                ],
                [
                    'name' => 'brands',
                    'attributes' => [
                        'style' => '2',
                        'subtitle' => 'PARTNERS',
                        'title' => 'Our Valued Sponsors & Partners',
                        'quantity' => 8,
                        'alt_1' => 'Boltshift',
                        'image_1' => $this->filePath('brands/brand-img1.png'),
                        'link_1' => 'https://paulmbingu.com/boltshiftui',
                        'alt_2' => 'Lightbox',
                        'image_2' => $this->filePath('brands/brand-img2.png'),
                        'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                        'alt_3' => 'GlobalBank',
                        'image_3' => $this->filePath('brands/brand-img3.png'),
                        'link_3' => 'https://www.globalbank.com.pa/',
                        'alt_4' => 'FeatherDev',
                        'image_4' => $this->filePath('brands/brand-img4.png'),
                        'link_4' => 'https://featherdev.com/',
                        'alt_5' => 'Acme Corp',
                        'image_5' => $this->filePath('brands/brand-img5.png'),
                        'link_5' => 'https://www.acmecorp.com/',
                        'alt_6' => 'Polymath',
                        'image_6' => $this->filePath('brands/brand-img6.png'),
                        'link_6' => 'https://polymath.network/',
                        'alt_7' => 'Nietzche',
                        'image_7' => $this->filePath('brands/brand-img7.png'),
                        'link_7' => 'https://redsvn.net/',
                        'alt_8' => 'Epicurious',
                        'image_8' => $this->filePath('brands/brand-img8.png'),
                        'link_8' => 'https://www.epicurious.com',
                        'text_color' => '#000000',
                        'background_color' => '#FFF3F6',
                    ],
                ],
                [
                    'name' => 'blog-posts',
                    'attributes' => [
                        'style' => '3',
                        'category_ids' => '1,2,3,4',
                        'limit' => '3',
                        'title' => 'Leadership in Strategies <br> For Economic Growth',
                        'type' => 'latest',
                    ],
                ],
            ]),
        ]);
    }
}
