<?php

namespace Database\Seeders\Themes\Homepage07;

use ActionBlockWidget;
use Botble\Widget\Models\Widget;

class WidgetSeeder extends \Database\Seeders\Themes\Main\WidgetSeeder
{
    public function run(): void
    {
        Widget::query()->truncate();

        $this->createWidgets($this->getData());
    }

    public function getDataPreFooterSidebar(): array
    {
        return [
            [
                'widget_id' => ActionBlockWidget::class,
                'sidebar_id' => 'pre_footer_sidebar',
                'position' => 1,
                'data' => [
                    'title' => 'Are you want to join our events?',
                    'description' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.',
                    'button_label' => 'Register Now',
                    'button_url' => '/register',
                    'background_image' => $this->filePath('backgrounds/hero-banner-bg.webp', 'homepage07'),
                ],
            ],
        ];
    }
}
