<?php

namespace Database\Seeders\Themes\Homepage08;

use ArchiElite\EventsBooking\Models\Account;
use Database\Seeders\Themes\Main\AccountSeeder as MainAccountSeeder;

class AccountSeeder extends MainAccountSeeder
{
    public function run(): void
    {
        $this->uploadFiles('speakers', 'homepage08');

        parent::run();
    }

    public function updateAvatar(Account $account): void
    {
        $account->update([
            'avatar' => $this->filePath('speakers/' . rand(1, 5) . '.png', 'homepage08'),
        ]);
    }
}
