<?php

namespace Database\Seeders\Themes\Homepage09;

use Botble\Page\Models\Page;

class PageSeeder extends \Database\Seeders\Themes\Main\PageSeeder
{
    public function run(): void
    {
        $this->uploadFiles('general', 'homepage09');
        $this->uploadFiles('backgrounds', 'homepage09');

        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => $this->generateShortcodeContent([
                [
                    'name' => 'hero-banner',
                    'attributes' => [
                        'style' => '8',
                        'title' => 'World Music <br> Events 2025',
                        'subtitle' => 'WE ARE COMING FOR',
                        'image' => $this->filePath('general/hero-banner-img.webp', 'homepage09'),
                        'button_primary_label' => 'Buy Tickets Now!',
                        'button_primary_url' => '/events',
                        'button_secondary_url' => '/events',
                        'button_secondary_label' => 'Schedule',
                        'background_image' => $this->filePath('backgrounds/hero-banner-bg.webp', 'homepage09'),
                    ],
                ],
                [
                    'name' => 'speakers',
                    'attributes' => [
                        'style' => '8',
                        'title' => 'Extraordinary Artists',
                        'subtitle' => '15+ Event Speakers',
                        'limit' => '8',
                        'text_color' => 'rgb(0, 0, 0)',
                    ],
                ],
                [
                    'name' => 'events-schedule',
                    'attributes' => [
                        'title' => 'Our Events Schedule Plan',
                        'subtitle' => 'Event Schedule',
                        'number_days' => 5,
                        'style' => 2,
                        'background_color' => '#F7F5FB',
                    ],
                ],
                [
                    'name' => 'pricing',
                    'attributes' => [
                        'style' => 4,
                        'title' => 'Event Passes and Pricing',
                        'subtitle' => 'our event Pricing Plan',
                        'quantity' => 3,
                        'name_1' => 'One Day Festival Pass',
                        'price_1' => '$49.89',
                        'unit_1' => 'Day',
                        'description_1' => 'Free 7 day trial, No credit card required, Cancel Anytime',
                        'features_1' => '+ Ticket for one day \n + Chance to win door prize  \n - Free-official merchandise \n - Free artist photo + signature \n - Hotel Voucher',
                        'button_url_1' => '/contact-us',
                        'button_label_1' => 'Buy Ticket Now',
                        'name_2' => 'Full Festival Pass',
                        'price_2' => '$69.89',
                        'unit_2' => 'Day',
                        'description_2' => 'Free 7 day trial, No credit card required, Cancel Anytime',
                        'features_2' => '+ Ticket for one day \n + Chance to win door prize  \n + Free-official merchandise \n - Free artist photo & signature \n - Hotel Voucher',
                        'button_url_2' => '/contact-us',
                        'button_label_2' => 'Buy Ticket Now',
                        'is_featured_2' => 'yes',
                        'name_3' => 'Couple Pass',
                        'price_3' => '$89.89',
                        'unit_3' => 'Day',
                        'description_3' => 'Free 7 day trial, No credit card required, Cancel Anytime',
                        'features_3' => '+ Ticket for one day \n + Chance to win door prize  \n + Free-official merchandise \n + Free artist photo & signature \n + Hotel Voucher',
                        'button_url_3' => '/contact-us',
                        'button_label_3' => 'Buy Ticket Now',
                    ],
                ],
                [
                    'name' => 'google-map',
                    'content' => 'New York, USA',
                ],
                [
                    'name' => 'brands',
                    'attributes' => [
                        'style' => 2,
                        'text_color' => '#000000',
                        'subtitle' => 'general sponsors',
                        'title' => 'Our Official Sponsors',
                        'quantity' => 8,
                        'alt_1' => 'Boltshift',
                        'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                        'link_1' => 'https://paulmbingu.com/boltshiftui',
                        'alt_2' => 'Lightbox',
                        'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                        'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                        'alt_3' => 'GlobalBank',
                        'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                        'link_3' => 'https://www.globalbank.com.pa/',
                        'alt_4' => 'FeatherDev',
                        'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                        'link_4' => 'https://featherdev.com/',
                        'alt_5' => 'Acme Corp',
                        'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                        'link_5' => 'https://www.acmecorp.com/',
                        'alt_6' => 'Polymath',
                        'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                        'link_6' => 'https://polymath.network/',
                        'alt_7' => 'Nietzche',
                        'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                        'link_7' => 'https://redsvn.net/',
                        'alt_8' => 'Epicurious',
                        'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                        'link_8' => 'https://www.epicurious.com',
                    ],
                ],
            ]),
        ]);
    }
}
