<?php

namespace Database\Seeders\Themes\Homepage10;

use Botble\Page\Models\Page;
use Botble\Shortcode\Facades\Shortcode;
use Database\Seeders\Themes\Main\PageSeeder as BasePageSeeder;

class PageSeeder extends BasePageSeeder
{
    public function run(): void
    {
        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => htmlentities(
                Shortcode::generateShortcode('hero-banner', [
                    'subtitle' => '12th Technology Forum Conference',
                    'button_primary_label' => 'Register now',
                    'subtitle_image' => $this->filePath('general/logo2.png', 'homepage10'),
                    'background_image' => $this->filePath('backgrounds/hero-bg.png', 'homepage10'),
                    'style' => '9',
                    'description' => 'Explore cutting-edge innovations, network with industry leaders and gain insight.',
                    'circle_text' => 'Build Success Brand .',
                    'quantity' => '3',
                    'image_1' => $this->filePath('general/hero-img1.webp', 'homepage10'),
                    'image_2' => $this->filePath('general/hero-img2.webp', 'homepage10'),
                    'image_3' => $this->filePath('general/hero-img3.webp', 'homepage10'),
                ])
                . Shortcode::generateShortcode('countdown', [
                    'start_date' => '2026-12-12',
                    'style' => '3',
                    'title' => 'Event Countdown',
                    'subtitle' => 'countdown',
                    'primary_button_label' => 'purchase Ticket Now',
                    'primary_button_url' => '/',
                ])
                . Shortcode::generateShortcode('about-us-information', [
                    'style' => '4',
                    'title' => 'Explore Future Of Design At Our Yearly Conference',
                    'subtitle' => 'about our Designer conferences',
                    'description' => 'The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design.',
                    'button_label' => 'Reserve premium Seat',
                    'button_url' => '/events',
                    'quantity' => '3',
                    'title_1' => 'Our Journalist',
                    'figure_1' => '250',
                    'title_2' => 'Our Speaker',
                    'figure_2' => '15',
                    'title_3' => 'Attendees',
                    'figure_3' => '7000',
                    'image' => $this->filePath('general/about-us-information-1.webp', 'homepage10'),
                    'image_1' => $this->filePath('general/about-us-information-2.webp', 'homepage10'),
                    'image_2' => $this->filePath('general/about-us-information-3.webp', 'homepage10'),
                    'image_3' => $this->filePath('general/about-us-information-4.webp', 'homepage10'),
                    'text_color' => '#ffffff',
                ])
                . Shortcode::generateShortcode(
                    'featured-block',
                    [
                        'subtitle' => 'WHY ATTEND',
                        'title' => 'Why You Shouldn’t Miss This Event',
                        'style' => 3,
                        'quantity' => 4,
                        'title_1' => '“The Technology Forum Summit 2025 will be hosted at the iconic Grand Convention Center.”',
                        'description_1' => 'Hear from top industry experts and get exclusive insights into emerging technologies. Participate in workshops that offer real-world applications of today’s technology. Connect with peers, investors, and tech pioneers to expand your professional network.',
                        'url_1' => '/events',
                        'icon_image_1' => $this->filePath('general/feature-img1.webp', 'homepage10'),
                        'title_2' => '15 - 17 January',
                        'icon_image_2' => $this->filePath('general/15-date.webp', 'homepage10'),
                        'title_3' => '20 Speakers',
                        'icon_image_3' => $this->filePath('icons/user-img.png', 'homepage10'),
                        'title_4' => '550 Tickets',
                        'icon_image_4' => $this->filePath('icons/ticket-img.png', 'homepage10'),
                    ]
                )
                . Shortcode::generateShortcode('events-schedule', [
                    'title' => 'Event Location & How to Get There',
                    'subtitle' => 'Event Schedule',
                    'number_days' => 3,
                    'number_each_days' => 3,
                    'style' => 6,
                ])
                . Shortcode::generateShortcode('speakers', [
                    'title' => 'Meet Our 2025 Speakers',
                    'subtitle' => 'our speakers',
                    'limit' => 7,
                    'style' => 9,
                ])
                . Shortcode::generateShortcode('brands', [
                    'style' => '1',
                    'title' => 'Join 4,000+ companies already growing',
                    'quantity' => 8,
                    'alt_1' => 'Boltshift',
                    'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                    'link_1' => 'https://paulmbingu.com/boltshiftui',
                    'alt_2' => 'Lightbox',
                    'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                    'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                    'alt_3' => 'GlobalBank',
                    'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                    'link_3' => 'https://www.globalbank.com.pa/',
                    'alt_4' => 'FeatherDev',
                    'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                    'link_4' => 'https://featherdev.com/',
                    'alt_5' => 'Acme Corp',
                    'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                    'link_5' => 'https://www.acmecorp.com/',
                    'alt_6' => 'Polymath',
                    'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                    'link_6' => 'https://polymath.network/',
                    'alt_7' => 'Nietzche',
                    'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                    'link_7' => 'https://redsvn.net/',
                    'alt_8' => 'Epicurious',
                    'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                    'link_8' => 'https://www.epicurious.com',
                    'text_color' => '#ffffff',
                    // 'background_image' => $this->filePath('backgrounds/header-bg.png', 'homepage02'),
                ])
                . Shortcode::generateShortcode('contact-information', [
                    'style' => 5,
                    'address' => 'Viet Nam',
                    'quantity' => '4',
                    'title_1' => 'Our Email',
                    'description_1' => 'eventify@gmail.com',
                    'url_1' => 'maito:eventify@gmail.com',
                    'icon_image_1' => $this->filePath('icons/mail-icon.png', 'main'),
                    'title_2' => 'our location',
                    'description_2' => 'Viet Nam',
                    'url_2' => '/contact-us',
                    'icon_image_2' => $this->filePath('icons/location-icon.png', 'main'),
                    'title_3' => 'Call/Message',
                    'description_3' => '+11234567890',
                    'url_3' => 'tel:+11234567890',
                    'icon_image_3' => $this->filePath('icons/phone-icon.png', 'main'),
                    'title_4' => 'Instagram',
                    'description_4' => '@eventify',
                    'url_4' => '/contact-us',
                    'icon_image_4' => $this->filePath('icons/instagram-icon.png', 'main'),
                ])
                // . Shortcode::generateShortcode('blog-posts', [
                //     'title' => 'Balancing Profit & Purpose',
                //     'subtitle' => 'News & updates',
                //     'category_ids' => '3,5',
                //     'type' => 'latest',
                //     'limit' => 3,
                //     'style' => 'style-2',
                // ])
            ),
        ]);
    }
}
