<?php

namespace Database\Seeders\Themes\Homepage10;

use Database\Seeders\Themes\Main\ThemeOptionSeeder as MainThemeOptionSeeder;

class ThemeOptionSeeder extends MainThemeOptionSeeder
{
    public function getData(): array
    {
        return [
            ...parent::getData(),
            'primary_color' => '#4af8ba',
            'secondary_color' => '#1a1719',
            'primary_font' => 'Space Grotesk',
            'logo' => $this->filePath('general/logo.png', 'main'),
            'event_location_image' => $this->filePath('icons/location.png', 'main'),
            'logo_height' => '45px',
            'header_background_color' => '#000000',
            'header_text_color' => '#ffffff',
            'is_header_transparent' => true,
            'display_header_top' => false,
            'footer_background_color' => '#212529',
            'footer_text_color' => '#fff',
            'footer_heading_color' => '#fff',
            'breadcrumb_text_color' => '#000000',
            'breadcrumb_background_color' => '#4af8ba',
            'gradient_color_from' => '#FF5000',
            'gradient_color_to' => '#FF00B8',

        ];
    }
}
