<?php

namespace Database\Seeders\Themes\Main;

use ArchiElite\EventsBooking\Enums\AccountStatusEnum;
use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use ArchiElite\EventsBooking\Models\Account;
use Botble\Base\Facades\MetaBox as MetaBoxFacade;
use Botble\Slug\Facades\SlugHelper;
use Botble\Slug\Models\Slug;
use Botble\Theme\Database\Seeders\ThemeSeeder;
use Botble\Theme\Supports\ThemeSupport;
use Illuminate\Support\Str;

class AccountSeeder extends ThemeSeeder
{
    public function run(): void
    {
        $faker = $this->fake();

        $this->uploadFiles('speakers', 'main');

        Account::query()->truncate();

        $titles = [
            'UX/UI Designer',
            'Frontend Developer',
            'Backend Developer',
            'Fullstack Developer',
            'Project Manager',
            'Product Manager',
            'Quality Assurance',
            'DevOps Engineer',
            'System Administrator',
        ];

        $account = Account::query()->create([
            'name' => $faker->name,
            'email' => 'customer@archielite.com',
            'phone' => '0' . $faker->numerify('#########'),
            'dob' => $faker->dateTimeBetween(),
            'password' => 12345678,
            'status' => AccountStatusEnum::ACTIVATED,
            'type' => AccountTypeEnum::ATTENDEE,
        ]);

        MetaBoxFacade::saveMetaBoxData($account, 'title', $titles[rand(0, count($titles) - 1)]);
        MetaBoxFacade::saveMetaBoxData($account, 'description', $faker->realText());
        MetaBoxFacade::saveMetaBoxData($account, 'address', $faker->address());
        MetaBoxFacade::saveMetaBoxData($account, 'socials', ThemeSupport::getDefaultSocialLinksData());

        foreach (range(1, 30) as $index) {
            $account = Account::query()->create([
                'name' => $index == 1 ? 'Michael Smith' : $faker->name,
                'email' => $faker->email,
                'phone' => '0' . $faker->numerify('#########'),
                'dob' => $faker->dateTimeBetween(),
                'password' => 12345678,
                'status' => AccountStatusEnum::ACTIVATED,
                'type' => $index == 1 ? 'speaker' : $faker->randomElement(['attendee', 'speaker', 'organizer']),
            ]);

            if (
                $account->type->getValue() === AccountTypeEnum::SPEAKER ||
                $account->type->getValue() === AccountTypeEnum::ORGANIZER
            ) {
                $this->updateAvatar($account);

                Slug::query()->create([
                    'reference_type' => Account::class,
                    'reference_id' => $account->getKey(),
                    'key' => Str::slug($account->name),
                    'prefix' => SlugHelper::getPrefix(Account::class),
                ]);
            }

            MetaBoxFacade::saveMetaBoxData($account, 'title', $titles[rand(0, count($titles) - 1)]);
            MetaBoxFacade::saveMetaBoxData($account, 'description', $faker->realText());
            MetaBoxFacade::saveMetaBoxData($account, 'address', $faker->address());
            MetaBoxFacade::saveMetaBoxData($account, 'socials', ThemeSupport::getDefaultSocialLinksData());
        }
    }

    public function updateAvatar(Account $account): void
    {
        $account->update([
            'avatar' => $this->filePath('speakers/' . rand(1, 10) . '.png', 'main'),
        ]);
    }
}
