<?php

namespace Database\Seeders\Themes\Main;

use Botble\ACL\Database\Seeders\UserSeeder;
use Botble\Contact\Database\Seeders\ContactSeeder;
use Botble\Language\Database\Seeders\LanguageSeeder;
use Botble\Theme\Database\Seeders\ThemeSeeder;
use Database\Seeders\CurrencySeeder;
use Illuminate\Support\Str;

class DatabaseSeeder extends ThemeSeeder
{
    protected string $themeName = 'eventify';

    public function run(): void
    {
        $this->prepareRun();

        $this->activateTheme($this->themeName);

        $this->uploadFiles('general', 'main');

        $seeders = [];

        foreach ($this->getSeeders() as $seeder) {
            $seeders[Str::afterLast($seeder, '\\')] = $seeder;
        }

        $this->call($seeders);

        $this->finished();
    }

    protected function getSeeders(): array
    {
        return [
            CurrencySeeder::class,
            GallerySeeder::class,
            UserSeeder::class,
            LanguageSeeder::class,
            ContactSeeder::class,
            TestimonialSeeder::class,
            PageSeeder::class,
            SettingSeeder::class,
            WidgetSeeder::class,
            BlogSeeder::class,
            FaqSeeder::class,
            ThemeOptionSeeder::class,
            AccountSeeder::class,
            LocationSeeder::class,
            EventSeeder::class,
            MenuSeeder::class,
            AnnouncementSeeder::class,
            SimpleSliderSeeder::class,
        ];
    }
}
