<?php

namespace Database\Seeders\Themes\Main;

use Botble\Base\Supports\BaseSeeder;
use Botble\Faq\Models\Faq;
use Botble\Faq\Models\FaqCategory;

class FaqSeeder extends BaseSeeder
{
    public function run(): void
    {
        $categories = [
            ['name' => 'Event information'],
            ['name' => 'Registration & Tickets'],
            ['name' => 'Event Experience'],
            ['name' => 'Speaker & Sessions'],
        ];

        $this->createFAQCategories($categories);

        Faq::query()->truncate();
        for($i = 0; $i <= 10; $i++){
            $data = $this->getRandomFAQ();
            $faq = Faq::query()->create($data);

            $this->createMetadata($faq, $data);
        }
    }

    public function createFAQCategories(array $categories, bool $truncate = true): void
    {
        if ($truncate) {
            FaqCategory::query()->truncate();
        }

        $faker = $this->fake();

        foreach ($categories as $index => $item) {
            $item['name'] ??= $faker->text();
            $item['description'] ??= $faker->text(100);

            $faqCategory = FaqCategory::query()->create($item);

            $this->createMetadata($faqCategory, $item);
        }
    }

    public function getRandomFAQ()
    {
        $faker = $this->fake();
        return [
            'question' => $faker->sentence(5),
            'answer' => $faker->sentence(30),
            'category_id' => $faker->numberBetween(1, 4)
        ];
    }
}
