<?php

namespace Database\Seeders\Themes\Main;

use Botble\Blog\Models\Category;
use Botble\Blog\Models\Post;
use Botble\Setting\Facades\Setting;
use Botble\Slug\Facades\SlugHelper;
use Botble\Slug\Models\Slug;
use Botble\Theme\Database\Seeders\ThemeSeeder;
use Botble\Theme\Facades\Theme;

class SettingSeeder extends ThemeSeeder
{
    public function run(): void
    {
        $settings = [
            'show_admin_bar' => '1',
            'theme' => Theme::getThemeName(),
            'media_random_hash' => md5(time()),
            'admin_favicon' => $this->filePath('general/favicon.png', 'main'),
            'admin_logo' => $this->filePath('general/logo.png', 'main'),
            SlugHelper::getPermalinkSettingKey(Post::class) => 'blog',
            SlugHelper::getPermalinkSettingKey(Category::class) => 'blog',
            'payment_cod_status' => 1,
            'payment_cod_description' => 'Please pay money directly to the postman, if you choose cash on delivery method (COD).',
            'payment_bank_transfer_status' => 1,
            'payment_bank_transfer_description' => 'Please send money to our bank account: ACB - 69270 213 19.',
            'payment_stripe_payment_type' => 'stripe_checkout',
            'events_booking_company_name_for_invoicing' => 'ArchiElite',
            'events_booking_company_address_for_invoicing' => '123 Street, New York, USA',
            'events_booking_company_country_for_invoicing' => 'US',
            'events_booking_company_state_for_invoicing' => 'NY',
            'events_booking_company_city_for_invoicing' => 'New York',
            'events_booking_company_email_for_invoicing' => 'company@example.com',
            'events_booking_company_phone_for_invoicing' => '123456789',
            'events_booking_company_logo_for_invoicing' => $this->filePath('general/logo-light.png', 'main'),
        ];

        Setting::delete(array_keys($settings));

        Setting::set($settings)->save();

        Slug::query()->where('reference_type', Post::class)->update(['prefix' => 'blog']);
        Slug::query()->where('reference_type', Category::class)->update(['prefix' => 'blog']);
    }
}
