<?php

namespace Database\Seeders\Themes\Main;

use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Facades\MetaBox;
use Botble\Language\Models\LanguageMeta;
use Botble\Setting\Facades\Setting;
use Botble\SimpleSlider\Models\SimpleSlider;
use Botble\SimpleSlider\Models\SimpleSliderItem;
use Botble\Theme\Database\Seeders\ThemeSeeder;
use Carbon\Carbon;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

class SimpleSliderSeeder extends ThemeSeeder
{
    public function run(): void
    {
        SimpleSlider::query()->truncate();
        SimpleSliderItem::query()->truncate();

        $this->uploadFiles('sliders', 'main');

        foreach ($this->getSliders() as $parent) {
            /** @var SimpleSlider $slider */
            $slider = SimpleSlider::query()->create(array_merge(Arr::except($parent, 'children'), [
                'key' => Str::slug($parent['name']),
            ]));

            LanguageMeta::saveMetaData($slider);

            foreach ($parent['children'] as $key => $item) {
                $sliderItem = $slider->sliderItems()->create([
                    ...Arr::except($item, ['metadata']),
                    'order' => $key,
                ]);

                foreach ($item['metadata'] as $metaKey => $metaValue) {
                    MetaBox::saveMetaBoxData($sliderItem, $metaKey, $metaValue);
                }
            }
        }

        Setting::set('simple_slider_using_assets', false)->save();
    }

    protected function getSliders(): array
    {
        $events = Event::query()
            ->where('status', EventStatusEnum::APPROVED)
            ->where('started_at', '>=', Carbon::now())
            ->pluck('id')
            ->all();

        return [
            [
                'name' => 'Home slider',
                'description' => 'The main slider on homepage',
                'children' => [
                    [
                        'title' => 'Yearly Business',
                        'link' => '/',
                        'image' => $this->filePath('sliders/1.png', 'main'),
                        'metadata' => [
                            'subtitle' => 'Lead Purpose, Innovate with Passion',
                            'highlight_title' => 'Conferences',
                            'button_label' => 'Reserve My Seat',
                            'event_id' => $events[rand(0, count($events) - 1)],
                        ],
                    ],
                    [
                        'title' => 'Yearly Business',
                        'link' => '/',
                        'image' => $this->filePath('sliders/2.png', 'main'),
                        'metadata' => [
                            'subtitle' => 'Lead Purpose, Innovate with Passion',
                            'highlight_title' => 'Conferences',
                            'button_label' => 'Reserve My Seat',
                            'event_id' => $events[rand(0, count($events) - 1)],
                        ],
                    ],
                    [
                        'title' => 'Yearly Business',
                        'link' => '/',
                        'image' => $this->filePath('sliders/3.png', 'main'),
                        'metadata' => [
                            'subtitle' => 'Lead Purpose, Innovate with Passion',
                            'highlight_title' => 'Conferences',
                            'button_label' => 'Reserve My Seat',
                            'event_id' => $events[rand(0, count($events) - 1)],
                        ],
                    ],
                ],
            ],
        ];
    }
}
