<?php

namespace Database\Seeders\Themes\Main;

use Botble\Theme\Database\Seeders\ThemeSeeder;
use Botble\Widget\Database\Traits\HasWidgetSeeder;
use Botble\Widget\Widgets\CoreSimpleMenu;

class WidgetSeeder extends ThemeSeeder
{
    use HasWidgetSeeder;

    public function run(): void
    {
        $this->createWidgets($this->getData());
    }

    public function getData(): array
    {
        return [
            ...$this->getHeaderSidebarData(),
            ...$this->getDataFooterSidebar(),
            ...$this->getDataBottomFooterSidebar(),
            ...$this->getDataBlogPostSidebar(),
            ...$this->getDataPreFooterSidebar(),
            ...$this->getDataOffCanvasSidebar(),
            ...$this->getDataHeaderTopSideBar(),
        ];
    }

    public function getDataBlogPostSidebar(): array
    {
        return [
            [
                'widget_id' => 'BlogSearchWidget',
                'sidebar_id' => 'blog_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'BlogSearchWidget',
                    'title' => 'Search',
                    'placeholder' => 'Search...',
                ],
            ],
            [
                'widget_id' => 'BlogCategoriesWidget',
                'sidebar_id' => 'blog_sidebar',
                'position' => 2,
                'data' => [
                    'id' => 'BlogCategoriesWidget',
                    'title' => 'Blog Category',
                    'category_ids' => [1, 2, 3, 4],
                ],
            ],
            [
                'widget_id' => 'BlogTagsWidget',
                'sidebar_id' => 'blog_sidebar',
                'position' => 3,
                'data' => [
                    'id' => 'BlogTagsWidget',
                    'title' => 'Popular Hastag',
                    'tag_ids' => [1, 2, 3, 4, 5, 6, 7],
                ],
            ],
        ];
    }

    public function getHeaderSidebarData(): array
    {
        return [
            [
                'widget_id' => 'SearchActionButtonWidget',
                'sidebar_id' => 'header_sidebar',
                'position' => 1,
                'data' => [],
            ],
            [
                'widget_id' => 'SocialLinksWidget',
                'sidebar_id' => 'header_sidebar',
                'position' => 2,
                'data' => [],
            ],
        ];
    }

    public function getDataFooterSidebar(): array
    {
        return [
            [
                'widget_id' => 'SiteInformationWidget',
                'sidebar_id' => 'footer_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'SiteInformationWidget',
                    'description' => 'We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas',
                    'is_enabled_social_links' => true,
                    'logo' => $this->filePath('general/logo-light.png', 'main'),
                ],
            ],
            [
                'widget_id' => CoreSimpleMenu::class,
                'sidebar_id' => 'footer_sidebar',
                'position' => 2,
                'data' => [
                    'id' => CoreSimpleMenu::class,
                    'name' => 'Quick Links',
                    'items' => [
                        [
                            [
                                'key' => 'label',
                                'value' => 'About Us',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/about-us',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Our Blog',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/blog',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Event Listing',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/events',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Pricing Plan',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/pricing-plan',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Contact Us',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/contact-us',
                            ],
                        ],
                    ],
                ],
            ],
            [
                'widget_id' => CoreSimpleMenu::class,
                'sidebar_id' => 'footer_sidebar',
                'position' => 3,
                'data' => [
                    'id' => CoreSimpleMenu::class,
                    'name' => 'Contact Us',
                    'items' => [
                        [
                            [
                                'key' => 'label',
                                'value' => '+1 123 456 7890',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'tel:+1 123 456 7890',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-phone-call',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Secret Location In The UK',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-map-pin',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'eventifyevent@gmail.com',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'mailto:eventifyevent@gmail.com',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-mail',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'eventify.archielite.com',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'https://eventify.archielite.com',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-world',
                            ],
                        ],
                    ],
                ],
            ],
            [
                'widget_id' => 'GalleriesWidget',
                'sidebar_id' => 'footer_sidebar',
                'position' => 4,
                'data' => [
                    'id' => 'GalleriesWidget',
                    'title' => 'Our Recent Event Gallery',
                    'limit' => 6,
                ],
            ],
            [
                'widget_id' => 'EventListWidget',
                'sidebar_id' => 'event_list_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'EventListWidget',
                    'title' => 'View More Event',
                    'number_of_days' => 3,
                ],
            ],
        ];
    }

    public function getDataBottomFooterSidebar(): array
    {
        return [
            [
                'widget_id' => 'SiteCopyrightWidget',
                'sidebar_id' => 'bottom_footer_sidebar',
                'position' => 1,
                'data' => [],
            ],
        ];
    }

    public function getDataPreFooterSidebar(): array
    {
        return [
            [
                'widget_id' => 'UpcomingEventWidget',
                'sidebar_id' => 'pre_footer_sidebar',
                'position' => 1,
                'data' => [
                    'background_color' => '#FFBA00',
                    'button_label' => 'Buy Ticket',
                ],
            ],
        ];
    }

    public function getDataOffCanvasSidebar(): array
    {
        return [
            [
                'widget_id' => 'ContactInformationWidget',
                'sidebar_id' => 'off_canvas_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'ContactInformationWidget',
                    'title' => 'Contact Info',
                    'quantity' => 3,
                    'title_1' => '+3(924)4596512',
                    'icon_1' => 'ti ti-phone-call',
                    'url_1' => 'tel:39244596512',
                    'title_2' => 'info@example.com',
                    'icon_2' => 'ti ti-mail',
                    'url_2' => 'mailto:info@example.com',
                    'icon_3' => 'ti ti-map-pin',
                    'title_3' => '55 East Birchwood Ave.Brooklyn, NY 11234',
                ],
            ],
            [
                'widget_id' => 'SocialLinksWidget',
                'sidebar_id' => 'off_canvas_sidebar',
                'position' => 2,
                'data' => [
                    'id' => 'SocialLinksWidget',
                    'title' => 'Social Links',
                ],
            ],
        ];
    }

    public function getDataHeaderTopSideBar(): array
    {
        return [];
    }
}
