<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class () extends Migration {
    public function up(): void
    {
        Schema::table('eb_invoices', function (Blueprint $table): void {
            $table->string('event_name')->nullable()->after('code');
            $table->decimal('event_ticket_price')->nullable()->after('code');
        });
    }

    public function down(): void
    {
        Schema::table('eb_invoices', function (Blueprint $table): void {
            $table->dropColumn('event_name');
            $table->dropColumn('event_ticket_price');
        });
    }
};
