'use strict';

$(document).ready(function () {
    $('.create-account').on('change', 'input[name="register_account"]', function (event) {
        const $formCreate = $('.form-create-account-password')

        if (event.target.checked) {
            $formCreate.removeClass('d-none')
        } else {
            $formCreate.addClass('d-none')
        }
    })

    const refreshCoupon = () => {
        let $checkoutButton = $(document).find('.payment-checkout-btn')
        $checkoutButton.prop('disabled', true)
        let $selectedPaymentMethod = $(document).find('.payment-checkout-form .list_payment_method input[name="payment_method"]:checked').val()

        $.ajax({
            url: '/ajax/calculate-amount',
            type: 'GET',
            data: {
                event_id: $('input[name=event_id]').val(),
                quantity: $('input[name=number_slots]').val(),
            },
            success: ({ error, message, data }) => {
                if (error) {
                    Theme.showError(message)

                    return
                }

                $('[data-bb-value="total_amount"]').text(data.total_amount)
                $('input[name=amount]').val(data.amount_raw)
                $('[data-bb-value="subtotal_amount"]').text(data.sub_total)
                $('[data-bb-value="discount_amount"]').text(data.discount_amount)
                $('[data-bb-value="tax_amount"]').text(data.tax_amount)

                $('.payment-checkout-form .list_payment_method').load(window.location.href + ' .payment-checkout-form .list_payment_method > *', function() {
                    $checkoutButton.prop('disabled', false)
                    $(document).find('.payment-checkout-form .list_payment_method input[value="' + $selectedPaymentMethod + '"]').prop('checked', true).trigger('change')
                })

                const refreshUrl = $('.order-detail-box').data('refresh-url')

                $.ajax({
                    url: refreshUrl,
                    type: 'GET',
                    data: {
                        coupon_code: $('input[name=coupon_hidden]').val() ?? $('input[name=coupon_code]').val(),
                    },
                    success: ({ error, message, data}) => {
                        if (error) {
                            Theme.showError(message)

                            return
                        }

                        $('.order-detail-box').html(data)
                    },
                    error: (error) => {
                        Theme.handleError(error)
                    },
                })
            },
            error: (error) => {
                Theme.handleError(error)
            },
        })
    }

    $(document)
        .on('click', '.toggle-coupon-form', () => $(document).find('.coupon-form').toggle('fast'))
        .on('click', '.apply-coupon-code', (e) => {
            e.preventDefault()

            const $button = $(e.currentTarget)

            $.ajax({
                url: $button.data('url'),
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    coupon_code: $('input[name=coupon_code]').val(),
                },
                beforeSend: () => {
                    $button.addClass('button-loading')
                },
                success: ({ error, message }) => {
                    if (error) {
                        Theme.showError(message)

                        return
                    }

                    Theme.showSuccess(message)

                    refreshCoupon()
                },
                error: (error) => {
                    Theme.handleError(error)
                },
                complete: () => {
                    $button.removeClass('button-loading')
                }
            })
        })
        .on('click', '.remove-coupon-code', (e) => {
            e.preventDefault()

            const $button = $(e.currentTarget)

            $.ajax({
                url: $button.data('url'),
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                beforeSend: () => {
                    $button.addClass('button-loading')
                },
                success: ({ message, error }) => {
                    if (error) {
                        Theme.showError(message)

                        return
                    }

                    Theme.showSuccess(message)

                    refreshCoupon()
                },
                error: (error) => {
                    Theme.handleError(error)
                },
                complete: () => {
                    $button.removeClass('button-loading')
                },
            })
        })
})
