<?php

return [
    'name' => 'Events bookings',
    'create' => 'New events booking',
    'export' => [
        'attendee' => [
            'name' => 'Attendees',
            'title' => 'Export Attendees',
            'total_attendees' => 'Total Attendees',
            'description' => 'Export attendees to CSV/Excel file.',
            'errors' => [
                'required_event' => 'Please select an event to export attendees.',
                'event_not_found' => 'Event not found.',
            ],
        ],
    ],
    'import' => [
        'attendee' => [
            'name' => 'Attendees',
            'title' => 'Import Attendees',
            'description' => 'Import attendees in bulk by uploading a CSV/Excel file.',
            'done_message' => 'Updated :count attendee(s) successfully.',
            'rules' => [
                'event_id' => 'The Event ID field is mandatory and must be exists in events table.',
                'name' => 'The name field is mandatory and must be a string.',
                'email' => 'The email field is mandatory and must be a string.',
                'phone' => 'The phone field must be a string.',
                'dob' => 'The dob field must be a date.',
            ],
        ],
    ],
    'event' => [
        'name' => 'Events',
        'create' => 'New Event',
        'empty_event_helper_text' => 'Please create an event first :link .',
        'search_events' => 'Search events',
        'no_results' => 'No results found',
        'form' => [
            'unique_id' => 'Unique ID',
            'address' => 'Address',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'latitude' => 'Latitude',
            'longitude' => 'Longitude',
            'description' => 'Description',
            'short_description' => 'Short Description',
            'seats' => 'Seats',
            'booked_seats' => 'Booked Seats',
            'status' => 'Status',
            'content' => 'Content',
            'image' => 'Image',
            'location_helper_text' => 'Go here to get :subject from address: :link',
            'organizer' => 'Organizer',
            'price' => 'Price',
            'is_featured' => 'Is featured?',
            'speakers' => 'Speakers',
            'booking_closed' => 'Booking closed',
            'speaker' => 'Speaker',
            'title' => 'Title',
            'subtitle' => 'Subtitle',
            'started_at' => 'Started At',
            'ended_at' => 'Ended At',
            'priority' => 'Priority',
            'booking_close_at' => 'Booking close at',
        ],
        'analytics' => [
            'name' => 'Analytics',
            'total_views' => 'Total views',
            'total_attendees' => 'Total attendees',
            'revenue' => 'Revenue',
            'number_of_empty_seats' => 'Number of empty seats',
            'number_of_successful_orders' => 'Number of successful orders',
            'number_of_pending_orders' => 'Number of pending orders',
            'number_of_failed_orders' => 'Number of failed orders',
            'view_analytics' => 'Analytics for event ":name"',
            'orders' => 'Orders',
            'attendees' => 'Attendees',
            'tickets' => 'Tickets',
        ],
    ],
    'account' => [
        'name' => 'Accounts',
        'create' => 'New Account',
        'company_position' => ':position at :company',
        'form' => [
            'name' => 'Name',
            'email' => 'Email',
            'phone' => 'Phone',
            'type' => 'Type',
            'avatar' => 'Avatar',
            'dob' => 'Date of Birth',
            'company' => 'Company',
            'position' => 'Position',
            'password' => 'Password',
            'password_confirmation' => 'Password confirmation',
            'change_password' => 'Change password?',
            'phone_placeholder' => 'Phone',
            'event_id' => 'Event ID',
        ],
    ],
    'order' => [
        'name' => 'Orders',
        'create' => 'New Order',
        'event' => 'Event',
        'account' => 'Account',
        'account_name' => 'Account Name',
        'account_email' => 'Account Email',
        'note' => 'Note',
        'private_note' => 'Private Note',
        'price' => 'Price',
        'quantity' => 'Quantity',
        'subtotal' => 'Subtotal',
        'total' => 'Total',
        'status' => 'Status',
        'order_information' => 'Order Information',
        'action' => 'Action',
        'code' => 'Code',
        'invoice' => 'Invoice',
        'order_id' => 'Order ID',
        'payment_status' => 'Payment Status',
        'pending_payment' => 'Pending payment',
        'payment_was_accepted' => 'Payment :money was accepted',
        'payment_was_refunded' => 'Payment was refunded',
        'confirm_payment_success' => 'Confirm payment successfully!',
        'confirm_payment' => 'Confirm payment',
        'confirm_payment_confirmation_description' => 'Processed by <strong>:method</strong>. Did you receive payment outside the system? This payment won\'t be saved into system and cannot be refunded',
        'tax_amount' => 'Tax Amount',
        'discount' => 'Discount',
        'charge_id' => 'Charge ID',
        'payment_info' => 'Payment Information',
        'id' => 'Order ID',
        'order_was_canceled' => 'Order was canceled',
        'resend_mail' => 'Resend mail',
        'resend_mail_success' => 'Resend mail successfully!',
        'resend_mail_failed' => 'Resend mail failed!',
    ],
    'ticket' => [
        'name' => 'Tickets',
        'note' => 'Note',
        'order_code' => 'Order Code',
        'code' => 'Code',
        'account_name' => 'Account Name',
        'ticket_name' => 'Name',
        'phone' => 'Phone',
        'email' => 'Email',
        'status' => 'Status',
        'ticket_information' => 'Ticket Information',
        'qr_code' => 'QR Code',
        'ticket_number' => 'Ticket #:number',
    ],
    'enums' => [
        'events' => [
            'statuses' => [
                'pending' => 'Pending',
                'approved' => 'Approved',
                'rejected' => 'Rejected',
            ],
        ],
        'accounts' => [
            'types' => [
                'attendee' => 'Attendee',
                'organizer' => 'Organizer',
                'speaker' => 'Speaker',
            ],
            'statuses' => [
                'activated' => 'Activated',
                'locked' => 'Locked',
            ],
        ],
        'orders' => [
            'statuses' => [
                'pending' => 'Pending',
                'processing' => 'Processing',
                'completed' => 'Completed',
                'cancelled' => 'Cancelled',
                'refunded' => 'Refunded',
            ],
        ],
        'tickets' => [
            'statuses' => [
                'reserved' => 'Reserved',
                'purchased' => 'Purchased',
                'checked_in' => 'Checked In',
                'cancelled' => 'Cancelled',
                'refunded' => 'Refunded',
                'transferred' => 'Transferred',
                'pending' => 'Pending',
            ],
        ],
        'invoices' => [
            'statuses' => [
                'pending' => 'Pending',
                'processing' => 'Processing',
                'completed' => 'Completed',
                'cancelled' => 'Cancelled',
            ],
        ],
    ],
    'order_confirm' => [
        'order_confirmation_title' => 'Order Completed',
        'order_confirmation_description' => 'Send email confirmation to account when an order completed',
        'customer_name' => 'Customer name',
        'customer_email' => 'Customer email',
        'customer_phone' => 'Customer phone',
        'ticket' => 'Customer phone',
        'order_note' => 'Order note',
        'order_id' => 'Order ID',
        'payment_method' => 'Payment Method',
        'ticket_list' => 'Tickets',
        'event_name' => 'Event',
        'event_image' => 'Event Image',
        'event_location' => 'Location',
        'event_date' => 'Date',
        'ticket_qrcode' => 'Ticket QR Code',
        'order_title' => 'Ticket: :name',
        'order_completed_title' => 'Your Ticket Booking is Confirmed!',
        'order_dear' => 'Dear',
        'order_your_tickets' => 'Here are your tickets:',
    ],
    'account_new_order' => [
        'account_new_order_title' => 'Order confirmation ',
        'account_new_order_description' => 'Send email confirmation to account when an order placed',
    ],
    'payment_confirmation' => [
        'payment_confirmation_title' => 'Payment confirmation',
        'payment_confirmation_description' => 'Send to customer when their payment was confirmed',
    ],
    'event_tickets_delivery' => [
        'event_tickets_delivery_title' => 'Event tickets delivery',
        'event_tickets_delivery_description' => 'Send to customer when their tickets are ready',
        'ticket_thanks' => 'We are thrilled to inform you that your ticket booking has been successfully completed. Below are the details of your booking:',
        'ticket_dear' => 'Dear',
        'ticket_instruction' => 'Give this QR code to the host when you arrive',
    ],
    'booking' => [
        'reports' => 'Booking Reports',
    ],
];
