@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    <x-core::stat-widget class="row row-cards mb-3">
        <div class="widget-item col-md-3">
            <x-core::card class="analytic-card">
                <x-core::card.body class="p-3">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <x-core::icon
                                class="text-white bg-green bg-azure rounded p-1"
                                name="ti ti-currency-dollar"
                                size="md"
                            />
                        </div>
                        <div class="col mt-0">
                            <p class="text-secondary mb-0 fs-4">
                                {{ trans('plugins/events-booking::events-booking.event.analytics.revenue') }}
                            </p>
                            <h3 class="mb-n1 fs-1">
                                {{ format_price($totalAmount) }}
                            </h3>
                        </div>
                    </div>
                </x-core::card.body>
            </x-core::card>
        </div>

        <div class="widget-item col-md-3">
            <x-core::card class="analytic-card ">
                <x-core::card.body class="p-3">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <x-core::icon
                                class="text-white bg-green bg-azure rounded p-1"
                                name="ti ti-shopping-cart"
                                size="md"
                            />
                        </div>
                        <div class="col mt-0">
                            <p class="text-secondary mb-0 fs-4">
                                {{ trans('plugins/events-booking::events-booking.event.analytics.number_of_successful_orders') }}
                            </p>
                            <h3 class="mb-n1 fs-1">
                                {{ number_format($ordersCompletedCount) }}
                            </h3>
                        </div>
                    </div>
                </x-core::card.body>
            </x-core::card>
        </div>

        <div class="widget-item col-md-3">
            <x-core::card class="analytic-card">
                <x-core::card.body class="p-3">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <x-core::icon
                                class="text-white bg-yellow bg-azure rounded p-1"
                                name="ti ti-shopping-cart"
                                size="md"
                            />
                        </div>
                        <div class="col mt-0">
                            <p class="text-secondary mb-0 fs-4">
                                {{ trans('plugins/events-booking::events-booking.event.analytics.number_of_pending_orders') }}
                            </p>
                            <h3 class="mb-n1 fs-1">
                                {{ number_format($ordersPendingCount) }}
                            </h3>
                        </div>
                    </div>
                </x-core::card.body>
            </x-core::card>
        </div>

        <div class="widget-item col-md-3">
            <x-core::card class="analytic-card">
                <x-core::card.body class="p-3">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <x-core::icon
                                class="text-white bg-red bg-azure rounded p-1"
                                name="ti ti-shopping-cart"
                                size="md"
                            />
                        </div>
                        <div class="col mt-0">
                            <p class="text-secondary mb-0 fs-4">
                                {{ trans('plugins/events-booking::events-booking.event.analytics.number_of_failed_orders') }}
                            </p>
                            <h3 class="mb-n1 fs-1">
                                {{ number_format($ordersCancelledCount) }}
                            </h3>
                        </div>
                    </div>
                </x-core::card.body>
            </x-core::card>
        </div>

        <div class="widget-item col-md-3">
            <x-core::card class="analytic-card">
                <x-core::card.body class="p-3">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <x-core::icon
                                class="text-white bg-info bg-azure rounded p-1"
                                name="ti ti-ticket"
                                size="md"
                            />
                        </div>
                        <div class="col mt-0">
                            <p class="text-secondary mb-0 fs-4">
                                {{ trans('plugins/events-booking::events-booking.event.analytics.tickets') }}
                            </p>
                            <h3 class="mb-n1 fs-1">
                                {{ number_format($attendeeCount) }}
                            </h3>
                        </div>
                    </div>
                </x-core::card.body>
            </x-core::card>
        </div>

        <div class="widget-item col-md-3">
            <x-core::card class="analytic-card">
                <x-core::card.body class="p-3">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <x-core::icon
                                class="text-white bg-info bg-azure rounded p-1"
                                name="ti ti-eye"
                                size="md"
                            />
                        </div>
                        <div class="col mt-0">
                            <p class="text-secondary mb-0 fs-4">
                                {{ trans('plugins/events-booking::events-booking.event.analytics.total_views') }}
                            </p>
                            <h3 class="mb-n1 fs-1">
                                {{ number_format($viewsCount) }}
                            </h3>
                        </div>
                    </div>
                </x-core::card.body>
            </x-core::card>
        </div>
    </x-core::stat-widget>

    <x-core::card class="mb-3">
        <x-core::card.header>
            <h4 class="card-title">{{ trans('plugins/events-booking::events-booking.event.analytics.orders') }}</h4>
        </x-core::card.header>

        {!! $orderTable->renderTable() !!}
    </x-core::card>


    <x-core::card class="mb-3">
        <x-core::card.header>
            <h4 class="card-title">{{ trans('plugins/events-booking::events-booking.event.analytics.attendees') }}</h4>
        </x-core::card.header>

        {!! $attendeeTable->renderTable() !!}
    </x-core::card>
@stop
