@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    @php
        do_action(BASE_ACTION_TOP_FORM_CONTENT_NOTIFICATION, request(), $order);
    @endphp

    <x-core::form id="main-order-content" method="post">
        <div class="row">
            <div class="col-md-9">
                <x-core::card>
                    <x-core::card.header>
                        <h4 class="card-title">{{ trans('plugins/events-booking::events-booking.order.order_information') }}</h4>

                        <div class="card-actions">
                            {!! apply_filters('order-information-card-actions', null, $order) !!}
                        </div>
                    </x-core::card.header>

                    <x-core::card.body>
                        <x-core::datagrid>
                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.code') }}</x-slot:title>
                                {{ $order->code }}
                            </x-core::datagrid.item>

                            @if ($event = $order->event)
                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.event') }}</x-slot:title>
                                    {{ $event->name }}
                                </x-core::datagrid.item>
                            @endif

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.account') }}</x-slot:title>
                                {{ $order->account_name }}
                            </x-core::datagrid.item>

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.account_email') }}</x-slot:title>
                                {{ $order->account_email }}
                            </x-core::datagrid.item>

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.quantity') }}</x-slot:title>
                                {{ $order->quantity }}
                            </x-core::datagrid.item>

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.subtotal') }}</x-slot:title>
                                {{ format_price($order->subtotal) }}
                            </x-core::datagrid.item>

                            @if (($couponAmount = $order->coupon_amount) && ($couponCode = $order->coupon_code))
                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.discount') }}</x-slot:title>
                                    {{ format_price($couponAmount) }} ({{ $couponCode }})
                                </x-core::datagrid.item>
                            @endif

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.tax_amount') }}</x-slot:title>
                                {{ format_price($order->tax_amount) }}
                            </x-core::datagrid.item>

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.total') }}</x-slot:title>
                                {{ format_price($order->total) }}
                            </x-core::datagrid.item>

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.status') }}</x-slot:title>
                                {!! BaseHelper::clean($order->status->toHtml()) !!}
                            </x-core::datagrid.item>

                            @if(is_plugin_active('payment') && $order->payment)
                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.payment_status') }}</x-slot:title>
                                    {!! BaseHelper::clean( $order->payment->status->toHtml()) !!}
                                </x-core::datagrid.item>

                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.order.charge_id') }}</x-slot:title>
                                    <a href="{{ route('payment.show', $order->payment) }}">{{ $order->payment->charge_id }}</a>
                                </x-core::datagrid.item>
                            @endif
                        </x-core::datagrid>

                        @if ($note = $order->note)
                            <div class="mt-3">
                                <div class="datagrid-title">{{ trans('plugins/events-booking::events-booking.order.note') }}</div>
                                {!! BaseHelper::clean($note) !!}
                            </div>
                        @endif

                        @if ($privateNote = $order->private_note)
                            <div class="mt-3">
                                <div class="datagrid-title">{{ trans('plugins/events-booking::events-booking.order.private_note') }}</div>
                                {!! BaseHelper::clean($privateNote) !!}
                            </div>
                        @endif

                        <div class="mt-3">
                            <div class="datagrid-title mb-3">{{ trans('plugins/events-booking::events-booking.ticket.name') }}</div>
                            <div class="row">
                                @foreach($order->tickets as $ticket)
                                    <div class="col-lg-6 mb-3">
                                        <x-core::card>
                                            <x-core::card.header @class('d-flex justify-content-between')>
                                                <div class="card-title">{{ trans('plugins/events-booking::events-booking.ticket.ticket_number', ['number' => $loop->iteration]) }}</div>
                                                @if ($order->status && $order->status == ArchiElite\EventsBooking\Enums\OrderStatusEnum::COMPLETED)
                                                    <button data-target="{{route('events-booking.ajax.order.resend-mail', [$order->id, $ticket->id])}}" type="button" class="btn btn-success btn-resend-mail">
                                                        <i class="fa-solid fa-paper-plane"></i>
                                                        {{ trans('plugins/events-booking::events-booking.order.resend_mail') }}
                                                    </button>
                                                @endif
                                            </x-core::card.header>

                                            <x-core::card.body>
                                                <div class="mb-2">
                                                    {{ trans('plugins/events-booking::events-booking.ticket.code') }}
                                                    : <strong>{{ $ticket->code }}</strong>
                                                </div>

                                                @if ($name = $ticket->name)
                                                    <div class="mb-2">
                                                        {{ trans('plugins/events-booking::events-booking.ticket.ticket_name') }}
                                                        : <strong>{{ $name }}</strong>
                                                    </div>
                                                @endif

                                                @if ($email = $ticket->email)
                                                    <div class="mb-2">
                                                        {{ trans('plugins/events-booking::events-booking.ticket.email') }}
                                                        : <strong>{{ $email }}</strong>
                                                    </div>
                                                @endif

                                                @if ($phone = $ticket->phone)
                                                    <div class="mb-2">
                                                        {{ trans('plugins/events-booking::events-booking.ticket.phone') }}
                                                        : <strong>{{ $phone }}</strong>
                                                    </div>
                                                @endif

                                                @if ($note = $ticket->note)
                                                    <div class="mb-2">
                                                        {{ trans('plugins/events-booking::events-booking.ticket.note') }}
                                                        : <strong>{{ $note }}</strong>
                                                    </div>
                                                @endif

                                                <div class="mb-2">
                                                    {{ trans('plugins/events-booking::events-booking.ticket.status') }}
                                                    : {!! BaseHelper::clean($ticket->status->toHtml()) !!}
                                                </div>

                                                @if($order->status == \ArchiElite\EventsBooking\Enums\OrderStatusEnum::COMPLETED)
                                                    <div class="mt-3">
                                                        <div class="mb-1"><strong>{{ trans('plugins/events-booking::events-booking.ticket.qr_code') }}</strong></div>
                                                        <div>
                                                            {{ RvMedia::image($ticket->qr_code_image, $ticket->code, attributes: ['class' => 'border border-1', 'width' => 120, 'height' => 120]) }}
                                                        </div>
                                                    </div>
                                                @endif
                                            </x-core::card.body>
                                        </x-core::card>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        @if ($order->status == ArchiElite\EventsBooking\Enums\OrderStatusEnum::CANCELLED || is_plugin_active('payment') && $order->payment)
                            <div class="p-3 border-bottom d-flex justify-content-between align-items-center">
                                @if ($order->status == ArchiElite\EventsBooking\Enums\OrderStatusEnum::CANCELLED)
                                    <div class="d-flex align-items-start gap-1">
                                        <x-core::icon name="ti ti-circle-off" />
                                        <div>
                                            <span class="text-uppercase">{{ trans('plugins/events-booking::events-booking.order.order_was_canceled') }}</span>

                                            @if($order->cancellation_reason)
                                                <div class="text-muted small">
                                                    {{ trans('plugins/events-booking::events-booking.order.cancellation_reason', ['reason' => $order->cancellation_reason_message]) }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @elseif (is_plugin_active('payment') && $order->payment)
                                    <div class="text-uppercase">
                                        @if (!$order->payment->status || $order->payment->status == Botble\Payment\Enums\PaymentStatusEnum::PENDING)
                                            <x-core::icon name="ti ti-credit-card" />
                                        @elseif (
                                            $order->payment->status == Botble\Payment\Enums\PaymentStatusEnum::COMPLETED
                                            || $order->payment->status == Botble\Payment\Enums\PaymentStatusEnum::PENDING
                                        )
                                            <x-core::icon name="ti ti-check" class="text-success" />
                                        @endif

                                        @if (!$order->payment->status || $order->payment->status == Botble\Payment\Enums\PaymentStatusEnum::PENDING)
                                            {{ trans('plugins/events-booking::events-booking.order.pending_payment') }}
                                        @elseif ($order->payment->status == Botble\Payment\Enums\PaymentStatusEnum::COMPLETED)
                                            {{ trans('plugins/events-booking::events-booking.order.payment_was_accepted', ['money' => format_price($order->payment->amount - $order->payment->refunded_amount)]) }}
                                        @elseif ($order->payment->amount - $order->payment->refunded_amount == 0)
                                            {{ trans('plugins/events-booking::events-booking.order.payment_was_refunded') }}
                                        @endif
                                    </div>

                                    <div class="btn-list">
                                        @if (!$order->payment->status || in_array($order->payment->status, [Botble\Payment\Enums\PaymentStatusEnum::PENDING]))
                                            <x-core::button
                                                    type="button"
                                                    color="info"
                                                    class="btn-trigger-confirm-payment"
                                                    :data-target="route('events-booking.orders.confirm-payment', $order->id)"
                                            >
                                                {{ trans('plugins/events-booking::events-booking.order.confirm_payment') }}
                                            </x-core::button>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        @endif
                    </x-core::card.body>
                </x-core::card>

                @php
                    do_action(BASE_ACTION_META_BOXES, 'advanced', $order);
                @endphp
            </div>

            <div class="col-md-3">
                @include('core/base::forms.partials.form-actions', [
                    'title' => trans('plugins/events-booking::events-booking.order.action'),
                ])

                <x-core::card class="meta-boxes mt-3">
                    <x-core::card.header>
                        <h4 class="card-title">
                            <label class="form-label required" for="status">
                                {{ trans('core/base::tables.status') }}
                            </label>
                        </h4>
                    </x-core::card.header>

                    <x-core::card.body>
                        {!! Form::customSelect('status', $orderStatuses, $order->status) !!}
                    </x-core::card.body>
                </x-core::card>

                <x-core::card class="meta-boxes mt-3">
                    <x-core::card.header>
                        <h4 class="card-title">
                            <label class="form-label" for="status">
                                {{ trans('plugins/events-booking::events-booking.order.private_note') }}
                            </label>
                        </h4>
                    </x-core::card.header>

                    <x-core::card.body>
                        {!! Form::textarea('private_note', $order->private_note, [
                            'class' => 'form-control',
                            'rows' => 3
                        ]) !!}
                    </x-core::card.body>
                </x-core::card>

                @php
                    do_action(BASE_ACTION_META_BOXES, 'side', $order);
                @endphp
            </div>
        </div>
    </x-core::form>
@endsection

@push('footer')
    @if (is_plugin_active('payment') && $order->payment)
        <x-core::modal.action
                id="confirm-payment-modal"
                type="info"
                :title="trans('plugins/events-booking::events-booking.order.confirm_payment')"
                :description="trans('plugins/events-booking::events-booking.order.confirm_payment_confirmation_description', [
                'method' => $order->payment->payment_channel->label(),
            ])"
                :submit-button-attrs="['id' => 'confirm-payment-order-button']"
                :submit-button-label="trans('plugins/events-booking::events-booking.order.confirm_payment')"
        />
    @endif
@endpush
