<div class="container">
    <div class="row g-4">
        @foreach($events as $event)
            <div class="col-sm-6 col-lg-3">
                <div class="card shadow-sm">
                    <a href="{{ $event->url }}">
                        {{ RvMedia::image($event->image, $event->name, attributes: ['class' => 'card-img-top', 'height' => '200'] ) }}
                    </a>
                    <div class="card-body">
                        <a class="text-black text-decoration-none" title="{{ $event->name }}" href="{{ $event->url }}">
                            <h5 class="card-title">{{ $event->name }}</h5>
                        </a>
                        @if($description = $event->description)
                            <div title="{{ $description }}" class="text-muted mb-3 text-truncate">
                                {!! BaseHelper::clean($event->short_description) !!}
                            </div>
                        @endif

                        <div class="fw-bold fs-5 text-primary">
                            {{ render_price($event->price) }}
                        </div>
                    </div>

                    @if ($organizer = $event->organizer)
                        <div class="card-footer bg-white">
                            <div class="d-flex fs-6">
                                <div>
                                    <div>{{ __('Organized By') }}</div>
                                    <div class="text-primary">{{ $organizer->name }}</div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @endforeach
    </div>
</div>