<?php

namespace ArchiElite\EventsBooking\Enums;

use Botble\Base\Facades\Html;
use Botble\Base\Supports\Enum;
use Illuminate\Support\HtmlString;

/**
 * @method static TicketStatusEnum RESERVED()
 * @method static TicketStatusEnum PURCHASED()
 * @method static TicketStatusEnum CHECKED_IN()
 * @method static TicketStatusEnum CANCELLED()
 * @method static TicketStatusEnum REFUNDED()
 * @method static TicketStatusEnum TRANSFERRED()
 * @method static TicketStatusEnum PENDING()
 */
class TicketStatusEnum extends Enum
{
    public const RESERVED = 'reserved';
    public const PURCHASED = 'purchased';
    public const CHECKED_IN = 'checked_in';
    public const CANCELLED = 'cancelled';
    public const REFUNDED = 'refunded';
    public const TRANSFERRED = 'transferred';
    public const PENDING = 'pending';

    public static $langPath = 'plugins/events-booking::events-booking.enums.tickets.statuses';

    public function toHtml(): string|HtmlString
    {
        return match ($this->value) {
            self::CANCELLED => Html::tag('span', self::CANCELLED()->label(), ['class' => 'badge bg-danger text-danger-fg']),
            self::RESERVED => Html::tag('span', self::RESERVED()->label(), ['class' => 'badge bg-warning text-warning-fg']),
            self::PURCHASED => Html::tag('span', self::PURCHASED()->label(), ['class' => 'badge bg-success text-success-fg']),
            self::CHECKED_IN => Html::tag('span', self::CHECKED_IN()->label(), ['class' => 'badge bg-primary text-primary-fg']),
            self::REFUNDED => Html::tag('span', self::REFUNDED()->label(), ['class' => 'badge bg-info text-info-fg']),
            self::TRANSFERRED => Html::tag('span', self::TRANSFERRED()->label(), ['class' => 'badge bg-info text-info-fg']),
            self::PENDING => Html::tag('span', self::PENDING()->label(), ['class' => 'badge bg-warning text-warning-fg']),
            default => parent::toHtml(),
        };
    }
}
