<?php

namespace ArchiElite\EventsBooking\Facades;

use ArchiElite\EventsBooking\Models\Ticket;
use ArchiElite\EventsBooking\Supports\TicketHelper as TicketHelperSupport;
use Illuminate\Support\Facades\Facade;

/**
 * @method static string getQrCodeImage(\ArchiElite\EventsBooking\Models\Ticket $ticket)
 * @method static bool sendTicketsEmail(\ArchiElite\EventsBooking\Models\Order $order)
 * @method static bool sendTicketEmail(\ArchiElite\EventsBooking\Models\Order $order, Ticket $ticket)
 *
 * @see \ArchiElite\EventsBooking\Supports\TicketHelperSupport
 */
class TicketHelper extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return TicketHelperSupport::class;
    }
}
