<?php

namespace ArchiElite\EventsBooking\Forms\Fronts\Auth;

use ArchiElite\EventsBooking\Http\Requests\Fronts\ChangePasswordRequest;
use ArchiElite\EventsBooking\Models\Account;
use Botble\Base\Forms\FieldOptions\ButtonFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\PasswordField;
use Botble\Base\Forms\FormAbstract;

class ChangePasswordForm extends FormAbstract
{
    public function setup(): void
    {
        $this
            ->setUrl(route('account.change-password.post'))
            ->model(Account::class)
            ->setValidatorClass(ChangePasswordRequest::class)
            ->contentOnly()
            ->add(
                'old_password',
                PasswordField::class,
                TextFieldOption::make()
                    ->placeholder(__('Current password'))
                    ->label(__('Current password'))
                    ->required()
            )
            ->add(
                'password',
                PasswordField::class,
                TextFieldOption::make()
                    ->placeholder(__('New password'))
                    ->label(__('Password'))
                    ->required()
            )
            ->add(
                'password_confirmation',
                PasswordField::class,
                TextFieldOption::make()
                    ->placeholder(__('Confirm password'))
                    ->label(__('Password confirmation'))
                    ->required()
            )
            ->add(
                'submit',
                'submit',
                ButtonFieldOption::make()
                    ->label(__('Change password'))
                    ->cssClass('btn btn-primary')
            );
    }
}
