<?php

namespace ArchiElite\EventsBooking\Http\Controllers;

use ArchiElite\EventsBooking\Forms\AccountForm;
use ArchiElite\EventsBooking\Http\Requests\AccountRequest;
use ArchiElite\EventsBooking\Http\Requests\EditAccountRequest;
use ArchiElite\EventsBooking\Models\Account;
use ArchiElite\EventsBooking\Tables\AccountTable;
use Botble\Base\Http\Actions\DeleteResourceAction;
use Botble\Base\Http\Controllers\BaseController;

class AccountController extends BaseController
{
    public function __construct()
    {
        $this
            ->breadcrumb()
            ->add(trans('plugins/events-booking::events-booking.account.name'), route('events-booking.accounts.index'));
    }

    public function index(AccountTable $table)
    {
        $this->pageTitle(trans('plugins/events-booking::events-booking.account.name'));

        return $table->renderTable();
    }

    public function create()
    {
        $this->pageTitle(trans('plugins/events-booking::events-booking.account.create'));

        return AccountForm::create()->renderForm();
    }

    public function store(AccountRequest $request)
    {
        $form = AccountForm::create()->setRequest($request);
        $form->save();

        return $this
            ->httpResponse()
            ->setPreviousUrl(route('events-booking.accounts.index'))
            ->setNextUrl(route('events-booking.accounts.edit', $form->getModel()->getKey()))
            ->withCreatedSuccessMessage();
    }

    public function edit(Account $account)
    {
        $this->pageTitle(trans('core/base::forms.edit_item', ['name' => $account->name]));

        $account->password = null;

        return AccountForm::createFromModel($account)
            ->setValidatorClass(EditAccountRequest::class)
            ->renderForm();
    }

    public function update(Account $account, EditAccountRequest $request)
    {
        AccountForm::createFromModel($account)->saving(function (AccountForm $form) use ($request) {
            $model = $form->getModel();

            $model->update($request->validated());
        });

        return $this
            ->httpResponse()
            ->setPreviousUrl(route('events-booking.accounts.index'))
            ->withUpdatedSuccessMessage();
    }

    public function destroy(Account $account)
    {
        return DeleteResourceAction::make($account);
    }
}
