<?php

namespace ArchiElite\EventsBooking\Http\Controllers\Accounts;

use ArchiElite\EventsBooking\Forms\Fronts\Auth\ForgotPasswordForm;
use Botble\ACL\Traits\SendsPasswordResetEmails;
use Botble\Base\Http\Controllers\BaseController;
use Botble\SeoHelper\Facades\SeoHelper;
use Botble\Theme\Facades\Theme;
use Illuminate\Contracts\Auth\PasswordBroker;
use Illuminate\Support\Facades\Password;

class ForgotPasswordController extends BaseController
{
    use SendsPasswordResetEmails;

    public function __construct()
    {
        $this->middleware('account.guest');
    }

    public function showLinkRequestForm()
    {
        SeoHelper::setTitle(__('Forgot Password'));

        Theme::breadcrumb()
            ->add(__('Login'), route('account.password.reset'));

        return Theme::scope(
            'events-booking.accounts.passwords.email',
            ['form' => ForgotPasswordForm::create()],
            'plugins/events-booking::themes.accounts.passwords.email'
        )->render();
    }

    public function broker(): PasswordBroker
    {
        return Password::broker('accounts');
    }
}
