<?php

namespace ArchiElite\EventsBooking\Http\Controllers\Settings;

use ArchiElite\EventsBooking\Forms\Settings\CurrencySettingForm;
use ArchiElite\EventsBooking\Http\Requests\Settings\CurrencySettingRequest;
use ArchiElite\EventsBooking\Services\StoreCurrenciesService;

class CurrencySettingController extends SettingController
{
    public function edit()
    {
        $this->pageTitle(trans('plugins/events-booking::currency.currencies'));

        $form = CurrencySettingForm::create();

        return view('plugins/events-booking::settings.currency', compact('form'));
    }

    public function update(CurrencySettingRequest $request, StoreCurrenciesService $service)
    {
        $this->saveSettings($request->except([
            'currencies',
            'currencies_data',
            'deleted_currencies',
        ]));

        $currencies = json_decode($request->validated('currencies'), true) ?: [];

        if (! $currencies) {
            return $this
                ->httpResponse()
                ->setNextUrl(route('events-booking.settings.currencies'))
                ->setError()
                ->setMessage(trans('plugins/events-booking::currency.require_at_least_one_currency'));
        }

        $deletedCurrencies = json_decode($request->input('deleted_currencies', []), true) ?: [];

        $service->execute($currencies, $deletedCurrencies);

        return $this
            ->httpResponse()
            ->setMessage(trans('core/base::notices.update_success_message'));
    }
}
