<?php

namespace ArchiElite\EventsBooking\Http\Controllers;

use ArchiElite\EventsBooking\Forms\TaxForm;
use ArchiElite\EventsBooking\Http\Requests\TaxRequest;
use ArchiElite\EventsBooking\Models\Tax;
use ArchiElite\EventsBooking\Tables\TaxTable;
use Botble\Base\Http\Actions\DeleteResourceAction;
use Botble\Base\Http\Controllers\BaseController;

class TaxController extends BaseController
{
    public function __construct()
    {
        $this
            ->breadcrumb()
            ->add(trans('plugins/events-booking::events-booking.name'))
            ->add(trans('plugins/events-booking::tax.name'), route('events-booking.taxes.index'));
    }

    public function index(TaxTable $table)
    {
        $this->pageTitle(trans('plugins/events-booking::tax.name'));

        return $table->renderTable();
    }

    public function create()
    {
        $this->pageTitle(trans('plugins/events-booking::tax.create'));

        return TaxForm::create()->renderForm();
    }

    public function store(TaxRequest $request)
    {
        $form = TaxForm::create()->setRequest($request);

        $form->save();

        return $this
            ->httpResponse()
            ->setPreviousUrl(route('events-booking.taxes.index'))
            ->setNextUrl(route('events-booking.taxes.edit', $form->getModel()->getKey()))
            ->withCreatedSuccessMessage();
    }

    public function edit(Tax $tax)
    {
        $this->pageTitle(trans('core/base::forms.edit_item', ['name' => $tax->title]));

        return TaxForm::createFromModel($tax)->renderForm();
    }

    public function update(Tax $tax, TaxRequest $request)
    {
        TaxForm::createFromModel($tax)->setRequest($request)->save();

        return $this
            ->httpResponse()
            ->setPreviousUrl(route('events-booking.taxes.index'))
            ->withUpdatedSuccessMessage();
    }

    public function destroy(Tax $tax)
    {
        return DeleteResourceAction::make($tax);
    }
}
