<?php

namespace ArchiElite\EventsBooking\Http\Requests\Fronts;

use ArchiElite\EventsBooking\Facades\EventsBookingHelper;
use ArchiElite\EventsBooking\Models\Account;
use Botble\Base\Facades\BaseHelper;
use Botble\Base\Rules\EmailRule;
use Botble\Support\Http\Requests\Request;
use Illuminate\Validation\Rule;

class RegisterRequest extends Request
{
    public function rules(): array
    {
        $rules = [
            'name' => ['required', 'max:120', 'min:2'],
            'email' => [
                'nullable',
                Rule::requiredIf(! EventsBookingHelper::isLoginUsingPhone()),
                new EmailRule(),
                Rule::unique((new Account())->getTable()),
            ],
            'phone' => [
                'nullable',
                Rule::requiredIf(EventsBookingHelper::isLoginUsingPhone()),
                ...explode('|', BaseHelper::getPhoneValidationRule()),
                Rule::unique((new Account())->getTable(), 'phone'),
            ],
            'password' => ['required', 'min:6', 'confirmed'],
            'agree_terms_and_policy' => ['sometimes', 'accepted:1'],
        ];

        return apply_filters('events_booking_account_registration_form_validation_rules', $rules);
    }

    public function attributes(): array
    {
        return apply_filters('events_booking_account_registration_form_validation_attributes', [
            'name' => __('Name'),
            'email' => __('Email'),
            'password' => __('Password'),
            'agree_terms_and_policy' => __('Term and Policy'),
        ]);
    }

    public function messages(): array
    {
        return apply_filters('events_booking_account_registration_form_validation_messages', []);
    }
}
