<?php

namespace ArchiElite\EventsBooking\Listeners;

use ArchiElite\EventsBooking\Events\OrderCompleted;
use ArchiElite\EventsBooking\Facades\TicketHelper;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendTicketEmailListener implements ShouldQueue
{
    public function handle(OrderCompleted $event)
    {
        $order = $event->order;

        $order->loadMissing('tickets');

        TicketHelper::sendTicketsEmail($order);
    }
}
