<?php

namespace ArchiElite\EventsBooking\Listeners;

use ArchiElite\EventsBooking\Events\TicketResendMailEvent;
use ArchiElite\EventsBooking\Facades\TicketHelper;
use Illuminate\Contracts\Queue\ShouldQueue;

class TicketResendMailListener implements ShouldQueue
{
    public function handle(TicketResendMailEvent $event)
    {
        $order = $event->order;
        $ticket = $event->ticket;

        TicketHelper::sendTicketEmail($order, $ticket);
    }
}
