<?php

namespace ArchiElite\EventsBooking\Listeners;

use ArchiElite\EventsBooking\Enums\AccountStatusEnum;
use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use ArchiElite\EventsBooking\Events\OrderCompleted;
use ArchiElite\EventsBooking\Models\Account;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;

class UpdateAttendeesListener implements ShouldQueue
{
    public function handle(OrderCompleted $event): void
    {
        $order = $event->order;

        Log::info('UpdateAttendeesListener: ' . $order->id);

        $order->loadMissing(['tickets', 'event']);

        $event = $order->event;

        $tickets = $order->tickets;

        foreach ($tickets as $ticket) {
            $account = Account::query()->where('email', $ticket->email)->first();

            if (! $account) {
                $account = Account::query()->create([
                    'email' => $ticket->email,
                    'name' => $ticket->name,
                    'phone' => $ticket->phone,
                    'status' => AccountStatusEnum::ACTIVATED,
                    'type' => AccountTypeEnum::ATTENDEE,
                    'password' => Hash::make('password'),
                ]);
            }

            if ($event->attendees()
                ->where('attendee_id', $account->getKey())
                ->wherePivot('hash', $ticket->code)->exists()) {
                continue;
            }

            $event->attendees()->attach($account->getKey(), [
                'hash' => $ticket->code,
            ]);
        }
    }
}
