<?php

namespace ArchiElite\EventsBooking\Notifications;

use ArchiElite\EventsBooking\Models\Order;
use Botble\Base\Facades\EmailHandler;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class OrderCompletedNotification extends Notification implements ShouldQueue
{
    public function __construct(public Order $order)
    {
    }

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $emailHandler = EmailHandler::setModule('events-booking')
            ->setType('plugins')
            ->addTemplateSettings('order_completed', config('plugins.events-booking.email', []));

        return (new MailMessage())
            ->view(['html' => new HtmlString($emailHandler->getContent())])
            ->subject($emailHandler->getSubject());
    }
}
