<?php

namespace ArchiElite\EventsBooking\Tables;

use ArchiElite\EventsBooking\Models\Account;
use Botble\Table\Abstracts\TableAbstract;
use Botble\Table\Actions\DeleteAction;
use Botble\Table\Actions\EditAction;
use Botble\Table\BulkActions\DeleteBulkAction;
use Botble\Table\BulkChanges\CreatedAtBulkChange;
use Botble\Table\BulkChanges\NameBulkChange;
use Botble\Table\Columns\Column;
use Botble\Table\Columns\CreatedAtColumn;
use Botble\Table\Columns\EmailColumn;
use Botble\Table\Columns\EnumColumn;
use Botble\Table\Columns\IdColumn;
use Botble\Table\Columns\StatusColumn;
use Botble\Table\HeaderActions\CreateHeaderAction;
use Illuminate\Database\Eloquent\Builder;

class AccountTable extends TableAbstract
{
    public function setup(): void
    {
        $this
            ->model(Account::class)
            ->addHeaderAction(CreateHeaderAction::make()->route('events-booking.accounts.create'))
            ->addActions([
                EditAction::make()->route('events-booking.accounts.edit'),
                DeleteAction::make()->route('events-booking.accounts.destroy'),
            ])
            ->addColumns([
                IdColumn::make(),
                Column::make('name')
                    ->title(trans('core/base::tables.name')),
                EmailColumn::make(),
                Column::make('phone'),
                EnumColumn::make('type'),
                StatusColumn::make(),
                CreatedAtColumn::make(),
            ])
            ->addBulkActions([
                DeleteBulkAction::make()->permission('events-booking.accounts.destroy'),
            ])
            ->addBulkChanges([
                NameBulkChange::make(),
                CreatedAtBulkChange::make(),
            ])
            ->queryUsing(function (Builder $query) {
                $query->select([
                    'id',
                    'name',
                    'avatar',
                    'email',
                    'phone',
                    'type',
                    'status',
                    'created_at',
                ]);
            });
    }
}
