<?php

namespace ArchiElite\EventsBooking\Tables;

use ArchiElite\EventsBooking\Models\Tax;
use Botble\Table\Abstracts\TableAbstract;
use Botble\Table\Actions\DeleteAction;
use Botble\Table\Actions\EditAction;
use Botble\Table\BulkChanges\CreatedAtBulkChange;
use Botble\Table\Columns\Column;
use Botble\Table\Columns\CreatedAtColumn;
use Botble\Table\Columns\IdColumn;
use Botble\Table\Columns\NameColumn;
use Botble\Table\Columns\StatusColumn;
use Botble\Table\HeaderActions\CreateHeaderAction;
use Illuminate\Database\Eloquent\Builder;

class TaxTable extends TableAbstract
{
    public function setup(): void
    {
        $this
            ->model(Tax::class)
            ->addHeaderAction(CreateHeaderAction::make()->route('events-booking.taxes.create'))
            ->addActions([
                EditAction::make()->route('events-booking.taxes.edit'),
                DeleteAction::make()->route('events-booking.taxes.destroy'),
            ])
            ->addColumns([
                IdColumn::make(),
                NameColumn::make('title')->route('events-booking.taxes.edit'),
                Column::make('percentage')
                    ->title(trans('plugins/events-booking::tax.form.percentage')),
                Column::make('priority')
                    ->title(trans('plugins/events-booking::tax.form.priority')),
                StatusColumn::make(),
                CreatedAtColumn::make(),
            ])
            ->addBulkChanges([
                CreatedAtBulkChange::make(),
            ])
            ->queryUsing(function (Builder $query) {
                $query->select([
                    'id',
                    'title',
                    'percentage',
                    'priority',
                    'status',
                    'created_at',
                ]);
            });
    }
}
