<?php

namespace ArchiElite\EventsBooking\Widgets;

use ArchiElite\EventsBooking\Models\Order;
use ArchiElite\EventsBooking\Widgets\Traits\HasCategory;
use Botble\Base\Widgets\Chart;

class BookingChart extends Chart
{
    use HasCategory;

    protected int $columns = 6;

    public function getLabel(): string
    {
        return trans('plugins/events-booking::booking-reports.bookings_chart');
    }

    public function getOptions(): array
    {
        $data = Order::query()
            ->selectRaw('count(id) as total, date_format(created_at, "' . $this->dateFormat . '") as period')
            ->whereDate('created_at', '>=', $this->startDate)
            ->whereDate('created_at', '<=', $this->endDate)
            ->groupBy('period')
            ->pluck('total', 'period')
            ->all();

        return [
            'series' => [
                [
                    'name' => trans('plugins/events-booking::booking-reports.number_of_bookings'),
                    'data' => array_values($data),
                ],
            ],
            'xaxis' => [
                'categories' => $this->translateCategories($data),
            ],
        ];
    }
}
