<div
    class="shortcode-events memory1-section-area sp1"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="memory-header text-center heading5 space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5
                            data-aos="fade-left"
                            data-aos-duration="800"
                        >{!! BaseHelper::clean($subtitle) !!}</h5>
                        <div class="space16"></div>
                    @endif

                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif

                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="memory-slider-area owl-carousel">
                    @foreach ($events as $event)
                        <div class="memory-boxarea">
                            <div class="img1 image-anime">
                                {{ RvMedia::image($event->image, $event->name, 'medium-rectangle-vertical') }}
                            </div>
                            <div class="content-area">
                                @if ($logo = $shortcode->logo)
                                    {{ RvMedia::image($logo, 'logo', attributes: ['class' => 'logo1 keyframe5', 'width' => 16, 'height' => 16]) }}
                                @endif

                                <div class="arrow">
                                    <a aria-label="{{ $event->name }}" href="{{ $event->url }}"><x-core::icon name="ti ti-arrow-right"/></a>
                                </div>
                                <div class="space18"></div>
                                <p>{{ __('Event :year', ['year' => $event->started_at->format('Y')]) }}</p>
                                <div class="space12"></div>
                                <a aria-label="{{ $event->name }}" href="{{ $event->url }}">{{ $event->name }}</a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
