@php
    $style = [];
    $bgColor = theme_option('header_background_color', '#313131');
    $textColor = theme_option('header_text_color', '#ffffff');
    $isTransparent = theme_option('is_header_transparent', false) && Theme::get('isHomepage');

    if ($textColor) {
        $style["--header-text-color: $textColor"] = $textColor;
    }

    if ($bgColor !== 'transparent') {
        $style["--header-background-color: $bgColor"] = $bgColor;
    }
@endphp

{!! apply_filters('ads_render', null, 'header_before', ['class' => 'mb-2']) !!}

<header>
    @if (theme_option('display_header_top', false))
        {!! Theme::partial('header.header-top', ['headerWrapperClass' => 'home-main']) !!}
    @endif

    <div
        @class([
            'header-area homepage5 header header-sticky d-none d-lg-block',
            'no-transparent' => !$isTransparent,
        ])
        id="header"
        @style($style)
    >
        {!! Theme::partial('header.content') !!}
    </div>
</header>

{!! apply_filters('ads_render', null, 'header_after', ['class' => 'mt-2']) !!}

{!! Theme::partial('header.mobile') !!}
