@php
    $backgroundColor = theme_option('footer_background_color', '#FBF9F4');
    $backgroundImage = theme_option('footer_background_image');
    $backgroundImage = $backgroundImage ? RvMedia::getImageUrl($backgroundImage) : null;
    $textColor = theme_option('footer_text_color', theme_option('text_color', '#544E51'));
    $headingColor = theme_option('footer_heading_color', theme_option('primary_color', '#1A1719'));
@endphp

{!! dynamic_sidebar('pre_footer_sidebar') !!}

{!! apply_filters('ads_render', null, 'footer_before', ['class' => 'mb-2']) !!}

<div
    class="footer7-sertion-area footer-area"
    @style([
        "--footer-background-color: $backgroundColor" => $backgroundColor,
        "--footer-heading-color: $headingColor" => $headingColor,
        "--footer-text-color: $textColor" => $textColor,
        "--footer-background-image: url('$backgroundImage')" => $backgroundImage,
    ])
>
    {!! Theme::partial('footer.content') !!}
</div>

{!! apply_filters('ads_render', null, 'footer_after', ['class' => 'mt-2']) !!}
