<?php

use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Forms\AccountForm;
use ArchiElite\EventsBooking\Forms\EventForm;
use ArchiElite\EventsBooking\Forms\Fronts\Auth\FieldOptions\TextFieldOption;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Forms\FieldOptions\ButtonFieldOption;
use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\HtmlFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\RepeaterFieldOption;
use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\FieldOptions\TextareaFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\HtmlField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\RepeaterField;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextareaField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Blog\Forms\PostForm;
use Botble\Blog\Models\Post;
use Botble\Contact\Forms\Fronts\ContactForm;
use Botble\Media\Facades\RvMedia;
use Botble\Newsletter\Facades\Newsletter;
use Botble\Newsletter\Forms\Fronts\NewsletterForm;
use Botble\Page\Forms\PageForm;
use Botble\SimpleSlider\Forms\SimpleSliderItemForm;
use Botble\SimpleSlider\Http\Requests\SimpleSliderItemRequest;
use Botble\Theme\Facades\Theme;
use Botble\Theme\Supports\ThemeSupport;
use Botble\Theme\Typography\TypographyItem;
use Carbon\Carbon;
use Illuminate\Http\Request;

app()->booted(function (): void {
    register_page_template([
        'default' => __('Default'),
        'homepage' => __('Homepage'),
        'full-width' => __('Full width'),
    ]);

    register_sidebar([
        'id' => 'second_sidebar',
        'name' => 'Second sidebar',
        'description' => 'This is a sample sidebar for events-booking theme',
    ]);

    register_sidebar([
        'id' => 'footer_sidebar',
        'name' => __('Footer sidebar'),
        'description' => __('The widget for the sidebar display is located at the footer.'),
    ]);

    register_sidebar([
        'id' => 'header_sidebar',
        'name' => __('Header sidebar'),
        'description' => __('The widget for the header start sidebar is located at header sidebar.'),
    ]);

    register_sidebar([
        'id' => 'header_top_sidebar',
        'name' => __('Header top sidebar'),
        'description' => __('The widget for the header start sidebar is located at header top sidebar.'),
    ]);

    register_sidebar([
        'id' => 'pre_footer_sidebar',
        'name' => __('Pre footer sidebar'),
        'description' => __('The widget for the sidebar display is located at the pre of the footer.'),
    ]);

    register_sidebar([
        'id' => 'footer_sidebar',
        'name' => __('Footer sidebar'),
        'description' => __('The widget for the sidebar display is located at the footer.'),
    ]);

    register_sidebar([
        'id' => 'bottom_footer_sidebar',
        'name' => __('Bottom footer sidebar'),
        'description' => __('The widget for the sidebar display is located at the bottom of the footer.'),
    ]);

    register_sidebar([
        'id' => 'blog_sidebar',
        'name' => __('Blog sidebar'),
        'description' => __('The widget for the sidebar display is located at the side of the blog page.'),
    ]);

    register_sidebar([
        'id' => 'event_list_sidebar',
        'name' => __('Event list sidebar'),
        'description' => __('The widget is displayed where it is located at the page.'),
    ]);
    register_sidebar([
        'id' => 'off_canvas_sidebar',
        'name' => __('Off canvas sidebar'),
        'description' => __('Widget area that slides in when triggered by the sidebar button'),
    ]);

    RvMedia::addSize('small-rectangle', 390, 270)
        ->addSize('medium-rectangle-vertical', 500, 600)
        ->addSize('medium', 1200, 800);

    RvMedia::setUploadPathAndURLToPublic();

    if (is_plugin_active('newsletter')) {
        Newsletter::registerNewsletterPopup();

        NewsletterForm::extend(function (NewsletterForm $form) {
            return $form->formClass('newsletter-form');
        });
    }

    Theme::typography()
        ->registerFontFamilies([
            new TypographyItem('primary', __('Primary'), 'Urbanist'),
            new TypographyItem('heading', __('Heading'), 'Urbanist'),
        ])
        ->registerFontSizes([
            new TypographyItem('h1', __('Heading 1'), 64),
            new TypographyItem('h2', __('Heading 2'), 52),
            new TypographyItem('h3', __('Heading 3'), 44),
            new TypographyItem('h4', __('Heading 4'), 36),
            new TypographyItem('h5', __('Heading 5'), 28),
            new TypographyItem('h6', __('Heading 6'), 24),
            new TypographyItem('body', __('Body'), 14),
        ]);

    ThemeSupport::registerToastNotification();
    ThemeSupport::registerSiteLogoHeight(45);
    ThemeSupport::registerSocialLinks();
    ThemeSupport::registerPreloader();

    add_filter('theme_preloader_versions', function (): array {
        return [
            'v2' => __('Default'),
        ];
    }, 128);

    add_filter('theme_preloader', function (string $preloader): string {
        if (theme_option('preloader_version', 'v2') === 'v2') {
            return Theme::partial('preloader');
        }

        return $preloader;
    }, 128);

    add_filter('widget_menu_admin_config', function (array $fields) {
        return [
            'fields' => [
                ...$fields['fields'],
                [
                    'type' => 'coreIcon',
                    'label' => __('Icon'),
                    'required' => true,
                    'attributes' => [
                        'name' => 'icon',
                        'value' => null,
                        'options' => [
                            'class' => 'form-control',
                        ],
                    ],
                ],
            ],
        ];
    }, 2, 120);

    PageForm::extend(function (PageForm $form) {
        $form
            ->addAfter(
                'image',
                'breadcrumb_text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->metadata()
                    ->label(__('Breadcrumb text color'))
            )
            ->addAfter(
                'breadcrumb_text_color',
                'breadcrumb_background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->metadata()
                    ->label(__('Breadcrumb background image'))
            );
    });

    if (is_plugin_active('contact')) {
        ContactForm::extend(function (ContactForm $form) {
            return $form
                ->remove([
                    'submit',
                ])->setFormInputWrapperClass('input-area')
                ->setFormInputClass('eventify-input-class')
                ->add(
                    'open_custom_submit_field_wrapper',
                    HtmlField::class,
                    HtmlFieldOption::make()
                        ->content('<div class="input-area text-end">')
                )

                ->add(
                    'submit',
                    'submit',
                    ButtonFieldOption::make()
                        ->cssClass('vl-btn1')
                        ->label(__('Submit now'))
                )
                ->add(
                    'close_custom_submit_field_wrapper',
                    HtmlField::class,
                    HtmlFieldOption::make()->content('</div>')
                );
        });
    }

    if (is_plugin_active('events-booking')) {
        AccountForm::extend(function (AccountForm $form) {
            return $form
                ->addAfter(
                    'dob',
                    'title',
                    TextField::class,
                    TextFieldOption::make()
                        ->metadata()
                        ->colspan(2)
                        ->label(__('Title'))
                )
                ->addAfter(
                    'title',
                    'description',
                    TextareaField::class,
                    TextareaFieldOption::make()
                        ->metadata()
                        ->label(__('Description'))
                        ->colspan(2)
                )
                ->addAfter(
                    'description',
                    'address',
                    TextareaField::class,
                    TextareaFieldOption::make()
                        ->metadata()
                        ->label(__('Address'))
                        ->colspan(2)
                )
                ->addAfter(
                    'description',
                    'socials',
                    RepeaterField::class,
                    RepeaterFieldOption::make()
                        ->metadata()
                        ->label(__('Socials'))
                        ->colspan(2)
                        ->fields(ThemeSupport::getSocialLinksRepeaterFields())
                );
        });

        EventForm::extend(function (EventForm $form) {
            $form->addAfter(
                'tax_id',
                'cover_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->metadata()
                    ->label(__('Cover image'))
            );
        });
    }

    if (is_plugin_active('simple-slider')) {
        add_filter('core_request_rules', function (array $rules, Request $request) {
            if ($request instanceof SimpleSliderItemRequest) {
                return array_merge($rules, [
                    'subtitle' => ['nullable', 'string', 'max:255'],
                    'button_label' => ['nullable', 'string', 'max:255'],
                ]);
            }

            return $rules;
        }, 120, 2);

        SimpleSliderItemForm::extend(function (SimpleSliderItemForm $form) {
            if (is_plugin_active('events-booking')) {
                $events = Event::query()
                    ->where('status', EventStatusEnum::APPROVED)
                    ->where('started_at', '>=', Carbon::now())
                    ->pluck('name', 'id')
                    ->toArray();
            }

            return $form
                ->addAfter(
                    'title',
                    'highlight_title',
                    TextField::class,
                    TextFieldOption::make()
                        ->metadata()
                        ->label(__('Highlight title'))
                        ->toArray()
                )
                ->addAfter(
                    'highlight_title',
                    'subtitle',
                    TextField::class,
                    TextFieldOption::make()
                        ->metadata()
                        ->label(__('Subtitle'))
                        ->toArray()
                )
                ->when(is_plugin_active('events-booking'), function (SimpleSliderItemForm $form) use ($events) {
                    $form->addAfter(
                        'highlight_title',
                        'event_id',
                        SelectField::class,
                        SelectFieldOption::make()
                            ->searchable()
                            ->metadata()
                            ->choices($events)
                            ->label(__('Choose Event'))
                    );
                })
                ->addAfter(
                    'link',
                    'button_label',
                    TextField::class,
                    TextFieldOption::make()
                        ->metadata()
                        ->label(__('Button label'))
                        ->toArray()
                );
        });
    }

    if (is_plugin_active('blog')) {
        PostForm::extend(function (PostForm $form) {
            $form->addAfter(
                'tag',
                'cover_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->metadata()
                    ->label(__('Cover image'))
            );
        });
    }

    add_filter('ads_locations', function (array $locations) {
        return [
            ...$locations,
            'footer_before' => __('Footer (before)'),
            'footer_after' => __('Footer (after)'),
            'post_list_before' => __('Post List (before)'),
            'post_list_after' => __('Post List (after)'),
            'post_before' => __('Post Detail (before)'),
            'post_after' => __('Post Detail (after)'),
            'event_list_before' => __('Event List (before)'),
            'event_list_after' => __('Event List (after)'),
            'event_before' => __('Event Detail (before)'),
            'event_after' => __('Event Detail (after)'),
            'speaker_before' => __('Speaker Detail (before)'),
            'speaker_after' => __('Speaker Detail (after)'),
        ];
    }, 128);

    add_filter('get_home_search_type', function () {
        $typeSearch = theme_option('home_search_type', 'events');

        switch ($typeSearch) {
            case 'posts':
                return Post::class;
            default:
                return Event::class;
        }
    }, 129);
});
