<?php

use ArchiElite\EventsBooking\Enums\AccountStatusEnum;
use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Models\Account;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\DescriptionFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\NumberFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\FieldOptions\UiSelectorFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\NumberField;
use Botble\Base\Forms\Fields\TextareaField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Base\Forms\Fields\UiSelectorField;
use Botble\Shortcode\Compilers\Shortcode as ShortcodeCompiler;
use Botble\Shortcode\Facades\Shortcode;
use Botble\Shortcode\Forms\FieldOptions\ShortcodeTabsFieldOption;
use Botble\Shortcode\Forms\Fields\ShortcodeTabsField;
use Botble\Shortcode\Forms\ShortcodeForm;
use Botble\Theme\Facades\Theme;
use Carbon\Carbon;
use Illuminate\Support\Arr;

if (! is_plugin_active('events-booking')) {
    return;
}

app()->booted(function () {
    Shortcode::register(
        'hero-banner',
        __('Hero Banner'),
        __('Add a hero banner'),
        function (ShortcodeCompiler $shortcode) {
            $event = Event::query()
                ->where('is_featured', true)
                ->where('status', EventStatusEnum::APPROVED)
                ->where('started_at', '>=', Carbon::now())
                ->latest()
                ->first();

            return Theme::partial('shortcodes.hero-banner.index', compact('shortcode', 'event'));
        }
    );

    Shortcode::setAdminConfig('hero-banner', function ($attributes) {
        $form = ShortcodeForm::createFromArray($attributes);

        return $form
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices([
                        1 => [
                            'label' => __('Style :number', ['number' => 1]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-1.jpeg'),
                        ],
                        2 => [
                            'label' => __('Style :number', ['number' => 2]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-2.jpeg'),
                        ],
                        3 => [
                            'label' => __('Style :number', ['number' => 3]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-3.png'),
                        ],
                        4 => [
                            'label' => __('Style :number', ['number' => 4]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-4.jpeg'),
                        ],
                        5 => [
                            'label' => __('Style :number', ['number' => 5]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-5.png'),
                        ],
                        6 => [
                            'label' => __('Style :number', ['number' => 6]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-6.png'),
                        ],
                        7 => [
                            'label' => __('Style :number', ['number' => 7]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-7.png'),
                        ],
                        8 => [
                            'label' => __('Style :number', ['number' => 8]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-8.png'),
                        ],
                        9 => [
                            'label' => __('Style :number', ['number' => 9]),
                            'image' => Theme::asset()->url('images/shortcodes/hero-banner/style-9.png'),
                        ],
                    ])
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'highlight',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [4], $attributes['style'] ?? 1)
                    ->label(__('Highlight'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 4, 5, 7, 8], $attributes['style'] ?? 1)
                    ->label(__('Subtitle'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [3, 5, 7, 8], $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add(
                'description',
                TextareaField::class,
                DescriptionFieldOption::make()
                    ->collapsible('style', [1, 3, 6], $attributes['style'] ?? 1)
                    ->label(__('Description'))
            )
            ->add(
                'circle_text',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [2, 4, 5, 6, 7], $attributes['style'] ?? 1)
                    ->label(__('Circle text'))
            )
            ->add(
                'image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [1, 3, 4, 5, 6, 8], $attributes['style'] ?? 1)
                    ->label(__('Image'))
            )
            ->add(
                'image_1',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [4, 6], $attributes['style'] ?? 1)
                    ->label(__('Image :number', ['number' => 1]))
            )
            ->add(
                'button_primary_label',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 5, 7, 8], $attributes['style'] ?? 1)
                    ->label(__('Button primary label'))
            )
            ->add(
                'button_primary_url',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 5, 6, 7, 8], $attributes['style'] ?? 1)
                    ->label(__('Button primary URL'))
            )
            ->add(
                'button_secondary_label',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 8], $attributes['style'] ?? 1)
                    ->label(__('Button secondary label'))
            )
            ->add(
                'button_secondary_url',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 6, 8], $attributes['style'] ?? 1)
                    ->label(__('Button secondary URL'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [1, 2, 5, 6, 7, 8], $attributes['style'] ?? 1)
                    ->label(__('Background image'))
            )
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->max(3)
                    ->fields([
                        'title' => [
                            'title' => __('Title'),
                        ],
                        'description' => [
                            'title' => __('Description'),
                            'type' => 'textarea',
                        ],
                        'image' => [
                            'title' => __('Image'),
                            'type' => 'image',
                        ],
                    ])
            );
    });

    Shortcode::register(
        'events-schedule',
        __('Events Schedule'),
        __('Add a event schedules'),
        function (ShortcodeCompiler $shortcode) {
            $numberDays = (int) $shortcode->number_days ?: 5;
            $numberEachDays = $shortcode->number_each_days ?: 4;
            $tabs = [];

            for ($i = 0; $i < $numberDays; $i++) {
                $currentDate = Carbon::now()->addDays($i);

                $tabs[] = [
                    'date' => $currentDate->format('Y-m-d'),
                    'month' => $currentDate->format('M'),
                    'day' => $currentDate->format('d'),
                    'year' => $currentDate->format('Y'),
                    'events' => in_array($shortcode->style, [2, 3, 4, 5]) ? Event::query()
                        ->where('status', EventStatusEnum::APPROVED)
                        ->whereDate('started_at', $currentDate)
                        ->orderBy('started_at')
                        ->limit($numberEachDays)
                        ->get() : [],
                ];
            }

            $events = Event::query()
                ->where('status', EventStatusEnum::APPROVED)
                ->whereBetween('started_at', [
                    Carbon::now()->format('Y-m-d'),
                    Carbon::now()->addDays((int) $numberDays),
                ])
                ->get();

            return Theme::partial('shortcodes.events-schedule.index', compact('shortcode', 'tabs', 'events'));
        }
    );

    Shortcode::setAdminConfig('events-schedule', function ($attributes) {
        $form = ShortcodeForm::createFromArray($attributes);

        return $form
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 6))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/events-schedule/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', '1'))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 5], $attributes['style'] ?? 1)
                    ->label(__('Subtitle'))
            )
            ->add(
                'number_days',
                NumberField::class,
                NumberFieldOption::make()
                    ->defaultValue(5)
                    ->label(__('Number of days'))
            )
            ->add(
                'number_each_days',
                NumberField::class,
                NumberFieldOption::make()
                    ->defaultValue(4)
                    ->collapsible('style', [3, 4, 5], $attributes['style'] ?? 1)
                    ->label(__('Number event of each day'))
            )
            ->add(
                'button_label',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', 3, $attributes['style'] ?? 1)
                    ->label(__('Button label'))
            )
            ->add(
                'button_url',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', 3, $attributes['style'] ?? 1)
                    ->label(__('Button URL'))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [1, 2, 3], $attributes['style'] ?? 1)
                    ->label(__('Image'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register(
        'events',
        __('Events'),
        __('Add a events'),
        function (ShortcodeCompiler $shortcode) {
            $events = Event::query()
                ->where('status', EventStatusEnum::APPROVED)
                ->where('started_at', '>=', Carbon::now())
                ->limit($shortcode->limit ?: 5)
                ->get();

            return Theme::partial('shortcodes.events.index', compact('shortcode', 'events'));
        }
    );

    Shortcode::setAdminConfig('events', function ($attributes) {
        $form = ShortcodeForm::createFromArray($attributes);

        return $form
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 5))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/events/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [3, 5], $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Subtitle'))
            )
            ->add(
                'logo',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Logo'))
                    ->collapsible('style', 1, $attributes['style'] ?? 1)
            )
            ->add(
                'limit',
                NumberField::class,
                NumberFieldOption::make()
                    ->defaultValue(5)
                    ->label(__('Limit'))
            )
            ->add(
                'redirect_url',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Redirect url'))
                    ->collapsible('style', 2, $attributes['style'] ?? 1)
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register(
        'speakers',
        __('Speakers'),
        __('Add a speakers'),
        function (ShortcodeCompiler $shortcode) {
            $speakers = Account::query()
                ->where('status', AccountStatusEnum::ACTIVATED)
                ->where('type', AccountTypeEnum::SPEAKER)
                ->limit($shortcode->limit ?: 8)
                ->get();

            if ($speakers->isEmpty()) {
                return null;
            }

            return Theme::partial('shortcodes.speakers.index', compact('shortcode', 'speakers'));
        }
    );

    Shortcode::setAdminConfig('speakers', function ($attributes) {
        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 9))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/speakers/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 4, 5, 6, 8], $attributes['style'] ?? 1)
                    ->label(__('Subtitle'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [4, 6], $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add(
                'limit',
                NumberField::class,
                NumberFieldOption::make()
                    ->defaultValue(8)
                    ->label(__('Limit'))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });
});
