<?php

use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Forms\FieldOptions\ButtonFieldOption;
use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\DescriptionFieldOption;
use Botble\Base\Forms\FieldOptions\HtmlFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\MultiChecklistFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\FieldOptions\UiSelectorFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\DatetimeField;
use Botble\Base\Forms\Fields\HtmlField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\MultiCheckListField;
use Botble\Base\Forms\Fields\TextareaField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Base\Forms\Fields\UiSelectorField;
use Botble\Contact\Forms\Fronts\ContactForm;
use Botble\Faq\Models\Faq;
use Botble\Faq\Models\FaqCategory;
use Botble\Faq\Repositories\Interfaces\FaqCategoryInterface;
use Botble\Shortcode\Compilers\Shortcode as ShortcodeCompiler;
use Botble\Shortcode\Facades\Shortcode;
use Botble\Shortcode\Forms\FieldOptions\ShortcodeTabsFieldOption;
use Botble\Shortcode\Forms\Fields\ShortcodeTabsField;
use Botble\Shortcode\Forms\ShortcodeForm;
use Botble\Theme\Facades\Theme;
use Botble\Theme\Supports\ThemeSupport;
use Carbon\Carbon;
use Illuminate\Support\Arr;

app()->booted(function () {
    ThemeSupport::registerGoogleMapsShortcode();
    ThemeSupport::registerYoutubeShortcode();

    Shortcode::register('pricing', __('Pricing'), __('Pricing'), function (ShortcodeCompiler $shortcode): ?string {
        $tabs = Shortcode::fields()->getTabsData(['name', 'description', 'price', 'unit', 'max_point', 'point', 'is_featured', 'features', 'button_label', 'button_url', 'background_color'], $shortcode);

        foreach ($tabs as $key => $item) {
            if ($features = Arr::get($item, 'features')) {
                $tabs[$key]['features'] = collect(explode(PHP_EOL, $features))
                    ->map(function ($feature) {
                        return [
                            'value' => trim($feature, '+- '),
                            'is_available' => str_starts_with($feature, '+') || str_starts_with($feature, ' +'),
                        ];
                    })->toArray();
            }
        }

        if (!$tabs) {
            return null;
        }

        return Theme::partial('shortcodes.pricing.index', compact('shortcode', 'tabs'));
    });

    Shortcode::setAdminConfig('pricing', function (array $attributes) {

        $quantity = Arr::get($attributes, 'quantity');

        foreach (range(0, $quantity) as $i) {
            if (Arr::get($attributes, "features_$i")) {
                $attributes["features_$i"] = str_replace(['-', '+'], [PHP_EOL . '-', PHP_EOL . '+'], Arr::get($attributes, "features_$i"));
            }
        }

        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 4))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/pricing/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', 3, $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add('subtitle', TextField::class, TextFieldOption::make()->label(__('Subtitle')))
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->fields([
                        'name' => [
                            'title' => __('Name'),
                        ],
                        'description' => [
                            'title' => __('Description (Only style 3, 4)'),
                            'type' => 'textarea',
                        ],
                        'price' => [
                            'title' => __('Price'),
                        ],
                        'unit' => [
                            'title' => __('Unit'),
                        ],
                        'max_point' => [
                            'title' => __('Max point (Only style 2)'),
                        ],
                        'point' => [
                            'title' => __('Current point (Only style 2)'),
                        ],
                        'is_featured' => [
                            'title' => __('Is featured (Only style 2, 4)'),
                            'type' => 'checkbox',
                        ],
                        'features' => [
                            'title' => __('Features'),
                            'type' => 'textarea',
                            'placeholder' => __('Separate by new line (+ is included, - is not included)'),
                        ],
                        'button_label' => [
                            'title' => __('Button Label'),
                        ],
                        'button_url' => [
                            'title' => __('Button URL'),
                        ],
                        'background_color' => [
                            'title' => __('Background color (Only style 3)'),
                            'type' => 'color',
                        ],
                    ])
            )
            ->add(
                'background_image_name',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', 1, $attributes['style'] ?? 1)
                    ->label(__('Background image name'))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register(
        'about-us-information',
        __('About Us Information'),
        __('Add a about information'),
        function (ShortcodeCompiler $shortcode) {
            $tabs = Shortcode::fields()->getTabsData(['title', 'figure', 'icon', 'url', 'description', 'icon_image'], $shortcode);
            $event = Event::query()
                ->where('is_featured', true)
                ->where('status', EventStatusEnum::APPROVED)
                ->where('started_at', '>=', Carbon::now())
                ->latest()
                ->first();

            return Theme::partial('shortcodes.about-us-information.index', compact('shortcode', 'tabs', 'event'));
        }
    );

    Shortcode::setAdminConfig('about-us-information', function ($attributes) {
        $form = ShortcodeForm::createFromArray($attributes);

        return $form
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 7))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/about-us-information/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 4, 5, 6], $attributes['style'] ?? 1)
                    ->label(__('Subtitle'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [6], $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add(
                'circle_text',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [7], $attributes['style'] ?? 1)
                    ->label(__('Circle text'))
            )
            ->add(
                'description',
                TextareaField::class,
                DescriptionFieldOption::make()
            )
            ->add(
                'floating_button_label',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 3], $attributes['style'] ?? 1)
                    ->label(__('Floating button label'))
            )
            ->add(
                'floating_button_url',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 3], $attributes['style'] ?? 1)
                    ->label(__('Floating button URL'))
            )
            ->add(
                'button_label',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Button label'))
            )
            ->add(
                'button_url',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Button URL'))
            )
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 4, 5, 7], $attributes['style'] ?? 1)
                    ->attrs($attributes)
                    ->max(3)
                    ->fields([
                        'title' => [
                            'title' => __('Title'),
                        ],
                        'description' => [
                            'title' => __('Description'),
                            'type' => 'textarea',
                        ],
                        'figure' => [
                            'title' => __('Figure'),
                            'type' => 'number',
                        ],
                        'url' => [
                            'title' => __('URL'),
                        ],
                        'icon' => [
                            'title' => __('Icon'),
                            'type' => 'icon',
                        ],
                        'icon_image' => [
                            'title' => __('Icon Image'),
                            'type' => 'image',
                        ],
                    ])
            )->add(
                'image',
                MediaImageField::class,
                MediaImageFieldOption::make()
            )->add(
                'image_1',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Image :number', ['number' => 1]))
            )->add(
                'image_2',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [1, 2, 3, 4, 5, 6], $attributes['style'] ?? 1)
                    ->label(__('Image :number', ['number' => 2]))
            )
            ->add(
                'image_3',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [4], $attributes['style'] ?? 1)
                    ->label(__('Image :number', ['number' => 3]))
            )
            ->add(
                'shape_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [7], $attributes['style'] ?? 1)
                    ->label(__('Shape image'))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register(
        'brands',
        __('Brands'),
        __('Add a brands'),
        function (ShortcodeCompiler $shortcode) {
            return Theme::partial('shortcodes.brands.index', compact('shortcode'));
        }
    );

    Shortcode::setAdminConfig('brands', function ($attributes) {
        $form = ShortcodeForm::createFromArray($attributes);

        return $form
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 2))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/brands/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', 2, $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', 2, $attributes['style'] ?? 1)
                    ->label(__('Sub Title'))
            )->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->fields([
                        'alt' => [
                            'title' => __('Alt'),
                        ],
                        'image' => [
                            'title' => __('Image'),
                            'type' => 'image',
                            'required' => true,
                        ],
                        'link' => [
                            'title' => __('Link to brand'),
                            'required' => true,
                        ],
                    ])
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register(
        'featured-block',
        __('Featured block'),
        __('Add a featured block'),
        function (ShortcodeCompiler $shortcode) {
            $tabs = Shortcode::fields()->getTabsData(['title', 'description', 'url', 'icon_image'], $shortcode);

            return
                Theme::partial('shortcodes.featured-block.index', compact('shortcode', 'tabs'));
        }
    );

    Shortcode::setAdminConfig('featured-block', function ($attributes) {
        $form = ShortcodeForm::createFromArray($attributes);

        return $form
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 3))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/featured-block/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [2], $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Subtitle'))
            )->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->fields([
                        'title' => [
                            'title' => __('Title'),
                        ],
                        'description' => [
                            'title' => __('Description'),
                            'type' => 'textarea',
                        ],
                        'url' => [
                            'title' => __('URL'),
                        ],
                        'icon_image' => [
                            'title' => __('Image'),
                            'type' => 'image',
                        ],
                    ])
            );
    });

    Shortcode::register(
        'contact-information',
        __('Contact information'),
        __('Add a contact information'),
        function (ShortcodeCompiler $shortcode) {
            $form = null;
            if (in_array($shortcode->style, [3])) {
                $form = ContactForm::createFromArray(
                    Arr::except($shortcode->toArray(), ['name', 'email', 'phone', 'content', 'subject', 'address'])
                );

                $form
                    ->remove([
                        'submit',
                    ])->setFormInputWrapperClass('input-area')
                    ->setFormInputClass('eventify-input-class')
                    ->add(
                        'open_second_custom_submit_field_wrapper',
                        HtmlField::class,
                        HtmlFieldOption::make()
                            ->content('<div class="input-area">')
                    )
                    ->add(
                        'submit',
                        'submit',
                        ButtonFieldOption::make()
                            ->cssClass('vl-btn4')
                            ->label(__('Send'))
                    )
                    ->add(
                        'close_second_custom_submit_field_wrapper',
                        HtmlField::class,
                        HtmlFieldOption::make()->content('</div>')
                    );
            }

            return Theme::partial('shortcodes.contact.contact-information.index', compact('shortcode', 'form'));
        }
    );

    Shortcode::setPreviewImage('contact-information', Theme::asset()->url('images/ui-blocks/contact-information.png'));

    Shortcode::setAdminConfig('contact-information', function ($attributes) {

        $fields = [
            'phone' => trans('plugins/contact::contact.sender_phone'),
            'email' => trans('plugins/contact::contact.form_email'),
            'subject' => trans('plugins/contact::contact.form_subject'),
            'address' => trans('plugins/contact::contact.form_address'),
        ];

        return ShortcodeForm::createFromArray($attributes)
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->choices(collect(range(1, 5))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/contact-information/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->toArray()
            )
            ->add(
                'address',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Address on Google Map'))
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3], $attributes['style'] ?? 1)
                    ->label(__('Title'))
            )
            ->add(
                'description',
                TextareaField::class,
                DescriptionFieldOption::make()
                    ->collapsible('style', [3], $attributes['style'] ?? 1)
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2, 3], $attributes['style'] ?? 1)
                    ->label(__('Subtitle'))
            )
            ->add(
                'image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [1, 3], $attributes['style'] ?? 1)
            )
            ->add(
                'image_2',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [3], $attributes['style'] ?? 1)
                    ->label(__('Image :number', ['number' => 1]))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            )
            ->add(
                'icon_bg_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [1, 2, 3], $attributes['style'] ?? 1)
                    ->label(__('Icon background image'))
            )
            ->add(
                'contact_method',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->label(__('Contact method'))
                    ->attrs($attributes)
                    ->max(4)
                    ->fields([
                        'title' => [
                            'title' => __('Title'),
                        ],
                        'description' => [
                            'type' => 'textarea',
                            'title' => __('Description'),
                        ],
                        'url' => [
                            'title' => __('URL'),
                        ],
                        'icon_image' => [
                            'type' => 'image',
                            'title' => __('Icon Image'),
                        ],
                    ])
                    ->toArray()
            )
            ->add(
                'display_fields',
                MultiCheckListField::class,
                MultiChecklistFieldOption::make()
                    ->collapsible('style', [3], $attributes['style'] ?? 1)
                    ->label(trans('plugins/contact::contact.display_fields'))
                    ->choices($fields)
                    ->defaultValue(array_keys($fields))
            )
            ->add(
                'mandatory_fields',
                MultiCheckListField::class,
                MultiChecklistFieldOption::make()
                    ->collapsible('style', [3], $attributes['style'] ?? 1)
                    ->label(trans('plugins/contact::contact.mandatory_fields'))
                    ->helperText(trans('plugins/contact::contact.mandatory_fields_helper_text'))
                    ->choices($fields)
                    ->defaultValue(['email'])
            );
    });

    Shortcode::register(
        'faq',
        __('FAQs'),
        __('Add FAQs'),
        function (ShortcodeCompiler $shortcode) {
            $allFaqArray = $data = [];
            if (is_plugin_active('faq')) {
                $faqs = app(Faq::class)->query()->select('id', 'question', 'answer', 'category_id')->get()->toArray();
                $faqCategories = app(FaqCategoryInterface::class)->pluck('name', 'id');
                $tabs = Shortcode::fields()->getTabsData(['category_id'], $shortcode);

                if (count($faqs) !== 0) {
                    $allFaqArray = array_chunk($faqs, ceil(count($faqs) / 2));
                    $data['All']['start'] = isset($allFaqArray[0]) ? $allFaqArray[0] : [];
                    $data['All']['end'] = isset($allFaqArray[1]) ? $allFaqArray[1] : [];
                    $data['All']['id'] = 'all';

                    foreach ($tabs as $category) {
                        $categoryId = Arr::get($category, 'category_id');
                        $categoryName = $faqCategories[$categoryId];
                        $categoryFilterData = array_filter($faqs, function ($item) use ($categoryId) {
                            return isset($item['category_id']) && $item['category_id'] == $categoryId;
                        });

                        if (count($categoryFilterData) == 0) {
                            continue;
                        }
                        $faqArray = array_chunk($categoryFilterData, ceil(count($categoryFilterData) / 2));
                        $data[$categoryName]['start'] = isset($faqArray[0]) ? $faqArray[0] : [];
                        $data[$categoryName]['end'] = isset($faqArray[1]) ? $faqArray[1] : [];
                        $data[$categoryName]['id'] = $categoryId;
                    }
                }
            }

            return Theme::partial('shortcodes.faq.index', compact('shortcode', 'data'));
        }
    );

    Shortcode::setAdminConfig('faq', function ($attributes) {
        $faqCategories = app(FaqCategory::class)->wherePublished()->pluck('name', 'id')->all();

        return ShortcodeForm::createFromArray($attributes)
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
                    ->toArray()
            )
            ->add(
                'categories',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->label('Categories')
                    ->attrs($attributes)
                    ->max(4)
                    ->fields([
                        'category_id' => [
                            'title' => __('FAQs categories'),
                            'type' => 'select',
                            'options' => ['' => __('-- Choose a category --')] + $faqCategories,
                            'required' => true,
                        ],
                    ])
                    ->toArray()
            );
    });

    Shortcode::register('content-images', __('Content Images'), __('Content Images'), function (ShortcodeCompiler $shortcode): ?string {
        $tabs = Shortcode::fields()->getTabsData(['image'], $shortcode);

        if (!$tabs) {
            return null;
        }

        return Theme::partial('shortcodes.content-images.index', compact('shortcode', 'tabs'));
    });

    Shortcode::setAdminConfig('content-images', function (array $attributes) {
        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->max(4)
                    ->fields([
                        'image' => [
                            'title' => __('Content'),
                            'type' => 'image',
                        ],
                    ])
            );
    });

    Shortcode::register('countdown', __('Countdown'), __('Countdown'), function (ShortcodeCompiler $shortcode): ?string {
        return Theme::partial('shortcodes.countdown.index', compact('shortcode'));
    });

    Shortcode::setAdminConfig('countdown', function (array $attributes) {
        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add(
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->choices(collect(range(1, 3))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/countdown/style-$i.png"),
                            ],
                        ];
                    })->all())
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->toArray()
            )
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add('subtitle', TextField::class, TextFieldOption::make()->label(__('Subtitle')))
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->collapsible('style', [1], $attributes['style'] ?? 1)
                    ->label(__('Subtitle image'))
            )
            ->add('start_date', DatetimeField::class)
            ->add(
                'primary_button_label',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1], $attributes['style'] ?? 1)
                    ->label(__('Primary button label'))
            )
            ->add(
                'primary_button_url',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1], $attributes['style'] ?? 1)
                    ->label(__('Primary button URL'))
            )
            ->add(
                'secondary_button_label',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1], $attributes['style'] ?? 1)
                    ->label(__('Secondary button label'))
            )
            ->add(
                'secondary_button_url',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1], $attributes['style'] ?? 1)
                    ->label(__('Secondary button URL'))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register('marquees', __('Marquees'), __('Marquees'), function (ShortcodeCompiler $shortcode): ?string {
        $tabs = Shortcode::fields()->getTabsData(['name'], $shortcode);

        if (!$tabs) {
            return null;
        }

        return Theme::partial('shortcodes.marquees.index', compact('shortcode', 'tabs'));
    });

    Shortcode::setAdminConfig('marquees', function (array $attributes) {
        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->fields([
                        'name' => [
                            'title' => __('Name'),
                            'type' => 'text',
                        ],
                    ])
            )
            ->add(
                'separator_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Separator image'))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register('tabs-content', __('Tabs Content'), __('Tabs Content'), function (ShortcodeCompiler $shortcode): ?string {
        $tabs = Shortcode::fields()->getTabsData(['title', 'description', 'image', 'image_1', 'image_2', 'image_3'], $shortcode);

        if (!$tabs) {
            return null;
        }

        return Theme::partial('shortcodes.tabs-content.index', compact('shortcode', 'tabs'));
    });

    Shortcode::setAdminConfig('tabs-content', function (array $attributes) {
        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Subtitle'))
            )
            ->add(
                'subtitle_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Subtitle image'))
            )
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->fields([
                        'title' => [
                            'title' => __('Title'),
                            'type' => 'text',
                        ],
                        'description' => [
                            'title' => __('Description'),
                            'type' => 'textarea',
                        ],
                        'image' => [
                            'title' => __('Image'),
                            'type' => 'image',
                        ],
                        'image_1' => [
                            'title' => __('Image :number', ['number' => 1]),
                            'type' => 'image',
                        ],
                        'image_2' => [
                            'title' => __('Image :number', ['number' => 2]),
                            'type' => 'image',
                        ],
                        'image_3' => [
                            'title' => __('Image :number', ['number' => 3]),
                            'type' => 'image',
                        ],
                    ])
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register('site-statistics', __('Site Statistics'), __('Site Statistics'), function (ShortcodeCompiler $shortcode): ?string {
        $tabs = Shortcode::fields()->getTabsData(['title', 'data', 'unit'], $shortcode);

        if (!$tabs) {
            return null;
        }

        return Theme::partial('shortcodes.site-statistics.index', compact('shortcode', 'tabs'));
    });

    Shortcode::setAdminConfig('site-statistics', function (array $attributes) {
        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->fields([
                        'title' => [
                            'title' => __('Title'),
                        ],
                        'data' => [
                            'title' => __('Data'),
                        ],
                        'unit' => [
                            'title' => __('Unit'),
                        ],
                    ])
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });

    Shortcode::register('locations', __('Location'), __('Location'), function (ShortcodeCompiler $shortcode): ?string {
        $tabs = Shortcode::fields()->getTabsData(['name', 'subtitle', 'image', 'address', 'button_label', 'button_url'], $shortcode);

        if (!$tabs) {
            return null;
        }

        return Theme::partial('shortcodes.locations.index', compact('shortcode', 'tabs'));
    });

    Shortcode::setAdminConfig('locations', function (array $attributes) {
        return ShortcodeForm::createFromArray($attributes)
            ->withLazyLoading()
            ->add('title', TextField::class, TextFieldOption::make()->label(__('Title')))
            ->add(
                'tabs',
                ShortcodeTabsField::class,
                ShortcodeTabsFieldOption::make()
                    ->attrs($attributes)
                    ->fields([
                        'name' => [
                            'title' => __('Name'),
                        ],
                        'subtitle' => [
                            'title' => __('Subtitle'),
                        ],
                        'address' => [
                            'title' => __('Address'),
                        ],
                        'image' => [
                            'title' => __('Image'),
                            'type' => 'image',
                        ],
                        'button_label' => [
                            'title' => __('Button Label'),
                        ],
                        'button_url' => [
                            'title' => __('Button URL'),
                        ],
                    ])
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->defaultValue('#000000')
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->defaultValue('#FFF3F6')
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );
    });
});
